/*------------------------------------------------------------------------------*
 * File Name: palette_utils.h													*
 * Creation: 2007-1-26															*
 * Purpose: Declare palette utility functions									*
 * Copyright (c) OriginLab Corp. 2007											*
 * All Rights Reserved															*
  *------------------------------------------------------------------------------*/

#ifndef _PALETTE_UTILS_H
#define _PALETTE_UTILS_H


enum{
	SPRD_R2B = 0,
	SPRD_B2R,
	SPRD_RED, 
	SPRD_GREEN,
	SPRD_BLUE, 
};




#define GetRValue(rgb)      ((BYTE)(rgb))
#define GetGValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((BYTE)((rgb)>>16))
#define MergeRGB(r, g, b)   (DWORD)((BYTE)r+(((WORD)g)<<8)+(((DWORD)b)<<16))    

bool save_palette_to_file(string strFile, Worksheet& wks, int nRCol, int nGCol, int nBCol);

bool read_palette_from_file(string strFile, vector& vr, vector& vg, vector& vb);


#endif // _PALETTE_UTILS_H