/*------------------------------------------------------------------------------*
 * File Name:	opencv_origin.h	 												*
 * Created:		2011-08-24														*
 * Purpose:		vc level functions dependent on OpenCV							*
 * Copyright (c) OriginLab Corp. 2011											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Rex 2011/10/21 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS					* 
 * Rex 2011/12/5 ORG-3193 SUPPORT_CALL_OPENCV_IN_OC								*
 * EJP 2012-01-25 ORG-4927 ORIGIN_C_VIDEO_WRITER								*
 * Rex 2012/6/14 ORG-5914 LIST_ALL_INSTALLED_CODECS								*
 * EJP 2012-06-26 ORG-4929-P1 CHECK_WRITE_ACCESS_TO_PREVENT_CRASH				*
 * Rex 2012/7/11 ORG-5112 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD			*
 *------------------------------------------------------------------------------*/

#ifndef __OPENCV_ORIGIN_H__
#define __OPENCV_ORIGIN_H__

#include "opencv_types.h"

#ifdef __cplusplus
extern "C" {
#endif

///Rex 2011/12/5 ORG-3193 SUPPORT_CALL_OPENCV_IN_OC
/****************************************************************************************\
*          						Ultilities for Originlab						         *
\****************************************************************************************/
//int ocv_getOpenCVDataType(DWORD dwOriginDataType);
//CvMat* ocv_createCvMat(int nRows, int nCols, int nOriginDataType);


//===========================================================================
//===========================================================================
//===========================================================================
//
// Functions added to opencv_core DLL by OriginLab
//
//===========================================================================
//===========================================================================
//===========================================================================
#pragma dll(opencv_core)


//---------------------------------------------------------------------------
// Begin declarations for functions that should be called using macros.
// The following functions were created to work around limits with Origin C.
// For portable OpenCV code do not call the following ocv* functions by name.
// Use the cv* with OpenCV syntax macros instead.
//---------------------------------------------------------------------------

/* Common inline functions in type_c.h */
CVAPI(int) ocvRound( double value); 
CVAPI(int) ocvFloor( double value);
CVAPI(int) ocvCeil( double value);
CVAPI(int) ocvIsNaN( double value);
CVAPI(int) ocvIsInf( double value);

/* Random generater */
//CVAPI(unsigned int) ocvRandInt(CvRNG* rng);

/* Allocates and initializes IplImage header */
CVAPI(IplImage*) ocvCreateImageHeader(const CvSize* size, int depth, int channels);

/* Inializes IplImage header */
CVAPI(IplImage*) ocvInitImageHeader( IplImage* image, const CvSize* size, int depth,
	int channels, int origin CV_DEFAULT(0), int align CV_DEFAULT(4));

/* Creates IPL image (header and data) */
CVAPI(IplImage*)  ocvCreateImage( const CvSize* size, int depth, int channels );

/* Makes a new matrix from <rect> subrectangle of input array. No data is copied */
CVAPI(CvMat*) ocvGetSubRect( const CvArr* arr, CvMat* submat, const CvRect* rect );

/* arr(idx0,idx1,...) = value */
CVAPI(void) ocvSet1D( CvArr* arr, int idx0, const CvScalar* value );
CVAPI(void) ocvSet2D( CvArr* arr, int idx0, int idx1, const CvScalar* value );
CVAPI(void) ocvSet3D( CvArr* arr, int idx0, int idx1, int idx2, const CvScalar* value );
CVAPI(void) ocvSetND( CvArr* arr, const int* idx, const CvScalar* value );

/* Sets all or "masked" elements of input array to the same value*/
CVAPI(void) ocvSet( CvArr* arr, const CvScalar* value, const CvArr* mask CV_DEFAULT(NULL) );

/* dst(mask) = src(mask) + value */
CVAPI(void) ocvAddS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst(mask) = src(mask) - value = src(mask) + (-value) */
CVAPI(void) ocvSubS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst(mask) = value - src(mask) */
CVAPI(void)  ocvSubRS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst = src1 * scale + src2 */
CVAPI(void)  ocvScaleAdd( const CvArr* src1, const CvScalar* scale,	const CvArr* src2, CvArr* dst );

/* dst(idx) = src(idx) & value */
CVAPI(void) ocvAndS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst(idx) = src(idx) | value */
CVAPI(void) ocvOrS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst(idx) = src(idx) ^ value */
CVAPI(void) ocvXorS( const CvArr* src, const CvScalar* value, CvArr* dst, const CvArr* mask CV_DEFAULT(NULL));

/* dst(idx) = lower <= src(idx) < upper */
CVAPI(void) ocvInRangeS( const CvArr* src, const CvScalar* lower, const CvScalar* upper, CvArr* dst );

/* dst(x,y,c) = abs(src(x,y,c) - value(c)) */
CVAPI(void) ocvAbsDiffS( const CvArr* src, CvArr* dst, const CvScalar* value );

/* Makes an identity matrix (mat_ij = i == j) */
CVAPI(void)  ocvSetIdentity( CvArr* mat, const CvScalar* value CV_DEFAULT(NULL)/*default 1*/ );

/* Calculates length of sequence slice (with support of negative indices). */
CVAPI(int) ocvSliceLength( const CvSlice* slice, const CvSeq* seq );

/* Draws 4-connected, 8-connected or antialiased line segment connecting two points */
CVAPI(void)  ocvLine( CvArr* img, const CvPoint* pt1, const CvPoint* pt2,
                     const CvScalar* color, int thickness CV_DEFAULT(1),
                     int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0) );

/* Draws a rectangle given two opposite corners of the rectangle (pt1 & pt2),
   if thickness<0 (e.g. thickness == CV_FILLED), the filled box is drawn */
CVAPI(void)  ocvRectangle( CvArr* img, const CvPoint* pt1, const CvPoint* pt2,
                          const CvScalar* color, int thickness CV_DEFAULT(1),
                          int line_type CV_DEFAULT(8),
                          int shift CV_DEFAULT(0));

/* Draws a rectangle specified by a CvRect structure */
CVAPI(void)  ocvRectangleR( CvArr* img, const CvRect* r, const CvScalar* color, int thickness CV_DEFAULT(1),
                           int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0));
    
/* Draws a circle with specified center and radius.
   Thickness works in the same way as with cvRectangle */
CVAPI(void)  ocvCircle( CvArr* img, const CvPoint* center, int radius,
                       const CvScalar* color, int thickness CV_DEFAULT(1),
                       int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0));

/* Draws ellipse outline, filled ellipse, elliptic arc or filled elliptic sector,
   depending on <thickness>, <start_angle> and <end_angle> parameters. The resultant figure
   is rotated by <angle>. All the angles are in degrees */
CVAPI(void)  ocvEllipse( CvArr* img, const CvPoint* center, const CvSize* axes,
                        double angle, double start_angle, double end_angle,
                        const CvScalar* color, int thickness CV_DEFAULT(1),
                        int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0));

/* Fills convex or monotonous polygon. */
CVAPI(void)  ocvFillConvexPoly( CvArr* img, const CvPoint* pts, int npts, const CvScalar* color,
                               int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0));

/* Fills an area bounded by one or more arbitrary polygons */
CVAPI(void)  ocvFillPoly( CvArr* img, CvPoint** pts, const int* npts, int contours, const CvScalar* color,
                         int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0) );

/* Draws one or more polygonal curves */
CVAPI(void)  ocvPolyLine( CvArr* img, CvPoint** pts, const int* npts, int contours,
                         int is_closed, const CvScalar* color, int thickness CV_DEFAULT(1),
                         int line_type CV_DEFAULT(8), int shift CV_DEFAULT(0) );

/* Initializes line iterator. Initially, line_iterator->ptr will point
   to pt1 (or pt2, see left_to_right description) location in the image.
   Returns the number of pixels on the line between the ending points. */
CVAPI(int)  ocvInitLineIterator( const CvArr* image, const CvPoint* pt1, const CvPoint* pt2,
                                CvLineIterator* line_iterator, int connectivity CV_DEFAULT(8),
                                int left_to_right CV_DEFAULT(0));

/* Renders text stroke with specified font and color at specified location.
   CvFont should be initialized with cvInitFont */
//CVAPI(void)  ocvPutText( CvArr* img, const char* text, const CvPoint* org,
//                        const CvFont* font, const CvScalar* color );

/* Returns the polygon points which make up the given ellipse.  The ellipse is define by
   the box of size 'axes' rotated 'angle' around the 'center'.  A partial sweep
   of the ellipse arc can be done by spcifying arc_start and arc_end to be something
   other than 0 and 360, respectively.  The input array 'pts' must be large enough to
   hold the result.  The total number of points stored into 'pts' is returned by this
   function. */
CVAPI(int) ocvEllipse2Poly( const CvPoint* center, const CvSize* axes,
                 int angle, int arc_start, int arc_end, CvPoint * pts, int delta );

/* Draws contour outlines or filled interiors on the image */
CVAPI(void)  ocvDrawContours( CvArr *img, CvSeq* contour,
                             const CvScalar* external_color, const CvScalar* hole_color,
                             int max_level, int thickness CV_DEFAULT(1),
                             int line_type CV_DEFAULT(8),
                            const CvPoint* offset CV_DEFAULT(NULL)/*cvPoint(0,0)*/);
                     
/* The function implements the K-means algorithm for clustering an array of sample
   vectors in a specified number of classes */
CVAPI(int) ocvKMeans2( const CvArr* samples, int cluster_count, CvArr* labels,
                      CvTermCriteria* termcrit, int attempts CV_DEFAULT(1),
                      CvRNG* rng CV_DEFAULT(NULL), int flags CV_DEFAULT(0),
                      CvArr* _centers CV_DEFAULT(NULL), double* compactness CV_DEFAULT(NULL) );

/* starts writing compound structure (map or sequence) */
CVAPI(void) ocvStartWriteStruct( CvFileStorage* fs, const char* name,
                                int struct_flags, const char* type_name CV_DEFAULT(NULL),
                                CvAttrList* attributes CV_DEFAULT(NULL) /*cvAttrList()*/);
 
//---------------------------------------------------------------------------
// End declarations for functions that should be called using macros.
//---------------------------------------------------------------------------

/// EJP 2012-01-25 ORG-4927 ORIGIN_C_VIDEO_WRITER
CVAPI(int) ocvOTypeToCVType(DWORD dwOriginDataType);
/// end ORIGIN_C_VIDEO_WRITER


 
//===========================================================================
//===========================================================================
//===========================================================================
//
// Functions added to opencv_imgproc DLL by OriginLab
//
//===========================================================================
//===========================================================================
//===========================================================================
#pragma dll(opencv_imgproc)


//---------------------------------------------------------------------------
// Begin declarations for functions that should be called using macros.
// The following functions were created to work around limits with Origin C.
// For portable OpenCV code do not call the following ocv* functions by name.
// Use the cv* macros  with OpenCV syntax instead.
//---------------------------------------------------------------------------

/* Copies source 2D array inside of the larger destination array and
   makes a border of the specified type (IPL_BORDER_*) around the copied area. */
CVAPI(void) ocvCopyMakeBorder( const CvArr* src, CvArr* dst, const CvPoint* offset,
							  int bordertype, const CvScalar* value CV_DEFAULT(NULL)/*=cvScalarAll(0)*/);


/* Convolves the image with the kernel */
CVAPI(void) ocvFilter2D( const CvArr* src, CvArr* dst, const CvMat* kernel, 
						const CvPoint* anchor CV_DEFAULT(NULL)/*=cvPoint(-1,-1)*/);

/* Filters image using meanshift algorithm */
CVAPI(void) ocvPyrMeanShiftFiltering( const CvArr* src, CvArr* dst, double sp, double sr, int max_level CV_DEFAULT(1),
									const CvTermCriteria* termcrit CV_DEFAULT(NULL)/*cvTermCriteria(CV_TERMCRIT_ITER+CV_TERMCRIT_EPS,5,1)*/);

/* Warps image with affine transform */
CVAPI(void)  ocvWarpAffine( const CvArr* src, CvArr* dst, const CvMat* map_matrix,
                            int flags CV_DEFAULT(CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS),
                            const CvScalar* fillval CV_DEFAULT(NULL)/*cvScalarAll(0)*/ );

/* Computes rotation_matrix matrix */
CVAPI(CvMat*)  ocv2DRotationMatrix( const CvPoint2D32f* center, double angle,
                                    double scale, CvMat* map_matrix );

/* Warps image with perspective (projective) transform */
CVAPI(void)  ocvWarpPerspective( const CvArr* src, CvArr* dst, const CvMat* map_matrix,
                                 int flags CV_DEFAULT(CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS),
                                 const CvScalar* fillval CV_DEFAULT(NULL)/*=cvScalarAll(0)*/);

/* Performs generic geometric transformation using the specified coordinate maps */
CVAPI(void)  ocvRemap( const CvArr* src, CvArr* dst, const CvArr* mapx, const CvArr* mapy,
                       int flags CV_DEFAULT(CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS),
                       const CvScalar* fillval CV_DEFAULT(NULL)/*=cvScalarAll(0)*/ );

/* Performs forward or inverse log-polar image transform */
CVAPI(void)  ocvLogPolar( const CvArr* src, CvArr* dst, const CvPoint2D32f* center, double M,
                          int flags CV_DEFAULT(CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS));

/* Performs forward or inverse linear-polar image transform */
CVAPI(void)  ocvLinearPolar( const CvArr* src, CvArr* dst, const CvPoint2D32f* center, double maxRadius,
                             int flags CV_DEFAULT(CV_INTER_LINEAR+CV_WARP_FILL_OUTLIERS));

/* Retrieves outer and optionally inner boundaries of white (non-zero) connected
   components in the black (zero) background */
CVAPI(int)  ocvFindContours( CvArr* image, CvMemStorage* ms, CvSeq** first_contour,
                             int header_size CV_DEFAULT(sizeof(CvContour)),
                             int mode CV_DEFAULT(CV_RETR_LIST),
                             int method CV_DEFAULT(CV_CHAIN_APPROX_SIMPLE),
                             const CvPoint* offset CV_DEFAULT(NULL)/*=cvPoint(0,0)*/);

/* Initalizes contour retrieving process.
   Calls cvStartFindContours.
   Calls cvFindNextContour until null pointer is returned
   or some other condition becomes true.
   Calls cvEndFindContours at the end. */
CVAPI(CvContourScanner)  ocvStartFindContours( CvArr* image, CvMemStorage* ms,
                             int header_size CV_DEFAULT(sizeof(CvContour)),
                             int mode CV_DEFAULT(CV_RETR_LIST),
                             int method CV_DEFAULT(CV_CHAIN_APPROX_SIMPLE),
                             const CvPoint* offset CV_DEFAULT(NULL)/*=cvPoint(0,0)*/);

/* Calculates perimeter of a contour or length of a part of contour */
CVAPI(double)  ocvArcLength( const void* curve, const CvSlice* slice CV_DEFAULT(NULL)/*=CV_WHOLE_SEQ*/,
                            int is_closed CV_DEFAULT(-1));

/* Calculates area of a contour or contour segment */
CVAPI(double)  ocvContourArea( const CvArr* contour, const CvSlice* slice CV_DEFAULT(NULL)/*=CV_WHOLE_SEQ*/,
                              int oriented CV_DEFAULT(0));

/* Checks whether the point is inside polygon, outside, on an edge (at a vertex).
   Returns positive, negative or zero value, correspondingly.
   Optionally, measures a signed distance between
   the point and the nearest polygon edge (measure_dist=1) */
CVAPI(double) ocvPointPolygonTest( const CvArr* contour, const CvPoint2D32f* pt, int measure_dist );

/* Does some sort of template matching but compares histograms of
   template and each window location */
CVAPI(void)  ocvCalcArrBackProjectPatch( CvArr** image, CvArr* dst, CvSize* range,
                                        CvHistogram* hist, int method,
                                        double factor );

/* Fills the connected component until the color difference gets large enough */
CVAPI(void) ocvFloodFill( CvArr* image, const CvPoint* seed_point, const CvScalar* new_val,
						 const CvScalar* lo_diff CV_DEFAULT(NULL), const CvScalar* up_diff CV_DEFAULT(NULL), 
						 CvConnectedComp* comp CV_DEFAULT(NULL), int flags CV_DEFAULT(4), 
						 CvArr* mask CV_DEFAULT(NULL));
//---------------------------------------------------------------------------
// End declarations for functions that should be called using macros.
//---------------------------------------------------------------------------

 
//---------------------------------------------------------------------------
// The following functions are OpenCV utility functions added to the
// opencv_imgproc DLL and created by OriginLab.
//---------------------------------------------------------------------------

///Rex 2011/10/21 RSRCH-72 DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS

//comments last updated by Rex 12/08/2011
/**$
		Flag value used when detecting and tracing a curve
*/
enum {OCV_CURVE_BACKGD = 0, OCV_CURVE_SALIENT = 1, OCV_CURVE_LOCALMAX = 100, OCV_CURVE_TRACED = 255};


//comments last updated by Rex 12/08/2011
/**$ 
		Calculate the salient threshold for curve tracing, see equation(8) of C. Steger's paper.
	Parameters:
		sigma=[input][optional]scale parameter, default is 2.0
		contrast=[input]curve contrast, default is 2.0
	Return:
		The calculated salient threshold of curve
*/
CVAPI(double) ocvCurveSalientThreshold(double sigma = 2.0, double contrast = 2.0);


//comments last updated by Rex 12/08/2011
/**$
		Calculate the curve salients and orientations in given scale space. Curve detection according to 
		paper: C. Steger, "An unbiased detector of curvilinear structures," IEEE Transactions on Pattern 
		Analysis and Machine Intelligence, Feb. 1998.
	Parameters:
		image=[input]source gray image, with type CV_8UC1
		salients=[output]salient values of pixels, with type CV_32FC1 and same size as input image
		angles=[output]orientations of pixels, with type CV_32FC1 and same size as input image
		sigma=[input][optional]scale space parameter, default is 2.0
	Return:
		Returns CV_StsOk on successful exit and a negative error code on failure		
*/
CVAPI(int) ocvCurveSalientsAndOrients(const CvMat* image, CvMat* salients, CvMat* angles, double sigma = 2.0);


//comments last updated by Rex 12/08/2011
/**$ 
		Find the curve centers according to the salient and orientation images. Curve centers are the candidate
		points for later tracing. See C. Steger's paper for details
	Parameters:
		salients=[input]salient image, with type CV_32FC1
		angles=[input]orientation image, with type CV_32FC1 and same size as salients
		mask=[output]output flag image, has type CV_8UC1 and same size as salients. Flag value OCV_CURVE_BACKGD 
				means a background point, OCV_CURVE_SALIENT means a salient point(>threshould), and 
				OCV_CURVE_LOCALMAX means a curve center(salient point being local maxima along its orientation), 
				it's a candidate point for later tracing
		threshold=[input][optional]salient threshold, default 0.0
	Return:
		Returns CV_StsOk on successful exit and a negative error code on failure
*/
CVAPI(int) ocvFindCurveCenter(const CvMat* salients, CvMat* angles, CvMat* mask, double threshold = 0.0);

///Rex 2012/7/11 ORG-5112 FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD

/* Find better start point in neighborhood*/
CVAPI(int) ocvFindTraceStart(const CvMat* mask, CvPoint* start, double radius = 3);

///End FIND_BETTER_TRACE_START_POINT_IN_NEIGHBORHOOD


//comments last updated by Rex 12/08/2011
/**$
		Trace out a curve with given start point. See C. Steger's paper for details.
	Parameters:
		salients=[input]salient image, with type CV_32FC1.
		angles=[modify]orientation image, with type CV_32FC1 and same size as salients. Curve tracing will 
				continue reversely when reaching an end, and finish when reaching another
		masks=[modify]flag image, with type CV_32FC1 and same size as salients. Flag value OCV_CURVE_BACKGD 
				means a background point, OCV_CURVE_SALIENT means a salient point(>threshould), and 
				OCV_CURVE_LOCALMAX means a curve center(salient point being local maxima along its orientation),
				it's candidate point for tracing. After the tracing, the curve center's value will be set to 
				OCV_CURVE_TRACED
		x0=[input]x value of start point
		y0=[input]y value of start point
		points=[output]pointer of pointer to a CvMat, with type CV_32SC2 and size 1xn, It contains the returned
				n curve points.	Each elem is the x and y value
	Return:
		Returns CV_StsOk on successful exit and a negative error code on failure.	
*/
CVAPI(int) ocvTraceCurve(const CvMat* salients, CvMat* angles, CvMat* masks, int x0, int y0, CvMat** points);


//comments last updated by Rex 12/08/2011
/**$
 		Find local maximas
 	Paramters:
 		src=[input]source matrix, with type CV_32FC1
 		dst=[output]destination matrix, with type CV_8UC1. It has value 255 if is a maxima, 0 otherwise
 		maximas=[output]returned maximas, with type CV_32FC3 and size 1xn. Each elem contains the x, y location 
 				and its value.
 		mask=[input][optional]operation mask with type CV_8UC1. It specifies elements of destination matrix to 
 				be changed. default NULL
 		stel=[input][optional]structuring element struct used for erode opration. Its anchor's value will be 
 				to 0. Default NULL, means a 3x3 rectangular structuring element with anchor=0
 	Return:
 		Returns CV_StsOk on successful exit and a negative error code on failure
*/
CVAPI(int) ocvFindLocalMaxima(const CvMat* src, CvMat* dst, CvMat** maximas, const CvMat* mask = NULL, 
							const IplConvKernel* stel = NULL);

							
//comments last updated by Rex 12/08/2011
/**$
		Remove the gridlines in a binary image
	Paramters:
		src=[input]source image, with type CV_8UC1
		dst=[output]destination image, with type CV_8UC1, and same size to src
		lines=[output][optional]detected gridlines, returned matrix with type CV_32SC4 and size 1xn. Each 
				element contaions the two ends(x1y1x2y2) of a gridline. Default is NULL
		threshold=[input][optional]accumulator threshold, parameter for probabilistic Hough transform to detect
				the gridlines. Default is 20
		minLen=[input][optional]minmum gridline length, parameter for probabilistic Hough transform to detect
				the gridlines. Default is 20
		maxGap=[input][optional]maximum allowed gap between points on the same line to link them, parameter for 
				probabilistic Hough transform to detect the gridlines. Default is 5
		angleTol=[input][optional]angle tolenrace of the gridlines, default is 1.0
	Return:
		Returns CV_StsOk on successful exit and a negative error code on failure
*/
CVAPI(int) ocvRemoveGridlines(const CvMat* src, CvMat* dst, CvMat** lines = NULL, double threshold = 20, 
							double minLen = 20, double maxGap = 5, double angleTol = 1.0);

							
//comments last updated by Rex 12/08/2011
/**$
		Digitize an area specified by a gridmesh
	Parameters:
		image=[input]input binray image, with type CV_8UC1
		points=[output]returned points, matrix with type CV_32SC4 and size 1xn. Each elem contains a point(x and y).
		x=[intput]x location of gridmesh
		y=[input]y location of gridmesh
		width=[input]width of gridmesh
		height=[input]height of gridmesh
		step=[input]grid interval of gridmesh
		theta=[input][optional]tilt angle of gridmesh, default is 0
		minsize=[input][optional]minmum point size, default is 1
		maxgap=[input][optional]maximum allowed gap betwern points on a grid line, default is 1
	Return:
		Returns CV_StsOk on successful exit and a negative error code on failure
*/
CVAPI(int) ocvDigitizeArea(const CvMat* image, CvMat** points, int x, int y, int width, int height, int step, 
							float theta = 0.0, int minsize = 1, int maxgap = 1);

///End DIGITIZER_AUTO_TRACE_LINE_FUNCTIONS


///Rex 2011/12/5 ORG-3193 SUPPORT_CALL_OPENCV_IN_OC
//===========================================================================
//===========================================================================
//===========================================================================
//
// Functions added to opencv_highgui DLL by OriginLab
//
//===========================================================================
//===========================================================================
//===========================================================================

#pragma dll(opencv_highgui)
	
//---------------------------------------------------------------------------
// Begin declarations for functions that should be called using macros.
// The following functions were created to work around limits with Origin C.
// For portable OpenCV code do not call the following ocv* functions by name.
// Use the cv* macros  with OpenCV syntax instead.
//---------------------------------------------------------------------------

CVAPI(CvVideoWriter*) ocvCreateVideoWriter( const char* filename, int fourcc,
	double fps, const CvSize* frame_size,
	int is_color CV_DEFAULT(1));

//---------------------------------------------------------------------------
// End declarations for functions that should be called using macros.
//---------------------------------------------------------------------------

/// EJP 2012-01-25 ORG-4927 ORIGIN_C_VIDEO_WRITER
CVAPI(int) ocvCreateImageFromDib(IplImage** ppIplImg, HANDLE hDib);
/// end ORIGIN_C_VIDEO_WRITER

///Rex 2012/6/14 ORG-5914 LIST_ALL_INSTALLED_CODECS
CVAPI(int) ocvGetInstalledCodecs(const char*** pCodecNames, DWORD** pCodecFourccs, bool bRetest=true);
CVAPI(void) ocvReleaseCodecInfos(const char*** pCodecNames, DWORD** pCodecFourccs);
CVAPI(bool) ocvIsCodecInstalled(DWORD fourcc); // test a single codec
///End LIST_ALL_INSTALLED_CODECS

/// EJP 2012-06-26 ORG-4929-P1 CHECK_WRITE_ACCESS_TO_PREVENT_CRASH
CVAPI(bool) ocvIsWriteAccess(const char* filename);
/// end CHECK_WRITE_ACCESS_TO_PREVENT_CRASH

///End SUPPORT_CALL_OPENCV_IN_OC

#ifdef __cplusplus
}
#endif

#endif // __OPENCV_ORIGIN_H__
 
/* End of file. */