/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Rex 2011/12/5 SUPPORT_CALL_OPENCV_IN_OC										*
 * EJP 2012-02-09 ORG-4927 ORIGIN_C_VIDEO_WRITER								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <opencv.h>


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
/// EJP 2012-02-09 ORG-4927 ORIGIN_C_VIDEO_WRITER
/// Moved function to opencv_core DLL, declared in opencv_origin.h
// int ocvOTypeToCVType(DWORD dwOriginDataType)
// {
	// /* From OC_const.h
	// enum FSITYPE {
		// FSI_DOUBLE = 0,
		// FSI_REAL,
		// FSI_SHORT,
		// FSI_LONG,
		// FSI_CHAR,
		// FSI_TEXT,
		// FSI_MIXED,
		// FSI_BYTE,
		// FSI_USHORT,
		// FSI_ULONG,
		// FSI_COMPLEX,
	// */
	// static int s_nCvTypes[] = {
		// CV_64F, CV_32F,
		// CV_16S, CV_32S, CV_8S,
		// -1, -1,
		// CV_8U, CV_16U, CV_32S, // CV_32S again because OpenCV has no CV_32U.
		// -1};

	// int nCvType = dwOriginDataType & 0x0000ffff;
	// if (nCvType > FSI_COMPLEX)
		// return -1;

	// nCvType = s_nCvTypes[nCvType];
	// if (-1 != nCvType)
	// {
		// // For now I am always setting number of channels to 1.
		// // I suspect for RGB or RGBA images we will need to set
		// // this to 3 or 4.
		// int nNumChannels = 1;

		// nCvType = CV_MAKETYPE(nCvType, nNumChannels);
	// }
	// return nCvType;
// }
/// end ORIGIN_C_VIDEO_WRITER


CvMat* ocvCreateCvMat(int nRows, int nCols, int nOriginDataType)
{
	CvMat* pCvMat = NULL;
	int nCvType = ocvOTypeToCVType(nOriginDataType);
	if (-1 != nCvType)
		pCvMat = cvCreateMat(nRows, nCols, nCvType);
	return pCvMat;
}


#define OCV_CREATE_CV_MAT_FROM_OMAT(omat,type) \
	CvMat* ocvCreateCvMat(const matrix<type>& omat, bool bCopyData = true) \
	{ \
		CvMat* pCvMat = ocvCreateCvMat(omat.GetNumRows(), omat.GetNumCols(), omat.GetInternalDataType()); \
		if (pCvMat && bCopyData) \
			omat.CopyTo(pCvMat); \
		return pCvMat; \
	}
	
OCV_CREATE_CV_MAT_FROM_OMAT(omat, double)	// create CV_64F from FSI_DOUBLE
OCV_CREATE_CV_MAT_FROM_OMAT(omat, float)	// create CV_32F from FSI_REAL
OCV_CREATE_CV_MAT_FROM_OMAT(omat, short)	// create CV_16S from FSI_SHORT
OCV_CREATE_CV_MAT_FROM_OMAT(omat, long)		// create CV_32S from FSI_LONG
OCV_CREATE_CV_MAT_FROM_OMAT(omat, char)		// create CV_8S  from FSI_CHAR
OCV_CREATE_CV_MAT_FROM_OMAT(omat, byte)		// create CV_8U  from FSI_BYTE
OCV_CREATE_CV_MAT_FROM_OMAT(omat, ushort)	// create CV_16U from FSI_USHORT
OCV_CREATE_CV_MAT_FROM_OMAT(omat, DWORD)	// create CV_32S from FSI_ULONG

