/*------------------------------------------------------------------------------*
 * File Name:op_utils.h		 													*
 * Creation: CPY 12/29/2007														*
 * Purpose: Curve Fitting and other Operation XF utilities						*
 * Copyright (c) Originlab Corp. 2007											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 01/18/08 QA80-10929 ADD_LT_NLFIT_MECHANISM								*
 *	Hong 01/23/08 QA80-10929 LTNL_ACCESS_WORKAREA_AFTER_INIT					*
 *	Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW			*
 *	Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK						*
 *	Folger 02/19/08 QA80-10929 OPTIONAL_DWORD_TO_DISPLAY_KEY_AND_NAME			*
 *	Hong 03/05/08 QA80-10292 v8.0817 NLFIT_SUPPORT_APPLY_DIALOG_THEME			*
 *	Hong 06/16/08 QA80-11699 FIX_2D_FITTING_FAIL_GENERATE_REPORT				*
 *	Folger 03/11/09 QA80-13253 NLFIT_LT_COMMAND_SUPPORT_SPECIFY_WEIGHT_METHOD	*
 *	Sophy 8/5/2009 QA80-14072 SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK	*
 *	Sophy 9/18/2009 QA80-14072 SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK	*
 *	Folger 11/09/2010 ORG-1347-P6 NLBEGINR_FAILED_FROM_THEME					*
 *	Folger 09/04/2012 ORG-5522-S1 IMPLICIT_FITTING_FROM_LT_USING_NLBEGINO		*
 *------------------------------------------------------------------------------*/

#ifndef _OP_UTILS_H
#define _OP_UTILS_H

#include	<onlsf.h>		///------ Folger 03/11/09 QA80-13253 NLFIT_LT_COMMAND_SUPPORT_SPECIFY_WEIGHT_METHOD

typedef Operation* OperationPtr;
int op_init(OperationPtr& pOP, LPCSTR lpcszclassname, TreeNode& iotrgui, LPCSTR lpcszTheme=NULL, int lParam=0);
int op_update(OperationPtr & pOP,  TreeNode& iotrgui, LPCSTR lpcszTheme=NULL);
int op_do_calculate(OperationPtr & pOP,  TreeNode& iotrgui, int nExec = 0, TreeNode& otrresult=NULL, LPCSTR lpcszTheme=NULL);

/// Hong 01/18/08 QA80-10929 ADD_LT_NLFIT_MECHANISM
/*
// NLSF specific
void cf_reset(bool bDumpStatusInfo=false);
// NULL will show current function name
int cf_set_fit_function(LPCSTR lpcszFundName);
int cf_set_data(XYRange& iy, int nMode);
*/
/* Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
//------ Folger 02/19/08 QA80-10929 OPTIONAL_DWORD_TO_DISPLAY_KEY_AND_NAME
//bool lt_cf_init(LPCSTR lpcszLTTreeName);
/// Hong 06/16/08 QA80-11699 FIX_2D_FITTING_FAIL_GENERATE_REPORT
//bool lt_cf_init(LPCSTR lpcszLTTreeName, DWORD dwOption = 0);
bool lt_cf_init(LPCSTR lpcszLTTreeName, DWORD dwOption = 0, int nFitType = NLFIT_GENERAL_XY_FITTING);
/// end FIX_2D_FITTING_FAIL_GENERATE_REPORT
//------
///Arvin 01/29/08 GENERATE_REPORT_SUPPORT_RECALCULATE_IN_LT_NLFit
//int lt_cf_end(int nReport, bool bPrintErr);
int lt_cf_end(int nReport, int nAutoUpdate = AU_NONE, bool bPrintErr = false);
///end GENERATE_REPORT_SUPPORT_RECALCULATE_IN_LT_NLFit
enum
{
	/// Hong 02/01/08 v8.0798 UPDATE_LTNL_FITMODE
	//AUTO_FIT_MODE = -1,	
	//INDEP_CONS_FIT_MODE,
	//INDEP_SEP_FIT_MODE,
	AUTO_FIT_MODE = 0,	
	/// end UPDATE_LTNL_FITMODE
	CONCAT_FIT_MODE,
	GLOBAL_FIT_MODE,
};
/// Iris 03/10/2008 SUPPORT_XYZ_INPUT
/////Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
////bool lt_cf_set_inputdata(const XYRange& iy, int nFitMode = AUTO_FIT_MODE, int nReplicas = 0);
//bool lt_cf_set_inputdata(const XYRange& iy);
bool lt_cf_set_inputdata(const Range& iy);
/////end GENERATE_REPORT_FOR_LT_NLFit
///end SUPPORT_XYZ_INPUT

//bool lt_cf_set_function(const string& lpcszFuncName);
/// Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK
//int lt_cf_set_function(const string& lpcszFuncName, bool bAutoInit = false); /// Hong 01/23/08 QA80-10929 LTNL_ACCESS_WORKAREA_AFTER_INIT
/// Hong 03/05/08 QA80-10292 v8.0817 NLFIT_SUPPORT_APPLY_DIALOG_THEME
//int lt_cf_set_function(const string& lpcszFuncName, bool bAutoInit = false, int* pnFitMode = NULL, int* pnReplica = NULL);
int lt_cf_set_function(const string& lpcszFuncName, bool* pbAutoInit = NULL, int* pnFitMode = NULL, int* pnReplica = NULL, LPCSTR lpcszTheme = NULL);
/// end NLFIT_SUPPORT_APPLY_DIALOG_THEME
/// end FIX_CONTANTENATE_FIT_FAIL_WORK
*/
///end Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
/// Hong 02/01/08 v8.0798 FIX_CONTANTENATE_FIT_FAIL_WORK
/*
///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
bool lt_cf_set_fit_mode_replica(int nFitMode = AUTO_FIT_MODE, int nReplicas = 0);
///end GENERATE_REPORT_FOR_LT_NLFit
*/
/// end FIX_CONTANTENATE_FIT_FAIL_WORK
///Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
/*
enum
{
	LM_ITERATE_METHOD,
	SIMPLEX_ITERATE_METHOD,
};
bool lt_cf_iterate(int nNum = -1, int nMethod = LM_ITERATE_METHOD);
/// end ADD_LT_NLFIT_MECHANISM
/// Hong 01/24/08 QA80-10929 LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW
bool lt_cf_enable_source_page_preview();
/// end LT_NLFIT_SUPPORT_SOUURCE_GRAPHPAGE_PREVIEW

bool lt_cf_params(); /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG

int cvt_op_err_to_nl_xf_err(int nOpErrCode); /// Hong 01/31/08 QA80-10929 LTNLFIT_MORE_DETAILS_ERROR_MSG

/// Iris 3/11/2008 SUPPORT_XYZ_INPUT
enum{
	fit_mode_auto,
	fit_mode_concat,
	fit_mode_global,
};
enum{
	param_notation_para,
	param_notation_abbr,
	param_notation_both,
};
enum
{
	NL_NO_LT_TREE = 1000, //---- CPY 1/22/08 LINK_NLFIT_OP_TREE_TO_LT_TREE
	NL_INIT_ERROR,
	NL_SET_FUNC_ERROR,
	NL_SET_INPUT_DATA_ERROR,
};
/// Hong 06/16/08 QA80-11699 FIX_2D_FITTING_FAIL_GENERATE_REPORT
//void lt_cf_nlbegin(const Range& iy, LPCSTR lpcszFunc, TreeNode& nltree, int nFitMode, int nReplica, LPCSTR lpcszTheme, int nParamNotation); 
void lt_cf_nlbegin(const Range& iy, LPCSTR lpcszFunc, TreeNode& nltree, int nFitMode, int nReplica, LPCSTR lpcszTheme, int nParamNotation, int nFitType = NLFIT_GENERAL_XY_FITTING);
/// end FIX_2D_FITTING_FAIL_GENERATE_REPORT
///end SUPPORT_XYZ_INPUT

*/ 
///end Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
///Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
//enum{
	//fit_mode_auto,
	//fit_mode_concat,
	//fit_mode_global,
//};
///end Sophy 10/15/2008 MOVE_CODE_FROM_LT_OPERATION_TO_OP_UTILS
enum{
	param_notation_para,
	param_notation_abbr,
	param_notation_both,
};
enum
{
	NL_NO_LT_TREE = 1000, //---- CPY 1/22/08 LINK_NLFIT_OP_TREE_TO_LT_TREE
	NL_INIT_ERROR,
	NL_SET_FUNC_ERROR,
	NL_SET_INPUT_DATA_ERROR,
};

enum
{
	/// Hong 02/01/08 v8.0798 UPDATE_LTNL_FITMODE
	//AUTO_FIT_MODE = -1,	
	//INDEP_CONS_FIT_MODE,
	//INDEP_SEP_FIT_MODE,
	AUTO_FIT_MODE = 0,	
	/// end UPDATE_LTNL_FITMODE
	CONCAT_FIT_MODE,
	GLOBAL_FIT_MODE,
	///Sophy 10/15/2008 QA80-12130 SUPPORT_INDEP_FIT_CONSOLIDATED_FROM_COMMAND
	INDEP_CONS_FIT_MODE,
	INDEP_SEP_FIT_MODE,
	///end SUPPORT_INDEP_FIT_CONSOLIDATED_FROM_COMMAND
};

///Sophy 8/5/2009 QA80-14072 SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK
//options for nlbegin, nlbeginr, nlbeginz, nlbeginm
enum
{
	NLFIT_INIT_ALL = 0,
	NLFIT_CHANGE_DATA,
};
///end SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK
/**$
*/
///------ Folger 11/09/2010 ORG-1347-P6 NLBEGINR_FAILED_FROM_THEME
//int lt_nlf_nlbegin(const Range& iy, LPCSTR lpcszFunc, TreeNode& nltree, int nFitMode = AUTO_FIT_MODE, int nReplica=0, LPCSTR lpcszTheme=NULL, int nParamNotation=0, int nFitType = NLFIT_GENERAL_XY_FITTING, bool* pbAutoInit = NULL, int nWeightMethod = WEIGHT_NONE);
int lt_nlf_nlbegin(const Range& iy, LPCSTR lpcszFunc, TreeNode& nltree, int nFitMode = AUTO_FIT_MODE, int nReplica=0, LPCSTR lpcszTheme=NULL, int nParamNotation=0, int nFitType = NLFIT_GENERAL_XY_FITTING, bool* pbAutoInit = NULL, int nWeightMethod = WEIGHT_NONE, BOOL bNeedReconstructRange = FALSE
	///------ Folger 09/04/2012 ORG-5522-S1 IMPLICIT_FITTING_FROM_LT_USING_NLBEGINO
	, BOOL bODR = FALSE
	///------ End IMPLICIT_FITTING_FROM_LT_USING_NLBEGINO
	);
///------ End NLBEGINR_FAILED_FROM_THEME

bool lt_nlf_params();				///Kyle 09/08/08 ADD_FUNCTIONS_TO_OPEN_NLPARAMSDIALOG

int lt_nlf_end(int nReport, int nAutoUpdate = AU_NONE, bool bPrintErr = false);

///------ Folger 11/09/2010 ORG-1347-P6 NLBEGINR_FAILED_FROM_THEME
//int lt_nlf_set_inputdata(const Range& iy);
int lt_nlf_set_inputdata(const Range& iy, LPCSTR lpcszFuncName, BOOL bNeedReconstructRange = FALSE);
///------ End NLBEGINR_FAILED_FROM_THEME

int	lt_nlf_get_function_name(string& strFuncName);	///Sophy 8/5/2009 QA80-14072 SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK

///------ Folger 11/09/2010 ORG-1347-P6 NLBEGINR_FAILED_FROM_THEME
//int lt_nlf_change_inputdata(const Range& iy); ///Sophy 8/5/2009 QA80-14072 SUPPORT_CHANGE_INPUTDATA_IN_NLFIT_FROM_LABTALK
int lt_nlf_change_inputdata(const Range& iy, BOOL bNeedReconstructRange = FALSE);
///------ End NLBEGINR_FAILED_FROM_THEME

int lt_nlf_set_function(LPCSTR lpcszFuncName, bool* pbAutoInit = NULL, int* pnFitMode = NULL, int* pnReplica = NULL, LPCSTR lpcszTheme = NULL);

enum
{
	LM_ITERATE_METHOD,
	SIMPLEX_ITERATE_METHOD,
};
int lt_nlf_iterate(int nNum = -1, int nMethod = LM_ITERATE_METHOD);

bool	lt_nlf_enable_source_page_preview();

/// Hong QA80-12374 10/14/08 NL_LT_ADD_OUTPUT_ACCESS
int		lt_nlf_gui(TreeNode& trGUI, bool bGet);
/// end NL_LT_ADD_OUTPUT_ACCESS

int cvt_op_err_to_nlf_xf_err(int nOpErrCode); /// Hong 01/31/08 QA80-10929 LTNLFIT_MORE_DETAILS_ERROR_MSG

string lt_nlf_get_function_err(LPCSTR lpcszFunc, int nErr); /// Iris 11/23/2010 ORG-1446-P1 STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE 

///------ Folger 09/11/2012 ORG-5522-S1 IMPLICIT_FITTING_FROM_LT_USING_NLBEGINO
void check_throw_err(int nErr);
///------ End IMPLICIT_FITTING_FROM_LT_USING_NLBEGINO

///end Sophy
#endif	//_OP_UTILS_H

