/*------------------------------------------------------------------------------*
 *	File Name: 	OCTE.h									 						*
 *	Purpose: TreeEditor related OC support codes							   	*
 *  Creation:	3/15/2005														*
 *					CPY 3/15/05 v8.0204 ADD_TREE_FROM_VC_FOR_GRID				*
 *  	Copyright Originlab Corp. 2005, 2006,									*
 *	Modification log	                                                        *
 *	AW 03/18/05 QA80-7522 v8.0206 MORE_ON_ADD_TREE_NODE_TO_LST_GRID				*
 *	CPY 5/4/08 QA70-11504 DIRECT_VC_SET_CELLS									*
 *	Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
 *------------------------------------------------------------------------------*/      

#ifndef _OCTE_H
#define _OCTE_H


#ifdef __AFX_H__
	#ifdef TREE_CNTRL_DLL
		#define OC_API __declspec(dllexport)
	#else
		#define OC_API __declspec(dllimport)
	#endif
	//---- CPY 5/4/08 QA70-11504 DIRECT_VC_SET_CELLS
	//#define TreeNode		OCXmlWrapperBase
	#include "OCtoVC.h"
	//----
	extern "C" {
#else
	#define OC_API

	///------ Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
	#define	IntArray	vector<int>
	///------ End COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE

	#pragma dll(OTreeEditor)	// Associate all functions below to OTreeEditor.dll which must be in the Origin EXE folder
#endif	//__AFX_H__


enum {
	TEAT_OPEN =				0x0001, // default to collapsed all node
	TEAT_AUTOSIZE =			0x0002,

	/// AW 03/18/05 QA80-7522 v8.0206 MORE_ON_ADD_TREE_NODE_TO_LST_GRID
	TEAT_SKIP_LEAFS =		0x0004, // defaut go through whole tree
	TEAT_NOT_SHOW_ROOT =	0x0008,  // default show root
	TEAT_IS_BRANCH =		0x0010,	// only used in octe_add_tree_row, default is not branch, add one more col for it 
	/// END MORE_ON_ADD_TREE_NODE_TO_LST_GRID
	
	TEAT_CHK_ADD_ICONS	=	0x0100, //---- CPY 6/7/2007 QA70-9815 XF_LT_SCRIPT_SAMPLE_VIEWER_NEED_FASTER_GET_INFO
	TEAT_CHK_ADD_ROW_DATA=	0x0200, //---- CPY 6/7/2007 QA70-9815 XF_LT_SCRIPT_SAMPLE_VIEWER_NEED_FASTER_GET_INFO
};

/// AW 03/18/05 QA80-7522 v8.0206 MORE_ON_ADD_TREE_NODE_TO_LST_GRID
//OC_API BOOL octe_add_tree(TreeNode* trSrc, HWND hDlg, HWND hGrid, int nStopLevel = -1, LPCSTR lpcszStopAttribute = NULL, DWORD dwCntrl = 0); 
/**
	Parameters:
		nStopLevel: default=-1, means no need check it, when nStopLevel>=0, only skip level large than it;
		lpcszStopAttribute: default=NULL, means no need check stopAttribute, when it not NULL, use it to stop adding subnode under it;
		dwCntrl: see above enum define, Will check TEAT_OPEN, TEAT_AUTOSIZE, TEAT_SKIP_LEAFS and TEAT_NOT_SHOW_ROOT in this function;
		nFromRow: default= -1, means add from root, if not add from the row=nFromRow to add trSrc;
*/
OC_API BOOL octe_add_tree(TreeNode* trSrc, HWND hDlg, HWND hGrid, int nStopLevel = -1, LPCSTR lpcszStopAttribute = NULL, DWORD dwCntrl = 0, int nFromRow = -1);

/**
	Parameters:
		nLevel: Add from nLevel level.
		dwCntrl: see above enum define. Will check TEAT_OPEN and TEAT_IS_BRANCH in this function
		nFromRow: default= -1, means add from root, if not add from the row=nFromRow to add trSrc;
*/
OC_API BOOL octe_add_tree_row(TreeNode* trSrc, int nLevel , DWORD dwCntrl = 0, int nFromRow=-1);
/// END MORE_ON_ADD_TREE_NODE_TO_LST_GRID


/**#
	Set grid row or col by array of string

*/
OC_API BOOL octe_set_cells(HWND hDlg, HWND hGrid, StringArray* pvsCells, int nRowCol, bool bCol = true, DWORD dwCntrl = 0);

///------ Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
/**#
	Get Show/Hidden Rows
*/
OC_API BOOL octe_get_rows_show(HWND hDlg, HWND hGrid, IntArray* pvsIndices);
/**#
	Get Show/Hidden Columns
*/
OC_API BOOL octe_get_cols_show(HWND hDlg, HWND hGrid, IntArray* pvsIndices);
///------ End COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE

#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OCTE_H

