/*------------------------------------------------------------------------------*
 * File Name : nlsf_factory.cpp													*
 * Creation: Folger Lun															*
 * Purpose: Create NLSF related objects											*
 * Copyright (c) Originlab Corp. 2012											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

///------ Folger 12/29/2011 ORG-4454 REFACTOR_NLFITSESSION

#include <origin.h>

#include "nlsf_utils.h" 
#include "NLFitSession.h"
#include "NLFitPreviewCtrl.h"
#include "SurfaceFitPreviewCtrl.h"

#define		CREATE_PREVIEW(_class) \
			NLFitSession*			pNLFitSession = (NLFitSession*)dwNLFitSession; \
			NLFitPreviewCtrlBase* 	pp = new _class(pNLFitSession); \
			return (ODWP)pp
			

ODWP	create_general_fitting_preview(ODWP dwNLFitSession)
{
	CREATE_PREVIEW(NLFitPreviewCtrl);
}

ODWP	create_xyz_surface_fitting_preview(ODWP dwNLFitSession)
{
	CREATE_PREVIEW(XYZSurfaceFitPreviewCtrl);
}

ODWP	create_matrix_surface_fitting_preview(ODWP dwNLFitSession)
{
	CREATE_PREVIEW(MatSurfaceFitPreviewCtrl);
}

///------ End REFACTOR_NLFITSESSION