/*------------------------------------------------------------------------------*
 * File Name:	IamgeFile			 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 9/11/06 IMG_IMPORT_TO_1ST_MATOBJ_AND_RENAME_USING_EXT					*
 *	Hong 02/19/08 QA80-10345 FIX_DUPLICATE_SHEETNAME_WHEN_AUTO_CORRECT			*
 *	Sim 03-03-2009 QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT						*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <origin.h>

////////////////////////////////////////////////////////////////////////////////////
 

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <tree_utils.h>
#include <image_utils.h>
#include "imageFile.h"


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
//int ImageFile::Import(LPCSTR lpcszFileName, MatrixLayer &lyTarget, TreeNode& trFileInfo, TreeNode &trFilter)
int ImageFile::Import(LPCSTR lpcszFileName, MatrixLayer &lyTarget, TreeNode& trFileInfo, TreeNode &trFilter, int nMoIndex) // -1
///end IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
{
	///---Sim 03-03-2009 QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
	if ( m_orng )
		m_orng.Reset();
	///---END QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
	
	MatrixObject moTarget;
	//--- CPY 9/11/06 IMG_IMPORT_TO_1ST_MATOBJ_AND_RENAME_USING_EXT
	//moTarget = lyTarget.MatrixObjects();
	///Sophy 6/8/2010 ORG-220-S1 SUPPORT_APPEND_MATRIXOBJECT_OF_SAME_DIM_TO_EXISTING_SHEET
	//lyTarget.SetSize(1, -1, -1, 0);
	///end SUPPORT_APPEND_MATRIXOBJECT_OF_SAME_DIM_TO_EXISTING_SHEET
	///Sophy 6/4/2010 ORG-220 IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
	//moTarget = lyTarget.MatrixObjects();
	moTarget = lyTarget.MatrixObjects(nMoIndex);
	///end IMPORT_MULTI_IMAGES_WITH_SAME_DIMS_INTO_SAME_MATRIXSHEET
	//---
	
	///---Sim 11-14-2006 HANDLE_ERR_MESSAGE_USE_DLL
	if ( !moTarget || !moTarget.IsValid() )
		return CER_INVALID_MATOBJ;
	///---END HANDLE_ERR_MESSAGE_USE_DLL
	
	///Sophy 6/18/2010 ORg-339 MULTIFRAME_TIFF_IMPORT
	int nBitmaps;
	if ( image_frame_counts(lpcszFileName, nBitmaps) && nBitmaps > 1 )
	{
		if ( image_import_to_matrix(lyTarget, lpcszFileName, trFileInfo) )
		{
			okutil_SetPageInfo(lyTarget.GetPage().GetName(), lpcszFileName, 1);
			m_orng.Add(lyTarget, 0, "Range", lyTarget.MatrixObjects.Count() - 1);
			return CER_NO_ERROR;
		}
		return IMPERR_IMG_FAILED_TO_IMPORT_FILE;
	}
	///end MULTIFRAME_TIFF_IMPORT
	///---Sim 08-09-2006 HANDLE_FILTER_AND_FILE_INFO
	//if ( moTarget && image_import_to_matrix(moTarget, lpcszFileName))/// modify this function to handle trFileInfo, trFilter
	///---Sim 11-14-2006 HANDLE_ERR_MESSAGE_USE_DLL
	//if ( moTarget && image_import_to_matrix(moTarget, lpcszFileName, trFileInfo, trFilter))/// modify this function to handle trFileInfo, trFilter
	if ( image_import_to_matrix(moTarget, lpcszFileName, trFileInfo, trFilter) )/// modify this function to handle trFileInfo, trFilter
	///---END HANDLE_ERR_MESSAGE_USE_DLL
	///---END HANDLE_FILTER_AND_FILE_INFO
	{
		///---Sim 08-09-2006 MOVE_OUT_FROM_IMAGE_UTILS
		///Sophy 6/8/2010 ORG-220-S2 USE_FILENAME_WTIH_EXT_TO_SET_OBJECT_LONGNAME
		//string strFileName = GetFileName(lpcszFileName, TRUE);
		string strFileName = GetFileName(lpcszFileName);
		///end USE_FILENAME_WTIH_EXT_TO_SET_OBJECT_LONGNAME
		//lyTarget.SetName(strFileName, OCD_LONG_NAME | OCD_ENUM_NEXT);
		///Sophy 6/7/2010 ORG-220-P3 RENAME_MATRIXOBJECT_WHEN_MULTIPLE_IMAGES_IN_SAME_LAYER
		//lyTarget.SetName(strFileName, OCD_ENUM_NEXT); /// Hong 02/19/08 QA80-10345 FIX_DUPLICATE_SHEETNAME_WHEN_AUTO_CORRECT
		///Sophy 6/11/2010 ORG-220-S4 ALWAYS_RENAME_RESULT_MATRIXOBJECT_WITH_FILENAME
		//if ( nMoIndex < 0 )
			//lyTarget.SetName(strFileName, OCD_ENUM_NEXT);
		//else
			//moTarget.SetLongName(strFileName);
		moTarget.SetLongName(strFileName);
		///end ALWAYS_RENAME_RESULT_MATRIXOBJECT_WITH_FILENAME
		///end RENAME_MATRIXOBJECT_WHEN_MULTIPLE_IMAGES_IN_SAME_LAYER
		
		Page pg = lyTarget.GetPage();
		if( pg )
		{
			//pg.Label = lpcszFile;
			//pg.TitleShow = WIN_TITLE_SHOW_BOTH;
			okutil_SetPageInfo(pg.GetName(), lpcszFileName, 1); // 1 = Binary data type
		}
		///---END MOVE_OUT_FROM_IMAGE_UTILS
		
		///---Sim 03-03-2009 QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
		int nC1 = moTarget.GetIndex();
		m_orng.Add((Datasheet)lyTarget, nC1, "Range", nC1);
		///---END QA80-13209 IMPORT_IMG_SUPPORT_REIMPORT
		
		return CER_NO_ERROR; ///---Sim 11-14-2006 HANDLE_ERR_MESSAGE_USE_DLL
	}
	///---Sim 11-14-2006 HANDLE_ERR_MESSAGE_USE_DLL
	//return -1;  //need set error codes to show failed, or modify original mage_import_to_matrix	
	return IMPERR_IMG_FAILED_TO_IMPORT_FILE;  //need set error codes to show failed, or modify original mage_import_to_matrix	
	///---END HANDLE_ERR_MESSAGE_USE_DLL
}
