/*------------------------------------------------------------------------------*
 * File Name: exportWAV.h	 													*
 * Creation: Sim 04-29-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 09/17/07 QA80-10381 SIMPLIFY_GUI_HIDDEN_OPTION_IF_NO_NEED				*
 *	Hong 09/24/07 QA80-10381 v8.0707 REMOVE_VOLUMN_FACTOR			*
 *	Tony 09/06/2012 ORG-5996-S1 CHANGE_INVALID_TYPE_TO_LONG					*
 *------------------------------------------------------------------------------*/
 
#ifndef _EXPORTWAV_H
#define _EXPORTWAV_H

typedef enum	// for temp 
{
	FAIL_CREATE_WAV_FILE = -20,
	INVALID_RANGE_INPUT, 
	SELECT_DATA_NOT_CONTAIN_VALID_CHANNEL,
	DATA_TYPE_NOT_SUPPORT,
	FAIL_CREATE_CHANNEL,
	FAIL_WRITE_CHANNEL_DATA,
	FAIL_ALLOCATE_MEMORY,
	FAIL_GET_CHANNEL,
	FAIL_READ_DATA,
	FAIL_GET_DATA_NUM,
	FAIL_GET_DATA_TYPE,
	UNKNOWN_DATA_TYPE,
	FAIL_GET_DATA,	
	INVALID_SETTING,
	INVALID_X_AXIS,
	INVALID_SAMPLE_RATE,
	SUCCEED = 0,
	
}WAV_EXPORT_ERROR;

enum
{
	SAMPLES_11KHZ = 11025,
	SAMPLES_22KHZ = 22050,
	SAMPLES_44KHZ = 44100,
};

#define WAV_SAMPLE_RATE_MINIMUM_LIMIT 20
#define WAV_SAMPLE_RATE_MAXIMUM_LIMIT 4294967296 ///---Sim 08-11-2008 CHECK_SAMPLE_RATE_LIMIT

enum
{
	BITS_8 = 8,
	BITS_16 = 16,
	BITS_32 = 32,
};

/// Hong 09/24/07 QA80-10381 v8.0707 REMOVE_VOLUMN_FACTOR
typedef enum
{
	WAV_CHANNEL_MONO = 1,
	WAV_CHANNEL_STEREO,
}WAV_CHANNEL_TYPE;
/// end REMOVE_VOLUMN_FACTOR

typedef struct tagWAVSETTING
{
	WORD Channels;			// number of channels, { 1 = mono | 2 = stereo }
	DWORD SamplesPerSecond;	// sampling rate
	WORD BitsPerSample;	// Sample size { 8 | 16 }
} WAVSETTING;

class exportWAVFile : public file
{
public:
	exportWAVFile();
	~exportWAVFile();
public:
	//int SetFormat(WORD wChannels = 2, DWORD dwSamplesPerSecond = SAMPLES_44KHZ, WORD wBitsPerSample = BITS_16);
	int SetBitsPerSample(WORD wBitsPerSample = BITS_16);
	//int SetRange(DataRange& dr);
	/// Hong 09/17/07 QA80-10381 SIMPLIFY_GUI_HIDDEN_OPTION_IF_NO_NEED
	//int SetRange(Worksheet wks, int nC1, int nC2, int nCX = -1, int nR1 = 0, int nR2 = -1);
	int SetRange(Worksheet wks, int nC1, int nC2 = -1, int nR1 = 0, int nR2 = -1, BOOL bStereo = FALSE);
	/// end SIMPLIFY_GUI_HIDDEN_OPTION_IF_NO_NEED
	int SetFactor(double dFactor);
	
	int WriteFile(LPCSTR lpcszFileName);
protected:
	bool CheckSetting();
	int WriteHeader();
	int WriteChunks();
	bool WriteSamples(matrixbase& mb);
	void GetMaxVolumeSource(double& dMaxVolume, Worksheet& wks, int nC1, int nC2, int nR1 = 0, int nR2 = -1);
	//void ClearMissingValueToZero(Worksheet& wks, int nC1, int nC2, int nR1 = 0, int nR2 = -1) // = 0, -1
	int GetSampleRate(Column& colX, DWORD& dwSampleRate, int nR1 = 0, int nR2 = -1);
	int GetSampleRate(Worksheet& wks, DWORD& dwSampleRate, int nC1, int nC2);
	
	///---Sim 12-13-2007 IMPROVE_CONVERT_SAMPLE_BITS
	///// Hong 09/24/07 QA80-10381 v8.0707 REMOVE_VOLUMN_FACTOR
	//bool GetMaxVolumnByType(int nType, int& nMaxVolumn,  int* pnBytesSample = NULL);
	///// end REMOVE_VOLUMN_FACTOR
	bool GetMaxMinSample(int nDataType, int& nMax, int& nMin);
	int GetBytesSample(int nDataType);
	int GetColDataType(Column col);		///------ Tony 09/06/2012 ORG-5996-S1 CHANGE_INVALID_TYPE_TO_LONG
	bool GenerateTargetChannelData(vector& vChannel, int nTargetDataType, const Column& col);
	///---END IMPROVE_CONVERT_SAMPLE_BITS
private:
	string	m_strWks;
	int 	m_nC1;
	int 	m_nC2;
	//int		m_nCX;
	int		m_nR1;
	int		m_nR2;
	WAVSETTING m_Setting;
	
	double m_dMaxVolume;
	double m_dFactor;
};


#endif //_EXPORTWAV_H