 /*-----------------------------------------------------------------------------*
 * File Name: XVariable.h			 											*
 * Creation: Yuri	 															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION					*
 * Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS								*
 *	YuI 04/12/05 XVARIABLE_CONTEXT												*
 *	RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ								*
 *	YuI 06/07/05 QA70-7784 ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE			*
 *	CPY QA70-7895 7/15/05 XF_LT_FUNC_CALLS										*
 * EJP 2005-08-24 v8.0293 QA70-7996 IMPWIZ_SUPPORT_XFUNC						*
 *		Rename: GetTempInfo to GetRunTimeInfo									*
 *				WipeTempInfo to WipeRunTimeInfo									*
 *				TempInfoGetValue to GetRunTimeValue								*
 *				TempInfoSetValue to SetRunTimeValue								*
 *				GetBookSheetInfo to GetRunTimeBookSheetInfo						*
 *				SetBookSheetInfo to SetRunTimeBookSheetInfo						*
 *				UpdateBookSheetInfo to UpdateRunTimeBookSheetInfo				*
 *	YuI 08/24/05 SIMPLIFIED_RANGE_SPECIFICATION_FOR_LT_XFUNCTION				*
 *	ML 8/29/2005 QA70-7547 UNDOABLE_XF_EXECUTION								*
 *  Iris 9/13/05 XFUNCTION_ADD_REPORT_TREE										*
 *	YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS		*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO							*
 *------------------------------------------------------------------------------*/
#ifndef	_XVARIABLE_H
#define _XVARIABLE_H

////////////////////////////////////////////////
// class	XVariable
////////////////////////////////////////////////
// this class incapsulate information on every function argument
/*
class	XVariable
{
public:
	XVariable();
	XVariable(TreeNode& tr);
	~XVariable();
	
public:
	void	Construct(TreeNode& tr);
	BOOL	GetDeclarationString(string& strDeclaration);
	int		GetType();
	
	void	GetValue(double& dVal);
	void	GetValue(string& strVal);
	void	GetValue(int& nVal);
	void	GetTree(TreeNode& tr);
	void	GetDisplayValue(string& strVal);
	
	void	SetValue(double dVal);
	void	SetValue(string strVal);
	void	SetValue(int nVal);
	void	SetRangeVariableValue(LPCSTR lpcszValue);
	
	BOOL	SetValueFromOpRange(TreeNode &trInput, TreeNode &trOutput, int &nInputIndex, int &nOutputIndex);

	
	int		GetDesignation();
	void	SetIO(bool bInput, bool bOutput);
	bool	IsOutput(bool bExcludeInput=true);
	void	SetName(LPCSTR lpcszName);
	
	BOOL	GetDescriptiveValueString(string& strValue);
	string	GetTypeString(bool bAddRef = true); //CPY 3/18/05 all arg to XF must be pass by ref, so typically int will become int&
	string	GetName();
	string	GetValData();
	
	
	BOOL	IsGoodOperationInput();
	BOOL	IsGoodOperationOutput();
	
protected:	
	BOOL	GetDataRangeFromVariable(DataRange& dr);
	BOOL	IsConst();
	
private:
	TreeNode	m_tr;
};
*/

int get_xvar_type_from_type_name(LPCSTR lpcszTypeName);

/// YuI 06/29/05 XYRANGE_MAKEPLOT_IMPLEMENTATION
/// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
/*
typedef enum tagXVARTREETRANSLATIONCTRL
{
	XVTT_GET_VALDATA 	= 0x00000001,
	XVTT_GET_DATA 		= 0x00000002,
}	XVARTREETRANSLATIONCTRL;
*/
/// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
/// end XYRANGE_MAKEPLOT_IMPLEMENTATION

class XFuncAuxInfoBase;
class CallStackEx;
class XVarActionBase;
class XVariableContext;/// YuI 04/12/05 XVARIABLE_CONTEXT
class	XVariableBase
{
public:
	XVariableBase();
	XVariableBase(TreeNode& tr);
	~XVariableBase();
	
public:
	SetTree(TreeNode& tr);
	BOOL	GetDeclarationString(string& strDeclaration);
	virtual int		GetType()	{return XVT_DOUBLE;} // default value let be double
	void	GetValue(double& dVal);
	//--------- CPY 8/23/05 OUTPUT_VAR_TREE_ETC_CLEANUP
	//	/// YuI 07/21/05 SUBSTITUTE_UNASSIGNED_WITH_XVAR_NAME_IF_OUTPUT
	//	//	void	GetValue(string& strVal);
	//	BOOL	GetValue(string& strVal, BOOL bSubstituteUnassigned = FALSE);
	//	/// end SUBSTITUTE_UNASSIGNED_WITH_XVAR_NAME_IF_OUTPUT
	virtual BOOL	GetValue(string& strVal, int* pnPredefinedType = NULL);
	//---------
	void	GetValue(int& nVal);
	void	GetTree(TreeNode& tr);
	void	GetDisplayValue(string& strVal);
	
	TreeNode GetDescription(int nLanguage = 0);	//---- CPY 8/29/05 LOCALIZED_HELP_BRANCH

	virtual void	SetValue(double dVal);
	virtual void	SetValue(string strVal);
	virtual void	SetValue(int nVal);
	
	int		GetDesignation();
	void	SetIO(bool bInput, bool bOutput);
	bool	IsOutput(bool bExcludeInput=true);
	bool	IsInput(bool bExcludeOutput=true);
	void	SetName(LPCSTR lpcszName);
	
	virtual BOOL	GetDescriptiveValueString(string& strValue);
	///--- Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	virtual bool	GetBookSheet(string& strBook, string& strSheet){return false;}
	//--- End GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	
	//-------- CPY 11/12/05 XF_RESULTS_LOG_DUMP_MORE_USFUL_INFO
	int GetComboString(string& strCombo, bool bCvtBoolTrueFalse = false);
	//--------

	string	GetTypeString(bool bAddRef = true);
	string	GetName();
	virtual string	GetValData();
	
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	//	BOOL			SetValueFromOpRange(TreeNode &trInput, TreeNode &trOutput, int &nInputIndex, int &nOutputIndex);
	virtual BOOL	SetValueFromOpRange(TreeNode &trInput, TreeNode &trOutput, Array<DataRange&>* parrOutputs, int &nInputTreeIndex, int &nOutputTreeIndex, int &nOutputArrayIndex);
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES

	virtual void	SetValueFromOpRange(TreeNode &tr);
	
	virtual		BOOL	CanBeOperationInput()							{return FALSE;}
	virtual		BOOL	CanBeOperationOutput()							{return FALSE;}
	
	BOOL	IsGoodOperationInput();
	BOOL	IsGoodOperationOutput();
	
	virtual BOOL		PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0)				{return FALSE;}
	virtual BOOL		PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	BOOL				Cleanup();
	void				SetCleanupInfo(DataRange& dr);
	
	virtual void		SetFunctionAuxInfo(XFuncAuxInfoBase* pAuxInfo)										{}
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	//	virtual void		SetDataRanges(DataRange *pdrInput, DataRange *pdrOutput, bool bUpdateDataRanges)	{}
	virtual void		SetDataRanges(DataRange *pdrInput, Array<DataRange&>* parrOutputs, bool bUpdateDataRanges)	{}
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	virtual XVarActionBase*		CreateActionObject()														{return NULL;}
	virtual void		GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs){ vsHiddenIDs.Add(IDE_RESULT_DATA_BRANCH) ;}///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	
	
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual XVariableContext*	CreateContext();
	XVariableContext&	GetContext();
	virtual BOOL		UpdateContext()										{return TRUE;}
	virtual BOOL		UpdateValDataFromContext(int nRelativityLevel)		{return TRUE;}
	/// end XVARIABLE_CONTEXT
	
	/// YuI 06/28/05 TRANSLATION_OF_XVAR_BRANCH
	/// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	//	DWORD 				GetTreeTranlsationCtrl();
	/// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	
	/// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	/*
	virtual BOOL		GetTranslatedTree(TreeNode& tr);
	virtual BOOL		SetTranslatedTree(TreeNode& tr);
	*/
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/*
	virtual BOOL		GetTranslatedTree(TreeNode& trValData, TreeNode& trData);
	virtual BOOL		SetTranslatedTree(TreeNode& trValData, TreeNode& trData);
	*/
	
	virtual BOOL		GetTranslatedTree(TreeNode& trValData);
	virtual BOOL		SetTranslatedTree(TreeNode& trValData);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	/// end TRANSLATION_OF_XVAR_BRANCH
	
	///------- CPY 10/22/05 QA70-8006 XFUNCTION_AND_TREE_VARIABLE
private:
	void setOutputTreeAttributes(TreeNode& trOut, const string& strTreeValMoreInfo = NULL);//CPY 11/12/05 XF_RESULTS_LOG_DUMP_MORE_USFUL_INFO, added strTreeValMoreInfo
public:
	virtual void		UpdateOutputTree(TreeNode& trOut, DataRange& dr);
	virtual void		UpdateOutputTree(TreeNode& trOut, LPVOID pVal, int nXVT, const string& strVal);
	///------- end XFUNCTION_AND_TREE_VARIABLE

	BOOL SetRunTimeValue(LPCSTR lpcszBranch,LPCSTR lpcszKey, LPCSTR lpcszValue); 
	BOOL GetRunTimeValue(LPCSTR lpcszBranch,LPCSTR lpcszKey, string& strValue); 

	BOOL SetRunTimeBookSheetInfo(LPCSTR lpcszBranch, LPCSTR lpcszBook, LPCSTR lpcszSheet);
	BOOL GetRunTimeBookSheetInfo(LPCSTR lpcszBranch, string& strBook, string& strSheet);
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	BOOL SetRunTimeObjectInfo(LPCSTR lpcszBranch, LPCSTR lpcszObject);
	BOOL GetRunTimeObjectInfo(LPCSTR lpcszBranch, string& strObject);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	
	BOOL SetBookSheetInfo(LPCSTR lpcszBook, LPCSTR lpcszSheet);
	BOOL GetBookSheetInfo(string& strBook, string& strSheet);
	
	/// YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT
	//	BOOL				GetPrevVarNodeOfSameType(TreeNode& tr);
	BOOL				GetPrevVarNodeOfSameType(TreeNode& tr, BOOL bInputOnly = FALSE);
	/// end SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT

	/// YuI 11/18/05 LOOSEN_RESTRINCTION_ON_INPUT_SAME_FOR_REPORT_TREE
	BOOL				GetPrevInputVariable(TreeNode& tr);
	/// end LOOSEN_RESTRINCTION_ON_INPUT_SAME_FOR_REPORT_TREE
	
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	BOOL				IsNew();
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES

	virtual	int			ConvertToPredefinedType(string* pstr = NULL);
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL		GetCommandLogString(string& str);
	virtual BOOL		InitDataRangeFromRangeStringValue(SelfCreatingDataRange& dr, BOOL bInitFromTree = TRUE);
	BOOL				ResolveLooseDatasetRangeString(LPCSTR lpcszObjectDescriptor, TreeNode& trData);
	BOOL				ResolveRangeString(LPCSTR lpcszBranch, LPCSTR lpcszRangeString, TreeNode& trData);
	virtual DWORD 		GetRangeStringParseCntrl(BOOL bForCommandLog = FALSE);
	BOOL				ResolveRangeStringPageDescriptor(LPCSTR lpcszBranch, string& strDest, LPCSTR lpcszSource);
	BOOL				ResolveRangeStringLayerDescriptor(LPCSTR lpcszBranch, string& strDest, LPCSTR lpcszSource, LPCSTR lpcszPage);
	BOOL				ResolveRangeStringObjectDescriptor(LPCSTR lpcszBranch, string& strDest, LPCSTR lpcszSource, LPCSTR lpcszPage, LPCSTR lpcszLayer);
	virtual BOOL		ResolveRangeStringObjectDescriptorEx(LPCSTR lpcszBranch, string& strDest, LPCSTR lpcszDescriptor, Layer& ll);
	virtual BOOL		GetPrevVarBookSheetObject(LPCSTR lpcszBranch, string& strBook, string& strSheet, string& strObject, BOOL bInput);
	virtual BOOL		IsCompatiblePage(Page& pg)		{return TRUE;}
	virtual BOOL		InitActiveDataRange(SelfCreatingDataRange& dr, BOOL bInitFromTree);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
protected:
	TreeNode			GetRunTimeInfo();
	void				WipeRunTimeInfo();
	/// end XVARIABLE_SAME_IMPLEMENTATION	
	//---- CPY 6/27/05 XF_LT_ACTIVE_NEW_FIX
	bool	CheckResolveActiveInput(DataRange& dr); 
	virtual DWORD	GetDataRules() {return 0;}
	//----
	//--------- CPY 8/23/05 OUTPUT_VAR_TREE_ETC_CLEANUP, moved here from XVarSimple
	virtual int	SetOutputResult(LPVOID lpVal, int nXVT, TreeNode& trOutVars = NULL);	
	virtual void OnAfterSetOutputResult() {}
	//---------
protected:	
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
	BOOL			IsConst();

protected:
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	Array<XVariableContext&>	m_arrContext;
	/// end XVARIABLE_CONTEXT
	
	// this datarange holds whatever new was created
	// so in the event of XF failier we would be able to clean things after ourselves
	// must be part of bigger Undo mechanism
	//DataRange	m_drCleanup;
	TreeNode	m_tr;
};

// comon base class for simple and range variables
class	XVariableSimpleRangeBase	:	public	XVariableBase
{
public:
	XVariableSimpleRangeBase(TreeNode& tr);
	~XVariableSimpleRangeBase();
	
public:	
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	//	virtual void	SetDataRanges(DataRange *pdrInput, DataRange *pdrOutput, bool bUpdateDataRanges);
	virtual void		SetDataRanges(DataRange *pdrInput, Array<DataRange&>* parrOutputs, bool bUpdateDataRanges);
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	
	virtual XVariableContext*	CreateContext();
	
	
	/// YuI 05/23/05 XVARIABLE_SAME_IMPLEMENTATION
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	//	BOOL			CheckNewDataResolveBookSheet();
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	//virtual
	//int				ConvertToPredefinedType();
	/// end XVARIABLE_SAME_IMPLEMENTATION
	
	/// YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT
	BOOL			CheckResolveSameAsInput(TreeNode& trInput);
	BOOL			CheckResolveSameAsInput(string& strValue);
	/// end SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
	
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	void			MergeRangeToOutput(DataRange& dr);
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
protected:	
	DataRange*			m_pInput;
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	//	DataRange*			m_pOutput;
	Array<DataRange&>*	m_parrOutputs;
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	BOOL		m_bUpdateDataRanges;
};

//////////////////////////////////////////////////////
/// class	XVariableSimple
//////////////////////////////////////////////////////
class	XVariableSimple		:	public	XVariableSimpleRangeBase
{
public:
	XVariableSimple(TreeNode& tr);
	~XVariableSimple();

public:
	virtual XVarActionBase*		CreateActionObject();

	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual BOOL		UpdateContext();
	virtual BOOL		UpdateValDataFromContext(int nRelativityLevel);
	/// end XVARIABLE_CONTEXT
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL		GetCommandLogString(string& str);
	virtual BOOL		InitDataRangeFromRangeStringValue(SelfCreatingDataRange& dr, BOOL bInitFromTree = TRUE);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
protected:
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
	virtual void	GetResolvedValue(string& strVal);
	void			UpdateDataRanges();
	//---- CPY QA70-7895 7/15/05 XF_LT_FUNC_CALLS
	//int				SetOutputResult(string& strResult); //
	//virtual int	SetOutputResult(LPVOID lpVal, int nXVT, TreeNode& trOutVars = NULL);
	//virtual 
	void 	OnAfterSetOutputResult();
	//----
};
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
////--- CPY 6/29/05 possible values of SetOutputResult
//enum {XFSOR_VALDATA, XFSOR_EXTERNAL_DATA_RANGE, XFSOR_EXTERNAL_LT_VAR};
////----
/// end XVARIABLEBASE_TO_VC

//////////////////////////////////////////////////////
/// class	XVariableString
//////////////////////////////////////////////////////
class	XVariableString		:	public	XVariableSimple
{
public:
	XVariableString(TreeNode& tr);
	~XVariableString();
	//----- CPY 10/21/05 XF_DEFAULT_STR_VAR_SHOULD_WORK_SAME_AS_WHEN_SPECIFIED
	//	//---- CPY 10/4/05 QA70-7895 STR_VAR_FROM_XF_ALLOW_NO_$
	//	//virtual
	//	void	SetValue(string strVal);
	//	//----
protected:
	//	virtual 
	void	GetResolvedValue(string& strVal);
	//-----
private:
	bool	isPreferLTStrVar(); //CPY 11/21/05 STR_COMBO_SHOULD_STAY_AS_STR

public:
	virtual int		GetType()	{return XVT_STRING;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
};

//////////////////////////////////////////////////////
/// class	XVariableInt
//////////////////////////////////////////////////////
class	XVariableInt		:	public	XVariableSimple
{
public:
	XVariableInt(TreeNode& tr);
	~XVariableInt();
	
public:
	virtual int		GetType()	{return XVT_INT;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
};

//////////////////////////////////////////////////////
/// class	XVariableDouble
//////////////////////////////////////////////////////
class 	XVariableDouble		:	public	XVariableSimple
{
public:
	XVariableDouble(TreeNode& tr);
	~XVariableDouble();
	
public:
	virtual int		GetType()	{return XVT_DOUBLE;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
};

//////////////////////////////////////////////////////
/// class	XVariableRangeBase
//////////////////////////////////////////////////////
class	XVariableRangeBase	:	public	XVariableSimpleRangeBase
{
public:
	XVariableRangeBase(TreeNode& tr);
	~XVariableRangeBase();

public:	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL		GetCommandLogString(string& str);
	virtual BOOL		InitDataRangeFromRangeStringValue(SelfCreatingDataRange& dr, BOOL bInitFromTree = TRUE);
	virtual BOOL		ResolveRangeStringObjectDescriptorEx(LPCSTR lpcszBranch,string& strDest, LPCSTR lpcszDescriptor, Layer& ll);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	
protected:
	
	/// ML 8/29/2005 QA70-7547 UNDOABLE_XF_EXECUTION
	//bool	PrepareRangeForStack(SelfCreatingDataRange* pRange);
	bool	PrepareRangeForStack(SelfCreatingDataRange* pRange, DWORD dwOpts = 0);
	/// end UNDOABLE_XF_EXECUTION
	/// YuI 06/14/05 RANGEBASED_XVAR_ACTIVE_SUPPORT
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/*
	bool			CheckResolveActive(SelfCreatingDataRange& dr, BOOL& bResolved);
	*/
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/// end RANGEBASED_XVAR_ACTIVE_SUPPORT
	/// YuI 06/30/05 QA70-7837 AUTOUPDATE_XF_BASED_ANALYSIS
	virtual		BOOL	CanBeOperationInput()							{return TRUE;}
	virtual		BOOL	CanBeOperationOutput()							{return TRUE;}
	/// end AUTOUPDATE_XF_BASED_ANALYSIS
};

//////////////////////////////////////////////////////
/// class	XVariableRangeSimple
//////////////////////////////////////////////////////
class	XVariableRangeSimple	:	public	XVariableRangeBase
{
public:
	XVariableRangeSimple(TreeNode& tr);
	~XVariableRangeSimple();
	
public:
	virtual BOOL	GetDescriptiveValueString(string& strValue);
	///--- Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	virtual bool	GetBookSheet(string& strBook, string& strSheet) ;
	//---End	GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	virtual void	SetValueFromOpRange(TreeNode &tr);
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual BOOL		UpdateContext();
	virtual BOOL		UpdateValDataFromContext(int nRelativityLevel);
	/// end XVARIABLE_CONTEXT
	
	/// YuI 08/24/05 SIMPLIFIED_RANGE_SPECIFICATION_FOR_LT_XFUNCTION
	virtual void		SetValue(string strVal);
	/// end SIMPLIFIED_RANGE_SPECIFICATION_FOR_LT_XFUNCTION

protected:
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
};

//////////////////////////////////////////////////////
/// class	XVariableVector
//////////////////////////////////////////////////////
class	XVariableVector		:	public	XVariableRangeSimple
{
public:
	XVariableVector(TreeNode& tr);
	~XVariableVector();
	
public:
	virtual int		GetType()	{return XVT_VECTOR;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject();
	virtual void		GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs);///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/*
	/// YuI 05/23/05 XVARIABLE_SAME_IMPLEMENTATION
	BOOL			UpdateRunTimeBookSheetInfo();
	/// end XVARIABLE_SAME_IMPLEMENTATION
	*/
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual DWORD		GetRangeStringParseCntrl(BOOL bForCommandLog = FALSE);
	
protected:
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
	
	/// YuI 06/29/05 XVARIABLE_ACTIVE_CLEANUP
	// <active> get resolved before function call
	// as well as <new> gets created
	// this data range hold the infomation
	// on the vector location for pop
	SelfCreatingDataRange	m_dr;
	/// end XVARIABLE_ACTIVE_CLEANUP
};

//////////////////////////////////////////////////////
/// class	XVariableDataRange
//////////////////////////////////////////////////////
class	XVariableRange		:	public	XVariableRangeSimple
{
public:
	XVariableRange(TreeNode& tr);
	~XVariableRange();
	
public:
	virtual int		GetType()	{return XVT_DATARANGE;}	
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject();
	virtual void		GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs); ///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	
	/// YuI 12/15/05 QA70-8395 EXTENDING_COMPLEX_NOTATION_FOR_DATARANGE_CLASS
	virtual BOOL		GetTranslatedTree(TreeNode& trValData);
	virtual BOOL		SetTranslatedTree(TreeNode& trValData);
	/// end EXTENDING_COMPLEX_NOTATION_FOR_DATARANGE_CLASS
};

//////////////////////////////////////////////////////
/// class	XVariableMatrix
//////////////////////////////////////////////////////
class	XVariableMatrix		:	public	XVariableRangeBase
{
public:
	XVariableMatrix(TreeNode& tr);
	~XVariableMatrix();
	
public:
	virtual int		GetType()	{return XVT_MATRIX;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject();
	virtual void	GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs); ///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	/// YuI 11/21/05 QA70-7450 MATRIX_RANGE_SHOULD_BE_Z
	virtual DWORD	GetDataRules();
	/// end MATRIX_RANGE_SHOULD_BE_Z
	
private:
	/// YuI 11/21/05 QA70-7450 MATRIX_RANGE_SHOULD_BE_Z
	// this data range is simlar to vector XVariable one
	SelfCreatingDataRange	m_dr;
	/// end MATRIX_RANGE_SHOULD_BE_Z
};



//////////////////////////////////////////////////////
/// class	XVariableMatrixObject
//////////////////////////////////////////////////////
/*
class	XVariableMatrixObject	:	public	XVariableRangeBase
{
public:
	XVariableMatrixObject(TreeNode& tr);
	~XVariableMatrixObject();
	
public:
	virtual int		GetType()	{return XVT_MATRIXOBJECT;}	
	virtual BOOL	PushOnStack(CallStackEx& oStack);
	virtual BOOL	PopFromStack(CallStackEx& oStack, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject();
};
*/
//////////////////////////////////////////////////////
/// class	XVariableRangeComplex
//////////////////////////////////////////////////////
class	XVariableRangeComplex	:	public	XVariableRangeBase
{
public:
	XVariableRangeComplex(TreeNode& tr);
	~XVariableRangeComplex();
	
public:
	virtual BOOL	GetDescriptiveValueString(string& strValue);
	///--- Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	virtual bool	GetBookSheet(string& strBook, string& strSheet) ;
	//--- End GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	virtual string	GetValData();
	
	virtual void	SetValue(double dVal);
	virtual void	SetValue(string strVal);
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual void	SetValue(LPCSTR lpcsz1, LPCSTR lpcsz2, LPCSTR lpcsz3, BOOL bSingleWord);
	virtual BOOL	InitDataRangeFromRangeStringValue(SelfCreatingDataRange& dr, BOOL bInitFromTree = TRUE);
	virtual BOOL	ResolveMissingNodesInRangeTree(TreeNode& tr);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS

	virtual void	SetValue(int nVal);
	virtual void	SetValueFromOpRange(TreeNode &tr);

	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual XVariableContext*	CreateContext();
	/// end XVARIABLE_CONTEXT
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual DWORD 		GetRangeStringParseCntrl(BOOL bForCommandLog = FALSE);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
protected:
	virtual BOOL	GetDataRangeFromVariable(DataRange& dr);
};

//////////////////////////////////////////////////////
/// class	XVariableXYRange
//////////////////////////////////////////////////////
class	XVariableXYRange	:	public	XVariableRangeComplex
{
public:
	XVariableXYRange(TreeNode& tr);
	~XVariableXYRange();
	
public:
	virtual int		GetType()	{return XVT_XYDATARANGE;}
	virtual void	SetValue(string strVal);
	virtual void	SetValueFromOpRange(TreeNode &tr);
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject();
	virtual void		GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs); ///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual BOOL		UpdateContext();
	virtual BOOL		UpdateValDataFromContext(int nRelativityLevel);
	/// end XVARIABLE_CONTEXT
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual void	SetValue(LPCSTR lpcsz1, LPCSTR lpcsz2, LPCSTR lpcsz3, BOOL bSingleWord);
	virtual BOOL	ResolveMissingNodesInRangeTree(TreeNode& tr);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	
	/// YuI 06/14/05 RANGEBASED_XVAR_ACTIVE_SUPPORT
	//virtual 
	DWORD	GetDataRules();
	/// end RANGEBASED_XVAR_ACTIVE_SUPPORT
};


//////////////////////////////////////////////////////
/// class	XVariableXYZRange
//////////////////////////////////////////////////////
class	XVariableXYZRange	:	public	XVariableRangeComplex
{
public:
	XVariableXYZRange(TreeNode& tr);
	~XVariableXYZRange();
	
public:
	virtual int		GetType()	{return XVT_XYZDATARANGE;}	
	virtual void	SetValue(string strVal);
	virtual void	SetValueFromOpRange(TreeNode &tr);
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual XVarActionBase*		CreateActionObject(); 
	virtual void		GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs); ///Frank 4/7/05		MOVE_DATA_RANGE_SETTINGS_MEMBER_FUNCTION
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	virtual BOOL		UpdateContext();
	virtual BOOL		UpdateValDataFromContext(int nRelativityLevel);
	/// end XVARIABLE_CONTEXT
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual void	SetValue(LPCSTR lpcsz1, LPCSTR lpcsz2, LPCSTR lpcsz3, BOOL bSingleWord);
	virtual BOOL	ResolveMissingNodesInRangeTree(TreeNode& tr);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	/// YuI 06/14/05 RANGEBASED_XVAR_ACTIVE_SUPPORT
	//virtual 	
	DWORD GetDataRules();
	/// end RANGEBASED_XVAR_ACTIVE_SUPPORT
};


//////////////////////////////////////////////////////
/// class	XVariableInfoBase
//////////////////////////////////////////////////////
class	XVariableInfoBase	:	public	XVariableBase
{
public:
	XVariableInfoBase(TreeNode& tr);
	~XVariableInfoBase();

public:
	virtual void		SetFunctionAuxInfo(XFuncAuxInfoBase* pAuxInfo);
	
protected:
	//TreeNode	GetNextGraphObjTreeNode(DWORD *pdwUIDMain);
	TreeNode	GetNextInfoObjTreeNode(DWORD *pdwUIDMain);

protected:	
	XFuncAuxInfoBase*	m_pAuxInfo;
};


class	XVariableButtonInfo	:	public	XVariableInfoBase
{
public:
	XVariableButtonInfo(TreeNode& tr);
	~XVariableButtonInfo();
	
public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	
public:
	virtual int		GetType()	{return XVT_BUTTONINFO;}
};

class	XVariableTextInfo	:	public	XVariableInfoBase
{
public:
	XVariableTextInfo(TreeNode& tr);
	~XVariableTextInfo();

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	
public:
	virtual int		GetType()	{return XVT_TEXTINFO;}	
};

class	XVariableLineInfo	:	public	XVariableInfoBase
{
public:
	XVariableLineInfo(TreeNode& tr);
	~XVariableLineInfo();

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);

public:
	virtual int		GetType()	{return XVT_LINEINFO;}	
};

class	XVariableEventInfo	:	public	XVariableInfoBase
{
public:
	XVariableEventInfo(TreeNode& tr);
	~XVariableEventInfo();

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);

public:
	virtual int		GetType()	{return XVT_EVENTINFO;}	
};

/// RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ
class	XVariableMarkerInfo	:	public	XVariableInfoBase
{
public:
	XVariableMarkerInfo(TreeNode& tr);
	~XVariableMarkerInfo();

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);

public:
	virtual int		GetType()	{return XVT_MARKERINFO;}	
};
/// end MARKER_GROBJ

/// RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO
class	XVariableRectInfo	:	public	XVariableInfoBase
{
public:
	XVariableRectInfo(TreeNode& tr);
	~XVariableRectInfo();

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);

public:
	virtual int		GetType()	{return XVT_RECTINFO;}	
};
/// end IMPLEMENT_RECTINFO

//////////////////////////////////////////////////////////////
/// class	XVariableHelper
//////////////////////////////////////////////////////////////
class	XVariableHelper
{
public:	
	XVariableHelper(TreeNode& tr);
	~XVariableHelper();
	
public:
	XVariableBase*	Var();
private:
	// in fact there is only one var in this array
	// it is only for destruction when not needed
	XVariableBase* m_pVar;
	Array<XVariableBase&>	m_arrVars; //garbage collector
};


XVariableBase*	CreateXVariable(TreeNode& trVar);
bool	is_excel_formatted_string(LPCSTR lpcszXtr);
bool 	is_col_formatted_string(LPCSTR lpcszStr, string& strVal = NULL);


////////////////////////////////////////////////////////////////////
// class	XVariableContext
////////////////////////////////////////////////////////////////////
typedef enum tagXVARRELATIVITYLEVEL
{
	XVRL_SAME_SHEET,	
	XVRL_SAME_BOOK,
	XVRL_DIFFERENT_BOOKS,
	XVRL_INVALID,
}	XVARRELATIVITYLEVEL;

#define	STR_ATTRIB_XVAR_CONTEXT_BOOK			"_XVAR_CONTEXT_BOOK"
#define	STR_ATTRIB_XVAR_CONTEXT_SHEET			"_XVAR_CONTEXT_SHEET"
#define	STR_ATTRIB_XVAR_CONTEXT_VAL				"_XVAR_CONTEXT_VAL"
////////////////////////////////////////////////////////////
// class	XVariableContextBase
////////////////////////////////////////////////////////////
class	XVariableContext
{
public:
	XVariableContext();
	XVariableContext(TreeNode& tr);
	~XVariableContext();
	
public:
	void	SetTree(TreeNode& tr);
	BOOL	GetBookName(string& strBook);
	BOOL	GetSheetName(string& strSheet);
	BOOL	GetRelativeSheet(string& strSheet);
	BOOL	GetValue(string& strValue);
	BOOL	GetResolvedString(string str, BOOL bAddSheet, BOOL bAddBook);
	int		Compare(XVariableContext& context);
	BOOL	GetMode(int& nMode);
	BOOL	SetMode(int nMode);
	
private:
	TreeNode	m_tr;
};

class	XVariableContextSimple	:	public	XVariableContext
{
};

class 	XVariableContextComplex	:	public	XVariableContext
{
};


/// YuI 05/11/05 XFUNCTION_ORIGINOBJECT_XVARIABLE
//////////////////////////////////////////////////////
/// class	XVariableOriginObject
//////////////////////////////////////////////////////
class	XVariableOriginObject		:	public	XVariableSimple
{
public:
	XVariableOriginObject(TreeNode& tr);
	~XVariableOriginObject();
	
public:
	virtual int		GetType()	{return XVT_ORIGINOBJECT;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	/// YuI 10/05/05 QA70-8156 IMAGE_MANIPULATION_UNDO_SUPPORT
	//	virtual BOOL	GetResolvedOriginObject(OriginObject& obj);
	virtual BOOL	GetResolvedOriginObject(OriginObject& obj, DWORD dwCntrl);
	/// end IMAGE_MANIPULATION_UNDO_SUPPORT
	BOOL			GetResolvedOriginObject(OriginObject& obj, string strPage, string strLayer, string strCollection, string strObject);
	virtual void	GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs);
	virtual void	UpdateRunTimeBookSheetInfo(OriginObject& obj);

	/// EJP 2005-08-24 v8.0293 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	//virtual 
	void SetValue(string strVal);
	/// end IMPWIZ_SUPPORT_XFUNC

	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL	GetCommandLogString(string& str);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	
protected:
	/// YuI 06/07/05 QA70-7784 ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE
	virtual OriginObject*	CreateOriginObject();
	/// end ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE	

	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	//	BOOL			CheckCreateNew(string& strBook, string& strSheet, string& strColumn);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
};


/////////////////////////////////////////////////////////////////
//	class	XVariableDataObject
/////////////////////////////////////////////////////////////////
// base class for matrix object and column for future convenience
class	XVariableDataObject		:	public	XVariableOriginObject
{
public:
	virtual	BOOL	CanBeOperationInput()							{return TRUE;}
	virtual	BOOL	CanBeOperationOutput()							{return TRUE;}
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	/// YuI 10/05/05 QA70-8156 IMAGE_MANIPULATION_UNDO_SUPPORT
	//	virtual BOOL	GetResolvedOriginObject(OriginObject& obj);
	virtual BOOL	GetResolvedOriginObject(OriginObject& obj, DWORD dwCntrl);
	/// end IMAGE_MANIPULATION_UNDO_SUPPORT
	
	virtual void	UpdateRunTimeBookSheetInfo(OriginObject& obj);
};

/////////////////////////////////////////////////////////////////
//	class	XVariableMatrixObject
/////////////////////////////////////////////////////////////////
class	XVariableMatrixObject	:	public	XVariableDataObject
{
public:
	XVariableMatrixObject(TreeNode& tr);
	~XVariableMatrixObject();
	
public:
	virtual int					GetType()	{return XVT_MATRIXOBJECT;}	
	virtual DWORD				GetDataRules();
	virtual XVarActionBase*		CreateActionObject();
	virtual DWORD				GetRangeStringParseCntrl(BOOL bForCommandLog = FALSE);
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL				ResolveRangeStringObjectDescriptorEx(LPCSTR lpcszBranch,string& strDest, LPCSTR lpcszDescriptor, Layer& ll);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
protected:
	virtual OriginObject*	CreateOriginObject();
};

/////////////////////////////////////////////////////////////////
//	class	XVariableColumn
/////////////////////////////////////////////////////////////////
class	XVariableColumn	:	public	XVariableDataObject
{
public:
	XVariableColumn(TreeNode& tr);
	~XVariableColumn();
	
public:
	virtual int					GetType()	{return XVT_COLUMN;}	
	virtual XVarActionBase*		CreateActionObject();
	
protected:
	virtual OriginObject*	CreateOriginObject();
};

/////////////////////////////////////////////////////////////////
//	class	XVariableWorksheet
/////////////////////////////////////////////////////////////////
class	XVariableWorksheet	:	public	XVariableOriginObject
{
public:
	XVariableWorksheet(TreeNode& tr);
	~XVariableWorksheet();
	
public:
	virtual int					GetType()	{return XVT_WORKSHEET;}	
	virtual BOOL				PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL				PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	
	/// YuI 10/05/05 QA70-8156 IMAGE_MANIPULATION_UNDO_SUPPORT
	//	virtual BOOL				GetResolvedOriginObject(OriginObject& obj);
	virtual BOOL				GetResolvedOriginObject(OriginObject& obj, DWORD dwCntrl);
	/// end IMAGE_MANIPULATION_UNDO_SUPPORT
	virtual XVarActionBase*		CreateActionObject();
	virtual void				GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs);
	virtual void				UpdateRunTimeBookSheetInfo(OriginObject& obj);
	virtual DWORD				GetRangeStringParseCntrl(BOOL bForCommandLog = FALSE);
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	virtual BOOL				IsCompatiblePage(Page& pg);
	virtual BOOL				InitActiveDataRange(SelfCreatingDataRange& dr, BOOL bInitFromTree);
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
protected:
	/// YuI 06/07/05 QA70-7784 ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE
	virtual OriginObject*	CreateOriginObject();
	/// end ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE	
};

/////////////////////////////////////////////////////////////////
//	class	XVariableWorksheet
/////////////////////////////////////////////////////////////////
class	XVariableDataplot	:	public	XVariableOriginObject
{
public:
	XVariableDataplot(TreeNode& tr);
	~XVariableDataplot();
	
public:
	virtual int					GetType()	{return XVT_DATAPLOT;}	
	virtual BOOL				PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL				PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	/// YuI 10/05/05 QA70-8156 IMAGE_MANIPULATION_UNDO_SUPPORT
	//	virtual BOOL				GetResolvedOriginObject(OriginObject& obj);
	virtual BOOL				GetResolvedOriginObject(OriginObject& obj, DWORD dwCntrl);
	/// end IMAGE_MANIPULATION_UNDO_SUPPORT
	virtual XVarActionBase*		CreateActionObject();
	virtual void				GetDataRangeSettings(vector<int> &vnShowIDs,vector<int> &vsHiddenIDs);
	virtual void				UpdateRunTimeBookSheetInfo(OriginObject& obj);
	
protected:
	/// YuI 06/07/05 QA70-7784 ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE
	virtual OriginObject*	CreateOriginObject();
	/// end ADDITIONAL_WORK_ON_ORIGIN_OBJECT_VARRIABLE	
};

/// YuI 08/12/05 QA70-8006 XFUNCTION_AND_TREE_VARIABLE
class	XVariableTree	:	public XVariableBase
{
public:	
	XVariableTree(TreeNode& tr);
	~XVariableTree();
	
public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	
	//virtual 
	BOOL	GetValue(string& strVal, int* pnPredefinedType = NULL);

public:
	virtual int		GetType()	{return XVT_TREE;}	
};
/// end XFUNCTION_AND_TREE_VARIABLE
/// end XFUNCTION_ORIGINOBJECT_XVARIABLE

/// Iris 9/13/05 XFUNCTION_ADD_REPORT_TREE
//	class	XVariableReportTree	:	public XVariableBase
class	XVariableReportTree	:	public XVariableSimple
{
public:	
	XVariableReportTree(TreeNode& tr);
	~XVariableReportTree();	

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual int		GetType()	{return XVT_REPORTTREE;}	
	virtual BOOL	SetValueFromOpRange(TreeNode &trInput, TreeNode &trOutput, Array<DataRange&>* parrOutputs, int &nInputTreeIndex, int &nOutputTreeIndex, int &nOutputArrayIndex);
	
protected:
	virtual BOOL	PrepareTargets(DWORD dwCntrl);
	void			UpdateTargets(ReportTree& trReport);
	
	BOOL			CheckResolveTargetWorksheet(LPCSTR lpcszDescriptor, DWORD dwCntrl);
	BOOL			CheckResolveTargetTree(LPCSTR lpcszDescriptor, DWORD dwCntrl);
	void			UpdateOperationDataRanges(TreeNode& tr);
	
protected:
	// gets resolved in "PushOnStack". May be invalid if not needed
	Worksheet		m_wksTarget;
	
	// gets resolved in "PushOnStack". May be empty if not needed. This is labtalk tree object to put results into
	string			m_strLTTreeName;
	
	BOOL			m_bToScriptWindow;
	BOOL			m_bToResultsLog;
	BOOL			m_bToNotes;
	string			m_strNotesName; //applicable only if m_bToNotes is true
};
///End XFUNCTION_ADD_REPORT_TREE


/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
class	XVariableReportData	:	public	XVariableReportTree
{
public:	
	XVariableReportData(TreeNode& tr);
	~XVariableReportData();		

public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	virtual int		GetType()	{return XVT_REPORTDATA;}	
	BOOL			PrepareTargetWks(ReportData& rd, DWORD dwCntrl);
};
/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES

/// YuI 08/29/05 QA70-7921 FILE_IMPORTING_XFUCNTIONS
class	XVariableFileLink	:	public	XVariableBase
{
public:	
	XVariableFileLink(TreeNode& tr);
	~XVariableFileLink();
	
public:
	virtual BOOL	PushOnStack(CallStackEx& oStack, DWORD dwOpts = 0);
	virtual BOOL	PopFromStack(CallStackEx& oStack, DWORD dwOpts, TreeNode& trOutVars = NULL);
	
public:
	virtual int		GetType()	{return XVT_FILELINK;}	

protected:	
	virtual		BOOL	CanBeOperationInput()							{return TRUE;}
	virtual		BOOL	CanBeOperationOutput()							{return TRUE;}
};
/// end FILE_IMPORTING_XFUCNTIONS

#endif //	_XVARIABLE_H
