/*------------------------------------------------------------------------------*
 * File Name: XFWizScript.c	 													*
 * Creation: Sim 03-20-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <xfutils.h>

#include <..\OriginLab\WizOperation.h>
#include <..\OriginLab\XFWizScript.h>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
XFWizRunModelScript::XFWizRunModelScript()
: XFWizRunModelBase()
{
	m_stXFMode.nXFType = XF_GETN_NONE;
	m_stXFMode.dwXFMode = LTXF_USE_FAST_ACCESS;
	m_stXFMode.dwExecute = LTXF_EXECUTE;
	m_stXFMode.nAddRecalculate = XFGETN_EX_NONE;
	m_stXFMode.nAddResultsLogOutput = XFGETN_EX_NONE;
}

XFWizRunModelRecalculate::XFWizRunModelRecalculate()
: XFWizRunModelScript()
{
	m_stXFMode.dwXFMode = LTXF_EXEC_RECALCULATE;
	m_stXFMode.dwExecute = LTXF_EXECUTE|LTXF_FROM_AUTO_UPDATE;
}


////XFWizScript::XFWizScript(XFCore	*pXFCore)
//XFWizScript::XFWizScript()
//{
	//XFCore *pXFCore = CreateXFCore();
	//ASSERT(pXFCore);
	//pXFCore->SetXFMode(LTXF_USE_FAST_ACCESS);
	//pXFCore->SetExecute(LTXF_EXECUTE);
	//
	//m_pXFWizTheme = CreateXFWizTheme();
	//ASSERT(m_pXFWizTheme);
	//m_pXFWizTheme->SetClassName(pXFCore->GetClassName());
	//m_pXFWizTheme->SetVersion(pXFCore->GetVersion());
	//
	//m_pXFWizIO = CreateXFWizInputOutputRange();
	//ASSERT(m_pXFWizIO);
	//
	//m_pXFWizNavg = new XFWizNavigation(pXFCore);
	//ASSERT(m_pXFWizNavg);
//}
//XFWizScript::~XFWizScript()
//{
	//XFCore *pXFCore = m_pXFWizNavg->GetXFCore();
	//
	//delete pXFCore; // This dialog is modeless. The XFCore object was created outside and passed into here.
	//delete m_pXFWizTheme;
	//delete m_pXFWizIO;
	//delete m_pXFWizNavg;
//}
////virtual
//XFCore* XFWizScript::CreateXFCore()
//{
	//XFCore *p = new XFCore;
	//return p;
//}
////virtual
//XFWizTheme* XFWizScript::CreateXFWizTheme()
//{
	//XFWizTheme *p = new XFWizTheme;
	//return p;
//}
////virtual
//XFWizInputOutputRange* XFWizScript::CreateXFWizInputOutputRange()
//{
	//XFWizInputOutputRange *p = new XFWizInputOutputRange;
	//return p;
//}
//
//int XFWizScript::UpdateOperation(DWORD dwUIDOp)
//{
	///*
	//XFCore* pXFCore = m_pXFWizNavg->GetXFCore();
	//ASSERT(pXFCore);
	//string strFile, strFunc;
	//if ( pXFCore->GetOPEntry(strFile, strFunc) )
	//{
		////PFNDoWizOp pfn = GetDoWizOp();
		////PFNDoWizOp pfn = Project.FindFunction(STR_WIZ_OP_FUNC, STR_WIZ_OP_FILE);
		////if ( pfn )
		////{
			//Tree trTheme;
			//m_pXFWizTheme->GetTree(trTheme);
			//
			//Tree trIOs;
			//m_pXFWizIO->GetTree(trIOs);
			//
			////return pfn(dwUIDOp, trTheme, trIOs, strFile, strFunc);
			//return DoWizardOperation(dwUIDOp, trTheme, trIOs, strFile, strFunc);
		////}
	//}
	//*/
	//return 0;
//}
////// This retrieves the function pointer which is used for initializing and updating operation.
////PFNDoWizOp XFWizScript::GetDoWizOp()
////{
	////PFNDoWizOp	pfn = Project.FindFunction("DoWizardOperation", "Originlab\\WizOperation.cpp");
	////
	////return pfn;
////}
//
//bool XFWizScript::IsRecalculate()
//{
	//return m_pXFWizTheme->IsHookOperation();
//}
//
//bool XFWizScript::Run(const TreeNode& trThemes, const TreeNode& trInputsOutputs, DWORD dwUIDOp)// = NULL, NULL, 0
//{
	//m_pXFWizIO->SetTree(trInputsOutputs);
	//m_pXFWizTheme->SetTree(trThemes);
	//
	//Page pgTarget;
	//if ( !m_pXFWizIO->GetTargetPage(pgTarget) )
	//{
		//pgTarget = Project.Pages();
	//}
	//
	//XFCore *pXFCore = m_pXFWizNavg->GetXFCore();
	//pXFCore->SetTargetPage(pgTarget);
	//
	//if ( IsRecalculate() )
	//{
		//pXFCore->SetXFMode(LTXF_EXEC_RECALCULATE);
		//pXFCore->SetExecute(LTXF_EXECUTE|LTXF_FROM_AUTO_UPDATE);
	//}
	//
	//m_pXFWizNavg->OnStart();
	//m_pXFWizNavg->InitWizard(m_pXFWizTheme, m_pXFWizIO);
	//if ( !m_pXFWizNavg->OnFinish() )
		//return false;
	//
	//UpdateOperation(dwUIDOp);
	//return true;
//}

XFWizScript::XFWizScript(XFWizManager &xfwizManager)
{
	m_pXFWizManager = &xfwizManager;
	ASSERT(m_pXFWizManager);
	
	if ( IsRecalculate() )
		m_pXFWizRM = new XFWizRunModelRecalculate;
	else
		m_pXFWizRM = new XFWizRunModelScript;
	ASSERT(m_pXFWizRM);
}
XFWizScript::~XFWizScript()
{
	//delete m_pXFWizManager;
	delete m_pXFWizRM;
}

bool XFWizScript::IsRecalculate()
{
	//return m_pXFWizManager->IsHookOperation();
	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	//return XFWIZ_MANAGER_MAP_THEME_CALL(m_pXFWizManager, IsHookOperation());
	return XFWIZ_MANAGER_MAP_CALL(m_pXFWizManager, IsHookOperation());
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
}

bool XFWizScript::Run()
{
	m_pXFWizManager->InitWizard(m_pXFWizRM);
	return m_pXFWizManager->OnFinish();
}
