/*------------------------------------------------------------------------------*
 * File Name: XFWizManager.h													*
 * Creation: Sim 11-28-2008														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD	*
 *	Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE								*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL										*
 *	Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
 *	Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE				*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *------------------------------------------------------------------------------*/

#ifndef __XF_WIZ_MAG_H__
#define __XF_WIZ_MAG_H__

#include <..\OriginLab\XFWizNavigation.h>

class XFWizManager
{
public:
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//XFWizManager(const TreeNode& trThemes = NULL, const TreeNode& trInputsOutputs = NULL, DWORD dwUIDOp = 0);
	XFWizManager(LPCSTR lpcszThemeName = NULL, const XFWizTheme *pXFWizTheme = NULL, const XFWizInputOutputRange *pXFWizIO = NULL, DWORD dwUIDOp = 0);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	~XFWizManager();
public:
	virtual void	Destroy();
	virtual bool	CreatePreview(Page& pg) {return false;}
	virtual string	GetClassName() {ASSERT(FALSE); return "";}
	
	//bool		Create(XFWizRunModelBase *pXFWizRM);
	bool		InitWizard(XFWizRunModelBase *pXFWizRM);
	BOOL		OnFinish();
	BOOL		OnCancel();		//------ Folger 12/10/08 v8.0984d REMOVE_ANALYSIS_MARKER_WHEN_CLICK_CANCEL_IN_WIZARD
	//BOOL		OnNext();
	//BOOL		OnPrev();
	
	BOOL		OnChangeStep(int nStep);
	
	//int			GetNumSteps();
	//int			GetStep();
	
	bool		SaveTheme(LPCSTR lpcszThemeName);
	bool		LoadTheme(LPCSTR lpcszThemeName);
 
	//bool		IsHookOperation();
	
	//XFWizNavigation*	GetNavigation() { return m_pXFWizNavg; }
	
	//bool		GetMapXFName(StringArray &saMapXFNames,	StringArray &saMapXFLabels);
	
	string		GetCurXFName(string& strXFDescription = NULL);
	TreeNode	GetCurXFTree();
	///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	string		GetCurXFLabel();
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	
	//void		SetTargetPage(const Page& pg);
	//bool		GetTargetPage(Page& pg);
	
	//bool		IsFromFile(string& strFileName);
	//
	//Function	GetEventHandler();
	
	string		GetRunDlgName()			{ return m_strRunDlgName; }
	
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
	bool		CompareTheme(LPCSTR lpcszThemeName, TreeNode& trDiff);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE

	///------ Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
	XFWizTheme*		GetWizTheme()		{ return m_pXFWizTheme; }
	///------ End SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER

	///------ Folger 11/03/09 BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE
	BOOL		IsHookOperation()		{ return 0 != m_dwUIDOp; }
	///------ End BETTER_CHECKING_FOR_RUNNING_PA_FROM_AUTO_UPDATE

protected:
	virtual double	GetVersion() {return DEFAULT_VERSION_NUMBER;}
 
	virtual XFCore*				CreateXFCore() { ASSERT(FALSE); return NULL; }
	virtual XFWizTheme*			CreateXFWizTheme() { ASSERT(FALSE); return NULL; }
	virtual XFWizInputOutputRange*		CreateXFWizInputOutputRange() { ASSERT(FALSE); return NULL; }
 
	///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
	//virtual bool	GetOPEntry(string &strFile, string &strFunc) {return false;}
	virtual bool	GetOPEntry(string &strFile, string &strFunc, string &strOPClass) {return false;}
	///---END FIX_WIZ_OPERATION_LABEL
	
	//virtual	bool	SetDefaultPath();
	//void		InitSteps(XFWizNavigation *pXFWizNavg);
	
	bool		SaveLastUsedTheme();
	int			UpdateOperation(DWORD dwUIDOp);

public:
	// these should are friendly for wizard dialog, script, no other else.
	// now only access them through XFWIZ_MANAGER_MAP_XX_CALL() macro
	XFCore					*m_pXFCore;
	XFWizTheme				*m_pXFWizTheme;
	XFWizInputOutputRange	*m_pXFWizIO;
	
	XFWizNavigation			*m_pXFWizNavg;
protected:
	
	XFWizRunModelBase		*m_pXFWizRM;
	
	DWORD					m_dwUIDOp;
	
	StringArray m_saDefaultXFNames;
	StringArray m_saMapXFNames;
	StringArray m_saMapXFLabels;
	
	string					m_strRunDlgName;
};

#define XFWIZ_MANAGER_MAP_CALL(_pXFWizManager_, _Call_)				_pXFWizManager_->_Call_
#define XFWIZ_MANAGER_MAP_NAVG_CALL(_pXFWizManager_, _Call_)		_pXFWizManager_->m_pXFWizNavg->_Call_
#define XFWIZ_MANAGER_MAP_CORE_CALL(_pXFWizManager_, _Call_)		_pXFWizManager_->m_pXFCore->_Call_
#define XFWIZ_MANAGER_MAP_THEME_CALL(_pXFWizManager_, _Call_)		_pXFWizManager_->m_pXFWizTheme->_Call_
#define XFWIZ_MANAGER_MAP_IORANGE_CALL(_pXFWizManager_, _Call_)	_pXFWizManager_->m_pXFWizIO->_Call_

#endif		//__XF_WIZ_MAG_H__
