/*------------------------------------------------------------------------------*
 * File Name:TXShowHelp.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
//--------------------------------------------------------------------------
// You can include just this typical header file for most Origin built-in
// functions and classes and it takes a reasonable amount of time to compile, 
// This file include most of the other header files except the NAG header, which
// takes longer to compile NAG routines.
//--------------------------------------------------------------------------

#ifndef _TXSHOWHELP_H
#define _TXSHOWHELP_H
#include "TXdisplayDlgBase.h"

#define TEMPLATE_FILE_NAME "TXTemplate.rtf"    // use RTF as TX has a bug for bookmark in doc


class TXDisplayDialog;
/**

*/
class XFTXDisplay : public BaseDocument
{
public:
	XFTXDisplay(TXDisplayDialog* pTXdlg)  
	{
		//m_pTxDisplayDlg->Create(GetWindow());//DoModalEx(GetWindow());
		//m_pTxDisplayDlg->ShowDialog();
		m_pTxDisplayDlg = pTXdlg;
	}
public:
	//bool OpenDoc(LPCSTR lpcszFile=NULL) {ASSERT(FALSE);}
	
	void SetTXDialog(TXDisplayDialog* pTXdlg)
	{
		m_pTxDisplayDlg = pTXdlg;
	}
	
	bool OpenTemplate(LPCSTR lpcszTemplate) 
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->OpenTemplate(lpcszTemplate);
		return false;
	}
	bool SaveDoc(LPCSTR lpcszFileName) 
	{
//		if ( m_pTxDisplayDlg )
//			m_pTxDisplayDlg->SaveAsFile(lpcszFileName);
//		if ( 0 == nSize )
//			return false;
		return true;
	}
	bool CloseDoc() 
	{
//		if ( m_pTxDisplayDlg )
//			m_pTxDisplayDlg->ShowDialog();
		return true;
	}
	bool CloseAllDoc() {ASSERT(FALSE);return true;}
	
	bool IsValid() {return true;}
	
	bool AddString(const string& str, LPCSTR lpcszTable=NULL, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL)
	{
		// no need table, should no need style handle neither
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->InsertTextSring(lpcszBookMark, str);
		return false;
	}
	///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	//bool AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL) 
	bool AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL, bool IsTable = false) 
	///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->InsertBinaryString(lpcszBookMark, vcDoc, TX_FILE_DOC);
		return false;
	}
	
	/// ----AW 11/03/05 ADD_HELP_SCREEN_SHOT
	bool AddImage(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark =NULL)
	{
		string strImgFileName;
		if ( m_strFileName.IsEmpty() )
		{
			ASSERT(FALSE);
			strImgFileName = STR_TEMP_IAMGE_FILE;
		}
		else
		{
			strImgFileName = m_strFileName + STR_IMAGE_FILE_EXT	
		}
		bool bRet = _save_doc(strImgFileName, vcDoc);
		if(!bRet)
			return error_report("Fail to save temp image file");
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->AddImage(vcDoc, lpcszBookMark, strImgFileName);
		return false;
	}
	/// ----END ADD_HELP_SCREEN_SHOT

	
	int GetTableIndexByBookMark( LPCSTR lpcszBookMark )
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->GetTableIndexByBookMark( lpcszBookMark );
		return 0;
	}
	
	BOOL FillTable(const vector<string>& vsVals, int nCols, int nTableIndex, int nNumTitleLine = 0, LPCSTR lpcszNewTableStyle = NULL) 
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->FillTable(vsVals, nCols, nTableIndex, nNumTitleLine, lpcszNewTableStyle);
		return false;
	}
	
	BOOL SplitCell(int nTableIndex, int nRowIndex, int nColIndex )	
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->SplitCell(nTableIndex, nRowIndex + 1, nColIndex );
		return false;
	}
	
	int InsertTable(const vector<string>& vsVals, int nCols, LPCSTR lpcszNewTableName=NULL, int nNumTitleLine = 0, LPCSTR lpcszNewTableStyle = NULL)
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->InsertTable(vsVals, nCols, lpcszNewTableName, nNumTitleLine, lpcszNewTableStyle);
		return 0;
	}

	///DG 9/15/05
	//virtual
	bool FillTable(const vector<string>& vsVals, int nCols, int& nTableIndex, LPCSTR lpcszTableBookMark=NULL, int nNumHeaderLine=0, LPCSTR lpcszCellBookMark=NULL)
	{
		bool bRet = true;
		//fill variable table
		nTableIndex = GetTableIndexByBookMark(lpcszTableBookMark);
		bRet = FillTable(vsVals, nCols, nTableIndex, nNumHeaderLine);	//variables tables, first row is title
		return bRet;
	}
	bool SplitTableCell(int nTableIndex=0, int nRow=0, int nCol=-1, int nCols=-1, LPCSTR lpcszTableBookMark=NULL, const vector<string>& vsVals=NULL, int nValCols=0, LPCSTR lpcszNewTableName=NULL, LPCSTR lpcszCellBookMark=NULL)
	{
		bool bRet = true;
		//fill variable option list table
		bRet &= SplitCell(nTableIndex, nRow, nCols);
		bRet &= InsertTable(vsVals, nValCols, lpcszNewTableName);
		return bRet;
	}
	///end
	
	//use book mark to search
	bool GetString(LPCSTR lpcszBookMark, string& str, bool bTableString=true)
	{
		ASSERT(FALSE);return true;
	}
	///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	//bool GetRichText(LPCSTR lpcszBookMark, vector<char>& vcDoc)
	bool GetRichText(LPCSTR lpcszBookMark, vector<char>& vcDoc, bool bIsTable = true)
	///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	{
		ASSERT(FALSE);return true;
	}
	
	bool DeleteSection(LPCSTR lpcszBookMark) 
	{
		if ( m_pTxDisplayDlg )
			return m_pTxDisplayDlg->DeleteSection(lpcszBookMark);
		return false;
	}
	
	virtual	bool CreateStyle(LPCSTR lpcszStyleName, DOC_STYLE& Style)
	{
		ASSERT(FALSE);return true;
	}
	bool SetFontColor(int nColorRGB)
	{
		ASSERT(FALSE);return true;
	}
protected:
	TXDisplayDialog* m_pTxDisplayDlg;
};


/**


*/
class TXDisplayDialog: public TXDisplayDlgBase
{
public:
	TXDisplayDialog(LPCSTR lpcszXFName, int nLanguage = IDRS_HELP_E) : TXDisplayDlgBase()
	{
		m_strXFName = lpcszXFName;
		m_nLanguage = nLanguage;
	}
	
//	int DoModalEx(HWND hParent);
//	virtual int  Create(HWND hParent = NULL);
	BOOL SetXFName(LPCSTR lpcszXFName, int nLanguage = IDRS_HELP_E)
	{
		m_strXFName = lpcszXFName;
		m_nLanguage = nLanguage;
		return true;
	}
	BOOL UpdateWin()
	{
		return OnReady();
	}

protected:
	
//EVENTS_BEGIN
//	ON_INIT(OnInitDialog)
//	ON_READY(OnReady)
//	ON_DESTROY(OnDestroy)
//	ON_SIZE(OnDlgResize)
//	ON_MENU_CMD(IDC_TX_MENU_PRINT, OnPrint)
//	ON_MENU_CMD(IDC_TX_MENU_SAVE, OnFileSave)
//	ON_MENU_CMD(IDC_TX_MENU_INSERT_EQUATION, OnInsertEquation)
//EVENTS_END
//	BOOL OnInitDialog();
	virtual BOOL OnReady();
//	BOOL OnDestroy(void);
//	BOOL OnDlgResize(int nType, int cx, int cy);
//	BOOL OnFileSave();
//	BOOL OnPrint();
//	BOOL OnInsertEquation();
//	BOOL OnOpen();

public:
	bool OpenTemplate(LPCSTR lpcszTemplate);
	bool FillTable(const vector<string>& vsVals, int nCols, int nTableIndex, int nNumTitleLine = 0, LPCSTR lpcszNewTableStyle = NULL);
	BOOL InsertBinaryString( LPCSTR strBookMark, vector<char>& vc, int nFormatID = TX_FILE_DOC);
	bool AddImage(const vector<char>& vcDoc, LPCSTR lpcszBookMark, LPCSTR lpcszFileName);
	BOOL InsertTextSring( LPCSTR strBookMark, string& strVal);
	BOOL DeleteSection(LPCSTR strBookMark);
	BOOL GetBookMarkPlace(LPCSTR strBookMark, BOOL bEnd = TRUE);
	BOOL SplitCell(int nTableIndex, int nRowIndex, int nColIndex );
	int InsertTable(const vector<string>& vsVals, int nCols, LPCSTR lpcszNewTableName=NULL, int nNumTitleLine = 0, LPCSTR lpcszNewTableStyle = NULL);
	int GetTableIndexByBookMark( LPCSTR lpcszBookMark );
	BOOL AddBookMark(LPCSTR lpcszBookMark);
	BOOL SelectTableCell(int nTableIndex, int nRowIndex, int nColIndex);
	BOOL PutCursorInTableCell(int nTableIndex, int nRowIndex, int nColIndex);
	
protected:
	
//	Object			m_txText;
	string			m_strXFName;
	int				m_nLanguage;
	
};





#endif // _TXSHOWHELP_H