/*------------------------------------------------------------------------------*
 * File Name:	XFShowHelp	 													*
 * Creation: 	AW 9/15/2005													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	AW 09/16/05 XF_TX_DISPLAY													*
 *	AW 10/30/2008 USER_NEW_ADDED_XF_DOCUMENT_NEED_TO_BE_SELECTED_AND_COPIED		*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "xfunctionEx.h" 
#ifdef _SMART_LOAD_ONLY
#include "XFDocument.h"
#endif
#include "BaseDocument.h"
//#include "XFTXDisplay.h"  /// AW 09/16/05 XF_TX_DISPLAY

#include "XFShowHelp.h"

static TXDisplayDialog* s_TXDisplayDlg;

/// AW 09/16/05 XF_TX_DISPLAY
//static bool display_xf_help_TX(LPCSTR lpcszXFname, int nLangID)
static bool display_xf_help_TX(const XFTXDisplay& oDoc, LPCSTR lpcszXFname, int nLangID)
/// END XF_TX_DISPLAY
{
	string strOXF, strFolder = GetAppPath();;
	if(okutil_find_file_from_map(&strOXF, SUPPORTFILE_XF, ORIGIN_PATH_UNDEF, lpcszXFname) == ORIGIN_PATH_UNDEF)
	{
		return out_str("Cannot Find X-Function");
	}
		
	XFunction xf;
	TreeNode trXF;    
	if(!xf.Load(&trXF, strOXF, LTXF_BY_FILENAME))
	{
		printf("err loading %s\n", strOXF);
		return false;    
	}
	
	/// AW 09/16/05 XF_TX_DISPLAY
	//XFTXDisplay oDoc(true);	//Prepare TXControl
	/// END XF_TX_DISPLAY

	if(!oDoc.IsValid())
	{
		return false;
	}
	//--- CPY 9/15/05 TX no need for multiple language
	/*
	DWORD dwOptions=XF2DOC_CLEAR_EMPTY;
	for(int jj = 0; jj < 1; jj++)
	{
		//diplay_xf_document(oDoc, xf, trXF, strJunk, vnLang[jj], dwOptions);
		create_xf_document(oDoc, xf, trXF, strJunk, vnLang[jj], dwOptions);
	}
	*/
	 create_xf_document(oDoc, trXF, strFolder, nLangID, XF2DOC_CLEAR_EMPTY);	
	return true;  
}

/*
int TXDisplayDialog::DoModalEx(HWND hParent)
{ 
	InitMsgMap();// will be called from internal later
	int nRet = DoModal(hParent);
	if(IDOK == nRet)
	{
		return 1;
	}
	return 0;
}	
int  TXDisplayDialog::Create(HWND hParent)
{
	InitMsgMap();
	//Launch the modeless dialog
	int nRet = ResizeDialog::Create(hParent);
	
	return nRet;
}


BOOL TXDisplayDialog::OnInitDialog()
{		
	ResizeDialog::OnInitDialog(0, "TX Diaply dialog"); // ??str for reg remembering dialog pos etc info
	
	Control TXTextControl;
	TXTextControl = GetItem(IDC_TX1);
	
	if(TXTextControl)
		m_txText = TXTextControl.GetActiveXControl();
	
	return true;
}	
*/

BOOL TXDisplayDialog::OnReady()
{
	SetInitReady(false);
	bool bRet = true;
	if ( m_txText )
	{
		try
		{
			m_txText.Load(okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+TEMPLATE_FILE_NAME, 0, TX_FILE_RTF);  // load template file
			m_txText.ViewMode = 0;
			/// AW 10/30/2008 USER_NEW_ADDED_XF_DOCUMENT_NEED_TO_BE_SELECTED_AND_COPIED
			//m_txText.EditMode = 2;  //readonly
			m_txText.EditMode = 1; 
			/// END USER_NEW_ADDED_XF_DOCUMENT_NEED_TO_BE_SELECTED_AND_COPIED
			//m_txText.EditMode = 0;
			XFTXDisplay		xfTXdisplay(this);
			/// AW 09/16/05 XF_TX_DISPLAY
			//return display_xf_help(xfTXdisplay, m_strXFName, m_nLanguage);
			if ( !display_xf_help_TX(xfTXdisplay, m_strXFName, m_nLanguage) )
				bRet =  FALSE;
			/// END XF_TX_DISPLAY
		}
		catch(int nError)
		{
			printf("failed to open %s", TEMPLATE_FILE_NAME);
			bRet = false;
		}
		
	}

	SetInitReady();
	ShowDialog(true);
	//---- CPY 10/18/05 TX_CONTROL_AUTO_SWITCH_KEYBOARD_LAYOUT
	//return true;
	TXDisplayDlgBase::OnReady();
	return bRet;
	//----
}

/*
BOOL TXDisplayDialog::OnOpen()
{
	//  some codes here to set m_strXFName and m_nLanguage;
	// update dialog
	return true;	
}

BOOL TXDisplayDialog::OnDestroy(void)
{
	ResizeDialog::OnDestroy();
	OnFileSave();
	return true;
}
BOOL TXDisplayDialog::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;

	PositionControl(IDC_TX1,0,0);
	SizeControl(IDC_TX1, cx, cy);
	return TRUE;
}

*/

bool TXDisplayDialog::OpenTemplate(LPCSTR lpcszTemplate) 
{
	try
	{
		m_txText.ViewMode = 0;
//		m_txText.Load(okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+TEMPLATE_FILE_NAME, 0, TX_FILE_RTF);  // load template file
	}
	catch(int nError)
	{
		printf("failed to open %s", TEMPLATE_FILE_NAME);
		return false;
	}
	return true;
}


BOOL TXDisplayDialog::InsertBinaryString( LPCSTR strBookMark, vector<char>& vc, int nFormatID)
{
		if ( GetBookMarkPlace( strBookMark) )
		{
			bool bOK = false;
			try
			{
				_VARIANT  var;
				var = vc.GetDataAsOneDimensionalArray();
				bOK =  m_txText.LoadFromMemory( var, TX_FILE_DOC, 1);
			}
			catch(int nError)
			{
				return error_report("failed to Insert BinaryString");
			}
			if ( bOK )
				return true;
			else
			{
				return error_report("Fail to load binary to file");
			}
		}
	return false;
}

/// ----AW 11/03/05 ADD_HELP_SCREEN_SHOT
bool TXDisplayDialog::AddImage(const vector<char>& vcDoc, LPCSTR lpcszBookMark, LPCSTR lpcszFileName)
{
	if ( GetBookMarkPlace( lpcszBookMark) )
	{
		bool bOK;
		try
		{
			bOK =  m_txText.ImageInsert(lpcszFileName, -1, 1, 0, 0, 100, 100, 3, 100, 100, 100, 100);
		}
		catch(int nError)
		{
			return error_report("Failed to Insert image");
		}
		if ( bOK )
			return true;
		else
		{
			return error_report("Fail to linsert image");
		}
	}
	return false;
}
/// ----END ADD_HELP_SCREEN_SHOT


BOOL TXDisplayDialog::InsertTextSring( LPCSTR strBookMark, string& strVal)
{
	if ( GetBookMarkPlace( strBookMark) )
	{
		try
		{
			m_txText.SelText  = strVal;
		}
		catch(int nError)
		{
			return error_report("failed to Insert TextString");
		}
		return true;
	}
	return false;
}
BOOL TXDisplayDialog::DeleteSection(LPCSTR strBookMark)
{
	if ( GetBookMarkPlace( strBookMark, FALSE ) )
	{
		return m_txText.FieldDelete(TRUE);
	}
	return FALSE;
}

BOOL TXDisplayDialog::GetBookMarkPlace(LPCSTR strBookMark, BOOL bEnd)
{
	bool bOK = true;;
	try
	{
		int nFieldID = 0;
		do 
		{
			nFieldID = m_txText.FieldNext(nFieldID, 0);
			if ( nFieldID > 0 )
			{
				string strtemp = m_txText.FieldData(nFieldID);
				if ( strtemp.Compare(strBookMark) == 0 )
					break;
			}
		}while ( nFieldID > 0 );
		if ( nFieldID > 0 )
		{
			m_txText.FieldCurrent = nFieldID;
			if ( bEnd )
			{
				m_txText.SelStart = m_txText.FieldEnd - 1 ;
	        	m_txText.SelLength = 0;	
			}
			else
			{
				m_txText.SelStart = m_txText.FieldStart - 1;
	        	m_txText.SelLength = m_txText.FieldEnd - m_txText.FieldStart + 1;
			}
		}
		else
		{
			string strErr;
			strErr.Format("Wrong book mark %s", strBookMark);
			bOK =  error_report(strErr);
		}
	}
	catch(int nError)
	{
		return error_report("failed to GetBookMark");
	}
	return bOK;
}

BOOL TXDisplayDialog::SplitCell(int nTableIndex, int nRowIndex, int nColIndex )
{
	return PutCursorInTableCell( nTableIndex, nRowIndex, nColIndex );
	//return m_txText.TableSplit(1);   /// there is no cellsplit
	return true;
	
}

int TXDisplayDialog::InsertTable(const vector<string>& vsVals, int nCols, LPCSTR lpcszNewTableName, int nNumTitleLine, LPCSTR lpcszNewTableStyle)
{
	int nTableIndex = 0;
	int nRows = nNumTitleLine + 1;
	try
	{
		int jjj=0;
		if(NULL != lpcszNewTableName)
		{
			int jjj=0;
			string strTemp = "\n";
			strTemp += lpcszNewTableName;
			m_txText.SelText = strTemp;
			m_txText.SelStart = m_txText.SelStart + m_txText.SelLength ;
		}
		//m_txText.SelLength = 0;
		nTableIndex = m_txText.TableInsert(nRows, nCols, m_txText.SelStart);
		if ( !FillTable( vsVals, nCols, nTableIndex, nNumTitleLine, lpcszNewTableStyle ) )
		{
			return 0;
		}
	}
	catch(int nErr) 
	{
		error_report("failed to insert table");
		return 0;
	} 
	return nTableIndex;
}

int TXDisplayDialog::GetTableIndexByBookMark( LPCSTR lpcszBookMark )
{
	
	int nTableIndex = 0;
	try
	{
		if ( GetBookMarkPlace(lpcszBookMark) )
		{
			nTableIndex = m_txText.TableAtInputPos;
		}
	}
	catch(int nErr) 
	{
		printf("failed to get Table index by bookMmark %s \n", lpcszBookMark);
		return 0;
	}
	
	return nTableIndex;
}

bool TXDisplayDialog::FillTable(const vector<string>& vsVals, int nCols, int nTableIndex, int nNumTitleLine, LPCSTR lpcszNewTableStyle) 
{
	if ( 0 == nTableIndex )  // no table available
	{
		ASSERT(false);
		return false;
	}
	int nSize = vsVals.GetSize();
	int nRows = nSize / nCols;
	
	int nRowIndex = nNumTitleLine + 1;  // Cell index start from 1 instead of 0
	int nColIndex = 1;
	PutCursorInTableCell(nTableIndex, nRowIndex , nColIndex);
	int nVarPos = 0;
	bool bOK;
	if ( nRows > 1 )
	{
		try
		{
			bOK = m_txText.TableInsertLines(2, nRows - 1);
		}
		catch(int nErr) 
		{
			return error_report("failed to split table");
		}
		ASSERT(bOK);
		if ( !bOK )
			return false;
	}
		
	for ( int ii = 1; ii <= nRows; ii++ )
	{
		nRowIndex = ii + nNumTitleLine;
		for ( int jj = 1; jj <= nCols; jj++, nVarPos++ )
		{
			try
			{

				m_txText.TableCellText(nTableIndex, nRowIndex, jj ) = vsVals[nVarPos];
			}
			catch(int nErr) 
			{
				return error_report("failed to inset table cell");
			}
		}

	}
	return true;
}

BOOL TXDisplayDialog::AddBookMark(LPCSTR lpcszBookMark)
{
	try
	{
		m_txText.FieldInsert("");
	    m_txText.FieldData(m_txText.FieldCurrent) = lpcszBookMark;
	    m_txText.SelLength = 0;		
	}
	catch(int nError)
	{
		return error_report("failed to add Bookmark");
	}
	return TRUE;
}

BOOL TXDisplayDialog::SelectTableCell(int nTableIndex, int nRowIndex, int nColIndex)
{
	try
	{
		m_txText.SelStart = m_txText.TableCellStart(nTableIndex, nRowIndex, nColIndex) - 1;
	    m_txText.SelLength = m_txText.TableCellLength(nTableIndex, nRowIndex, nColIndex) + 1;
	}
	catch(int nError)
	{
		return error_report("failed to select TableCell");
	}
	return TRUE;

}

BOOL TXDisplayDialog::PutCursorInTableCell(int nTableIndex, int nRowIndex, int nColIndex)
{
	try
	{
		m_txText.SelStart = m_txText.TableCellStart(nTableIndex, nRowIndex, nColIndex) + m_txText.TableCellLength(nTableIndex, nRowIndex, nColIndex) - 1;
	    m_txText.SelLength = 0;
	}
	catch(int nError)
	{
		return error_report("failed to put Cursor In TableCell");
	}
	return TRUE;
}
/*
BOOL TXDisplayDialog::OnFileSave()
{
	// temp file to check result for testing
	try
	{
		m_txText.Save(okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+"TXresult.rtf", 0, TX_FILE_RTF);
	}
	catch(int nError)
	{
		printf("failed to save TX file");
		return FALSE;
	}
	return TRUE;
}
BOOL TXDisplayDialog::OnPrint()
{
	// temp simple testing codes for print
	try
	{
		m_txText.PrintDoc("Test TX", 1, 2, 1);		
	}
	catch(int nError)
	{
		printf("failed to print");
		return FALSE;
	}
	return TRUE;		
}
BOOL TXDisplayDialog::OnInsertEquation()
{
	try
	{
		m_txText.ObjectInsert(TX_OLE_INSERT_OBJECT_WITH_PROGID, "Equation.3", -1, 0, 0, 0, 100, 100, 3, 100, 100, 100, 100);
	}
	catch(int nError)
	{
		printf("failed to InsertEquation");
		return FALSE;
	}
	return TRUE;
}
*/



void XFShowHelp(LPCSTR lpcszXFname)
{
	/// AW 09/16/05 XF_TX_DISPLAY
	//TXDisplayDialog myDlg(lpcszXFname, IDRS_HELP_E);
	//myDlg.Create(GetWindow());
	//myDlg.ShowDialog();
	if(!s_TXDisplayDlg)
	{
		s_TXDisplayDlg = new TXDisplayDialog(lpcszXFname, IDRS_HELP_E);
	}
	else
	{
		s_TXDisplayDlg->SetXFName(lpcszXFname, IDRS_HELP_E);
	}
	
	Window winDlg;
	
	winDlg =  s_TXDisplayDlg->GetWindow();
	if ( winDlg )
	{
		s_TXDisplayDlg->UpdateWin();
	}
	else
	{	
		s_TXDisplayDlg->Create(GetWindow());
	}
	/// END XF_TX_DISPLAY	
		
}

void testxf2()
{
	string str("qstats");
	XFShowHelp(str);
}

void testxf3()
{
	TXDisplayDialog myDlg("smooth", IDRS_HELP_E);
	myDlg.DoModalEx(GetWindow());
}


