/*------------------------------------------------------------------------------*
 * File Name: Wks_Utils.c														*
 * Creation: GJL 5/22/2002														*
 * Purpose: Origin C file containing Worksheet Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 09-30-2003 v7.5710 QA70-4073.63 FIX_FIND_EMPTY_TEXT_COL					*
 * Sim 05-09-2007 CHANGE_LABEL_TEXT_STYLE										*
 * Folger 06/22/07 ADD_WKS_PROPERTIES_FUNCTIONS									*
 * Folger 06/25/07 TRORIGIN_SETTING												*
 * Folger 06/25/07 REMOVE_NO_MORE_USE_CODE										*
 * Folger 06/27/07 FIX_BUG_WHEN_ROW_OR_COL_EMPTY								*
 * Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					* 
 * Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT								*
 * Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE								*
 * Jasmine 08/13/07 MAKE_APPLY_UNDOABLE											*
 * Jasmine 08/13/07 SET_SIZE_WILL_ADD_NON_EMPTY_ROW								*	
 * Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES										*
 * Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED		*
 *	TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog				*
 *	Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
 *	Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION	*
 *	Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION*
 *	Kyle 08/12/2009 QA80-12339-P7 WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
 *	Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH		*
 *	Kyle 01/19/2010 QA80-14940-P2 DEFAULT_ROW_HEIGHT_AND_COLUMN_WIDTH_ACCEPT_INTEGER_VALUES
 *	Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT			*
 *	Kit 10/20/2011 ORG-4167-P1 WKS_PROPERTIES_DEFAULT_WOULD_NOT_DISPLAY			*
 *	Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
 *  Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB*
 *------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////////////////////////
// Included header files
//////////////////////////////////////////////////////////////////////////////////
//
#include <origin.h>       // EXIST_ codes
///Folger 06/22/07 ADD_WKS_PROPERTIES_FUNCTIONS
#include <GetNBox.h>
#include "OriginEvents.h" 
#include "okThemeID.h"
#include "theme_utils.h"
#include "TextFormat.h"
///End ADD_WKS_PROPERTIES_FUNCTIONS
#include "wks_utils.h"	// Function prototypes and non-localized constants
///Folger 06/25/07 REMOVE_NO_MORE_USE_CODE

//All useless code has been removed

///End REMOVE_NO_MORE_USE_CODE

///Folger 06/22/07 ADD_WKS_PROPERTIES_FUNCTIONS
enum{
	WKS_PROP_SHOW_UDL_ID = OC_MENURANGE_BEGIN + MAX_WKS_PROPS,
	WKS_PROP_ROW_NUMBER_ID,
	WKS_PROP_COL_NUMBER_ID,	
	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
	WKS_PROP_COL_HEAD_HEIGHT_ID,
	WKS_PROP_ROW_HEAD_WIDTH_ID, 
	WKS_PROP_ROW_HEIGHT_ID, 
	WKS_PROP_COL_WIDTH_ID
	///End ONLY_APPLY_CHANGE
};

///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
string construct_text_format_apply_to_list(const Worksheet& wks)
{
	string strHeaders = get_show_headers(wks);
	string strLabels = get_show_label_names(wks);
	string strList = _L(E_STR_STANDARD);
	if(!strLabels.IsEmpty())
		strList += "|" + GetLocalized(E_STR_COLLABEL);
	strList += "|" + GetLocalized(E_STR_DATA);
	if(!strHeaders.IsEmpty())
		strList += "|" + strHeaders;
	if(!strLabels.IsEmpty())
		strList += "|" + strLabels;
	return strList;		
}
///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION

void construct_wks_properties_tree(const Worksheet &wks, TreeNode &tr)
{
	//View
	Worksheet wksheet(wks);
	WksAccess wksView(wksheet);
	wksView.GetTree(tr);
	TreeNode trColLabels = tree_get_node_by_tagname(tr, "ColLabels", true);
	if(trColLabels.IsValid())
		trColLabels.Remove();
	//trColLabels.Btn.SetAttribute(STR_NAME_ATTRIB, wks.GetName());
	GETN_USE(tr)
	//Size
	GETN_BEGIN_BRANCH(SheetSize, _L("Size")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_STR(RowNum, _L("Row Number"), (string)wks.GetNumRows())		GETN_ID(WKS_PROP_ROW_NUMBER_ID)
		GETN_STR(ColNum, _L("Column Number"), (string)wks.GetNumCols())	GETN_ID(WKS_PROP_COL_NUMBER_ID)
	GETN_END_BRANCH(SheetSize)
	///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
	//GETN_BEGIN_BRANCH(WksMeasure, _L("Worksheet Measurement (% of Text Height)")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_BEGIN_BRANCH(WksMeasure, _L("Worksheet Measurement")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_STR(HintHeight, _L("Row Height is percentage of default row height(16)"), "")			GETN_HINT
		GETN_STR(HintWidth, _L("Column Width is percentage of default column width(67)"), "")		GETN_HINT
	///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
		GETN_STR(ColHeaderHeight, _L("Column Header Height"), "150")	GETN_ID(WKS_PROP_COL_HEAD_HEIGHT_ID)//GETN_ID(OTID_GRID_DIM_SIZES)//temp	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
		GETN_STR(RowHeaderWidth, _L("Row Header Width"), "130")		GETN_ID(WKS_PROP_ROW_HEAD_WIDTH_ID)	//GETN_ID(OTID_GRID_DIM_SIZES)	///Jasmine 07/25/07 WKS_HEADER_LABEL_MODIFICATION
		GETN_STR(TopGap, _L("Gap From Top"), "0")								GETN_ID(OTID_GRID_GAPFROMTOP)
		///Folger 06/27/07 FIX_BUG_WHEN_ROW_OR_COL_EMPTY
		//GETN_STR(AllRowHeight, _L("All Rows Height"), "" + wks_get_cell_heights(wks, 0, wks.GetNumRows() - 1, false, false))	GETN_ID(WKS_PROP_ROW_HEIGHT_ID)
		//GETN_STR(AllColWidth, _L("All Columns Width"),"" + wks_get_cell_heights(wks, 0, wks.GetNumCols() - 1, true, false))		GETN_ID(WKS_PROP_COL_WIDTH_ID)
		GETN_STR(AllRowHeight, _L("All Rows Height"), "" + (wks.GetNumRows() ? wks_get_cell_heights(wks, 0, wks.GetNumRows() - 1, false, false) : 0))	GETN_ID(WKS_PROP_ROW_HEIGHT_ID)
		GETN_STR(AllColWidth, _L("All Columns Width"),"" + (wks.GetNumCols() ? wks_get_cell_heights(wks, 0, wks.GetNumCols() - 1, true, false) : 0))		GETN_ID(WKS_PROP_COL_WIDTH_ID)
		///End FIX_BUG_WHEN_ROW_OR_COL_EMPTY
	//Format
	GETN_END_BRANCH(WksMeasure)
	GETN_BEGIN_BRANCH(TextControl, _L("Text Control")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
		//string strLabelList = "Data|" + get_show_label_names(wks);
		///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
		/////Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
//#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		//string strLabelList = E_STR_DATA;
		//string strHeaders = get_show_headers(wks);
		//if(!strHeaders.IsEmpty())
			//strLabelList += "|" + strHeaders;
		//string strLabels = get_show_label_names(wks);
		//if(!strLabels.IsEmpty())
			//strLabelList += "|" + strLabels;
//
		//strLabelList = _L(E_STR_STANDARD) + "|" + strLabelList;			///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
//#else // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		/////End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
		//string strLabelList = E_STR_DATA + '|' + get_show_label_names(wks);
		/////Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
//#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		/////End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
		////------ End LOCALIZE_BUILD_IN_LABLES
		//GETN_STRLIST(ApplyTo, _L("Apply To"), "Data", strLabelList);
		string strApplyToList = construct_text_format_apply_to_list(wks);
		///-----Kit 10/20/2011 ORG-4167-P1 WKS_PROPERTIES_DEFAULT_WOULD_NOT_DISPLAY
		//GETN_STRLIST(ApplyTo, _L("Apply To"), "Data", strApplyToList);
		GETN_STRLIST(ApplyTo, _L("Apply To"), _L("Data"), strApplyToList);
		///-----End WKS_PROPERTIES_DEFAULT_WOULD_NOT_DISPLAY
		///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
		///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		GETN_STR(Hint, _L("Standard refers to the global control for the whole sheet"), "")			GETN_HINT
#endif __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		construct_text_format_tree(GETN_CURRENT_NODE);
	GETN_END_BRANCH(TextControl)
	//Miscellaneous
	GETN_BEGIN_BRANCH(Other, _L("Miscellaneous")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_CHECK(AutoAddRows, _L("Auto Add Rows"), true)		GETN_ID(OTID_GRID_AUTOROWS)
		/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
		//GETN_CHECK(AutoResizeCell, _L("Auto Resize Cells "), 0)	GETN_ID(OTID_GRID_CNTRL)///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
		GETN_CHECK(AutoResizeCell, _L("Fit Sheet to Window"), 0)	GETN_ID(OTID_GRID_CNTRL)///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
		/// END REMOVE_SPACE_FOR_LOCATION_STRING
		/// Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
		GETN_CHECK(IgnoreHiddenRows, _L("Ignore Hidden Rows on Plotting and Analysis"), true)
		/// END ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	GETN_END_BRANCH(Other)
}

///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
string get_show_headers(const Worksheet& wks)
{
	string strLabels;
	vector<string> vsType;

	Grid grid;
	if(!grid.Attach(wks))
		return strLabels;

	if(grid.IsHeadersShown(false))		// row header
		vsType.InsertAt(0, GetLocalized(E_STR_ROWHEADER));
	if(grid.IsHeadersShown(true))		// col header
		vsType.InsertAt(0, GetLocalized(E_STR_COLHEADER));

	if(vsType.GetSize())
		strLabels.SetTokens(vsType, '|');
	return strLabels;
}
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

string get_show_label_names(const Worksheet &wks)
{
	string strLabels;
	Grid grid;
	if(!grid.Attach(wks))
		return strLabels;
	//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
	//vector<string> vsType = {"Long Name", "Units", "Comments", "Parameters", "User-Defined Parameters"};
	vector<string> vsType;
	vsType.Add(GetLocalized(E_STR_COL_FILTER)); ////Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	vsType.Add(GetLocalized(E_STR_LONGNAME));
	vsType.Add(GetLocalized(E_STR_UNITS));
	vsType.Add(GetLocalized(E_STR_COMMENTS));
	vsType.Add(GetLocalized(E_STR_PARAMETERS));
	vsType.Add(GetLocalized(E_STR_USER_DEFINED_PARAMETERS));

	///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	#ifdef		__REPLICATE_COLUMNS_SUPPORT__
	vsType.Add(GetLocalized(E_STR_REPLICATES));
	#endif		/// __REPLICATE_COLUMNS_SUPPORT__
	///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	//------ End LOCALIZE_BUILD_IN_LABLES
	
	///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	//vector<int> vnType = { RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM, RCLT_UDL
		/////------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		//#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		//, RCLT_REPLICATES
		//#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		/////------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	//};
	vector<int> vnType = {	RCLT_COL_FILTER, RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM, RCLT_UDL
		///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		, RCLT_REPLICATES
		#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	};
	///End ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	///------Jsamine 09/24/07 should find Parameters and User-Defined Parameters in a range
	///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	//vector<int> vnTypeUpper = {	RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM + PARAMS_MAX_NUM - 1, RCLT_MAX_TYPE};
	
	///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	//vector<int> vnTypeUpper = {RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM + PARAMS_MAX_NUM - 1, RCLT_MAX_UDL
		//#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		//, RCLT_REPLICATES
		//#endif		/// __REPLICATE_COLUMNS_SUPPORT__
	//};
	vector<int> vnTypeUpper = {RCLT_COL_FILTER,	RCLT_LONG_NAME, RCLT_UNIT, RCLT_COMMENT, RCLT_PARAM + PARAMS_MAX_NUM - 1, RCLT_MAX_UDL
		#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		, RCLT_REPLICATES
		#endif		/// __REPLICATE_COLUMNS_SUPPORT__
	};
	///End ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	vector<int> vnShowType;
	grid.GetShowLabels(vnShowType);
	for(int ii = vsType.GetSize() - 1; ii >=0; ii--)
	{
		vector<uint> vecIndex;
		if(1 > vnShowType.Find(vecIndex, vnType[ii], vnTypeUpper[ii]))
			vsType.RemoveAt(ii);
	}
	///------End
	

	if(vsType.GetSize())
		strLabels.SetTokens(vsType, '|');
	return strLabels;
}

///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
#define		Default_Column_Width		67.0
#define		Default_Row_Height			16.0
#define		Default_Font_Size			9.0
///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
 
bool get_wks_setting(const Worksheet &wks, TreeNode& tr)
{
	if(!tr.IsValid())
		return error_report("tr is invalid");

	///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH, clean up by the way
	/*
	int nAutoAddRows, nColHeaderHeight, nRowHeaderWidth, nTopGap, nAutoResizeCell;//nBlankMissing
	Tree trFmt;
	trFmt = wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);//trFmt = wks.GetFormat(FPB_DIMENSION|FPB_STYLE_FILL|FPB_OTHER, FOB_NAME_STYLE|FOB_DIMENSION, TRUE, TRUE);
	nAutoAddRows = tree_get_int_value_by_id(trFmt, OTID_GRID_AUTOROWS);	
	nAutoResizeCell = tree_get_int_value_by_id(trFmt, OTID_GRID_CNTRL); ///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX		
	///Jasmine 01/22/07 ADD_BLANK_MISSING
	//TreeNode trNameStyle = tree_get_node_by_tagname(trFmt, "NameStyle2", true), trBM;//ogData
	//if(trNameStyle.IsValid())
		//trBM = tree_get_node_by_tagname(trNameStyle, "BlankMissing", true);
	//if(trBM.IsValid())
		//nBlankMissing = trBM.nVal;
	//End ADD_BLANK_MISSING	
	nTopGap = tree_get_int_value_by_id(trFmt, OTID_GRID_GAPFROMTOP);
	vector<int> vn;
	TreeNode trHV = tree_get_node_by_tagname(trFmt, "Vertical", true);
	if(trHV && trHV.Size)
		vn = trHV.Size.nVals;
	nColHeaderHeight = vn[0];
	trHV = tree_get_node_by_tagname(trFmt, "Horizontal", true);
	if(trHV && trHV.Size)
		vn = trHV.Size.nVals;
	nRowHeaderWidth = vn[0];
	///Jasmine 03/20/07 LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
	TreeNode trColHeaderHeight = tree_get_node_by_tagname(tr, "ColHeaderHeight", true);
	trColHeaderHeight.strVal = (string)nColHeaderHeight;
	trColHeaderHeight.Enable = tree_get_node_by_tagname(tr, "ColHeader", true).nVal;
	TreeNode trRowHeaderWidth = tree_get_node_by_tagname(tr, "RowHeaderWidth", true);
	trRowHeaderWidth.strVal = (string)nRowHeaderWidth;
	trRowHeaderWidth.Enable = tree_get_node_by_tagname(tr, "RowHeader", true).nVal;
	///End LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
	tree_get_node_by_tagname(tr, "TopGap", true).strVal = (string)nTopGap;
	tree_get_node_by_tagname(tr, "AutoAddRows", true).nVal = nAutoAddRows;
	tree_get_node_by_tagname(tr, "AutoResizeCell", true).nVal = nAutoResizeCell == GC_CLIENT_RESIZE;///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
	*/
	int nAutoAddRows, nAutoResizeCell, nColHeaderHeight, nRowHeaderWidth, nTopGap, nAllRowHeight, nAllColWidth;

	Tree trFmt;
	trFmt = wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);

	nAutoAddRows = tree_get_int_value_by_id(trFmt, OTID_GRID_AUTOROWS);	
	nAutoResizeCell = tree_get_int_value_by_id(trFmt, OTID_GRID_CNTRL);
	tree_get_node_by_tagname(tr, "AutoAddRows", true).nVal = nAutoAddRows;
	tree_get_node_by_tagname(tr, "AutoResizeCell", true).nVal = nAutoResizeCell == GC_CLIENT_RESIZE;
	
	/// Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	tree_get_node_by_tagname(tr, "IgnoreHiddenRows", true).nVal = wks.IsIgnoreHiddenRow();
	/// END ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	
	double dDefColWidth = tree_get_double_value_by_id(trFmt, OTID_GRID_DEFAULT_COL_WIDTH, Default_Column_Width);
	double dDefRowHeight = tree_get_double_value_by_id(trFmt, OTID_GRID_DEFAULT_ROW_HEIGHT, Default_Row_Height);
	
	// Column Header Height
	vector<int> vn;
	TreeNode trHV = tree_get_node_by_tagname(trFmt, "Vertical", true);
	if(trHV && trHV.Size)
		vn = trHV.Size.nVals;
	nColHeaderHeight = vn[0];
	TreeNode trColHeaderHeight = tree_get_node_by_tagname(tr, "ColHeaderHeight", true);
	trColHeaderHeight.strVal = (string)nint(nColHeaderHeight * dDefRowHeight / Default_Row_Height);
	trColHeaderHeight.Enable = tree_get_node_by_tagname(tr, "ColHeader", true).nVal;

	// Row Header Width
	trHV = tree_get_node_by_tagname(trFmt, "Horizontal", true);
	if(trHV && trHV.Size)
		vn = trHV.Size.nVals;
	nRowHeaderWidth = vn[0];
	TreeNode trRowHeaderWidth = tree_get_node_by_tagname(tr, "RowHeaderWidth", true);
	trRowHeaderWidth.strVal = (string)nint(nRowHeaderWidth * dDefColWidth / Default_Column_Width);
	trRowHeaderWidth.Enable = tree_get_node_by_tagname(tr, "RowHeader", true).nVal;

	// Gap From Top
	nTopGap = tree_get_int_value_by_id(trFmt, OTID_GRID_GAPFROMTOP);
	TreeNode trTopGap = tree_get_node_by_tagname(tr, "TopGap", true);
	trTopGap.strVal = ftoa(nTopGap);

	// All Rows Height
	nAllRowHeight = wks.GetNumRows() > 0 ? wks_get_cell_heights(wks, 0, wks.GetNumRows() - 1, false, false) : DEFAULT_WKS_ROW_HEIGHT;
	TreeNode trAllRowHeight = tree_get_node_by_tagname(tr, "AllRowHeight", true);
	trAllRowHeight.strVal = (string)nint(nAllRowHeight * dDefRowHeight / Default_Row_Height);

	// All Columns Width
	nAllColWidth = wks.GetNumCols() > 0 ? wks_get_cell_heights(wks, 0, wks.GetNumCols() - 1, true, false) : DEFAULT_WKS_ROW_HEIGHT;
	TreeNode trAllColWidth = tree_get_node_by_tagname(tr, "AllColWidth", true);
	trAllColWidth.strVal = (string)nint(nAllColWidth * dDefColWidth / Default_Column_Width);
	///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
	
	string strTagName = convert_displayname_to_tagname(tree_get_node_by_tagname(tr, "ApplyTo", true));
	if(!strTagName.IsEmpty())
	{
		///Kyle 08/12/2009 QA80-12339-P7 WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
		/////Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		//TreeNode trHint = tree_get_node_by_tagname(tr, "Hint", true);
		//if(trHint)
		//{
			//trHint.Show = (0==strTagName.CompareNoCase(E_STR_STANDARD));
		//}
		/////End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		update_text_format_hint(tr, strTagName);
		///End WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
		get_text_format(wks, tr, strTagName + ".Style");
	}
	return true;
}

///Kyle 08/12/2009 QA80-12339-P7 WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS
void update_text_format_hint(TreeNode& tr, LPCSTR lpcszTagName)
{
	TreeNode trHint = tree_get_node_by_tagname(tr, "Hint", true);
	if(!trHint)
		return;
	///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	//vector<string> vsTagNames = {STR_NAMESTYLE_LONG_NAME, STR_NAMESTYLE_UNITS, STR_NAMESTYLE_SAMPLE_RATE, STR_NAMESTYLE_COMMENTS, STR_NAMESTYLE_PARAM, STR_NAMESTYLE_UDL, STR_NAMESTYLE_DATA, STR_NAMESTYLE_COL_HEADER, STR_NAMESTYLE_ROW_HEADER, STR_NAMESTYLE_STANDARD, STR_NAMESTYLE_COL_LABEL
		/////------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		//#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		//, STR_NAMESTYLE_REPLICATES
		//#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		/////------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	//};
	vector<string> vsTagNames = {STR_NAMESTYLE_FILTER, STR_NAMESTYLE_LONG_NAME, STR_NAMESTYLE_UNITS, STR_NAMESTYLE_SAMPLE_RATE, STR_NAMESTYLE_COMMENTS, STR_NAMESTYLE_PARAM, STR_NAMESTYLE_UDL, STR_NAMESTYLE_DATA, STR_NAMESTYLE_COL_HEADER, STR_NAMESTYLE_ROW_HEADER, STR_NAMESTYLE_STANDARD, STR_NAMESTYLE_COL_LABEL
		///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		, STR_NAMESTYLE_REPLICATES
		#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	};
	///End ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	vector<string> vsHints;
	vsHints.Add(_L("Priority on Apply: Filter > Column Labels > Standard"));///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	vsHints.Add(_L("Priority on Apply: Long Name > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: Units > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: SampleRate > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: Comments > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: Parameters > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: User-Defined Parameters > Column Labels > Standard"));
	vsHints.Add(_L("Priority on Apply: Data > Standard"));
	vsHints.Add(_L("Priority on Apply: Column Header > Standard"));
	vsHints.Add(_L("Priority on Apply: Row Header > Standard"));
	vsHints.Add(_L("Standard refers to the global control for the whole sheet"));
	vsHints.Add(_L("Priority on Apply: Column Labels > Standard"));
	///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	#ifdef		__REPLICATE_COLUMNS_SUPPORT__
	vsHints.Add(_L("Priority on Apply: Replicate Name > Column Labels > Standard"));
	#endif		/// __REPLICATE_COLUMNS_SUPPORT__
	///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT

	int nIndex = vsTagNames.Find(lpcszTagName, 0, true);
	string strHint;
	if(nIndex >= 0 && nIndex < vsHints.GetSize())
		strHint = vsHints[nIndex];
	
	trHint.SetAttribute(STR_LABEL_ATTRIB, strHint);
	trHint.Show = !strHint.IsEmpty();
}
///End WKS_PROPERTIES_FORMAT_INFORMED_HINT_FOR_APPLY_TO_OPTIONS


string convert_displayname_to_tagname(const TreeNode& tr)
{
	string strName;
	vector<string> vsNames;
	//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
	//vector<string> vsType = {"Long Name", "Units", "Sampling Interval", "Comments", "Parameters", "User-Defined Parameters", "Data"};
	vector<string> vsType;
	vsType.Add(E_STR_COL_FILTER);///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	vsType.Add(E_STR_LONGNAME);
	vsType.Add(E_STR_UNITS);
	vsType.Add(E_STR_SAMPLING_INTERVAL);
	vsType.Add(E_STR_COMMENTS);
	vsType.Add(E_STR_PARAMETERS);
	vsType.Add(E_STR_USER_DEFINED_PARAMETERS);
	vsType.Add(E_STR_DATA);
	//------ End LOCALIZE_BUILD_IN_LABLES
	//vector<string> vsTagName = {"NameStyle16", "NameStyle17", "NameStyle18", "NameStyle20", "NameStyle22", "NameStyle23", "NameStyle2"};	///Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE
	///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	vsType.Add(E_STR_COLHEADER);
	vsType.Add(E_STR_ROWHEADER);
	///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
	//vector<string> vsTagName = {"ogLongName", "ogUnit", "ogSampleRate", "ogComment", "ogParam", "ogUDL", "ogData", "Column Header", "Row Header"};
	vsType.Add(E_STR_STANDARD);
	///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	#ifdef		__REPLICATE_COLUMNS_SUPPORT__
	vsType.Add(E_STR_REPLICATES);
	#endif		/// __REPLICATE_COLUMNS_SUPPORT__
	///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	//vector<string> vsTagName = {STR_NAMESTYLE_FILTER, STR_NAMESTYLE_LONG_NAME, STR_NAMESTYLE_UNITS, STR_NAMESTYLE_SAMPLE_RATE, STR_NAMESTYLE_COMMENTS, STR_NAMESTYLE_PARAM, STR_NAMESTYLE_UDL, STR_NAMESTYLE_DATA, STR_NAMESTYLE_COL_HEADER, STR_NAMESTYLE_ROW_HEADER, STR_NAMESTYLE_STANDARD
		/////------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		//#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		//, STR_NAMESTYLE_REPLICATES
		//#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		/////------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	//};
	vector<string> vsTagName = {STR_NAMESTYLE_FILTER, STR_NAMESTYLE_LONG_NAME, STR_NAMESTYLE_UNITS, STR_NAMESTYLE_SAMPLE_RATE, STR_NAMESTYLE_COMMENTS, STR_NAMESTYLE_PARAM, STR_NAMESTYLE_UDL, STR_NAMESTYLE_DATA, STR_NAMESTYLE_COL_HEADER, STR_NAMESTYLE_ROW_HEADER, STR_NAMESTYLE_STANDARD
		///------ Folger 08/17/2011 ORG-3005-S2 GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
		#ifdef		__REPLICATE_COLUMNS_SUPPORT__
		, STR_NAMESTYLE_REPLICATES
		#endif		/// __REPLICATE_COLUMNS_SUPPORT__
		///------ End GROUP_ID_LABEL_ROW_MORE_GUI_SUPPORT
	};
	///End ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#else
	///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
	///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
	//vector<string> vsTagName = {"ogLongName", "ogUnit", "ogSampleRate", "ogComment", "ogParam", "ogUDL", "ogData"};
	vector<string> vsTagName = {"ogColFilter", "ogLongName", "ogUnit", "ogSampleRate", "ogComment", "ogParam", "ogUDL", "ogData"};
	///End ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
#endif ///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

	///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
	vsType.Add(E_STR_COLLABEL);
	vsTagName.Add("ogColLabel");
	///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION

	if(!tr.IsValid() || !tr.GetAttribute(STR_COMBO_ATTRIB, strName))
		return strName;
   	strName = tr.strVal;
   	if (strName.GetLength() == 1)
   	{
   		switch (strName[0])
   		{
   		case 'L':
   		case 'l':
   			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
   			//strName = "Long Name";
   			strName = E_STR_LONGNAME;
   			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
   			break;
   		case 'U':
   		case 'u':
   			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
   			//strName = "Units";
   			strName = E_STR_UNITS;
   			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
			break;
 		case 'C':
 		case 'c':
 			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
 			//strName = "Comments";
 			strName = E_STR_COMMENTS;
 			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
 			break;
		case 'P':
		case 'p':
			//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
			//strName = "Parameters";
			strName = E_STR_PARAMETERS;
			//------ End LOCALIZE_BUILD_IN_LABLES
			break;
		///Junon 17/09/2012 ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
		case 'f':
		case 'F':
			strName = E_STR_COL_FILTER;
			break;
		///End ORG-6825 ADD_FILTER_TO_WORKSHEET_PROPERTIES_DIALOGS_FORMAT_TAB
 		default:
 			break;
 		}
 	}
 	for(int ii = 0; ii < vsType.GetSize(); ii++)
 	{
 		//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
 		//if(!strName.CompareNoCase(vsType[ii]))
 		if(compare_string_localization(strName, vsType[ii]))
 		//------ End LOCALIZE_BUILD_IN_LABLES
 			return vsTagName[ii];
 	}
 	return "";
}

///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
static void _check_remove_nodes_not_in_ref_tree(TreeNode& tr, const TreeNode& trRef)
{
	if(!tr || !trRef)
		return;
	foreach(TreeNode cNode in tr.Children)//tr
	{
		if(cNode.GetNodeCount())			// branch
		{
			foreach(TreeNode cSubNode in cNode.Children)
			{
				TreeNode trNode = tree_get_node_by_tagname(trRef, cSubNode.tagName, true);	
				if(!trNode)
					cSubNode.Remove();
			}
			if(cNode.GetNodeCount() == 0)
				cNode.Remove();
			continue;
		}
		
		TreeNode trNode = tree_get_node_by_tagname(trRef, cNode.tagName, true);	
		if(!trNode)
			cNode.Remove();
	}
}

///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION

///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH, moving up
//#define		Default_Column_Width		67.0
//#define		Default_Row_Height			16.0
//#define		Default_Font_Size			9.0
///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH

static void _apply_text_settings(Worksheet& wks, TreeNode& trText, TreeNode& trOrigin)
{
	if(!trText)							// nothing changed
		return;
	
	string strTagName = convert_displayname_to_tagname(tree_get_node_by_tagname(trOrigin, "ApplyTo", true));
	if(strTagName.IsEmpty())		// error
		return;
	bool bStandard = strTagName.Compare(E_STR_STANDARD)==0;

	if(!bStandard)	// font and color settings are branched
	{
		TreeNode trFontControl = trText.FontControl;
		if(trFontControl)
		{
			TreeNode trOriginTextControl = trOrigin.TextControl.FontControl;
			if(trFontControl.Use != trOriginTextControl.Use)
				trFontControl.Use = trOriginTextControl.Use;
			if(trFontControl.Use)
			{
				trFontControl.Replace(trOriginTextControl);
				int nUndefined = false;
				if(trFontControl.Face.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined)
					trFontControl.Face.Remove();
				if(trFontControl.Size.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined)
					trFontControl.Size.Remove();
			}
			if(trFontControl.GetNodeCount()==0)
				trFontControl.Remove();
		}
		
		TreeNode trColorControl = trText.ColorControl;
		if(trColorControl)
		{
			TreeNode trOriginColorControl = trOrigin.TextControl.ColorControl;
			if(trColorControl.Use != trOriginColorControl.Use)
				trColorControl.Use = trOriginColorControl.Use;
			if(trColorControl.Use)
			{
				trColorControl.Replace(trOriginColorControl);
				int nUndefined = false;
				if(trColorControl.Color.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined)
					trColorControl.Color.Remove();
				if(trColorControl.FillColor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined) && nUndefined)
					trColorControl.FillColor.Remove();
			}
			if(trColorControl.GetNodeCount()==0)
				trColorControl.Remove();
		}
	}
	if(!trText || trText.GetNodeCount()==0)
		return;

	Tree trFmt;
	//trFmt = wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
	trFmt = wks.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE), TRUE, TRUE);
	TreeNode trTextFmt = theme_tree_get_node_by_name_strval(trFmt, strTagName);
	if(!trTextFmt)					// error
		return;
	if(!trTextFmt.Style)
		trTextFmt = trTextFmt.AddNode("Style");
	trTextFmt = trTextFmt.Style;
	ASSERT(trTextFmt);

	// special handle the font and color setting since its structure is different from theme tree
	if(bStandard)
	{
		if(trText.Face)
		{
			trTextFmt.Font.Face.nVal = trText.Face.nVal;
			trText.Face.Remove();
		}
		if(trText.Size)
		{
			trTextFmt.Font.Size.nVal = trText.Size.nVal;
			trText.Size.Remove();

			TreeNode trGrid = tree_get_node_by_tagname(trFmt, "Grid", true);
			if(trGrid)
			{
				double dFSize = trTextFmt.Font.Size.nVal;
				double dFactor = dFSize / Default_Font_Size;
				double dWidth = Default_Column_Width * dFactor;
				double dHeight = Default_Row_Height * dFactor;
	
				trGrid.DefaultColumnWidth.nVal = dWidth;
				trGrid.DefaultRowHeight.nVal = dHeight;
			}
		}
		if(trText.Color)
		{
			trTextFmt.Color.nVal = trText.Color.nVal;
			trText.Color.Remove();
		}
		if(trText.FillColor)
		{
			trTextFmt.Fill.FillColor.nVal = trText.FillColor.nVal;
			trText.FillColor.Remove();
		}
	}
	else
	{
		if(trText.FontControl)
		{
			if(trText.FontControl.Face)
				trTextFmt.Font.Face.nVal = trText.FontControl.Face.nVal;
	
			if(trText.FontControl.Size)
				trTextFmt.Font.Size.nVal = trText.FontControl.Size.nVal;
	
			trText.FontControl.Remove();
		}
		else if(trTextFmt.Font)
		{
			if(trTextFmt.Font.Face)
				trTextFmt.Font.Face.Remove();
			if(trTextFmt.Font.Size)
				trTextFmt.Font.Size.Remove();
		}
		
		if(trText.ColorControl)
		{
			if(trText.ColorControl.Color)
				trTextFmt.Color.nVal = trText.ColorControl.Color.nVal;
	
			if(trText.ColorControl.FillColor)
				trTextFmt.Fill.FillColor.nVal = trText.ColorControl.FillColor.nVal;
			
			trText.ColorControl.Remove();
		}
		else
		{
			if(trTextFmt.Color)
				trTextFmt.Color.Remove();
			if(trTextFmt.Fill && trTextFmt.Fill.FillColor)
				trTextFmt.Fill.FillColor.Remove();
		}
	}

	// remove special node for gui only
	if(trText.ApplyTo)
		trText.ApplyTo.Remove();
	if(trText.Hint)				// Hint won't be changed, just in case
		trText.Hint.Remove();
	if(trText.OriginTextControl)
		trText.OriginTextControl.Remove();

	foreach(TreeNode trProperty in trText.Children)
	{
		if(!trTextFmt.GetNode(trProperty.tagName))
			trTextFmt.AddNode(trProperty.tagName);
	}
	if(0 == wks.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag"))
	{
		octree_copy_values_by_id(&trText, &trTextFmt, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
		wks.ApplyFormat(STYLE_REPAINT | STYLE_RELATIVE | STYLE_UNDO | STYLE_COMPLETE, trFmt);
	}
}
///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION

#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS


/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
//bool set_wks_setting(Worksheet &wks, TreeNode& tr, TreeNode &trOrigin)
bool set_wks_setting(Worksheet &wks, TreeNode& tr, TreeNode &trOrigin, bool bRelyOnChangeAttribute)//= true
/// end LT_INVOKE_Worksheet_Properties_dialog
{
	///Folger 06/25/07 TRORIGIN_SETTING
	string strOldValue;
	//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
	//if(trOrigin.TextControl.Format.GetAttribute(STR_CHANGED_ATTRIB, strOldValue) || trOrigin.TextControl.Control.GetAttribute(STR_CHANGED_ATTRIB, strOldValue))
	//------
	/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
	//convert_gui_setting_to_theme(trOrigin);
	convert_gui_setting_to_theme(trOrigin, bRelyOnChangeAttribute);
	/// end LT_INVOKE_Worksheet_Properties_dialog
	octree_copy_values_by_id(&trOrigin, &tr, true, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);
	///End TRORIGIN_SETTING
	if(tr.View)
	{
		TreeNode trView = tr.View.Clone();
	 	TreeNode trColLabels = tree_get_node_by_tagname(trView, "ColLabels", true);
		if(trColLabels.IsValid())
			trColLabels.Remove();				
		WksAccess wksView(wks);
		if(wksView.IsValid())
			wksView.SetTree(trView);
	}
	octree_delete_nodes_by_missing_attribute(&tr, STR_CHANGED_ATTRIB);	///Jasmine 06/06/07 ONLY_APPLY_CHANGE
	bool bApply;
	Tree trFmt;
	trFmt = wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
	///Jasmine 02/27/07 ADD_AUTO_RESIZE_CELLS_CHECKBOX
	int nColHeaderHeight, nRowHeaderWidth, nAutoResizeCell;
	TreeNode trAutoSize = tr.FindNodeByAttribute(STR_DATAID_ATTRIB, OTID_GRID_CNTRL);
	if(trAutoSize)
	{
		bApply = true;
		nAutoResizeCell = tree_get_int_value_by_id(tr, OTID_GRID_CNTRL)? GC_CLIENT_RESIZE : 0;
		tree_set_int_value_by_id(trFmt, OTID_GRID_CNTRL, nAutoResizeCell);		
	}
	///End ADD_AUTO_RESIZE_CELLS_CHECKBOX	
	///Jasmine 03/20/07 LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
	vector<int> vn;
	TreeNode  trColHeaderHeight = tree_get_node_by_tagname(tr, "ColHeaderHeight", true);
	if(trColHeaderHeight)
	{
		TreeNode trHV = tree_get_node_by_tagname(trFmt, "Vertical", true);
		if(trHV && trHV.Size)
		{
			if(ENABLE == trColHeaderHeight.Enable)
			{
				bApply = true;
				vn = trHV.Size.nVals;
				///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
				//vn[0] = atoi(trColHeaderHeight.strVal);
				int nColHeaderHeight = atoi(trColHeaderHeight.strVal);
				if( nColHeaderHeight >= 0 )
				{
					double dSize = nColHeaderHeight * Default_Row_Height / tree_get_double_value_by_id(trFmt, OTID_GRID_DEFAULT_ROW_HEIGHT, Default_Row_Height);
					vn[0] = nint(dSize);
				}
				///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
				trHV.Size.nVals = vn;
			}
			else
				trHV.Remove();//not apply
		}
	}
	TreeNode trRowHeaderWidth = tree_get_node_by_tagname(tr, "RowHeaderWidth", true);
	if(trRowHeaderWidth)
	{
		TreeNode trHV = tree_get_node_by_tagname(trFmt, "Horizontal", true);
		if(trHV && trHV.Size)
		{ 
			if(ENABLE == trRowHeaderWidth.Enable)
			{
				bApply = true;
				vn = trHV.Size.nVals;
				///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
				//vn[0] = atoi(trRowHeaderWidth.strVal);
				int nRowHeaderWidth = atoi(trRowHeaderWidth.strVal);
				if( nRowHeaderWidth >= 0 )
				{
					double dSize = nRowHeaderWidth * Default_Column_Width / tree_get_double_value_by_id(trFmt, OTID_GRID_DEFAULT_COL_WIDTH, Default_Column_Width);
					vn[0] = nint(dSize);
				}
				///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
				trHV.Size.nVals = vn;
			}
			else
				trHV.Remove();//not apply
		}
	}
	///End LINK_UP_HEDER_SHOW_AND_SIZE_SETTING
	TreeNode trAutoRows =tr.FindNodeByAttribute(STR_DATAID_ATTRIB, OTID_GRID_AUTOROWS);
	if(trAutoRows)
	{
		bApply = true;
		tree_set_int_value_by_id(trFmt, OTID_GRID_AUTOROWS, trAutoRows.nVal);//tree_get_int_value_by_id(tr, OTID_GRID_AUTOROWS));
	}
	TreeNode trTopGap =tr.FindNodeByAttribute(STR_DATAID_ATTRIB, OTID_GRID_GAPFROMTOP);
	if(trTopGap)
	{
		bApply = true;
		tree_set_int_value_by_id(trFmt, OTID_GRID_GAPFROMTOP, trTopGap.nVal);//tree_get_int_value_by_id(tr, OTID_GRID_GAPFROMTOP));
	}
	int iRet;
	if(bApply)
		iRet = wks.ApplyFormat(trFmt, TRUE, TRUE, TRUE);	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
	
	///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	_apply_text_settings(wks, tr.TextControl, trOrigin);
#else // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION

	if(tr.TextControl && tr.TextControl.GetNodeCount())
	{
		string strTagName = convert_displayname_to_tagname(tree_get_node_by_tagname(trOrigin, "ApplyTo", true));
		if(!strTagName.IsEmpty())
		{	//get_text_format(wks, tr, strTagName + ".Style");	
			//convert_numeric_setting_node(tr);	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS
			TreeNode trText = tree_get_node_by_tagname(tr, "TextControl", true);	
			trFmt.Reset();
			trFmt = wks.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE), TRUE, TRUE);
			///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
			///Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE
			//TreeNode trTextFmt = tree_get_node_by_tagname(trFmt, strTagName, true);
			//if(trTextFmt && trTextFmt.Name)
				//strTagName = trTextFmt.Name.strVal;
			TreeNode trTextFmt = theme_tree_get_node_by_name_strval(trFmt, strTagName);
			///End NAME_STYLE_N_IS_NOT_RELIABLE
			trTextFmt = trTextFmt.Style;
			///End ADD_RICH_TEXT_CHEKBOX
			trTextFmt.WrapText.nVal = TRUE;
		    trTextFmt.AllowEnter.nVal = TRUE;
		    trTextFmt.Float.nVal = TRUE;
		    //trTextFmt.Flood.nVal = FALSE;	///Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD
		    trTextFmt.ReadOnly.nVal = FALSE///Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX
		    trTextFmt.Merge.nVal = GMC_NONE;
		    trTextFmt.BlankMissing.nVal = FALSE;
		    trTextFmt.Format.strVal = "";	///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS, default should be empty
#ifdef ADD_STYLE_CONTROL				
			///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
		    //tr.OriginTextControl.Type.Show = -1 < vsAllowControl.Find(strTagName);
		    trTextFmt.Control.strVal = strTagName.CompareNoCase("ogUnit")? "Edit Control":"Origin Text Edit";//"Origin Text";	///Folger 05/09/07 ADD_STYLE_CONTROL
		    ///End ADD_RICH_TEXT_CHEKBOX
#endif
			//---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT
			trTextFmt.Ellipsis.nVal = 0;
			//---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
			
			///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
			if(!trTextFmt.Color)
				trTextFmt.Color.nVal = -1;
			if(!trTextFmt.Fill || !trTextFmt.Fill.FillColor)
				trTextFmt.Fill.FillColor.nVal = -1;
			if(!trTextFmt.Font || !trTextFmt.Font.Size)
				trTextFmt.Font.Size.nVal = 12;
			if(!trTextFmt.Font || !trTextFmt.Font.Face)
				trTextFmt.Font.Face.nVal = 0;
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
			///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

			///Folger 04/12/07 FIX_NO_ID_CANNOT_APPLY_BUG
			//octree_copy_values_by_id(&trText, &trTextFmt, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
			//int iRet = wks.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
			iRet = wks.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
			octree_copy_values_by_id(&trText, &trTextFmt, true, STR_DATAID_ATTRIB, STR_ID_ATTRIB);
			///End FIX_NO_ID_CANNOT_APPLY_BUG
			//octree_delete_nodes_by_missing_attribute(&trFmt, STR_CHANGED_ATTRIB);//don't know why this will rename the label
			///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
			_check_remove_nodes_not_in_ref_tree(trTextFmt, trText);
#else // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
			///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
			foreach(TreeNode cNode in trTextFmt.Children)//tr
		    {
		    	TreeNode trNode = tree_get_node_by_tagname(trText, cNode.tagName, true);
	    		if(!trNode)
	    			cNode.Remove();
		    }
			///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
			///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

		    ///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
			/////Folger 05/09/07 ADD_STYLE_CONTROL
//#ifdef ADD_STYLE_CONTROL
		    //if (trText.Control.nVal == 1)
		    	//trTextFmt.Control.strVal = "Edit Control";
		    //else
		    	//trTextFmt.Control.strVal = "Origin Text";
//#endif
			/////End ADD_STYLE_CONTROL
			///End ADD_RICH_TEXT_CHEKBOX
			iRet = wks.ApplyFormat(trFmt, TRUE, TRUE, TRUE);///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		}
	}

	///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION

	///End ADD_WKS_MEASUREMENT_ETC_BRANCHES 
	if(tr.SheetSize && tr.SheetSize.GetNodeCount())
	{
		///Jasmine 08/13/07 SET_SIZE_WILL_ADD_NON_EMPTY_ROW
		TreeNode trRowNum = trOrigin.SheetSize.RowNum;
		TreeNode trColNum = trOrigin.SheetSize.ColNum;
		//if(trRowNum && trColNum)// && (trRowNum.GetAttribute(STR_CHANGED_ATTRIB, strOldValue) || trColNum.GetAttribute(STR_CHANGED_ATTRIB, strOldValue)))
			//wks.SetSize(atoi(trRowNum.strVal), atoi(trColNum.strVal));
		if(trColNum)
			///Sophy 9/29/2011 ORG-3969-P1 WORKSHEET_SETSIZE_FILL_MISSING_VALUE_IN_EXISTING_COLUMNS
			//wks.SetSize(wks.GetNumRows(), atoi(trColNum.strVal));
			wks.SetSize(-1, atoi(trColNum.strVal));
			///end WORKSHEET_SETSIZE_FILL_MISSING_VALUE_IN_EXISTING_COLUMNS
		if(trRowNum)
			wks.SetNumRows(atoi(trRowNum.strVal));
		///End SET_SIZE_WILL_ADD_NON_EMPTY_ROW
	}
	///Folger 04/25/07 ADD_SET_ALL_HEIGHT_WIDTH
	if (tr.WksMeasure && tr.WksMeasure.GetNodeCount())
	{
		TreeNode trAllRowHeight = tr.WksMeasure.AllRowHeight;
		if (trAllRowHeight)
		{
			///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
			//if (!is_numeric(trAllRowHeight.strVal))
			//{
				//trAllRowHeight.nVal = DEFAULT_WKS_ROW_HEIGHT;
			//}
			//wks_set_cell_heights(wks, 0, wks.GetNumRows() - 1, trAllRowHeight.nVal, false);
			if( is_numeric(trAllRowHeight.strVal) )
			{
				double dRealSize = trAllRowHeight.nVal * Default_Row_Height / 100.0;
				_wks_set_all_cell_heights(wks, dRealSize, false);
			}
			///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
		}
		TreeNode trAllColWidth = tr.WksMeasure.AllColWidth;
		if (trAllColWidth)
		{
			///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
			//if (!is_numeric(trAllColWidth.strVal))
			//{
				//trAllColWidth.nVal = DEFAULT_WKS_ROW_HEIGHT;
			//}
			//wks_set_cell_heights(wks, 0, wks.GetNumCols() - 1, trAllColWidth.nVal, true);
			if ( is_numeric(trAllColWidth.strVal) )
			{
				double dRealSize = trAllColWidth.nVal * Default_Column_Width / 100.0;
				_wks_set_all_cell_heights(wks, dRealSize, true);
			}
			///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
		}
	}
	
	/// Zech 04/23/2012 ORG-5529-S1 ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	if (trOrigin.Other)
	{
		TreeNode trIgnoreHidden = trOrigin.Other.IgnoreHiddenRows;
		if (trIgnoreHidden)
		{
			wks.SetIgnoreHiddenRow(trIgnoreHidden.nVal);
		}
	}
	/// END ADD_IGNORE_HIDDEN_ROWS_PROPERTY_TO_WORKSHEET_PROPERTIES
	return true;
}

///Kyle 01/13/2010 QA80-14940 SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH
static bool _wks_set_all_cell_heights(Worksheet& wks, double dRealSize, bool bCol)
{
	Tree tr;
	if( !wks_get_labels_show_theme(wks, tr) )
		return false;
	if( dRealSize <= 0 )
		return false;

	TreeNode trDim = tree_check_get_node(tr.Root, "Dimensions");
	TreeNode trHV, trDefSz;
	if(bCol)
	{
		trHV = tree_check_get_node(trDim, "Horizontal");
		trDefSz = tr.Root.DefaultColumnWidth;
	}
	else
	{
		trHV = tree_check_get_node(trDim, "Vertical");
		trDefSz = tr.Root.DefaultRowHeight;
	}

	vector<int> vn;
	if(trHV.Size)
		vn = trHV.Size.nVals;

	vector<int> vnShowTypes;
	Grid grid;
	if(grid.Attach(wks))
		grid.GetShowLabels(vnShowTypes, !bCol);
	int nLabelOffset = vnShowTypes.GetSize() + 1;//1: header

	if( vn.GetSize() != nLabelOffset )			// only the header
	{
		if( vn.GetSize() > nLabelOffset )
		{
			vn.SetSize(nLabelOffset);
		}
		else
		{
			int nOldSize = vn.GetSize();
			vn.SetSize(nLabelOffset);
			for( int ii = nOldSize; ii < nLabelOffset; ii++)
				vn[ii] = DEFAULT_WKS_ROW_HEIGHT;
		}
	}
	double dFactor = trDefSz.dVal / dRealSize;
	for(int ii=vn.GetSize()-1; ii>=0; ii--)
		vn[ii] = nint(vn[ii] * dFactor);

	Tree trTemp;
	if(bCol)
	{
		trTemp.Root.Dimensions.Horizontal.Size.nVals = vn;
		trTemp.Root.DefaultColumnWidth.dVal = dRealSize;
	}
	else
	{
		trTemp.Root.Dimensions.Vertical.Size.nVals = vn;
		trTemp.Root.DefaultRowHeight.dVal = dRealSize;
	}
	grid.UpdateThemeIDs(trTemp.Root);
	grid.ApplyFormat(trTemp, TRUE, TRUE, TRUE);

	return true;
}
///End SPEED_UP_SET_ROW_HEIGHT_AND_SET_COLUMN_WIDTH

///End ADD_WKS_PROPERTIES_FUNCTIONS
