/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 9/14/2011 ORG-3616-P5 FIX_CLEAR_DATA_NOT_CLEAR_EMBEDDED_GRAPHS			*
 * Iris 9/14/2011 ORG-3616-P8 REMOVE_CLEAR_ALL_DATA_MENU_FROM_MATRIX_NAGIVATE_DLG
 *	Folger 09/14/2011 ORG-3616-P7 FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE
 * Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING								*
 * Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU								*
 * Iris 9/27/2011 ORG-3616-S4 SHOW_PAGE_SHORT_NAME_AND_LONG_NAME_ON_DLG_TITLE	*
 * Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID				*
 * Iris 9/29/2011 ORG-3616-S3 SUPPORT_DRAG_AND_DROP_ON_MULTIPLE_SELECTIONS		*
 *	CPY 10/13/2011 ORG-3616-P11 WKS_NAVIGATE_DRAG_TO_REORDER_CRASHING			*
 * Iris 10/14/2011 ORG-3616-P11 FIX_DRAG_MULTI_ROWS_MOVE_WILL_CAUSE_CRASH		*
 *	Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET			*
 *	Bill 10/21/2011 ORG-3616-P14 MOVE_BEFORE_OPTION_SHOULD_DISABLE_THE_NEXT_SHEET_OF_THE_SELECTED_SHEET
 * Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE					*
 *	Bill 11/02/2011 ORG-3616-P18 ENTER_EDIT_MODE_WHEN_SINGLE_CLICK_TO_COMMENT_COLUMN
 *	Bill 12/22/2011 ORG-4682-P1 COMMENT_SHOULD_NOT_CLEARED_AFTER_DELETE_OR_MOVE_SHEET
 *	Folger 12/30/2011 ORG-4727-P1 CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG
 *	Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *  Iris 2/14/2012 ORG-5052-P1 FIX_APPLY_REORDER_BUTTON_STILL_DISABLE_AFTER_SORT*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include "MenuBase.h"
#include "WksMoveDlg.h"

#define STR_REG_GRID_COL_HIDDEN		"ColHidden"
#define NUM_FIXED_COL_WIDTH			400 


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
void SheetListView::Init(UINT uID, WndContainer &Dlg)
{
	SetDlgName(GetDlgName());	
	GridListControl::Init(uID, Dlg);
		
	/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	SetExplorerBar(flexExSortShow);
#else
	SetExplorerBar(flexExSort | flexExMoveRows);
#endif
	///End SUPPORT_ROW_MOVING
	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
	//m_flx.Editable = flexEDNone;
	SetEditable(flexEDKbdMouse);
	///End SET_COMMENTS_COLUMN_AS_EDITABLE
	SetAlternateRowColors();
	EnableMultiRowMove(true); /// Iris 9/29/2011 ORG-3616-S3 SUPPORT_DRAG_AND_DROP_ON_MULTIPLE_SELECTIONS
	
	string strHeaders = GetHeaders();
	int nCols = strHeaders.GetNumTokens('|');
	/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	SetCols(nCols);
#else
	SetCols(nCols+1);
	m_flx.FixedCols = 1; 
#endif
	///End SUPPORT_ROW_MOVING
	/// Iris 09/28/2011 ORG-3616 SUPPORT_KEYBOARD_NAVIGATION
	EnableNavigation(true); 
	SetNavigationCol(COL_NAME);
	///End SUPPORT_KEYBOARD_NAVIGATION
	
	for(int index = 0; index < nCols; index++)
	{
		SetColHeading(index, strHeaders.GetToken(index, '|'));
	}
	/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
	//const vector<uint> vnDefaultHidden = {0, 0, 0, 0, 0, 0, 0, 0, 0};
	vector<uint> vnDefaultHidden(COL_COUNT);
	vnDefaultHidden = 0;
	///End SUPPORT_ROW_MOVING
	InitColsShowHiddenFromReg(STR_REG_GRID_COL_HIDDEN, &vnDefaultHidden);
	
	Layer lay = Project.ActiveLayer();
	if( lay )
	{
		m_pg = lay.GetPage();
	}
	update(true);
}

SheetListView::~SheetListView()
{
	SaveColsShowHiddenToReg(STR_REG_GRID_COL_HIDDEN);
}

bool SheetListView::HasSelection(bool *pbOnlyOneSelection) //= NULL
{
	vector<uint> vnRows;
	if( GetSelRows(vnRows) )
	{
		if( NULL != pbOnlyOneSelection )
		{
			*pbOnlyOneSelection = (1 == vnRows.GetSize());
		}
		return true;
	}
	else
	{
		if( NULL != pbOnlyOneSelection )
			*pbOnlyOneSelection = false;
	}
	return false;
}

int  SheetListView::GetSheets(vector<string>& vsSheetName, vector<int>& vnIndex, vector<bool>& vbSelected)
{	
	vsSheetName.RemoveAll();
	vnIndex.RemoveAll();
	vbSelected.RemoveAll();	
	
	vector<uint> vnSel;
	getSelectedSheet(&vnSel);	
	
	foreach(Layer lay in m_pg.Layers)
	{		
		vsSheetName.Add(lay.GetName());
		
		int nLayIndex = lay.GetIndex();
		vnIndex.Add(nLayIndex + 1);
		
		vector<uint> vn;
		vbSelected.Add( vnSel.GetSize() > 0 && vnSel.Find(MATREPL_TEST_EQUAL, nLayIndex, vn) > 0 );		
	}
	return vsSheetName.GetSize();
}

void SheetListView::update(bool bInit)
{	
	vector<uint> vnSelRows;
	if( !bInit )
	{
		GetSelRows(vnSelRows);	
		SetBold(m_nBoldRow, -1, false);	
	}
	else
	{
		vector<int> vnIndices;
		m_pg.GetSelectedLayers(vnIndices);
		for(int nn = 0; nn < vnIndices.GetSize(); nn++)
		{
			vnSelRows.Add( vnIndices[nn] + GetRowOffset() );
		}
	}
	
	if( !m_pg )
	{
		SetRows(0);
		return;
	}

	vector<string> vsInfo;
	foreach(Layer lay in m_pg.Layers)
	{
		Datasheet datasheet(lay);
		getSheetInfo(datasheet, vsInfo);
	}
	
	// after update rows	
	SetRows(m_pg.Layers.Count()); 
	/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	SetTableValue(vsInfo, true);
#else
	m_flx.SetTableValue(&vsInfo, m_flx.Rows, m_flx.Cols - m_flx.FixedCols, m_flx.FixedRows, m_flx.FixedCols, true);
#endif
	///End SUPPORT_ROW_MOVING
	
	if( vnSelRows.GetSize() > 0 )
	{
		/// Iris 10/14/2011 ORG-3616-P11 FIX_DRAG_MULTI_ROWS_MOVE_WILL_CAUSE_CRASH
		//m_flx.Row = -1;
		RemoveSelection();
		///End FIX_DRAG_MULTI_ROWS_MOVE_WILL_CAUSE_CRASH
		
		for(int ii = 0; ii < vnSelRows.GetSize() && vnSelRows[ii] < GetRows() && vnSelRows[ii] >= GetRowOffset(); ii++)
			SetIsSelected(vnSelRows[ii], true);
	}
	
	Layer layActive = m_pg.Layers(-1);
	if( layActive )
	{
		m_nBoldRow = layActive.GetIndex() + GetRowOffset();
		SetBold(m_nBoldRow, -1, true);
	}
	ResizeCols();
#ifdef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	SetColWidth(COL_FIXED, NUM_FIXED_COL_WIDTH);
#endif //_SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
}

int SheetListView::getSelectedSheet(vector<uint>* pvnSel)
{
	if( NULL == pvnSel )
	{
		int nRow = GetSelectedRow();
		if( nRow >= GetRowOffset() )
		{
			return (int)atoi(GetCell(nRow, COL_INDEX)) - 1;
		}
	}
	else
	{
		vector<uint> vnRows;
		if( GetSelRows(vnRows) )
		{
			vector<uint> vnLayIndexes;
			for(int ii = 0; ii < vnRows.GetSize(); ii++)
			{
				vnLayIndexes.Add( (uint)atoi(GetCell(vnRows[ii], COL_INDEX)) - 1 );
			}
			if( NULL != pvnSel )
				*pvnSel = vnLayIndexes;
			return vnLayIndexes[0];
		}
	}
	return -1;
}

void SheetListView::appendOneSheetInfo(Datasheet& datasheet)
{
	if( datasheet )
	{
		vector<string> vsInfo;
		getSheetInfo(datasheet, vsInfo);
	
		AddOneRow();
		SetRowValues(GetRows()-GetRowOffset()-1, vsInfo);
	}
}

bool SheetListView::getSheetInfo(Datasheet& datasheet, vector<string>& vsInfo)
{
	if( !datasheet )
		return error_report("datasheet is invalid.");
	
	bool bIsHierarchy = datasheet.GetSystemParam(0) & WP_SHEET_HIERARCHY;
	
	string strHeaders = GetHeaders();
	int nNumHeaders = strHeaders.GetNumTokens('|');
	vector<string> vsOneSheetInfo;
	
	// sheet index
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
		vsOneSheetInfo.Add((string)(datasheet.GetIndex()+1));
	
	// sheet creation index
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
		vsOneSheetInfo.Add((string)(datasheet.GetCreationIndex()+1));
	
	// sheet name
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
		vsOneSheetInfo.Add(datasheet.GetName());
	
	// Column number
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
	{
		if( !bIsHierarchy )
		{
			vsOneSheetInfo.Add( GetNumObjects(datasheet) );
		}
		else
		{
			vsOneSheetInfo.Add("");
		}
	}
	
	// size
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
	{
		double dSize = datasheet.GetSize() / 1024.0;
		string strSize;
		strSize.Format("%.1f", dSize);
		vsOneSheetInfo.Add(strSize);
	}
	
	// comments
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
	{
		vsOneSheetInfo.Add(datasheet.GetComments());
	}
	
	// type
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
	{
		if( bIsHierarchy )
		{
			vsOneSheetInfo.Add(_L("Hierarchical Sheet"));
		}
		else
		{
			vsOneSheetInfo.Add(_L("Flat Sheet"));
		}
	}
	
	// source
	if( vsOneSheetInfo.GetSize() < nNumHeaders )
	{
      	string strSourceSheet;
		OperationBase &op = datasheet.GetSrcOperation();
	    if( op )
	    {
	        DataRange dr;
	        if( op.GetInput(dr) )
			{        
			    string strBook, strSheet;
				///------ Folger 09/14/2011 ORG-3616-P7 FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE
				//dr.GetBookSheet(strBook, strSheet, 0); // get the source of 1st range
				get_range_book_sheet(strBook, strSheet, dr);
				///------ End FAILED_TO_GET_BOOK_SHEET_STRING_FOR_MATRIX_BASED_RANGE
			    if( 0 == strBook.Compare(m_pg.GetName()) )
			    	strSourceSheet = strSheet;
			    else
			    	strSourceSheet = make_book_sheet_name(strBook, strSheet);
			}
		}
	    vsOneSheetInfo.Add(strSourceSheet);	
	}
	
	vsInfo.Append(vsOneSheetInfo);
	return true;
}	

bool SheetListView::IsMenuItemEnable(int nCmdID)
{
	bool bOnlyOneSelection;
	bool bHasSelection = HasSelection(&bOnlyOneSelection);
	
	bool bFirstRowSelected = false, bLastRowSelected = false;
	vector<uint> vnRows;
	if( GetSelRows(vnRows) )
	{
		vector<uint> vn;
		if( vnRows.Find(MATREPL_TEST_EQUAL, GetRowOffset(), vn) > 0 ) // already select the first
			bFirstRowSelected = true;
		
		if( vnRows.Find(MATREPL_TEST_EQUAL, GetRows() - 1, vn) > 0 ) // already select the last
			bLastRowSelected = true;
	}

	if( nCmdID >= IDR_MOVE_BEFORE_TO_BEGIN )
	{
		if( IDR_MOVE_BEFORE_TO_BEGIN == nCmdID )
			return true;
		
		int nSheet = nCmdID - IDR_MOVE_BEFORE_TO_BEGIN - 1;
		vector<string> vsSheetName;
		vector<int> vnIndex;
		vector<bool> vbSelected;
		GetSheets(vsSheetName, vnIndex, vbSelected);	
		
		if( nSheet < vbSelected.GetSize() )
			/// Bill 10/21/2011 ORG-3616-P14 MOVE_BEFORE_OPTION_SHOULD_DISABLE_THE_NEXT_SHEET_OF_THE_SELECTED_SHEET
			//return (bHasSelection && !vbSelected[nSheet]);
			return (bHasSelection && !vbSelected[nSheet] && !((nSheet > 0 && bOnlyOneSelection && vbSelected[nSheet - 1])));
			/// End MOVE_BEFORE_OPTION_SHOULD_DISABLE_THE_NEXT_SHEET_OF_THE_SELECTED_SHEET
		else
			return false;
	}
	else
	{
		switch(nCmdID)
		{
		case IDR_ACTIVATE:
			return bHasSelection && bOnlyOneSelection;
			
		case IDR_DUPLICATE:
		case IDR_DUPLICATE_WITHOUT_DATA:
		case IDR_CLEAR_DATA:
		case IDR_DELETE:
		case IDR_MOVE_TO_NEW_BOOK:
		case IDR_DUPLICATE_TO_NEW_BOOK:
			return bHasSelection;
			
		case IDR_MOVE_TO_BEGIN:
			return bHasSelection && !bFirstRowSelected;
			
		case IDR_MOVE_TO_END:
			return bHasSelection && !bLastRowSelected;
			
		case IDR_SET_CURRENT_ORDER_AS_SHEET_ORDER:
			return true;
			
		default:
			return error_report((string)nCmdID + " is invalid ID for menu enable checking");		
		}
	}
	return false;
}

/// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
bool SheetListView::IsSheetsReordered()
{
	vector<string> vsIndexes;
	bool bRet = GetColValues( COL_INDEX, vsIndexes, GetRowOffset() );
	if( vsIndexes.GetSize() <= 1 )
		return false;
	
	vector<int> vnIndexes;
	convert_string_vector_to_int_vector(vsIndexes, vnIndexes);
	
	vector<int> vnDiff;
	vnIndexes.Difference(vnDiff);
	
	double min, max;
	vnDiff.GetMinMax(min, max);
	
	return !(1 == min && 1 == max);
}
///End ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID

/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
bool SheetListView::ApplyChange()
{
	if( m_bIsCommentsEdit )
	{
		vector<string> vsComments;
		GetColValues( COL_COMMENTS, vsComments, GetRowOffset() );
		
		vector<string> vsIndexes;
		GetColValues( COL_INDEX, vsIndexes, GetRowOffset() );
		
		vector<int> vnIndexes;
		convert_string_vector_to_int_vector(vsIndexes, vnIndexes);
		
		for(int index = 0; index < vnIndexes.GetSize(); index++)
		{
			Layer lay = m_pg.Layers(vnIndexes[index]-1);
			ASSERT(lay);
			if( lay )
			{
				/// Iris 12/22/2011 ORG-4682-P1 TO_AVOID_APPLY_COMMENTS_CHANGE_COSE_TOO_MUCH_TIME
				if( 0 != vsComments[index].Compare(lay.GetComments()) )
				///End TO_AVOID_APPLY_COMMENTS_CHANGE_COSE_TOO_MUCH_TIME
				{
					lay.SetComments(vsComments[index]);
				}
			}
		}
		return true;
	}
	return false;
}
///End SET_COMMENTS_COLUMN_AS_EDITABLE

int	 SheetListView::findRow(int nLayIndex)
{
	vector<string> vsIndexes;
	bool bRet = GetColValues( COL_INDEX, vsIndexes );
	ASSERT(bRet);
	
	int index = vsIndexes.Find( (string)(nLayIndex + 1) );
	if( index >= 0 )
	{
		return index;
	}
	return -1;
}

void SheetListView::OnAfterRowReorder()
{
	Layer layActive = m_pg.Layers(-1);
	
	/// Bill 11/02/2011 ORG-3613-P19 RUNTIME_ERROR_WHEN_REORDER_AN_EMPTY_GRID
	if (!layActive)
		return;
	/// End RUNTIME_ERROR_WHEN_REORDER_AN_EMPTY_GRID
	
	m_nBoldRow = findRow(layActive.GetIndex());
}

void SheetListView::OnAfterSortCol()
{
	OnAfterRowReorder();
}

void SheetListView::ActivateSheet()
{
	int nRow = GetSelectedRow();
	int nLay = getSelectedSheet();
	Layer lay = m_pg.Layers(nLay);
	if( lay )
	{
		set_active_layer(lay);
		
		// update row bold status after change active sheet
		if( m_nBoldRow >= GetRowOffset() )
		{
			SetBold( m_nBoldRow, -1, false );
		}	
		
		m_nBoldRow = nRow;
		if( m_nBoldRow >= GetRowOffset() )
			SetBold(m_nBoldRow, -1, true);
	}
}

bool SheetListView::ClearAllData()
{
	vector<uint> vn;
	if( getSelectedSheet(&vn) >= 0 )
	{
		for(int index = 0; index < vn.GetSize(); ++index)
		{
			Layer lay = m_pg.Layers(vn[index]);
			Datasheet dsheet(lay);
			
			/// Iris 9/14/2011 ORG-3616-P5 FIX_CLEAR_DATA_NOT_CLEAR_EMBEDDED_GRAPHS
			//dsheet.ClearData();
			DWORD dwOptions = CWOD_CLEAR_EMBEDDINGS | CWOD_SHRINK_COLS | CWOD_CLEAR_OPERATIONS_OUTPUTS_ETC;
			dsheet.ClearData(dwOptions);
			//End FIX_CLEAR_DATA_NOT_CLEAR_EMBEDDED_GRAPHS
		}
		return true;
	}	
	return false;
}

bool SheetListView::DeleteSheet()
{	
	ApplyChange(); /// Bill 12/22/2011 ORG-4682-P1 COMMENT_SHOULD_NOT_CLEARED_AFTER_DELETE_OR_MOVE_SHEET

	string str;
	str.Format(EXIST_WKS == m_pg.GetType() ? _L("Do you want to delete the selected worksheets?") : _L("Do you want to delete the selected matrix sheets?"));
	if( IDNO == MessageBox(GetWindow(), str, _L("Warning"), MB_YESNO) )
		return false;
		
	vector<uint> vnLays;
	if( getSelectedSheet(&vnLays) < 0 )
		return false;	
	///------ Folger 12/30/2011 ORG-4727-P1 CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG
	//vnLays.Sort(); /// Iris 9/28/2011 to fix after sort columns, fail to delete all selected sheets.
	//
	//Layer layActive = m_pg.Layers(-1);
	//for(int index = vnLays.GetSize()-1; index >= 0; --index)
	//{
		//int nLay = vnLays[index];
		//int nRow = findRow(nLay);
		//
		//Layer lay = m_pg.Layers(nLay);
		//if( !lay )
		//{
			//error_report("invalid datasheet, fail to delete");
		//}
		//else
		//{
			//lay.Destroy(); // this method will auto set the first sheet as active after destroy
			//
			//if( nRow < m_nBoldRow )
				//m_nBoldRow--;
			//else if( nRow == m_nBoldRow )
				//m_nBoldRow = -1;				
			//DeleteRow(nRow);			
		//}
	//}	
	//
	//if( layActive ) // if the active not be delete
		//layActive.CheckShowActivate();
	vector<int>		vnLayers;
	vnLayers = vnLays;
	if ( !page_delete_layers(m_pg, vnLayers) )
		return false;
	///------ End CHECK_OPERATION_WHEN_DELETE_WKS_FROM_NAVIGATION_DLG
	
	RemoveSelection();
	update(false);	
	return true;
}

void SheetListView::DuplicateSheets(bool bWithData)
{
	DWORD dwOptions;
	if( bWithData )
		dwOptions = DCTRL_COPY_DEFAULT;
	else
		dwOptions = DCTRL_COPY_OUT_OPERATIONS;
	
	vector<uint> vn;
	if( getSelectedSheet(&vn) >= 0 )
	{
		for(int index = 0; index < vn.GetSize(); ++index)
		{
			Layer laySource = m_pg.Layers(vn[index]);
			if( laySource )
			{
				int nNewlay = m_pg.AddLayer(laySource, dwOptions);
				Datasheet datasheet = m_pg.Layers(nNewlay);
				appendOneSheetInfo(datasheet);
			}
			else
			{
				error_report("fail to copy, invalid sheet");
			}
		}
	}	
}

bool SheetListView::MoveToNewBook(bool bKeepSource)
{
	vector<uint> vnLays;
	if( getSelectedSheet(&vnLays) < 0 )
		return error_report("No selected, fail to do moving");
	
	Page pgNew;
	string strTemplate = "Origin";
	DWORD dwOptions = CREATE_NACTIVE | CREATE_EMPTY;
	if( m_pg.GetType() == EXIST_WKS )
	{
		WorksheetPage wksPageNew;
		wksPageNew.Create(strTemplate, dwOptions);
		pgNew = wksPageNew;
	}
	else
	{
		MatrixPage matPageNew;
		matPageNew.Create(strTemplate, dwOptions);
		pgNew = matPageNew;
	}		
	
	// add to new page
	vnLays.Sort(SORT_DESCENDING);
	for(int nn = 0; nn < vnLays.GetSize(); ++nn)
	{
		int nLay = vnLays[nn];
		Datasheet datasheet = m_pg.Layers(nLay);
		ASSERT(datasheet);
		
		pgNew.AddLayer(datasheet, DCTRL_COPY_DEFAULT, bKeepSource, 0);		
	}	
	
	RemoveSelection();	
	update(false);
	return true;
}

bool SheetListView::MoveSelectedTo(int nToWksBefore)
{
	ApplyChange(); /// Bill 12/22/2011 ORG-4682-P1 COMMENT_SHOULD_NOT_CLEARED_AFTER_DELETE_OR_MOVE_SHEET
	
	vector<uint> vnLays;
	if( getSelectedSheet(&vnLays) < 0 )
		return error_report("No selected, fail to do moving");
	
	if( -1 == nToWksBefore ) // -1 means move to End
		nToWksBefore = m_pg.Layers.Count(); 	
	Layer layBefore = m_pg.Layers(nToWksBefore);	
	
	for(int nn = 0; nn < vnLays.GetSize(); nn++)
	{	
		if( layBefore )
			nToWksBefore = layBefore.GetIndex();
		
		int nMoveTo;
		if( vnLays[nn] >= nToWksBefore )
			nMoveTo = nToWksBefore;
		else
		{
			nMoveTo = nToWksBefore - 1;
		}			
	
		if( nMoveTo != vnLays[nn] )
		{
			Layer layActive = m_pg.Layers(-1);
			Layer lay = m_pg.Layers(vnLays[nn]);		
			lay.SetIndex(nMoveTo);
			layActive.CheckShowActivate(); // to temp fix the bug in ORG-3729-P2
			adjustLayerIndexAfterMoving(vnLays, nMoveTo, nn);
		}			
	}
	update(false);
	
	RemoveSelection();	
	vector<uint> vnRows;
	vnRows = vnLays + 1;
	for(nn = 0; nn < vnRows.GetSize(); nn++)
	{
		SetIsSelected(vnRows[nn], true);
	}
	
	return true;
}

void SheetListView::SetSheetOrderAsCurrent()
{
	vector<uint> vnSheets;
	for(int nRow = GetRowOffset(); nRow < GetRows(); nRow++)
	{
		int nSheetIndex = atoi(GetCell(nRow, COL_INDEX)) - 1;
		vnSheets.Add( nSheetIndex );
	}
	
	Datasheet dsActive = m_pg.Layers(-1);
	for(int index = 0; index < vnSheets.GetSize(); index++)
	{
		Datasheet datasheet = m_pg.Layers(vnSheets[index]);
		ASSERT( datasheet );		
		
		if( datasheet && datasheet.GetIndex() != index )
		{
			datasheet.SetIndex(index);
			adjustLayerIndexAfterMoving(vnSheets, index, index);
		}
	}
	// SetIndex changed the active status
	if( dsActive )
	{
		dsActive.CheckShowActivate();
	}
	
	// just need update Index column
	vector vecIndex;
	vecIndex.Data(1, m_pg.Layers.Count(), 1);
	
	vector<string> vsIndex;
	convert_double_vector_to_string_vector(vecIndex, vsIndex, vecIndex.GetSize());
	
	/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	SetColValues(COL_INDEX, vsIndex);
#else
	SetColValues(COL_INDEX - GetColOffset(), vsIndex);
#endif
	///End SUPPORT_ROW_MOVING
}

void SheetListView::adjustLayerIndexAfterMoving(vector<uint>& vnLays, int nMoveTo, int index)
{
	int nBeforeMove = vnLays[index];
	
	for(int nn = 0; nn < vnLays.GetSize(); nn++)
	{
		if( nn != index )
		{		
			if( nBeforeMove < vnLays[nn] && nMoveTo >= vnLays[nn] )
			{
				vnLays[nn] = vnLays[nn] - 1;
			}
			else if( nBeforeMove > vnLays[nn] && nMoveTo <= vnLays[nn] )
			{
				vnLays[nn] = vnLays[nn] + 1;
			}
		}
		else
		{
			vnLays[nn] = nMoveTo;
		}
	}
}

/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
bool SheetListView::OnCellBeforeEdit( int nRow, int nCol, BOOL* pCancel )
{
	if( pCancel != NULL )
	{
		*pCancel = (COL_COMMENTS != nCol);
	}
	return true;
}

bool SheetListView::OnCellAfterEdit(int nRow, int nCol)
{
	if( COL_COMMENTS == nCol )
		m_bIsCommentsEdit = true;
	return true;
}
///End SET_COMMENTS_COLUMN_AS_EDITABLE

///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
//void SheetListView::OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel, bool* pMenuNeedUpdate)
void SheetListView::ShowMenu(int nx, int ny, bool* pMenuNeedUpdate/* = NULL*/)
///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	int nRow, nCol;
	GetMouseCell(nRow, nCol);	
	
	if( nRow >= 0 && nRow < GetRowOffset() ) // right click on column header
	{
		SheetListHeaderMenu myMenu(this);	
		/// Iris 9/26/2011 ORG-3616-S3 SUPPORT_ROW_MOVING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
		int nSelCol = myMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if( nSelCol >= 0 && nSelCol < GetNumCols() )
		{
			bool bHide = GetIsColHidden(nSelCol);
			SetIsColHidden(nSelCol, !bHide);
		}
#else
		int nSelCmd = myMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if( nSelCmd >= 0 )
		{
			int nSelCol = nSelCmd + GetColOffset();
			if( nSelCol >= COL_INDEX && nSelCol < COL_COUNT )
			{
				bool bHide = GetIsColHidden(nSelCol);
				SetIsColHidden(nSelCol, !bHide);
			}
		}
#endif
	}
	/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	else // right click in grid
	{			
		SheetListContextMenu myMenu(m_vsContextMenuText, m_vnContextMenuCmdIDs, m_vbEnables);
		int nSel = myMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		//printf("%d, %d\n",nSel, myMenu.GetCommandID());			
		
		bool bMenuNeedUpdate = false;
		int nCmdID = myMenu.GetCommandID();
		if( nCmdID > 0 )
		{				
			if( nCmdID > IDR_MOVE_BEFORE_TO_BEGIN )
			{
				int nSheet = nCmdID - IDR_MOVE_BEFORE_TO_BEGIN - 1;
				MoveSelectedTo(nSheet);
				bMenuNeedUpdate = true;
			}
			else
			{
				switch(nCmdID)
				{
				case IDR_ACTIVATE:
					ActivateSheet();
					break;
					
				case IDR_DUPLICATE:
					DuplicateSheets(true);
					bMenuNeedUpdate = true;
					break;
					
				case IDR_DUPLICATE_WITHOUT_DATA:
					DuplicateSheets(false);
					bMenuNeedUpdate = true;
					break;
					
				case IDR_DELETE:
					DeleteSheet();
					bMenuNeedUpdate = true;
					break;
					
				case IDR_CLEAR_DATA:
					ClearAllData();
					break;				
				
				case IDR_MOVE_TO_BEGIN:
					MoveSelectedTo(0);
					bMenuNeedUpdate = true;
					break;
					
				case IDR_MOVE_TO_END:
					MoveSelectedTo(-1);
					bMenuNeedUpdate = true;
					break;
					
				case IDR_SET_CURRENT_ORDER_AS_SHEET_ORDER:
					SetSheetOrderAsCurrent();
					bMenuNeedUpdate = true; /// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
					break;
					
				case IDR_MOVE_TO_NEW_BOOK:
					MoveToNewBook(false);
					bMenuNeedUpdate = true;
					break;
					
				case IDR_DUPLICATE_TO_NEW_BOOK:
					MoveToNewBook(true);
					bMenuNeedUpdate = true;
					break;					
					
				default:
					break;
				}
			}
		}			
		if( pMenuNeedUpdate != NULL )
			*pMenuNeedUpdate = bMenuNeedUpdate;
	}
	///End ADD_GRID_CONTEXT_MENU
}

//virtual
int WorkSheetListView::GetNumObjects(Datasheet& datasheet) 
{
	Worksheet wks(datasheet); 
	if ( wks ) 
		return wks.GetNumCols(); 
	return 0;
}

// virtual
int MatrixSheetListView::GetNumObjects(Datasheet& datasheet) 
{ 
	MatrixLayer matLay(datasheet); 
	if ( matLay ) 
		return matLay.MatrixObjects.Count(); 
	return 0;
}

BOOL WksMoveDlg::OnInitDialog()
{	
	ResizeDialog::OnInitDialog(IDC_LIST);	
	InitToolBar(IDR_WKS_MOVE_MENU);
	SetLangMenu(IDR_WKS_MOVE_MENU);
	
	Layer lay = Project.ActiveLayer();
	if( !lay )
		return false;	
	
	// init sheet view list pointer by page type
	if( EXIST_WKS == lay.GetPage().GetType() )
	{
		m_plist = new WorkSheetListView;
	}
	else
	{
		m_plist = new MatrixSheetListView;
	}
	if( NULL == m_plist )
		return error_report("Fail to create list view pointer");
	
	m_plist->Init(IDC_LIST, *this);	
	
	string strTitle;
	/// Iris 9/27/2011 ORG-3616-S4 SHOW_PAGE_SHORT_NAME_AND_LONG_NAME_ON_DLG_TITLE
	//strTitle.Format("%s - %s", m_plist->GetDlgName(), page_get_display_name(lay.GetPage(), false));
	strTitle.Format("%s - %s", m_plist->GetDlgName(), page_get_display_name(lay.GetPage(), true));
	///End SHOW_PAGE_SHORT_NAME_AND_LONG_NAME_ON_DLG_TITLE
	Text = strTitle;

	HMENU hmn = GetMenu(GetSafeHwnd());
	if( hmn )
		m_menu.Load(hmn);
	updateSubMenuEnableStatus();	
	updateSheetsPopupMenu(true);
	
	/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	updateContextMenu();
	///End ADD_GRID_CONTEXT_MENU
	
	/// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	enableApplyReorderButton(false);
	///End ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	
//---- CPY 10/13/2011 ORG-3616-P11 WKS_NAVIGATE_DRAG_TO_REORDER_CRASHING
#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_	
	Button btn = GetItem(IDC_BTN_APPLY_REORDER);
	btn.ShowWindow(SW_HIDE);
#endif
//----- end WKS_NAVIGATE_DRAG_TO_REORDER_CRASHING	
	return true;
}

BOOL WksMoveDlg::OnReady()
{
	SetInitReady(true);
	return true;
}

BOOL WksMoveDlg::OnDlgResize(int nType, int cx, int cy)
{	
	if(!IsInitReady())
		return true;
	
	MoveControlsHelper	_temp(this);
	int nGap = GetControlGap();
	
	// move Cancel button
	RECT rrBtn;
	GetControlClientRect(IDCANCEL, rrBtn);
	vector<uint> vuRightIDs = {
		IDC_BTN_APPLY_REORDER, /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
		IDOK, /// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
		IDCANCEL,
		0
	};
	int nDX = cx - nGap - RECT_WIDTH(rrBtn) - rrBtn.left;
	int nDY = cy - nGap - RECT_HEIGHT(rrBtn) - rrBtn.top;
	MoveControls(vuRightIDs, nDX, nDY);	
	
	// resize list
	RECT rrList;	
	Control list = GetItem(IDC_LIST);
	GetClientRect(list, rrList);
	rrList.right = cx - nGap;
	rrList.bottom = cy - 2 * nGap - RECT_HEIGHT(rrBtn);
	MoveControl(list, rrList);
	
	return true;
}

/// Iris 09/09/2011 ORG-3616 ADD_WKS_NAVIGATE_DLG_HELP_ID
BOOL WksMoveDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = m_plist->GetHelpID();
	return true;
}
///End ADD_WKS_NAVIGATE_DLG_HELP_ID

BOOL WksMoveDlg::OnDestroy()	
{
	if( NULL != m_plist )
	{
		delete m_plist;
		m_plist = NULL;
	}
	return true;
}

/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
BOOL WksMoveDlg::OnOK()
{
	m_plist->ApplyChange();
	return true;
}
///End SET_COMMENTS_COLUMN_AS_EDITABLE

/// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
BOOL WksMoveDlg::OnApplyReorderButtonClick(Control ctrl)
{
	/// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	//m_plist->SetSheetOrderAsCurrent();
	//enableApplyReorderButton(false);
	doReorderSheet();	
	/// End RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	return true;
}
///End ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID

BOOL WksMoveDlg::OnActivate()
{
	m_plist->ActivateSheet();
	return true;
}

/*
// move the active sheet before the selected
BOOL WksMoveDlg::OnMoveActive(Control ctrl)
{
	int nLay = m_plist->getSelectedSheet();
	int nMoveTo;
	if( nLay == 0 )
	{
		nMoveTo = 0;
	}
	else if( nLay == m_pg.Layers.Count() - 1 ) // last sheet
	{
		nMoveTo = nLay - 1;
	}
	else
	{
		nMoveTo = nLay;
	}
	
	Worksheet wks = m_pg.Layers(-1);
	wks.SetIndex(nMoveTo);
	
	m_plist->update();
	//updateButtonStatus();
	return true;
}
*/

BOOL WksMoveDlg::OnMoveToNewBook()
{
	bool bRet = m_plist->MoveToNewBook(false);
	//updateSheetsPopupMenu();
	//updateContextMenu();
	updateMenuItemOnAfterGridChange();
	return bRet;	
}

BOOL WksMoveDlg::OnDuplicateToNewBook()
{
	return m_plist->MoveToNewBook(true);
}

BOOL WksMoveDlg::OnClearAllData()
{
	return m_plist->ClearAllData();
}

BOOL WksMoveDlg::OnDelete()
{
	bool bRet = m_plist->DeleteSheet();	
	//updateSheetsPopupMenu();
	//updateContextMenu();
	updateMenuItemOnAfterGridChange();
	return bRet;
}

/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
static int _get_sheet_index_from_menu_item(Menu& menu, int nCmdID)
{
	string str;
	if( menu.GetMenuString(nCmdID, str, MF_BYCOMMAND) > 0 )
	{
		string strIndex = str.GetToken(0, ' ');		
		int nWks = atoi(strIndex) - 1;
		return nWks;
	}
	return -1;
}
///End ADD_GRID_CONTEXT_MENU

BOOL WksMoveDlg::OnMoveBefore(int nCmdID)
{
	/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
	/*
	string str;
	if( m_menu.GetMenuString(nCmdID, str, MF_BYCOMMAND) > 0 )
	{
		string strIndex = str.GetToken(0, ' ');
		
		int nWks = atoi(strIndex) - 1;
		return m_plist->MoveSelectedTo(nWks);		
	}
	*/
	int nSheet;
	if( (nSheet = _get_sheet_index_from_menu_item(m_menu, nCmdID)) >= 0 )
		return m_plist->MoveSelectedTo(nSheet);
	return FALSE;
	///End ADD_GRID_CONTEXT_MENU
}

BOOL WksMoveDlg::OnMoveToBegin()
{
	return m_plist->MoveSelectedTo(0);
}

BOOL WksMoveDlg::OnMoveToEnd()
{
	return m_plist->MoveSelectedTo(-1);
}

BOOL WksMoveDlg::OnSetSheetOrderAsCurrent()
{
	/// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	//m_plist->SetSheetOrderAsCurrent();
	doReorderSheet();
	/// End RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	return true;
}

BOOL WksMoveDlg::OnDuplicate()
{
	m_plist->DuplicateSheets(true);
	//updateSheetsPopupMenu();
	//updateContextMenu();
	updateMenuItemOnAfterGridChange();
	return TRUE;
}

BOOL WksMoveDlg::OnDuplicateWithoutData()
{
	m_plist->DuplicateSheets(false);
	//updateSheetsPopupMenu();
	//updateContextMenu();
	updateMenuItemOnAfterGridChange();
	return TRUE;
}


void WksMoveDlg::updateSubMenuEnableStatus()
{
	if( NULL == m_menu.GetSafeHmenu() )
		return;	
	/*	
	bool bOnlyOneSelection;
	bool bHasSelection = m_plist->HasSelection(&bOnlyOneSelection);
	
	enableMenuItem(IDR_ACTIVATE, bHasSelection && bOnlyOneSelection);
	
	uint nIDs[] = {
		IDR_DUPLICATE,
		IDR_DUPLICATE_WITHOUT_DATA,
		IDR_CLEAR_DATA,
		IDR_DELETE,
		IDR_MOVE_BEFORE_TO_BEGIN,
		IDR_MOVE_TO_BEGIN,
		IDR_MOVE_TO_END,
		IDR_MOVE_TO_NEW_BOOK,
		IDR_DUPLICATE_TO_NEW_BOOK,
		0
	};	
	int ii = 0;
	while( nIDs[ii] > 0 )
	{
		enableMenuItem(nIDs[ii++], bHasSelection);
	}
	
	vector<uint> vnRows;
	if( m_plist->GetSelRows(vnRows) )
	{
		vector<uint> vn;
		if( vnRows.Find(MATREPL_TEST_EQUAL, m_plist->GetRowOffset(), vn) > 0 ) // already select the first
			enableMenuItem(IDR_MOVE_TO_BEGIN, false);
		
		if( vnRows.Find(MATREPL_TEST_EQUAL, m_plist->GetRows() - 1, vn) > 0 ) // already select the last
			enableMenuItem(IDR_MOVE_TO_END, false);
	}
	*/
	uint nIDs[] = {
		IDR_ACTIVATE,
		IDR_DUPLICATE,
		IDR_DUPLICATE_WITHOUT_DATA,
		IDR_CLEAR_DATA,
		IDR_DELETE,
		IDR_MOVE_BEFORE_TO_BEGIN,
		IDR_MOVE_TO_BEGIN,
		IDR_MOVE_TO_END,
		IDR_MOVE_TO_NEW_BOOK,
		IDR_DUPLICATE_TO_NEW_BOOK,
		0
	};
	
	int ii = 0;
	while( nIDs[ii] > 0 )
	{
		enableMenuItem(nIDs[ii], m_plist->IsMenuItemEnable(nIDs[ii]));
		ii++;
	}
}

void WksMoveDlg::enableMenuItem(int nMenuID, bool bEnable)
{
	string str;
	if( m_menu.GetMenuString(nMenuID, str, MF_BYCOMMAND) > 0 )
	{
		UINT uFlag = MF_BYCOMMAND;
		if( !bEnable )
			uFlag |= MF_DISABLED | MF_GRAYED;
		m_menu.ModifyMenu(nMenuID, uFlag, nMenuID,  str);
	}
}

/// Iris 9/26/2011 ORG-3616-S3 ADD_GRID_CONTEXT_MENU
bool WksMoveDlg::getMenuText(vector<string>& vsMenu, vector<int>& vnContextCmdIDs, vector<bool>& vbEnables)
{
	if( NULL == m_menu.GetSafeHmenu() )
		return false;
	
	vector<int> vnCmd = {
			IDR_ACTIVATE,
			0,
			IDR_DUPLICATE,            
			IDR_DUPLICATE_WITHOUT_DATA,
			0,
			IDR_CLEAR_DATA,
			IDR_DELETE,
			0,
			IDR_MOVE_BEFORE_TO_BEGIN,
			IDR_MOVE_TO_BEGIN,
			IDR_MOVE_TO_END,
			IDR_SET_CURRENT_ORDER_AS_SHEET_ORDER,
			0,
			IDR_MOVE_TO_NEW_BOOK,
			IDR_DUPLICATE_TO_NEW_BOOK						
	};

	for(int index = 0; index < vnCmd.GetSize(); index++)
	{
		if( 0 == vnCmd[index] ) // separator
		{
			vsMenu.Add("");
			vnContextCmdIDs.Add(0);
			vbEnables.Add(true);
		}
		else if( IDR_MOVE_BEFORE_TO_BEGIN == vnCmd[index] )
		{
			string strMoveBefore;
			strMoveBefore.Format("+%s", _L("Move Before"));
			vsMenu.Add(strMoveBefore);
			vnContextCmdIDs.Add(vnCmd[index]);
			vbEnables.Add(m_plist->IsMenuItemEnable(vnCmd[index]));
			
			string str;
			int nSubMenuID = IDR_MOVE_BEFORE_TO_BEGIN + 1;	
			bool bIncSub = false;
			while( m_menu.GetMenuString(nSubMenuID, str, MF_STRING) )
			{
				vsMenu.Add(str);
				vnContextCmdIDs.Add(nSubMenuID);
				vbEnables.Add(m_plist->IsMenuItemEnable(nSubMenuID));
				nSubMenuID++;
				bIncSub = true;
			}
			
			int nLast = vsMenu.GetSize()-1;
			if( bIncSub )
				vsMenu[nLast] = "-" + vsMenu[nLast];
			else
			{
				vsMenu.RemoveAt(nLast); // remove +
				vnContextCmdIDs.RemoveAt(nLast);
				vbEnables.RemoveAt(nLast);
			}
		}
		else
		{
			string str;	
			int nID = vnCmd[index];
			if( m_menu.GetMenuString(nID, str, MF_STRING) )
			{
				// remove & from menu text
				int nPos = -1;
				while( (nPos = str.Find('&')) >= 0 )
				{
					str.Delete(nPos);
				}
				
				vsMenu.Add(str);
				vnContextCmdIDs.Add(nID);
				vbEnables.Add(m_plist->IsMenuItemEnable(nID));
			}
			else
			{
				error_report("Fail to get menu text for ID " + (string)nID);
			}
		}
	}
	
	return vsMenu.GetSize() > 0;
}
///End ADD_GRID_CONTEXT_MENU

void WksMoveDlg::updateSheetsPopupMenu(bool bInit)
{
	if( NULL == m_menu.GetSafeHmenu() )
		return;
	
	/// Iris 9/14/2011 ORG-3616-P8 REMOVE_CLEAR_ALL_DATA_MENU_FROM_MATRIX_NAGIVATE_DLG
	if( bInit )
	{
		Layer lay = Project.ActiveLayer();
		if( lay && EXIST_MATRIX == lay.GetPage().GetType() )
			m_menu.RemoveMenu(IDR_CLEAR_DATA, MF_STRING);
	}
	///End REMOVE_CLEAR_ALL_DATA_MENU_FROM_MATRIX_NAGIVATE_DLG
	
	// insert back IDR_MOVE_BEFORE_TO_BEGIN to keep the position and remove all sheet name
	string str;
	if( m_menu.GetMenuString(IDR_MOVE_BEFORE_TO_BEGIN + 1, str, MF_STRING) > 0 )
	{
		m_menu.InsertMenu(IDR_MOVE_BEFORE_TO_BEGIN + 1, MF_STRING | MF_BYCOMMAND, IDR_MOVE_BEFORE_TO_BEGIN, _L("Empty"));
	
		int ii = 0;
		while( m_menu.GetMenuString(IDR_MOVE_BEFORE_TO_BEGIN + ii + 1, str, MF_STRING) > 0 && ii < MAX_SHEETS_NUMBER )
		{
			m_menu.RemoveMenu(IDR_MOVE_BEFORE_TO_BEGIN + ii + 1, MF_STRING);
			ii++;
		}
	}
	
	vector<string> vsSubMenus;
	vector<uint> vnFlags;
	getSheetListSubMenus(vsSubMenus, vnFlags);
	ASSERT(vsSubMenus.GetSize() == vnFlags.GetSize());
	
	for(int ii = 0; ii < vsSubMenus.GetSize() && ii < vnFlags.GetSize(); ii++)
	{
		m_menu.InsertMenu(IDR_MOVE_BEFORE_TO_BEGIN, vnFlags[ii], IDR_MOVE_BEFORE_TO_BEGIN + ii + 1, vsSubMenus[ii]);		
	}
	m_menu.RemoveMenu(IDR_MOVE_BEFORE_TO_BEGIN, MF_STRING);
}

int WksMoveDlg::getSheetListSubMenus(vector<string>& vsMenu, vector<uint>& vnFlags)
{
	vector<string> vsSheetName;
	vector<int> vnIndex;
	vector<bool> vbSelected;
	m_plist->GetSheets(vsSheetName, vnIndex, vbSelected);	
	bool bOnlyOneSelection;
	bool bHasSelection = m_plist->HasSelection(&bOnlyOneSelection);

	// insert new sheets back before IDR_MOVE_BEFORE_TO_BEGIN, then remove IDR_MOVE_BEFORE_TO_BEGIN
	for(int ii = 0; ii < vsSheetName.GetSize() && ii < MAX_SHEETS_NUMBER; ii++)
	{
		UINT uFlag = MF_STRING;
		/// Bill 10/21/2011 ORG-3616-P14 MOVE_BEFORE_OPTION_SHOULD_DISABLE_THE_NEXT_SHEET_OF_THE_SELECTED_SHEET
		//if( !bHasSelection || bHasSelection && vbSelected[ii] )
		if( !bHasSelection || bHasSelection && vbSelected[ii] || (ii > 0 && bOnlyOneSelection && vbSelected[ii - 1]))
		/// End MOVE_BEFORE_OPTION_SHOULD_DISABLE_THE_NEXT_SHEET_OF_THE_SELECTED_SHEET
			uFlag |= MF_GRAYED | MF_DISABLED;

		string strEntry;
		strEntry.Format("%d %s", vnIndex[ii], vsSheetName[ii]);
		
		vsMenu.Add(strEntry);
		vnFlags.Add(uFlag);
	}
	return vnFlags.GetSize();
}

void WksMoveDlg::updateContextMenu()
{
	vector<string> vsMenuText;
	vector<int> vnCmdIDs;
	vector<bool> vbEnables;
	if( getMenuText(vsMenuText, vnCmdIDs, vbEnables) )
	{
		m_plist->SetContextMenu(vsMenuText, vnCmdIDs, vbEnables);		
	}
}

void WksMoveDlg::updateMenuItemOnAfterGridChange()
{
	updateSubMenuEnableStatus();
	updateSheetsPopupMenu();
	updateContextMenu();
}

void WksMoveDlg::OnGridDBClick(Control ctrl)
{
	m_plist->ActivateSheet();
}

void WksMoveDlg::OnGridAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
{	
	updateMenuItemOnAfterGridChange();
	
	/// Bill 11/02/2011 ORG-3616-P18 ENTER_EDIT_MODE_WHEN_SINGLE_CLICK_TO_COMMENT_COLUMN
	if (nNewColSel == COL_COMMENTS)
	{
		m_plist->EditCell();
	}
	/// End ENTER_EDIT_MODE_WHEN_SINGLE_CLICK_TO_COMMENT_COLUMN
}

BOOL WksMoveDlg::OnGridAfterSort(Control ctrl, long lCol, short* pSort)
{
	m_plist->OnAfterSortCol();
	/// Iris 2/14/2012 ORG-5052-P1 FIX_APPLY_REORDER_BUTTON_STILL_DISABLE_AFTER_SORT
//#ifndef _SUPPORT_DRAG_TO_MOVE_ROW_FOR_WKS_ARRANGE_
	///End FIX_APPLY_REORDER_BUTTON_STILL_DISABLE_AFTER_SORT
	
	/// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	if( m_plist->IsSheetsReordered() )
	{
		enableApplyReorderButton();
	}
	///End ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
	
	/// Iris 2/14/2012 ORG-5052-P1 FIX_APPLY_REORDER_BUTTON_STILL_DISABLE_AFTER_SORT
//#endif
	///End FIX_APPLY_REORDER_BUTTON_STILL_DISABLE_AFTER_SORT
	return TRUE;
}

void WksMoveDlg::OnGridBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
{
///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
}
BOOL WksMoveDlg::OnContextMenu(UINT nResIDCtrl, int nx, int ny)
{
	if ( IDC_LIST != nResIDCtrl )
		return FALSE;
///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

	bool bMenuNeedUpdate;
	///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//m_plist->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel, &bMenuNeedUpdate);
	m_plist->ShowMenu(nx, ny, &bMenuNeedUpdate);
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	
	if( bMenuNeedUpdate )
	{
		updateMenuItemOnAfterGridChange();
		enableApplyReorderButton(false); /// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
	}
	return TRUE;		///------ Folger 01/31/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
}

void WksMoveDlg::OnGridAfterMoveRows(Control ctrl, long nRow, long *pnPosition)
{
	m_plist->OnAfterRowReorder();	
	enableApplyReorderButton(); /// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
}

/// Iris 10/26/2011 ORG-3616-P16 SET_COMMENTS_COLUMN_AS_EDITABLE
void WksMoveDlg::OnGridBeforeEdit( Control ctrl, int nRow, int nCol, BOOL* pCancel )
{
	m_plist->OnCellBeforeEdit( nRow, nCol, pCancel );
}

void WksMoveDlg::OnGridAfterEdit(Control ctrl, int nRow, int nCol)
{
	m_plist->OnCellAfterEdit( nRow, nCol );
}
///End SET_COMMENTS_COLUMN_AS_EDITABLE

/// Bill 10/21/2011 ORG-3616-P15 RECONSTRUCT_MENU_AFTER_REORDER_SHEET
void WksMoveDlg::doReorderSheet()
{
	m_plist->SetSheetOrderAsCurrent();
	enableApplyReorderButton(false);	
	updateMenuItemOnAfterGridChange();
}
/// End RECONSTRUCT_MENU_AFTER_REORDER_SHEET

/// Iris 9/29/2011 ORG-3616 ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID
void WksMoveDlg::enableApplyReorderButton(bool bEnable)
{
	Button btnApplyReorder = GetItem(IDC_BTN_APPLY_REORDER);
	if( btnApplyReorder )
	{
		btnApplyReorder.Enable = bEnable;
	}
}
///End ADD_APPLY_SHEET_ORDER_SAME_AS_IN_GRID


void OpenWksMoveDlg()
{
	WksMoveDlg mydlg;
	mydlg.DoModalEx();
}
