/*------------------------------------------------------------------------------*
 * File Name:WksListControl.h													*
 * Creation: CPY 6/28/2003														*
 * Purpose: OriginC Class for managing list of worksheets. This class is used in*
 * the Select Columns for Plotting dialog										*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT						*
 *	CPY 9/8/03 v7.5688 WKS_MAT_SEL_CHECK_CONSISTENT								*
 *	CPY 10/26/03 AUTO_SEL_LAST_ACTIVE_WKS_MATRIX								*
 *	Jasmine 03/28/07 QA70-7718 CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT	*
 *	Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT						*
 *	Kyle 07/29/08 SELECT_THE_FIRST_ROW_WHEN_THERE_IS_NO_ACTIVE_PAGE_OF_THE_SELECTED_TYPE
 *	Kyle 07/30/08 UPDATE_LIST_WHEN_NO_CONTENT									*
 *	Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION				*
 *	Jasmine 09/09/08 v8.0935 QA80-12165 BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
 *	Jasmine 10/07/08 QA80-11992-P1 MAT_FOLDER_SELECTION_IS_CHANGED_BY_MISTAKE	*
 *	Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN				*
 *	Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE								*
 *	Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING				*
 *	Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME					*
 *	Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
 *	Jasmine 03/29/10 QA81-14022-P1 OPTION_NOT_AFFECT_DATACOMBO_PROJECT			*
 *	Jasmine 04/01/10 QA81-14022-P2 COLLECTION_IS_VALID_BY_DEFAULT				*
 *	Sophy 7/30/2010 ORG-681-P2 FAIL_TO_SELECT_LOOSE_DATASET_IF_NOT_PLOT_IN_ACTIVE_PAGE
 *	Bill 12/17/2010 SET_DEFAULT_VALUE_IN_WXGRID									*
 *	Kit 01/12/2011 ORG-1637-S2 RENAME_INCLUDE_SHORTCUT_PAGE_TO_INCLUDE_SHORTCUT_WINDOW
 *	Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
 *	Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *------------------------------------------------------------------------------*/

#ifndef _WKS_LIST_CONTORL_H
#define _WKS_LIST_CONTORL_H

#include "PageListControl.h" //CPY 2/29/04

////////////////////////////////////////////////////////
// class WksListControl - Available Data List (AD)    
////////////////////////////////////////////////////////
// supported col types


enum {DATACOMBO_CURRENT, DATACOMBO_FOLDER, 		DATACOMBO_PROJECT, 		DATACOMBO_FAVORITES,		///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
						DATACOMBO_MAT_FOLDER, 	DATACOMBO_MAT_PROJECT, 	DATACOMBO_MAT_FAVORITES,	///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
	DATACOMBO_LOOSEDATA, DATACOMBO_FUNCTIONS,
	/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	DATACOMBO_NAMEDRANGE,
#endif	// NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
};
	
enum {WLCMENU_HIDE, WLCMENU_SHOW_ALL, WLCMENU_SEPARATOR, WLCMENU_APPLY_DESIGNATIONS, WLCMENU_SEPARATOR1, WLCMENU_INCREASE_SIZE, WLCMENU_DECREASE_SIZE};

enum{UPDATE_LIST_NONE = -1, UPDATE_LIST_NORMAL, UPDATE_LIST_ADD_SHORTCUT};///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME

/// Iris 3/05/2011 ORG-2239-S2 RENAME_TO_INCLUDE_SHORTCUTS
//#define STR_INCLUDE_SHORTCUT_CHECK_BOX_TITLE _L("Include Shortcut Windows") ///-----Kit 01/12/2011 ORG-1637-S2 RENAME_INCLUDE_SHORTCUT_PAGE_TO_INCLUDE_SHORTCUT_WINDOW
#define STR_INCLUDE_SHORTCUT_CHECK_BOX_TITLE _L("Include Shortcuts")
///End RENAME_TO_INCLUDE_SHORTCUTS

class AvailDataList : public ComboBox
{
private:
	//bool	m_bIncludeMatrices; this is no longer an option, too complicated
public:
	AvailDataList()
	{
		m_nPageTypeChoice = -1;
	}
		
	Init(bool bIncludeMatrices)
	{
		//m_bIncludeMatrices = bIncludeMatrices;
		AddString(_L("Current Workbook"));//Worksheet"));
		AddString(_L("Worksheets in Folder"));
		AddString(_L("Worksheets in Project"));
		AddString(_L("Worksheets in Favorites"));	///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
		//if(m_bIncludeMatrices)
		//{
			AddString(_L("Matrices in Folder"));
			AddString(_L("Matrices in Project"));
			AddString(_L("Matrices in Favorites"));	///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
		//}
		AddString(_L("Loose Datasets"));
		AddString(_L("Function Plots"));
		
		/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		#ifdef NEW_NAMED_RANGE_FEATURE
		AddString( _L("Named Ranges for Vectors") );
		#endif // NEW_NAMED_RANGE_FEATURE
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		
		//-------- CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT
		//SetCurSel(DATACOMBO_PROJECT);
		//--------
	}
	int	GetSelectedPageType()
	{
		return comboIndexToPageType(GetCurSel());
	}
	// return true if sel has been changed
	///Jasmine 03/28/07 QA70-7718 CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT
	//bool SelectByPageType(int nPageType)
	//bool SelectByPageType(int nPageType, LPCSTR lpcszName = NULL)///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
	bool SelectByPageType(int nPageType, LPCSTR lpcszName = NULL, LPCSTR lpcszCurrentName = NULL)
	{
		int nIndex = pageTypeToComboIndex(nPageType, lpcszName, lpcszCurrentName);
		if(nIndex == m_nPageTypeChoice)
			return false;
		SetCurSel(nIndex);
		return true;
	}
	int GetCurSel()
	{
		m_nPageTypeChoice = ComboBox::GetCurSel();
		/*
		if(m_nPageTypeChoice > DATACOMBO_PROJECT)
		{
			if(!m_bIncludeMatrices)
				return DATACOMBO_LOOSEDATA;
		}
		*/
		return m_nPageTypeChoice;
	}
private:
	int comboIndexToPageType(int nComboIndex)
	{
		///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
		//if(nComboIndex > DATACOMBO_PROJECT)
		if(nComboIndex >= DATACOMBO_MAT_FOLDER)
		///End ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
		{
			//if(m_bIncludeMatrices && m_nPageTypeChoice < DATACOMBO_LOOSEDATA )
			if(nComboIndex < DATACOMBO_LOOSEDATA )
				return EXIST_MATRIX;
			if(nComboIndex > DATACOMBO_LOOSEDATA)
				return EXIST_FUNC_PLOT;
			
			return EXIST_DATA;
		}
		return EXIST_WKS;
	}
	///Jasmine 03/28/07 QA70-7718 CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT
	//int pageTypeToComboIndex(int nPageType)
	//int pageTypeToComboIndex(int nPageType, LPCSTR lpcszName = NULL)///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
	int pageTypeToComboIndex(int nPageType, LPCSTR lpcszName = NULL, LPCSTR lpcszCurrentName = NULL)
	{
		switch(nPageType)
		{
		case EXIST_WKS:
		case EXIST_EXTERN_WKS:
			Worksheet wks(lpcszName);
			switch(m_nPageTypeChoice)
			{
			case DATACOMBO_CURRENT:
				///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
				//Layer lay = Project.ActiveLayer();
				Worksheet lay = Project.ActiveLayer();
				if(!lay && lpcszCurrentName)
				{
					Worksheet wksTemp(lpcszCurrentName);
					if(wksTemp)
						lay = wksTemp;
				}
				///End REDUCE_UPDATE_WKS_LIST_TIME
				if(wks && lay && is_same_layer(wks, lay))
					return DATACOMBO_CURRENT;
				//go to next case
			case DATACOMBO_FOLDER:
				if(wks)
				{
					string strMyPath = wks.GetPage().GetFolder().GetPath();
					string strCurPath = Project.ActiveFolder().GetPath();
					if(!strMyPath.CompareNoCase(strCurPath))
						return DATACOMBO_FOLDER;
				}
				break;
			}
	///End CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT
			return DATACOMBO_PROJECT;
		case EXIST_MATRIX:
			///Jasmine 10/07/08 QA80-11992-P1 MAT_FOLDER_SELECTION_IS_CHANGED_BY_MISTAKE
			if(DATACOMBO_MAT_FOLDER == m_nPageTypeChoice)
			{
				MatrixLayer ml(lpcszName);
				if(ml)
				{
					string strMyPath = ml.GetPage().GetFolder().GetPath();
					string strCurPath = Project.ActiveFolder().GetPath();
					if(!strMyPath.CompareNoCase(strCurPath))
						return DATACOMBO_MAT_FOLDER;
				}
			}
			///End MAT_FOLDER_SELECTION_IS_CHANGED_BY_MISTAKE
			return DATACOMBO_MAT_PROJECT;
		case EXIST_FUNC_PLOT:
			return DATACOMBO_FUNCTIONS;
		}
		return DATACOMBO_LOOSEDATA;
	}
private:
	int	m_nPageTypeChoice;
};

	
class WksListControl : public PageListControl
{
	WksListControl() : PageListControl()
	{
		m_bIsListUpdated = false;	/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	}
	
public:
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	//void Init(int nID, Dialog& dlg, bool bMakeNewPlot, const string& strRegDlgName, int nApplyWks, int nAvilDataCombo)
	void Init(int nID, Dialog& dlg, bool bMakeNewPlot, const string& strRegDlgName, int nApplyWks, int nAvilDataCombo, int nShortcutCheck)
	{
		PageListControl::Init(nID, dlg, strRegDlgName);
		//m_comboAvailData = dlg.GetItem(nAvilDataCombo);
		//m_comboAvailData.SetCurSel(DATACOMBO_PROJECT);
		m_AvailData = dlg.GetItem(nAvilDataCombo);
		m_AvailData.Init(true);//bMakeNewPlot? false:true);
		
		m_chkApplyWks 	= dlg.GetItem(nApplyWks);
		m_chkShortcut 	= dlg.GetItem(nShortcutCheck);
		///-----Kit 01/12/2011 ORG-1637-S2 RENAME_INCLUDE_SHORTCUT_PAGE_TO_INCLUDE_SHORTCUT_WINDOW
		m_chkShortcut.Text = STR_INCLUDE_SHORTCUT_CHECK_BOX_TITLE;
		///-----
		///End OPTION_TO_GET_PAGE
		
		///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
		m_nSel 		= -1;
		m_dwOption 	= -1;
		///End REDUCE_UPDATE_WKS_LIST_TIME
		
//		updateList(bMakeNewPlot);
		/// Bill 12/17/2010 SET_DEFAULT_VALUE_IN_WXGRID
		/// We use resource to set the editable propery in vsflex, need
		/// to set this propery manually in wxGrid.
#ifdef __REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		SetEditable(flexEDNone)
#endif // __REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// End SET_DEFAULT_VALUE_IN_WXGRID
	}
	/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	//void OnReady(int nAvilDataType, bool bMakeNewPlot, DWORD dwAuxTypeInfo)
	void OnReady(int nAvilDataType, bool bMakeNewPlot, DWORD dwAuxTypeInfo, bool bUpdateList = true)
	/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	{
		//-------- CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT
		//updateList(bSelCurrentWks);
		if(nAvilDataType  < DATACOMBO_CURRENT || nAvilDataType > DATACOMBO_FUNCTIONS)
			/// Kenny 08/18/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
			//nAvilDataType = DATACOMBO_PROJECT;
			nAvilDataType = DATACOMBO_CURRENT;
			/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		
		bool bSelCurrentWks = checkAvailDataConsistentWithPlotType(nAvilDataType, bMakeNewPlot, dwAuxTypeInfo);
		
		m_AvailData.SetCurSel(nAvilDataType);
		int nSel = m_AvailData.GetCurSel();
		if(nSel >= DATACOMBO_LOOSEDATA)//if(nSel > DATACOMBO_MAT_PROJECT)	///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
			bSelCurrentWks = false;
		
		/// -----Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		if ( bUpdateList )
		/// -----End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		{
			updateList(bSelCurrentWks);	
		}
		//--------
	}
	void OnAvilableDataComboChange(LPCSTR lpcszWks = NULL)///Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT
	{
		///Kyle 07/29/08 SELECT_THE_FIRST_ROW_WHEN_THERE_IS_NO_ACTIVE_PAGE_OF_THE_SELECTED_TYPE
		/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		//updateList(false, lpcszWks);
		updateList(false, lpcszWks, true);
		/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		//updateList(true, lpcszWks);
		///End SELECT_THE_FIRST_ROW_WHEN_THERE_IS_NO_ACTIVE_PAGE_OF_THE_SELECTED_TYPE
	}
	int GetAvailableDataChoice() { return m_AvailData.GetCurSel();}
	int OnOK() // return Available Data choice
	{
		//SaveHideCols();// CPY 5/30/04 moved to base class OnDestroy, so cancel will also remember col heading changes
		return GetAvailableDataChoice();
	}
	bool IsApplyWks()
	{
		return m_chkApplyWks.Check;
	}
	//virtual 
	string GetRuntimeClass()
	{
		return "WksListControl";
	}
	//virtual 
	int GetDefaultSize(){return 178;}
	//---- CPY 9/25/03 v7.5707 EDIT_PLOT_SHOW_HIGHLIGHT_IN_WKS_LIST
	void OnStartEdit(const vector<string>& vsWksDatasetNames, int nPageType)
	{
		///Jasmine 03/28/07 QA70-7718 CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT
		//m_AvailData.SelectByPageType(nPageType);
		string strWksDatasetName;
		int nSize = vsWksDatasetNames.GetSize();
		if(nSize)
			strWksDatasetName = vsWksDatasetNames[0];
		///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
		//m_AvailData.SelectByPageType(nPageType, strWksDatasetName);
		string strFirstWks = getFirstWks();
		m_AvailData.SelectByPageType(nPageType, strWksDatasetName, strFirstWks);
		///End CHECK_WKS_PATH_BEFORE_RETURN_DATACOMBO_PROJECT
		
		/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		//updateList(false);
		//updateList(false, NULL, true);
		updateList(false, strFirstWks, true);
		///End REDUCE_UPDATE_WKS_LIST_TIME
		
		/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		// select all the given wks names
		//		m_flx.Col = m_nNameCol;
		//		m_flx.Row = FindRow(wkspg.GetName(), m_nNameCol);
		vector<int> vnRows;
		int nSel = -1;
		for(int ii = 0; ii < nSize; ii++)
		{
			///Jasmine 09/09/08 v8.0935 QA80-12165 BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
			//if((nSel = FindRow(vsWksDatasetNames[ii], m_nNameCol)) < 0)
			string strBook, strSheet;
			if( get_book_sheet_names(vsWksDatasetNames[ii], strBook, strSheet) )
				nSel = findBookSheetRow(strBook, strSheet);
			else
				nSel = findLNameRow(vsWksDatasetNames[ii]);
				
			if(nSel < 0)
			///End BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
			{
				//---- CPY 4/15/07 REMOVE_PRINTF
				//printf("%d:%s not found\n", ii+1, vsWksDatasetNames[ii]);
				string str;
				str.Format("%d:%s not found\n", ii+1, vsWksDatasetNames[ii]);
				_DBMSG(str);
				//----
			}
			else // OK
				vnRows.Add(nSel);
		}
		SelRows(vnRows);
		//printf("OnStartEdit has selected %d rows\n", vnRows.GetSize());
	}
	//---- end EDIT_PLOT_SHOW_HIGHLIGHT_IN_WKS_LIST
	/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	void UpdateList(bool bSelCurrent = true, LPCSTR lpcszWks = NULL, bool bForceUpdate = false)
	{
		updateList(bSelCurrent, lpcszWks, bForceUpdate);
	}
	/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
private:
	///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
	string getFirstWks()
	{
		if(GetNumRows() <= 0)
			return "";
		
		vector<uint> vnRows(1);
		vnRows[0] = GetRowOffset();
					
		vector<string> vsWksNames;
		GetSpecifiedItems(vsWksNames, vnRows);
		return vsWksNames.GetSize() > 0? vsWksNames[0] : "";
	}
	///End REDUCE_UPDATE_WKS_LIST_TIME
	///Jasmine 09/09/08 v8.0935 QA80-12165 BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
	int findLNameRow(LPCSTR lpcszName)
	{
		//DATACOMBO_LOOSEDATA, DATACOMBO_FUNCTIONS
		return FindRow(lpcszName, PEPAGE_LONGNAME);
	}
	int findBookSheetRow(LPCSTR lpcszName, LPCSTR lpcszSheet)
	{
		int nRow = -1;
		
		int nr1 = FindRow(lpcszName, m_nNameCol);
		if( nr1 >= GetRowOffset() )
		{
			int nr2 = FindRow(lpcszSheet, PAGEG_SHEET_NAME, true, true, nr1);
			nRow = nr2 < GetRowOffset()? nr1 : nr2;
		}
		
		return nRow;
	}
	///End BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
	
	//----- CPY 9/8/03 v7.5688 WKS_MAT_SEL_CHECK_CONSISTENT
	// return true for selecting current wks/matrix window
	bool checkAvailDataConsistentWithPlotType(int& nAvilDataType, bool bMakeNewPlot, DWORD dwAuxTypeInfo)
	{
		DWORD dwLayerBits = dwAuxTypeInfo & MASK_PCD_LAYER_BITS;
		
		return true;
	}
	//----- end WKS_MAT_SEL_CHECK_CONSISTENT
	///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
	void _get_folder(Folder& folder, int nOption)
	{
		switch(nOption)
		{
		case DATACOMBO_FOLDER:
		case DATACOMBO_MAT_FOLDER:
			folder = Project.ActiveFolder();
			break;
		case DATACOMBO_PROJECT:
		case DATACOMBO_MAT_PROJECT:
			folder = Project.RootFolder;
			break;
		case DATACOMBO_FAVORITES:	
		case DATACOMBO_MAT_FAVORITES:
			get_favorites_folder(folder);
			break;
		}
	}
	bool _is_same_folder(int nOption, int nOption2) 
	{
		Folder fld, fld2;
		_get_folder(fld, nOption);
		_get_folder(fld2, nOption2);
		
		if(!fld || !fld2)
			return false;
		
		return lstrcmp( fld.GetPath(), fld2.GetPath() ) == 0;
	}
	
	///Jasmine 04/01/10 QA81-14022-P2 COLLECTION_IS_VALID_BY_DEFAULT
	bool _get_page_collection_by_available_data_type(Collection<PageBase>& pages, int nSel, int dwOption)
	{
		bool bRet = false;
		
		if(nSel == DATACOMBO_PROJECT || nSel == DATACOMBO_MAT_PROJECT)
		{
			pages = Project.Pages;
			bRet = true;
		}
		else
		{
			Folder fld;
			_get_folder(fld, nSel);
			if(fld)
			{
				if(dwOption & PLIST_INCLUDE_SHORTCUT)
				{
					pages = fld.PagesAndShortcuts;
				}
				else
				{
					pages = fld.Pages;
				}
				bRet = true;
			}
		}
		
		return bRet;
	}
	///End COLLECTION_IS_VALID_BY_DEFAULT
	
	//assumption:
	//1. when Plot Setup opens, active folder, active page and others will not change
	//2. lpcszWks will compatible with nSel. This means, for example, if nSel = DATACOMBO_FOLDER, lpcszWks is in the folder,
	//	so now lpcszWks is not used and reserved
	int checkIsAvailableDataChange(int nSel, LPCSTR lpcszWks, DWORD dwOption)
	{
		int nChange = UPDATE_LIST_NORMAL;
				
		switch(nSel)
		{
		case DATACOMBO_CURRENT://it takes little time to update one sheet 
			break;
			
		case DATACOMBO_FOLDER:
		case DATACOMBO_PROJECT:
		case DATACOMBO_FAVORITES:
			if(nSel == m_nSel)
			{
				if(dwOption == m_dwOption || DATACOMBO_PROJECT == nSel)///Jasmine 03/29/10 QA81-14022-P1 OPTION_NOT_AFFECT_DATACOMBO_PROJECT
					nChange = UPDATE_LIST_NONE;
				else
				{
					if(dwOption & PLIST_INCLUDE_SHORTCUT)
					{
						if( !(m_dwOption & PLIST_INCLUDE_SHORTCUT) )
							nChange = UPDATE_LIST_ADD_SHORTCUT;
					}
				}
			}
			else
			{
				if(m_nSel != DATACOMBO_FOLDER && m_nSel != DATACOMBO_PROJECT && m_nSel != DATACOMBO_FAVORITES)
					break;
					
				if( _is_same_folder(nSel, m_nSel) )
				{
					if(dwOption == m_dwOption)
						nChange = UPDATE_LIST_NONE;
					else
					{
						if(dwOption & PLIST_INCLUDE_SHORTCUT)
						{
							if( !(m_dwOption & PLIST_INCLUDE_SHORTCUT) )
								nChange = UPDATE_LIST_ADD_SHORTCUT;
						}
					}
					
					break;
				}
				else if(nSel != DATACOMBO_PROJECT && m_nSel != DATACOMBO_PROJECT)
					break;
				
				//if all pages are in one folder
				///Jasmine 04/01/10 QA81-14022-P2 COLLECTION_IS_VALID_BY_DEFAULT
				Collection<PageBase> newPages, oldPages; 
				int nWorksheetPageCount = 0, nWorksheetPageCount2 = 0;
				
				if( _get_page_collection_by_available_data_type(newPages, nSel, dwOption) )
					nWorksheetPageCount = CountPageByType(newPages, EXIST_WKS);
				
				if( _get_page_collection_by_available_data_type(oldPages, m_nSel, m_dwOption) )
					nWorksheetPageCount2 = CountPageByType(oldPages, EXIST_WKS);
				///End COLLECTION_IS_VALID_BY_DEFAULT
				if(nWorksheetPageCount == nWorksheetPageCount2)
					nChange = UPDATE_LIST_NONE;
			}
			
			break;
		
		case DATACOMBO_MAT_FOLDER:
		case DATACOMBO_MAT_PROJECT:
		case DATACOMBO_MAT_FAVORITES:
			if(nSel == m_nSel)
			{
				if(dwOption == m_dwOption || DATACOMBO_MAT_PROJECT == nSel)///Jasmine 03/29/10 QA81-14022-P1 OPTION_NOT_AFFECT_DATACOMBO_PROJECT
					nChange = UPDATE_LIST_NONE;
				else 
				{
					if(dwOption & PLIST_INCLUDE_SHORTCUT)
					{
						if( !(m_dwOption & PLIST_INCLUDE_SHORTCUT) )
							nChange = UPDATE_LIST_ADD_SHORTCUT;
					}
				}
			}
			else
			{
				if(m_nSel != DATACOMBO_MAT_FOLDER && m_nSel != DATACOMBO_MAT_PROJECT && m_nSel != DATACOMBO_MAT_FAVORITES)
					break;
					
				if( _is_same_folder(nSel, m_nSel) )
				{
					if(dwOption == m_dwOption)
						nChange = UPDATE_LIST_NONE;
					else
					{
						if(dwOption & PLIST_INCLUDE_SHORTCUT)
						{
							if( !(m_dwOption & PLIST_INCLUDE_SHORTCUT) )
								nChange = UPDATE_LIST_ADD_SHORTCUT;
						}
					}
					
					break;
				}
				else if(nSel != DATACOMBO_MAT_PROJECT && m_nSel != DATACOMBO_MAT_PROJECT)
					break;
				
				//if all pagesare in one folder
				///Jasmine 04/01/10 QA81-14022-P2 COLLECTION_IS_VALID_BY_DEFAULT
				Collection<PageBase> newPages, oldPages; 
				int nMatrixPageCount = 0, nMatrixPageCount2 = 0;
				
				if( _get_page_collection_by_available_data_type(newPages, nSel, dwOption) )
					nMatrixPageCount = CountPageByType(newPages, EXIST_MATRIX);
				
				if( _get_page_collection_by_available_data_type(oldPages, m_nSel, m_dwOption) )
					nMatrixPageCount2 = CountPageByType(oldPages, EXIST_MATRIX);
				///End COLLECTION_IS_VALID_BY_DEFAULT
				
				if(nMatrixPageCount == nMatrixPageCount2)
					nChange = UPDATE_LIST_NONE;
			}
			
			break;
			
		case DATACOMBO_LOOSEDATA:
		case DATACOMBO_FUNCTIONS:
			nChange = nSel == m_nSel? UPDATE_LIST_NONE : UPDATE_LIST_NORMAL;
			break;
		}
		
		m_nSel 		= nSel;
		m_dwOption 	= dwOption;
		return nChange;
	}
	///End REDUCE_UPDATE_WKS_LIST_TIME
	/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	//void updateList(bool bSelCurrent, LPCSTR lpcszWks = NULL)	///Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT
	void updateList(bool bSelCurrent, LPCSTR lpcszWks = NULL, bool bForceUpdate = false)
	/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	{
		int nSel = m_AvailData.GetCurSel();
		/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
		bool bDoUpdate = bForceUpdate || !m_bIsListUpdated;
		if ( !bDoUpdate )
		{
			return;
		}
		m_bIsListUpdated = true;
		if ( nSel < 0 )
			nSel = DATACOMBO_CURRENT;
		/// End QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
			
		int	nSelPageType = bSelCurrent? EXIST_WKS:EXIST_NONE;
		
		///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
		///------ Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
		//DWORD dwOption = 0;
		DWORD dwOption = PLIST_UPDATE_EXCEL_TO_ORIGIN;
		///------ End ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
		if(m_chkShortcut.Check)
			dwOption |= PLIST_INCLUDE_SHORTCUT;		
		///End OPTION_TO_GET_PAGE
		///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
		int nUpdate = checkIsAvailableDataChange(nSel, lpcszWks, dwOption);
		
		if(nUpdate == UPDATE_LIST_NORMAL)		
			ClearAll();
		
		if(nUpdate == UPDATE_LIST_ADD_SHORTCUT)
			dwOption |= PLIST_INCLUDE_SHORTCUT_ONLY;		
		
		if(nUpdate > UPDATE_LIST_NONE)
		{
			DWORD dwInfo = 0;// dataset
		///End REDUCE_UPDATE_WKS_LIST_TIME
			switch(nSel)
			{
			case DATACOMBO_PROJECT:
				AddAllWksPages(dwOption);
				break;
			case DATACOMBO_FOLDER:
				AddPages(Project.ActiveFolder(), EXIST_WKS, dwOption);
				break;
			case DATACOMBO_CURRENT:
				///Jasmine 04/10/07 QA80-9597 v597b GET_WKS_FROM_DATA_PLOT
				//AddPage(Project.Pages(), EXIST_WKS);
				WorksheetPage wp = Project.Pages();
				if(!wp.IsValid() && lpcszWks)
				{
					Worksheet wks(lpcszWks);
					if(wks.IsValid())
						wp = wks.GetPage();
				}
				AddPage(wp, EXIST_WKS);
				///End GET_WKS_FROM_DATA_PLOT
				break;
			///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
			case DATACOMBO_FAVORITES:
				Folder fldFavor;
				if( get_favorites_folder(fldFavor) )
					AddPages(fldFavor, EXIST_WKS, dwOption);
				break;
			///End ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
			case DATACOMBO_MAT_PROJECT:
				nSelPageType = EXIST_MATRIX;
				AddProjectMatrixPages(dwOption);
				break;
			case DATACOMBO_MAT_FOLDER:
				nSelPageType = EXIST_MATRIX;
				AddPages(Project.ActiveFolder(), EXIST_MATRIX, dwOption);
				break;
			///Jasmine 07/31/09 QA80-14022 ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
			case DATACOMBO_MAT_FAVORITES:
				Folder fldFavor;
				if( get_favorites_folder(fldFavor) )
					AddPages(fldFavor, EXIST_MATRIX, dwOption);
				break;
			///End ADD_FAVORITES_TO_AVAILABLE_DROPDOWN
			case DATACOMBO_LOOSEDATA:
				nSelPageType = EXIST_DATA;
				foreach(string strName in Project.LooseDatasetNames)
				{
					dwInfo = Project.GetDatasetInfo(strName);
					if(dwInfo & PGDN_FUNCTION)
						continue;
					m_flx.AddItem(makeRow(strName));
				}
				break;
			case DATACOMBO_FUNCTIONS:
				nSelPageType = EXIST_DATA;
				foreach(string strName in Project.LooseDatasetNames)
				{
					dwInfo = Project.GetDatasetInfo(strName);
					if(!(dwInfo & PGDN_FUNCTION))
						continue;
					m_flx.AddItem(makeRow(strName));
				}
				break;
			default:
				out_str("Error, m_AvailData returns invalid choice");
				// not supported yet
				break;
			}
			
			ResizeCols(2, 2);
		
		}
		
		//---- CPY 3/23/2007 QA70-9168-P1 STARTUP_WKS_SEL_TO_ACTUAL_ACTIVE
		//m_nNameCol = 0; // need update later
		m_nNameCol = PEPAGE_SHORTNAME;//PEPAGE_LONGNAME;	///Jasmine 08/01/08 QA80-11931 see getCurrentSelPageName, strName to find is page's short name
		//----
		if(bSelCurrent)
		{
			string strSheet;//---- CPY 3/23/2007 QA70-9168-P1 STARTUP_WKS_SEL_TO_ACTUAL_ACTIVE
			string strName = getCurrentSelPageName(nSelPageType, strSheet);
			///Jasmine 09/09/08 v8.0935 QA80-12165 BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
			/*if(!strName.IsEmpty())
			{
				m_flx.Col = m_nNameCol;
				//---- CPY 3/23/2007 QA70-9168-P1 STARTUP_WKS_SEL_TO_ACTUAL_ACTIVE
				//m_flx.Row = FindRow(strName, m_nNameCol);
				int nr1 = FindRow(strName, m_nNameCol);
				if(nr1 >= 0)
				{
					int nr2 = nr1;
					if(!strSheet.IsEmpty())
					{
						nr2 = FindRow(strSheet, PAGEG_SHEET_NAME, true, true, nr1);
						if(nr2 < 0)
							nr2 = nr1;
					}
					m_flx.Row = nr2;
				}
				//----
			}*/
			int nRow = findBookSheetRow(strName, strSheet);
			if(nRow >= GetRowOffset() )
				m_flx.Row = nRow;
			///End BOOK_SHEET_ARE_TWO_COLS_AND_FIND_SEPARATELY
		}
		///Kyle 07/29/08 SELECT_THE_FIRST_ROW_WHEN_THERE_IS_NO_ACTIVE_PAGE_OF_THE_SELECTED_TYPE
		//vector<uint> vnRows;
		//if(!GetSelRows(vnRows) || vnRows.GetSize()<=0)
			//SelRow(1);
		///End SELECT_THE_FIRST_ROW_WHEN_THERE_IS_NO_ACTIVE_PAGE_OF_THE_SELECTED_TYPE
	}
	//------ CPY 10/26/03 AUTO_SEL_LAST_ACTIVE_WKS_MATRIX
	string getCurrentSelPageName(int nPageTypeToSel, string& strSheetName)
	{
		string strTemp;
		Page pg = Project.Pages();
		int	nActiveWinType = EXIST_NONE;

		if(pg)
		{
			nActiveWinType = pg.GetType();
			strTemp = pg.GetName();
		}		

		if(nActiveWinType != nPageTypeToSel)
			strTemp = getLastActivePageName(nPageTypeToSel);
		
		//---- CPY 3/23/2007 QA70-9168-P1 STARTUP_WKS_SEL_TO_ACTUAL_ACTIVE
		if(!strTemp.IsEmpty())
		{
			Page wpg(strTemp);
			Datasheet ds = wpg.Layers();
			if(ds)
				strSheetName = ds.GetName();
		}
		//----
		return strTemp;
	}
	string getLastActivePageName(int nPageType)
	{
		string strTemp;
		string strVar;
		if(EXIST_MATRIX == nPageType)
			strVar = "LastMatrix$";
		else if(EXIST_WKS == nPageType)
			strVar = "LastWks$";
		
		if(strVar.IsEmpty())
			return strTemp;// empty
		
		char	szBuffer[MAXLINE];
		LT_get_str(strVar, szBuffer, MAXLINE);
		strTemp = szBuffer;
		return strTemp;
	}
	//---- end AUTO_SEL_LAST_ACTIVE_WKS_MATRIX
	string makeRow(const string& strDatasetname)
	{
		return strDatasetname;
	}

protected:
	//virtual
	void ClearAll()
	{
		GridListControl::ClearAll();
	}
	///Sophy 7/30/2010 ORG-681-P2 FAIL_TO_SELECT_LOOSE_DATASET_IF_NOT_PLOT_IN_ACTIVE_PAGE
	bool GetSelItems(vector<string>& vsWksNames, int nPageType)
	{
		vector<uint> vnRows;
		if(GetSelRows(vnRows))
		{
			if ( nPageType != EXIST_DATA )
				return GetSpecifiedItems(vsWksNames, vnRows);
			else
			{
				vsWksNames.SetSize(0);
				for ( int ii = 0; ii < vnRows.GetSize(); ii++ )
				{
					string strDataName = GetCell(flexcpText, vnRows[ii], PEPAGE_LONGNAME);
					vsWksNames.Add(strDataName);
				}
			}
			return true;
		}
		return false;
	}
	///end FAIL_TO_SELECT_LOOSE_DATASET_IF_NOT_PLOT_IN_ACTIVE_PAGE

public:
	// return page type, EXIST_*
	int OnSelChange(ColListControl& listCols, int nCommonColsMode)
	{
		vector<string> vsWksNames;
		int nPageType = m_AvailData.GetSelectedPageType();
		///Sophy 7/30/2010 ORG-681-P2 FAIL_TO_SELECT_LOOSE_DATASET_IF_NOT_PLOT_IN_ACTIVE_PAGE
		//if(GetSelItems(vsWksNames)) // assume
		if( GetSelItems(vsWksNames, nPageType) )
		///end FAIL_TO_SELECT_LOOSE_DATASET_IF_NOT_PLOT_IN_ACTIVE_PAGE
		{
			//int nTest = m_AvailData.GetSelectedPageType();
			listCols.UpdateList(vsWksNames, IsApplyWks(), nPageType, nCommonColsMode);
			
			///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
			//Page pg(vsWksNames[0]);
			//if(pg)
			//	return pg.GetType();
			///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
		}
		//else
			//listCols.UpdateList(nPageType);			///Kyle 07/30/08 UPDATE_LIST_WHEN_NO_CONTENT
		return nPageType;
	}
	int GetCurrentPageType() // EXIST_
	{
		return m_AvailData.GetSelectedPageType();
	}
	
	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION}
#ifdef 	CHANGE_DESIGNATION_MODE_BTN
	void OnBeforeMouseDown(ColListControl& listCols, short nButton, short nShift, float X, float Y, bool bDesignation, BOOL* pCancel) 
#else
	void OnBeforeMouseDown(ColListControl& listCols, short nButton, short nShift, float X, float Y, BOOL* pCancel) // listCols arg not used for now, maybe needed later
#endif//CHANGE_DESIGNATION_MODE_BTN
	///End DEFAULT_MODE_AUTO_GET_DESIGNATION
	{
///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
//		int nRow = m_flx.MouseRow;
//		int nCol = m_flx.MouseCol;
//		if(MK_RBUTTON == nButton && 0 == nShift)//&& nCol >= 0 && 0== nRow)
//		{
//			int nx = XTwipsToPixels(X);
//			int ny = YTwipsToPixels(Y);
//			ClientToScreen(nx, ny);
//			//printf("nx = %d, ny = %d\n", nx, ny);
//#ifdef 	CHANGE_DESIGNATION_MODE_BTN
//			WksListControlMenu	myMenu(this, IsInGrid(nRow, nCol), bDesignation);	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
//#else
//			WksListControlMenu	myMenu(this, IsInGrid(nRow, nCol));
//#endif//CHANGE_DESIGNATION_MODE_BTN
//			myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd());
//			int nCmd;
//			if(myMenu.GetCommand(nCmd))
//			{
//				switch(nCmd)
//				{
//				case WLCMENU_HIDE:
//					HideCol(nCol);
//					break;
//				case WLCMENU_SHOW_ALL:
//					HideCol(-1, false);
//					break;
//				case WLCMENU_APPLY_DESIGNATIONS:
//					///Jasmine 08/06/09 QA81-13749 AUTO_APPLY_DESTINATIONS_IN_COL_LIST	
//					//m_chkApplyWks.Check = m_chkApplyWks.Check? false:true;
//					listCols.OnAutoApplyColDesignations();
//					///End AUTO_APPLY_DESTINATIONS_IN_COL_LIST
//					break;
//				case WLCMENU_INCREASE_SIZE:
//					PostDlgMessage(WM_USER_RESIZE_CONTROLS, 0 , LPARAM_RESIZE_CONTROLS_INCREASE);
//					break;
//				case WLCMENU_DECREASE_SIZE:
//					PostDlgMessage(WM_USER_RESIZE_CONTROLS, 0 , LPARAM_RESIZE_CONTROLS_DECREASE);
//					break;					
//				}
//			}
//			return;
//		}
///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	}

	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	void			ShowMenu(ColListControl& listCols, int nx, int ny)
	{
		int nRow = m_flx.MouseRow;
		int nCol = m_flx.MouseCol;
		WksListControlMenu	myMenu(this, IsInGrid(nRow, nCol), listCols.IsDesignationMode());
		myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			switch(nCmd)
			{
			case WLCMENU_HIDE:
				HideCol(nCol);
				break;
			case WLCMENU_SHOW_ALL:
				HideCol(-1, false);
				break;
			case WLCMENU_APPLY_DESIGNATIONS:
				listCols.OnAutoApplyColDesignations();
				break;
			case WLCMENU_INCREASE_SIZE:
				PostDlgMessage(WM_USER_RESIZE_CONTROLS, 0 , LPARAM_RESIZE_CONTROLS_INCREASE);
				break;
			case WLCMENU_DECREASE_SIZE:
				PostDlgMessage(WM_USER_RESIZE_CONTROLS, 0 , LPARAM_RESIZE_CONTROLS_DECREASE);
				break;					
			}
		}
	}
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
private:
	Button			m_chkApplyWks;
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	Button			m_chkShortcut;
	///End OPTION_TO_GET_PAGE
	//ComboBox		m_comboAvailData;
	AvailDataList	m_AvailData;
	bool			m_bIsListUpdated;	/// Kenny 08/17/2009 QA81-14144 IMPROVE_SPEED_UP_PLOT_SETUP_OPENING
	///Jasmine 02/04/10 QA81-14754-P3 REDUCE_UPDATE_WKS_LIST_TIME
	int				m_nSel;
	DWORD 			m_dwOption;
	///End REDUCE_UPDATE_WKS_LIST_TIME
};



//------ CPY 8/21/03 QA70-5034 COL_WKS_CONTEXT_MENU_IMPROVEMENT
// moved to after WksListControl and add Auto Apply Designations
class WksListControlMenu : public Menu
{
public:
#ifdef 	CHANGE_DESIGNATION_MODE_BTN
	WksListControlMenu(WksListControl* pWLcntrl, bool bIsInGrid, bool bDesignation)	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
#else
	WksListControlMenu(WksListControl* pWLcntrl, bool bIsInGrid)
#endif//CHANGE_DESIGNATION_MODE_BTN
	{
		UINT nFlags = bIsInGrid? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		m_nChoice = -1;
		Add(_L("Hide Column"), OnMenuItem, nFlags);
		Add(_L("Show all Columns"), OnMenuItem);
		
		Add(NULL, OnMenuItem);		
		nFlags = pWLcntrl->IsApplyWks()?MF_CHECKED : MF_UNCHECKED;
#ifdef 	CHANGE_DESIGNATION_MODE_BTN		
		if(!bDesignation)	///Jasmine 09/01/08 QA80-11938 DEFAULT_MODE_AUTO_GET_DESIGNATION
			nFlags = MF_DISABLED | MF_GRAYED;
#endif//CHANGE_DESIGNATION_MODE_BTN
		Add(_L("Auto Apply Designations"), OnMenuItem, nFlags);
		
		Add(NULL, OnMenuItem);
		Add(STR_INCREASE_HEIGHT, OnMenuItem);
		Add(STR_DECREASE_HEIGHT, OnMenuItem);		
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= WLCMENU_HIDE && m_nChoice <= WLCMENU_DECREASE_SIZE)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
//-----

#endif //_WKS_LIST_CONTORL_H



