/*------------------------------------------------------------------------------*
 * File Name: Wks2Vm.h															*
 * Creation: Bill 01/10/2010													*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Bill 01/19/2011 ORG-1632-P2 INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT				*
 *	Sophy 3/5/2011 ORG-923-P3 PROPER_INIT_COLUMN_LABELS_FROM_ACTIVE_WORKSHEET_WHEN_ON_SCRIPT_MODE
 *	Folger 04/07/2011 ORG-2601-P1 SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT		*
 *	Folger 10/06/2012 ORG-428-P1 VIRTUAL_MATRIX_PLOT_AXIS_TITLE_FAILED_TO_SHOW_CORRECTLY_WHEN_COME_FROM_COLUMN_LABEL
 *------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <GetNBox.h>
#include <xfutils.h>

#include <..\Originlab\WksColLabels.h>
#include <..\Originlab\theme_utils.h>
#include <..\OriginLab\Wks2Vm.h>

int VirtualMatrixConstructor::Init(const TreeNode& trGetN)
{
	TreeNode trIrng = trGetN.irng;
	TreeNode trRowrng = trGetN.rowrng;
	TreeNode trColrng = trGetN.colrng;
	okxf_resolve_tree_construct_range(&trIrng, &m_irng);
	///Sophy 5/3/2012 ORG-5377-P1 PROPER_CHECK_WORKSHEET_SELECTION_FOR_PLOTVM
	if ( m_irng && !m_irng.IsEmpty() )
		m_irng.ConvertToContiguous();
	///end PROPER_CHECK_WORKSHEET_SELECTION_FOR_PLOTVM
	okxf_resolve_tree_construct_range(&trRowrng, &m_rowrng);
	okxf_resolve_tree_construct_range(&trColrng, &m_colrng);
	///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
	//if ( !m_irng || m_irng.IsEmpty() )
		//return XFERR_RANGE_LESS_THAN_2X2;
	//
	//m_irng.GetRange(0, m_nR1, m_nC1, m_nR2, m_nC2, m_wks);
	//if ( !m_wks )
		//return XFERR_RANGE_LESS_THAN_2X2;
	//_update_input_range(m_nR1, m_nC1, m_nR2, m_nC2, m_wks);
	//m_nZr1 = m_nR1, m_nZc1 = m_nC1, m_nZr2 = m_nR2, m_nZc2 = m_nC2; //these values might be updated later.
	//m_nFormat = trGetN.format.nVal;
	//m_nRowMode = trGetN.rowpos.nVal;
	//m_nColMode = trGetN.colpos.nVal;
	//if ( m_nFormat != FORMAT_XACROSS && m_nFormat != FORMAT_YACROSS )
		//return XFERR_VM_INVALID_DATAFORMAT; //invalid format.
	//
	//return CER_NO_ERROR;
	return InitSettings(trGetN);
	///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
}

///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
int		VirtualMatrixConstructor::Init(const TreeNode& trGetN, Range& irng, Range& rowrng, Range& colrng)
{
	m_irng = irng;
	m_rowrng = rowrng;
	m_colrng = colrng;
	return InitSettings(trGetN);
}

int VirtualMatrixConstructor::InitSettings(const TreeNode& trGetN)
{
	if ( !m_irng || m_irng.IsEmpty() )
		return XFERR_RANGE_LESS_THAN_2X2;
	
	m_irng.GetRange(0, m_nR1, m_nC1, m_nR2, m_nC2, m_wks);
	if ( !m_wks )
		return XFERR_RANGE_LESS_THAN_2X2;
	update_input_range(m_nR1, m_nC1, m_nR2, m_nC2, m_wks);
	m_nZr1 = m_nR1, m_nZc1 = m_nC1, m_nZr2 = m_nR2, m_nZc2 = m_nC2; //these values might be updated later.
	m_nFormat = trGetN.format.nVal;
	m_nRowMode = trGetN.rowpos.nVal;
	m_nColMode = trGetN.colpos.nVal;
	if ( m_nFormat != FORMAT_XACROSS && m_nFormat != FORMAT_YACROSS )
		return XFERR_VM_INVALID_DATAFORMAT; //invalid format.
	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	m_nColLabelIndex = 0;
	if ( m_nRowMode == ROWPOS_LABEL )
	{
		vector<string> vstrLabelName;
		vector<int> vnLabelNum;	
		get_wks_shown_col_label_info(m_wks, vstrLabelName, vnLabelNum);
		///------ Folger 04/07/2011 ORG-2601-P1 SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT
		//int nPos  = vstrLabelName.Find(trGetN.label.strVal);
		string		strLabel = trGetN.label.strVal;
		convert_label_name_identifier(strLabel, m_wks, TRUE);
		int nPos  = vstrLabelName.Find(strLabel);
		///------ End SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT
		if ( nPos >= 0 )		//this should be always successful
			m_nColLabelIndex = nPos - vstrLabelName.GetSize();
		else
		{
			ASSERT(FALSE);
			return XFERR_VM_INVALID_DATAFORMAT;
		}
	}
	///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	if ( m_nC2 - m_nC1 < 1 || m_nR2 - m_nR1 < 1 )
		return XFERR_RANGE_LESS_THAN_2X2;
	return CER_NO_ERROR;
}
///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH

int VirtualMatrixConstructor::InitRowRange()
{
	int nRowRange = VM_NORMAL_RANGE;
	int nColStartOffset = (COLPOS_SELCOL1 == m_nColMode || COLPOS_WKSCOL1 == m_nColMode && m_nC1 == 0) ? 1 : 0;
	//update Z range
	m_nZc1 = m_nC1 + nColStartOffset; ///Sophy 8/24/2010 ORG-815-P11 CENTRALIZE_CODE_UPDATE_Z_RANGE_INDICES
	switch(m_nRowMode)
	{
	case ROWPOS_NONE:
		nRowRange = VM_NO_ROW_RANGE;
		break;
	case ROWPOS_SELROW1:
		m_nRr1 = m_nR1;
		m_nRc1 = m_nC1 + nColStartOffset;
		m_nRr2 = m_nR1;
		m_nRc2 = m_nC2;
		break;
	case ROWPOS_WKSROW1:
		m_nRr1 = 0;
		m_nRc1 = m_nC1 + nColStartOffset;
		m_nRr2 = 0;
		m_nRc2 = m_nC2;
		break;
	case ROWPOS_LABEL:
		///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		//m_nRr1 = sg_nColLabel;
		m_nRr1 = m_nColLabelIndex;
		///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		m_nRc1 = m_nC1 + nColStartOffset;
		///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		//m_nRr2 = sg_nColLabel;
		m_nRr2 = m_nColLabelIndex;
		///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		m_nRc2 = m_nC2;
		break;
	case ROWPOS_CUSTOM:
		{
			int rr1, rc1, rr2, rc2;
			Datasheet dsRow;
			if ( !m_rowrng || m_rowrng.IsEmpty() )
				return (FORMAT_XACROSS == m_nFormat) ? XFERR_INVALID_X_COORD : XFERR_INVALID_Y_COORD;
			m_rowrng.GetRange(0, m_nRr1, m_nRc1, m_nRr2, m_nRc2, dsRow);
			if ( !dsRow || !is_same_layer(dsRow, m_wks) )
				return XFERR_SELECT_DIFF_WORKSHEET;
			
			int nRowSelMode = get_range_mode(m_rowrng);
			if ( (nRowSelMode & SEL_WHOLE_ROW) )
			{
				if ( m_nRr1 >= 0 )
					update_input_range(m_nRr1, m_nRc1, m_nRr2, m_nRc2, dsRow);
				if ( m_nRc1 < m_nZc1 )
					m_nRc1 = m_nZc1;
				if ( m_nRc2 > m_nZc2 || m_nRc2 < 0 )	///Sophy 8/20/2010 ORG-815-P8 PROPER_INIT_CUSTOM_RANGE_WHEN_SELECT_WHOLE_LABEL_ROW
					m_nRc2 = m_nZc2;
			}
		}
		break;
	default:
		ASSERT(false);
		nRowRange = VM_NO_ROW_RANGE;
		break;
	}
	return nRowRange;
}

int VirtualMatrixConstructor::InitColRange()
{
	int nColRange = VM_NORMAL_RANGE;
	int nRowStartOffset = (ROWPOS_SELROW1 == m_nRowMode || ROWPOS_WKSROW1 == m_nRowMode && m_nR1 == 0) ? 1 : 0;
	
	//update Z range
	m_nZr1 = m_nR1 + nRowStartOffset;	///Sophy 8/24/2010 ORG-815-P11 CENTRALIZE_CODE_UPDATE_Z_RANGE_INDICES
	
	switch(m_nColMode)
	{
	case COLPOS_NONE:
		nColRange = VM_NO_COL_RANGE;
		break;
	case COLPOS_SELCOL1:
		m_nCr1 = m_nR1 + nRowStartOffset;
		m_nCc1 = m_nC1;
		m_nCr2 = m_nR2;
		m_nCc2 = m_nC1;
		break;
	case COLPOS_WKSCOL1:
		m_nCr1 = m_nR1 + nRowStartOffset;
		m_nCc1 = 0;
		m_nCr2 = m_nR2;
		m_nCc2 = 0;
		break;
	case COLPOS_XCOL:
		{
			int nXIndex = m_wks.FindColIndex(m_nC1, OKDATAOBJ_DESIGNATION_X, FCI_NO_CHECK_EVEN_SPACED);
			if ( nXIndex >= 0 )
			{
				m_nCr1 = m_nR1 + nRowStartOffset;
				m_nCc1 = nXIndex;
				m_nCr2 = m_nR2;
				m_nCc2 = nXIndex;
			}
			else
			{
				nColRange = VM_NO_COL_RANGE;
			}
		}
		break;
	case COLPOS_CUSTOM:
		{
			Datasheet dsCol;
			if ( !m_colrng || m_colrng.IsEmpty() )
				return (FORMAT_XACROSS == m_nFormat) ? XFERR_INVALID_Y_COORD : XFERR_INVALID_X_COORD;
			m_colrng.GetRange(0, m_nCr1, m_nCc1, m_nCr2, m_nCc2, dsCol);
			if ( !dsCol || !is_same_layer(dsCol, m_wks) )
				return XFERR_SELECT_DIFF_WORKSHEET;
			
			int nColSelMode = get_range_mode(m_colrng);
			if ( (nColSelMode & SEL_WHOLE_COL) )
			{
				if ( m_nCr1 >= 0 )
					update_input_range(m_nCr1, m_nCc1, m_nCr2, m_nCc2, dsCol);
				if ( m_nCr1 < m_nZr1 )
					m_nCr1 = m_nZr1;
				if ( m_nCr2 > m_nZr2 || m_nCr2 < 0 ) ///Sophy 8/20/2010 ORG-815-P8 PROPER_INIT_CUSTOM_RANGE_WHEN_SELECT_WHOLE_LABEL_ROW
					m_nCr2 = m_nZr2;
			}
		}
		break;
	default:
		ASSERT(false);
		nColRange = VM_NO_COL_RANGE;
		break;
	}
	return nColRange;
}

BOOL VirtualMatrixConstructor::MakeVirtualMatrixRange(const TreeNode& trGetN, DataRange& drVM)
{
	if ( CER_NO_ERROR != Init(trGetN) )
		return FALSE;
	
	return AddRanges(drVM);
}

///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
BOOL VirtualMatrixConstructor::MakeVirtualMatrixRange(const TreeNode& trGetN, Range& irng, Range& rowrng, Range& colrng, DataRange& drVM)
{
	if ( CER_NO_ERROR != Init(trGetN, irng, rowrng, colrng) )
		return FALSE;
	
	return AddRanges(drVM);
}

BOOL VirtualMatrixConstructor::AddRanges(DataRange& drVM)
{
	BOOL bRet = TRUE;
	bRet &= AddX(drVM);
	bRet &= AddY(drVM);
	bRet &= AddZ(drVM);
	return bRet;
}
///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH

BOOL VirtualMatrixConstructor::AddX(DataRange& drVM)
{
	if ( FORMAT_XACROSS == m_nFormat )
		return AddRow(drVM, "X");
	else
		return AddCol(drVM, "X");
	return TRUE;
}

BOOL VirtualMatrixConstructor::AddY(DataRange& drVM)
{
	if ( FORMAT_XACROSS == m_nFormat )
		return AddCol(drVM, "Y");
	else
		return AddRow(drVM, "Y");
	return TRUE;
}

BOOL VirtualMatrixConstructor::AddZ(DataRange& drVM)
{
	drVM.Add("Z", m_wks, m_nZr1, m_nZc1, m_nZr2, m_nZc2);
	return TRUE;
}

BOOL VirtualMatrixConstructor::AddRow(DataRange& drVM, LPCSTR lpcszName)
{
	int nInitRet = InitRowRange();
	if ( VM_NO_ROW_RANGE == nInitRet )
		return TRUE; //no need to add
	else if ( VM_NORMAL_RANGE == nInitRet )
	{
		drVM.Add(lpcszName, m_wks, m_nRr1, m_nRc1, m_nRr2, m_nRc2);
	}
	else //error when init range
	{
		return FALSE;
	}
	return TRUE;
}

BOOL VirtualMatrixConstructor::AddCol(DataRange& drVM, LPCSTR lpcszName)
{
	int nInitRet = InitColRange();
	if ( VM_NO_COL_RANGE == nInitRet )
		return TRUE; //no need to add
	else if ( VM_NORMAL_RANGE == nInitRet )
	{
		drVM.Add(lpcszName, m_wks, m_nCr1, m_nCc1, m_nCr2, m_nCc2);
	}
	else //error when init range
	{
		return FALSE;
	}
	return TRUE;
}

int VirtualMatrixConstructor::UpdateGUI(TreeNode& trGetN, bool bAllowAuto)
{
	int nInit = Init(trGetN);
	int nRowInit = InitRowRange();
	int nColInit = InitColRange();
	
	//update labels
	TreeNode trRow = trGetN.rowpos;
	TreeNode trCol = trGetN.colpos;
	BOOL bTransPosed = FORMAT_YACROSS == m_nFormat;
	trRow.SetAttribute(STR_LABEL_ATTRIB, bTransPosed ? STR_Y_VALUES_IN : STR_X_VALUES_IN);
	trCol.SetAttribute(STR_LABEL_ATTRIB, bTransPosed ? STR_X_VALUES_IN : STR_Y_VALUES_IN);
	trGetN.rowrng.SetAttribute(STR_LABEL_ATTRIB, bTransPosed ? STR_Y_VALUES : STR_X_VALUES);
	trGetN.colrng.SetAttribute(STR_LABEL_ATTRIB, bTransPosed ? STR_X_VALUES : STR_Y_VALUES);

	//update combolists
	int nSelMode = get_range_mode(m_irng);
	string strCombo, strMap;
	vector<string>	vsLabels, vsIndices;
	//row combolist, default value
	bool bAutoRow = bAllowAuto && (octree_get_auto_support(&trRow) == 1); //whether need to auto init mode selection
	vsLabels.Add(_L("None"));	vsIndices.Add(ROWPOS_NONE);
	vsLabels.Add(_L("1st row in selection"));	vsIndices.Add(ROWPOS_SELROW1);
	if ( !(IS_WHOLE_SHEET(nSelMode)) )
	{
		vsLabels.Add(_L("1st row in worksheet"));	vsIndices.Add(ROWPOS_WKSROW1);
		if ( bAutoRow )
			m_nRowMode = ROWPOS_NONE;
	}
	else
	{
		if ( bAutoRow )
			m_nRowMode = ROWPOS_SELROW1;
	}
	vsLabels.Add(_L("Column Label"));	vsIndices.Add(ROWPOS_LABEL);
	vsLabels.Add(_L("Custom"));		vsIndices.Add(ROWPOS_CUSTOM);
	strCombo.SetTokens(vsLabels, '|');
	strMap.SetTokens(vsIndices, '|');
	trRow.SetAttribute(STR_COMBO_ATTRIB, strCombo);	trRow.SetAttribute(STR_INTMAP_ATTRIB, strMap);
	//invalid, should be updated
	if ( vsIndices.Find((string)m_nRowMode) < 0 )
		m_nRowMode = ROWPOS_SELROW1;
	
	trRow.nVal = m_nRowMode;
	octree_set_auto_support(&trRow, 0);
	//column combolist, default value
	bool bAutoCol = bAllowAuto && (octree_get_auto_support(&trCol) == 1); //whether need to auto init mode selection
	vsLabels.SetSize(0);	vsIndices.SetSize(0);
	vsLabels.Add(_L("None"));	vsIndices.Add(COLPOS_NONE);
	vsLabels.Add(_L("1st column in selection"));	vsIndices.Add(COLPOS_SELCOL1);
	if ( !(IS_WHOLE_SHEET(nSelMode)) )
	{
		vsLabels.Add(_L("1st column in worksheet"));	vsIndices.Add(COLPOS_WKSCOL1);
		int nXIndex = m_wks.IsValid() ? m_wks.FindColIndex(m_nC1, OKDATAOBJ_DESIGNATION_X, FCI_NO_CHECK_EVEN_SPACED) : -1;
		if ( nXIndex >= 0 )
		{
			vsLabels.Add(_L("X column to the left of selection"));	vsIndices.Add(COLPOS_XCOL);
			if ( bAutoCol )
				m_nColMode = COLPOS_XCOL;
		}
		else if ( bAutoCol )
			m_nColMode = COLPOS_NONE;
	}
	else
	{
		if ( bAutoCol )
			m_nColMode = COLPOS_SELCOL1;
	}
	vsLabels.Add(_L("Custom"));		vsIndices.Add(COLPOS_CUSTOM);
	strCombo.SetTokens(vsLabels, '|');
	strMap.SetTokens(vsIndices, '|');
	trCol.SetAttribute(STR_COMBO_ATTRIB, strCombo);	trCol.SetAttribute(STR_INTMAP_ATTRIB, strMap);
	//invalid, should be updated.
	if ( vsIndices.Find((string)m_nColMode) < 0 )
	{
		if ( IS_WHOLE_SHEET(nSelMode) )
			m_nColMode = COLPOS_SELCOL1;
		else if ( vsIndices.Find((string)COLPOS_WKSCOL1) >= 0 )
			m_nColMode = COLPOS_WKSCOL1;
		else
			m_nColMode = COLPOS_NONE;
	}
	trCol.nVal = m_nColMode;
	octree_set_auto_support(&trCol, 0);
	
	//show hide controls
	trGetN.label.Show = (ROWPOS_LABEL == m_nRowMode);
	trGetN.rowrng.Show = (ROWPOS_CUSTOM == m_nRowMode);
	trGetN.colrng.Show = (COLPOS_CUSTOM == m_nColMode);
	return CER_NO_ERROR;
}

int VirtualMatrixConstructor::CheckInput(TreeNode& trGetN)
{
	int nInit = Init(trGetN);
	if ( CER_NO_ERROR != nInit )
		return nInit;
	
	int nRowInit = InitRowRange();
	if ( CER_NO_ERROR != nRowInit && VM_NORMAL_RANGE != nRowInit && VM_NO_ROW_RANGE != nRowInit )
		return nRowInit;
	
	int nColInit = InitColRange();
	if ( CER_NO_ERROR != nColInit && VM_NORMAL_RANGE != nColInit && VM_NO_COL_RANGE != nColInit )
		return nColInit;
	
	//check Z range
	if ( m_nZc2 - m_nZc1 < 1 || m_nZr2 - m_nZr1 < 1 )
		return XFERR_RANGE_LESS_THAN_2X2;
	
	//check row range
	if ( ROWPOS_NONE != m_nRowMode ) //if not none, need to check monotonic and range
	{
		if ( m_nRr2 != m_nRr1 )
			return XFERR_REQUIRE_SINGLE_ROW;
		if ( m_nRc1 != m_nZc1 || m_nRc2 != m_nZc2 )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_X_COORD_IS_NOT_MATCH_WITH_INPUT_DATA_WIDTH : XFERR_Y_COORD_IS_NOT_MATCH_WITH_INPUT_DATA_HEIGHT;
		if ( ROWPOS_CUSTOM == m_nRowMode && m_nRr1 >= m_nZr1 && m_nRr1 <= m_nZr2 )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_IRNG_ACROSS_X_VALUES : XFERR_IRNG_ACROSS_Y_VALUES;
		int nFlag = is_subrng_valid_xy_array(m_wks, m_nRr1, m_nRc1, m_nRr2, m_nRc2, false);
		if ( 0 == nFlag )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_RANGE_X_NOT_MONOTONIC : XFERR_RANGE_Y_NOT_MONOTONIC;
		else if ( -1 == nFlag )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_ROW_PARAMETER_EMPTY_OR_HAS_TEXT_DATA : XFERR_COL_PARAMETER_EMPTY_OR_HAS_TEXT_DATA;
	}
	
	//check column range
	if ( COLPOS_NONE != m_nColMode ) //not none, need to check
	{
		if ( m_nCc1 != m_nCc2 )
			return XFERR_REQUIRE_SINGLE_COL;
		if ( m_nCr1 != m_nZr1 || m_nCr2 != m_nZr2 )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_Y_COORD_IS_NOT_MATCH_WITH_INPUT_DATA_HEIGHT : XFERR_X_COORD_IS_NOT_MATCH_WITH_INPUT_DATA_WIDTH;
		if ( COLPOS_CUSTOM == m_nColMode && m_nCc1 >= m_nZc1 && m_nCc1 <= m_nZc2 )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_IRNG_ACROSS_Y_VALUES : XFERR_IRNG_ACROSS_X_VALUES;
		int nFlag = is_subrng_valid_xy_array(m_wks, m_nCr1, m_nCc1,  m_nCr2, m_nCc2, true);
		if ( 0 == nFlag )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_RANGE_Y_NOT_MONOTONIC : XFERR_RANGE_X_NOT_MONOTONIC;
		else if ( -1 == nFlag )
			return (FORMAT_XACROSS == m_nFormat) ? XFERR_COL_PARAMETER_EMPTY_OR_HAS_TEXT_DATA : XFERR_ROW_PARAMETER_EMPTY_OR_HAS_TEXT_DATA;
	}
	
	return CER_NO_ERROR;
}

// util functions

bool construct_virtual_range(TreeNode& trGetN, DataRange& drVM)
{
	VirtualMatrixConstructor vmc;
	return vmc.MakeVirtualMatrixRange(trGetN, drVM);
}

///Sophy 8/27/2010 ORG-923-P1 LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH
//when from LT script, use "1!" for range can not be resolved since result graph is active page at that moment.
bool construct_virtual_range(TreeNode&trGetN, Range& irng, Range& rowrng, Range& colrng, DataRange& drVM)
{
	VirtualMatrixConstructor vmc;
	return vmc.MakeVirtualMatrixRange(trGetN, irng, rowrng, colrng, drVM);
}
///end LT_EXECUTE_FAIL_TO_RESOLVE_INPUT_RANGE_DUE_TO_ACTIVE_RESULT_GRAPH

// event handlers

static void load_err_msg(int nErr, const TreeNode& trGetN, string& strErrMsg)
{
	BOOL bTranspose = (FORMAT_YACROSS == trGetN.format.nVal);
	strErrMsg = nErr;
	if ( XFERR_INVALID_SERIES_NAME == nErr )
	{
		string strZtitle = trGetN.ztitle.strVal;
		strErrMsg += ":" + strZtitle;
	}
	else if ( XFERR_REQUIRE_SINGLE_COL == nErr )
	{
		strErrMsg += ":" + (bTranspose ? STR_X_VALUES : STR_Y_VALUES);
	}
	else if ( XFERR_REQUIRE_SINGLE_ROW == nErr )
	{
		strErrMsg += ":" + (bTranspose ? STR_Y_VALUES : STR_X_VALUES);
	}
}

static int check_input(const TreeNode& trGetN)
{
	VirtualMatrixConstructor vmc;
	return vmc.CheckInput(trGetN);
}

static void update_gui_on_format_change(TreeNode& trGetN, bool bAllowAuto)
{
	VirtualMatrixConstructor vmc;
	vmc.UpdateGUI(trGetN, bAllowAuto);
}

///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
//static int	sg_nColLabel;
//static bool init_column_label(TreeNode& trGetN, const Worksheet& wks, bool bInit, int* pnColLabel)
static bool init_column_label(TreeNode& trGetN, const Worksheet& wks, bool bInit)
///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
{
	ASSERT( wks );
	if( !wks )
	{
		trGetN.label.Enable = false;
		return false;
	}

	vector<string> vstrLabelName;
	vector<int> vnLabelNum;	
	get_wks_shown_col_label_info_skip_specials( wks, vstrLabelName, vnLabelNum );
		
	string strTemp;
	strTemp.SetTokens( vstrLabelName, '|' );
	strTemp += "|";
	
	trGetN.label.SetAttribute( STR_COMBO_ATTRIB, strTemp );
		
	if( bInit )
	{
		///------ Folger 04/07/2011 ORG-2601-P1 SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT
		//int nSize = vstrLabelName.GetSize();
		//if( nSize >= 0 )
		//{
			//trGetN.label.strVal = vstrLabelName[nSize - 1];
		//}
		check_init_getn_label_combo(trGetN.label, vstrLabelName, wks, FALSE);
		///------ End SIMPLE_CHAR_TO_SPECIFY_LABEL_ROW_IN_LT
	}
	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	//get_wks_shown_col_label_info( wks, vstrLabelName, vnLabelNum );
					//
	//int nPos  = vstrLabelName.Find(trGetN.label.strVal);
	//
	//if( -1 != nPos )
	//{
		//trGetN.label.Enable = true;
		//*pnColLabel =  nPos - vstrLabelName.GetSize();
	//}
	//else
	//{
		//ASSERT( FALSE );
		//trGetN.label.Enable = false;
		//return false;
	//}
	///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	
	return true;
}

static bool init_dlg(TreeNode &trGetN, const Worksheet &wks)
{
	trGetN.type.Show 		= false;
	trGetN.ogl.Show 		= false;
	trGetN.AutoUpdate.Show 	= false; 
	
	ASSERT(wks);
	if( !wks )
	{
		trGetN.label.Enable = false;
		return false;
	}
	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	//return init_column_label(trGetN, wks, true, &sg_nColLabel);
	return init_column_label(trGetN, wks, true);
	///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
}

static bool get_longname_units_format_string(Column& col, string& strLNUnits)
{
	if ( !col )
		return false;
	string strName = col.GetLongName();
	if ( strName.IsEmpty() )
		strName = col.GetName();
	string strUnits = col.GetUnits();
	if ( strUnits.IsEmpty() )
		strLNUnits = strName;
	else
		strLNUnits.Format("%s (%s)", strName, strUnits);
	return true;
}

static int get_range_mode(Range& irng)
{
	int nSelMode = SEL_INVALID;
	if ( irng.IsEmpty() )
		return SEL_INVALID;
	
	Datasheet ds;
	int r1, c1, r2, c2;
	if ( !irng.GetRange(0, r1, c1, r2, c2, ds) || !ds.IsValid() )
		return SEL_INVALID;

	if ( r1 == 0 && (r2 == -1 || r2 == ds.GetNumRows() - 1) )
		nSelMode |= SEL_WHOLE_COL;
	if ( c1 == 0 && (c2 == -1 || c2 == ds.GetNumCols() - 1) )
		nSelMode |= SEL_WHOLE_ROW;
	
	if ( r1 == r2 )
		nSelMode |= SEL_SINGLE_ROW;
	if ( c1 == c2 )
		nSelMode |= SEL_SINGLE_COL;

	return nSelMode;
}

static int update_xyz_titles(TreeNode& trGetN)
{
	DataRange irng;
	TreeNode trInput = trGetN.irng;
	if ( !okxf_resolve_tree_construct_range(&trInput, &irng) )
		return CER_INVALID_DATA;
	Worksheet wks;
	int r1, r2, c1, c2;
	irng.GetRange(0, r1, c1, r2, c2, wks);
	if ( !wks )
		return XFERR_RANGE_LESS_THAN_2X2;
	
	TreeNode trXtitle = trGetN.xtitle;
	TreeNode trYtitle = trGetN.ytitle;
	TreeNode trZtitle = trGetN.ztitle;
	
	//update X/Y titles
	int nFormat = trGetN.format.nVal;
	int nRowMode = trGetN.rowpos.nVal;
	int nColMode = trGetN.colpos.nVal;
	bool bXAuto = octree_get_auto_support(&trXtitle) == 1;
	bool bYAuto = octree_get_auto_support(&trYtitle) == 1;
	if ( ROWPOS_LABEL == nRowMode )
	{
		///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		//int nType = get_label_type_by_name(wks, trGetN.label.strVal);
		//string strLabel = get_label_name_by_type(nType, wks);
		string strLabel = trGetN.label.strVal;
		///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
		///------ Folger 10/06/2012 ORG-428-P1 VIRTUAL_MATRIX_PLOT_AXIS_TITLE_FAILED_TO_SHOW_CORRECTLY_WHEN_COME_FROM_COLUMN_LABEL
		convert_label_name_identifier(strLabel, wks, TRUE);
		///------ End VIRTUAL_MATRIX_PLOT_AXIS_TITLE_FAILED_TO_SHOW_CORRECTLY_WHEN_COME_FROM_COLUMN_LABEL
		
		string strName;
		Column col(wks, c1);
		get_longname_units_format_string(col, strName);
		if ( FORMAT_XACROSS == nFormat )
		{
			if ( bXAuto )
				trXtitle.strVal = strLabel;
			if ( bYAuto )
				trYtitle.strVal = strName;
		}
		else
		{
			if ( bXAuto )
				trXtitle.strVal = strName;
			if ( bYAuto )
				trYtitle.strVal = strLabel;
		}
	}
	else
	{
		if ( bXAuto )
			trXtitle.strVal = "X Title";
		if ( bYAuto )
			trYtitle.strVal = "Y Title";
	}
	
	if ( COLPOS_CUSTOM == nColMode )
	{
		XYRange colrng;
		xy_range_from_GetN_data_node(trGetN.colrng, colrng);
		
		Worksheet wks;
		int r1, r2, c1, c2;
		colrng.GetRange(0, r1, c1, r2, c2, wks);
		if ( !wks )
			return CER_INVALID_DATA;
		
		string strName;
		Column col(wks, c1);
		get_longname_units_format_string(col, strName);
		if ( FORMAT_XACROSS == nFormat )
		{
			if ( bYAuto )
				trYtitle.strVal = strName;
		}
		else if ( FORMAT_YACROSS == nFormat )
		{
			if ( bXAuto )
				trXtitle.strVal = strName;
		}
	}
	///Sophy 8/19/2010 ORG-815-P5 AUTO_INIT_XY_TITLE_WHEN_SEL_X_TO_LEFT_SELECTION_MODE
	else if ( COLPOS_XCOL == nColMode || COLPOS_WKSCOL1 == nColMode || COLPOS_SELCOL1 == nColMode)
	{
		int nXIndex = (COLPOS_XCOL == nColMode) ? wks.FindColIndex(c1, OKDATAOBJ_DESIGNATION_X, FCI_NO_CHECK_EVEN_SPACED) : ((COLPOS_WKSCOL1 == nColMode) ? 0 : c1);
		if ( nXIndex >= 0 )
		{
			Column colX(wks, nXIndex);
			string strName;
			get_longname_units_format_string(colX, strName);
			if ( FORMAT_XACROSS == nFormat )
			{
				if ( bYAuto )
					trYtitle.strVal = strName;
			}
			else if ( FORMAT_YACROSS == nFormat )
			{
				if ( bXAuto )
					trXtitle.strVal = strName;
			}
		}

	}
	///end AUTO_INIT_XY_TITLE_WHEN_SEL_X_TO_LEFT_SELECTION_MODE
	
	//update Z title
	DataRange drVM;
	if ( construct_virtual_range(trGetN, drVM) )
	{
		string strZtitle = trGetN.ztitle.strVal;
		if ( strZtitle.IsEmpty() )
			return XFERR_Z_TITLE_IS_EMPTY;
		else
		{
			MatrixObject mo;
			if ( mo.Attach(drVM, FORMAT_YACROSS == nFormat ? MATOBJATTACH_TRANSPOSE : 0) )
			{
				string strUpdated = strZtitle;
				BOOL bValidName = mo.CheckUpdateVSName(strUpdated);
				if ( !bValidName )
					return XFERR_INVALID_SERIES_NAME;
			}
		}
	}
	return CER_NO_ERROR;
}

int wks_to_vm_event1_event_handler(TreeNode& trGetN, int nRow, int nEventID, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& DynaCntrlContainer, string& strAux, string& strErrMsg, bool & bOKEnable)
{
	int nErr = CER_NO_ERROR;
	Worksheet wks;
	///Sophy 5/3/2012 ORG-5377-P1 PROPER_CHECK_WORKSHEET_SELECTION_FOR_PLOTVM
	//okxf_resolve_string_get_origin_object(trGetN.irng.strVal, &wks);
	DataRange drInput;
	okxf_init_range_from_string(&drInput, trGetN.irng.strVal);
	if ( drInput.IsValid() && !drInput.IsEmpty() )
	{
		int nC1, nC2;
		drInput.ConvertToContiguous();
		drInput.GetRange(wks, nC1, nC2);
	}
	///end PROPER_CHECK_WORKSHEET_SELECTION_FOR_PLOTVM
	ASSERT(wks);
	if(!wks)
		nErr = CER_NO_NUMERIC_WORKSHEET;
	
	bool bInitDlg = (GETNE_ON_INIT == nEventID) || (GETNE_ON_THEME == nEventID);
	if ( bInitDlg )
		init_dlg(trGetN, wks);
	
	int nThemeSettings = xf_is_theme_applied(trGetN);
	vector<string> vsNodes = {"rowpos", "colpos", "format", "irng"};
	string strNodeName(lpcszNodeName);
	if ( bInitDlg || vsNodes.Find(strNodeName) >= 0 )
		update_gui_on_format_change(trGetN, (THEME_NONE == nThemeSettings));
	
	///Sophy 8/20/2010 ORG-815-P9 PROPER_INIT_Z_TITLE_WHEN_RELOAD_THEME
	if ( bInitDlg )
		init_xyz_titles(trGetN); //this event should be trigger after update_gui_on_format_change, whith might affect the Z range
	///end PROPER_INIT_Z_TITLE_WHEN_RELOAD_THEME
	
	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	//vector<string> vsColLabels = {"rowpos", "label"};
	//if ( vsColLabels.Find(strNodeName) >= 0 )
		//_init_column_label(trGetN, wks, false, &sg_nColLabel);
	///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	
	if ( CER_NO_ERROR == nErr )
		nErr = check_input(trGetN);
	
	if ( CER_NO_ERROR == nErr )
	{
		nErr = update_xyz_titles(trGetN);
	}
	if ( CER_NO_ERROR != nErr )
	{
		load_err_msg(nErr, trGetN, strErrMsg);
		bOKEnable = false;
	}
	return true;	
}

void wks_to_vm_before_execute_event_handler(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl)
{
	if ( 0 == nGetNDialog ) //script mode
	{
		int nThemeSettings = xf_is_theme_applied(trGetN);

		///Sophy 3/5/2011 ORG-923-P3 PROPER_INIT_COLUMN_LABELS_FROM_ACTIVE_WORKSHEET_WHEN_ON_SCRIPT_MODE
		int nErrCode = CER_NO_ERROR;
		Worksheet wks;
		okxf_resolve_string_get_origin_object(trGetN.irng.strVal, &wks);
		if ( !wks )
			nErrCode = CER_NO_NUMERIC_WORKSHEET;
		init_dlg(trGetN, wks);
		///end PROPER_INIT_COLUMN_LABELS_FROM_ACTIVE_WORKSHEET_WHEN_ON_SCRIPT_MODE
		if ( CER_NO_ERROR == nErrCode )
			update_gui_on_format_change(trGetN, (THEME_NONE == nThemeSettings));

		if ( CER_NO_ERROR == nErrCode )
			nErrCode = check_input(trGetN);
		if ( CER_NO_ERROR != nErrCode )
		{
			string strErrMsg;
			load_err_msg(nErrCode, trGetN, strErrMsg);
			xf_warning_msg_box(strErrMsg, false, 'E');
			nRet = XFEVT_ABORT;
		}
	}
}

// other

static void update_input_range(int& r1, int& c1, int& r2, int& c2, const Datasheet& ds)
{
	///Sophy 8/24/2010 ORG-815-P10 PROPER_UPDATE_SELECTION_BOUNDS_ON_WHOLE_ROW_COL
	//if ( (r1 >= 0  && r2 == -1 || c2 == -1) && ds.IsValid() )
	//{
		//Worksheet wks(ds);
		//if ( c2 == -1 )
			//c2 = wks.GetNumCols() - 1;
		//wks.GetBounds(r1, c1, r2, c2, TRUE);
		//if ( r2 == -1 )
			//r2 = wks.GetNumRows() - 1;
	//}
	if ( ds )
	{
		if ( c2 == -1 )
			c2 = ds.GetNumCols() - 1;
		
		if ( r1 >= 0 && r2 == -1 ) //if it is label area selection, we should not update it 
		{
			Worksheet wks(ds);
			wks.GetBounds(r1, c1, r2, c2, TRUE);
		}
	}
	///end PROPER_UPDATE_SELECTION_BOUNDS_ON_WHOLE_ROW_COL
}

/// return 1 if success, return -1 if has empty or text data
static int is_subrng_valid_xy_array(const Datasheet &ds, int r1, int c1, int r2, int c2, bool bColumn)
{
	if ( bColumn && c2 - c1 != 0 )
		return 0;
	else if ( !bColumn && r2 - r1 != 0 )
		return 0;
	
	///Sophy 8/31/2010 ORG-923-P2 LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	Grid grid; //need to attach to grid in case ds not in active folder(no window in VC level)
	if ( !ds )
		return 0;
	else
		grid.Attach(ds);
	///end LABEL_INDEX_NOT_SET_WHEN_RUN_FROM_SCRIPT_MODE
	
	int nIndex = bColumn ? c1 : r1;
	int i1 = bColumn ? r1 : c1;
	int i2 = bColumn ? r2 : c2;
	if ( i2 - i1 <= 0 )
		return 0;
	
	vector	vx;
	vx.SetSize(i2-i1+1);
	for ( int ii=i1; ii<=i2; ++ii )
	{
		if( NANUM == (vx[ii-i1] = bColumn ? ds.Cell(ii, nIndex) : ds.Cell(nIndex, ii)) )
			return -1;
	}
	
	int mo = ocmath_is_monotonic(vx, vx.GetSize());
	
	return (MONO_DECREASE == mo || MONO_INCREASE == mo) ? 1 : 0;
}

static bool init_xyz_titles(TreeNode& trGetN)
{
	XYRange irng, xrange, yrange;
	xy_range_from_GetN_data_node(trGetN.irng, irng);
	xy_range_from_GetN_data_node(trGetN.xrange, xrange);
	xy_range_from_GetN_data_node(trGetN.yrange, yrange);

	if ( !irng || irng.IsEmpty() )
	{
		/// Bill 01/19/2011 ORG-1632-P2 INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
		//trGetN.xtitle.strVal 	= "X Title";
		//trGetN.ytitle.strVal 	= "Y Title";
		//trGetN.ztitle.strVal 	= "Z Title";
		if (trGetN.xtitle.strVal.IsEmpty())
			trGetN.xtitle.strVal = "X Title";

		if (trGetN.ytitle.strVal.IsEmpty())
			trGetN.ytitle.strVal = "Y Title";

		if (trGetN.ztitle.strVal.IsEmpty())
			trGetN.ztitle.strVal = "Z Title";
		/// End INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
		return false;
	}

	Datasheet ds;
	int r1, r2, c1, c2;
	irng.GetRange(0, r1, c1, r2, c2, ds);
	if ( !ds )
		return false;
	
	string strTitle;
	DataRange drVM;
	if ( construct_virtual_range(trGetN, drVM) )
	{
		MatrixObject mo;
		if ( mo.Attach(drVM, FORMAT_YACROSS == trGetN.format.nVal ? MATOBJATTACH_TRANSPOSE : 0) )
		{
			strTitle = mo.GetLongName();
			if ( strTitle.IsEmpty() )
			{
				int nSelMode = get_range_mode(irng);
				if ( IS_WHOLE_SHEET(nSelMode) )
					strTitle = ds.GetName();
				else
					strTitle = "vm1";
			}
			mo.CheckUpdateVSName(strTitle);

			/// Bill 01/19/2011 ORG-1632-P2 INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
			//trGetN.ztitle.strVal = strTitle;
			if (trGetN.ztitle.strVal.IsEmpty())
				trGetN.ztitle.strVal = strTitle;
			/// End INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
			
			string strX, strY;
			mo.GetAxesLongName(strX, strY);
			/// Bill 01/19/2011 ORG-1632-P2 INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
			//trGetN.xtitle.strVal = strX.IsEmpty() ? "X Title" : strX;
			//trGetN.ytitle.strVal = strY.IsEmpty() ? "Y Title" : strY;
			if (trGetN.xtitle.strVal.IsEmpty())
				trGetN.xtitle.strVal = strX.IsEmpty() ? "X Title" : strX;

			if (trGetN.ytitle.strVal.IsEmpty())
				trGetN.ytitle.strVal = strY.IsEmpty() ? "Y Title" : strY;
			/// End INIT_XYZ_TITLES_FROM_LABTALK_SCRIPT
		}
	}
	else
	{
		strTitle = trGetN.ztitle.strVal;
		if ( strTitle.IsEmpty() )
		{
			int nSelMode = get_range_mode(irng);
			if ( IS_WHOLE_SHEET(nSelMode) )
				strTitle = ds.GetName();
			else
				strTitle = "vm1";
		}
		trGetN.ztitle.strVal = strTitle;
	}
	return true;
}
