/*------------------------------------------------------------------------------*
 * File Name:  VideoRecorder.h													*
 * Purpose: Handle the Video Recorder dialog									*
 * Copyright (c)2012 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2012-04-16 ORG-4928 FIX_VIDEO_BUILDER_FRAME_COUNTER						*
 * EJP 2012-04-19 ORG-4928-P3 DISABLE_WINDOWS_VIDEO_COMPRESSION_DLG				*
 * EJP 2012-04-19 ORG-4928-P4 CHECK_FPS											*
 * EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START			*
 * EJP 2012-06-15 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING					*
 * EJP 2012-07-30 ORG-6157 TEST_PAGE_IS_VALID									*
 * EJP 2012-07-30 ORG-6156-S1 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER		*
 * EJP 2012-08-08 ORG-6489 USE_NEW_ERR_REPORTING_MECHANISM						*
 *------------------------------------------------------------------------------*/

#ifndef _VIDEO_RECORDER_H_
#define _VIDEO_RECORDER_H_

#include <okocUtils.h> /// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
#include <..\OriginLab\VideoWriter.h>
#include <ocu.h> /// EJP 2012-08-10 ORG-6489 USE_NEW_ERR_REPORTING_MECHANISM

//#define ENABLE_MATRIX_SUPPORT
//#define ENABLE_GRAPH_BROWSER
//#define ENABLE_SUPPORT_FOR_WINDOWS_COMPRESSION_DLG

#ifdef ENABLE_GRAPH_BROWSER
typedef BOOL (*FUNC_VECTOR_STR_DWORD_HWND_BOOL)(vector<string>& vsGraphs, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect);
#endif // ENABLE_GRAPH_BROWSER

/// EJP 2012-08-08 ORG-6489 USE_NEW_ERR_REPORTING_MECHANISM
/*enum {
	VRD_SUCCESS = 0,
	VRD_CREATE_VIDEO_FILE_FAILED,
	VRD_PAGE_TYPE_NOT_SUPPORTED,
	VRD_GRAPH_PAGE_INVALID,
	VRD_MATRIX_PAGE_INVALID,
	VRD_WRITE_FRAME_FAILED,
	VRD_BROWSE_FOR_WINDOW_FAILED,
	VRD_BROWSE_FOR_WINDOW_CANCELED,
};*/
/// end USE_NEW_ERR_REPORTING_MECHANISM


//---------------------------------------------------------------------------
// class VideoCodecList
//
// A simple class for managing a list of codec strings, IDs, and indexes.
// Data member m_nCodecs is external to class.
//---------------------------------------------------------------------------
/// EJP 2012-06-14 ORG-5914-S1 LIST_INSTALLED_CODECS
///	static int m_nCodecs[] = {VW_CODEC_UNCOMPRESSED,
///		VW_CODEC_MPEG1, VW_CODEC_MJPEG, VW_CODEC_MPEG42, VW_CODEC_MPEG43, VW_CODEC_MPEG4,
///		/// EJP 2012-04-19 ORG-4928-P3 DISABLE_WINDOWS_VIDEO_COMPRESSION_DLG
///		///VW_CODEC_H263, VW_CODEC_H263I, VW_CODEC_FLV1,
///		///VW_CODEC_PROMPT_USER
///		VW_CODEC_H263, VW_CODEC_H263I, VW_CODEC_FLV1
///		#ifdef ENABLE_SUPPORT_FOR_WINDOWS_COMPRESSION_DLG
///		,VW_CODEC_PROMPT_USER
///		#endif // ENABLE_SUPPORT_FOR_WINDOWS_COMPRESSION_DLG
///		/// end DISABLE_WINDOWS_VIDEO_COMPRESSION_DLG
///		};
/// end LIST_INSTALLED_CODECS

class VideoCodecList
{
public:
	VideoCodecList()
	{
		/// EJP 2012-06-14 ORG-5914-S1 LIST_INSTALLED_CODECS
		///	/// EJP 2012-04-19 ORG-4928-P3 DISABLE_WINDOWS_VIDEO_COMPRESSION_DLG
		///	///m_strCodecs = "None|PIM1|MJPG|MPEG 4.2|MPEG 4.3|MPEG 4|H263|H263i|FLV1|Prompt with available codecs on Start";
		///	m_strCodecs = "None|PIM1|MJPG|MPEG 4.2|MPEG 4.3|MPEG 4|H263|H263i|FLV1";
		///	#ifdef ENABLE_SUPPORT_FOR_WINDOWS_COMPRESSION_DLG
		///	m_strCodecs += "|Prompt with available codecs on Start";
		///	#endif // ENABLE_SUPPORT_FOR_WINDOWS_COMPRESSION_DLG
		///	/// end DISABLE_WINDOWS_VIDEO_COMPRESSION_DLG
		InitCodecList();
		/// end LIST_INSTALLED_CODECS
	}

	~VideoCodecList()
	{
	}

	LPCSTR GetCodecNames()
	{
		return (LPCSTR)m_strCodecs;
	}

	int GetCodecIndexFromID(int nID)
	{
		/// EJP 2012-06-14 ORG-5914-S1 LIST_INSTALLED_CODECS
		///	for( int nIndex = 0; nIndex < m_strCodecs.GetNumTokens('|'); nIndex++ )
		///	{
		///		if( m_nCodecs[nIndex] == nID )
		///			return nIndex;
		///	}
		for( int nIndex = 0; nIndex < m_vdwFourCC.GetSize(); nIndex++ )
		{
			if( m_vdwFourCC[nIndex] == nID )
				return nIndex;
		}
		/// end LIST_INSTALLED_CODECS
		return -1; // unknown ID
	}

	int GetCodecIndexFromName(LPCSTR pszCodec)
	{
		string str;
		for( int nIndex = 0; nIndex < m_strCodecs.GetNumTokens('|'); nIndex++ )
		{
			str = m_strCodecs.GetToken(nIndex, '|');
			if( 0 == str.CompareNoCase(pszCodec) )
				return nIndex;
		}
		return -1; // unknown name
	}

	int GetCodecIDFromName(LPCSTR pszCodec)
	{
		int nIndex = GetCodecIndexFromName(pszCodec);
		if( nIndex >= 0 )
			/// EJP 2012-06-14 ORG-5914-S1 LIST_INSTALLED_CODECS
			///return m_nCodecs[nIndex];
			return m_vdwFourCC[nIndex];
			/// end LIST_INSTALLED_CODECS
		return VW_CODEC_INVALID;
	}

	LPCSTR GetCodecNameFromID(int nID)
	{
		int nIndex = GetCodecIndexFromID(nID);
		if( nIndex < 0 )
			return NULL;
		return (LPCSTR)m_strCodecs.GetToken(nIndex, '|');
	}

protected:
	string m_strCodecs;

	/// EJP 2012-06-14 ORG-5914-S1 LIST_INSTALLED_CODECS
	vector<DWORD> m_vdwFourCC;

	int InitCodecList()
	{
		LPCSTR* pCodecNames;
		DWORD* pdwCodecFourCC;

		int nNumCodecs = ocvGetInstalledCodecs(&pCodecNames, &pdwCodecFourCC, false);
		if( nNumCodecs > 0 )
		{
			LPCSTR* pNames = pCodecNames;
			DWORD* pdwFourCC = pdwCodecFourCC;

			for( int i = 0; i < nNumCodecs; i++ )
			{
				if( m_strCodecs.GetLength() )
					m_strCodecs += "|";
				if ( lstrcmp((LPCSTR)*pNames, "Uncompressed") == 0 )
					m_strCodecs += _L("Uncompressed");
				else
					m_strCodecs += (LPCSTR)*pNames;
				m_vdwFourCC.Add(*pdwFourCC);

				pNames++;
				pdwFourCC++;
			}
			ocvReleaseCodecInfos(&pCodecNames, &pdwCodecFourCC);
		}
		return 0;
	}
	/// end LIST_INSTALLED_CODECS

};


//---------------------------------------------------------------------------
// class VideoRecorderDlg
//
// The class for handling the Video Recorder dialog box.
//---------------------------------------------------------------------------
class VideoRecorderDlg : public Dialog 
{
public:
	VideoRecorderDlg() : Dialog(IDD_VIDEO_RECORDER, "ODlg8") 
	{
		m_bInitialized = false; /// EJP 2012-07-30 ORG-6156 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
		m_codec = VW_CODEC_UNCOMPRESSED;
		m_fps = 1.0;
		m_width = 800;
		m_height = 600;
		m_nFramesWritten = 0;
		m_bStarted = false;
	}

	~VideoRecorderDlg()
	{
	}

	BOOL Create(HWND hWndParent = NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL)
	{
		InitMsgMap();
		return Dialog::Create(hWndParent, dwOptions, OpsName);
	}

	int DoModal(HWND hWndParent = NULL, DWORD dwOptions = 0, LPCSTR OpsName = NULL)
	{
		InitMsgMap();
		return Dialog::DoModal(hWndParent, dwOptions, OpsName);
	}

	/// EJP 2012-07-30 ORG-6156 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
	BOOL DoSaveVideoAsDialog()
	{
		StringArray saFileTypes;
		saFileTypes.Add(_L("[AVI (*.avi)] *.avi"));
		saFileTypes.Add(_L("[All Files (*.*)] *.*"));
		m_strFileName = GetSaveAsBox(saFileTypes, GetAppPath(false));
		if( m_strFileName.IsEmpty() )
			return FALSE;
		if( m_bInitialized )
			m_ctrlFileName.Text = m_strFileName;
		return TRUE;
	}
	/// end PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER

protected:  
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_EN_CHANGE(IDC_VID_FILE_NAME, OnChangeFileName)
		ON_BN_CLICKED(IDC_VID_BROWSE, OnBrowse)
		ON_BN_CLICKED(IDC_VID_START, OnStart)
		ON_BN_CLICKED(IDC_VID_ADD, OnAddActive)
		ON_BN_CLICKED(IDC_VID_FINISH, OnFinish)
		ON_BN_CLICKED(IDC_VID_SETTINGS, OnSettings)
		/// EJP 2012-06-07 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		ON_BN_CLICKED(IDC_VID_CANCEL_MAIN, OnCancel)
		ON_BN_CLICKED(IDC_VID_CANCEL, OnCancel)
		/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
	EVENTS_END

	BOOL OnInitDialog()
	{
		m_ctrlFileName = GetDlgItem(IDC_VID_FILE_NAME);
		m_ctrlFileName.Text = m_strFileName; /// EJP 2012-07-30 ORG-6156 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER

		m_ctrlBrowse = GetDlgItem(IDC_VID_BROWSE);
		///m_ctrlFrames = GetDlgItem(IDC_FRAMES);
		m_ctrlStart = GetDlgItem(IDC_VID_START);
		m_ctrlAdd = GetDlgItem(IDC_VID_ADD);
		m_ctrlFinish = GetDlgItem(IDC_VID_FINISH);
		m_ctrlSettings = GetDlgItem(IDC_VID_SETTINGS);

		/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		///m_strFramesWritten = m_ctrlFrames.Text;
		///UpdateFramesWritten();
		m_ctrlCancelMain = GetDlgItem(IDC_VID_CANCEL_MAIN);
		m_ctrlCancel = GetDlgItem(IDC_VID_CANCEL);
		m_strOriginalCaption = this->Text;
		/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START

		UpdateControls();

		m_bInitialized = true; /// EJP 2012-07-30 ORG-6156 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER

		return TRUE;
	}

	BOOL OnReady()
	{
		ShowWindow(SW_NORMAL);
		return TRUE;
	}

	BOOL OnDestroy()
	{
		/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		///if( m_bStarted )
		///	m_vw.Release();
		Cancel();
		/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		return TRUE;
	}

	BOOL OnChangeFileName(Control ctrl)
	{
		UpdateControls();
		return TRUE;
	}

	BOOL OnBrowse(Control ctrl)
	{
		/// EJP 2012-07-30 ORG-6156 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
		///StringArray saFileTypes;
		///saFileTypes.Add(_L("[AVI (*.avi)] *.avi"));
		///saFileTypes.Add(_L("[All Files (*.*)] *.*"));
		///m_ctrlFileName.Text = GetSaveAsBox(saFileTypes, GetAppPath(false));
		///UpdateControls();
		DoSaveVideoAsDialog();
		/// end PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER

		return TRUE;
	}

	BOOL OnStart(Control ctrl)
	{
		Edit ctrlFileName = GetItem(IDC_VID_FILE_NAME);
		/// EJP 2012-06-15 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
		///if( m_vw.Create(ctrlFileName.Text, m_codec, m_fps, m_width, m_height) )
		int nErr = m_vw.Create(ctrlFileName.Text, m_codec, m_fps, m_width, m_height);
		if( 0 == nErr )
		/// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		{
			m_bStarted = true;
			m_nFramesWritten = 0;

			/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
			m_strNameOfWindowWritten.Empty();
			ReduceWindowSize();
			/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
			
			UpdateFramesWritten();
			UpdateControls();
		}
		else
			/// EJP 2012-06-15 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
			///Message(VRD_CREATE_VIDEO_FILE_FAILED);
			Message(nErr);
			/// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		return TRUE;
	}

	BOOL OnAddActive(Control ctrl)
	{
		Page pg = Project.Pages(-1); // -1 for active page
		int nErr = WriteFrame(pg);

		if( nErr )
			Message(nErr);

		return TRUE;
	}

	BOOL OnFinish(Control ctrl)
	{
		m_vw.Release();
		m_bStarted = false;

		/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		///UpdateControls();
		string str;
		str.Format(_L("Video written to %s"), m_ctrlFileName.Text);
		okoc_out_msg(str, 'I');
		PostMessage(WM_CLOSE);
		/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START

		return TRUE;
	}

	BOOL OnSettings(Control ctrl)
	{
		VideoCodecList vcl;

		GETN_BOX(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_NUM(Width, _L("Video Width (pixels)"), m_width)
		GETN_NUM(Height, _L("Video Height (pixels)"), m_height)
		GETN_NUM(FPS, _L("Frames Per Second (1 to 120)"), m_fps)
			GETN_OPTION_EVENT_EX(check_fps) /// EJP 2012-04-19 ORG-4928-P4 CHECK_FPS
		GETN_STRLIST(Codec, _L("Compression"), vcl.GetCodecNameFromID(m_codec), vcl.GetCodecNames())

		// typedef bool (* PEVENT_NODE_FUNC)(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer); //CPY 5/19/05 GETN_NODE_EVENT_ROW_COL_FOR_LIST_VIEW
		// bool GetNBox(TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, PAPPLY_FUNC pfnApply = NULL, PEVENT_FUNC pfnEvent = NULL, HWND hWndParent = NULL, bool bSetGridView=false, bool bTranspose=false);
		tr.SetAttribute(STR_HELPID_ATTRIB, IDD_VIDEO_RECORDER);
		if( GetNBox(tr, _L("Video Settings")) )
		{
			m_width = tr.Width.nVal;
			m_height = tr.Height.nVal;
			m_fps = tr.FPS.dVal;
			m_codec = vcl.GetCodecIDFromName(tr.Codec.strVal);
		}
		return TRUE;
	}

	void UpdateControls()
	{
		if( m_bStarted )
		{
			/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
			///m_ctrlFileName.Enable = false;
			///m_ctrlBrowse.Enable = false;
			///m_ctrlSettings.Enable = false;
			///m_ctrlStart.Enable = false;
			///m_ctrlAdd.Enable = true;
			///m_ctrlFinish.Enable = true;
			m_ctrlFileName.Visible = false;
			m_ctrlBrowse.Visible = false;
			m_ctrlSettings.Visible = false;
			m_ctrlStart.Visible = false;
			m_ctrlCancelMain.Visible = false;
			m_ctrlAdd.Visible = true;
			m_ctrlFinish.Visible = true;
			m_ctrlCancel.Visible = true;
			/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		}
		else // not started
		{
			m_ctrlFileName.Enable = true;
			m_ctrlBrowse.Enable = true;
			m_ctrlSettings.Enable = true;

			/// EJP 2012-03-14: A bug prevents the following commented code from working
			/// but a work around are the two lines after it. For more info see JIRA ORG-5281.
			///m_ctrlStart.Enable = !m_ctrlFileName.Text.IsEmpty();
			string str = m_ctrlFileName.Text;
			m_ctrlStart.Enable = !str.IsEmpty();

			/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
			///m_ctrlAdd.Enable = false;
			///m_ctrlFinish.Enable = false;
			m_ctrlAdd.Visible = false;
			m_ctrlFinish.Visible = false;
			m_ctrlCancel.Visible = false;
			/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		}
	}

	void UpdateFramesWritten()
	{
		/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
		///m_ctrlFrames.Text.Format("%s  %d", m_strFramesWritten, m_nFramesWritten);
		string str;
		str.Format("%s: %d", m_strOriginalCaption, m_nFramesWritten);
		if( m_nFramesWritten > 0 )
			str += " - " + m_strNameOfWindowWritten;
		this->Text = str;
		/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
	}

	/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
	void Cancel()
	{
		if( m_bStarted )
		{
			m_vw.Release();
			m_bStarted = false;
			DeleteFile(m_ctrlFileName.Text);
		}
	}

	BOOL OnCancel(Control ctrl)
	{
		Cancel();
		PostMessage(WM_CLOSE);
		return TRUE;
	}

	void ReduceWindowSize()
	{
		RECT rect;
		m_ctrlAdd.GetWindowRect(&rect);
		ScreenToClient(&rect);

		SIZE size;
		size.cx = rect.left;
		size.cy = rect.top + rect.bottom;

		m_ctrlCancel.GetWindowRect(&rect);
		ScreenToClient(&rect);
		size.cx += rect.right;

		SetWindowClientSize(&size);
	}

	void SetWindowClientSize(const SIZE* size)
	{
		RECT rectWnd;
		GetWindowRect(&rectWnd);

		RECT rectClient;
		GetClientRect(&rectClient);
		ClientToScreen(&rectClient);

		int cx = size->cx + RECT_WIDTH(rectWnd) - RECT_WIDTH(rectClient);
		int cy = size->cy + RECT_HEIGHT(rectWnd) - RECT_HEIGHT(rectClient);

		SetWindowPos(NULL, 0, 0, cx, cy, SWP_NOACTIVATE|SWP_NOZORDER|SWP_NOMOVE);
	}
	/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START

	void Message(int nID)
	{
		string strMsg;
		/// EJP 2012-08-10 ORG-6489 USE_NEW_ERR_REPORTING_MECHANISM
		//switch( nID )
		//{
		//case VRD_CREATE_VIDEO_FILE_FAILED:
			//strMsg = _L("Failed to create video file.");
			//break;
		//case VRD_PAGE_TYPE_NOT_SUPPORTED:
			//#ifdef ENABLE_MATRIX_SUPPORT
			//strMsg = _L("Activate a graph or matrix window.");
			//#else // !ENABLE_MATRIX_SUPPORT
			//strMsg = _L("Activate a graph window.");
			//#endif // !ENABLE_MATRIX_SUPPORT
			//break;
		//case VRD_GRAPH_PAGE_INVALID:
			//strMsg = _L("Failed to get graph page.");
			//break;
		//case VRD_MATRIX_PAGE_INVALID:
			//strMsg = _L("Failed to get matrix page.");
			//break;
		//case VRD_WRITE_FRAME_FAILED:
			//strMsg = _L("Failed to write frame to video file.");
			//break;
		//case VRD_BROWSE_FOR_WINDOW_FAILED:
			//strMsg = _L("Failed to open the window browser dialog.");
			//break;
		///// EJP 2012-06-26 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
		//case OCV_ERR_NO_WRITE_ACCESS:
			//strMsg = _L("Destination file or folder is not writable.");
			//break;
		///// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		//default:
			///// EJP 2012-06-15 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
			/////return; // do nothing for unknown IDs
			//strMsg.Format(_L("Internal error %d"), nID);
			//break;
			///// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		//}
		if( !ocu_load_err_msg_str(nID, &strMsg) )
			strMsg.Format(_L("Error %d"), nID);
		/// end USE_NEW_ERR_REPORTING_MECHANISM
		MessageBox(GetSafeHwnd(), strMsg, _L("Origin Video Builder"), MB_OK);
	}

#ifdef ENABLE_GRAPH_BROWSER
	BOOL OnBrowseAndAdd(Control ctrl)
	{
		string strWndName;
		int nErr = BrowseForGraph(strWndName);
		if( 0 == nErr )
		{
			Page pg(strWndName);
			nErr = WriteFrame(pg);
		}

		if( nErr && nErr != VRD_BROWSE_FOR_WINDOW_CANCELED )
			Message(nErr);

		return TRUE;
	}

	int BrowseForGraph(string& strWndName)
	{
		FUNC_VECTOR_STR_DWORD_HWND_BOOL pfn = Project.FindFunction("ProjectBrowseGraphs", "Originlab\\ProjectBrowser.c");
		if (pfn)
		{
			vector<string> vs;
			if (pfn(vs, 0, GetSafeHwnd(), false)) // false for single select
			{
				//for (int i = 0; i < vs.GetSize(); i++)
				//	printf("%4d  %s\n", i, vs[i]);
				strWndName = vs[0];
				return 0; // success
			}
			return VRD_BROWSE_FOR_WINDOW_CANCELED; // cancel
		}
		return VRD_BROWSE_FOR_WINDOW_FAILED; // error
	}
#endif // ENABLE_GRAPH_BROWSER

private:
	Edit m_ctrlFileName;

	/// EJP 2012-07-30 ORG-6156-S1 PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER
	string m_strFileName;
	bool m_bInitialized;
	/// end PROMPT_FOR_FILENAME_ON_START_OF_VIDEOBUILDER

	Button m_ctrlBrowse;
	///Control m_ctrlFrames;
	Button m_ctrlSettings;
	Button m_ctrlStart;
	Button m_ctrlAdd;
	Button m_ctrlFinish;

	VideoWriter m_vw;
	bool m_bStarted;

	int m_codec;
	double m_fps;
	int m_width;
	int m_height;

	int m_nFramesWritten;
	/// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
	///string m_strFramesWritten;
	string m_strOriginalCaption;
	string m_strNameOfWindowWritten;
	Button m_ctrlCancel;
	Button m_ctrlCancelMain;
	/// end REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START


	int WriteFrame(const Page& pg)
	{
		/// EJP 2012-07-30 ORG-6157 TEST_PAGE_IS_VALID
		if( !pg.IsValid() )
			return VRD_PAGE_TYPE_NOT_SUPPORTED;
		/// end TEST_PAGE_IS_VALID

		int nErr = 0;

		if( EXIST_PLOT == pg.GetType() )
		{
			GraphPage gp(pg);
			/// EJP 2012-06-15 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
			///	if( gp.IsValid() )
			///	{
			///		if( !m_vw.WriteFrame(gp) )
			///			nErr = VRD_WRITE_FRAME_FAILED;
			///	}
			///	else
			///		nErr = VRD_GRAPH_PAGE_INVALID;
			nErr = m_vw.WriteFrame(gp);
			/// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		}
#ifdef ENABLE_MATRIX_SUPPORT
		else if( EXIST_MATRIX == pg.GetType() )
		{
			MatrixPage mp(pg);// = Project.MatrixPages(-1)
			/// EJP 2012-06-26 ORG-4927 IMPROVE_VIDEOWRITER_ERROR_HANDLING
			///	if( mp.IsValid() )
			///	{
			///		MatrixLayer ml = mp.Layers(-1);
			///		if( !m_vw.WriteFrame(ml) )
			///			nErr = VRD_WRITE_FRAME_FAILED;
			///	}
			///	else
			///		nErr = VRD_MATRIX_PAGE_INVALID;
			nErr = m_vw.WriteFrame(mp);
			/// end IMPROVE_VIDEOWRITER_ERROR_HANDLING
		}
#endif // ENABLE_MATRIX_SUPPORT
		else
			nErr = VRD_PAGE_TYPE_NOT_SUPPORTED;

		if( 0 == nErr )
		{
			m_strNameOfWindowWritten = pg.GetName(); /// EJP 2012-06-05 ORG-5893 REDUCE_VIDEO_BUILDER_DIALOG_ON_CLICK_START
			m_nFramesWritten++;
			UpdateFramesWritten(); /// EJP 2012-04-16 ORG-4928 FIX_VIDEO_BUILDER_FRAME_COUNTER
		}

		return nErr;
	}

};

/// EJP 2012-04-19 ORG-4928-P4 CHECK_FPS
static bool check_fps(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	double fps = trNode.dVal;
	if( fps < 1 )
		fps = 1;
	else if( fps > 120 )
		fps = 120;
	trNode.dVal = fps;
	return true;
}
/// end ORG-4928-P4 CHECK_FPS

#endif // _VIDEO_RECORDER_H_
