/*------------------------------------------------------------------------------*
 * File Name: VerticalCursorDlg.c												*
 * Creation: Kenny 02/24/2009													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp. 2009											*
 * All Rights Reserved															*
 *																				*
 * Modification Log:															*
 *	Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE				*
 *	Folger 01/15/10 X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE*
 *	Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS							*
 *	Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER								*
 *	Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING								*
 *	Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME						*
 *	Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT									*
 *	Jasmine 01/20/10 SHOW_NEAREST_POINT											*
 *	Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS									*
 *	Folger 01/22/09 ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE
 *	Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE			*
 *	Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT									*
 *	Folger 01/27/10 VERTICAL_CURSOR_DIALOG_STILL_SHOW_AFTER_CURSOR_LINE_DELETED	*
 *	Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA						*
 *	Jasmine 01/28/10 RESTRICT_X_EDIT_TEXT										*
 *	Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG						*
 *	Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU						*
 *	Jasmine 02/08/10 HIDE_SNAP_OPTION_TO_SIMPLIFY_GUI							*
 *	Jasmine 02/08/10 REMEMBER_SNAP_OPTION										*
 *	Jasmine 02/08/10 MENU_NOT_HAVE_ALL_COLUMN_SO_CAN_HIDE_ALL_MENU_COL			*
 *	Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET					*
 *	Folger 07/06/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT						*
 *	Jasmine 06/17/2011 ORG-3106-P1 MAKE_VERTICAL_CURSOR_GUI_CONSISTENT_WITH_OTHER_GADGET_LIKE_CLUSTER
 *	Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
 *	Jasmine 06/28/2011 ORG-3106-P1 MAKE_DUPLICATE_GRAPH_VALID_FOR_CURSOR		*
 *	Jasmine 07-11-2011 ORG-3106-S2 BRING_BACK_LABEL_FEATURE						*
 *	Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE						*
 *	Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE					*
 *	Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH					*
 *	Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG					*
 *	Sophy 9/6/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT		*
 *	Sophy 9/16/2011 ORG-3106-P10 WRONG_SHOWHIDE_STATUS_AFTER_SORT_PLOT_COLUMN	*
 *	Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT	*
 *	Folger 11/04/2011 ADD_F1_HELP_FOR_OC_DIALOGS								*
 *	Folger 02/07/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR				*
 *	Folger 02/21/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR						*
 *	Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS				*
 *	Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH							*
 *	Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB				*
 *	Folger 07/27/2012 ORG-6339-P1 SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH*
 *	Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
 *	Folger 08/02/2012 ORG-6421-P1 VERTICAL_CURSOR_RUNTIME_ERROR_AFTER_OPEN_EXPORT_GRAPH
 *	Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT				*
 *	Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT		*
 *	Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT				*
 *	Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM	*
 *	Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
 *	Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT						*
 *	Jasmine 08/20/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS 	*
 *	Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA			*
 *	Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
 *	Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER				*
 *	Jasmine 09/10/2012 ORG-6764-P1 UNNECESSERY_UPDATE_REWRITE_USER_INPUT_XVALUE	*
 *	Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS					*		
 *	Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST*
 *	Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH				*
 *	Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR	*
 *------------------------------------------------------------------------------*/

#define REMOVE_TAG_FEATURE
//#define REMOVE_LABEL_FEATURE	///Jasmine 07-11-2011 ORG-3106-S2 BRING_BACK_LABEL_FEATURE
 
#include <Origin.h>
#include <..\Originlab\DialogEx.h>
#include "VerticalCursorManager.h"
#include "GridTableControl.h"

#define _CAT								"Vertical Cursor"

/*----------------------------------------------------------------------------*/
/* Macros/Enums
/*----------------------------------------------------------------------------*/

#define STR_NODE_TAG_NAME_DIALOG				"VDialog"

///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
	#define IDC_BTN_DUMP_LABEL					IDC_BTN_ADD_TAG
#endif//REMOVE_TAG_FEATURE
///End DUMP_LABEL_AND_LINE_ON_GRAPH

enum TAGINFOGRIDCOLTYPE
{
	TAGINFOGRIDCOLTYPE_TAG_UID					= 0,
	TAGINFOGRIDCOLTYPE_X_SCALE,
	TAGINFOGRIDCOLTYPE_Y_SCALE,
	TAGINFOGRIDCOLTYPE_PLOT_NAME,

	TAGINFOGRIDCOLTYPE_TOTAL,
};

#define STR_TAG_INFO_GRID_COLS					_LC("Tag UID|X|Y|Plot Name", _CAT)

#define INFO_LIST_CONTEXT_MENU_ID_INVALID		0
enum
{
	TAG_INFO_CONTEXT_MENU_ID_INVALUD			= INFO_LIST_CONTEXT_MENU_ID_INVALID,
	TAG_INFO_CONTEXT_MENU_ID_REMOVE,
	TAG_INFO_CONTEXT_MENU_ID_CLEAR_ALL,
};


//keep TEXTLABELINFOGRIDCOLTYPE and STR_TEXT_LABEL_INFO_GRID_COLS consistent
///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
//#define STR_TEXT_LABEL_INFO_GRID_COLS			_LC("Snap To|Nearest Index|X|Y|Nearest X|Nearest Y|ID", _CAT)+"|"+ LABEL_NAME + "|"+LABEL_SHEET_NAME+"|"+LABEL_BOOK_NAME	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
#define STR_TEXT_LABEL_INFO_GRID_COLS			_LC("Snap To|Nearest Index|X|Y|Nearest X|Nearest Y|ID", _CAT)+"|"+ LABEL_NAME + "|"+LABEL_SHEET_NAME+"|"+LABEL_BOOK_NAME + "|" + LABEL_GRAPH_NAME + "|" + _LC("Status", _CAT)	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
///End SUPPORT_MULTI_WINS_CURSOR
enum TEXTLABELINFOGRIDCOLTYPE
{
	TEXTLABELINFOGRIDCOLTYPE_SNAPTO			= 0,
	TEXTLABELINFOGRIDCOLTYPE_INDEX,				///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
	TEXTLABELINFOGRIDCOLTYPE_X_SCALE,
	TEXTLABELINFOGRIDCOLTYPE_Y_SCALE,
	TEXTLABELINFOGRIDCOLTYPE_NEAREST_X,	///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
	TEXTLABELINFOGRIDCOLTYPE_NEAREST_Y,
	TEXTLABELINFOGRIDCOLTYPE_ID,				///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//TEXTLABELINFOGRIDCOLTYPE_SHORTNAME,
	//TEXTLABELINFOGRIDCOLTYPE_LONGNAME,
	TEXTLABELINFOGRIDCOLTYPE_NAME,
	///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	TEXTLABELINFOGRIDCOLTYPE_SHEETNAME,
	TEXTLABELINFOGRIDCOLTYPE_BOOKNAME,
	///End CONFIGURE_SHOW_HIDE_SETTING
	TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME,			///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	TEXTLABELINFOGRIDCOLTYPE_STATUS,			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	TEXTLABELINFOGRIDCOLTYPE_TOTAL,
};


/*----------------------------------------------------------------------------*/
/* Global Variable
/*----------------------------------------------------------------------------*/
class GraphVerticalCursorDlg;
static GraphVerticalCursorDlg* s_pVerticalCursorDlg = NULL;

#ifdef _DEBUG
static BOOL s_bDestroyDlgOnClose = FALSE;
#endif // _DEBUG

/*----------------------------------------------------------------------------*/
/* Local util functions
/*----------------------------------------------------------------------------*/

static void _move_control_no_size(Control& ctrl, RECT& rt, int nX, int nY)
{
	rt.right = nX + RECT_WIDTH(rt);
	rt.left = nX;
	rt.bottom = nY + RECT_HEIGHT(rt);
	rt.top = nY;
	ctrl.MoveWindow(&rt, TRUE);
}

/*----------------------------------------------------------------------------*/
/* InfoListContextMenu
/*----------------------------------------------------------------------------*/

class InfoListContextMenu : public MenuBase
{
public:
	InfoListContextMenu(const vector<int>& vnIDs, const vector<string>& vsText, const vector<bool>& vbEnables)
	{
		const int nIDSize = vnIDs.GetSize();
		if (nIDSize != vsText.GetSize() || nIDSize != vbEnables.GetSize())
		{
			ASSERT(FALSE);
			return;
		}
		for(int ii = 0; ii < nIDSize; ++ii)
		{
			int nFlags;
			if(INFO_LIST_CONTEXT_MENU_ID_INVALID == vnIDs[ii])
				nFlags = MF_SEPARATOR;
			else
			{
				nFlags = MF_STRING;
				if(!vbEnables[ii])
					nFlags |= MF_GRAYED | MF_DISABLED;
			}
			Add(vsText[ii], OnMenuItem, nFlags, vnIDs[ii]);
		}
	}
};

/*----------------------------------------------------------------------------*/
/* InfoGridTableControlBase class
/*----------------------------------------------------------------------------*/

class InfoGridTableControlBase : public GridTableControl
{
public:
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName, int nCols, LPCSTR lpcszColHeader)
	{
		GridTableControl::Init(nID, dlg, lpcszDlgName);

		SetCols(nCols);
		SetColHeaderString(lpcszColHeader);

		SetupColTypes();
	}
	virtual void OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		if(nButton != MK_RBUTTON || nShift != 0)
			return;
		int nRow = m_flx.MouseRow;
		int nCol = m_flx.MouseCol;
		vector<UINT> vnRows;
		GetSelRows(vnRows);
		if(nRow < 0 || nCol < 0)
		{
			RemoveSelection();
		}
		else
		{
			vector<uint> vec;
			if(vnRows.Find(vec, nRow) <= 0)
				SelRow(nRow);
		}
		GetSelRows(vnRows);

		int    nx = XTwipsToPixels(X);
		int    ny = YTwipsToPixels(Y);
		ClientToScreen(nx, ny);

		vector<int> vnIDs;
		vector<string> vsText;
		vector<bool> vbEnable;
		if ( !GetMenuInfo(vnIDs, vsText, vbEnable) )
			return;
		
		InfoListContextMenu contextMenu(vnIDs, vsText, vbEnable);

		int nID = 0;
		contextMenu.TrackPopupMenu(0, nx, ny, GetDlgSafeHwnd(), &nID);

		OnClickMenuItem(nID);
	}
	
	bool GetInfoTableContent(string& strData, LPCSTR lpcszRowSeparator = NULL, LPCSTR lpcszColSeparator = NULL);	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
	
protected:
	virtual void SetupColTypes() { ASSERT(FALSE); }
	virtual BOOL GetMenuInfo(vector<int>& vnIDs, vector<string>& vsText, vector<bool>& vbEnable) { return FALSE; }
	virtual void OnClickMenuItem(const int nID) {}
};

///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
bool InfoGridTableControlBase::GetInfoTableContent(string& strData, LPCSTR lpcszRowSeparator/* = NULL*/, LPCSTR lpcszColSeparator/* = NULL*/)
{
	strData.Empty();
	
	string strRowSeparator(lpcszRowSeparator);
	if( strRowSeparator.IsEmpty() )
		strRowSeparator = "\r\n";
	
	string strColSeparator(lpcszColSeparator);
	if( strColSeparator.IsEmpty() )
		strColSeparator = "\t";
	
	int nRowCount = GetNumRows();
	if(nRowCount <= 0)
		return false;
	vector<string> vsContents;
	vsContents.SetSize(nRowCount);
	
	for(int nRow = GetRowOffset(), ii = 0; ii < nRowCount; ii++)
	{
		vector<string> vsRowVals;
		GetRowValues(nRow++, vsRowVals);
		if(vsRowVals.GetSize() > 0)
		{
			string strRowValues;
			strRowValues = str_combine(vsRowVals, strColSeparator);
			vsContents[ii] = strRowValues;
		}
	}
	
	strData = str_combine(vsContents, strRowSeparator);
	return true;
}
///End MORE_CONFIGURATION_FOR_INFO_TABLE

/*----------------------------------------------------------------------------*/
/* TagInfoTable class
/*----------------------------------------------------------------------------*/

class TagInfoTable : public InfoGridTableControlBase
{
public:
	TagInfoTable() {}	
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName)
	{
		InfoGridTableControlBase::Init(nID, dlg, lpcszDlgName, TAGINFOGRIDCOLTYPE_TOTAL, STR_TAG_INFO_GRID_COLS);
		SetAllowSelection(true);
		SetSelection(flexSelectionListBox);
		HideCol(0);
	}
protected:
	virtual void SetupColTypes();
	virtual BOOL GetMenuInfo(vector<int>& vnIDs, vector<string>& vsText, vector<bool>& vbEnable);
	virtual void OnClickMenuItem(const int nID);
};

/*----------------------------------------------------------------------------*/
/* The implement of the member function of TagInfoTable class
/*----------------------------------------------------------------------------*/

//virtual 
void TagInfoTable::SetupColTypes()
{
	m_flx.Cols = TAGINFOGRIDCOLTYPE_TOTAL;

	int nCol;
	for(nCol = 0; nCol < m_flx.Cols; nCol++)
	{
		switch(nCol)
		{
		case TAGINFOGRIDCOLTYPE_TAG_UID:
			SetColDataType(nCol, flexDTLong);
			break;
		case TAGINFOGRIDCOLTYPE_X_SCALE:
		case TAGINFOGRIDCOLTYPE_Y_SCALE:
			SetColDataType(nCol, flexDTDouble);
			break;
		case TAGINFOGRIDCOLTYPE_PLOT_NAME:
		default:
			SetColDataType(nCol, flexDTString);
			break;
		}
		SetColAlignment(nCol, flexAlignCenterCenter);
	}		
}

BOOL TagInfoTable::GetMenuInfo( vector<int>& vnIDs, vector<string>& vsText, vector<bool>& vbEnable )
{
	vnIDs.RemoveAll();
	vsText.RemoveAll();
	vbEnable.RemoveAll();

	vector<uint> vnRows;
	GetSelRows(vnRows);

	if( vnRows.GetSize() > 0 )
	{
		vnIDs.Add(TAG_INFO_CONTEXT_MENU_ID_REMOVE);
		vsText.Add( _L("Remove Selected") );
		vbEnable.Add(true);
	}
	if (GetRows() > 1)
	{
		vnIDs.Add(TAG_INFO_CONTEXT_MENU_ID_CLEAR_ALL);
		vsText.Add(_L("Clear All"));
		vbEnable.Add(true);
	}
	return TRUE;
}

void TagInfoTable::OnClickMenuItem( const int nID )
{
	switch (nID)
	{
	case TAG_INFO_CONTEXT_MENU_ID_REMOVE:
		{
			vector<UINT> vnRows;
			GetSelRows(vnRows);
			vector<UINT> vnRemoveTagUID;
			for (int ii = 0; ii < vnRows.GetSize(); ++ii)
			{
				const string strUID = GetCell(vnRows[ii], 0);
				const UINT uTagUID = atoi(strUID);
				vnRemoveTagUID.Add(uTagUID);
			}
			THE_VCURSOR_MANAGER.RemoveTag(vnRemoveTagUID);
		}
		break;
	case TAG_INFO_CONTEXT_MENU_ID_CLEAR_ALL:
		THE_VCURSOR_MANAGER.ClearAllTags();
		break;
	}
}

/*----------------------------------------------------------------------------*/
/* CursorDataInfoTable class
/*----------------------------------------------------------------------------*/
///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
enum{
	VCURSOR_MENU_COPY 			= 1,  
	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	//VCURSOR_MENU_CUSTOM_PLOT,	
	//VCURSOR_MENU_PLOT_BEGIN,
	//VCURSOR_MENU_PLOT_END 		= VCURSOR_MENU_PLOT_BEGIN + 500 - 1,
	VCURSOR_MENU_INCLUDE,
	VCURSOR_MENU_EXCLUDE,
	VCURSOR_MENU_HIDE,
	VCURSOR_MENU_SHOW_ALL,
	VCURSOR_MENU_UNLINK_GRAPH,
	///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	///Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS
	VCURSOR_MENU_SAVE_LINK_GRAPH,
	VCURSOR_MENU_LOAD_LINK_GRAPH,
	///End SAVE_AND_LOAD_LINKED_GRAPHS
};
///End MENU_TO_HIDE_PLOT_FROM_DLG

class CursorDataInfoTable : public InfoGridTableControlBase
{
public:
	CursorDataInfoTable() {}	
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName)
	{
		InfoGridTableControlBase::Init(nID, dlg, lpcszDlgName, TEXTLABELINFOGRIDCOLTYPE_TOTAL, STR_TEXT_LABEL_INFO_GRID_COLS);

		///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
		SetAllowSelection(true); // to allow select multiple rows
		SetSelection(flexSelectionListBox);//flexSelectionByRow);
		///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT
		
		///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
		m_vnColMap.Data(0, TEXTLABELINFOGRIDCOLTYPE_TOTAL - 1);		///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
		
		vector<int> vnPublicCols;
		for(int nType = 0; nType < TEXTLABELINFOGRIDCOLTYPE_TOTAL; nType++)
		{
			if(	TEXTLABELINFOGRIDCOLTYPE_SNAPTO == nType ||
				TEXTLABELINFOGRIDCOLTYPE_ID == nType ||	
				TEXTLABELINFOGRIDCOLTYPE_X_SCALE == nType ||
				TEXTLABELINFOGRIDCOLTYPE_Y_SCALE == nType) 
				continue;
			vnPublicCols.Add(nType);
		}
		vector<uint> vnDefaultShows;
		vnDefaultShows.SetSize( vnPublicCols.GetSize() );
		vnDefaultShows = 1;		 
		int nGroup = AddGroup(vnPublicCols, vnDefaultShows);
		ASSERT(0 == nGroup);
		SetGroup(0);
		HideCol(TEXTLABELINFOGRIDCOLTYPE_ID);	
		HideCol(TEXTLABELINFOGRIDCOLTYPE_SNAPTO);		///Jasmine 02/08/10 HIDE_SNAP_OPTION_TO_SIMPLIFY_GUI
		///End CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
		
		//SetAllowSelection(false);		///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE 
		//SetExplorerBar(flexExMove);	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
		SetExplorerBar(flexExSortAndMove);	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
		
		string strToolTips = _L("Drag and drop the column header to reorder the column list");
		SetToolTipsText(strToolTips);
	}

	virtual void OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel);
		
	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
	void 	OnAfterMoveColumns(long lCol, long *pnPosition);	
	int 	GetColType(int nPosition);
	int		GetColPos(int nType);
	///End MORE_CONFIGURATION_FOR_INFO_TABLE
	
	///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	int 	GetColumnOrder(vector<int>& vnColMap);
	void	SetColumnOrder(const vector<int>& vnColMap);
	///End KEEP_COL_ORDER_IN_PAGE

	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	void	SetRowOrderAndShow(const vector<string>& vsPlotIDs, const vector<int>& vnPlotShow);
	///End MENU_TO_HIDE_PLOT_FROM_DLG
	

protected:
	virtual void SetupColTypes()
	{
		//in this function can use TEXTLABELINFOGRIDCOLTYPE_* directly as column position 
		//since the order is not changed by drag&drop
		for(int nCol = 0; nCol < m_flx.Cols; nCol++)
		{
			switch(nCol)
			{
			///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
			case TEXTLABELINFOGRIDCOLTYPE_SNAPTO:
				SetColDataType(nCol, flexDTBoolean);
				break;
			///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
			case TEXTLABELINFOGRIDCOLTYPE_INDEX:
			case TEXTLABELINFOGRIDCOLTYPE_X_SCALE:
			case TEXTLABELINFOGRIDCOLTYPE_Y_SCALE:
			case TEXTLABELINFOGRIDCOLTYPE_NEAREST_X:	///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
			case TEXTLABELINFOGRIDCOLTYPE_NEAREST_Y:	
			case TEXTLABELINFOGRIDCOLTYPE_ID:
				SetColDataType(nCol, flexDTDouble);
				break;
			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
			case TEXTLABELINFOGRIDCOLTYPE_STATUS:
				SetColDataType(nCol, flexDTBoolean);
				break;
			///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
			default:
				SetColDataType(nCol, flexDTString);
				break;
			}
			SetColAlignment(nCol, flexAlignCenterCenter);
		}
	}
private:
	///Jasmine 02/08/10 MENU_NOT_HAVE_ALL_COLUMN_SO_CAN_HIDE_ALL_MENU_COL
	virtual bool 	toggleShowCol(int nCol, int nNumShowCols = -1)
	{   
		HideCol(nCol, IsColHidden(nCol)? false:true);
	    return true;
  	}
  	///End MENU_NOT_HAVE_ALL_COLUMN_SO_CAN_HIDE_ALL_MENU_COL
  	
private:
	vector<int>		m_vnColMap;		///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
};


virtual void CursorDataInfoTable::OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE
	int nRow, nCol, nFirstRowIndex = GetRowOffset();		
	GetMouseCell(nRow,nCol);	
	///Sophy 8/9/2011 ORG-3106-S5 MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	//if(nRow >= nFirstRowIndex)
	if ( nRow >= nFirstRowIndex || nRow < 0 ) //when user hide all rows, should provide a way to bring back all rows, that's the gray area
	///end MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
	{
		///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		if( !GetIsSelected(nRow) )
			SelRow(nRow);
		///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		
		int nx = XTwipsToPixels(X);
		int ny = YTwipsToPixels(Y);
		ClientToScreen(nx, ny);
		
		vector<UINT> vnRows;
		GetSelRows(vnRows);
		bool bHasSelection = vnRows.GetSize() > 0;
		
		Menu cellMenu;
		cellMenu.Add(_L("Copy"), VCURSOR_MENU_COPY, bHasSelection? MF_ENABLED: MF_DISABLED|MF_GRAYED);
		
		///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		/////Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
		//if(	s_pVerticalCursorDlg &&
			//s_pVerticalCursorDlg->ConstrucPlotsMenu(cellMenu) )
		//{
			//cellMenu.Add(NULL, 0, MF_SEPARATOR); 
			/////Jasmine 08/11/2011 ORG-3502 CHANGE_CUSTOMIZE_TEXT_TO_SELECT
			////cellMenu.Add(_L("Customize..."), VCURSOR_MENU_CUSTOM_PLOT, MF_STRING); 
			//cellMenu.Add(_L("Select") + STR_THREE_DOTS, VCURSOR_MENU_CUSTOM_PLOT, MF_STRING); 
			/////End CHANGE_CUSTOMIZE_TEXT_TO_SELECT
		//}
		/////MENU_TO_HIDE_PLOT_FROM_DLG    	
		cellMenu.Add(NULL, 0, MF_SEPARATOR); 
		cellMenu.Add(_L("Include"), 	VCURSOR_MENU_INCLUDE, 	bHasSelection? MF_ENABLED : MF_DISABLED|MF_GRAYED); 
		cellMenu.Add(_L("Exclude"), 	VCURSOR_MENU_EXCLUDE, 	bHasSelection? MF_ENABLED : MF_DISABLED|MF_GRAYED); 
		cellMenu.Add(_L("Hide"), 		VCURSOR_MENU_HIDE, 		bHasSelection? MF_ENABLED : MF_DISABLED|MF_GRAYED); 
		cellMenu.Add(_L("Show All"), 	VCURSOR_MENU_SHOW_ALL, 	MF_STRING); 
		cellMenu.Add(_L("Unlink Graph"), VCURSOR_MENU_UNLINK_GRAPH, bHasSelection? MF_ENABLED : MF_DISABLED|MF_GRAYED); 
		///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		
		///Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS
		bool bHasLinkedGraphs = s_pVerticalCursorDlg->HasLinkedGraphs();
		bool bLinkGraphSaved = s_pVerticalCursorDlg->IsLinkGraphSaved();
		cellMenu.Add(NULL, 0, MF_SEPARATOR); 
		cellMenu.Add(_L("Save Linked Graphs"), 	VCURSOR_MENU_SAVE_LINK_GRAPH, bHasLinkedGraphs? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		cellMenu.Add(_L("Load Linked Graphs"), 	VCURSOR_MENU_LOAD_LINK_GRAPH, bLinkGraphSaved? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		///End SAVE_AND_LOAD_LINKED_GRAPHS
		
		int nCmd = 0;
		cellMenu.TrackPopupMenu(0, nx, ny, GetDlgSafeHwnd(), &nCmd);
		if ( nCmd > 0 )
		{
			switch(nCmd)
			{
			case VCURSOR_MENU_COPY:
				CopySelectedCellsValue(nRow, nCol);
				break;
			///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
			//case VCURSOR_MENU_CUSTOM_PLOT:
				//s_pVerticalCursorDlg->OnOpenSelectPlotsDlg();
				//break;
			//default:
				//s_pVerticalCursorDlg->OnToggleOnePlotShow(nCmd);
				//break;
			case VCURSOR_MENU_INCLUDE:
				s_pVerticalCursorDlg->OnIncludeSelectedPlots(true);
				break;
			case VCURSOR_MENU_EXCLUDE:
				s_pVerticalCursorDlg->OnIncludeSelectedPlots(false);
				break;
			case VCURSOR_MENU_HIDE:
				s_pVerticalCursorDlg->OnHideSelectedPlotsFromGrid();
				break;
			case VCURSOR_MENU_SHOW_ALL:
				s_pVerticalCursorDlg->OnShowAllPlotsInGrid();
				break;
			case VCURSOR_MENU_UNLINK_GRAPH:
				s_pVerticalCursorDlg->OnUnlinkSelectedGraphs();
				break;
			///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
			///Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS
			case VCURSOR_MENU_SAVE_LINK_GRAPH:
				s_pVerticalCursorDlg->OnSaveLinkedGraphs();
				break;				
			case VCURSOR_MENU_LOAD_LINK_GRAPH:
				s_pVerticalCursorDlg->OnLoadLinkedGraphs();
				break;
			///End SAVE_AND_LOAD_LINKED_GRAPHS
			}
		}
    }
    else
    {
    ///End GENERAL_COPY_GRID_VALUE
		///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
		Control ctrl;
		OnBeforeMouseDown(ctrl, nButton, nShift, X, Y, pCancel);
		///End CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
    }
}

///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
void CursorDataInfoTable::OnAfterMoveColumns(long lCol, long *pnPosition)	
{
	int nOldPostion = lCol;
	int nNewPostion = -1;
	if(pnPosition)
		nNewPostion = *pnPosition;
	
	int nColMoved = GetColType(nOldPostion);	
	if(nColMoved < 0 || GetColType(nNewPostion) < 0)//lCol or pnPosition may be invalid
	{
		ASSERT(0);
		return;
	}
	
	m_vnColMap.RemoveAt(nOldPostion);
	m_vnColMap.InsertAt(nNewPostion, nColMoved);
	
	///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
	vector<int> vnPublicCols;
	vector<byte> vnDefaultShows;
	for(int nType = 0; nType < TEXTLABELINFOGRIDCOLTYPE_TOTAL; nType++)
	{
		if(	TEXTLABELINFOGRIDCOLTYPE_SNAPTO == nType ||
			TEXTLABELINFOGRIDCOLTYPE_ID == nType ||
			TEXTLABELINFOGRIDCOLTYPE_X_SCALE == nType ||
			TEXTLABELINFOGRIDCOLTYPE_Y_SCALE == nType) 
			continue;
		
		int nPos = GetColPos(nType);
		vnPublicCols.Add(nPos);
		vnDefaultShows.Add( !IsColHidden(nPos) );
	}
	SetGroupColShows(0, vnPublicCols, vnDefaultShows);
	
	m_strColHeader = "";
	for(int nCol = 0; nCol < m_flx.Cols; nCol++)
	{
		if(nCol != 0)
			m_strColHeader += "|";
		m_strColHeader += GetCell(0, nCol);
	}
	///End CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
}

int CursorDataInfoTable::GetColType(int nPosition)
{
	if( m_vnColMap.GetSize() < TEXTLABELINFOGRIDCOLTYPE_TOTAL //in case m_vnColMap is not ready
		||	0 > nPosition 
		|| nPosition >= TEXTLABELINFOGRIDCOLTYPE_TOTAL)
		return -1;
	
	return m_vnColMap[nPosition];
}

int CursorDataInfoTable::GetColPos(int nType)
{
	if( m_vnColMap.GetSize() < TEXTLABELINFOGRIDCOLTYPE_TOTAL //in case m_vnColMap is not ready
		||	0 > nType 
		|| nType >= TEXTLABELINFOGRIDCOLTYPE_TOTAL)
		return -1;
		
	vector<uint> vecIndex;
	if(m_vnColMap.Find(vecIndex, nType) > 0)
		return vecIndex[0];
	
	return -1;
}
///End MORE_CONFIGURATION_FOR_INFO_TABLE
///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
int CursorDataInfoTable::GetColumnOrder(vector<int>& vnColMap)
{
	vnColMap = m_vnColMap;
	return vnColMap.GetSize();
}
void CursorDataInfoTable::SetColumnOrder(const vector<int>& vnColMap)
{
	int nNewOrderSize = vnColMap.GetSize();
	int nOldOrderSize = m_vnColMap.GetSize();
	if(nNewOrderSize > 0 && nNewOrderSize != nOldOrderSize)
	{
		error_report("Since we changed the number of columns, column order and column display will be different from the past.");
	}
	
	for(int ii = 0; ; ii++)
	{
		ii = find_diff(vnColMap, nNewOrderSize, m_vnColMap, nOldOrderSize, ii);
		if(ii == -1 || ii >= nNewOrderSize || ii >= nOldOrderSize)
			break;
		
		int nColType = vnColMap[ii];
		
		vector<uint> vecIndex;
		int nFind = m_vnColMap.Find(vecIndex, nColType);
		if(nFind < 1)
			continue;
		
		nFind = vecIndex[0];
		int nCol = nFind, nPos = ii;
		SetColPosition(nCol, nPos);
		OnAfterMoveColumns(nCol, &nPos);
	}
}
/*find the first different index*/
static int find_diff(const vector<int>& vnNew, int nNewOrderSize, const vector<int>& vnOld, int nOldOrderSize, int nStart)
{
	int nDiff = -1;;
	for(int ii = nStart; ii < nNewOrderSize; ii++)		
	{
		if(ii >= nOldOrderSize)
			return -1;
	
		if( !is_equal(vnNew[ii], vnOld[ii]) )	
		{									
			nDiff = ii;
			break;
		}										
	}
	
	return nDiff;
}
///End KEEP_COL_ORDER_IN_PAGE

///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
void CursorDataInfoTable::SetRowOrderAndShow(const vector<string>& vsPlotIDs, const vector<int>& vnPlotShow)
{
	//if(vsPlotIDs && vnPlotShow)
		//printf("row = %d, ids = %s, show = %s\n", GetNumRows(), vsPlotIDs.GetSize(), vnPlotShow.GetSize());
}
///End MENU_TO_HIDE_PLOT_FROM_DLG


/*----------------------------------------------------------------------------*/
/* GraphVerticalCursorDlg class
/*----------------------------------------------------------------------------*/

#define STR_DLG_NAME 						_L("Vertical Cursor")

enum
{
	LABEL_INFO_TAB = 0,
	TAG_INFO_TAB,
};

///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifdef REMOVE_TAG_FEATURE
//class GraphVerticalCursorDlg : public ResizeDialog
//#else
//class GraphVerticalCursorDlg : public MultiPaneDlg
//#endif
class GraphVerticalCursorDlg : public MultiPaneDlg
///End HIDE_VCURSOR_TO_A_SIMPLER_DB
{	
public:
	GraphVerticalCursorDlg();
	~GraphVerticalCursorDlg();
	
	BOOL	Create(HWND hWndParent = NULL);
	BOOL 	StartVerticalCursor();
	void 	UpdateDialogData(bool bUupdateColOrder = false, bool bUpdateCursorPos = true);//void UpdateDialogData(bool bUupdateColOrder = false);	///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
	BOOL	ApplyToolSettings(const TreeNode& tnSettings);
	
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
  	//bool	ConstrucPlotsMenu(Menu& cellMenu);	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	void	OnToggleOnePlotShow(int nCmd);
  	void	OnIncludeSelectedPlots(bool bInclude);//void 	OnOpenSelectPlotsDlg();	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	///End MENU_TO_HIDE_PLOT_FROM_DLG
	
	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT	
	void	OnHideSelectedPlotsFromGrid();
	void	OnShowAllPlotsInGrid();
	void	OnUnlinkSelectedGraphs();
	///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	
	///Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS
	bool	HasLinkedGraphs();
	bool 	IsLinkGraphSaved();
	void	OnSaveLinkedGraphs();
	void	OnLoadLinkedGraphs();
	///End SAVE_AND_LOAD_LINKED_GRAPHS
	
	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	BOOL 	GetTreeFromGraph(UINT uidLine, TreeNode& trGraphTree);
	BOOL 	SetGraphTree(TreeNode& trGraphTree);
	///End PASS_MORE_INFO_TO_LINKED_GRAPH

	///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	BOOL	DumpData();
	BOOL	GetGUITree(TreeNode& trGUI);
	BOOL	SetGUITree(TreeNode& trGUI);
	BOOL	LoadTheme(LPCSTR lpcszTheme);
	BOOL	SaveTheme(LPCSTR lpcszTheme);
	///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR

	///------ Folger 07/27/2012 ORG-6339-P1 SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	OUID VLine();
	///------ End SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
	ON_DESTROY(OnDestroy)
	ON_HELPINFO(OnHelp)
	ON_CANCEL(OnClose)
	ON_CHANGE_PAGE(OnActivePageChange)
	ON_OBJECT_MODIFY(OnOriginModify)///Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
	ON_OK(OnOK)
	ON_GETMINMAXINFO(OnMinMaxInfo)///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
#ifndef REMOVE_TAG_FEATURE
	ON_TAB_SEL_CHANGE(IDC_BOTTOM_INFO_TAB, OnTabChange)
#endif//REMOVE_TAG_FEATURE
	//ON_CONTEXTMENU(OnShowMenu)		///Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS	///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_TAG_INFO_LIST_BOX, OnBeforeMouseDownInfoList)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_LABEL_INFO_LIST_BOX, OnBeforeMouseDownInfoList)

	///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
	ON_CHANGE_DATASET(OnChangeActivePlot)
	ON_GRID_DBLCLICK(IDC_LABEL_INFO_LIST_BOX, OnDBClickInfoList)
	///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT

	ON_GRID_BEFORE_EDIT(IDC_TAG_INFO_LIST_BOX, OnBeforeEditInfoList)
	ON_GRID_BEFORE_EDIT(IDC_LABEL_INFO_LIST_BOX, OnBeforeEditInfoList)
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	ON_GRID_AFTER_EDIT(IDC_LABEL_INFO_LIST_BOX, OnAfterEditInfoList)
	ON_BN_CLICKED(IDC_SNAP_NEAREST_X, OnCheckUseNearestX)
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	ON_GRID_AFTER_MOVE_COLUMNS(IDC_LABEL_INFO_LIST_BOX, OnAfterMoveColumns)	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
	ON_GRID_AFTER_SORT(IDC_LABEL_INFO_LIST_BOX, OnAfterSort)	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER 

	ON_KEY(IDC_TAG_INFO_LIST_BOX, OnKey)
	ON_KEY(IDC_LABEL_INFO_LIST_BOX, OnKey)
	
	ON_USER_MSG(WM_USER_CURSOR_DELETED, OnCursorDeleted)
	ON_USER_MSG(WM_USER_UPDATE_CURSOR_POSITION, OnUpdateCursorPosition)

	ON_USER_MSG(WM_USER_TAG_ADDED, OnTagAdded)
	ON_USER_MSG(WM_USER_TAG_DELETED, OnTagDeleted)
	ON_USER_MSG(WM_USER_UPDATE_TAG_SELECT_STATE, OnUpdateTagSelectState)

	ON_USER_MSG(WM_USER_UPDATE_CURSOR_INTERSECT_POINT_BEGIN, OnUpdateCursorIntersectPointBegin)
	ON_USER_MSG(WM_USER_NEW_CURSOR_INTERSECT_POINT, OnAfterMoveCursor)///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS

	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	ON_USER_MSG(WM_USER_QUERY_POSITION_CHANGE_BY_EDITING, OnQueryPositionChangeByEditing)
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE

	ON_USER_MSG(WM_USER_MOVE_LINE, OnMoveLine)	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	
	ON_BN_CLICKED(IDC_STATIC_TIPS_X, OnChangeXBasedLayer)	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	ON_BN_CLICKED(IDC_CHECK_USE_X, OnMoveLineTo)
	
	ON_GROBJ_EXECUTE(OnGrObjChange)			///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	
#ifndef REMOVE_LABEL_FEATURE
	ON_USER_MSG(WM_USER_UPDATE_TEXT_LABELS_SHOW_STATE, OnUpdateTextLabelsShowState)
	ON_BN_CLICKED(IDC_BTN_SHOW_LABEL, OnShowLabels)
	ON_BN_CLICKED(IDC_BTN_INCREASE_FONT, OnIncreaseFontSize)
	ON_BN_CLICKED(IDC_BTN_DECREASE_FONT, OnDecreaseFontSize)
#endif//REMOVE_LABEL_FEATURE

#ifndef REMOVE_TAG_FEATURE
	ON_BN_CLICKED(IDC_BTN_ADD_TAG, OnAddTags)
	ON_BN_CLICKED(IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS, OnRemoveSelectedTagsGroups)
	ON_BN_CLICKED(IDC_BTN_CLEAR_ALL_TAGS, OnClearAllTags)
	ON_BN_CLICKED(IDC_BTN_NEXT_TAG, OnSelectNextTagsGroup)
	ON_BN_CLICKED(IDC_BTN_PREVIOUS_TAG, OnSelectPreviousTagsGroup)
#endif//REMOVE_TAG_FEATURE
	ON_BN_CLICKED(IDC_BTN_DOWNUP, OnShowBottomPane)			///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
	ON_BN_CLICKED(IDC_BTN_CONFIG_OUTPUT, OnConfigureOutput)
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
	//ON_KEY(IDC_EDIT_RESULT_SHEET, OnKeyEditWks)		
	//ON_EN_KILLFOCUS(IDC_EDIT_RESULT_SHEET, OnUpdateEditWks)
	///End MOVE_OUT_RESULT_SHEET_EDITBOX
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	ON_BN_CLICKED(IDC_BTN_DUMP_TAG_INTO_WKS, 	OnDumpData)	
	ON_BN_CLICKED(IDC_BTN_ACTIVATE_WKS, 		OnActivateOutputWks)		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
	ON_BN_CLICKED(IDC_BTN_LINK_GRAPH, 			OnClickLinkGraph)			///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
	ON_BN_CLICKED(IDC_BTN_DUMP_LABEL, OnDumpLabelS)
#endif//REMOVE_TAG_FEATURE
///End DUMP_LABEL_AND_LINE_ON_GRAPH

	///------ Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
	ON_PAGE_DESTROY(OnPageDestroy)
	///------ End REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY

EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	BOOL OnDestroy();
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL OnClose();
	BOOL OnActivePageChange();
	BOOL UpdateDlgTitle();	///Sophy 8/8/2011 ORG-3106-S7 BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES

	BOOL OnOriginModify(OriginObject obj, int nKind);///Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
	BOOL OnOK();
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//virtual int GetTotalWidth(bool bGetMin = false);
	//virtual int GetTotalHeight(bool bGetMin = false);
	// virtual
	int	GetMinClientTrackWidth();
	// virtual
	int	GetMinClientTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

	BOOL OnTabChange(Control ctrl);
	BOOL OnKey(Control ctrl, UINT msg, UINT wParam, UINT lParam);
	
	BOOL OnCursorDeleted(uint wParam, uint lParam);
	BOOL OnUpdateCursorPosition(uint wParam, uint lParam);
#ifndef REMOVE_LABEL_FEATURE
	BOOL OnUpdateTextLabelsShowState(uint wParam, uint lParam);
#endif
	BOOL OnTagAdded(uint wParam, uint lParam);
	BOOL OnTagDeleted(uint wParam, uint lParam);
	BOOL OnUpdateTagSelectState(uint wParam, uint lParam);

	BOOL OnUpdateCursorIntersectPointBegin(uint wParam, uint lParam);
	BOOL OnAfterMoveCursor( uint wParam, uint lParam );

	///------ Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
	BOOL OnPageDestroy(Page pg, DWORD dwCntrl);
	///------ End REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY

	///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
	BOOL	OnQueryPositionChangeByEditing(DWORD wParam, DWORD lParam);
	///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE

	BOOL	OnMoveLine(DWORD wParam, DWORD lParam);	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	
	BOOL OnChangeXBasedLayer(Control ctrl);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	BOOL OnMoveLineTo(Control ctrl);
	BOOL OnShowLabels(Control ctrl);
	BOOL OnAddTags(Control ctrl);
	BOOL OnRemoveSelectedTagsGroups(Control ctrl);
	BOOL OnClearAllTags(Control ctrl);
	BOOL OnSelectNextTagsGroup(Control ctrl);
	BOOL OnSelectPreviousTagsGroup(Control ctrl);
	BOOL OnIncreaseFontSize(Control ctrl);
	BOOL OnDecreaseFontSize(Control ctrl);
	BOOL OnConfigureOutput(Control ctrl);
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
	//BOOL OnKeyEditWks(Control ctrl, UINT msg, UINT wParam, UINT lParam);		
	//BOOL OnUpdateEditWks(Control ctrl);
	///End MOVE_OUT_RESULT_SHEET_EDITBOX
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	BOOL OnDumpData(Control ctrl);
	BOOL OnActivateOutputWks(Control ctrl);		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
	BOOL OnClickLinkGraph(Control ctrl);		///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	//BOOL OnGrObjChange(GraphObject gr, int nEvent);		///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	BOOL OnGrObjChange(GraphObject gr, int nEvent, int nCtrl);	
	///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
	
	BOOL OnShowBottomPane(Control ctrl);
	//BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);	///Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS	///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	BOOL OnBeforeMouseDownInfoList(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void OnBeforeEditInfoList(Control flxControl, long nRow, long nCol, BOOL* pCancel);

	///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
	void OnDBClickInfoList(Control ctrl);
	BOOL OnChangeActivePlot();
	///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT
	
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	void OnAfterEditInfoList(Control flxControl, int nRow, int nCol);
	BOOL OnCheckUseNearestX(Control cntrl);
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	void OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition);	///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
	void OnAfterSort(Control ctrl, long lCol, int* pnOrder);	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER 
	
	///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
	BOOL OnDumpLabelS(Control ctrl);
#endif//REMOVE_TAG_FEATURE
	///End DUMP_LABEL_AND_LINE_ON_GRAPH
	
protected:
	int GetBottomPaneSubControls(vector<uint>& vnCntrls);
	int GetMinTopPaneHeight();
	void AllowResizing(BOOL bResizing = TRUE);
		
private:
	void initButtons();
	void arrangeControls();
	void PositionSnapNearestXCheckbox();
		
	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	void cvtXBaseToLineUnit(double& dd, bool bReverse);
	void enableXBasedLayerBtn();		
	///End BTN_TO_CAHNGE_X_REFERECE_LAYER
	void enableLinkGraphBtn(bool bEnable);		///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	void enableActivateBtn(bool bEnable);		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS
	updateSnapCheckBoxes(const VManagerSetting& managerSetting);///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
#ifndef REMOVE_LABEL_FEATURE
	void updateShowHideLabelsBtnState();
#endif
	void updateTagRelatedBtnState(BOOL bEnableBtn = FALSE);
	void updateRemoveSelTagsGrpsBtnState();
	
	void updateCursorPos(bool bIsMoving = false);

	void updateTagsInfo();
	void updateCursorDataInfo(bool bUpdateCursorPos = true);//void updateCursorDataInfo(); ///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
	void showCursorInfos(const VCursorShow& cursorshow);///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	void checkUpdateShowCursorInfos();///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
	
	void addTagInfoToTable(const VTagUnit& vTagUnit);
	//void removeTagInfoFromTable(const UINT uTagUID);
	void removeTagInfoFromTable(const VTagUnit& vTagUnit);

	int getTitleWidth();
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//void getDlgFrameSpace(int* pnFrameHoriz = NULL, int* pnFrameVert = NULL);
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

	BOOL constructSettingGUITree(TreeNode& tnSettingGUI, const VManagerSetting& managerSetting);
	void showReportSheetName(const VManagerSetting& managerSetting);	///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX

	BOOL shouldUpdateDialogDataForPage(UINT uPageUID);
	
	BOOL updatePointsIDs(UINT uPageUID);	///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
	
	string	PlotListAttr()		{ return "PlotList"; }
	
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	void	showHidePlots(const vector<int>& vnChangePlot);
	///End MENU_TO_HIDE_PLOT_FROM_DLG

	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	double	getInputXValue();	
	void 	setInputXValue(double dPosX);
	///End PASS_MORE_INFO_TO_LINKED_GRAPH
	
private:
#ifdef REMOVE_TAG_FEATURE
	TabControl 				m_BottomTab;
#endif
	Control					m_editPos;
	DWORD					m_dwXValueStyle;		///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
	DateTimeCtrl			m_DateTimeXValue;		///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
	TagInfoTable			m_TagInfoTable;
	CursorDataInfoTable		m_CursorDataInfoTable;

	int						m_nGroupedBtnTotalWidth;
	///------ Folger 01/15/10 X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	BOOL					m_bPositionChangeByEditing;
	///------ End X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	double					m_dXValue;				///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
};

/*----------------------------------------------------------------------------*/
/* Constructors/Destructors of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/

GraphVerticalCursorDlg::GraphVerticalCursorDlg()
///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifdef REMOVE_TAG_FEATURE
	//: ResizeDialog(IDD_VERTICAL_CURSOR_DLG, "ODlg8")
//#else
	//: MultiPaneDlg(IDD_VERTICAL_CURSOR_DLG, "ODlg8")
//#endif
	: MultiPaneDlg(IDD_VERTICAL_CURSOR_DLG, "ODlg8")
///End HIDE_VCURSOR_TO_A_SIMPLER_DB
{
	MY_DBG_OUTPUT("Constructing Dialog!");
	m_nGroupedBtnTotalWidth = -1;
	///------ Folger 01/15/10 X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	m_bPositionChangeByEditing = FALSE;
	///------ End X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
}

GraphVerticalCursorDlg::~GraphVerticalCursorDlg()
{
	MY_DBG_OUTPUT("Destructing Dialog!");
}

/*----------------------------------------------------------------------------*/
/* Event handlers of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/

BOOL GraphVerticalCursorDlg::OnInitDialog()
{	
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	GetItem(IDC_STATIC_RESULT_SHEET).Visible = GetItem(IDC_EDIT_RESULT_SHEET).Visible = false;
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	arrangeControls();

#ifdef REMOVE_TAG_FEATURE 
	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
	//ResizeDialog::OnInitDialog(IDC_BOTTOM_INFO_TAB, STR_DLG_NAME);
	//GetItem(IDC_BTN_DOWNUP).Visible = false;
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show Details");
	vstrTipsUpDown[1] = _L("Hide Details");
	MultiPaneDlg::OnInitDialog(0, IDC_BTN_DOWNUP, IDC_BOTTOM_INFO_TAB, vstrTipsUpDown, STR_DLG_NAME);
	///End HIDE_VCURSOR_TO_A_SIMPLER_DB
	GetItem(IDC_TAG_INFO_LIST_BOX).Visible = false;
	GetItem(IDC_LABEL_INFO_LIST_BOX).Visible = true;
	m_BottomTab = GetItem(IDC_BOTTOM_INFO_TAB);
#else//REMOVE_TAG_FEATURE
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show Details");
	vstrTipsUpDown[1] = _L("Hide Details");
	MultiPaneDlg::OnInitDialog(IDC_FRAME_TOP_PANE, IDC_BTN_DOWNUP, IDC_BOTTOM_INFO_TAB, vstrTipsUpDown, STR_DLG_NAME, 0, NULL);
	
	m_TagInfoTable.Init(IDC_TAG_INFO_LIST_BOX, *this, STR_DLG_NAME);
#endif//REMOVE_TAG_FEATURE
	m_CursorDataInfoTable.Init(IDC_LABEL_INFO_LIST_BOX, *this, STR_DLG_NAME);
	
	m_BottomTab = GetItem(IDC_BOTTOM_INFO_TAB);
	m_BottomTab.InsertItem(LABEL_INFO_TAB, _LC("Cursor", _CAT));
#ifndef REMOVE_TAG_FEATURE
	m_BottomTab.InsertItem(TAG_INFO_TAB, _LC("Tags", _CAT));
	m_BottomTab.SetCurSel(0);
	OnTabChange(m_BottomTab);
#endif//REMOVE_TAG_FEATURE
	PositionSnapNearestXCheckbox();

	m_editPos	= GetItem(IDC_EDIT_X);
	m_dwXValueStyle = GetWindowLong(m_editPos.GetSafeHwnd(), GWL_STYLE);	///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
	Text		= STR_DLG_NAME;

	initButtons();	
	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifdef REMOVE_TAG_FEATURE
	//AllowResizing(true);
//#else
	AllowResizing(IsBottomPaneShown());
//#endif
	///End HIDE_VCURSOR_TO_A_SIMPLER_DB
	if ( !StartVerticalCursor() )
	{
		SendMessage(WM_CLOSE);
		return TRUE;
	}

	UpdateDialogData();
	
	///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
	//UpdateDlgTitle();	///Sophy 8/8/2011 ORG-3106-S7 BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES force update title
	///------ End VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE

	return TRUE;
}

BOOL GraphVerticalCursorDlg::StartVerticalCursor()
{
	///Sophy 8/8/2011 ORG-3106-S7 BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES
	//return THE_VCURSOR_MANAGER.StartVerticalCursor(this);
	BOOL bRet = THE_VCURSOR_MANAGER.StartVerticalCursor(this);
	///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
	// if ( bRet )
	// 	UpdateDlgTitle();
	///------ End VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
	return bRet;
	///end BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES
}

BOOL GraphVerticalCursorDlg::OnReady()
{	
//#ifndef REMOVE_TAG_FEATURE///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
	UpdateDlgSize();
//#endif
	SetInitReady();
	
	return TRUE;
}

int GraphVerticalCursorDlg::GetMinTopPaneHeight()
{
	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB	
	//Button btnCheckX;
	//RECT rCheckX;
	//GetControlClientRect(IDC_CHECK_USE_X, rCheckX, &btnCheckX);
	//int nHeight = RECT_HEIGHT(rCheckX);
	//if(nHeight < 5)
		//nHeight = 10;
	//return nHeight*2 + 3 * GetControlGap();
	RECT rBtn;
	GetControlClientRect(IDC_BTN_DOWNUP, rBtn);
	int nHeight = RECT_HEIGHT(rBtn);
	if(nHeight < 5)
		nHeight = 10;
	return nHeight + 2 * GetControlGap();
}

BOOL GraphVerticalCursorDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);

	pSz->top = -1;
	pSz->left = -1;

//#ifndef REMOVE_TAG_FEATURE	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//pSz->width = GetTotalWidth(TRUE) * 1.5;
	//pSz->height = GetTotalHeight(TRUE) * 2;
	pSz->width = GetMinClientTrackWidth() * 1.5;
	pSz->height = GetMinClientTrackHeight() * 2;
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	
	if(0 == HasPreviousSize(STR_DLG_NAME))
	{
		SetBottomPaneHeight(150);
	}
	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#else	
	///// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	////pSz->width = GetTotalWidth(TRUE) * 1.5;
	////pSz->height = GetTotalHeight(TRUE) * 4;
	//pSz->width = GetMinClientTrackWidth() * 1.5;
	//pSz->height = GetMinClientTrackHeight() * 4;
	///// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//#endif
	///End HIDE_VCURSOR_TO_A_SIMPLER_DB
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return FALSE;

 	MoveControlsHelper	_temp(this);

#ifdef REMOVE_TAG_FEATURE
	Control cc;
	RECT rr;
	GetControlClientRect(IDC_BOTTOM_INFO_TAB, rr, &cc);
	rr.bottom = cy;
	rr.right = cx;
	MoveControl(cc, rr);
		
#else//REMOVE_TAG_FEATURE
	vector<uint> vnBtnIDs = {
		IDC_CHECK_USE_X,
		0
	};
	
	MultiPaneDlg::OnDlgResize(vnBtnIDs, cx, cy, false);
	
	const int nControlGap		= GetControlGap();
	Button btnCheckX;
	RECT rCheckX;
	GetControlClientRect(IDC_CHECK_USE_X, rCheckX, &btnCheckX);
	vector<uint> vnOtherCtrlIDs = {IDC_STATIC_TIPS_X, IDC_EDIT_X, IDC_CHECK_USE_X, 0};
	ArrangeControlsLeftRight(vnOtherCtrlIDs, nControlGap, rCheckX.top, nControlGap);
#endif//REMOVE_TAG_FEATURE
	
	Control ctrlTab;
	RECT rTab;
	GetControlClientRect(IDC_BOTTOM_INFO_TAB, rTab, &ctrlTab);
	m_BottomTab.AdjustRect(FALSE, &rTab);
	MoveControl(GetItem(IDC_TAG_INFO_LIST_BOX), rTab);
	MoveControl(GetItem(IDC_LABEL_INFO_LIST_BOX), rTab);
	
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnDestroy()
{
	///------ Folger 01/22/09 ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE
	THE_VCURSOR_MANAGER.ResetParentWnd();
	///------ End ORIGIN_CRASH_WHEN_EXIT_IF_GRAPH_PAGE_HAS_VERTICAL_CURSOR_IS_NOT_ACTIVE

	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifdef REMOVE_TAG_FEATURE
	//ResizeDialog::OnDestroy();
//#else
	//MultiPaneDlg::OnDestroy();
//#endif
	MultiPaneDlg::OnDestroy();
	///End HIDE_VCURSOR_TO_A_SIMPLER_DB

	if (s_pVerticalCursorDlg)
	{
		delete this;
		s_pVerticalCursorDlg = NULL;
	}
	
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnClose()
{
	BOOL bRemoveOK = THE_VCURSOR_MANAGER.RemoveVerticalCursor();
	Visible = !bRemoveOK;
#ifdef _DEBUG
	if (s_bDestroyDlgOnClose)
	{
		s_bDestroyDlgOnClose = FALSE;
		return TRUE;
	}
#endif // _DEBUG
	return FALSE;	// return FALSE to prevent calling OnDestroy() since we just simply want this dialog to be hidden
}

BOOL GraphVerticalCursorDlg::OnActivePageChange()
{	
	BOOL bIsPageHasVerticalCursor = THE_VCURSOR_MANAGER.HasCursorHolderForPage();
	Visible = bIsPageHasVerticalCursor;
	if ( bIsPageHasVerticalCursor && StartVerticalCursor() )
	{
		///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
		// UpdateDlgTitle();	///Sophy 8/8/2011 ORG-3106-S7 BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES force update title
		///------ End VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
		UpdateDialogData();
	}
	return TRUE;
}

///Sophy 8/8/2011 ORG-3106-S7 BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES
BOOL GraphVerticalCursorDlg::UpdateDlgTitle()
{
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL != pHolder && pHolder->m_line.GetValidObj() )
	{
		GraphLayer glActive;
		pHolder->GetXBasedLayer(glActive);//pHolder->m_line.GetParent(glActive);	///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		if ( glActive )
		{
			string strDlgTitle;
			strDlgTitle.Format(_L("Vertical Cursor - X Based on Layer%d"), glActive.GetIndex() + 1);
			///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
			int nLinkedGraphs = pHolder->GetLinkedGraphs();
			if ( nLinkedGraphs > 0 )
			{
				string strLinkedGraphs;
				strLinkedGraphs.Format(" - %d linked graphs", nLinkedGraphs);
				strDlgTitle += strLinkedGraphs;
			}
			///------ End VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
			Text = strDlgTitle;
		}
	}
	return TRUE;
}
///end BETTER_HINTS_ACTIVE_LAYER_FOR_VERTICAL_CURSOR_X_COORDINATES

///Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
BOOL GraphVerticalCursorDlg::OnOriginModify(OriginObject obj, int nKind)
{
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	//Edit editWks = GetDlgItem(IDC_EDIT_RESULT_SHEET);
	//if(editWks)
	//{
		//Worksheet wks(editWks.Text);
	VManagerSetting		managerSetting;
	if( THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
	{
		///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
		//Worksheet wks(managerSetting.m_strDumpWksName);
		string strWksName = managerSetting.m_strDumpWksName;
		okutil_arg_copy(&strWksName);
		Worksheet wks(strWksName);
		///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
		enableActivateBtn( wks.IsValid() );
	}
	return TRUE;
}
//End ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
BOOL GraphVerticalCursorDlg::OnOK()
{
	return FALSE;	// return FALSE to prevent dialog from closing since 'return' wanted to be received by the X edit control.
}

//virtual
/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int GraphVerticalCursorDlg::GetTotalWidth(bool bGetMin/* = false*/)
int GraphVerticalCursorDlg::GetMinClientTrackWidth()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	static int s_nWidth = -1;
	if (-1 == s_nWidth)
	{
		// Make the dialog to show at least the grouped buttons all the time.
		const int nTitleWidth = getTitleWidth();

		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//int nFrameHorizSpace;
		//getDlgFrameSpace(&nFrameHorizSpace);

		//s_nWidth = max(nTitleWidth, m_nGroupedBtnTotalWidth) + GetControlGap()*2 + nFrameHorizSpace;
		s_nWidth = max(nTitleWidth, m_nGroupedBtnTotalWidth) + GetControlGap()*2;
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}

	return s_nWidth;
}

//virtual
/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int GraphVerticalCursorDlg::GetTotalHeight( bool bGetMin /*= false*/ )
//{
//	if(bGetMin)
//	{
int GraphVerticalCursorDlg::GetMinClientTrackHeight()
{
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		int nHeight = GetMinTopPaneHeight();
//#ifndef REMOVE_TAG_FEATURE	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
		if(IsBottomPaneShown())
			nHeight += GetMinBottomPaneHeight();
//#endif	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
		return nHeight;
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//	}
//#ifdef REMOVE_TAG_FEATURE
// 	return	ResizeDialog::GetTotalHeight(bGetMin);
//#else
//	return MultiPaneDlg::GetTotalHeight(bGetMin);
//#endif
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
}

BOOL GraphVerticalCursorDlg::OnTabChange( Control ctrl )
{
	const int nCurSelTab = m_BottomTab.GetCurSel();
	const bool bShowTagInfo = (TAG_INFO_TAB == nCurSelTab);

	m_TagInfoTable.SetVisible(bShowTagInfo);
	m_CursorDataInfoTable.SetVisible(!bShowTagInfo);

	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnKey( Control ctrl, UINT msg, UINT wParam, UINT lParam )
{
	if( msg == WM_KEYDOWN )
	{
		switch(wParam)
		{
		case VK_F2:
			return TRUE;
		case VK_DELETE:
			//m_builtInGridCtrl.OnDelete(ctrl);
			break;
		default:
			return FALSE;
		}
		return TRUE;
	}
	return FALSE;
}

BOOL GraphVerticalCursorDlg::OnCursorDeleted( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == not used
	///------ Folger 01/27/10 VERTICAL_CURSOR_DIALOG_STILL_SHOW_AFTER_CURSOR_LINE_DELETED
	//if ( !shouldUpdateDialogDataForPage(wParam) )
		//return FALSE;
	///------ eND VERTICAL_CURSOR_DIALOG_STILL_SHOW_AFTER_CURSOR_LINE_DELETED
	///------ Folger 07/30/2012 ORG-6339-P1 SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	//Visible = THE_VCURSOR_MANAGER.HasCursorHolderForPage();
	double rNoHideDB = 0;
	LT_get_var("@DGD", &rNoHideDB);
	if ( !(int)rNoHideDB )
		Visible = THE_VCURSOR_MANAGER.HasCursorHolderForPage();
	///------ End SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	
	///------ Folger 01/27/10 VERTICAL_CURSOR_DIALOG_STILL_SHOW_AFTER_CURSOR_LINE_DELETED
	//return TRUE;
	return shouldUpdateDialogDataForPage(wParam);
	///------ End VERTICAL_CURSOR_DIALOG_STILL_SHOW_AFTER_CURSOR_LINE_DELETED
}

BOOL GraphVerticalCursorDlg::OnUpdateCursorPosition(uint wParam, uint lParam)
{
	// wParam == uPageUID, lParam == A flag that indicating whether the cursor is moving or moved
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	const bool bIsMoving = CURSOR_MOVING == lParam;
	updateCursorPos( bIsMoving );
	return TRUE;
}
#ifndef REMOVE_LABEL_FEATURE
BOOL GraphVerticalCursorDlg::OnUpdateTextLabelsShowState( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == not used
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	updateShowHideLabelsBtnState();
	return TRUE;
}
#endif//REMOVE_LABEL_FEATURE
BOOL GraphVerticalCursorDlg::OnTagAdded( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == Newly added tag's index
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	if (THE_VCURSOR_MANAGER.GetNumTags() == 1)
		updateTagRelatedBtnState(TRUE);
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnTagDeleted( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == Deleted tag's UID
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	if (THE_VCURSOR_MANAGER.GetNumTags() <= 0)
		updateTagRelatedBtnState(FALSE);
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnUpdateTagSelectState( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == The index of TagUnit within the array of holder
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	const GraphVerticalCursorHolder* pgvcHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(wParam);
	if (pgvcHolder)
	{
		GetItem(IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS).Enable = pgvcHolder->m_nSelectedTagsCount > 0;

		const VTagUnit& vTagUnit = pgvcHolder->m_arrTagUnits.GetAt(lParam);
		if (vTagUnit.m_bIsSelected)
		{
			addTagInfoToTable(vTagUnit);
		}
		else
		{
			//removeTagInfoFromTable( vTagUnit.m_vTag.GetUID() );
			removeTagInfoFromTable( vTagUnit );
		}
	}
	return TRUE;
}

BOOL GraphVerticalCursorDlg::OnUpdateCursorIntersectPointBegin( uint wParam, uint lParam )
{
	// wParam == uPageUID, lParam == Not used
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	
	m_CursorDataInfoTable.ClearAll();
	return TRUE;
}

///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
//static string _ftoa(const XInfo& xinfo, double dd, int nSigificantDigits)
//{
	//string strOut = _convert_double_to_date_time_str(xinfo, dd);
	//if( strOut.IsEmpty() )
		//strOut = ftoa_sd(dd, nSigificantDigits);
	//return strOut;
//}

static double _atof(const XInfo& xinfo, LPCSTR lpcsz)
{
	double ddOut =_convert_date_time_str_to_double(xinfo, lpcsz);
	if( is_missing_value(ddOut) )
		ddOut = atof(lpcsz);
	return ddOut;
}
///End SHOW_XVALUE_WITH_FORMAT

///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
double	GraphVerticalCursorDlg::getInputXValue()
{
	double dd;
	///Jasmine 09/11/2012 ORG-6419 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
	VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint( 0 );
	if(	pti &&
		( pti->IsXDateTime() )
		&& m_DateTimeXValue )
	{
		dd = m_DateTimeXValue.GetValue();
		if(pti->xinfo.format == OULABEL_TIME)
			dd = dd - floor(dd);
	}
	else		
	///End USE_DATE_TIME_PICKER_FOR_SUCH_DATA	
	{
		///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
		if ( pti )
			dd = _atof(pti->xinfo, m_editPos.Text);
		else
		///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
			dd = atof(m_editPos.Text);
	}
	
	return dd;
}

void	GraphVerticalCursorDlg::setInputXValue(double dPosX)
{
	VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(0);
	if ( pti && pti->IsXDateTime() )
	{
		if(pti->xinfo.format == OULABEL_TIME && floor(dPosX) <= 0)
			dPosX += 2456070;
		m_DateTimeXValue.SetValue(dPosX);
	}
	else
	{	
		string strOut;
		if(pti)
			strOut = _convert_double_to_date_time_str(pti->xinfo, dPosX);
		if( strOut.IsEmpty() )
			strOut = ftoa(dPosX);
		//m_editPos.Text = strOut;
		GetItem(IDC_EDIT_X).Text = strOut;		
	}
}
///End PASS_MORE_INFO_TO_LINKED_GRAPH

///------ Folger 01/22/10 CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE
BOOL	GraphVerticalCursorDlg::OnQueryPositionChangeByEditing(DWORD wParam, DWORD lParam)
{
	double*		pr = (double*)wParam;
	if ( !m_bPositionChangeByEditing )
		return FALSE;
	
	if ( pr )
	{
		///Jasmine 09/11/2012 ORG-6419 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
		//*pr = atof(m_editPos.Text);
		*pr = getInputXValue();	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
		///End USE_DATE_TIME_PICKER_FOR_SUCH_DATA	
	}
	return TRUE;
}
///------ End CURSOR_X_COORDINATE_LOSE_PRECISION_IN_INFO_TABLE

///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
static void _get_graph_cell_string(string& str, VIntersectPoint* pti)
{
	str.Format("%s%s", pti->bActive ? "*" : "", pti->plotinfo.graph);
}
///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT

///Jasmine 01/15/10 REORDER_CURSOR_VALUE_BY_LAYER_POS
BOOL GraphVerticalCursorDlg::OnAfterMoveCursor( uint wParam, uint lParam )
{
	if ( !shouldUpdateDialogDataForPage(wParam) )
		return FALSE;
	
	//updateCursorPos();		///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA	///Jasmine 09/10/2012 ORG-6764-P1 UNNECESSERY_UPDATE_REWRITE_USER_INPUT_XVALUE
	
	m_CursorDataInfoTable.ClearAll();	///Sophy 9/20/2011 ORG-3843-P1 PROPER_LOAD_SETTINGS_WHEN_OPEN_OGG
	
	int		nSize = THE_VCURSOR_MANAGER.GetPointsCount();
	if(nSize <= 0)
		return FALSE;
	
	vector<int> vnIndeces;	
	THE_VCURSOR_MANAGER.GetCursorDisplayOrder(vnIndeces, wParam);
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	VManagerSetting		managerSetting;
	THE_VCURSOR_MANAGER.GetSetting(managerSetting);
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	UpdateDlgTitle(); ///------ Folger 08/21/2012 ORG-4971-S7 VERTICAL_CURSOR_SHOULD_LINKED_GRAPHS_NUM_ON_TITLE
	
	const int nSigificantDigits = THE_VCURSOR_MANAGER.GetLabelsSignificantDigits();
	
	for(int ii = 0; ii < nSize; ii++)
	{
		VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint( vnIndeces[ii] );
		if ( NULL == pti )
		{
			ASSERT(FALSE);
			return FALSE;
		}
		
		DataPlot	dp;
		dp = (DataPlot)Project.GetObject(pti->plotuid);
		GraphLayer	gl;
		string 		strLayerRange;
		if(dp)
		{
			dp.GetParent(gl);
			gl.GetRangeString(strLayerRange);
		}
		
		vector<string> vsRowVals(TEXTLABELINFOGRIDCOLTYPE_TOTAL);
		for(int jj = 0; jj < TEXTLABELINFOGRIDCOLTYPE_TOTAL; jj++)
		{
			switch( m_CursorDataInfoTable.GetColType(jj) )
			{
			case TEXTLABELINFOGRIDCOLTYPE_INDEX:
				vsRowVals[jj] = ftoa(pti->index);
				break;
			case TEXTLABELINFOGRIDCOLTYPE_X_SCALE:
				///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
				//vsRowVals[jj] = _ftoa(pti->xinfo, pti->fpPoint.x, nSigificantDigits);///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
				///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				//vsRowVals[jj] = ftoa(pti->fpPoint.x, managerSetting.m_cursorshow.strXDisp);
				vsRowVals[jj] = _cvt_double_to_str_with_display_setting(pti->fpPoint.x, managerSetting.m_cursorshow.strXDisp, strLayerRange);
				///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				///end NEW_OPTIONS_DIALOG
				break;
			case TEXTLABELINFOGRIDCOLTYPE_Y_SCALE:
				///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
				//vsRowVals[jj] = ftoa_sd(pti->fpPoint.y, nSigificantDigits);
				///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				//vsRowVals[jj] = ftoa(pti->fpPoint.y, managerSetting.m_cursorshow.strYDisp);
				vsRowVals[jj] = _cvt_double_to_str_with_display_setting(pti->fpPoint.y, managerSetting.m_cursorshow.strYDisp, strLayerRange);
				///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS	
				///end NEW_OPTIONS_DIALOG
				break;
			///Jasmine 01/20/10 SHOW_NEAREST_POINT
			case TEXTLABELINFOGRIDCOLTYPE_NEAREST_X:
				///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
				//vsRowVals[jj] = _ftoa(pti->xinfo, pti->fpNearPoint.x, nSigificantDigits);///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
				///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				//vsRowVals[jj] = ftoa(pti->fpNearPoint.x, managerSetting.m_cursorshow.strXDisp);
				vsRowVals[jj] = _cvt_double_to_str_with_display_setting(pti->fpNearPoint.x, managerSetting.m_cursorshow.strXDisp, strLayerRange);
				///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				///end NEW_OPTIONS_DIALOG
				break;
			case TEXTLABELINFOGRIDCOLTYPE_NEAREST_Y:
				///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
				//vsRowVals[jj] = ftoa_sd(pti->fpNearPoint.y, nSigificantDigits);
				///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				//vsRowVals[jj] = ftoa(pti->fpNearPoint.y, managerSetting.m_cursorshow.strYDisp);	
				vsRowVals[jj] = _cvt_double_to_str_with_display_setting(pti->fpNearPoint.y, managerSetting.m_cursorshow.strYDisp, strLayerRange);
				///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
				///end NEW_OPTIONS_DIALOG
				break;
			///End SHOW_NEAREST_POINT
			case TEXTLABELINFOGRIDCOLTYPE_ID:				///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
				///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
				//int id = 10 * pti->layer + pti->plot;
				int		id = pti->plotuid;
				///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
				vsRowVals[jj] = (string)id;
				break;
			///Jasmine 01/18/10 SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
			case TEXTLABELINFOGRIDCOLTYPE_BOOKNAME:
				vsRowVals[jj] = pti->plotinfo.book;
				break;
			case TEXTLABELINFOGRIDCOLTYPE_SHEETNAME:
				vsRowVals[jj] = pti->plotinfo.sheet;
				break;
			///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE	
			//case TEXTLABELINFOGRIDCOLTYPE_SHORTNAME:
				//vsRowVals[jj] = pti->plotinfo.colname;
				//break;
			//case TEXTLABELINFOGRIDCOLTYPE_LONGNAME:
				//vsRowVals[jj] = pti->plotinfo.collongname;
				//break;
			case TEXTLABELINFOGRIDCOLTYPE_NAME:
				string strName = pti->plotinfo.collongname;
				if ( strName.IsEmpty() )
					strName = pti->plotinfo.colname;
				vsRowVals[jj] = strName;
				break;
			///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
			///End SHOW_MORE_THAN_ONE_PLOT_INFO_AT_A_TIME
			///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
			case TEXTLABELINFOGRIDCOLTYPE_SNAPTO:
				{
					if ( dp )
					{
						string		strDescription;
						_get_plot_legend_and_description(dp, NULL, &strDescription);
						vsRowVals[jj] = strDescription.Compare(managerSetting.m_strSnappedPlot) == 0 ? "1" : "0";
					}
				}
				break;
			///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
			///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
			case TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME:
				///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
				//vsRowVals[jj] = pti->plotinfo.graph;
				_get_graph_cell_string(vsRowVals[jj], pti);
				///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT
				break;
			///End SUPPORT_MULTI_WINS_CURSOR
			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
			case TEXTLABELINFOGRIDCOLTYPE_STATUS:
				vsRowVals[jj] = managerSetting.m_cursorshow.vnPlotShow[ii];
				break;
			///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
			}
		}
		m_CursorDataInfoTable.SetCells(vsRowVals, m_CursorDataInfoTable.GetRows()-1, false);
		
		///Sophy 8/9/2011 ORG-3106-S5 MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
		///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		//m_CursorDataInfoTable.SetIsRowHidden(m_CursorDataInfoTable.GetRows() - 1, managerSetting.m_cursorshow.vnPlotShow[vnIndeces[ii]] == 0);
		m_CursorDataInfoTable.SetIsRowHidden(m_CursorDataInfoTable.GetRows() - 1, managerSetting.m_cursorshow.vnPlotHideFromGrid[ii]);
		///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		///end MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG

	}
	
	m_CursorDataInfoTable.ResizeCols();
	return TRUE;
}
///End REORDER_CURSOR_VALUE_BY_LAYER_POS

///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
BOOL GraphVerticalCursorDlg::OnChangeXBasedLayer(Control ctrl)	
{
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL == pHolder )
		return FALSE;
	
	GraphLayer glXBased;
	pHolder->GetXBasedLayer(glXBased);
	
	GraphPage gp = glXBased.GetPage();
	vector<string> vsLayers(gp.Layers.Count());
	int ii = 0;
	foreach(GraphLayer gl in gp.Layers)
	{
		vsLayers[ii++] = gl.GetName();
	}
	
	GETN_BOX(trLayers)
	GETN_RADIO_INDEX(XBasedLayer, glXBased.GetIndex(), str_combine(vsLayers, "|"))
	
    if(GetNBox(trLayers))
    {
    	int nNew = trLayers.XBasedLayer.nVal;
    	if(nNew != glXBased.GetIndex())
    	{
    		GraphLayer glNew = gp.Layers(nNew);
    		pHolder->SetXBasedLayer(glNew);
    		UpdateDlgTitle(); 
    		updateCursorPos();
    	}
    }

    return TRUE;
}

void GraphVerticalCursorDlg::enableXBasedLayerBtn()
{
	BOOL bEnable = TRUE;
	
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL == pHolder )
		bEnable = FALSE;
	else
	{
		GraphLayer glXBased;
		pHolder->GetXBasedLayer(glXBased);
		
		GraphPage gp = glXBased.GetPage();
		bEnable = gp.Layers.Count() > 1;
	}
	
	GetItem(IDC_STATIC_TIPS_X).Enable = bEnable;
}

void GraphVerticalCursorDlg::cvtXBaseToLineUnit(double& dd, bool bReverse)
{
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL != pHolder )
	{
		GraphLayer glLine, glXBased;
		pHolder->m_line.GetParent(glLine);
		pHolder->GetXBasedLayer(glXBased);
		if(glLine.GetIndex() != glXBased.GetIndex())
		{
			double dPageCoor;
			VGraphLayer	vglXBased(glXBased), vglLine(glLine);
			if(bReverse)
			{
				vglLine.ScaleToPageCoordinate(dd, dPageCoor);
				vglXBased.PageToScaleCoordinate(dPageCoor, dd);
			}
			else
			{
				vglXBased.ScaleToPageCoordinate(dd, dPageCoor);
				vglLine.PageToScaleCoordinate(dPageCoor, dd);
			}
		}
	}
}
///End BTN_TO_CAHNGE_X_REFERECE_LAYER

BOOL GraphVerticalCursorDlg::OnMoveLineTo( Control ctrl )
{	
	///------ Folger 01/15/10 X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	m_bPositionChangeByEditing = TRUE;
	///------ End X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	//VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint( 0 );
	//double dd;
	//if(pti)
	//{
		/////Jasmine 09/11/2012 ORG-6419 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
		//if( (pti->xinfo.format == OULABEL_TIME || pti->xinfo.format == OULABEL_DATE)
			//&& m_DateTimeXValue)
		//{
			//dd = m_DateTimeXValue.GetValue();
			//if(pti->xinfo.format == OULABEL_TIME)
				//dd = dd - floor(dd);
		//}
		//else			
		/////End USE_DATE_TIME_PICKER_FOR_SUCH_DATA
			//dd = _atof(pti->xinfo, m_editPos.Text);
	//}
	//else
		//dd = atof(m_editPos.Text);
	double dd = getInputXValue();
	///End PASS_MORE_INFO_TO_LINKED_GRAPH
	
	///Jasmine 01/28/10 RESTRICT_X_EDIT_TEXT
	if( THE_VCURSOR_MANAGER.IsOutOfView(dd) )
	{
		MessageBox(GetSafeHwnd(), _L("Input X value is out of range."), ERROR_TITLE);
		m_bPositionChangeByEditing = FALSE;
		updateCursorPos(false);
		return FALSE;
	}
	///End RESTRICT_X_EDIT_TEXT
	
	cvtXBaseToLineUnit(dd, false);///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	
	return THE_VCURSOR_MANAGER.SetLinePosition(dd);
	///End SHOW_XVALUE_WITH_FORMAT
}

BOOL GraphVerticalCursorDlg::OnShowLabels(Control ctrl)
{
	Button btn(ctrl);
	if(!btn)
		return FALSE;
	return THE_VCURSOR_MANAGER.ShowTextLabels(btn.Check);
}

BOOL GraphVerticalCursorDlg::OnAddTags(Control ctrl)
{
	return THE_VCURSOR_MANAGER.AddTags();
}
 
BOOL GraphVerticalCursorDlg::OnRemoveSelectedTagsGroups( Control ctrl )
{
	return THE_VCURSOR_MANAGER.RemoveSelectedTagsGroups();
}

BOOL GraphVerticalCursorDlg::OnClearAllTags(Control ctrl)
{
	return THE_VCURSOR_MANAGER.ClearAllTags();
}

BOOL GraphVerticalCursorDlg::OnSelectNextTagsGroup( Control ctrl )
{
	return THE_VCURSOR_MANAGER.SelectTagsGroup(TRUE);
}

BOOL GraphVerticalCursorDlg::OnSelectPreviousTagsGroup( Control ctrl )
{
	return THE_VCURSOR_MANAGER.SelectTagsGroup(FALSE);
}

BOOL GraphVerticalCursorDlg::OnIncreaseFontSize(Control ctrl)
{
	const  bool bIncrease = true;
	return THE_VCURSOR_MANAGER.UpdateLabelsFontSize(bIncrease);
}

BOOL GraphVerticalCursorDlg::OnDecreaseFontSize(Control ctrl)
{
	const  bool bIncrease = false;
	return THE_VCURSOR_MANAGER.UpdateLabelsFontSize(bIncrease);
}

#define			STR_ACTUAL_WORKSHEET_NAME_FORMAT		_L("Actual Worksheet Name: %s")

///Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
#define	STR_DEFAULT_VALUE_ATTRIB	"DefaultValue"
static int _load_default_settings(TreeNode& trGetN)
{
	//Table tag settings
	string strDefX, strDefY;
	TreeNode trTable = trGetN.Table;
	trTable.XDisp.GetAttribute(STR_DEFAULT_VALUE_ATTRIB, strDefX);
	trTable.YDisp.GetAttribute(STR_DEFAULT_VALUE_ATTRIB, strDefY);
	
	trTable.XDisp.strVal = strDefX;
	trTable.YDisp.strVal = strDefY;
	trTable.CursorShow.Index.nVal = 0;
	trTable.CursorShow.CursorNearX.nVal = 1;
	trTable.CursorShow.CursorNearY.nVal = 1;
	trTable.CursorShow.Name.nVal = 1;
	trTable.CursorShow.SheetName.nVal = 0;
	trTable.CursorShow.BookName.nVal = 0;
	
	//Label & Tag
	TreeNode trLabelTag = trGetN.LabelsTags;
	trLabelTag.Labels.Label.nVal = LTT_Y_VALUE;
	trLabelTag.Labels.CustomFormat.strVal = STR_LABEL_TYPE_Y_VALUE;
	trLabelTag.Tags.Tag.nVal = TTT_X_VALUE;
	trLabelTag.Tags.CustomFormat.strVal = STR_TAG_TYPE_X_VALUE;
	trLabelTag.Tags.Location.nVal = TL_TOP;
	
	//Output
	string strWksName = "[Cursor]%H";
	TreeNode trOutput = trGetN.Dump;
	trOutput.WksName.strVal = strWksName;
	okutil_arg_copy(&strWksName);
	string strHint;
	strHint.Format(STR_ACTUAL_WORKSHEET_NAME_FORMAT, strWksName);
	trOutput.hintActiveWksName.SetAttribute(STR_LABEL_ATTRIB, strHint);

	return 0;
}
///end VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
static int _config_tool_getnbox_event(TreeNode& trGetN, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	if ( nEvent > 0 )
	{
		if ( nEvent & GETNEVENT_UPDATE_GUI_TREE )
			nEvent = GETNE_ON_VALUE_CHANGE;
	}
	if (GETNE_ON_INIT == nEvent)
	{
		//dwEnables &= ~GETNGEVT_APPLY_ENABLE;
	}
	if ( GETNE_ON_VALUE_CHANGE == nEvent || GETNE_ON_INIT == nEvent || GETNE_ON_THEME == nEvent )
	{
		if ( GETNE_ON_VALUE_CHANGE == nEvent && trGetN.Dump.WksName.strVal.IsEmpty() )
		{
			dwEnables &= ~GETNGEVT_OK_ENABLE;
			strErrMsg = IDS_INVALID_DUMP_WKS_NAME;
			return 0;
		}
		///Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
		if ( GETNE_ON_THEME == nEvent )
		{
			string strNewTheme;
			if ( trGetN.GetAttribute(STR_THEME_FILE_ATTRIB, strNewTheme) && strNewTheme.IsEmpty() ) //default theme
			{
				_load_default_settings(trGetN);
			}
		}
		///end VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT


		///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
		//if ( LTT_CUSTOM == trGetN.Label.TextType.nVal && trGetN.Label.CustomText.strVal.IsEmpty() )
		TreeNode trTable = trGetN.Table;
		trTable.XDispCustom.Show = trTable.XDisp.nVal == 21;
		trTable.YDispCustom.Show = trTable.YDisp.nVal == 21;
		TreeNode trLabels = trGetN.LabelsTags.Labels;
		TreeNode trTags = trGetN.LabelsTags.Tags;
		trLabels.CustomFormat.Show = LTT_CUSTOM == trLabels.Label.nVal;
		trTags.CustomFormat.Show =  LTT_CUSTOM == trTags.Tag.nVal + 1;
		if ( LTT_CUSTOM == trLabels.Label.nVal && trLabels.CustomFormat.strVal.IsEmpty() 
			|| LTT_CUSTOM == trTags.Tag.nVal - 1 && trTags.CustomFormat.strVal.IsEmpty()
			)
		///end NEW_OPTIONS_DIALOG
		{
			dwEnables &= ~GETNGEVT_OK_ENABLE;
			strErrMsg = IDS_INVALID_CUSTOM_LABEL_TEXT;
			return 0;
		}
		if ( GETNE_ON_VALUE_CHANGE == nEvent )
			dwEnables |= GETNGEVT_APPLY_ENABLE;
	}
	else if( GETNE_ON_APPLY == nEvent )
	{
		GraphVerticalCursorDlg* pDlg = NULL;
		TreeNode trDlgPtr = trGetN.GetNode(STR_NODE_TAG_NAME_DIALOG);
		if (!trDlgPtr)
			return 0;
		///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
		//DWORD dwDlgPtr = (DWORD)trDlgPtr.nVal;
		ODWP DlgPtr = (ODWP)trDlgPtr.oipVal;
		///end ///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
		pDlg = (GraphVerticalCursorDlg*)DlgPtr;
		if (pDlg)
		{
			BOOL bApplyOK = pDlg->ApplyToolSettings(trGetN);
			dwEnables &= ~GETNGEVT_APPLY_ENABLE;
		}
	}
	return 0;
}

BOOL GraphVerticalCursorDlg::OnConfigureOutput(Control ctrl)
{
	///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	//VManagerSetting managerSetting;
	//if( THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
	//{
		//Tree trSettingGUI;
		//if ( constructSettingGUITree(trSettingGUI, managerSetting) )
		//{
			//TreeNode tnConfig = trSettingGUI.trGUI;
	TreeNode	trGUI;
	if ( GetGUITree(trGUI) )
	{
		Tree trSettingGUI;
		trSettingGUI.AddNode(trGUI);
		TreeNode	tnConfig = trSettingGUI.FirstNode;
	///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR
			if (!tnConfig)
				return FALSE;
			///------ Folger 11/04/2011 ADD_F1_HELP_FOR_OC_DIALOGS
			tnConfig.SetAttribute(STR_HELPID_ATTRIB, IDD_VERTICAL_CURSOR_PREFERENCE);
			///------ End ADD_F1_HELP_FOR_OC_DIALOGS
			tree_set_branch_open_status_auto_save(tnConfig); /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG 
			int nRet = GetNBox(tnConfig, _config_tool_getnbox_event, _L("Preferences"), NULL, GetSafeHwnd(), true);
			if (nRet)
			{
				///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
				//BOOL bRet = ApplyToolSettings(tnConfig);
				BOOL bRet = SetGUITree(tnConfig);
				///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR
				return bRet;
			}
		//}		///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	}
	return TRUE;
}
///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
/////Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
//BOOL GraphVerticalCursorDlg::OnKeyEditWks(Control ctrl, UINT msg, UINT wParam, UINT lParam)
//{
	//if( msg != WM_KEYDOWN )
		//return FALSE;
	//
	//switch(wParam)
	//{
	//case VK_RETURN:
		//break;
	//default:
		//return FALSE;
	//}
	//
	//return TRUE;
//}
//BOOL GraphVerticalCursorDlg::OnUpdateEditWks(Control ctrl)
//{
	//Edit editWks = GetDlgItem(IDC_EDIT_RESULT_SHEET);
	//if(!editWks)
		//return FALSE;
	//
	//VManagerSetting		managerSetting;
	//THE_VCURSOR_MANAGER.GetSetting(managerSetting);
	//if(editWks.Text.Compare(managerSetting.m_strDumpWksName) != 0)
	//{
		//managerSetting.m_strDumpWksName = editWks.Text;
		//THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	//}		
	/////Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
	//Worksheet wks(editWks.Text);
	//enableActivateBtn( wks.IsValid() );
	/////End ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
	//return TRUE;
//}
///End MOVE_OUT_RESULT_SHEET_EDITBOX
///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
BOOL GraphVerticalCursorDlg::OnDumpData(Control ctrl)
{
	///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
	//bool bRet;
	//if ( m_BottomTab.GetCurSel() == TAG_INFO_TAB )
	//	bRet = THE_VCURSOR_MANAGER.DumpTagValues();//DumpData();
	//else
	//	bRet = THE_VCURSOR_MANAGER.DumpCursorValues();
	//
	//if(bRet)
	//	enableActivateBtn(true);		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS
	//
	//return bRet;
	return DumpData();
	///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR
}
///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
BOOL GraphVerticalCursorDlg::OnActivateOutputWks(Control ctrl)
{
	return THE_VCURSOR_MANAGER.ActivateOutputWks();
}
void GraphVerticalCursorDlg::enableActivateBtn(bool bEnable)
{
	Control ctrl = GetDlgItem(IDC_BTN_ACTIVATE_WKS);
	if(ctrl)
		ctrl.Enable = bEnable;
}
///End 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	
///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
void GraphVerticalCursorDlg::updateSnapCheckBoxes(const VManagerSetting& managerSetting)
{
	Button chkSnapNearestX = GetDlgItem(IDC_SNAP_NEAREST_X);
	if(chkSnapNearestX)
		chkSnapNearestX.Check = managerSetting.m_bSnapToNearestX;
	
	//if snap to checkbox column shows, here should also update it
}
///End REMEMBER_SNAP_OPTION

///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifndef REMOVE_TAG_FEATURE
//BOOL GraphVerticalCursorDlg::OnShowBottomPane(Control cntrl)
//{
	//MultiPaneDlg::OnShowBottomPane(cntrl);
	//AllowResizing(IsBottomPaneShown());
	//OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	//return TRUE;
//}
//#endif//REMOVE_TAG_FEATURE
BOOL GraphVerticalCursorDlg::OnShowBottomPane(Control cntrl)
{
	MultiPaneDlg::OnShowBottomPane(cntrl);
	
	AllowResizing(IsBottomPaneShown());		
	
	RECT rBtn, rTab, rWin;
	GetControlClientRect(IDC_BTN_DOWNUP, rBtn);
	GetControlClientRect(IDC_BOTTOM_INFO_TAB, rTab);
	m_wndDlg.GetWindowRect(&rWin);
	
	int nHeight = 0;
	if ( IsBottomPaneShown() )
	{
		m_wndDlg.ClientToScreen(&rTab);
		rWin.bottom = rTab.bottom + GetControlGap() * 1.5;
	}
	else
	{
		SetInitReady(false);
		int nBottom = rBtn.bottom + GetControlGap();
		if(nBottom > rTab.top)
			nBottom = rTab.top;
		
		RECT rCheck, rTemp;
		GetControlClientRect(IDC_SNAP_NEAREST_X, rCheck);
		if(nBottom > rCheck.top)
			nBottom = rCheck.top;
		
		rTemp.bottom = nBottom;
		m_wndDlg.ClientToScreen(&rTemp);
		rWin.bottom = rTemp.bottom;
	}
	
	m_wndDlg.MoveWindow(&rWin);	
	SetInitReady(true);
	return TRUE;
}
///HIDE_VCURSOR_TO_A_SIMPLER_DB

///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
/////Jasmine 03/15/2012 ORG-4971 LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
//enum{
	//ID_VERTICAL_CURSOR_MENU_LINK_GRAPHS 		= 0x0001,
	//ID_VERTICAL_CURSOR_MENU_UNLINK_GRAPHS,
//};
//BOOL GraphVerticalCursorDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
//{
	//if( !THE_VCURSOR_MANAGER.CanLinkGraph() )	
		//return TRUE;
	//
	//Menu myMenu;
	//myMenu.Add(_L("Link Cursor to Other Graphs..."), 		ID_VERTICAL_CURSOR_MENU_LINK_GRAPHS);
	//myMenu.Add(_L("Unlink Cursor from Linked Graphs..."), 	ID_VERTICAL_CURSOR_MENU_UNLINK_GRAPHS, THE_VCURSOR_MANAGER.HasLinkedGraphs()? MF_ENABLED : MF_DISABLED|MF_GRAYED);
	//
	//int		nCmd = 0;
	//myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd(), &nCmd);
	//
	//switch(nCmd)
	//{
	//case ID_VERTICAL_CURSOR_MENU_LINK_GRAPHS:
	//case ID_VERTICAL_CURSOR_MENU_UNLINK_GRAPHS:
		//{
			//string	strGraphs;
			//DWORD 	dwOption 	= SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED | SORT_PAGE | FILTER_3D_GRAPH;
			//bool	bRet 		= open_page_preview_list_dlg(	GetSafeHwnd(), strGraphs, NULL, dwOption, EXIST_GRAPH, 
																//(ID_VERTICAL_CURSOR_MENU_UNLINK_GRAPHS == nCmd)? "filter_unlink_graphs" : "filter_unavailable_link_graphs");
			//if(bRet)
			//{
				//if(		ID_VERTICAL_CURSOR_MENU_LINK_GRAPHS 	== nCmd)
					//bRet = THE_VCURSOR_MANAGER.LinkGraphs(strGraphs);
				//else if(ID_VERTICAL_CURSOR_MENU_UNLINK_GRAPHS 	== nCmd)
					//bRet = THE_VCURSOR_MANAGER.UnlinkGraphs(strGraphs);
			//}
			//
			//if(bRet)
				//UpdateDialogData();
		//}
		//break;
		//
	//default:
		//break;
	//}
	//
	//return TRUE;
//}
/////End LINK_CURRENT_GADGET_TO_OTHER_GRAPHS
void GraphVerticalCursorDlg::enableLinkGraphBtn(bool bEnable)
{
	Control ctrl = GetDlgItem(IDC_BTN_LINK_GRAPH);
	if(ctrl)
		ctrl.Enable = bEnable;
}

BOOL GraphVerticalCursorDlg::OnClickLinkGraph(Control ctrl)
{
	vector<string>	vsOlds;
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL != pHolder && pHolder->m_line.GetValidObj() )
	{
		vector<OUID> 	vnGraphUIDs;
		int nSize = pHolder->GetLinkedGraphs(&vnGraphUIDs);
		for(int ii = 0; ii < nSize; ii++)
		{
			GraphPage gpLinked;
			gpLinked = (GraphPage)Project.GetObject( vnGraphUIDs[ii] );
			if(gpLinked)vsOlds.Add( gpLinked.GetName() );
		}
	}
	
	string	strGraphs;
	strGraphs.SetTokens(vsOlds, STR_PAGE_LIST_SEPARATOR);	
	DWORD 	dwOption 	= SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED | SORT_PAGE | FILTER_3D_GRAPH | CAN_REMOVE_ALL;	///Jasmine 05/11/2012 ORG-4971-S2 ALLOW_REMOVE_ALL_LINKED_GRAPHS
	bool	bRet 		= open_page_preview_list_dlg( GetSafeHwnd(), strGraphs, NULL, dwOption, EXIST_GRAPH, "filter_unavailable_link_graphs");
	if(bRet)
	{
		bool			bLink = false, bUnlink = false;
		string 			strLinks, strUnlinks;
		vector<string>	vsNews, vsLinks, vsUnlinks;
		strGraphs.GetTokens(vsNews, STR_PAGE_LIST_SEPARATOR);	
		
		vsLinks = vsNews;
		if( 0 < remove_if_in_list(vsLinks, vsOlds) )
		{
			strLinks.SetTokens(vsLinks, STR_PAGE_LIST_SEPARATOR);	
			bLink = THE_VCURSOR_MANAGER.LinkGraphs(strLinks);
			ASSERT(bLink);
		}
		
		vsUnlinks = vsOlds;
		if( 0 < remove_if_in_list(vsUnlinks, vsNews) )
		{
			strUnlinks.SetTokens(vsUnlinks, STR_PAGE_LIST_SEPARATOR);	
			bUnlink = THE_VCURSOR_MANAGER.UnlinkGraphs(strUnlinks);
			ASSERT(bUnlink);
		}
		
		if(bLink || bUnlink)
			UpdateDialogData(false, false);//UpdateDialogData();///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
	}
	
	return TRUE;
}
///End BTN_FOR_LINK_GRAPH

BOOL GraphVerticalCursorDlg::OnBeforeMouseDownInfoList( Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel )
{
	if(MK_RBUTTON == nButton)
	{
#ifndef REMOVE_TAG_FEATURE
		if ( m_BottomTab.GetCurSel() == TAG_INFO_TAB )
			m_TagInfoTable.OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
		else
#endif//REMOVE_TAG_FEATURE
		{
			m_CursorDataInfoTable.OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
			checkUpdateShowCursorInfos();		///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
		}
		return TRUE;
	}
	if(pCancel)
		*pCancel = FALSE;
	return FALSE;
}

void GraphVerticalCursorDlg::OnBeforeEditInfoList( Control flxControl, long nRow, long nCol, BOOL* pCancel )
{
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	if ( TEXTLABELINFOGRIDCOLTYPE_SNAPTO == m_CursorDataInfoTable.GetColType(nCol) )
	{
		if (pCancel)
		{
			Button	btn = GetItem(IDC_SNAP_NEAREST_X);
			*pCancel = btn.Check;
		}
		return;
	}
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG

	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	if ( TEXTLABELINFOGRIDCOLTYPE_STATUS == m_CursorDataInfoTable.GetColType(nCol) )
	{
		return;
	}
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	if (pCancel)
		*pCancel = TRUE;
}

///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
void GraphVerticalCursorDlg::OnAfterEditInfoList(Control flxControl, int nRow, int nCol)
{
	int		nColType = m_CursorDataInfoTable.GetColType(nCol);
	if ( TEXTLABELINFOGRIDCOLTYPE_SNAPTO == nColType )
	{		
		string	str = m_CursorDataInfoTable.GetCell(nRow, nCol);

		vector<string>		vs(m_CursorDataInfoTable.GetNumRows());
		m_CursorDataInfoTable.SetCells(vs, nCol);
		m_CursorDataInfoTable.SetCell(nRow, nCol, str);

		VManagerSetting		managerSetting;
		THE_VCURSOR_MANAGER.GetSetting(managerSetting);
				
		if ( atoi(str) )
		{
			DataPlot		dp;
			dp = (DataPlot)Project.GetObject(atoi(m_CursorDataInfoTable.GetCell(nRow, m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_ID))));
			if ( dp )
			{
				_get_plot_legend_and_description(dp, NULL, &managerSetting.m_strSnappedPlot);
			}
		}
		else
		{
			managerSetting.m_strSnappedPlot.Empty();
		}

		THE_VCURSOR_MANAGER.SetSetting(managerSetting);
		return;
	}
	
	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	if ( TEXTLABELINFOGRIDCOLTYPE_STATUS == nColType )
	{
		OnToggleOnePlotShow(nRow);
		return;
	}
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	ASSERT(FALSE);
}

///------ Folger 08/03/2012 ORG-6409-S1 VERTICAL_CURSOR_USAGE_IMPROVEMENT
void GraphVerticalCursorDlg::OnDBClickInfoList(Control ctrl)
{
	int nRow, nCol;
	m_CursorDataInfoTable.GetMouseCell(nRow, nCol);

	int nRowOffset = m_CursorDataInfoTable.GetRowOffset();
	if ( nRow < nRowOffset )
		return;

	vector<int> vnIndeces;	
	THE_VCURSOR_MANAGER.GetCursorDisplayOrder(vnIndeces, 0);
	VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(vnIndeces[nRow - nRowOffset]);
	if ( NULL == pti )
	{
		ASSERT(FALSE);
		return;
	}

	GraphPage gp(pti->plotinfo.graph);
	if ( gp )
		gp.CheckShowActivate();
}

BOOL GraphVerticalCursorDlg::OnChangeActivePlot()
{
	int		nSize = THE_VCURSOR_MANAGER.GetPointsCount();
	if ( nSize <= 0 )
		return TRUE;

	vector<int> vnIndeces;	
	THE_VCURSOR_MANAGER.GetCursorDisplayOrder(vnIndeces, 0);
	ASSERT(nSize == vnIndeces.GetSize());
	
	Layer lay = Project.ActiveLayer();
	
	vector<string> vsVals(nSize);
	for ( int ii=0; ii<nSize; ++ii )
	{
		VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(vnIndeces[ii]);
		DataPlot dp;
		dp = Project.GetObject(pti->plotuid);
		if ( !dp )
			continue;
		
		GraphLayer gl;
		dp.GetParent(gl);
		
		pti->bActive = is_same_layer(gl, lay) && dp.GetIndex() == gl.DataPlots().GetIndex();
		
		_get_graph_cell_string(vsVals[ii], pti);
	}

	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	m_CursorDataInfoTable.SetCells(vsVals, nColPos);
	return TRUE;
}
///------ End VERTICAL_CURSOR_USAGE_IMPROVEMENT

BOOL GraphVerticalCursorDlg::OnCheckUseNearestX(Control cntrl)
{
	VManagerSetting		managerSetting;
	THE_VCURSOR_MANAGER.GetSetting(managerSetting);
	Button				btn = cntrl;
	managerSetting.m_bSnapToNearestX = btn.Check;
	//---Jasmine 02/08/10 when uncheck, turn off snap
	if(!managerSetting.m_bSnapToNearestX)
		managerSetting.m_strSnappedPlot = "";
	//---
	THE_VCURSOR_MANAGER.SetSetting(managerSetting);	

	return TRUE;
}
///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG

///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
void GraphVerticalCursorDlg::OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition)
{
	m_CursorDataInfoTable.OnAfterMoveColumns(lCol, pnPosition);	
	
	///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	vector<int> vnColMap;
	m_CursorDataInfoTable.GetColumnOrder(vnColMap);
	
	VManagerSetting managerSetting;
	BOOL bRet = THE_VCURSOR_MANAGER.GetSetting(managerSetting);
	if(bRet)
	{
		managerSetting.m_cursorshow.vnColMap = vnColMap;
		bRet = THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	}
	ASSERT(bRet);
	///End KEEP_COL_ORDER_IN_PAGE
}
///End MORE_CONFIGURATION_FOR_INFO_TABLE
///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER 
void GraphVerticalCursorDlg::OnAfterSort(Control ctrl, long lCol, int* pnOrder)
{
	updatePointsIDs(0);
}
///End UPDATE_LIST_WITH_SORT_ORDER
void GraphVerticalCursorDlg::AllowResizing( BOOL bResizing /*= TRUE*/ )
{
	int nStyleCurrent = GetWindowLong(Window::GetSafeHwnd(), GWL_STYLE);
	if(bResizing)
	{
		nStyleCurrent |= WS_THICKFRAME;
	}
	else
	{
		nStyleCurrent &= (~WS_THICKFRAME);
	}
	SetWindowLong(Window::GetSafeHwnd(), GWL_STYLE, nStyleCurrent);
	UpdateWindow(TRUE);
}
	
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
BOOL GraphVerticalCursorDlg::OnDumpLabelS(Control ctrl)
{	
	return THE_VCURSOR_MANAGER.DumpTextLabels();
}	
#endif//REMOVE_TAG_FEATURE
///End DUMP_LABEL_AND_LINE_ON_GRAPH
/*----------------------------------------------------------------------------*/
/* Protected functions(interfaces) of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/
void GraphVerticalCursorDlg::initButtons()
{
	GetItem(IDC_STATIC_TIPS_X).SetToolTip(_L("Change X Based Layer"));		///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	
	vector<int> 	vnBtnIDs = {
		 IDC_CHECK_USE_X
		 
#ifndef REMOVE_TAG_FEATURE
		,IDC_BTN_ADD_TAG
		,IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS
		,IDC_BTN_CLEAR_ALL_TAGS
		,IDC_BTN_NEXT_TAG
		,IDC_BTN_PREVIOUS_TAG
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#else
		,IDC_BTN_DUMP_LABEL
///End DUMP_LABEL_AND_LINE_ON_GRAPH
#endif//REMOVE_TAG_FEATURE

#ifndef REMOVE_LABEL_FEATURE
		,IDC_BTN_INCREASE_FONT
		,IDC_BTN_DECREASE_FONT
#endif//REMOVE_LABEL_FEATURE

		,IDC_BTN_CONFIG_OUTPUT
		,IDC_BTN_DUMP_TAG_INTO_WKS
		,IDC_BTN_ACTIVATE_WKS		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS
		,IDC_BTN_LINK_GRAPH			///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	};
	
	vector<int> 	vnBitmaps = {
		 IDB_APPLY_BTN
		 
#ifndef REMOVE_TAG_FEATURE
		,IDB_TOGGLE_TAG
		,IDB_REMOVE_SELECTED_TAGS_GROUPS
		,IDB_REMOVE_ALL_TAGS
		,IDB_NEXT_TAG
		,IDB_PREVIOUS_TAG
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#else
		,IDB_SET_LABEL
///End DUMP_LABEL_AND_LINE_ON_GRAPH
#endif//REMOVE_TAG_FEATURE

#ifndef REMOVE_LABEL_FEATURE
		,IDB_INCREASE_FONT
		,IDB_DECREASE_FONT
#endif//REMOVE_LABEL_FEATURE

		,IDB_ADJUST_SCALE//,IDB_PF_ADV		///Jasmine 06/17/2011 ORG-3106-P1 MAKE_VERTICAL_CURSOR_GUI_CONSISTENT_WITH_OTHER_GADGET_LIKE_CLUSTER
		,IDB_DUMP_DATA_INTO_WKS
		,IDB_GOTO_DATA//,IDB_ACTIVATE_WKS	///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS	///Jasmine 06/17/2011 ORG-3106-P1 MAKE_VERTICAL_CURSOR_GUI_CONSISTENT_WITH_OTHER_GADGET_LIKE_CLUSTER
		,IDB_LINK_GRAPH						///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	};
	
	vector<string> 	vsBtnTips;
	vsBtnTips.SetSize( vnBtnIDs.GetSize() );
	int nn = 0;
	vsBtnTips[nn++] = _L("Move Cursor to X");		  
#ifndef REMOVE_TAG_FEATURE
	vsBtnTips[nn++] = _L("Add Tags");
	vsBtnTips[nn++] = _L("Clear Selected Tags Groups");
	vsBtnTips[nn++] = _L("Clear All Tags");
	vsBtnTips[nn++] = _L("Select Next Tags Group");
	vsBtnTips[nn++] = _L("Select Previous Tags Group");
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#else
	vsBtnTips[nn++] = _L("Add Tag and Label");
///End DUMP_LABEL_AND_LINE_ON_GRAPH
#endif//REMOVE_TAG_FEATURE

#ifndef REMOVE_LABEL_FEATURE
	vsBtnTips[nn++] = _L("Increase Font Size");
	vsBtnTips[nn++] = _L("Decrease Font Size");
#endif//REMOVE_LABEL_FEATURE
	vsBtnTips[nn++] = _L("Options");//_L("Preferences");	///Jasmine 06/17/2011 ORG-3106-P1 MAKE_VERTICAL_CURSOR_GUI_CONSISTENT_WITH_OTHER_GADGET_LIKE_CLUSTER
	vsBtnTips[nn++] = _L("Output Report");
	vsBtnTips[nn++] = _L("Go to Report Worksheet");//_L("Go to Report");///Jasmine 06/17/2011 ORG-3106-P1 MAKE_VERTICAL_CURSOR_GUI_CONSISTENT_WITH_OTHER_GADGET_LIKE_CLUSTER
	vsBtnTips[nn++] = _L("Link/Unlink Graphs");///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	
	const int nIDSize = vnBtnIDs.GetSize();
	const int nBtnTipsSize = vsBtnTips.GetSize();
	const int nBitMapSize = vnBitmaps.GetSize();
	ASSERT(nBitMapSize == nIDSize && nBtnTipsSize == nIDSize);
	
	for(int ii = 0; ii < nIDSize; ii++)
	{
		BitmapRadioButton btn = GetItem( vnBtnIDs[ii] );
		vector<string> vsTips(1);
		vsTips[0] = ii < nBtnTipsSize ? vsBtnTips[ii] : "";
		btn.Init(1, ii < nBitMapSize ? vnBitmaps[ii] : 0, 16, vsTips);
	}
#ifndef REMOVE_LABEL_FEATURE
	BitmapRadioButton btnShowHideLabels = GetItem(IDC_BTN_SHOW_LABEL);
	vector<string> vsTips(2);
	vsTips[0] = _L("Show Label");
	vsTips[1] = _L("Hide Label");
	btnShowHideLabels.Init(2, IDB_SHOW_LABEL, 16, vsTips);
	btnShowHideLabels.Check = 1;
#else
	vector<int> 	vnHideLabelBtnIDs = {
		IDC_BTN_SHOW_LABEL
		,IDC_BTN_INCREASE_FONT
		,IDC_BTN_DECREASE_FONT
	}
	for(ii = 0; ii < vnHideLabelBtnIDs.GetSize(); ii++)
	{
		Control btn = GetItem( vnHideLabelBtnIDs[ii] );
		if(btn)
			btn.Visible = false;
	}
#endif//REMOVE_LABEL_FEATURE
	
#ifdef REMOVE_TAG_FEATURE
	vector<int> 	vnHideIDs = {
		IDC_BTN_ADD_TAG
		,IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS
		,IDC_BTN_CLEAR_ALL_TAGS
		,IDC_BTN_NEXT_TAG
		,IDC_BTN_PREVIOUS_TAG
	}
	for(ii = 0; ii < vnHideIDs.GetSize(); ii++)
	{
		Control btn = GetItem( vnHideIDs[ii] );
		if(btn)
			btn.Visible = false;
	}
	///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
	Control btn = GetItem(IDC_BTN_DUMP_LABEL);
	if(btn)
		btn.Visible = true;
	///End DUMP_LABEL_AND_LINE_ON_GRAPH
#endif//REMOVE_TAG_FEATURE
}

/*----------------------------------------------------------------------------*/
/* Public functions(interfaces) of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/

BOOL GraphVerticalCursorDlg::Create(HWND hWndParent /*= NULL*/)
{
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
//#ifdef REMOVE_TAG_FEATURE
	//BOOL bRet = ResizeDialog::Create(hWndParent, dwDlgOptions);
//#else
	//BOOL bRet = MultiPaneDlg::Create(hWndParent, dwDlgOptions);
//#endif
	BOOL bRet = MultiPaneDlg::Create(hWndParent, dwDlgOptions);
	///End HIDE_VCURSOR_TO_A_SIMPLER_DB
	Visible = true;
	return bRet;
}

void GraphVerticalCursorDlg::UpdateDialogData(bool bUupdateColOrder/* = false*/, bool bUpdateCursorPos/* = true*/)//void GraphVerticalCursorDlg::UpdateDialogData(bool bUupdateColOrder/* = false*/)	///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
{
	VManagerSetting managerSetting;
	if( THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	
	//updateCursorPos();	///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
#ifndef REMOVE_LABEL_FEATURE
	updateShowHideLabelsBtnState();
#endif

	updateRemoveSelTagsGrpsBtnState();
	
#ifndef REMOVE_TAG_FEATURE
	BOOL bEnableBtn = THE_VCURSOR_MANAGER.GetNumTags() > 0;
	updateTagRelatedBtnState(bEnableBtn);

	updateTagsInfo();
#endif//REMOVE_TAG_FEATURE

	///Jasmine 07/18/2011 ORG-3106-S3-4 KEEP_COL_ORDER_IN_PAGE
	m_CursorDataInfoTable.SetColumnOrder(managerSetting.m_cursorshow.vnColMap);
	///End KEEP_COL_ORDER_IN_PAGE
	
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	m_CursorDataInfoTable.SetRowOrderAndShow(managerSetting.m_cursorshow.vsPlotIDs, managerSetting.m_cursorshow.vnPlotShow);
	///End MENU_TO_HIDE_PLOT_FROM_DLG
	
	showCursorInfos(managerSetting.m_cursorshow);	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	updateCursorDataInfo(bUpdateCursorPos);//updateCursorDataInfo();	///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK

	//---report controls
	showReportSheetName(managerSetting);	///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
	//---
	
	updateSnapCheckBoxes(managerSetting);///Jasmine 02/08/10 REMEMBER_SNAP_OPTION
	
	enableLinkGraphBtn( THE_VCURSOR_MANAGER.CanLinkGraph() );		///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
	enableXBasedLayerBtn();		///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
	
	Visible = TRUE;
}

BOOL GraphVerticalCursorDlg::ApplyToolSettings( const TreeNode& tnSettings )
{
	VManagerSetting managerSetting;
	THE_VCURSOR_MANAGER.GetSetting(managerSetting);
	///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
	//managerSetting.m_bSnapLineToData 		= tnSettings.Misc.SnapLine.nVal;
	TreeNode trSnapLine = tnSettings.Misc.SnapLine;
	string strSnappedPlot;
	if( trSnapLine && trSnapLine.nVal )
	{
		int nIndex = trSnapLine.nVal;
		string strPlots;
		trSnapLine.GetAttribute(PlotListAttr(), strPlots);

		vector<string> vsPlots;
		strPlots.GetTokens(vsPlots, '|');
		if(nIndex > 0 && nIndex < vsPlots.GetSize() )
			strSnappedPlot = vsPlots[nIndex];
	}
	
	///Sophy 9/6/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	string strThemeFileName;
	if ( tnSettings && tnSettings.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFileName) )
		managerSetting.m_strThemeFileName = strThemeFileName;
	///end VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	managerSetting.m_strSnappedPlot 		= strSnappedPlot;
	///End SNAP_CURSOR_TO_DATA_PLOT
	managerSetting.m_strDumpWksName 		= tnSettings.Dump.WksName.strVal;
	///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
	//managerSetting.m_labelSetting.nSignificantDigits = 	tnSettings.Label.SD.nVal;
	//managerSetting.m_labelSetting.nTextType = tnSettings.Label.TextType.nVal;
	//managerSetting.m_labelSetting.strLTCustomTextType = tnSettings.Label.CustomText.strVal;
	managerSetting.m_labelSetting.nTextType = tnSettings.LabelsTags.Labels.Label.nVal;
	managerSetting.m_labelSetting.strLTCustomTextType = tnSettings.LabelsTags.Labels.CustomFormat.strVal;
	///end NEW_OPTIONS_DIALOG
	///Sophy 8/18/2011 ORG-3106-S10 NEW_OPTIONS_DIALOG
	managerSetting.m_tagSetting.nTextType = tnSettings.LabelsTags.Tags.Tag.nVal;
	managerSetting.m_tagSetting.strLTCustomTextType = tnSettings.LabelsTags.Tags.CustomFormat.strVal;
	managerSetting.m_tagSetting.nLocation = tnSettings.LabelsTags.Tags.Location.nVal;
	///end NEW_OPTIONS_DIALOG

	///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	if ( managerSetting.m_nLineLength != tnSettings.LabelsTags.LineLength.nVal )
	{
		THE_VCURSOR_MANAGER.ToggleLineLength(TRUE);
		managerSetting.m_nLineLength = tnSettings.LabelsTags.LineLength.nVal;
	}
	///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS

	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	managerSetting.m_cursorshow.BookName 	= tnSettings.Table.CursorShow.BookName.nVal;
	managerSetting.m_cursorshow.SheetName 	= tnSettings.Table.CursorShow.SheetName.nVal;
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//managerSetting.m_cursorshow.ShortName 	= tnSettings.CursorShow.ShortName.nVal;
	//managerSetting.m_cursorshow.LongName 	= tnSettings.CursorShow.LongName.nVal;
	managerSetting.m_cursorshow.Name 	= tnSettings.Table.CursorShow.Name.nVal;
	///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	managerSetting.m_cursorshow.CursorX 	= tnSettings.Table.CursorShow.CursorX.nVal;
	managerSetting.m_cursorshow.CursorY 	= tnSettings.Table.CursorShow.CursorY.nVal;
	///Jasmine 01/20/10 SHOW_NEAREST_POINT 			
	managerSetting.m_cursorshow.CursorNearX = tnSettings.Table.CursorShow.CursorNearX.nVal;
	managerSetting.m_cursorshow.CursorNearY = tnSettings.Table.CursorShow.CursorNearY.nVal;
	///End SHOW_NEAREST_POINT
	managerSetting.m_cursorshow.Index 		= tnSettings.Table.CursorShow.Index.nVal;
	managerSetting.m_cursorshow.GraphName	= tnSettings.Table.CursorShow.GraphName.nVal;		///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	managerSetting.m_cursorshow.Status		= tnSettings.Table.CursorShow.Status.nVal;			///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
	///Jasmine 08/20/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS 
	managerSetting.m_cursorshow.strXDisp = _cvt_auto_format_display_str(tnSettings.Table.XDisp.strVal, false, true);//tnSettings.Table.XDisp.strVal
	managerSetting.m_cursorshow.strYDisp = _cvt_auto_format_display_str(tnSettings.Table.YDisp.strVal, false, false);//tnSettings.Table.YDisp.strVal
	///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
	///end NEW_OPTIONS_DIALOG
	managerSetting.m_cursorshow.bModifiedOutside = false;	///Sophy 9/19/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
	showCursorInfos(managerSetting.m_cursorshow);
	///End CONFIGURE_SHOW_HIDE_SETTING

	BOOL bRet = THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	//updateCursorPos();///Jasmine 09/10/2012 ORG-6764-P1 UNNECESSERY_UPDATE_REWRITE_USER_INPUT_XVALUE
#ifndef REMOVE_TAG_FEATURE
	updateTagsInfo();
#endif//REMOVE_TAG_FEATURE
	updateCursorDataInfo();
	showReportSheetName(managerSetting);///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
	return bRet;
}

///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
//bool	GraphVerticalCursorDlg::ConstrucPlotsMenu(Menu& cellMenu)
//{
	//VManagerSetting managerSetting;
	//if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		//return false;
	//
	//int nSize = THE_VCURSOR_MANAGER.GetPointsCount();
	//if(nSize <= 0)
		//return false;
	//
	//vector<string> 	vsPlotIDs;
	//vsPlotIDs 	= managerSetting.m_cursorshow.vsPlotIDs;
	//vector<int> 	vnShow;
	//vnShow 		= managerSetting.m_cursorshow.vnPlotShow;
	//int nCount = vnShow.GetSize();
	//
	//cellMenu.Add(NULL, 0, MF_SEPARATOR); 
//
	//for(int ii = 0; ii < nSize; ii++)
	//{
		//DWORD dwFlag = MF_STRING;
		//
		//VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(ii/*vnIndeces[ii]*/);
		//if ( NULL == pti )
		//{
			//ASSERT(FALSE);
			//break
		//}
		//
		//int nFind = vsPlotIDs.Find( (string)pti->plotuid );//plot is hidden in layer
		//if(nFind < 0 || nFind >= nCount)
		//{
			//ASSERT(FALSE);
			//continue;		
		//}
	//
		//dwFlag |= vnShow[nFind]? MF_CHECKED : MF_UNCHECKED;
		//
		//int nn = ii + 1;
		/////Sophy 9/20/2011 ORG-3497-S1 BETTER_LABEL_FOR_VERTICALCURSOR_PLOT_SELECTION
		////string strName = pti->plotinfo.colname;//temp
		//string strName = pti->plotinfo.collongname;;
		//if ( strName.IsEmpty() )
			//strName = pti->plotinfo.colname;
		/////end BETTER_LABEL_FOR_VERTICALCURSOR_PLOT_SELECTION
		//string strLabel;
		/////Sophy 8/15/2011 ORG-3497-P1 GADGET_CONTEXT_MENU_FAIL_TO_SHOW_PLOT_NAME_IF_CONTAINS_TAB
		////strLabel.Format("Plot(%d)\t%s", nn, strName);
		//strLabel.Format("Plot(%d)    %s", nn, strName);
		/////end GADGET_CONTEXT_MENU_FAIL_TO_SHOW_PLOT_NAME_IF_CONTAINS_TAB
			//
		//int nCmd = nn + VCURSOR_MENU_PLOT_BEGIN;
		//cellMenu.Add(strLabel, nCmd, dwFlag);
	//}
	//
	//return true;
//}	
///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT	

void	GraphVerticalCursorDlg::OnToggleOnePlotShow(int nCmd)
{
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
	
	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	//int nn = nCmd - VCURSOR_MENU_PLOT_BEGIN;
	//int ii = nn - 1;
	//VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(ii/*vnIndeces[ii]*/);//bug
	//if ( NULL == pti )
	//{
		//ASSERT(FALSE);
		//return;
	//}
	int nRow= nCmd;
	int ii 	= nRow - m_CursorDataInfoTable.GetRowOffset();
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	vector<string> 	vsPlotIDs;
	vsPlotIDs 	= managerSetting.m_cursorshow.vsPlotIDs;
	vector<int> 	vnShow;
	vnShow 		= managerSetting.m_cursorshow.vnPlotShow;
	int nCount = vnShow.GetSize();
	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	//int nFind = vsPlotIDs.Find( (string)pti->plotuid );//plot is hidden in layer
	//if(nFind < 0 || nFind >= nCount)
	//{
		//ASSERT(FALSE);
		//return;		
	//}	
	//
	//vnShow[nFind] = !vnShow[nFind];
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_STATUS);
	vnShow[ii] = atoi(m_CursorDataInfoTable.GetCell(nRow, nColPos));
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	managerSetting.m_cursorshow.vnPlotShow = vnShow;
	THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	
	vector<int> vnChangePlot(1);
	vnChangePlot[0] = ii;
	showHidePlots(vnChangePlot);
}	

//#include <Profiler.h>
void	GraphVerticalCursorDlg::OnIncludeSelectedPlots(bool bInclude)//void 	GraphVerticalCursorDlg::OnOpenSelectPlotsDlg()	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
{
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
		
	int nSize = THE_VCURSOR_MANAGER.GetPointsCount();
	if(nSize <= 0)
		return;
	
	vector<string> 	vsPlotIDs;
	vsPlotIDs 	= managerSetting.m_cursorshow.vsPlotIDs;
	vector<int> 	vnShow;
	vnShow 		= managerSetting.m_cursorshow.vnPlotShow;
	int nCount = vnShow.GetSize();
	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	//GETN_TREE(trUser);
	//GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	//GETN_BEGIN_BRANCH(DataPlots, _L("Plots")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN | GETNBRANCH_CHECK_CONTROL)
	//
	//for(int ii = 0; ii < nSize; ii++)
	//{
		//VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(ii/*vnIndeces[ii]*/);
		//if ( NULL == pti )
		//{
			//ASSERT(FALSE);
			//break
		//}
		//
		//int nFind = vsPlotIDs.Find( (string)pti->plotuid );//plot is hidden in layer
		//if(nFind < 0 || nFind >= nCount)
		//{
			//ASSERT(FALSE);
			//continue;		
		//}
		//int nn = ii+1;
		/////Sophy 9/20/2011 ORG-3497-S1 BETTER_LABEL_FOR_VERTICALCURSOR_PLOT_SELECTION
		////string strName = pti->plotinfo.colname;//temp
		//string strName = pti->plotinfo.collongname;;
		//if ( strName.IsEmpty() )
			//strName = pti->plotinfo.colname;
		/////end BETTER_LABEL_FOR_VERTICALCURSOR_PLOT_SELECTION
		//string strLabel;
		//strLabel.Format("Plot(%d)    %s", nn, strName);
		//GETN_CHECK(Plot, strLabel, vnShow[nFind])
		//GETN_CURRENT_SUBNODE.DataID = nFind;
	//}
	//
	//GETN_END_BRANCH(DataPlots)	
	//if ( !GetNBox(trUser, _L("Select Plots")) )
		//return;
	//
	//vector<int> vnChangePlot;
	//foreach(TreeNode trNode in trUser.DataPlots.Children)
	//{
		//int nn = trNode.DataID;
		//if(nn >= nCount || vnShow[nn] == trNode.nVal)
			//continue;	
		//
		//vnShow[nn] = trNode.nVal;
		//vnChangePlot.Add(nn);
	//Profiler myTimer;	

	vector<uint> 	vnRows, vnPlot, vnDiff;
	vector<int>		vnChangePlot, vnSelRowShow;
	vector<string>	vsPlotShow, vsSelRowShow;
	
	m_CursorDataInfoTable.GetSelRows(vnRows);
	vnPlot = vnRows - m_CursorDataInfoTable.GetRowOffset();
	
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_STATUS);
	m_CursorDataInfoTable.GetColValues(nColPos, vsPlotShow, m_CursorDataInfoTable.GetRowOffset() );
	vsPlotShow.GetSubVector(vsSelRowShow, vnPlot);	
	convert_string_vector_to_int_vector(vsSelRowShow, vnSelRowShow);
	
	int nFind = vnSelRowShow.Find(vnDiff, bInclude? 0 : 1);
	if(nFind < 1)
		return;	
		
	int nInclude = bInclude? 1 : 0;
	for(int ii = 0; ii < nFind; ii++)
	{
		int nn = vnDiff[ii];
		vnShow[ vnPlot[nn] ] = nInclude;
		m_CursorDataInfoTable.SetCell(vnRows[nn], nColPos, nInclude);
	///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	}
	
	managerSetting.m_cursorshow.vnPlotShow = vnShow;
	THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	
	vnPlot.GetSubVector(vnChangePlot, vnDiff);	
	showHidePlots(vnChangePlot);
}
///End MENU_TO_HIDE_PLOT_FROM_DLG

void	GraphVerticalCursorDlg::OnHideSelectedPlotsFromGrid()
{
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
	
	vector<UINT> vnRows;
	m_CursorDataInfoTable.GetSelRows(vnRows);
	int nRows = vnRows.GetSize();
	for(int ii = 0; ii < nRows; ii++)
	{
		m_CursorDataInfoTable.SetIsRowHidden(vnRows[ii], true);
	}
	m_CursorDataInfoTable.RemoveSelection();
	
	vector<int> vnPlotHideFromGrid;
	m_CursorDataInfoTable.GetRowsHide(vnPlotHideFromGrid);
	managerSetting.m_cursorshow.vnPlotHideFromGrid 	= vnPlotHideFromGrid;
	THE_VCURSOR_MANAGER.SetSetting(managerSetting);
}
void	GraphVerticalCursorDlg::OnShowAllPlotsInGrid()
{
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
	
	int nRows = m_CursorDataInfoTable.GetRows();
	
	vector<int> vnHides;
	m_CursorDataInfoTable.GetRowsHide(vnHides);
	ASSERT(vnHides.GetSize() == nRows - m_CursorDataInfoTable.GetRowOffset());
	
	vector<uint> vnIndex;
	int nFind = vnHides.Find(vnIndex, 1);
	for(int ii = 0; ii < nFind; ii++)
	{
		int nRow = vnIndex[ii] + m_CursorDataInfoTable.GetRowOffset();
		m_CursorDataInfoTable.SetIsRowHidden(nRow, false);
	}
	
	vector<int> vnPlotHideFromGrid(nRows - m_CursorDataInfoTable.GetRowOffset());
	vnPlotHideFromGrid = 0;
	managerSetting.m_cursorshow.vnPlotHideFromGrid 	= vnPlotHideFromGrid;
	THE_VCURSOR_MANAGER.SetSetting(managerSetting);
}
void	GraphVerticalCursorDlg::OnUnlinkSelectedGraphs()
{
	string strGraph, strUnlinks;
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL != pHolder && pHolder->m_line.GetValidObj() )
	{
		GraphLayer glActive;
		pHolder->m_line.GetParent(glActive);
		if ( glActive )
			strGraph = glActive.GetPage().GetName();
	}
	if(strGraph.IsEmpty())
	{
		ASSERT(0);
		return;
	}
			
	vector<UINT> vnRows, vnPlot;
	m_CursorDataInfoTable.GetSelRows(vnRows);
	vnPlot = vnRows - m_CursorDataInfoTable.GetRowOffset();
	
	vector<string> vsGraphs, vsSelGraphs, vsList;
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	m_CursorDataInfoTable.GetColValues(nColPos, vsGraphs, m_CursorDataInfoTable.GetRowOffset() );
	vsGraphs.GetSubVector(vsSelGraphs, vnPlot);	
	
	vsList.Add(strGraph);
	int nRet = remove_if_in_list(vsSelGraphs , vsList);
	if(nRet > 0)
		remove_repeat_item(vsSelGraphs);
	int nSize = vsSelGraphs.GetSize();
	if(nSize < 1)
		return;
	
	strUnlinks.SetTokens(vsSelGraphs, STR_PAGE_LIST_SEPARATOR);	
	bool bUnlink = THE_VCURSOR_MANAGER.UnlinkGraphs(strUnlinks);
	ASSERT(bUnlink);
	if(bUnlink)
		UpdateDialogData();
}
///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT

///Jasmine 09/13/2012 ORG-6760-S1 SAVE_AND_LOAD_LINKED_GRAPHS
bool	GraphVerticalCursorDlg::HasLinkedGraphs()
{
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( NULL != pHolder )
		return pHolder->GetLinkedGraphs();
	
	return false;
}

#define STR_VCURSOR_TXT			"VCursorSetting.txt"
#define STR_LINK_GRAPH_SEC		"LinkedGraphs"
bool 	GraphVerticalCursorDlg::IsLinkGraphSaved()
{
	vector<string> vsSections;
	okutil_get_file_sections(GetAppPath() + STR_VCURSOR_TXT, &vsSections);
	int nFind = vsSections.Find(STR_LINK_GRAPH_SEC, 0, false, false);//bFullMatch = false so that we can have more than one linked graphs settings later
	return nFind >= 0;
}

void	GraphVerticalCursorDlg::OnSaveLinkedGraphs()
{
	vector<string> vsGraphs;
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	m_CursorDataInfoTable.GetColValues(nColPos, vsGraphs, m_CursorDataInfoTable.GetRowOffset() );
	remove_repeat_item(vsGraphs);
	int nFind = vsGraphs.Find("*", 0, false, false);
	if(nFind < 0)
		ASSERT(0);
	else
	{
		string strGraph = vsGraphs[nFind];
		vsGraphs.RemoveAt(nFind);
		
		strGraph.Delete(0);
		nFind = vsGraphs.Find(strGraph);
		if(nFind >= 0)
			vsGraphs.RemoveAt(nFind);
	}
	
	int nSize = vsGraphs.GetSize();
	if(nSize <= 0)
		return;
	
	vector<int> 	vnIndex;
	vnIndex.Data(1, nSize);
	vector<string> 	vsKeys;
	convert_int_vector_to_string_vector(vnIndex, vsKeys);
	//string strPrefix("Linked");
	//vsKeys = strPrefix + vsKeys;
	okutil_write_file_section_keys(GetAppPath() + STR_VCURSOR_TXT, STR_LINK_GRAPH_SEC, NULL, NULL);
	okutil_write_file_section_keys(GetAppPath() + STR_VCURSOR_TXT, STR_LINK_GRAPH_SEC, &vsKeys, &vsGraphs);
}

void	GraphVerticalCursorDlg::OnLoadLinkedGraphs()
{	
	vector<string> vsGraphs;
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	m_CursorDataInfoTable.GetColValues(nColPos, vsGraphs, m_CursorDataInfoTable.GetRowOffset() );
	remove_repeat_item(vsGraphs);	
	
	vector<string> 	vsKeys, vsLoad, vsLinks;
	okutil_read_file_section_keys(GetAppPath() + STR_VCURSOR_TXT, STR_LINK_GRAPH_SEC, &vsKeys, &vsLoad);
	vsLinks = vsLoad;
	remove_if_in_list(vsLinks, vsGraphs);
	
	bool bLink = false;
	if(vsLinks.GetSize() > 0)
	{
		string strLinks;
		strLinks.SetTokens(vsLinks, STR_PAGE_LIST_SEPARATOR);	
		bLink = THE_VCURSOR_MANAGER.LinkGraphs(strLinks);
	}
	
	bool bUnlink = false;
	remove_if_in_list(vsGraphs, vsLoad);
	int nFind = vsGraphs.Find("*", 0, false, false);
	if(nFind >= 0)
	{
		string strGraph = vsGraphs[nFind];
		vsGraphs.RemoveAt(nFind);
		
		strGraph.Delete(0);
		nFind = vsGraphs.Find(strGraph);
		if(nFind >= 0)
			vsGraphs.RemoveAt(nFind);
	}
	if(vsGraphs.GetSize() > 0)
	{
		string strUnlinks;
		strUnlinks.SetTokens(vsGraphs, STR_PAGE_LIST_SEPARATOR);	
		bUnlink = THE_VCURSOR_MANAGER.UnlinkGraphs(strUnlinks);
	}
	
	if(bLink || bUnlink)
		UpdateDialogData();
}
///End SAVE_AND_LOAD_LINKED_GRAPHS
	
/*----------------------------------------------------------------------------*/
/* Private functions(implementations) of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/

int GraphVerticalCursorDlg::getTitleWidth()
{
	///------ Folger 07/06/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
	//DeviceContext dc = GetDC();
	DeviceContext	dc(m_wndDlg);
	///------ End BETTER_USE_OC_DEVICE_CONTEXT
	SIZE sz;
	sz = dc.GetTextExtent(STR_DLG_NAME, strlen(STR_DLG_NAME));
	return sz.cx;
}

/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//void GraphVerticalCursorDlg::getDlgFrameSpace( int* pnFrameHoriz /*= NULL*/, int* pnFrameVert /*= NULL*/ )
//{
//	RECT rtWindow, rtClient;
//	GetWindowRect(&rtWindow);
//	GetClientRect(&rtClient);
//	if(pnFrameHoriz)
//		*pnFrameHoriz = RECT_WIDTH(rtWindow)-RECT_WIDTH(rtClient);
//	if(pnFrameVert)
//		*pnFrameVert = RECT_HEIGHT(rtWindow)-RECT_HEIGHT(rtClient);
//}
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

static bool _config_chg_text_type_event(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if ( !(dwCntrl & GETNEVENT_ON_INIT) )
	{
		const BOOL bCustomText = trNode.nVal == LTT_CUSTOM;
		trGetN.LabelsTags.Labels.CustomFormat.Show = bCustomText;
	}
	return true;
}

///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT

static void _get_plot_legend_and_description(const DataPlot& dp, string* pstrLegend, string* pstrDescrip)
{
	ASSERT(dp.IsValid());

	if ( pstrLegend )
	{
		pstrLegend->Empty();
		dp.GetLegend(*pstrLegend);
	}

	if ( pstrDescrip )
	{
		get_dataplot_range_description(*pstrDescrip, dp, VERTICAL_CURSOR_DATAPLOT_GET_DESCRIPTION_STYLE);
	}
}

static int _get_plot_list(string& strCombo, string& strPlots, const GraphPage& gp, const DataPlot& dpSnapped, LPCSTR lpcszCurrent)
{
	vector<string> vsCombo, vsPlots;
	vsCombo.Add(_L("None"));
	vsPlots.Add("");
	///------ Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
	vsCombo.Add(_L("Nearest X"));
	vsPlots.Add(STR_PLOT_NEAREST_X);
	///------ End VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA

	string strLegend, strDescrip;
	if (gp)
	{
		foreach(GraphLayer gl in gp.Layers)
		{
			int nLayIndex = gl.GetIndex() + 1;
			foreach (DataPlot dp in gl.DataPlots)
			{
				_get_plot_legend_and_description(dp, &strLegend, &strDescrip);
				vsPlots.Add(strDescrip);
				if( strLegend.IsEmpty() )
				{
					int nSep;
					if( (nSep = strDescrip.Find(']')) >= 0 )		// remove book name
					{
						strDescrip = strDescrip.Mid(nSep + 1);
						strDescrip.TrimLeft();
			}
					vsCombo.Add(strDescrip);
		}
				else
				{
					vsCombo.Add(strLegend);
	}
			}
		}
	}
	strCombo.SetTokens(vsCombo, '|');
	strPlots.SetTokens(vsPlots, '|');

	int nRet = 0;
	///------ Folger 01/27/10 VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
	if ( lstrcmp(lpcszCurrent, STR_PLOT_NEAREST_X) == 0 )
		nRet = 1;
	else
	///------ End VERTICAL_CURSOR_SNAP_TO_NEAREST_X_DATA
	if( dpSnapped && vsPlots.GetSize() > 1 )
	{
		_get_plot_legend_and_description(dpSnapped, &strLegend, &strDescrip);
		nRet = vsPlots.Find(strDescrip);
		if(nRet < 0)
			nRet = 0;
	}

	return nRet;
}
///End SNAP_CURSOR_TO_DATA_PLOT
///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
static	bool	_on_worksheet_name_update(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
{
	TreeNode trWksName = tr.Dump.WksName;
	TreeNode trWksNameHint = tr.Dump.hintActiveWksName;
	if ( trWksName && trWksNameHint )
	{
		string strWksName = trWksName.strVal;
		okutil_arg_copy(&strWksName);
		string strHint;
		strHint.Format(STR_ACTUAL_WORKSHEET_NAME_FORMAT, strWksName);
		trWksNameHint.SetAttribute(STR_LABEL_ATTRIB, strHint);
	}
	return true;
}
///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
//#define		OPTIONS_GUI_FIRST_SUBNODES_AS_TABS(_TR)	GETN_FIRST_SUBNODES_AS_TABS(_TR);_TR.SetAttribute(STR_PARENT_OF_SUBNODE_DISPLAY_AS_TAB_ATTRIB, "trGUI")
//static	int _get_y_col_format(VIntersectPoint* pti)
//{
	//int nFormat  = OKCOLTYPE_NUMERIC;
	//if ( !pti )
		//return nFormat;
	//XYRange xySrc;
	//Column colObj;
	//DataPlot dp;
	//dp = Project.GetObject(pti->xinfo.plotuid);
	//if ( dp && dp.GetDataRange(xySrc) && xySrc.GetYColumn(colObj) )
	//{
		//nFormat = colObj.GetFormat();
	//}
	//return nFormat;
//}
///end NEW_OPTIONS_DIALOG


///Sophy 8/25/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DLG_WITH_THEME_SUPPORT
enum {
	IDE_VERTI_TABLE_BRANCH		= 0x00001000,
		IDE_VERTI_XDISP				= 0x00000100,
		IDE_VERTI_YDISP				= 0x00000101,
	IDE_VERTI_CURSHOW_BRANCH	= 0x00002000,
		IDE_VERTI_CURSHOW_INDEX		= 0x00002100,
		IDE_VERTI_CURSHOW_NEARX		= 0x00002101,
		IDE_VERTI_CURSHOW_NEARY		= 0x00002102,
		IDE_VERTI_CURSHOW_NAME		= 0x00002103,
		IDE_VERTI_CURSHOW_SHEETNAME	= 0x00002104,
		IDE_VERTI_CURSHOW_BOOKNAME	= 0x00002105,
		IDE_VERTI_CURSHOW_GRAPHNAME	= 0x00002106,	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		IDE_VERTI_CURSHOW_STATUS	= 0x00002107,	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	IDE_VERTI_LABELTAG_BRANCH	= 0x00003000,
		IDE_VERTI_LABEL_BRANCH		= 0x00003100,
			IDE_VERTI_LABEL				= 0x00003111,
			IDE_VERTI_LABEL_CUSTOM		= 0x00003112,
		IDE_VERTI_TAG_BRANCH		= 0x00003200,
			IDE_VERTI_TAG				= 0x00003211,
			IDE_VERTI_TAG_CUSTOM		= 0x00003212,
			IDE_VERTI_TAG_LOCATION		= 0x00003213,
		IDE_VERTI_LINE_LENGTH = 0x00003300, ///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	IDE_VERTI_OUTPUT_BRANCH		= 0x00004000,
		IDE_OUTPUT_WKS_NAME			= 0x00004100,
};
///end VERTICAL_CURSOR_OPTION_DLG_WITH_THEME_SUPPORT

BOOL GraphVerticalCursorDlg::constructSettingGUITree( TreeNode& tnSettingGUI, const VManagerSetting& managerSetting )
{
	///Sophy 8/15/2011 ORG-3106 NEW_OPTIONS_DIALOG
	/*
	tnSettingGUI.Reset();
	TreeNode trGUI = tnSettingGUI.AddNode("ConfigGUI");

	GETN_USE(trGUI)
	GETN_DLG_OPTIONS(DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY)

	GETN_BEGIN_BRANCH( Dump, _L("Output") )	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
		GETN_STR(hintLTRegister, _L("%H=Active Window Name\n%C=Active Dataset Name"), "")	GETN_HINT
		///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
		GETN_STR( WksName, _L("Worksheet"), managerSetting.m_strDumpWksName)
		///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
			GETN_OPTION_EVENT(_on_worksheet_name_update)
		GETN_STR(hintActiveWksName, "", "")	GETN_HINT //hint will be updated within _on_worksheet_name_update
		///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	GETN_END_BRANCH( Dump )

	GETN_BEGIN_BRANCH( Label, _L("Display") )	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_LIST( SD, _L("Significant Digits"), managerSetting.m_labelSetting.nSignificantDigits, _L("System|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15") )
		GETN_LIST( TextType, _L("Text Type"), managerSetting.m_labelSetting.nTextType, _L("Y|(X,Y)|Custom") )
			GETN_OPTION_EVENT_EX(_config_chg_text_type_event)
		GETN_STR( CustomText, _L("Custom Text"), managerSetting.m_labelSetting.strLTCustomTextType)
		GETN_CURRENT_SUBNODE.Show = managerSetting.m_labelSetting.nTextType == LTT_CUSTOM;
		GETN_CURRENT_SUBNODE.Use = FALSE;
		
	GETN_END_BRANCH( Label )

	///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
	GETN_BEGIN_BRANCH( CursorShow, _L("Show") )	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_CHECK(Index, 		_L("Nearest Index"), 		managerSetting.m_cursorshow.Index)
		GETN_CHECK(CursorX, 	_L("Cursor X"), 	true)//managerSetting.m_cursorshow.CursorX)///Jasmine 01/19/10 VCURSOR_ALWAYS_SHOW_XY_VALUE
			GETN_CURRENT_SUBNODE.Show = false;
		GETN_CHECK(CursorY,		_L("Cursor Y"), 	true)//managerSetting.m_cursorshow.CursorY)
			GETN_CURRENT_SUBNODE.Show = false;
		///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
		GETN_CHECK(CursorNearX, _L("Nearest X"), 	managerSetting.m_cursorshow.CursorNearX)
		GETN_CHECK(CursorNearY, _L("Nearest Y"), 	managerSetting.m_cursorshow.CursorNearY)		
		///End SHOW_NEAREST_POINT
		///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		//GETN_CHECK(ShortName, 	LABEL_SHORT_NAME, 	managerSetting.m_cursorshow.ShortName)
		//GETN_CHECK(LongName, 	STR_LONG_NAME_LABEL,	managerSetting.m_cursorshow.LongName)
		GETN_CHECK(Name, 	LABEL_NAME,	managerSetting.m_cursorshow.Name)
		///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
		GETN_CHECK(SheetName,	LABEL_SHEET_NAME, 	managerSetting.m_cursorshow.SheetName)
		GETN_CHECK(BookName, 	LABEL_BOOK_NAME, 	managerSetting.m_cursorshow.BookName)
	GETN_END_BRANCH( CursorShow )
	///End CONFIGURE_SHOW_HIDE_SETTING
	
	GETN_BEGIN_BRANCH( Misc, _L("Misc") )	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		///Kyle 01/26/2010 SNAP_CURSOR_TO_DATA_PLOT
		//GETN_CHECK( SnapLine, _L("Snap Cursor to Data"), managerSetting.m_bSnapLineToData)
		GraphPage gp;
		DataPlot dpSnapped;
		string strComboList, strPlots;
		const GraphVerticalCursorHolder* pgvcHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer();
		if (pgvcHolder)
			gp = pgvcHolder->GetPage();
		THE_VCURSOR_MANAGER.IsLineSnappedToData(&dpSnapped);
		int nIndex = _get_plot_list(strComboList, strPlots, gp, dpSnapped, managerSetting.m_strSnappedPlot);
		GETN_LIST(SnapLine,_L("Snap Cursor to Data"), nIndex, strComboList)			_tmpSubNode.SetAttribute(PlotListAttr(), strPlots);
		///End SNAP_CURSOR_TO_DATA_PLOT
	GETN_END_BRANCH( Misc )

#ifdef REMOVE_LABEL_FEATURE
	trGUI.Label.TextType.Show = false;
#endif
	
	///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	trGUI.Misc.Show = 0;
	///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
	
	DWORD dwDlgPtr = (DWORD)this;		
	GraphVerticalCursorDlg* pDialog = (GraphVerticalCursorDlg*)dwDlgPtr;
	TreeNode trDlgPtr = tree_check_get_node(trGUI, STR_NODE_TAG_NAME_DIALOG);
	trDlgPtr.nVal = dwDlgPtr;
	trDlgPtr.Show = FALSE;
	*/
	CurrentDateTimeDisplayHelper _helper;
	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
	string strDateStrList 	= "D0|D10|D21" + "|" + STR_AUTO;//"|D1|D2|D3";
	string strTimeStrList 	= "T0|T10|T17" + "|" + STR_AUTO;//"|T1|T2|T3";
	string strNuemricList 	= "*|*3|.4|2.2|P*3|S.4|E.3|L.2";//"|*|.2|*5";
	///End LABEL_FOLLOW_AXIS_FORMAT
	string strXDispList 	= strNuemricList;
	string strYDispList 	= strNuemricList;
	VIntersectPoint* pti 	= THE_VCURSOR_MANAGER.GetPoint(0);
	int nXFormat, nYFormat;
	nXFormat = managerSetting.m_tagSetting.nXFormat;
	nYFormat = managerSetting.m_tagSetting.nYFormat;
	///Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	string strDefX = "*", strDefY = "*";	
	///end VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	///Jasmine 08/20/2012 ORG-6419-P1 LABEL_FOLLOW_AXIS_FORMAT
	if ( nXFormat == OULABEL_TIME )//OKCOLTYPE_TIME
	{
		strDefX = STR_AUTO;//"T1";		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		strXDispList = strTimeStrList;
	}
	else if (nXFormat == OULABEL_DATE )//OKCOLTYPE_DATE
	{
		strDefX = STR_AUTO;//"D1";		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		strXDispList = strDateStrList;
	}
	///Jasmine 08/23/2012 ORG-6419-P2 DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
	else if(nXFormat != OULABEL_NUMERIC)
	{
		strDefX = STR_AUTO;
		strXDispList = strNuemricList + "|" + STR_AUTO;
	}
	///End DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL

	if ( OULABEL_TIME == nYFormat )//OKCOLTYPE_TIME
	{
		strDefY = STR_AUTO;//"T1";		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		strYDispList = strTimeStrList;
	}
	else if ( OULABEL_DATE == nYFormat )//OKCOLTYPE_DATE
	{
		strDefY = STR_AUTO;//"D1";		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		strYDispList = strDateStrList;
	}
	///Jasmine 08/23/2012 ORG-6419-P2 DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
	else if(nYFormat != OULABEL_NUMERIC)
	{
		strDefY = STR_AUTO;
		strYDispList = strNuemricList + "|" + STR_AUTO;
	}
	///End DEFAULT_AUTO_FOR_OTHER_FORMAT_TYPE_OF_AXIS_LABEL
	///End LABEL_FOLLOW_AXIS_FORMAT
	
	tnSettingGUI.Reset();
	TreeNode trGUI = tnSettingGUI.AddNode("trGUI");
	GETN_USE(trGUI)
	///Sophy 9/6/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	trGUI.SetAttribute(STR_XFUNCTION_NAME_ATTRIB, 		"verticalcursor");
	trGUI.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, 	"VerticalCursorDlg");
	trGUI.SetAttribute(STR_THEME_FILE_ATTRIB, 			managerSetting.m_strThemeFileName);
	///end VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
	///Sophy 9/19/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
	//GETN_DLG_OPTIONS(DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY)
	DWORD dwXFBits = DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY | DYNALAYOUT_NO_EXECUTE_XF_ON_APPLY | DYNALAYOUT_NO_DESCRIPTION;
	///Sophy 10/10/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	if ( managerSetting.m_cursorshow.bModifiedOutside )
		dwXFBits |= DYNALAYOUT_THEME_MODIFIED_OUTSIDE;
	///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	GETN_DLG_OPTIONS(dwXFBits)
	///end GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
	GETN_FIRST_SUBNODES_AS_TABS(trGUI);
	
	GETN_BEGIN_BRANCH(Table, _L("Table")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_ID(IDE_VERTI_TABLE_BRANCH)
		GETN_STR(FormatHint, _L("Use *nn to set significant digits.\r\nUse .nn to set decimal places.\r\nUse * to follow system settings.\r\nUse Dnn/Tnn to set date/time format. nn matches the index (0 offset) in the Display dropdown list for Format Cells dialog."), "") GETN_HINT
		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		//GETN_STRLIST(XDisp, _L("X Display Format"), managerSetting.m_cursorshow.strXDisp, strXDispList) GETN_ID(IDE_VERTI_XDISP)
		string strTemp = _cvt_auto_format_display_str(managerSetting.m_cursorshow.strXDisp, true, true);
		insert_str_to_str_list(strTemp, strXDispList, "junk");
		GETN_STRLIST(XDisp, _L("X Display Format"), strTemp, "|" + strXDispList) GETN_ID(IDE_VERTI_XDISP)
		///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
			GETN_CURRENT_SUBNODE.SetAttribute(STR_DEFAULT_VALUE_ATTRIB, strDefX);	///Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
		///Jasmne 08/21/2012 ORG-6419-S2 SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
		//GETN_STRLIST(YDisp, _L("Y Display Format"), managerSetting.m_cursorshow.strYDisp, strYDispList) GETN_ID(IDE_VERTI_YDISP)
		strTemp = _cvt_auto_format_display_str(managerSetting.m_cursorshow.strYDisp, true, false);
		insert_str_to_str_list(strTemp, strYDispList, "junk");
		GETN_STRLIST(YDisp, _L("Y Display Format"), strTemp, "|" + strYDispList) GETN_ID(IDE_VERTI_YDISP)
		///End SUPPORT_CONVERT_DOUBLE_TO_STR_FOLLOW_AXIS
			GETN_CURRENT_SUBNODE.SetAttribute(STR_DEFAULT_VALUE_ATTRIB, strDefY);	///Sophy 9/27/2011 ORG-3106-S13 VERTICAL_CURSOR_OPTION_DIALOG_THEME_SUPPORT
		GETN_BEGIN_BRANCH(CursorShow, _L("Show")) SET_BRANCH_AS_GROUP_BOX(_L("Show")) GETN_ID(IDE_VERTI_CURSHOW_BRANCH)
			GETN_CHECK(Index, _L("Nearest Index"), managerSetting.m_cursorshow.Index) GETN_ID(IDE_VERTI_CURSHOW_INDEX)
			GETN_CHECK(CursorX, 	_L("Cursor X"), 	true)//managerSetting.m_cursorshow.CursorX)///Jasmine 01/19/10 VCURSOR_ALWAYS_SHOW_XY_VALUE
				GETN_CURRENT_SUBNODE.Show = false;
			GETN_CHECK(CursorY,		_L("Cursor Y"), 	true)//managerSetting.m_cursorshow.CursorY)
				GETN_CURRENT_SUBNODE.Show = false;
			GETN_CHECK(CursorNearX,	_L("Nearest X"), managerSetting.m_cursorshow.CursorNearX) GETN_ID(IDE_VERTI_CURSHOW_NEARX)
			GETN_CHECK(CursorNearY,	_L("Nearest Y"), managerSetting.m_cursorshow.CursorNearY) GETN_ID(IDE_VERTI_CURSHOW_NEARY)
			GETN_CHECK(Name, 		_L("Name"), 	managerSetting.m_cursorshow.Name) 		GETN_ID(IDE_VERTI_CURSHOW_NAME)
			GETN_CHECK(SheetName, 	_L("Sheet"), 	managerSetting.m_cursorshow.SheetName) 	GETN_ID(IDE_VERTI_CURSHOW_SHEETNAME)
			GETN_CHECK(BookName, 	_L("Book"), 	managerSetting.m_cursorshow.BookName) 	GETN_ID(IDE_VERTI_CURSHOW_BOOKNAME)
			GETN_CHECK(GraphName, 	_L("Graph"), 	managerSetting.m_cursorshow.GraphName) 	GETN_ID(IDE_VERTI_CURSHOW_GRAPHNAME)	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
			GETN_CHECK(Status, 		_L("Status"), 	managerSetting.m_cursorshow.Status) 	GETN_ID(IDE_VERTI_CURSHOW_STATUS)		///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
		GETN_END_BRANCH(CursorShow)
	GETN_END_BRANCH(Table)
	GETN_BEGIN_BRANCH(LabelsTags, _L("Labels and Tags")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_ID(IDE_VERTI_LABELTAG_BRANCH)
		GETN_BEGIN_BRANCH(Labels, _L("Labels"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN) SET_BRANCH_AS_GROUP_BOX(_L("Labels")) GETN_ID(IDE_VERTI_LABEL_BRANCH)
			///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
			//GETN_LIST(Label, _L("Label Form"), managerSetting.m_labelSetting.nTextType, _L("Y|(X, Y)|Custom")) GETN_ID(IDE_VERTI_LABEL) GETN_OPTION_EVENT_EX(_config_chg_text_type_event)
			GETN_LIST(Label, _L("Label Form"), managerSetting.m_labelSetting.nTextType, _L("Y|(X, Y)|Custom|None")) GETN_ID(IDE_VERTI_LABEL) GETN_OPTION_EVENT_EX(_config_chg_text_type_event)
			///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
				///Jasmine 08/31/2012 ORG-6422-P1 KEEP_CURRENT_VALUE_IN_DROPLIST
				//GETN_STRLIST(CustomFormat, _L("Format Strings"),  managerSetting.m_labelSetting.strLTCustomTextType, "|Value $(Y, *3) at $(X, T2)") GETN_ID(IDE_VERTI_LABEL_CUSTOM)
				string strTempList = (OULABEL_DATE == nYFormat || OULABEL_TIME == nYFormat)? "$(Y, y)" : "$(Y, *)";
				strTempList += "|Value $(Y, *3) at $(X, T2)";
				insert_str_to_str_list(managerSetting.m_labelSetting.strLTCustomTextType, strTempList, "junk");
				GETN_STRLIST(CustomFormat, _L("Format Strings"),  managerSetting.m_labelSetting.strLTCustomTextType, "|"+strTempList) GETN_ID(IDE_VERTI_LABEL_CUSTOM)
				///End KEEP_CURRENT_VALUE_IN_DROPLIST
		GETN_END_BRANCH(Labels)
		GETN_BEGIN_BRANCH(Tags, _L("Tags")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) SET_BRANCH_AS_GROUP_BOX(_L("Tags")) GETN_ID(IDE_VERTI_TAG_BRANCH)
			///------ Folger 08/10/2012 ORG-6381-S3 VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
			//GETN_LIST(Tag, _L("Tag Form")	, managerSetting.m_tagSetting.nTextType, _L("X|Custom")) GETN_ID(IDE_VERTI_TAG)
			GETN_LIST(Tag, _L("Tag Form")	, managerSetting.m_tagSetting.nTextType, _L("X|Custom|None")) GETN_ID(IDE_VERTI_TAG)
			///------ End VERTICAL_CURSOR_NONE_LABEL_FROM_AND_TAG_FROM
				///Jasmine 08/31/2012 ORG-6422-P1 KEEP_CURRENT_VALUE_IN_DROPLIST
				//GETN_STRLIST(CustomFormat, _L("Format Strings"), managerSetting.m_tagSetting.strLTCustomTextType, "|X = $(X, T2)|X = $(X, D2)") GETN_ID(IDE_VERTI_TAG_CUSTOM)
				strTempList = "$(X)|X = $(X, T2)|X = $(X, D2)";
				insert_str_to_str_list(managerSetting.m_tagSetting.strLTCustomTextType, strTempList, "junk");
				GETN_STRLIST(CustomFormat, _L("Format Strings"), managerSetting.m_tagSetting.strLTCustomTextType, "|"+strTempList) GETN_ID(IDE_VERTI_TAG_CUSTOM)
				///End KEEP_CURRENT_VALUE_IN_DROPLIST
				GETN_LIST(Location, _L("Location"), managerSetting.m_tagSetting.nLocation, _L("Top|Bottom")) GETN_ID(IDE_VERTI_TAG_LOCATION)
		GETN_END_BRANCH(Tags)
		///------ Folger 08/16/2012 ORG-6381-S2 VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
		GETN_LIST(LineLength, _L("Line Length"), managerSetting.m_nLineLength, _L("Span Layers|Full Page")) GETN_ID(IDE_VERTI_LINE_LENGTH)
		///------ End VECTICAL_CURSOR_SUPPORT_CURSOR_LINE_ACROSS_LAYERS
	GETN_END_BRANCH(LabelsTags)
	GETN_BEGIN_BRANCH(Dump, _L("Output")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_ID(IDE_VERTI_OUTPUT_BRANCH)
		GETN_STR(hintLTRegister, _L("%H=Active Window Name\n%C=Active Dataset Name"), "")	GETN_HINT
		GETN_STR( WksName, _L("Worksheet"), managerSetting.m_strDumpWksName) GETN_ID(IDE_OUTPUT_WKS_NAME)
			GETN_OPTION_EVENT(_on_worksheet_name_update)
		GETN_STR(hintActiveWksName, "", "")	GETN_HINT //hint will be updated within _on_worksheet_name_update
	GETN_END_BRANCH(Dump)
	
	ODWP 		DlgPtr 	= (ODWP)this;		
	TreeNode 	trDlgPtr= tree_check_get_node(trGUI, STR_NODE_TAG_NAME_DIALOG);
	trDlgPtr.oipVal 	= DlgPtr;
	trDlgPtr.Show 		= FALSE;

	///end NEW_OPTIONS_DIALOG
	return TRUE;
}
///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
void GraphVerticalCursorDlg::showReportSheetName(const VManagerSetting& managerSetting)
{
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	//Control editWks = GetDlgItem(IDC_EDIT_RESULT_SHEET);
	//if(!editWks)
		//return;
	//
	//editWks.Text = managerSetting.m_strDumpWksName;
	/////Jasmine 02/08/10 ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
	//Worksheet wks(editWks.Text);
	///Sophy 8/8/2011 ORG-3106-S6 ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	//Worksheet wks(managerSetting.m_strDumpWksName);
	string strWksName = managerSetting.m_strDumpWksName;
	okutil_arg_copy(&strWksName);
	Worksheet wks(strWksName);
	///end ALLOW_STRING_REGISTER_TO_CUSTOMIZE_OUTPUT_WORKSHEET
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	enableActivateBtn( wks.IsValid() );
	///End ENABLE_ACTIVATE_BTN_BY_CHECK_REPORT_SHEET
}
///End MOVE_OUT_RESULT_SHEET_EDITBOX

#define SET_DEFAULT_CONTROL_GAP			3
void GraphVerticalCursorDlg::arrangeControls()
{
	if(!m_wndDlg)
		m_wndDlg = GetWindow();

	// 1. Arrange the toolbar buttons
		vector<uint> vnGroupBtnIDs = {
///Jasmine 07/21/2011 ORG-3106-S8 DUMP_LABEL_AND_LINE_ON_GRAPH
#ifdef REMOVE_TAG_FEATURE
			IDC_BTN_DUMP_LABEL,
#endif//REMOVE_TAG_FEATURE
///End DUMP_LABEL_AND_LINE_ON_GRAPH
#ifndef REMOVE_LABEL_FEATURE
			IDC_BTN_SHOW_LABEL,																IDC_GROUP_GAP
#endif//REMOVE_LABEL_FEATURE
#ifndef REMOVE_TAG_FEATURE
		, 	IDC_BTN_ADD_TAG, IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS, IDC_BTN_CLEAR_ALL_TAGS,	IDC_GROUP_GAP
		, 	IDC_BTN_NEXT_TAG, IDC_BTN_PREVIOUS_TAG,											IDC_GROUP_GAP
#endif//REMOVE_TAG_FEATURE
#ifndef REMOVE_LABEL_FEATURE
		,	IDC_BTN_INCREASE_FONT, IDC_BTN_DECREASE_FONT,									IDC_GROUP_GAP
		, 	
#endif//REMOVE_LABEL_FEATURE
			///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
		//	IDC_BTN_CONFIG_OUTPUT,  														IDC_GROUP_GAP 
		//,	IDC_STATIC_RESULT_SHEET, IDC_EDIT_RESULT_SHEET, 	///Jasmine MOVE_OUT_RESULT_SHEET_EDITBOX
			IDC_STATIC_TIPS_X, IDC_EDIT_X, IDC_CHECK_USE_X,					IDC_GROUP_GAP,	IDC_GROUP_GAP
		,
			///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
			IDC_BTN_DUMP_TAG_INTO_WKS, IDC_BTN_ACTIVATE_WKS		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS
		,	IDC_BTN_CONFIG_OUTPUT  								///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
		,	IDC_BTN_LINK_GRAPH									///Jasmine 05/11/2012 ORG-4971-S2 BTN_FOR_LINK_GRAPH
		,	IDC_BTN_DOWNUP										///Jasmine 06/08/2012 ORG-4971-S4-1 HIDE_VCURSOR_TO_A_SIMPLER_DB
		,	0
	};

	SetControlGap(SET_DEFAULT_CONTROL_GAP);
	const int nControlGap		= GetControlGap();

	//ArrangeMainItemAndControls(vnGroupBtnIDs, 0, NULL, false, cx, cy, nControlGap, nGroupBtnGap);
	int nBottom = ArrangeControlsLeftRight(vnGroupBtnIDs, nControlGap, nControlGap, nControlGap);
	
	Button btnFirst;
	RECT rFirstBtn;
	GetControlClientRect(vnGroupBtnIDs[0], rFirstBtn, &btnFirst);
	
	vector<uint>	vnIndices;
	if(vnGroupBtnIDs.Find(vnIndices, 0) > 0)
	{
		int nLast = vnIndices[0] - 1;
		Button btnLast;
		RECT rLastBtn;
		GetControlClientRect(vnGroupBtnIDs[nLast], rLastBtn, &btnLast);
		m_nGroupedBtnTotalWidth = max(m_nGroupedBtnTotalWidth, rLastBtn.right-rFirstBtn.left);
	}

	// 2. Arrange the other controls
	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	//vector<uint> vnOtherCtrlIDs = {IDC_STATIC_TIPS_X, IDC_EDIT_X, IDC_CHECK_USE_X, IDC_BTN_DOWNUP, 0};
#ifndef REMOVE_TAG_FEATURE
	vector<uint> vnOtherCtrlIDs = {IDC_BTN_DOWNUP, 0};
	///End KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	nBottom = ArrangeControlsLeftRight(vnOtherCtrlIDs, nControlGap, nBottom + nControlGap*2, nControlGap);
	
	if(vnOtherCtrlIDs.Find(vnIndices, 0) > 0)
	{
		int nLast = vnIndices[0] - 1;
		Button btnLast;
		RECT rLastBtn;
		GetControlClientRect(vnOtherCtrlIDs[nLast], rLastBtn, &btnLast);
		m_nGroupedBtnTotalWidth = max(m_nGroupedBtnTotalWidth, rLastBtn.right-rFirstBtn.left);
	}
#endif//REMOVE_TAG_FEATURE	///Jasmine 06/17/2011 ORG-3106-P1 KEEP_ONLY_ONE_OUTPUT_WKS_EDITBOX_IN_OPTION_DLG
	// 3. junk frame
	Control cFrame = GetItem(IDC_FRAME_TOP_PANE);
	MoveControl(cFrame, rFirstBtn);
	cFrame.Visible = false;
	
	// 4. tab
	Control tab;
	RECT rTab;
	GetControlClientRect(IDC_BOTTOM_INFO_TAB, rTab, &tab);
	rTab.top = nBottom + nControlGap;
	rTab.left = nControlGap;
	MoveControl(tab, rTab);
}

void GraphVerticalCursorDlg::PositionSnapNearestXCheckbox()
{
	TabControl tab;
	RECT rTab;
	GetControlClientRect(IDC_BOTTOM_INFO_TAB, rTab, &tab);
	
	///------ Folger 07/06/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
	//DeviceContext dc = tab.GetDC();
	DeviceContext	dc(tab);
	///------ End BETTER_USE_OC_DEVICE_CONTEXT

	vector<int> vnTab = {	LABEL_INFO_TAB
					#ifndef REMOVE_TAG_FEATURE
							,TAG_INFO_TAB
					#endif
						};
						
	int nTabTitleWidth = 0;
	for(int ii = 0; ii < vnTab.GetSize(); ii++)
	{
		string strTitle = tab.GetItemText( vnTab[ii] );
		SIZE sz;
		sz = dc.GetTextExtent(strTitle, strlen(strTitle));
		nTabTitleWidth += sz.cx + GetControlGap()*2;
	}
	
	///Jasmine 06/13/2012 ORG-4971-S4 SNAP_NEAREST_X_CHECKBOX_IS_TOO_LOW
	//PositionControl(IDC_SNAP_NEAREST_X, rTab.left+nTabTitleWidth+GetControlGap()*2, rTab.top+GetControlGap());
	RECT rGrid;
	rGrid = rTab;
	tab.AdjustRect(FALSE, &rGrid);
	int nTabGap = rTab.bottom - rGrid.bottom;
	PositionControl(IDC_SNAP_NEAREST_X, rTab.left+nTabTitleWidth+GetControlGap()*2, rGrid.top - nTabGap - 1/*min gap*/, false);
	///End SNAP_NEAREST_X_CHECKBOX_IS_TOO_LOW
}

int GraphVerticalCursorDlg::GetBottomPaneSubControls(vector<uint>& vnCntrls)
{
	vnCntrls.SetSize(0);
	vnCntrls.Add(IDC_LABEL_INFO_LIST_BOX);
	vnCntrls.Add(IDC_TAG_INFO_LIST_BOX);
	return m_BottomTab.GetCurSel();
}
#ifndef REMOVE_LABEL_FEATURE
void GraphVerticalCursorDlg::updateShowHideLabelsBtnState()
{
	Button btnShowLabel = GetItem(IDC_BTN_SHOW_LABEL);
	btnShowLabel.Check = THE_VCURSOR_MANAGER.IsTextLabelsShown();
}
#endif//REMOVE_LABEL_FEATURE
void GraphVerticalCursorDlg::updateTagRelatedBtnState( BOOL bEnableBtn /*= FALSE*/ )
{
	BitmapRadioButton btnClearTags			= GetDlgItem(IDC_BTN_CLEAR_ALL_TAGS);
	BitmapRadioButton btnNextTag			= GetDlgItem(IDC_BTN_NEXT_TAG);
	BitmapRadioButton btnPreviousTag		= GetDlgItem(IDC_BTN_PREVIOUS_TAG);
	BitmapRadioButton btnDumpData			= GetDlgItem(IDC_BTN_DUMP_TAG_INTO_WKS);

	btnClearTags.Enable		= bEnableBtn;
	btnNextTag.Enable		= bEnableBtn;
	btnPreviousTag.Enable	= bEnableBtn;
	btnDumpData.Enable		= bEnableBtn;
}

void GraphVerticalCursorDlg::updateRemoveSelTagsGrpsBtnState()
{
	BitmapRadioButton btnRemoveSelTagsGrps	= GetDlgItem(IDC_BTN_REMOVE_SELECTED_TAGS_GROUPS);
	btnRemoveSelTagsGrps.Enable = (THE_VCURSOR_MANAGER.GetSelectedTagsCount() > 0);
}

///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
static	string	_get_time_format_string(int nFormat)
{
	CurrentDateTimeDisplayHelper dtHelper;
	string str = dtHelper.TimeList();
	return str.GetToken(nFormat, '|');
}

static int	_get_lt_datetime_display_format(int nFormat, int nSubFmt, string strCustomDisp, string& strDispFmt, bool& bForDateTimePicker)
///end DYNA_CTRL_DATE_TIME_PICKER_WITH_AUTO_CHECKBOX_SUPPORT
{
	int nLTFormat = LT_FORMAT_NUMERIC;
	
	if ( OULABEL_DATE != nFormat && OULABEL_TIME != nFormat )
		return nLTFormat;
	
	bool bDate = (OULABEL_DATE == nFormat);
	nLTFormat = bDate ? LT_FORMAT_DATE : LT_FORMAT_TIME;
	strDispFmt = bDate ? "D" : "T";
	///Sophy 1/20/2012 ORG-2189-S1 DYNA_CTRL_DATE_TIME_PICKER_WITH_AUTO_CHECKBOX_SUPPORT
	if ( bForDateTimePicker )
		strDispFmt = ""; //clear the prefix.
	///end DYNA_CTRL_DATE_TIME_PICKER_WITH_AUTO_CHECKBOX_SUPPORT
	
	if ( bDate && LDF_OBJ_CUSTOM == nSubFmt || !bDate && LTF_OBJ_CUSTOM == nSubFmt )
	{
		strDispFmt = strDispFmt + strCustomDisp;
		if ( strDispFmt.Find('#') >= 0 )
		{
			strDispFmt = bDate ? "D" : "T";
			strDispFmt += strCustomDisp;
			bForDateTimePicker = false;
		}
		///Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
		if ( !bDate && strCustomDisp.Find('D') < 0 )
		{
			if ( !bForDateTimePicker )
				strDispFmt = "D";
			else
				strDispFmt = "";
			strDispFmt += "MM/dd/yyyy "+ strCustomDisp;
			nLTFormat = LT_FORMAT_DATE;
		}
		///end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
	}
	else
	{
		string strDateTimeFmtStr = (bDate ? get_date_format_str(nSubFmt) : _get_time_format_string(nSubFmt));
		if ( strDateTimeFmtStr.Find('#') >= 0 )
		{
			strDispFmt = bDate ? "D" : "T";
			strDispFmt = strDispFmt + (nSubFmt); //restore to get rid of date time picker control
			bForDateTimePicker = false;
		}
		strDispFmt = strDispFmt + (nSubFmt);
		///Sophy 1/20/2012 ORG-2189-S1 DYNA_CTRL_DATE_TIME_PICKER_WITH_AUTO_CHECKBOX_SUPPORT
		if ( bForDateTimePicker ) //overwrite lt display format
		{
			strDispFmt = (bDate ? get_date_format_str(nSubFmt) : _get_time_format_string(nSubFmt));
		}
		///end DYNA_CTRL_DATE_TIME_PICKER_WITH_AUTO_CHECKBOX_SUPPORT
		/////Sophy 4/5/2012 ORG-4611-P1 BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
		//if ( !bDate && (nSubFmt >= 0 && nSubFmt <= 10) )
		//{
			//string strTimeFmt = _get_time_format_string(nSubFmt);
			//if ( !bForDateTimePicker )
				//strDispFmt = "D";
			//else
				//strDispFmt = "";
			//strDispFmt += "MM/dd/yyyy "+ strTimeFmt;
			//nLTFormat = LT_FORMAT_DATE;
		//}
		/////end BRING_BACK_DATE_INFORMATION_FOR_TIME_FORMAT_COLUMN
	}
	
	return nLTFormat;
}

///------ Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
//static string _get_data_time_ctrl_format(const XInfo& xinfo)
//{
//	bool	bForDateTimePicker = true;
//	string 	strDispFmt;//, strDateDispFmt = "MM/dd/yyyy", strTimeDispFmt = "HH:mm:ss";
//	int 	nLTFormat = _get_lt_datetime_display_format(xinfo.format, xinfo.display, xinfo.custom, strDispFmt, bForDateTimePicker);
//	//printf("nLTFormat = %d, bForDateTimePicker = %d, strDispFmt = %s\n", nLTFormat, (int)bForDateTimePicker, strDispFmt);//test
//	if(!bForDateTimePicker || (LT_FORMAT_TIME != nLTFormat && LT_FORMAT_DATE != nLTFormat))
//	{
//		return "";
//	}
//	
//	return strDispFmt;
//}
///------ End SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
///End USE_DATE_TIME_PICKER_FOR_SUCH_DATA

void GraphVerticalCursorDlg::updateCursorPos(bool bIsMoving /*= false*/)
{
	///------ Folger 01/15/10 X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	if ( m_bPositionChangeByEditing )
	{
		m_bPositionChangeByEditing = FALSE;
		return;
	}
	///------ End X_VALUE_IN_EDITBOX_SHOULD_NOT_CHANGE_AFTER_ENTER_A_NEW_VALUE
	double dPosX;
	if( THE_VCURSOR_MANAGER.GetLinePosition(dPosX, bIsMoving) )
	{
		cvtXBaseToLineUnit(dPosX, true);///Jasmine 09/04/2012 ORG-6429-S1 BTN_TO_CAHNGE_X_REFERECE_LAYER
		
		const int nSigificantDigits = THE_VCURSOR_MANAGER.GetLabelsSignificantDigits();
		///Jasmine 07/20/2011 ORG-3106-S4-3 KEEP_ACTUAL_VALUE_IN_X_EDITBOX
		/*
		///Jasmine 01/20/10 SHOW_XVALUE_WITH_FORMAT
		VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(0);
		if (pti )
			m_editPos.Text = _ftoa(pti->xinfo, dPosX, nSigificantDigits);
		else
			m_editPos.Text = ftoa_sd(dPosX, nSigificantDigits);
		///End SHOW_XVALUE_WITH_FORMAT
		*/
		VIntersectPoint* pti = THE_VCURSOR_MANAGER.GetPoint(0);
		m_editPos = GetItem(IDC_EDIT_X);
		if (pti )
		{
			///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
			///------ Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
			//string strDTFormat = _get_data_time_ctrl_format(pti->xinfo);
			///------ End SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
			///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
			//if(pti->xinfo.format == OULABEL_TIME)
			if ( pti->IsXTime() )
			///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
			{
				m_DateTimeXValue.SetDateTimeStyle(FALSE);
				m_DateTimeXValue.CreateControl(m_editPos.GetSafeHwnd());
				///------ Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
				//m_DateTimeXValue.SetDisplayFormat(strDTFormat);
				m_DateTimeXValue.SetDisplayFormat("X");
				///------ End SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
			}
			///------ Folger 09/29/2012 ORG-6857-P1 BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
			//else if(pti->xinfo.format == OULABEL_DATE)
			else if( pti->IsXDate() )
			///------ End BETTER_DATE_TIME_HANDLE_FOR_VERTICAL_CURSOR
			{
				m_DateTimeXValue.SetDateTimeStyle(TRUE);
				m_DateTimeXValue.CreateControl(m_editPos.GetSafeHwnd());
				///------ Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
				//m_DateTimeXValue.SetDisplayFormat(strDTFormat);
				m_DateTimeXValue.SetDisplayFormat("X");
				///------ End SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
			}
			else			
			{
				Edit edXValue;
				edXValue.CreateControl(m_editPos.GetSafeHwnd(), m_dwXValueStyle);
			///End USE_DATE_TIME_PICKER_FOR_SUCH_DATA
			}
		}
		
		///Jasmine 08/22/2012 ORG-6419-S1 USE_DATE_TIME_PICKER_FOR_SUCH_DATA
		///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
		//if(pti && (pti->xinfo.format == OULABEL_TIME || pti->xinfo.format == OULABEL_DATE))
		//{
			//if(pti->xinfo.format == OULABEL_TIME && floor(dPosX) <= 0)
				//dPosX += 2456070;
			//m_DateTimeXValue.SetValue(dPosX);
		//}
		//else
		//{
			//string strOut;
			//if(pti)
				//strOut = _convert_double_to_date_time_str(pti->xinfo, dPosX);
			//if( strOut.IsEmpty() )
				//strOut = ftoa(dPosX);
			////m_editPos.Text = strOut;
			//GetItem(IDC_EDIT_X).Text = strOut;
			//
		//}
		setInputXValue(dPosX);
		///End PASS_MORE_INFO_TO_LINKED_GRAPH
		m_editPos = GetItem(IDC_EDIT_X);
		///End USE_DATE_TIME_PICKER_FOR_SUCH_DATA
		///End KEEP_ACTUAL_VALUE_IN_X_EDITBOX
	}
}

void GraphVerticalCursorDlg::updateTagsInfo()
{
	const GraphVerticalCursorHolder* pgvcHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer();
	if (pgvcHolder)
	{
		m_TagInfoTable.ClearAll();
		const int nTagUnitSize = pgvcHolder->m_arrTagUnits.GetSize();
		const UINT uPageUID = pgvcHolder->m_uPageUID;

		for (int ii = 0; ii < nTagUnitSize; ++ii)
		{
			OnTagAdded(uPageUID, ii);
		}
	}
}

void GraphVerticalCursorDlg::updateCursorDataInfo(bool bUpdateCursorPos/* true*/)//void GraphVerticalCursorDlg::updateCursorDataInfo()///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
{
	THE_VCURSOR_MANAGER.RetrieveCursorInfo();
	if(bUpdateCursorPos)	///Jasmine 09/21/2012 ORG-6759-P2 NO_NEED_UPDATE_CURSOR_POS_AFTER_LINK
	updateCursorPos();		///Jasmine 09/10/2012 ORG-6764-P1 UNNECESSERY_UPDATE_REWRITE_USER_INPUT_XVALUE
}

///Jasmine 01/18/10 CONFIGURE_SHOW_HIDE_SETTING
void GraphVerticalCursorDlg::showCursorInfos(const VCursorShow& cursorshow)
{
	int nColPos;
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_BOOKNAME);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.BookName);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_SHEETNAME);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.SheetName);
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_SHORTNAME);
	//if(nColPos > -1)
		//m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.ShortName);
	//
	//nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_LONGNAME);
	//if(nColPos > -1)
		//m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.LongName);
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NAME);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.Name);
	///end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_X_SCALE);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.CursorX);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_Y_SCALE);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.CursorY);
	
	///Jasmine 01/20/10 SHOW_NEAREST_POINT 		
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NEAREST_X);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.CursorNearX);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NEAREST_Y);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.CursorNearY);
	///End SHOW_NEAREST_POINT
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_INDEX);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.Index);	
		
	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.GraphName);	
	///End SUPPORT_MULTI_WINS_CURSOR
	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_STATUS);
	if(nColPos > -1)
		m_CursorDataInfoTable.HideCol(nColPos, !cursorshow.Status);	
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
}
///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
void GraphVerticalCursorDlg::checkUpdateShowCursorInfos()
{	
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
	///Sophy 10/10/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE	
	VCursorShow cursorOldSettings;
	cursorOldSettings = managerSetting.m_cursorshow;
	managerSetting.m_cursorshow.bModifiedOutside = false;
	///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	int nColPos;
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_BOOKNAME);	
	managerSetting.m_cursorshow.BookName 	= !m_CursorDataInfoTable.IsColHidden(nColPos);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_SHEETNAME);
	managerSetting.m_cursorshow.SheetName 	= !m_CursorDataInfoTable.IsColHidden(nColPos);
	///Sophy 8/11/2011 ORG-3106-S11 AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	//nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_SHORTNAME);
	//managerSetting.m_cursorshow.ShortName = !m_CursorDataInfoTable.IsColHidden(nColPos);
	//
	//nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_LONGNAME);
	//managerSetting.m_cursorshow.LongName 	= !m_CursorDataInfoTable.IsColHidden(nColPos);
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NAME);
	managerSetting.m_cursorshow.Name 		= !m_CursorDataInfoTable.IsColHidden(nColPos);
	////end AUTO_SHOW_LONGNAME_SHORTNAME_IN_INFO_TABLE
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NEAREST_X);
	managerSetting.m_cursorshow.CursorNearX = !m_CursorDataInfoTable.IsColHidden(nColPos);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_NEAREST_Y);
	managerSetting.m_cursorshow.CursorNearY = !m_CursorDataInfoTable.IsColHidden(nColPos);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_INDEX);
	managerSetting.m_cursorshow.Index 		= !m_CursorDataInfoTable.IsColHidden(nColPos);
	
	///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_GRAPHNAME);
	managerSetting.m_cursorshow.GraphName 	= !m_CursorDataInfoTable.IsColHidden(nColPos);
	///End SUPPORT_MULTI_WINS_CURSOR
	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_STATUS);
	managerSetting.m_cursorshow.Status 		= !m_CursorDataInfoTable.IsColHidden(nColPos);
	///End ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
	
	///Sophy 10/10/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	if ( 	cursorOldSettings.BookName 		!= managerSetting.m_cursorshow.BookName
		|| 	cursorOldSettings.SheetName 	!= managerSetting.m_cursorshow.SheetName
		|| 	cursorOldSettings.Name 			!= managerSetting.m_cursorshow.Name
		|| 	cursorOldSettings.CursorNearX	!= managerSetting.m_cursorshow.CursorNearX
		|| 	cursorOldSettings.CursorNearY	!= managerSetting.m_cursorshow.CursorNearY
		|| 	cursorOldSettings.Index 		!= managerSetting.m_cursorshow.Index
		|| 	cursorOldSettings.GraphName 	!= managerSetting.m_cursorshow.GraphName			///Jasmine 02/06/2012 ORG-4971 SUPPORT_MULTI_WINS_CURSOR
		|| 	cursorOldSettings.Status 		!= managerSetting.m_cursorshow.Status				///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
		)
	{
		managerSetting.m_cursorshow.bModifiedOutside = true;
	}
	///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	BOOL bRet = THE_VCURSOR_MANAGER.SetSetting(managerSetting);
}
///End CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
///End CONFIGURE_SHOW_HIDE_SETTING

void GraphVerticalCursorDlg::addTagInfoToTable( const VTagUnit& vTagUnit )
{
	const int nSigificantDigits = THE_VCURSOR_MANAGER.GetLabelsSignificantDigits();

	for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
	{
		VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
		
		vector<string> vsRowVals;
		vsRowVals.Add( vTagLabel.GetValidObj().GetUID() );

		vsRowVals.Add( ftoa_sd(vTagLabel.GetMarkedPointXScale(), nSigificantDigits) );
		vsRowVals.Add( ftoa_sd(vTagLabel.GetMarkedPointYScale(), nSigificantDigits) );
		vsRowVals.Add( vTagLabel.GetAttachedPlotName() );

		m_TagInfoTable.SetCells(vsRowVals, m_TagInfoTable.GetRows()-1, false);
	}
	m_TagInfoTable.ResizeCols();
}

//void GraphVerticalCursorDlg::removeTagInfoFromTable( const UINT uTagUID )
void GraphVerticalCursorDlg::removeTagInfoFromTable(const VTagUnit& vTagUnit)
{
	for(int ii = 0; ii < vTagUnit.m_arrTagLabels.GetSize(); ii++)
	{
		VTagLabel& vTagLabel = vTagUnit.m_arrTagLabels.GetAt(ii);
		string strTagUID = vTagLabel.GetValidObj().GetUID();
		const int nRow = m_TagInfoTable.FindRow(strTagUID);
		m_TagInfoTable.DeleteRow(nRow);
	}
}

BOOL GraphVerticalCursorDlg::shouldUpdateDialogDataForPage( UINT uPageUID )
{
	const BOOL bShouldUpdate = (!IsInitReady() || Visible) && THE_VCURSOR_MANAGER.IsPageCurrentTarget(uPageUID);
	return bShouldUpdate;
}

///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER
BOOL GraphVerticalCursorDlg::updatePointsIDs(UINT uPageUID)
{
	vector<string> vsPointIDs, vsPlotShow;
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_ID);
	m_CursorDataInfoTable.GetColValues(nColPos, vsPointIDs, m_CursorDataInfoTable.GetRowOffset() );
	
	///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
	//const GraphVerticalCursorHolder* pgvcHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(uPageUID);
	//if(pgvcHolder)
	//{
		//pgvcHolder->m_vsPointIDs = vsPointIDs;
		//return TRUE;
	//}
	vector<int> vnPlotShow, vnPlotHideFromGrid;
	///Sophy 9/16/2011 ORG-3106-P10 WRONG_SHOWHIDE_STATUS_AFTER_SORT_PLOT_COLUMN
	//m_CursorDataInfoTable.GetRowsHide(vnPlotShow);
	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	//vector<int> vnHides;
	//m_CursorDataInfoTable.GetRowsHide(vnHides);
	//vnPlotShow = 1 - vnHides;
	m_CursorDataInfoTable.GetRowsHide(vnPlotHideFromGrid);
	
	nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_STATUS);
	m_CursorDataInfoTable.GetColValues(nColPos, vsPlotShow, m_CursorDataInfoTable.GetRowOffset() );
	convert_string_vector_to_int_vector(vsPlotShow, vnPlotShow);
	///End NEW_MENU_TO_EXCLUDE_HIDE_PLOT
	///end WRONG_SHOWHIDE_STATUS_AFTER_SORT_PLOT_COLUMN
	
	VManagerSetting managerSetting;
	if( THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
	{
		managerSetting.m_cursorshow.vsPlotIDs 			= vsPointIDs;
		managerSetting.m_cursorshow.vnPlotShow 			= vnPlotShow;
		managerSetting.m_cursorshow.vnPlotHideFromGrid 	= vnPlotHideFromGrid;	///Jasmine 08/09/2012 ORG-6409-S1 NEW_MENU_TO_EXCLUDE_HIDE_PLOT
		return THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	}
	///End MENU_TO_HIDE_PLOT_FROM_DLG
	return FALSE;	
}
///End UPDATE_LIST_WITH_SORT_ORDER
	
///Jasmine 07/25/2011 ORG-3106-S5 MENU_TO_HIDE_PLOT_FROM_DLG
//0 offset, position of the plots in the grid
void GraphVerticalCursorDlg::showHidePlots(const vector<int>& vnChangePlot)
{
	VManagerSetting managerSetting;
	if( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return;
	
	vector<string> 	vsPlotIDs;
	vsPlotIDs 	= managerSetting.m_cursorshow.vsPlotIDs;
	vector<int> 	vnShow;
	vnShow 		= managerSetting.m_cursorshow.vnPlotShow;
	int nCount = vnShow.GetSize();
	
	vector<string> vsPointIDs;
	int nColPos = m_CursorDataInfoTable.GetColPos(TEXTLABELINFOGRIDCOLTYPE_ID);
	m_CursorDataInfoTable.GetColValues(nColPos, vsPointIDs, m_CursorDataInfoTable.GetRowOffset() );
	
	int nRet = 0;
	int nSize = vnChangePlot.GetSize(), nRowOffset = m_CursorDataInfoTable.GetRowOffset();
	for(int ii = 0; ii < nSize; ii++)
	{
		int nn = vnChangePlot[ii];
		if(nn >= nCount)
			continue;
		
		//hide row in table
		//assum vsPlotIDs is always same as vsPointIDs
		///Sophy 8/9/2011 ORG-3106-S5 MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
		//if(lstrcmpi(vsPlotIDs[nn], vsPointIDs[nn]) != 0)
		if ( nn < vsPlotIDs.GetSize() && nn < vsPointIDs.GetSize() && lstrcmpi(vsPlotIDs[nn], vsPointIDs[nn]) != 0 )
		///end MORE_WORK_ON_MENU_TO_HIDE_PLOT_FROM_DLG
		{
			ASSERT(0);
			continue;			
		}
		int 	nRow	= nn + nRowOffset;
		bool	bShow 	= vnShow[nn];
		//m_CursorDataInfoTable.SetIsRowHidden(nRow, !bShow);	///Jasmine 08/08/2012 ORG-6409-S1 ADD_STATUS_COL_TO_INCLUDE_EXCLUDE_PLOT
		
		//hide label object
		UINT uid = atof(vsPlotIDs[nn]);
		///Sophy 8/11/2011 ORG-3106-S5 PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
		//bool bRet = THE_VCURSOR_MANAGER.ShowTextLabel(0, uid, bShow);
		bool bRet = THE_VCURSOR_MANAGER.ShowPlotTextLabel(0, uid, bShow);
		///end PROPER_SHOWHIDE_LABEL_OBJ_BY_UID
		nRet =+ (int)bRet;
	}
	
	if(nRet > 0)
		THE_VCURSOR_MANAGER.GraphRefresh();
}
///End MENU_TO_HIDE_PLOT_FROM_DLG

///------ Folger 02/08/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
BOOL	GraphVerticalCursorDlg::DumpData()
{
	bool bRet;
	if ( m_BottomTab.GetCurSel() == TAG_INFO_TAB )
		bRet = THE_VCURSOR_MANAGER.DumpTagValues();//DumpData();
	else
		bRet = THE_VCURSOR_MANAGER.DumpCursorValues();

	if(bRet)
		enableActivateBtn(true);		///Jasmine 01/22/10 BTN_TO_ACTIVATE_OUTPUT_WKS

	return bRet;
}

///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
BOOL 	GraphVerticalCursorDlg::GetTreeFromGraph(UINT uidLine, TreeNode& trGraphTree)
{
	GraphObject goLine;
	GraphPage 	gp;
	GraphLayer 	gl;
	goLine = (GraphObject)Project.GetObject(uidLine);
	if(goLine)
		goLine.GetParent(gl);
	if(gl)
		gp = gl.GetPage();	
	
	BOOL bRet = TRUE;	
	if( !gp || !gp.GetBinaryStorage(STR_VERTICAL_CURSOR_SETTINGS, trGraphTree) )
		bRet = GetGUITree(trGraphTree);
	
	trGraphTree.XValue.dVal = getInputXValue();
	return bRet;
}

BOOL 	GraphVerticalCursorDlg::SetGraphTree(TreeNode& trGraphTree)
{
	BOOL bRet;
	string strXFName;
	if(trGraphTree.GetAttribute(STR_XFUNCTION_NAME_ATTRIB, strXFName))
		bRet = SetGUITree(trGraphTree);
	else
	{
		VManagerSetting managerSetting;
		managerSetting.LoadFromGraphTree(trGraphTree);
		bRet = THE_VCURSOR_MANAGER.SetSetting(managerSetting);
	}
	
	if(trGraphTree.XValue)
	{
		m_dXValue = trGraphTree.XValue.dVal;
		PostMessage(WM_USER_MOVE_LINE);
	}
	
	return bRet;
}

BOOL	GraphVerticalCursorDlg::OnMoveLine(DWORD wParam, DWORD lParam)
{
	setInputXValue(m_dXValue);		
	Control junk;
	return OnMoveLineTo(junk);
}
///End PASS_MORE_INFO_TO_LINKED_GRAPH

BOOL	GraphVerticalCursorDlg::GetGUITree(TreeNode& trGUI)
{
	VManagerSetting managerSetting;
	if ( !THE_VCURSOR_MANAGER.GetSetting(managerSetting) )
		return FALSE;

	Tree trSettingGUI;
	if ( !constructSettingGUITree(trSettingGUI, managerSetting) )
		return FALSE;

	trGUI = trSettingGUI.trGUI.Clone();
	return TRUE;
}

BOOL	GraphVerticalCursorDlg::SetGUITree(TreeNode& trGUI)
{
	return ApplyToolSettings(trGUI);
}

BOOL	GraphVerticalCursorDlg::LoadTheme(LPCSTR lpcszTheme)
{
	Tree	trGUI;
	if ( !GetGUITree(trGUI) )
		return FALSE;

	return theme_update_on_new_sel(trGUI, lpcszTheme) && ApplyToolSettings(trGUI);
}

BOOL	GraphVerticalCursorDlg::SaveTheme(LPCSTR lpcszTheme)
{
	Tree	trGUI;
	if ( !GetGUITree(trGUI) )
		return FALSE;

	string		strClassOption;
	theme_get_class_option(trGUI, strClassOption);
	return theme_save_settings(trGUI, okutil_theme_get_settings_file(lpcszTheme, strClassOption));
}
///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
//BOOL	GraphVerticalCursorDlg::OnGrObjChange(GraphObject gr, int nEvent)
BOOL	GraphVerticalCursorDlg::OnGrObjChange(GraphObject gr, int nEvent, int nCtrl)
///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
{
	if ( gr.GetName().Find(STR_VGRAPH_LINE_NAME_PREFIX) == 0 )
	{
		if ( OE_MOVE == nEvent )
		{
			///Sophy 9/13/2012 ORG-6504-P1 GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
			THE_VCURSOR_MANAGER.SetLastMovedByKey(TMC_KEY == nCtrl);
			///end GROBJ_MOVE_EVENT_FROM_KEY_OR_MOUSE_INFO
			THE_VCURSOR_MANAGER.SetLinePosition(gr.X);
	}
	}

	return FALSE;
}
///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR

///------ Folger 07/27/2012 ORG-6339-P1 SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
OUID GraphVerticalCursorDlg::VLine()
{
	GraphVerticalCursorHolder* pHolder = THE_VCURSOR_MANAGER.GetCursorHolderPointer(0);
	if ( pHolder )
		return pHolder->m_line.GetValidObj().GetUID();

	return 0;
}
///------ End SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH

///------ Folger 08/24/2012 ORG-6633-P1 REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY
BOOL GraphVerticalCursorDlg::OnPageDestroy(Page pg, DWORD dwCntrl)
{
	OUID uidPage = pg.GetUID();
	if ( 0 != uidPage )
		return THE_VCURSOR_MANAGER.RemoveVerticalCursor(pg.GetUID());

	return 0;
}
///------ End REMOE_PAGE_FROM_VERTICAL_CURSOR_WHEN_PAGE_DESTROY_BUT_NOT_WINDOW_DESTROY

/*----------------------------------------------------------------------------*/
/* Public interface of GraphVerticalCursorDlg
/*----------------------------------------------------------------------------*/

///------ Folger 02/21/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
//BOOL VerticalCursorDlg(BOOL bRemoveActiveCursorAndHideDlg = FALSE)
BOOL VerticalCursorDlg(BOOL bRemoveActiveCursorAndHideDlg = FALSE, TreeNode* ptrGUI = NULL)
///------ End GLOBAL_GADGET_MANAGER
{
	if (bRemoveActiveCursorAndHideDlg)
	{
		if (s_pVerticalCursorDlg)
		{
			s_pVerticalCursorDlg->SendMessage(WM_CLOSE);
		}
		return TRUE;
	}

	// FALSE == bRemoveActiveCursorAndHideDlg now
	BOOL bRet = FALSE;
	if ( s_pVerticalCursorDlg )
	{
		if ( s_pVerticalCursorDlg->Visible )
			return FALSE;
		bRet = s_pVerticalCursorDlg->StartVerticalCursor();
		if (bRet)
			s_pVerticalCursorDlg->UpdateDialogData();
		s_pVerticalCursorDlg->Visible = bRet;
	}
	else
	{
		if ( !THE_VCURSOR_MANAGER.CanStartVerticalCursor() )
			return FALSE;
		s_pVerticalCursorDlg = new GraphVerticalCursorDlg;
		if (s_pVerticalCursorDlg)
			bRet = s_pVerticalCursorDlg->Create( GetWindow() );

		if (!bRet)
			return error_report("Failed to create the tool window!", true);
	}
	///------ Folger 02/21/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
	if ( ptrGUI )
		s_pVerticalCursorDlg->SetGraphTree(*ptrGUI);//s_pVerticalCursorDlg->SetGUITree(*ptrGUI);	///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
	///------ End GLOBAL_GADGET_MANAGER
	return bRet;
}

/*----------------------------------------------------------------------------*/
/* For initializing the GraphVerticalCursorManager's holder, creating/showing the dialog, etc.
/*----------------------------------------------------------------------------*/

BOOL CheckInitVerticalCursorAndExecEvent(int nEvent, const string strObjectName, int nObjType)
{
	///Jasmine 06/28/2011 ORG-3106-P1 MAKE_DUPLICATE_GRAPH_VALID_FOR_CURSOR
	///------ Folger 07/30/2012 ORG-6340-P1 ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	//if(	VCOT_LINE == nObjType && !THE_VCURSOR_MANAGER.HasCursorHolderForPage() )
	if(	VCOT_LINE == nObjType && !THE_VCURSOR_MANAGER.HasCursorHolderForPage() && !THE_VCURSOR_MANAGER.IsCursorStarting() )
	///------ End ORIGIN_CRASH_WHEN_ADD_VERTICAL_CURSOR_TO_LINKED_GRAPH
	{
		///------ Folger 08/02/2012 ORG-6421-P1 VERTICAL_CURSOR_RUNTIME_ERROR_AFTER_OPEN_EXPORT_GRAPH
		GraphLayer gl = Project.ActiveLayer();
		GraphPage gpActive;
		if ( gl )
			gl.GetParent(gpActive);

		if ( !gpActive )
			return FALSE;

		if ( (get_gp_noclick(gpActive) & NOCLICK_BUTTONS) || gpActive.TestFlag(PGDWNS_PLOT_EXCLUDED_FROM_MANAGER) )
			return FALSE;
		///------ End VERTICAL_CURSOR_RUNTIME_ERROR_AFTER_OPEN_EXPORT_GRAPH
		
		if(s_pVerticalCursorDlg && s_pVerticalCursorDlg->Visible)
			s_pVerticalCursorDlg->Visible = false;
		
		Tree trProperties;
		if( !gpActive.GetBinaryStorage(STR_VERTICAL_CURSOR_BINARY_STORAGE_NAME, trProperties) )
			return FALSE;
		
		BOOL bRet = VerticalCursorDlg();
		
	}
	///End MAKE_DUPLICATE_GRAPH_VALID_FOR_CURSOR
	if (OE_SELECT == nEvent || OE_MOVE == nEvent || OE_MOVING == nEvent || OE_RESIZE == nEvent || OE_SCALE_CHANGE == nEvent)
	{
		const int nLoadCursorResult = THE_VCURSOR_MANAGER.LoadCursorInfoFromPage();
		switch (nLoadCursorResult)
		{
		case LOAD_CURSOR_INFO_FAILED:
			MY_DBG_OUTPUT1("Failed to load the cursor holder info at event %d", nEvent);
			return FALSE;
			break;
		case LOAD_CURSOR_INFO_OK:
			MY_DBG_OUTPUT1("Successfully loaded the cursor holder info at event %d", nEvent);
			break;
		case CURSOR_INFO_EXIST_IN_MANAGER:
			break;
		}
		BOOL bRet = VerticalCursorDlg();
	}
	BOOL bRet = on_vertical_cursor_object_event(nEvent, strObjectName, nObjType);
	return bRet;
}

/*----------------------------------------------------------------------------*/
/* For debugging use only
/*----------------------------------------------------------------------------*/

///------ Folger 02/07/2012 ORG-4970 LT_GADGET_SUPPORT_VERTICAL_CURSOR
int	verticalcursor_msg(LPVOID lpMsgInfo)
{
	LTVarTempChange junk("@PTOC", 1);

	GadgetMsgPtr	pMsgInfo = (GadgetMsgPtr)lpMsgInfo;
	int				nReturn = -1;
	switch ( pMsgInfo->nMessage )
	{
	case GGT_DOOUTPUT:
		if ( s_pVerticalCursorDlg )
		{
			nReturn = s_pVerticalCursorDlg->DumpData();
		}
		break;

	case GGT_GETGUITREE:
		if ( s_pVerticalCursorDlg )
		{
			TreeNode*	ptrGUITree = (TreeNode*)(ODWP)pMsgInfo->lpMoreInfo;
			nReturn = s_pVerticalCursorDlg->GetGUITree(*ptrGUITree);
		}
		break;

	case GGT_SETGUITREE:
		if ( s_pVerticalCursorDlg )
		{
			TreeNode*	ptrGUITree = (TreeNode*)(ODWP)pMsgInfo->lpMoreInfo;
			nReturn = s_pVerticalCursorDlg->SetGUITree(*ptrGUITree);
		}
		break;

	case GGT_LOADTHEME:
		if ( s_pVerticalCursorDlg )
		{
			nReturn = s_pVerticalCursorDlg->LoadTheme((LPCSTR)pMsgInfo->lpMoreInfo);
		}
		break;

	case GGT_SAVETHEME:
		if ( s_pVerticalCursorDlg )
		{
			nReturn = s_pVerticalCursorDlg->SaveTheme((LPCSTR)pMsgInfo->lpMoreInfo);
		}
		break;

	default:
		O_A_FAIL;
		return -1;
	}

	return nReturn;
}
///------ End LT_GADGET_SUPPORT_VERTICAL_CURSOR

///------ Folger 02/21/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
int	GlobalGadget_verticalcursor(int nMsg, WPARAM wParam, LPARAM lParam)
{
	LTVarTempChange junk("@PTOC", 1);
	int				nReturn = -1;

	switch ( nMsg )
	{
	case GLOBALGADGET_GET_SETTING:
		if ( s_pVerticalCursorDlg )
		{
			TreeNode*	ptrGUITree = (TreeNode*)lParam;
			///Jasmine 09/21/2012 ORG-6759-P1 PASS_MORE_INFO_TO_LINKED_GRAPH
			//nReturn = s_pVerticalCursorDlg->GetGUITree(*ptrGUITree);
			UINT uidLine = (UINT)wParam;
			nReturn = s_pVerticalCursorDlg->GetTreeFromGraph(uidLine, *ptrGUITree);
			///End PASS_MORE_INFO_TO_LINKED_GRAPH
		}
		break;

	case GLOBALGADGET_CAN_CREATE_GADGET:
		return NULL == s_pVerticalCursorDlg || !s_pVerticalCursorDlg->Visible;

	case GLOBALGADGET_CREATE_GADGET:
		if ( GlobalGadget_verticalcursor(GLOBALGADGET_CAN_CREATE_GADGET, 0, 0) )
		{
			TreeNode*	ptrGUITree = (TreeNode*)lParam;
			if ( VerticalCursorDlg(FALSE, ptrGUITree) )
			{
				nReturn = s_pVerticalCursorDlg->VLine();
			}
			else
			{
				nReturn = 0;
			}
		}
		break;

	///------ Folger 07/30/2012 ORG-6339-P1 SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	case GLOBALGADGET_UPDATE_DATA:
		if ( s_pVerticalCursorDlg )
			s_pVerticalCursorDlg->UpdateDialogData();
		nReturn = 0;
		break;

	default:
		break;
	///------ End SHOW_LINKED_ICON_ON_GLOBAL_GADGET_LINKED_GRAPH
	}

	return nReturn;
}
///------ End GLOBAL_GADGET_MANAGER


#ifdef _DEBUG
void DestroyVerticalCursorDlg()
{
	if (s_pVerticalCursorDlg)
	{
		s_bDestroyDlgOnClose = TRUE;
		VerticalCursorDlg(TRUE);
	}
	THE_VCURSOR_MANAGER.ClearAllCursorHolders();
}

void ShowAllCursorPropertiesTree()
{
	THE_VCURSOR_MANAGER.ShowPropertiesTree();
}

void ShowCurrentPageCursorBinaryTree()
{
	GraphLayer glActive = Project.ActiveLayer();
	if (glActive)
	{
		GraphPage gp = glActive.GetPage();
		if (gp)
		{
			CStopWatch watch("ShowCurrentPageBinaryTree()");
			Tree trProperties;
			BOOL bRet = gp.GetBinaryStorage(STR_VERTICAL_CURSOR_BINARY_STORAGE_NAME, trProperties);
			out_tree(trProperties);
		}
	}
}
#endif // _DEBUG






