/*------------------------------------------------------------------------------*
 * File Name:TreeEditSaveSetting.h												*
 * Creation: Danice 6/15/2004													*
 * Purpose: OriginC Header file for InputData branch in TreeEditControl			*
 * Copyright (c) Originlab Corp. 		2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 6/15/04 QA70-6222 GETNTREE_CONTEXT_MENU_MORE_SETTING					*
 *  Danice v8.0890 6/16/04 QA70-6222 COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING		*
 *	Forest 09/14/04 QA70-6682	SETTINGS_THEME_FILE_SAVE_LOAD                   *
 *  Forest 09/15/04 QA70-6682	USING_FAN_OUT_MENU_LOAD							*
 *	Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME					*
 *------------------------------------------------------------------------------*/
#ifndef _TREEEDIT_SAVE_SETTINGS_H
#define _TREEEDIT_SAVE_SETTINGS_H
///Danice COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING
/*
///Frank 6/15/04 QA70-6222 GETNTREE_CONTEXT_MENU_MORE_SETTING	
enum
{
	SETTINGS_COPY ,
	SETTINGS_PASTE 
};
///---End GETNTREE_CONTEXT_MENU_MORE_SETTING
*/
///end COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING

//#include <operation.h>	//Forest 9/15/04

enum{
	SETTING_SAVE = 0, 				//Save Settings As...
	//SETTING_SET_AS_DEFAULT = 0, //Set As Default
	SETTING_RESET_TO_DEFAULT,	//Reset to Default
	SETTING_SEPARATOR_0,
	SETTING_COPY,				//Copy
	SETTING_PASTE,				//Paste
	//SETTING_BY_USER_SAVING		//
	SETTING_SEPARATOR_1,
	SETTING_LOAD
};

class TreeEditSaveSettingMenu : public MenuBase
{
public:
	//strThemeFilePrefix is Classname + nOption, e.g. "DescStats_1" or "DescStats" etc
	//if it's null, context menu "Reset Branch to Factory Default" is disable
	TreeEditSaveSettingMenu(TreeNode& trInputData, int nRow, int nCol, string strThemeFilePrefix)	:	MenuBase()
	{
		m_strThemeFilePrefix = strThemeFilePrefix;
		m_trInputData = trInputData;
		string strNodeID;
		m_trInputData.GetAttribute(STR_DATAID_ATTRIB, strNodeID);

		m_vsSaveFile.SetSize(0);
		
		//bool bHasDefault, bHasCopy;
		///Forest 09/14/04 QA70-6682	SETTINGS_THEME_FILE_SAVE_LOAD
		//m_strDefaultFile = TREE_PROPERTY_SAVE_PATH + strNodeID + "-Default.ois";
		//m_strCopyToFile = TREE_PROPERTY_SAVE_PATH + strNodeID + "-Copy.ois";
		//m_strDefaultFile = TREE_PROPERTY_SAVE_PATH + THEME_FILENAME_BRANCH_PREFIX + "-" + strNodeID + "-" + THEME_FILENAME_DEFAULT + ".ois";
		//-------- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
		//m_strCopyToFile = TREE_PROPERTY_SAVE_PATH + THEME_FILENAME_BRANCH_PREFIX + "_" + strNodeID + "-" + THEME_FILENAME_COPY + ".ois";
		m_strCopyToFile = getCopyThemeFullPathFilename(strNodeID);
		//--------
		///End SETTINGS_THEME_FILE_SAVE_LOAD
		//if(!GetFilePath(m_strDefaultFile).IsPath())
		//	return;
		
		//Check if default setting file exist
		//bHasDefault = m_strDefaultFile.IsFile();
		bool bHasCopy = m_strCopyToFile.IsFile();
		
		//Add(_L("Set As Default Settings"), OnMenuItem);
		//Add(_L("Reset To Default Settings"), OnMenuItem, bHasDefault ? MF_ENABLED : MF_GRAYED | MF_DISABLED);
		//Add(_L("Save Settings As..."), OnMenuItem);
		Add( _L("Save Branch Settings As..."), OnMenuItem );
		bool	bHasFactoryDefault = !m_strThemeFilePrefix.IsEmpty();
		Add( _L("Reset Branch to Factory Default"), OnMenuItem, bHasFactoryDefault ? MF_ENABLED : MF_GRAYED | MF_DISABLED );
		Add( NULL, OnMenuItem );
		///Danice COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING
		Add(_L("Copy Branch Settings"), OnMenuItem);
		Add(_L("Paste Branch Settings"), OnMenuItem, bHasCopy ? MF_ENABLED : MF_GRAYED | MF_DISABLED);
		///end COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING
		

		//search for .ois file
		addBranchThemeFiles(strNodeID);
	}
	
	int DoTrackPopup(int nx, int ny, HWND hWndParent);
	
private :
	string askSaveFileName(HWND hWndParent);
	string getCopyThemeFullPathFilename(const string& strNodeID);
	void addBranchThemeFiles(const string& strNodeID);
	bool loadBranchThemeFile(int nCmd);
private :
	TreeNode		m_trInputData;
	//---- CPY 10/9/04 THEME_RELATED_CODE_MOVED_TO_GETNBOX_C
	//string			m_strDefaultFile;
	// the following was commented out, but that will lead to compile problem
	vector<string>	m_vsSaveFile;
	//---- end THEME_RELATED_CODE_MOVED_TO_GETNBOX_C
	string			m_strCopyToFile;
	string			m_strThemeFilePrefix;
};
///END RIGHT_CLICK_ACCESS


///Danice 6/16/04 v8.0890 QA70-6222 COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING
/*
///----Frank 6/15/04 QA70-6222 GETNTREE_CONTEXT_MENU_MORE_SETTING	
class TreeEditCopySettingMenu : public MenuBase
{
public:
	TreeEditCopySettingMenu(TreeNode& trInputData, int nRow, int nCol)	:	MenuBase()
	{
		m_trInputData = trInputData;
		string strNodeID;
		m_trInputData.GetAttribute(STR_DATAID_ATTRIB, strNodeID);

		bool bHasDefault;
		m_strDefaultFile = TREE_PROPERTY_SAVE_PATH + strNodeID + "-Default.ois";
		
		if(!GetFilePath(m_strDefaultFile).IsPath())
			return;
		
		//Check if default setting file exist
		bHasDefault = m_strDefaultFile.IsFile();
		
		Add(_L("Copy Settings"), OnMenuItem);
		Add(_L("Paste Settings"), OnMenuItem, bHasDefault ? MF_ENABLED : MF_GRAYED | MF_DISABLED);
	}
	
	void DoTrackPopup(int nx, int ny, HWND hWndParent, bool &bNeedUpdateValue)
	{
		TrackPopupMenu(0,  nx, ny, hWndParent);
		int nCmd;
		if(!GetCommand(nCmd))
			return;
		bNeedUpdateValue = false;
		vector<int> vnIDs;
		vector<string> vsValues;
		string strFullFileName;
		
		switch(nCmd)
		{
		case SETTINGS_PASTE:
			bool bReadValue = tree_read_values_with_ids(m_strDefaultFile, vnIDs, vsValues);
			tree_set_values_by_ids(m_trInputData, vnIDs, vsValues);
			
			bNeedUpdateValue = true;
			if(bReadValue)
				DeleteFile(m_strDefaultFile);
			//return UpdateGridValues(false, false, false);
			break;
			
		case SETTINGS_COPY:
			tree_get_values_with_ids(m_trInputData, vnIDs, vsValues);
			tree_save_values_with_ids(m_strDefaultFile, vnIDs, vsValues);
			
			break;
			
		default :	
			tree_read_values_with_ids(m_strDefaultFile, vnIDs, vsValues);
			tree_set_values_by_ids(m_trInputData, vnIDs, vsValues);
			
			bNeedUpdateValue = true;
			break;
			//return UpdateGridValues(false, false, false);
		}
	}

private :
	TreeNode		m_trInputData;	
	string			m_strDefaultFile;
};
///---End		GETNTREE_CONTEXT_MENU_MORE_SETTING
*/
///end COMBINE_TREEEDIT_SAVE_AND_COPY_SETTING



#endif //_TREEEDIT_SAVE_SETTINGS_H
