/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*		
 *	Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT				`	*
 *	Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX	*
 *	Tony 07/12/2012 ORG-2840-P5 VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH			*
 *	Tony 07/24/2012 ORG-6330-S1 CANCEL_CHANGE_TO_CLOSE_AFTER_TRANSFER			*
 *	Tony 07/24/2012 ORG-6330-S2 OUTPUT_FILEPATH_TO_MESSAGE_LOG_AFTER_OPX		*
 *	Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT			*
 *	Tony 07/26/2012 ORG-6330-S6 ADD_GRAY_AFTER_SHOW_CURRENT						*
 *	Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES							*
 *	Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER	 	*
 *	Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON					*
 *	Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER		*
 *	Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS				*
 *	Tony 08/01/2012 ORG-2840-P6 SHOW_USERFILES_UPDATE_ON_VIEW_CHECK_CHANGE	*
 *	Tony 08/01/2012 ORG-6330-S5 GRAY_FIELS_AFTER_TANSFER						*
 *	Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT			*
 *	Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG	*
 *	Tony 08/06/2012 ORG-6330-S5 TRANSFERRED_FILES_SHOULD_BE_GRAY_WHEN_CHECK_SHOW_CURRENT_FILES_LIST	*
 *	Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE	*
 *	Tony 08/07/2012 ORG-6414-P1 SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE	*
 *	Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION	*
 *	Tony 08/20/2012 ORG-6330-S3 EXPORT_FILES_SHOULD_NOT_INCLUDE_PREVIEW_FILES	*
 *	Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT			*
 *	Tony 08/22/2012 ORG-6330-P2 SHOULD_NOT_UPDATE_SOURCE_LIST_WHEN_SPECIAL_FLODER_IS_EMPTY	*
 *	Tony 08/22/2012 ORG-6330-S5 STATUS_SAME_CURRENT_SHOULD_NOT_CHANGE_BY_CHECK_SHOW_USER_FILES	*
 *	Tony 08/22/2012 ORG-6616-P1 PUT_THE_CHECKBOX_A_BETTER_PLACE				*
 *	Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP	*
 *	Tony 08/30/2012 ORG-6686-P1 CORRECT_WITH_NEW_FILESINFO						*
 *	Tony 09/07/2012 ORG-6762-P1 ENABLE_PUBLISH_BUTTON_AFTER_DELETE			*
 *	Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER						*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <Array.h>
#include "FilePublish.h"
#include "TransferFilesDlg.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

#define STR_DLG_NAME						_L("Group Folder Manager")
#define STR_DLG_NAME_TRANSFER_USER_FILES	_L("Transfer User Files")

///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
#define STR_GROUP_FOLDER			_L("Group folder")
#define STR_GROUP_FOLDER_FILE_LIST	_L("Group Folder File List")
#define STR_TRANSFER_FILE_LIST		_L("Transfer File List")
///------End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

#define STR_SPECIFIED_FOLDER		_L("Specified Folder")
///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//#define STR_SOURCE_GRID_HEADER		_L("File Name|File Category|File Type|File Size|Modified Date")
#define STR_SOURCE_GRID_HEADER		_L("File Name|File Name(Specified)|File Category|File Type|File Size|Modified Date")
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
//#define STR_SELECTED_GRID_HEADER	_L("File Name|File Category|Status|RegKey")
#define STR_SELECTED_GRID_HEADER	_L("File Name|File Name(Specified)|File Category|File Type|File Size|Modified Date|Status|Registry Key")
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

#define STR_PUBLISH					_L("Publish")		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

#define STR_SECTION					"UpdateInfo"		///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
#define STR_VERSION					"version"			///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
#define STR_IS_PUBLISHED			"IsPublished"		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

#define STR_CURRENT_LOCATION		_L("Current Location")		///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

#define STR_BTN_NAME_CLOSE			_L("Close")		///------ Tony 07/24/2012 ORG-6330-S1 CANCEL_CHANGE_TO_CLOSE_AFTER_TRANSFER
// for registry
#define STR_LAST_SPECIFIED_LOCATION "LastLocation"
#define STR_CHECK_BOX				"CheckBox"
#define STR_USER_SPECIFIED_FOLDER	"SpecifiedFolder"

#define FILE_NAME_WIDTH				2000
#define FILE_SELECTED_LIST_WIDTH	2500

#define BE_RECURSIVE	-1		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
#define NOT_RECURSIVE	0		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

enum {
	COL_FILE_NAME,
	COL_FILE_NAME_SPECIFIED,		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	COL_FILE_CATEGORY,
	COL_FILE_TYPE,
	COL_FILE_SIZE,
	COL_FILE_DATE,
};

enum {
	COL_SELECTED_LIST_FILE_NAME,
	COL_SELECTED_LIST_FILE_NAME_SPECIFIED,		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	COL_SELECTED_LIST_FILE_CATEGORY,
	COL_SELECTED_LIST_FILE_TYPE,		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	COL_SELECTED_LIST_FILE_SIZE,		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	COL_SELECTED_LIST_FILE_DATE,		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	COL_SELECTED_LIST_FILE_STATUS,
	COL_SELECTED_LIST_FILE_REG_KEY,
};

enum {
	STATUS_NEW,
	STATUS_NEWER,
	STATUS_OLDER,
	STATUS_SAME,
	STATUS_CURRENT,
	STATUS_PREVIEW, //for preview, should not be moved, only can be deleted
};
enum {
	LOCATION_OTHER		= 0x0001,
	LOCATION_CURRENT	= 0x0002,
};
#define STR_STATUS_NEW		_L("New File")
#define STR_STATUS_NEWER	_L("Newer than current")
#define STR_STATUS_OLDER	_L("Older than current")
#define STR_STATUS_SAME		_L("Same as current")
#define STR_STATUS_CURRENT	_L("Current")
#define STR_STATUS_PREVIEW	("") //make empty
///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
#define	COLOR_DARKGREEN						RGB(0, 100, 0)
#define	STR_COLOR_HINT_RED					_L("Red : newer")
#define	STR_COLOR_HINT_GREEN				_L("Green : older")
#define	STR_COLOR_HINT_BLUE					_L("Blue : identical")
///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT

static bool _is_opx_file(LPCSTR lpcszFile)
{
	string strOPXExt = STR_PACKAGE_80_EXT;
	string strExt;
	separate_file_name_ext(lpcszFile, NULL, &strExt);
	return strOPXExt.CompareNoCase("." + strExt) == 0 ? true : false;
}

static int _compare_file_status(LPCSTR lpcszOldVer, LPCSTR lpcszCurrent)
{
	if (!_stricmp(lpcszOldVer, lpcszCurrent))
		return STATUS_CURRENT;
	
	int nRet = 0;
	if (_is_opx_file(lpcszOldVer))
		nRet = opx_file_version_compare(lpcszOldVer, lpcszCurrent);
	else	
		nRet = file_last_modified_time_compare(lpcszOldVer, lpcszCurrent);
	
	switch (nRet)
	{
	case -1:		
		return STATUS_OLDER;
		
	case 0:
		return STATUS_SAME;
		
	case 1:
		return STATUS_NEWER
	}
	
	return STATUS_NEW;
}

static string _get_status_string(int nStatus)
{
	switch (nStatus)
	{
	case STATUS_NEW:
		return STR_STATUS_NEW;
		
	case STATUS_NEWER:
		return STR_STATUS_NEWER;
		
	case STATUS_OLDER:
		return STR_STATUS_OLDER;
		
	case STATUS_SAME:
		return STR_STATUS_SAME;
		
	case STATUS_CURRENT:
		return STR_STATUS_CURRENT;	
	case STATUS_PREVIEW:
		return STR_STATUS_PREVIEW;
	}
	
	return "";
}

///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
class UseEllipsisCutTextHelper
{
public:
	bool GetText(const DeviceContext &dc, int nWidthAfterCut, string &strText)
	{
		if(strText.IsEmpty() || nWidthAfterCut <= 0)
			return false;
		
		return editText(dc, nWidthAfterCut, strText);
	}
private:
	// this algorithm can be improve, such as use binary chop
	bool editText(const DeviceContext &dc, int nWidth, string &strText)
	{
		int nPathLen = strText.GetLength();
		for(int ii = nPathLen-1; ii >= 0; ii--)
		{
			SIZE szPath;
			szPath = dc.GetTextExtent(strText);
			if(szPath.cx <= nWidth)
				break;
			
			strText.Delete(ii);
		}
		
		return nPathLen != strText.GetLength();
	}
};
///------ End CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP

/************************************************************************
*   TransferHelper											    		*
*************************************************************************/

TransferHelper::TransferHelper()
{
	m_FilePublishMap.SetAsOwner(TRUE);
	m_pSpecFliePublish = NULL;
}

TransferHelper::~TransferHelper()
{
	NICE_SAFE_REMOVAL(m_pSpecFliePublish);
}
///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
//bool TransferHelper::GetFileInfo(DWORD dwFileType, LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFiles, vector<string> & vsFileInfo, bool bSource)
bool TransferHelper::GetFileInfo(DWORD dwFileType, LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFiles, vector<string> & vsFileInfo, bool bSource)
///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
{
	vector<int> vnFileType;
	convertFileType(dwFileType, vnFileType);

	vector<string> m_vsAllFileTypeName;
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OGW);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DIALOG_THEME);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_FUNCTION_THEME);	///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT	
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_FDF);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_IMPORT_FILTER);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OGS);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DATABASE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_ORIGINC);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PACKAGE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_TEMPLATE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PATCH);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PROJECT);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_THEME);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_XF);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OMC);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DEFAULT_SETTINGS);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_TEXT_FILE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PAL_FILE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_USERBUTTONS);///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OTHER_FILE);
	
	for (int i = 0 ; i < vnFileType.GetSize() ; ++i)
	{
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//FilePublishBase * pFilePublish = create_file_publish(vnFileType[i], m_bGroupManager, lpcszRegKey, lpcszSpecPath)
		FilePublishBase * pFilePublish = create_file_publish(vnFileType[i], m_bGroupManager, lpcszRegKey, lpcszSpecPath, m_nRecursive);
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		
		if (pFilePublish == NULL)
			continue;
		
		vector<string> vsSubFiles;
		pFilePublish->GetFiles(bSource, vsSubFiles);
		vsFiles.Append(vsSubFiles);
		
		for (int j = 0 ; j < vsSubFiles.GetSize() ; ++j)
		{
			vector<string> vsSubInfo;
			pFilePublish->GetRowInfo(vsSubFiles[j], vsSubInfo, bSource);
			vsSubInfo[COL_FILE_TYPE] = m_vsAllFileTypeName[vnFileType[i]];
			vsFileInfo.Append(vsSubInfo);
		}		

		NICE_SAFE_REMOVAL(pFilePublish);
	}

	return true;
}

void TransferHelper::GetCurrentFileStatus(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsSourceFilesPath, vector<string> & vsCurrentFilesPath, vector<int> & vnStatus)
{
	vnStatus.SetSize(0);
	
	ASSERT(vsRegKey.GetSize() == vsSourceFilesPath.GetSize());
	
	string strSourceFile;
	string strCurrentFile;	
	for (int i = 0 ; i < vsSourceFilesPath.GetSize() ; ++i)
	{
		FilePublishBase * pFilePublish = getFilePublish(vsRegKey[i], lpcszSpecPath);
		if (pFilePublish == NULL)
			continue;
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//strSourceFile = strCurrentFile = vsFilesPath[i];
		strSourceFile = vsSourceFilesPath[i];
		strCurrentFile 	= vsCurrentFilesPath[i];
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		pFilePublish->GetFileFullPath(strSourceFile, strCurrentFile);
		vnStatus.Add(_compare_file_status(strSourceFile, strCurrentFile));
	}	
}

void TransferHelper::GetDestPath(string &strDestPath)
{
	string strSourcePath;
	FilePublishBase * pFilePublish = getFilePublish("", "");
	if (pFilePublish == NULL)
		return;
	pFilePublish->GetFileFullPath(strSourcePath, strDestPath);
}

///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
//int TransferHelper::TransferFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFilePath)
int TransferHelper::TransferFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFilePath, bool bSource /* = true*/, vector<string> & vsTransferredFiles/* = NULL */, vector<string> & vsTransferredRegKey/* = NULL */)
///------ End SHOW_TRANSFERRED_FILES
{
	ASSERT(vsRegKey.GetSize() == vsFilePath.GetSize());
	
	vector<string> vsFile;
	int nFileTranfered = 0;
	for (int i = 0 ; i < vsRegKey.GetSize() ; ++i)
	{		
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//FilePublishBase * pFilePublish = getFilePublish(vsRegKey[i], lpcszSpecPath);
		FilePublishBase * pFilePublish = getFilePublish(vsRegKey[i], lpcszSpecPath, m_nRecursive);
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		if (pFilePublish == NULL)
			continue;
		
		vsFile.SetSize(0);
		vsFile.Add(vsFilePath[i]);
		
		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
		//vector<string> vsDummy;
		//pFilePublish->GetFiles(true, vsDummy);
	 	//nFileTranfered += pFilePublish->PublishFiles(vsFile, true);
	 	vector<string> vsSrcDummy;
		pFilePublish->GetFiles(true, vsSrcDummy);
		vector<string> vsDstDummy;
		pFilePublish->GetFiles(false, vsDstDummy);
	 	nFileTranfered += pFilePublish->PublishFiles(vsFile, bSource);
	 	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	 	 ///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	 	if(vsTransferredFiles != NULL)
	 	{
			vsTransferredFiles.Add(vsFilePath[i]);
			vsTransferredRegKey.Add(vsRegKey[i]);
	 	}
	 	///------ End SHOW_TRANSFERRED_FILES
	}
	
	return nFileTranfered;
}

int TransferHelper::ExportFiles(vector<string> & vsRegKey, LPCSTR lpcszSpecPath, vector<string> & vsFilePath, LPCSTR lpcszOpxFileName)
{
	ASSERT(vsRegKey.GetSize() == vsFilePath.GetSize());
	
	string strSourceFile;
	string strCurrentFile;
	string strSourceFilePath;		///------ Tony 08/07/2012 ORG-6414-P1 SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE
	vector<string> vsFileFullPath;
	
	for (int i = 0 ; i < vsRegKey.GetSize() ; ++i)
	{
		FilePublishBase * pFilePublish = getFilePublish(vsRegKey[i], lpcszSpecPath);
		if (pFilePublish == NULL)
			continue;
		
		strSourceFile = strCurrentFile = vsFilePath[i];
		pFilePublish->GetFileFullPath(strSourceFile, strCurrentFile);
		vsFileFullPath.Add(strSourceFile);
		strSourceFilePath = pFilePublish->GetSrcPath();		///------ Tony 08/07/2012 ORG-6414-P1 SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE
	}
	
	Tree trPkg;
	okutil_create_package_tree(&trPkg);
	
	///------ Tony 08/07/2012 ORG-6414-P1 SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE
	//trPkg.SourcePath.strVal = okutil_get_origin_path(ORIGIN_PATH_USER);
	trPkg.SourcePath.strVal = strSourceFilePath;
	///------ End SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE
	
	if (okutil_add_files_to_package(&trPkg, &vsFileFullPath) != 0)
		return 0;
	
	trPkg.SourcePath.strVal = okutil_get_origin_path(ORIGIN_PATH_USER);		///------ Tony 08/07/2012 ORG-6414-P1 SET_CURRENT_PATH_AFTER_ADD_FILES_TO_PACKAGE

	if (okutil_create_package_file(&trPkg, lpcszOpxFileName, NULL) != 0)
		return 0;
	
	return vsFileFullPath.GetSize();
}

void TransferHelper::GetFileFullPath(string& strFile1, string& strFile2, LPCSTR lpcszKey, LPCSTR lpcszSpecPath)
{
	FilePublishBase * pFilePublish = getFilePublish(lpcszKey, lpcszSpecPath);
	if ( NULL == pFilePublish)
	{
		ASSERT(false);
		return;
	}
	pFilePublish->GetFileFullPath(strFile1, strFile2);
}


void TransferHelper::convertFileType(DWORD dwFileType, vector<int> & vnFileType)
{
	vnFileType.SetSize(0);

	if (dwFileType & CHECK_PROJECT)
	{
		vnFileType.Add(FILE_TYPE_OGW);
		vnFileType.Add(FILE_TYPE_PROJECT);
		vnFileType.Add(FILE_TYPE_TEMPLATE);
	}

	if (dwFileType & CHECK_THEME)
	{
		vnFileType.Add(FILE_TYPE_THEME);
		vnFileType.Add(FILE_TYPE_DIALOG_THEME);
		vnFileType.Add(FILE_TYPE_FUNCTION_THEME);		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
		vnFileType.Add(FILE_TYPE_IMPORT_FILTER);
		vnFileType.Add(FILE_TYPE_DATABASE);
	}

	if (dwFileType & CHECK_CODE)
	{
		vnFileType.Add(FILE_TYPE_ORIGINC);
		vnFileType.Add(FILE_TYPE_PACKAGE);
		vnFileType.Add(FILE_TYPE_XF);
		vnFileType.Add(FILE_TYPE_OGS);
	}

	if (dwFileType & CHECK_SETTINGS)
	{
		vnFileType.Add(FILE_TYPE_DEFAULT_SETTINGS);
		vnFileType.Add(FILE_TYPE_TEXT);
		vnFileType.Add(FILE_TYPE_PALETTE);
		vnFileType.Add(FILE_TYPE_OMC);
		vnFileType.Add(FILE_TYPE_USERBUTTONS);	///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	}

	if (dwFileType & CHECK_FITTING)
	{
		vnFileType.Add(FILE_TYPE_FDF);
	}
	///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER
	if (dwFileType & CHECK_PATCH)
	{
		vnFileType.Add(FILE_TYPE_PATCH);
	}
	///------ End SUPPORT_PATCH_EXE_TRANSFER
	if ( dwFileType & CHECK_OTHER )
	{
		vnFileType.Add(FILE_TYPE_OTHER_FILE);
	}
}

static bool _isSepcPath(LPCSTR lpcszRegKey)
{
	string strPath;
	return !get_origin_user_path(strPath, lpcszRegKey, true);
}

///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//FilePublishBase * TransferHelper::getFilePublish(LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath)
FilePublishBase * TransferHelper::getFilePublish(LPCSTR lpcszRegKey, LPCSTR lpcszSpecPath, int nRecursive /* = 0*/)
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
{
	if (_isSepcPath(lpcszRegKey))
	{
		if (m_pSpecFliePublish == NULL || m_strSpecPath.CompareNoCase(lpcszSpecPath) != 0)
		{
			NICE_SAFE_REMOVAL(m_pSpecFliePublish);
			///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
			//m_pSpecFliePublish = create_file_publish(FILE_TYPE_ALL_FILE, m_bGroupManager, lpcszRegKey, lpcszSpecPath)
			m_pSpecFliePublish = create_file_publish(FILE_TYPE_ALL_FILE, m_bGroupManager, lpcszRegKey, lpcszSpecPath, nRecursive);
			///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		}
		 
		return m_pSpecFliePublish;
	}

	for (int i = 0 ; i < m_FilePublishMap.GetSize() ; ++i)
	{
		FilePublishMapItem & item = m_FilePublishMap.GetAt(i);

		if (!item.strRegKey.CompareNoCase(lpcszRegKey))
			return item.pFilePublish;
	}

	// not found, then create
	FilePublishMapItem * pNewItem = new FilePublishMapItem;
	pNewItem->strRegKey = lpcszRegKey;
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//pNewItem->pFilePublish = create_file_publish(FILE_TYPE_ALL_FILE, m_bGroupManager, lpcszRegKey, lpcszSpecPath)
	pNewItem->pFilePublish = create_file_publish(FILE_TYPE_ALL_FILE, m_bGroupManager, lpcszRegKey, lpcszSpecPath, nRecursive);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	m_FilePublishMap.Add(*pNewItem);

	return pNewItem->pFilePublish;
}

/************************************************************************
*   SourceListControl													*
*************************************************************************/

void SourceListControl::Init(int nID, WndContainer &dlg)
{
	GridListControl::Init(nID, dlg);

	SetDlgName(STR_DLG_NAME);
	SetColHeaderString(STR_SOURCE_GRID_HEADER);

	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable();
	SetAlternateRowColors();
	SetExplorerBar(flexExSort);
	
	EnableNavigation(true);
	SetNavigationCol(COL_FILE_NAME);
	SetColWidth(COL_FILE_NAME, FILE_NAME_WIDTH);
	HideCol(COL_FILE_NAME_SPECIFIED, true);		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	HideCol(COL_FILE_CATEGORY, true);
	SetColDataType(COL_FILE_DATE, flexDTDate);
	SetColFormat(COL_FILE_DATE, COL_DATE_FORMAT_TYPE_ShortDate);
	m_pTransferHelper = NULL;
	
#ifdef _DEBUG
	//HideCol(COL_FILE_CATEGORY, false);
#endif	
}

void SourceListControl::ShowMenu(int nx, int ny)
{
	int nRow, nCol;
	GetMouseCell(nRow, nCol);
	if ( nCol < 0 )
		return;
	vector<uint> vnRows;
	GetSelRows(vnRows);
	vector<uint> vec;
	if ( vnRows.Find(vec, nRow) <= 0 )
	{
		SelRow(nRow);
		vnRows.SetSize(1);
		vnRows[0] = nRow;
	}
	if ( vnRows.GetSize() != 1 )
		return;
	
	MenuBase mn;
	mn.Add(_L("Open Containing Folder"), MenuBase::OnMenuItem, MF_STRING);
	int nRet = mn.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
	if ( nRet >= 0 )
	{
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//string strFile = GetCell(vnRows[0], GetColOffset() + COL_FILE_NAME);
		//string strCat = GetCell(vnRows[0], GetColOffset() + COL_FILE_CATEGORY);
		//strFile = strCat + strFile;
		//string strDstFile = strFile;
		string strFile;
		string strCat;
		string strDstFile;
		strDstFile = GetCell(vnRows[0], GetColOffset() + COL_FILE_NAME);
		strCat = GetCell(vnRows[0], GetColOffset() + COL_FILE_CATEGORY);
		strDstFile = strCat + strDstFile;
		
		if(!m_strKey.Compare(STR_SPECIFIED_FOLDER))
		{
			strFile = GetCell(vnRows[0], GetColOffset() + COL_FILE_NAME_SPECIFIED);
		}
		else
		{
			strFile = strDstFile;
		}
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		
		if ( m_pTransferHelper )
		{
			m_pTransferHelper->GetFileFullPath(strFile, strDstFile, m_strKey, m_strSpecPath);
		}
		okutil_open_os_explorer(strFile);
	}
}
///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
void SourceListControl::GetFilePathList(vector<string> & vsSourcePathList, vector<string> & vsCurrentPathList, bool bIncludePreviewRows/* = true */)
{
	vsSourcePathList.SetSize(0);
	vsCurrentPathList.SetSize(0);		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	
	
	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		if ( !bIncludePreviewRows && GetRowData(i) == STATUS_PREVIEW )
			continue;
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//string strFilePath = GetCell(i, COL_SELECTED_LIST_FILE_CATEGORY) + GetCell(i, COL_SELECTED_LIST_FILE_NAME);
		//vsPathList.Add(strFilePath);
		string strSourceFilePath;
		string strCurrentFilePath;
		if(!m_strKey.Compare(STR_SPECIFIED_FOLDER))
		{
			strSourceFilePath = GetCell(i, COL_FILE_NAME_SPECIFIED);
		}
		else
		{
			strSourceFilePath = GetCell(i, COL_FILE_CATEGORY) + GetCell(i, COL_FILE_NAME);
		}
		strCurrentFilePath = GetCell(i, COL_FILE_CATEGORY) + GetCell(i, COL_FILE_NAME);
		vsSourcePathList.Add(strSourceFilePath);
		vsCurrentPathList.Add(strCurrentFilePath);
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	}
}
///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT

///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
void SourceListControl::DeleteSelectedFiles()
{
	if ( NULL == m_pTransferHelper )
		return;
	vector<uint> vnRows;
	GetSelRows(vnRows);
	for ( int ii = vnRows.GetSize() - 1; ii >= 0; ii-- )
	{
		string strFilePath = GetCell(vnRows[ii], COL_SELECTED_LIST_FILE_CATEGORY) + GetCell(vnRows[ii], COL_SELECTED_LIST_FILE_NAME);		
		string strCurPath = strFilePath;
		m_pTransferHelper->GetFileFullPath(strFilePath, strCurPath, m_strKey, m_strSpecPath);
		if ( strFilePath.IsFile() )
		{
			okutil_delete_file(strFilePath, true);
		}
		DeleteRow(vnRows[ii]);
	}
}
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

/************************************************************************
*   SelectedListControl													*
*************************************************************************/

void SelectedListControl::Init(int nID, WndContainer &dlg, bool bGroupManager/* = false */)
{
	GridListControl::Init(nID, dlg);
	SetDlgName(STR_DLG_NAME);
	SetColHeaderString(STR_SELECTED_GRID_HEADER);

	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable();
	SetAlternateRowColors();
	SetExplorerBar(flexExSort);
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//SetColWidth(COL_SELECTED_LIST_FILE_NAME, FILE_SELECTED_LIST_WIDTH);
	//HideCol(COL_SELECTED_LIST_FILE_CATEGORY, true);
	//HideCol(COL_SELECTED_LIST_FILE_REG_KEY, true);
	HideCol(COL_SELECTED_LIST_FILE_NAME_SPECIFIED, true);
	HideCol(COL_SELECTED_LIST_FILE_CATEGORY, true);
	

	if(bGroupManager)
	{
		SetColWidth(COL_SELECTED_LIST_FILE_NAME, FILE_NAME_WIDTH);
		SetNavigationCol(COL_SELECTED_LIST_FILE_NAME);
		SetColDataType(COL_FILE_DATE, flexDTDate);
		SetColFormat(COL_FILE_DATE, COL_DATE_FORMAT_TYPE_ShortDate);
		DeleteCol(COL_SELECTED_LIST_FILE_REG_KEY);
		DeleteCol(COL_SELECTED_LIST_FILE_STATUS);
	}
	else
	{	
		SetColWidth(COL_SELECTED_LIST_FILE_NAME, FILE_SELECTED_LIST_WIDTH);
		HideCol(COL_SELECTED_LIST_FILE_TYPE, true);
		HideCol(COL_SELECTED_LIST_FILE_SIZE, true);
		HideCol(COL_SELECTED_LIST_FILE_DATE, true);
		HideCol(COL_SELECTED_LIST_FILE_REG_KEY, true);
	}	
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	
	m_pTransferHelper = NULL;
#ifndef _DEBUG
	//HideCol(COL_SELECTED_LIST_FILE_CATEGORY, false);
	//HideCol(COL_SELECTED_LIST_FILE_REG_KEY, false);
#endif
}

void SelectedListControl::GetFileList(vector<string> & vsFiles)
{
	vsFiles.SetSize(0);
	
	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		vsFiles.Add(GetCell(i, COL_SELECTED_LIST_FILE_NAME));
	}
}

void SelectedListControl::GetCategoryList(vector<string> & vsCategory)
{
	vsCategory.SetSize(0);
	
	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		vsCategory.Add(GetCell(i, COL_SELECTED_LIST_FILE_CATEGORY));
	}
}

void SelectedListControl::GetFilePathList(vector<string> & vsPathList, bool bIncludePreviewRows)
{
	vsPathList.SetSize(0);
	
	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		if ( !bIncludePreviewRows && GetRowData(i) == STATUS_PREVIEW )
			continue;
		string strFilePath = GetCell(i, COL_SELECTED_LIST_FILE_CATEGORY) + GetCell(i, COL_SELECTED_LIST_FILE_NAME);
		vsPathList.Add(strFilePath);
	}
}

void SelectedListControl::GetRegKey(vector<string> & vsRegKey, bool bIncludePreviewRows)
{
	vsRegKey.SetSize(0);
	
	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		if ( !bIncludePreviewRows && GetRowData(i) == STATUS_PREVIEW )
			continue;
		vsRegKey.Add(GetCell(i, COL_SELECTED_LIST_FILE_REG_KEY));
	}
}

void SelectedListControl::GetFileStatus(vector<int> & vnStatus)
{
	vnStatus.SetSize(0);

	for (int i = GetRowOffset() ; i < GetRows() ; ++i)
	{
		vnStatus.Add(GetRowData(i));
	}
}
///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
//void SelectedListControl::ShowMenu(int nx, int ny)
void SelectedListControl::ShowMenu(int nx, int ny, bool bGroupManager/* = false */)
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
{
	int nRow, nCol;
	GetMouseCell(nRow, nCol);
	if ( nCol < 0 )
		return;
	vector<uint> vnRows;
	GetSelRows(vnRows);
	vector<uint> vec;
	if ( vnRows.Find(vec, nRow) <= 0 )
	{
		SelRow(nRow);
		vnRows.SetSize(1);
		vnRows[0] = nRow;
	}
	if ( vnRows.GetSize() != 1 )
		return;
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//if ( GetRowData(vnRows[0]) != STATUS_PREVIEW )
	if ( GetRowData(vnRows[0]) != STATUS_PREVIEW && !bGroupManager)
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG	
		return;
	MenuBase mn;
	mn.Add(_L("Open Containing Folder"), MenuBase::OnMenuItem, MF_STRING);
	int nRet = mn.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
	if ( nRet >= 0 )
	{
		string strFile = GetCell(vnRows[0], GetColOffset() + COL_SELECTED_LIST_FILE_NAME);
		string strCat = GetCell(vnRows[0], GetColOffset() + COL_SELECTED_LIST_FILE_CATEGORY);
		strFile = strCat + strFile;
		string strDstFile = strFile;
		if ( m_pTransferHelper )
		{
			m_pTransferHelper->GetFileFullPath(strFile, strDstFile, m_strKey, m_strSpecPath);
		}
		okutil_open_os_explorer(strDstFile);
	}
}

void SelectedListControl::DeleteSelectedFiles()
{
	if ( NULL == m_pTransferHelper )
		return;
	vector<uint> vnRows;
	GetSelRows(vnRows);
	for ( int ii = vnRows.GetSize() - 1; ii >= 0; ii-- )
	{
		string strFilePath = GetCell(vnRows[ii], COL_SELECTED_LIST_FILE_CATEGORY) + GetCell(vnRows[ii], COL_SELECTED_LIST_FILE_NAME);		
		string strRegKey = GetCell(vnRows[ii], COL_SELECTED_LIST_FILE_REG_KEY);
		string strCurPath = strFilePath;
		m_pTransferHelper->GetFileFullPath(strFilePath, strCurPath, strRegKey, m_strSpecPath);
		if ( strCurPath.IsFile() )
		{
			okutil_delete_file(strCurPath, true);
		}
		DeleteRow(vnRows[ii]);
	}
}
/************************************************************************
*   TransferFilesDlg													*
*************************************************************************/

TransferFilesDlg::TransferFilesDlg(bool bGroupMgr) : ResizeDialog(IDD_TRANSFER_USER_FILES, "ODlg8")
{	
	m_bGroupManager = bGroupMgr;
}

TransferFilesDlg::~TransferFilesDlg()
{
}

int TransferFilesDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

BOOL TransferFilesDlg::OnInitDialog()
{
	Text = m_strDlgName = (m_bGroupManager ? STR_DLG_NAME : STR_DLG_NAME_TRANSFER_USER_FILES);
	ResizeDialog::OnInitDialog();
	
	m_helper.SetGroupManager(m_bGroupManager);
	m_helper.SetRecursive(NOT_RECURSIVE);		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	
	SetInitReady();
	
	loadSetting();

	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	//GetItem(IDC_HINT).Text = "very long text..............................................................................................";
	//GetItem(IDC_HINT).Visible = FALSE;	///Sophy 3/5/2012 ORG-2840-P1 HIDE_HINT_FOR_LATER_USE
	//GetItem(IDC_HINT).Text = _L("Transfer File List");
	m_Location = GetItem(IDC_COMBO_LOCALTION);
	///------ Tony 07/26/2012 ORG-6330-S6 ADD_GRAY_AFTER_SHOW_CURRENT
	//GetItem(IDC_CHECK_SHOW_USER_FILES).Text = m_bGroupManager ? _L("Show Group Folder Files") : _L("Show Current User Files(Gray)");
	//GetItem(IDC_CHECK_SHOW_USER_FILES).Text = m_bGroupManager ? _L("Show Group Folder Files(Gray)") : _L("Show Current User Files(Gray)");
	GetItem(IDC_CHECK_SHOW_USER_FILES).Text = _L("Show Current User Files (Gray)");		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	///------ End ADD_GRAY_AFTER_SHOW_CURRENT
	///end NEW_TRANSFER_USER_FILES_DLG_GUI
	
	initAddRemoveButton();
	
	initCustomButton();			///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	
	initGroupFolderPath();		///------ Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT
	
	initHintCtrl();		///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	
	initTransferredList();		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	
	initLocationList();
	
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//enableBrowserButton();
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//enableBrowserButton(m_Location.GetCurSel());
	enableBrowserHideRecursive(getCurrentSel());
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	
	m_SourceList.Init(IDC_SOURCE_LIST, *this);
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//m_SelectedList.Init(IDC_SELECTED_FILE_LIST, *this);
	m_SelectedList.Init(IDC_SELECTED_FILE_LIST, *this, m_bGroupManager);
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	
	//allowExportUpdate();	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	updateSourceFileList();		///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//showUserFilesUpdate();
	if(m_bGroupManager)
	{
		updateGroupFolderList();
	}
	else
	{
		showUserFilesUpdate();
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	
	allowExportUpdate();	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	
	return TRUE;
}

BOOL TransferFilesDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	
	MoveControlsHelper _temp(this);
	
	int nGap = GetControlGap();
	///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	//RECT rtTransfer, rtExport, rtCancel, rtDelete, rtExportOPX;
	RECT rtTransfer, rtExport, rtCancel, rtDelete, rtExportOPX, rtShowNewerFiles, rtShowTransferredFiles, rtRedHint, rtExportOPXText, rtRemove;
	///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	GetControlClientRect(IDC_TRANSFER, rtTransfer);
	GetControlClientRect(IDC_EXPORT, rtExport);
	GetControlClientRect(IDCANCEL, rtCancel);		
	GetControlClientRect(IDC_DELETE, rtDelete);
	GetControlClientRect(IDC_CHECK_ALLOW_EXPORT_OPX, rtExportOPX);		///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	GetControlClientRect(IDC_REMOVE, rtRemove);		///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	GetControlClientRect(IDC_CHECK_SHOW_NEWER_FILES_ONLY, rtShowNewerFiles);
	GetControlClientRect(IDC_CHECK_HIDE_TRANSFERRED_FILES, rtShowTransferredFiles);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	GetControlClientRect(IDC_COLOR_HINT_RED, rtRedHint);		///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	GetControlClientRect(IDC_OPX_EXPORT_HINTS, rtExportOPXText);		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	
	int nButtonWidth = RECT_WIDTH(rtCancel);
	int nButtonHeight = RECT_HEIGHT(rtCancel);
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//MoveControl(IDCANCEL, cx - nGap, cy - nGap, false);
	//MoveControl(IDC_EXPORT, cx - 2 * nGap - nButtonWidth, cy - nGap, false);
	//MoveControl(IDC_TRANSFER, cx - 3 * nGap - 2 * nButtonWidth, cy - nGap, false);
	//MoveControl(IDC_DELETE, cx - 4 * nGap - 3 * nButtonWidth, cy - nGap, false);
	///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	//MoveControl(IDC_CHECK_ALLOW_EXPORT_OPX,  nGap + RECT_WIDTH(rtExportOPX), cy - nGap, false);
	///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//MoveControl(IDC_CHECK_ALLOW_EXPORT_OPX,  nGap + RECT_WIDTH(rtExportOPX), cy - 4 * nGap, false);
	if(m_bGroupManager)
	{
		MoveControl(IDC_REMOVE,  nGap + RECT_WIDTH(rtRemove), cy - nGap, false);
		MoveControl(IDCANCEL, cx - nGap, cy - nGap, false);
		MoveControl(IDC_TRANSFER, cx - 2 * nGap - nButtonWidth, cy - nGap, false);
		MoveControl(IDC_DELETE, cx - 3 * nGap - 2 * nButtonWidth, cy - nGap, false);
	}
	else
	{
		MoveControl(IDC_CHECK_ALLOW_EXPORT_OPX,  nGap + RECT_WIDTH(rtExportOPX), cy -  nGap - nButtonHeight, false);
		MoveControl(IDCANCEL, cx - nGap, cy - nGap, false);
		MoveControl(IDC_EXPORT, cx - 2 * nGap - nButtonWidth, cy - nGap, false);
		MoveControl(IDC_TRANSFER, cx - 3 * nGap - 2 * nButtonWidth, cy - nGap, false);
		MoveControl(IDC_DELETE, cx - 4 * nGap - 3 * nButtonWidth, cy - nGap, false);
		///------ Tony 08/22/2012 ORG-6616-P1 PUT_THE_CHECKBOX_A_BETTER_PLACE
		//MoveControl(IDC_CHECK_SHOW_NEWER_FILES_ONLY, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles), cy - 4 * nGap, false);
		//MoveControl(IDC_CHECK_HIDE_TRANSFERRED_FILES, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles)+ RECT_WIDTH(rtShowTransferredFiles), cy - 4 * nGap, false);
		MoveControl(IDC_CHECK_SHOW_NEWER_FILES_ONLY, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles), cy -  nGap - nButtonHeight, false);
		MoveControl(IDC_CHECK_HIDE_TRANSFERRED_FILES, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles)+ RECT_WIDTH(rtShowTransferredFiles), cy -   nGap - nButtonHeight, false);
		///------ End PUT_THE_CHECKBOX_A_BETTER_PLACE
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	///------ End ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	//MoveControl(IDC_CHECK_SHOW_NEWER_FILES_ONLY, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles), cy - 4 * nGap, false);		///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	//MoveControl(IDC_CHECK_HIDE_TRANSFERRED_FILES, 2 * nGap + RECT_WIDTH(rtExportOPX) + RECT_WIDTH(rtShowNewerFiles)+ RECT_WIDTH(rtShowTransferredFiles), cy - 4 * nGap, false);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	//RECT rtHint;
	//GetControlClientRect(IDC_HINT, rtHint);
	//rtHint.right = cx - nGap;
	//MoveControl(GetItem(IDC_HINT), rtHint);
	///end NEW_TRANSFER_USER_FILES_DLG_GUI
	MoveControl(IDC_OPX_EXPORT_HINTS,  nGap + RECT_WIDTH(rtExportOPXText), cy - nGap, false);	///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT	
	///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	//color hint
	MoveControl(IDC_COLOR_HINT_RED,  2 * nGap + RECT_WIDTH(rtExportOPXText) + RECT_WIDTH(rtRedHint), cy - nGap, false);
	MoveControl(IDC_COLOR_HINT_GREEN,  3 * nGap + RECT_WIDTH(rtExportOPXText) + 2 * RECT_WIDTH(rtRedHint), cy - nGap, false);
	MoveControl(IDC_COLOR_HINT_BLUE,  4 * nGap + RECT_WIDTH(rtExportOPXText) + 3 * RECT_WIDTH(rtRedHint), cy - nGap, false);
	///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	// left, right button
	RECT rtLeft, rtRight;
	GetControlClientRect(IDC_LEFT, rtLeft);
	GetControlClientRect(IDC_RIGHT, rtRight);
	int nArrowWidth = RECT_WIDTH(rtLeft);
	int nArrowHeight = RECT_HEIGHT(rtLeft);

	// two grid
	///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	//int nGridBottom = cy - 2 * nGap - nButtonHeight;
	int nGridBottom;
	if(m_bGroupManager)
	{
		nGridBottom = cy - 2 * nGap - nButtonHeight;
	}
	else
	{
		nGridBottom = cy - 5 * nGap -  nButtonHeight;
	}
	///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
	int nOldVerGridWidth = (cx - 4 * nGap - nArrowWidth) * 0.5;
	int nSelectedGridWidth = (cx - 4 * nGap - nArrowWidth) * 0.5;
	
	RECT rtGrid;
	GetControlClientRect(IDC_SOURCE_LIST, rtGrid);
	rtGrid.left = nGap;
	rtGrid.right =  rtGrid.left + nOldVerGridWidth;
	rtGrid.bottom = nGridBottom;
	MoveControl(GetItem(IDC_SOURCE_LIST), rtGrid);
	
	GetControlClientRect(IDC_SELECTED_FILE_LIST, rtGrid);
	rtGrid.left = cx - nGap - nSelectedGridWidth;
	rtGrid.right = cx - nGap;
	rtGrid.bottom = nGridBottom;
	MoveControl(GetItem(IDC_SELECTED_FILE_LIST), rtGrid);
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	
	RECT rtCheck;
	GetControlClientRect(IDC_CHECK_SHOW_USER_FILES, rtCheck);
	
	RECT rtUFFHint;
	GetControlClientRect(IDC_CURRENT_UFF_HINT, rtUFFHint);
	///------ Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT
	//rtUFFHint.right = nGap + nOldVerGridWidth;
	rtUFFHint.left = nGap;
	rtUFFHint.top = rtCheck.top;
	MoveControl(GetItem(IDC_CURRENT_UFF_HINT), rtUFFHint);
	///------ End PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT
	
	if(m_bGroupManager)
	{
		MoveControl(IDC_GROUP_LIST_PATH_TEXT, cx - nGap - nSelectedGridWidth, rtCheck.top);
	}
	else
	{
		MoveControl(IDC_CHECK_SHOW_USER_FILES, cx - nGap - nSelectedGridWidth, rtCheck.top, true);
	}
	
	RECT rtHint;
	GetControlClientRect(IDC_HINT, rtHint);
	MoveControl(IDC_HINT, cx - nGap - nSelectedGridWidth, rtHint.top, true);
	///End NEW_TRANSFER_USER_FILES_DLG_GUI
	///Sophy 3/5/2012 ORG-2840-P1 SWAP_ADD_AND_REMOVE_BUTTON_POSITION
	//MoveControl(IDC_LEFT, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top - nGap) / 2, false);
	//MoveControl(IDC_RIGHT, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top + nGap) / 2 + nArrowHeight, false);
	MoveControl(IDC_RIGHT, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top - nGap) / 2, false);
	MoveControl(IDC_LEFT, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top + nGap) / 2 + nArrowHeight, false);
	///end SWAP_ADD_AND_REMOVE_BUTTON_POSITION
	
	return TRUE;
}

BOOL TransferFilesDlg::OnDestroy()
{
	saveSetting();
	return TRUE;
}

BOOL TransferFilesDlg::OnLocationChange(Control ctrl)
{
	
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//m_strLastLocationKey = nCurSel >= (m_vsSourceKeys.GetSize()) ? STR_SPECIFIED_FOLDER : m_vsSourceKeys[nCurSel]
	//int nCurSel = m_Location.GetCurSel();
	//if( !checkExportOPX() && nCurSel >= m_nCurrentLocationIndex)	
			//nCurSel++;
	int nCurSel = getCurrentSel();
	m_strLastLocationKey = nCurSel >= (m_vsSourceKeys.GetSize()) ? STR_SPECIFIED_FOLDER : m_vsSourceKeys[nCurSel];
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//enableBrowserButton();
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//enableBrowserButton(nCurSel);
	enableBrowserHideRecursive(nCurSel);
	updateRecursive();
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	updateSourceFileList();
	clearSelectedFileList();
	updateOpxExportHint();
	return TRUE;
}

BOOL TransferFilesDlg::OnViewCheckChange(Control ctrl)
{
	updateSourceFileList();
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//showUserFilesUpdate();
	if(m_bGroupManager)
	{
		updateGroupFolderList();
	}
	else
	{
		showUserFilesUpdate();
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	return TRUE;
}
	
///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
BOOL TransferFilesDlg::OnRecursiveCheckChange(Control ctrl)
{
	updateRecursive();
	updateSourceFileList();	
	return TRUE;
}	
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
BOOL TransferFilesDlg::OnSelectedListSelectionChange(Control ctrl)
{
	if(!m_bGroupManager)
		disableDeleteButton();
	disableLeftRightButton(false);
	return TRUE;
}

BOOL TransferFilesDlg::OnSourceListSelectionChange(Control ctrl)
{
	disableLeftRightButton(true);
	return TRUE;
}

///------ End DISABLE_TRANSFER_DELETE_BUTTON
BOOL TransferFilesDlg::OnBrowser(Control ctrl)
{
	char szNewPath[MAX_PATH];
	
	string	strDefPath = m_strSpecifiedFolder.IsEmpty() ? okutil_get_origin_path(ORIGIN_PATH_USER) : m_strSpecifiedFolder;
	
	int nRet = browse_get_path_dialog(GetSafeHwnd(), szNewPath, strDefPath, _L("Please choose a folder."));
	
	if (nRet != IDOK)
		return false;
	
	string strPath = szNewPath;
	if(strPath.IsEmpty())
		return false;
	
	if (!m_strSpecifiedFolder.CompareNoCase(strPath))
		return false;
	
	m_strSpecifiedFolder = strPath;
	updateSourceFileList();
	return TRUE;
}

BOOL TransferFilesDlg::OnTransfer(Control ctrl)
{
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//doTransferFiles();
	//updateSourceFileList();	
	//updateListStatus();
	if(m_bGroupManager)
	{
		updateINIFile();		///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
		CopyClientUpdateEXE();		///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
		PostMessage(WM_CLOSE);
	}
	else
	{
		doTransferFiles();
		updateListStatus();
		updateSourceFileList();		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	return TRUE;
}

BOOL TransferFilesDlg::OnExport(Control ctrl)
{
	exportFiles();
	return TRUE;
}

///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
BOOL TransferFilesDlg::OnRemove(Control ctrl)
{		
	m_SourceList.SetTransferHelper(&m_helper, m_strLastLocationKey, m_strSpecifiedFolder);
	m_SourceList.DeleteSelectedFiles();
	updateGroupFolderList();
	disableLeftRightButton(true);
	return TRUE;
}
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
BOOL TransferFilesDlg::OnDelete(Control ctrl)
{
	m_SelectedList.SetTransferHelper(&m_helper, m_strLastLocationKey, m_strSpecifiedFolder);
	m_SelectedList.DeleteSelectedFiles();
	updateSourceFileList();
	disableLeftRightButton(false);	
	///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	if(!m_bGroupManager)
	{
		updateOpxExportHint();
	}
	///------ Tony 09/07/2012 ORG-6762-P1 ENABLE_PUBLISH_BUTTON_AFTER_DELETE
	else
	{
		GetItem(IDC_TRANSFER).Enable = true;	
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);
	}
	///------ End ENABLE_PUBLISH_BUTTON_AFTER_DELETE
	///------ END ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	return TRUE;
}
BOOL TransferFilesDlg::OnAllowExportOPX(Control ctrl)
{
	allowExportUpdate();
	return TRUE;
}
///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
BOOL TransferFilesDlg::OnHideTransferredFiles(Control ctrl)
{
	updateSourceFileList();
	return TRUE;
}
///------ End SHOW_TRANSFERRED_FILES
BOOL TransferFilesDlg::OnShowFilesInUFF(Control ctrl)
{
	showUserFilesUpdate();
	enableLocation();		///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
	updateOpxExportHint();		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	return TRUE;
}
///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
void TransferFilesDlg::OnMinMaxInfo(MINMAXINFO* lpMMI)
{
	lpMMI->ptMinTrackSize.x = 800;
	lpMMI->ptMinTrackSize.y = 400;
}
///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
void TransferFilesDlg::allowExportUpdate()
{
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//Button btn = GetItem(IDC_CHECK_ALLOW_EXPORT_OPX);
	//bool bAllowExportOPX = btn.Check;
	//if ( bAllowExportOPX )
 	if ( checkExportOPX() )
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	{
		DWORD dwItemData = m_Location.GetItemData(m_nCurrentLocationIndex);
		if ( dwItemData != LOCATION_CURRENT )
		{
			m_Location.InsertString(m_nCurrentLocationIndex, m_vsSourceKeys[m_nCurrentLocationIndex] + " " + _L("User Files Folder"));
			m_Location.SetItemData(m_nCurrentLocationIndex, LOCATION_CURRENT);
		}
	}
	else
	{
		int nCurSel = m_Location.GetCurSel();
		DWORD dwItemData = m_Location.GetItemData(m_nCurrentLocationIndex);
		if ( dwItemData == LOCATION_CURRENT )
		{
			m_Location.DeleteString(m_nCurrentLocationIndex);
		}
		if ( nCurSel == m_nCurrentLocationIndex )
		{
			nCurSel--;
			if ( nCurSel < 0 )
				nCurSel = 0;
			m_Location.SetCurSel(nCurSel);
			m_strLastLocationKey = nCurSel >= m_vsSourceKeys.GetSize() ? STR_SPECIFIED_FOLDER : m_vsSourceKeys[nCurSel];
			updateSourceFileList();
		}
		//m_Location.Enable = true;			///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
	}
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//GetItem(IDC_EXPORT).Enable = bAllowExportOPX;
	GetItem(IDC_EXPORT).Enable = checkExportOPX();
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX

	updateOpxExportHint();		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
}

///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
void	TransferFilesDlg::updateOpxExportHint()
{
	RichEdit reOpxExportHint = GetItem(IDC_OPX_EXPORT_HINTS);
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//reOpxExportHint.Visible = checkExportOPX();
	if(!m_bGroupManager)
	{
		reOpxExportHint.Visible = checkExportOPX();
	}
	else
	{
		reOpxExportHint.Visible = false;
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	vector<string> vsRegKey;
	m_SelectedList.GetRegKey(vsRegKey, false);
	string strOpxExportHint;
	strOpxExportHint.Format(_L("%d file(s) will be exported"), vsRegKey.GetSize());
	reOpxExportHint.Text = strOpxExportHint;
}
///------ End ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT

void TransferFilesDlg::showUserFilesUpdate()
{
	Button btn = GetItem(IDC_CHECK_SHOW_USER_FILES);
	bool bShowFiles = btn.Check;
	vector<string> vsExist;
	m_SelectedList.GetFilePathList(vsExist);
	
	///------ Tony 08/01/2012 ORG-2840-P6 SHOW_USERFILES_UPDATE_ON_VIEW_CHECK_CHANGE
	int nOffset = m_SelectedList.GetRowOffset();
	int nRows = m_SelectedList.GetRows();
	for ( int ii = nRows - 1 - nOffset; ii >= 0; ii-- )
	{
		if ( m_SelectedList.GetRowData(ii + nOffset) == STATUS_PREVIEW )
		{
			m_SelectedList.DeleteRow(ii + nOffset);
			vsExist.RemoveAt(ii);
		}
	}
	///------ End SHOW_USERFILES_UPDATE_ON_VIEW_CHECK_CHANGE
	if ( bShowFiles )
	{
		vector<string> vsFiles;
		vector<string> vsFileInfo;
		m_helper.GetFileInfo(getFileType(), m_vsSourceKeys[m_nCurrentLocationIndex], m_strSpecifiedFolder, vsFiles, vsFileInfo, false);
		
		int nRowOffset = m_SelectedList.GetRowOffset();
		for ( int ii = 0; ii < vsFiles.GetSize(); ii++ )
		{
			int nItemOffset = ii * FB_COL_NUMS;
			string strPath = vsFileInfo[nItemOffset + FB_COL_CATEGORY] + vsFileInfo[nItemOffset + FB_COL_FILE];
			int nFound = vsExist.Find(strPath);
			if ( nFound >= 0 )
			{
				///------ Tony 08/06/2012 when check show current user files ,don't change "newer" and "older" files to "preview"
				//m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_REG_KEY, m_vsSourceKeys[m_nCurrentLocationIndex]);
				//m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_STATUS, _get_status_string(STATUS_PREVIEW));
				//m_SelectedList.SetRowData(nFound + nRowOffset, STATUS_PREVIEW);
				//m_SelectedList.SetRowColor(nFound + nRowOffset, RGB(127, 127, 127));
				int nStatus =  m_SelectedList.GetRowData(nFound + nRowOffset);
				///------ Tony 08/22/2012 ORG-6330-S5 STATUS_SAME_CURRENT_SHOULD_NOT_CHANGE_BY_CHECK_SHOW_USER_FILES
				//if(nStatus == STATUS_SAME || nStatus == STATUS_CURRENT)
				//{
				//	nStatus = STATUS_PREVIEW;
				//	m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_REG_KEY, m_vsSourceKeys[m_nCurrentLocationIndex]);
				//}
				//else
				//{
				//	m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_REG_KEY, m_strLastLocationKey);
				//}
				m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_REG_KEY, m_strLastLocationKey);
				///------ End STATUS_SAME_CURRENT_SHOULD_NOT_CHANGE_BY_CHECK_SHOW_USER_FILES
				m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_STATUS, _get_status_string(nStatus));
				m_SelectedList.SetRowData(nFound + nRowOffset, nStatus);
				updateStatusColor(m_SelectedList, nFound, nRowOffset, nStatus);
				///----- End
			}
			else
			{
				int nRows = m_SelectedList.GetRows();
				m_SelectedList.SetRows(nRows);
				m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_NAME, vsFileInfo[nItemOffset + FB_COL_FILE]);	
				m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_CATEGORY, vsFileInfo[nItemOffset + FB_COL_CATEGORY]);
				m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_REG_KEY, m_vsSourceKeys[m_nCurrentLocationIndex]);
				m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_STATUS, _get_status_string(STATUS_PREVIEW));
				m_SelectedList.SetRowData(nRows, STATUS_PREVIEW);
				m_SelectedList.SetRowColor(nRows, RGB(127, 127, 127));
			}
		}
		return;
	}
	///------ Tony 08/01/2012 ORG-2840-P6 SHOW_USERFILES_UPDATE_ON_VIEW_CHECK_CHANGE
	/*
	else
	{
		int nRows = m_SelectedList.GetRows();
		for ( int ii = nRows - 1; ii >= 0; ii-- )
		{
			if ( m_SelectedList.GetRowData(ii) == STATUS_PREVIEW )
			{
				m_SelectedList.DeleteRow(ii);
			}
		}
	}*/
	///------ End SHOW_USERFILES_UPDATE_ON_VIEW_CHECK_CHANGE
}
///end NEW_TRANSFER_USER_FILES_DLG_GUI

BOOL TransferFilesDlg::OnAddFileToSelectedList(Control ctrl)
{
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//addFileToList();
	//updateListStatus();
	if(m_bGroupManager)
	{
		transferFileToList(false);
		disableLeftRightButton(true);	
	}
	else
	{
		addFileToList();
		updateListStatus();
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	disableLeftRightButton(false);		///----- Tony 08/06/2012
	return TRUE;
}

BOOL TransferFilesDlg::OnRemoveFileToSelectedList(Control ctrl)
{
	///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	//removeFileFromList();
	//enableLocation();	
	if(m_bGroupManager)
	{
		transferFileToList(true);
		
	}
	else
	{
		removeFileFromList();
		enableLocation();		///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
		updateOpxExportHint();		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
	}
	disableLeftRightButton(false);	
	disableLeftRightButton(true);	
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	return TRUE;
}

BOOL TransferFilesDlg::OnContextMenu(UINT nResIDCtrl, int nx, int ny)
{
	if ( IDC_SOURCE_LIST == nResIDCtrl )
	{
		m_SourceList.ShowMenu(nx, ny);
	}
	else if ( IDC_SELECTED_FILE_LIST == nResIDCtrl )
	{
		m_SelectedList.SetTransferHelper(&m_helper, m_strLastLocationKey, m_strSpecifiedFolder);
		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
		//m_SelectedList.ShowMenu(nx, ny);
		m_SelectedList.ShowMenu(nx, ny, m_bGroupManager);
		///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	}
	return TRUE;
}

BOOL TransferFilesDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = m_bGroupManager ? IDD_GROUP_FOLDER_DLG : IDD_UUF_DLG;
	return TRUE;
}

void TransferFilesDlg::initLocationList()
{
	vector vdVersions;
	okutil_get_installed_origins(&vdVersions, &m_vsSourceKeys, NULL, &m_vsSourceUFFPath, GETINSTALLEDORG_SORT_BY_VERSION);
	
	m_Location.ResetContent();
	string strUFF = GetAppPath(FALSE);
	for(int i = 0 ; i < m_vsSourceKeys.GetSize() ; ++i)
	{
		int nItemIndex = m_Location.AddString(m_vsSourceKeys[i] + " " + _L("User Files Folder"));
		DWORD dwData = strUFF.CompareNoCase(m_vsSourceUFFPath[i]) == 0 ? LOCATION_CURRENT : LOCATION_OTHER;
		if ( dwData == LOCATION_CURRENT )
			m_nCurrentLocationIndex = nItemIndex;
		m_Location.SetItemData(nItemIndex, dwData);
	}
	m_Location.AddString(STR_SPECIFIED_FOLDER);

	int nFind = -1;
	if (!m_strLastLocationKey.CompareNoCase(STR_SPECIFIED_FOLDER))
	{
		m_Location.SetCurSel(m_vsSourceKeys.GetSize());
	}
	else if (!m_strLastLocationKey.IsEmpty() && (nFind = m_vsSourceKeys.Find(m_strLastLocationKey)) != -1)
	{
		m_Location.SetCurSel(nFind);
	}
	else if (m_bGroupManager)		//tony 9/18/2012 when groupmanager, current selection is current version origin
	{
		m_Location.SetCurSel(m_nCurrentLocationIndex);
	}
	else
	{
		m_Location.SetCurSel(m_vsSourceKeys.GetSize() - 1);
	}
}

///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
void TransferFilesDlg::enableLocation()
{
	int nOffset = m_SelectedList.GetRowOffset();
	if(!m_bGroupManager)
	{
		m_Location.Enable = true;
	}
	GetItem(IDC_TRANSFER).Enable = false;		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	enableBrowserHideRecursive(getCurrentSel());		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	for (int ii = 0 ; ii < m_SelectedList.GetRows() - 1; ++ii)
	{
		int nStatus =  m_SelectedList.GetRowData(ii + nOffset);
		if ( nStatus == STATUS_NEW || nStatus == STATUS_NEWER ||nStatus == STATUS_OLDER )
		{
			m_Location.Enable = false;
			GetItem(IDC_BROWSER).Enable = false;
			GetItem(IDC_TRANSFER).Enable = true;		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
			break;
		}	
	}
}
///----- End DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER

///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
//void TransferFilesDlg::enableBrowserButton()
///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
//void TransferFilesDlg::enableBrowserButton(int nCurSel)
void TransferFilesDlg::enableBrowserHideRecursive(int nCurSel)
///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
{
	//int nCurSel = m_Location.GetCurSel();		///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//GetItem(IDC_BROWSER).Enable = !(nCurSel >= 0 && nCurSel < m_vsSourceKeys.GetSize());
	bool bEnable = !(nCurSel >= 0 && nCurSel < m_vsSourceKeys.GetSize());
	GetItem(IDC_BROWSER).Enable = bEnable;
	GetItem(IDC_CHECK_RECURSIVE_SPECIFIED_FOLDER).Visible = bEnable;
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
}
///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
void TransferFilesDlg::disableDeleteButton()
{
	vector<uint> vnSelectedRows;	
	m_SelectedList.GetSelRows(vnSelectedRows);
	
	if (vnSelectedRows.GetSize() == 0)
		return;

	Button btn = GetItem(IDC_DELETE);
	btn.Enable = true;
	Button btnCheckUFF = GetItem(IDC_CHECK_SHOW_USER_FILES);

	for (int ii = 0 ; ii < vnSelectedRows.GetSize() ; ++ii)
	{
		int nStatus = m_SelectedList.GetRowData(vnSelectedRows[ii]);
		if(!btnCheckUFF || (btnCheckUFF && !(nStatus == STATUS_PREVIEW || nStatus == STATUS_SAME || nStatus == STATUS_CURRENT)))
		{
			btn.Enable = false;
			break;
		}
	}
}
///------ End DISABLE_TRANSFER_DELETE_BUTTON
///------ Tony 08/06/2012
void TransferFilesDlg::disableLeftRightButton(bool bSourceList)
{
	Button btn;
	int nStatus;
	vector<uint> vnSelectedRows;	
	if(bSourceList)
	{
		btn = GetItem(IDC_RIGHT);;
		btn.Enable = false;
		m_SourceList.GetSelRows(vnSelectedRows);
	}
	else
	{
		btn = GetItem(IDC_LEFT);;
		btn.Enable = false;
		m_SelectedList.GetSelRows(vnSelectedRows);
	}

	if (vnSelectedRows.GetSize() == 0 || (vnSelectedRows.GetSize() == 1 && vnSelectedRows[0] == 0))
		return;

	for (int ii = 0 ; ii < vnSelectedRows.GetSize() ; ++ii)
	{
		if(bSourceList)
			nStatus = m_SourceList.GetRowData(vnSelectedRows[ii]);
		else
			nStatus = m_SelectedList.GetRowData(vnSelectedRows[ii]);
		if(m_bGroupManager)
		{
			if(nStatus == STATUS_NEW || nStatus == STATUS_NEWER || nStatus == STATUS_OLDER )
			{
				btn.Enable = true;
				break;
			}
		}
		else
		{
			if(nStatus == STATUS_NEW || nStatus == STATUS_NEWER || nStatus == STATUS_OLDER || nStatus == STATUS_SAME || nStatus == STATUS_CURRENT)
			{
				btn.Enable = true;
				break;
			}
		}
	}
}
///----- End
void TransferFilesDlg::initAddRemoveButton()
{
	vector<string> vsTips(1);
	vsTips[0] = _L("Remove");
	m_bnLeft = GetItem(IDC_LEFT);
	m_bnLeft.Init(1, IDB_ARROW_LEFT, 16, vsTips);
	
	vsTips[0] = _L("Add");
	m_bnRight = GetItem(IDC_RIGHT);
	m_bnRight.Init(1, IDB_ARROW_RIGHT, 16, vsTips);
}

///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
void TransferFilesDlg::initHintCtrl()
{
	RichEdit reOpxExportHint = GetItem(IDC_OPX_EXPORT_HINTS);
	reOpxExportHint.Enable = false;
	if(!m_bGroupManager)		///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	{
		reOpxExportHint.Visible = checkExportOPX();
	}
	reOpxExportHint.SetTextColor(0, -1, SYSCOLOR_BLACK);

	initColorHint();
}

void TransferFilesDlg::initColorHint()
{
	setHintColor(IDC_COLOR_HINT_RED, COLOR_RED, STR_COLOR_HINT_RED);
	setHintColor(IDC_COLOR_HINT_GREEN, COLOR_DARKGREEN, STR_COLOR_HINT_GREEN);
	setHintColor(IDC_COLOR_HINT_BLUE, COLOR_BLUE, STR_COLOR_HINT_BLUE);
}

void TransferFilesDlg::setHintColor(uint uResourceID, uint uColor, LPCTSTR lpcszHint)
{
	RichEdit reHint = GetItem(uResourceID);
	reHint.Text = lpcszHint;
	reHint.SetTextColor(0, -1, uColor);
	reHint.Enable = false;
}
///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
void TransferFilesDlg::initTransferredList()
{
	m_vsTransferredFiles.SetSize(0);
	m_vsTransferredRegKey.SetSize(0);
}
///------ End SHOW_TRANSFERRED_FILES

///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
void TransferFilesDlg::initCustomButton()
{
	GetItem(IDC_TRANSFER).Enable = false;		///------ Tony 07/30/2012 ORG-6330-S8 DISABLE_TRANSFER_DELETE_BUTTON
	
	///------ Tony 08/02/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
	if(m_bGroupManager)
	{
		m_strLastLocationKey = m_vsSourceKeys[m_nCurrentLocationIndex];
		Button btnCheckExport = GetItem(IDC_CHECK_ALLOW_EXPORT_OPX);
		btnCheckExport.Check = true;
		btnCheckExport.Visible = false;
		Button btnCheckUFF = GetItem(IDC_CHECK_SHOW_USER_FILES);
		btnCheckUFF.Check = false;
		btnCheckUFF.Visible = false;
		Button btnCheckNewerFiles = GetItem(IDC_CHECK_SHOW_NEWER_FILES_ONLY);
		btnCheckNewerFiles.Check = false;
		btnCheckNewerFiles.Visible = false;
		Button btnCheckHideTransferredFiles = GetItem(IDC_CHECK_HIDE_TRANSFERRED_FILES);
		btnCheckHideTransferredFiles.Check = false;
		btnCheckHideTransferredFiles.Visible = false;
		GetItem(IDC_LOCATION).Text = STR_CURRENT_LOCATION;
		GetItem(IDC_COMBO_LOCALTION).Enable = false;
		GetItem(IDC_BROWSER).Visible = false;
		GetItem(IDC_EXPORT).Visible = false;
		GetItem(IDC_HINT).Text = STR_GROUP_FOLDER_FILE_LIST;
		GetItem(IDCANCEL).Text = STR_BTN_NAME_CLOSE;		///------ Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT
		
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		Button btnTransfer = GetItem(IDC_TRANSFER);
		int nIsPublished = iniFile.ReadInt(STR_SECTION, STR_IS_PUBLISHED, -1);
		btnTransfer.Text = STR_PUBLISH;
		btnTransfer.Enable = !nIsPublished;
	}	
	else
	{
		///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER	
		Button btnCheckPatch = GetItem(IDC_CHECK_PATCH);
		btnCheckPatch.Check = false;
		GetItem(IDC_CHECK_PATCH).Visible = false;	
		///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER	
		GetItem(IDC_HINT).Text = STR_TRANSFER_FILE_LIST;
		Button btnRemove = GetItem(IDC_REMOVE);
		btnRemove.Visible = false;
	}
	///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
}
///----- End DISABLE_TRANSFER_DELETE_BUTTON

///------ Tony 08/22/2012 ORG-6325-S1 PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT
void TransferFilesDlg::initGroupFolderPath()
{
	if(m_bGroupManager)
	{
		string strGroupPath;
		m_helper.GetDestPath(strGroupPath);
		strGroupPath = STR_GROUP_FOLDER + " : " + strGroupPath;
		///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
		Control ctrlGroupPath = GetItem(IDC_GROUP_LIST_PATH_TEXT);
		if( !ctrlGroupPath )
			return;
		ctrlGroupPath.SetToolTip(strGroupPath);
		RECT rrCtrl;
		GetControlClientRect(IDC_GROUP_LIST_PATH_TEXT, rrCtrl);
		getEllipsisText(RECT_WIDTH(rrCtrl) * 1.3, strGroupPath);
		///------ End CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
		ctrlGroupPath.Text = strGroupPath;
	}
	else
	{
		Button btnGroupPathText = GetItem(IDC_GROUP_LIST_PATH_TEXT);
		btnGroupPathText.Visible = false;
	}

}
///------ End PANEL_SHOULD_SHOW_GROUP_FOLDER_HINT

DWORD TransferFilesDlg::getFileType()
{
	DWORD dwFileType = 0;
	///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	//vector<int> vnCheckBox = { IDC_CHECK_PROJECT, IDC_CHECK_THEME, IDC_CHECK_CODE, IDC_CHECK_SETTINGS, IDC_CHECK_FITTING, IDC_CHECK_OTHER, IDC_CHECK_ALLOW_EXPORT_OPX, IDC_CHECK_SHOW_USER_FILES };
	//vector<int> vnFileType = { CHECK_PROJECT, CHECK_THEME, CHECK_CODE, CHECK_SETTINGS, CHECK_FITTING, CHECK_OTHER, CHECK_ALLOW_EXPORT_OPX, CHECK_SHOW_UFF_FILES };
	///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER
	//add IDC_CHECK_FITTING & CHECK_PATCH
	vector<int> vnCheckBox = { IDC_CHECK_PROJECT, IDC_CHECK_THEME, IDC_CHECK_CODE, IDC_CHECK_SETTINGS, IDC_CHECK_FITTING, IDC_CHECK_PATCH, IDC_CHECK_OTHER, IDC_CHECK_ALLOW_EXPORT_OPX, IDC_CHECK_SHOW_USER_FILES,IDC_CHECK_HIDE_TRANSFERRED_FILES, IDC_CHECK_SHOW_NEWER_FILES_ONLY};
	vector<int> vnFileType = { CHECK_PROJECT, CHECK_THEME, CHECK_CODE, CHECK_SETTINGS, CHECK_FITTING, CHECK_PATCH, CHECK_OTHER, CHECK_ALLOW_EXPORT_OPX, CHECK_SHOW_UFF_FILES, CHECK_HIDE_TRANSFERRED_FILES, CHECK_SHOW_NEWER_FILES_ONLY};
	///------ End SUPPORT_PATCH_EXE_TRANSFER
	///------ End HIDE_NOT_NEWER_STATUS_FILES_ROWS
	for (int i = 0 ; i < vnCheckBox.GetSize() ; ++i)
	{
		Button CheckBox = GetItem(vnCheckBox[i]);
		if (CheckBox.Check == TRUE)
			dwFileType |= vnFileType[i];
	}

	return dwFileType;
}

void TransferFilesDlg::setFileTypeCheckBox(DWORD dwFileType)
{
	///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
	//vector<int> vnCheckBox = { IDC_CHECK_PROJECT, IDC_CHECK_THEME, IDC_CHECK_CODE, IDC_CHECK_SETTINGS, IDC_CHECK_FITTING, IDC_CHECK_OTHER, IDC_CHECK_ALLOW_EXPORT_OPX, IDC_CHECK_SHOW_USER_FILES };
	//vector<int> vnFileType = { CHECK_PROJECT, CHECK_THEME, CHECK_CODE, CHECK_SETTINGS, CHECK_FITTING, CHECK_OTHER, CHECK_ALLOW_EXPORT_OPX, CHECK_SHOW_UFF_FILES };
	///------ Tony 09/18/2012 ORG-6862-P1 SUPPORT_PATCH_EXE_TRANSFER
	//add IDC_CHECK_FITTING & CHECK_PATCH
	vector<int> vnCheckBox = { IDC_CHECK_PROJECT, IDC_CHECK_THEME, IDC_CHECK_CODE, IDC_CHECK_SETTINGS, IDC_CHECK_FITTING, IDC_CHECK_PATCH, IDC_CHECK_OTHER, IDC_CHECK_ALLOW_EXPORT_OPX, IDC_CHECK_SHOW_USER_FILES,IDC_CHECK_HIDE_TRANSFERRED_FILES, IDC_CHECK_SHOW_NEWER_FILES_ONLY};
	vector<int> vnFileType = { CHECK_PROJECT, CHECK_THEME, CHECK_CODE, CHECK_SETTINGS, CHECK_FITTING, CHECK_PATCH, CHECK_OTHER, CHECK_ALLOW_EXPORT_OPX, CHECK_SHOW_UFF_FILES, CHECK_HIDE_TRANSFERRED_FILES, CHECK_SHOW_NEWER_FILES_ONLY};
	///------ End SUPPORT_PATCH_EXE_TRANSFER
	///------ End HIDE_NOT_NEWER_STATUS_FILES_ROWS
	
	for (int i = 0 ; i < vnCheckBox.GetSize() ; ++i)
	{
		Button CheckBox = GetItem(vnCheckBox[i]);
		if (dwFileType & vnFileType[i])
			CheckBox.Check = true;
		else
			CheckBox.Check = false;
	}
}

///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
void TransferFilesDlg::updateRecursive()
{
	Button btn;
	btn = GetItem(IDC_CHECK_RECURSIVE_SPECIFIED_FOLDER);
	if(btn.Check && btn.Visible)
		m_helper.SetRecursive(BE_RECURSIVE);
	else
		m_helper.SetRecursive(NOT_RECURSIVE);
}
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
bool TransferFilesDlg::getEllipsisText(int nWidth, string &strText)
{
	string strEllipsis = "...";
	int nEllipsisWidth = 0;
	GetTextExtentSize(strEllipsis, &nEllipsisWidth);
	UseEllipsisCutTextHelper cutText;

	DeviceContext dc(m_wndDlg);
	if(!cutText.GetText(dc, nWidth - nEllipsisWidth, strText))
		return false;

	strText += strEllipsis;
	return true;
}
///------ End CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP

///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
int TransferFilesDlg::getCurrentSel()
{
	int nCurSel = m_Location.GetCurSel();
	if( !checkExportOPX() && nCurSel >= m_nCurrentLocationIndex)	
		nCurSel++;
	return nCurSel;
}
///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX

void TransferFilesDlg::updateSourceFileList()
{
	DWORD dwFileType = getFileType();
	///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	//int nSel = m_Location.GetCurSel();
	//string strKey = nSel >= m_vsSourceKeys.GetSize() ? STR_SPECIFIED_FOLDER : m_vsSourceKeys[nSel];
	//if( !checkExportOPX() && nSel >= m_nCurrentLocationIndex)	
			//nSel++;
	int nSel = getCurrentSel();
	string strKey;
	strKey = nSel >= m_vsSourceKeys.GetSize() ? STR_SPECIFIED_FOLDER : m_vsSourceKeys[nSel];
	///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
	if (m_strLastLocationKey.IsEmpty())
		m_strLastLocationKey = strKey;
	
	ASSERT(strKey == m_strLastLocationKey);
	
	///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
	string strUFF;
	if ( nSel < m_vsSourceUFFPath.GetSize())		
			strUFF = m_vsSourceUFFPath[nSel];
	else
		strUFF = m_strSpecifiedFolder;
	string strUFFHint = _L("Path: ") + strUFF;
	///------ Tony 08/23/2012 ORG-6330-S9 CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
	Control ctrlCurentUff = GetItem(IDC_CURRENT_UFF_HINT);
	if( !ctrlCurentUff )
		return;
	ctrlCurentUff.SetToolTip(strUFFHint);
	RECT rrCtrl;
	GetControlClientRect(IDC_CURRENT_UFF_HINT, rrCtrl);
	getEllipsisText(RECT_WIDTH(rrCtrl) * 1.3, strUFFHint);
	///------ End CHANGE_TEXT_CONTROL_TO_EDIT_CONTROL_SUPPORT_TOOLTIP
	ctrlCurentUff.Text = strUFFHint;
	///end NEW_TRANSFER_USER_FILES_DLG_GUI
	
	vector<string> vsFiles;
	vector<string> vsFileInfo;
	
	///------ Tony 08/22/2012 ORG-6330-P2 SHOULD_NOT_UPDATE_SOURCE_LIST_WHEN_SPECIAL_FLODER_IS_EMPTY
 	if(!strKey.CompareNoCase(STR_SPECIFIED_FOLDER) && m_strSpecifiedFolder.IsEmpty())
		;
	else
	///------ End SHOULD_NOT_UPDATE_SOURCE_LIST_WHEN_SPECIAL_FLODER_IS_EMPTY
		m_helper.GetFileInfo(dwFileType, strKey, m_strSpecifiedFolder, vsFiles, vsFileInfo);
	
	m_SourceList.SetRows(vsFiles.GetSize());
	m_SourceList.SetTableValue(vsFileInfo, true);
	
	hideTransferredFiles(strKey, vsFiles);		///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	
	m_SourceList.SetTransferHelper(&m_helper, strKey, m_strSpecifiedFolder);
	
	updateSpecifiedListStatus(m_SourceList);			///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
}
///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
void TransferFilesDlg::updateSpecifiedListStatus(GridTableControl &gtControlList, bool bGroupFolderList/* = false*/)
{
	vector<string> vsSourceFilesPath;
	vector<string> vsCurrentFilesPath;
	vector<string> vsRegKey;
	int nOffset;
	if(bGroupFolderList)
	{
		m_SelectedList.GetFilePathList(vsCurrentFilesPath);
		vsSourceFilesPath = vsCurrentFilesPath;
		nOffset = m_SelectedList.GetRowOffset();
	}
	else
	{
		m_SourceList.GetFilePathList(vsSourceFilesPath, vsCurrentFilesPath);
		nOffset = m_SourceList.GetRowOffset();
	}
	vsRegKey.SetSize(vsSourceFilesPath.GetSize());
	vsRegKey = m_strLastLocationKey;
	
	vector<int> vnStatus;
 
	m_helper.GetCurrentFileStatus(vsRegKey, m_strSpecifiedFolder, vsSourceFilesPath, vsCurrentFilesPath, vnStatus);

	for (int ii = 0 ; ii < vnStatus.GetSize() ; ++ii)
	{
		updateStatusColor(gtControlList, ii, nOffset, vnStatus[ii], bGroupFolderList);	
		gtControlList.SetRowData(nOffset + ii, vnStatus[ii])
	}	
	
	showNewerFilesOnly(gtControlList, vnStatus);		///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
}
///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
void TransferFilesDlg::updateListStatus()
{
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//vector<string> vsFilesPath;
	//vector<string> vsRegKey;
	//m_SelectedList.GetFilePathList(vsFilesPath);
	vector<string> vsSourceFilesPath;
	vector<string> vsCurrentFilesPath;
	vector<string> vsCurrentFilesName;
	vector<string> vsRegKey;
	
	m_SelectedList.GetFilePathList(vsCurrentFilesPath);
	m_SelectedList.GetRegKey(vsRegKey);
	vsSourceFilesPath.SetSize(0);
	vsCurrentFilesName.SetSize(0);
	
	for (int ii = 0; ii < vsCurrentFilesPath.GetSize(); ii++)
	{
		vsCurrentFilesName.Add(GetFileName(vsCurrentFilesPath[ii]));
	}
	
	for (ii = 0; ii < vsCurrentFilesPath.GetSize(); ii++)
	{
		int nOffset = m_SourceList.GetRowOffset();
		string strSourceFilePath;
		if(!vsRegKey[ii].Compare(STR_SPECIFIED_FOLDER))
		{
			for(int jj = 0; jj < m_SourceList.GetRows(); jj++)
			{
				string strSourceFileName;
				strSourceFileName = m_SourceList.GetCell(jj + nOffset, COL_FILE_NAME);
				if(!vsCurrentFilesName[ii].Compare(strSourceFileName))
				{
					strSourceFilePath =  m_SourceList.GetCell(jj + nOffset, COL_FILE_NAME_SPECIFIED);
					break;
				}
			}
		}
		else
			strSourceFilePath = vsCurrentFilesPath[ii];
		vsSourceFilesPath.Add(strSourceFilePath);	
	}
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

	vector<int> vnStatus;
	m_helper.GetCurrentFileStatus(vsRegKey, m_strSpecifiedFolder, vsSourceFilesPath, vsCurrentFilesPath, vnStatus);
	
	int nOffset = m_SelectedList.GetRowOffset();
	for (int i = 0 ; i < vnStatus.GetSize() ; ++i)
	{
		int nStatus = vnStatus[i];
		///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
		if ( m_SelectedList.GetRowData(i + nOffset) == STATUS_PREVIEW )
		{
			//no need to update status;
		}
		else
		{
		///end NEW_TRANSFER_USER_FILES_DLG_GUI
			Button btn;
			btn = GetItem(IDC_CHECK_SHOW_USER_FILES);
			///------ Tony 08/22/2012 ORG-6330-S5 STATUS_SAME_CURRENT_SHOULD_NOT_CHANGE_BY_CHECK_SHOW_USER_FILES
			///------ Tony 08/06/2012 ORG-6330-S5 TRANSFERRED_FILES_SHOULD_BE_GRAY_WHEN_CHECK_SHOW_CURRENT_FILES_LIST
			//Button btnTransfer;
			//btnTransfer = GetItem(IDC_TRANSFER);
			//if(btn.Check && btnTransfer.Check)
			//{
			//	nStatus  = STATUS_PREVIEW;
			//}
			///------ End TRANSFERRED_FILES_SHOULD_BE_GRAY_WHEN_CHECK_SHOW_CURRENT_FILES_LIST
			///------ End STATUS_SAME_CURRENT_SHOULD_NOT_CHANGE_BY_CHECK_SHOW_USER_FILES
			m_SelectedList.SetCell(i + nOffset, COL_SELECTED_LIST_FILE_STATUS, _get_status_string(nStatus));
			m_SelectedList.SetRowData(i + nOffset, nStatus);
			///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
			//m_SelectedList.SetRowColor(i + nOffset, COLOR_BLACK);
			updateStatusColor(m_SelectedList, i, nOffset, nStatus);
			///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
			///Sophy 3/8/2012 ORG-2840-P1 NEW_TRANSFER_USER_FILES_DLG_GUI
		}
			///end NEW_TRANSFER_USER_FILES_DLG_GUI
	}
		
	enableLocation();		///------ Tony 07/30/2012 ORG-6383-P1 DISABLE_DROPDOWNLIST_WHEN_CLICK_TRANSFER
	
	updateOpxExportHint();		///------ Tony 08/02/2012 ORG-6330-S3 ADD_HOW_MANY_FILES_EXPORTED_HINT_TEXT
}

///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
void TransferFilesDlg::updateGroupFolderList()
{
	vector<string> vsFiles;
	vector<string> vsFileInfo;
	
	m_helper.GetFileInfo(getFileType(), m_vsSourceKeys[m_nCurrentLocationIndex], m_strSpecifiedFolder, vsFiles, vsFileInfo, false);
		
	m_SelectedList.SetRows(vsFiles.GetSize());
	m_SelectedList.SetTableValue(vsFileInfo, true);

	m_SelectedList.SetTransferHelper(&m_helper, m_vsSourceKeys[m_nCurrentLocationIndex], m_strSpecifiedFolder);
	
	updateSpecifiedListStatus(m_SelectedList, true);
}
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

///------ Tony 07/25/2012 ORG-6330-S5 ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT
void TransferFilesDlg::updateStatusColor(GridTableControl &gtControl, int nRow, int nOffset, int nStatus,  bool bGroupFolderList/* = false*/)
{
	switch (nStatus)
	{
		case STATUS_NEW:
		{
			gtControl.SetRowColor(nRow + nOffset, SYSCOLOR_BLACK);
			break;
		}
	
		case STATUS_NEWER:
		{
			if(bGroupFolderList)
				gtControl.SetRowColor(nRow + nOffset, COLOR_DARKGREEN);
			else
				gtControl.SetRowColor(nRow + nOffset, COLOR_RED);
			break;
		}
		
		case STATUS_OLDER:
		{
			if(bGroupFolderList)
				gtControl.SetRowColor(nRow + nOffset, COLOR_RED);
			else
				gtControl.SetRowColor(nRow + nOffset, COLOR_DARKGREEN);
			break;
		}
		
		case STATUS_SAME:
		{
			gtControl.SetRowColor(nRow + nOffset, COLOR_BLUE);
			break;
		}
		
		case STATUS_CURRENT:
		{
			gtControl.SetRowColor(nRow + nOffset, COLOR_BLUE);
			break;
		}
					
		case STATUS_PREVIEW:
		{
			gtControl.SetRowColor(nRow + nOffset, RGB(127, 127, 127));		///------ Tony 08/01/2012 ORG-6330-S5 GRAY_FIELS_AFTER_TANSFER
			break;
		}
	}
	return;
}

///------ Tony 08/20/2012 ORG-6330-S3 EXPORT_FILES_SHOULD_NOT_INCLUDE_PREVIEW_FILES
void TransferFilesDlg::clearSelectedFileList()
{
	int nOffset = m_SelectedList.GetRowOffset();
	Button btn = GetItem(IDC_CHECK_SHOW_USER_FILES);
	bool bShowUserFiles;
	bShowUserFiles = btn.Check;
	for (int nRow = m_SelectedList.GetRows() - 1; nRow >= nOffset ; nRow--)
	{
		if (bShowUserFiles && (m_SelectedList.GetRowData(nRow) == STATUS_SAME || m_SelectedList.GetRowData(nRow) == STATUS_CURRENT))
		{
			m_SelectedList.SetCell(nRow, COL_SELECTED_LIST_FILE_REG_KEY, m_vsSourceKeys[m_nCurrentLocationIndex]);
			m_SelectedList.SetCell(nRow, COL_SELECTED_LIST_FILE_STATUS, _get_status_string(STATUS_PREVIEW));
			m_SelectedList.SetRowData(nRow, STATUS_PREVIEW);
			updateStatusColor(m_SelectedList, nRow, 0, STATUS_PREVIEW);
		}
		if ( m_SelectedList.GetRowData(nRow) == STATUS_PREVIEW )
			continue;
		m_SelectedList.DeleteRow(nRow);
	}
}
///------ End EXPORT_FILES_NOT_INCLUDE_PREVIEW_FILES

///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
void TransferFilesDlg::updateINIFile()
{
	INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
	int nVersion = iniFile.ReadInt(STR_SECTION, STR_VERSION, -1);
	nVersion++;
	iniFile.WriteInt(STR_SECTION, STR_VERSION, nVersion);
	iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 1);
}
///------ End UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE

///------ Tony 08/07/2012 ORG-6325-P1 UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE
bool TransferFilesDlg::CopyClientUpdateEXE()
{
	return copyfile(okutil_get_origin_path(ORIGIN_PATH_SYSTEM, ALL_USERS_FOLDER) + AUTO_UPDATE_EXE, okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + AUTO_UPDATE_EXE);
}
///------ End UPDATE_ISPUBLISHED_VERSION_OF_UPDATEINI_FILE

///------ Tony 08/01/2012 ORG-2840-S5 HIDE_NOT_NEWER_STATUS_FILES_ROWS
void TransferFilesDlg::showNewerFilesOnly(GridTableControl &gtControl, vector<int> vnStatus)
{
	Button btn = GetItem(IDC_CHECK_SHOW_NEWER_FILES_ONLY);
	bool bCheckShowNewerOnly;
	bCheckShowNewerOnly = btn.Check;
	for (int ii = 0 ; ii < vnStatus.GetSize() ; ++ii)
	{
		if(vnStatus[ii] != STATUS_NEWER)
		{
			if(bCheckShowNewerOnly)
				gtControl.SetIsRowHidden(ii +1, true);
			else
				gtControl.SetIsRowHidden(ii +1, false);
		}	
	}		
}
///------ End HIDE_NOT_NEWER_STATUS_FILES_ROWS
///------ End ROLL_BACK_COLOR_AND_NDICATE_STATUS_HINT

///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
void TransferFilesDlg::hideTransferredFiles(LPCSTR lpcszRegKey, vector<string> & vsFiles)
{
	Button btn = GetItem(IDC_CHECK_HIDE_TRANSFERRED_FILES);
	bool bHideTransferredFiles = btn.Check;
	int nOffset = m_SourceList.GetRowOffset();
	if(bHideTransferredFiles)
	{
		for(int ii = 0; ii < m_vsTransferredFiles.GetSize(); ii++)
		{
			if(!m_vsTransferredRegKey[ii].Compare(lpcszRegKey))
			{
				for(int jj = 0; jj <vsFiles.GetSize(); jj++)	
				{
					///------ Tony 08/30/2012 ORG-6686-P1 CORRECT_WITH_NEW_FILESINFO
					//if(!m_vsTransferredFiles[ii].Compare(vsFileInfo[jj * 5 + 1] + vsFileInfo[jj * 5]))
					//string str = vsFileInfo[jj * nRet+ 2]+ vsFileInfo[jj * nRet] ; 
					string strName =  m_SourceList.GetCell(jj + nOffset, COL_FILE_CATEGORY) + m_SourceList.GetCell(jj + nOffset, COL_FILE_NAME);
					if(!m_vsTransferredFiles[ii].Compare(strName))
					///------ End CORRECT_WITH_NEW_FILESINFO
					{
						///------ Tony 08/30/2012 ORG-6686-P1 CORRECT_WITH_NEW_FILESINFO
						//vsFiles.RemoveAt(jj);
						//remove vsFileInfo
						//for(int xx = 0; xx < 5; xx++)
						//	vsFileInfo.RemoveAt(jj * 5);
						m_SourceList.DeleteRow(jj + nOffset);
						///------ End CORRECT_WITH_NEW_FILESINFO
					}
				}
			}
		}
	}
}
///------ End SHOW_TRANSFERRED_FILES

void TransferFilesDlg::addFileToList()
{
	vector<uint> vnSelectedRows;	
	m_SourceList.GetSelRows(vnSelectedRows);
	
	if (vnSelectedRows.GetSize() == 0)
		return;

	vector<string> vsExist;
	m_SelectedList.GetFilePathList(vsExist);
	
	int nRowOffset = m_SelectedList.GetRowOffset();
	for (int i = 0 ; i < vnSelectedRows.GetSize() ; ++i)
	{
		string strFileName = m_SourceList.GetCell(vnSelectedRows[i], COL_FILE_NAME);
		string strCate = m_SourceList.GetCell(vnSelectedRows[i], COL_FILE_CATEGORY);
		string strPath = strCate + strFileName;
		
		// replace regkey if file already in list
		int nFound = vsExist.Find(strPath);		
		if (nFound != -1)
		{
			m_SelectedList.SetCell(nFound + nRowOffset, COL_SELECTED_LIST_FILE_REG_KEY, m_strLastLocationKey);
			m_SelectedList.SetRowData(nFound + nRowOffset, STATUS_CURRENT); //need to reset later.
		}
		else
		{		
			int nRows = m_SelectedList.GetRows();
			m_SelectedList.SetRows(nRows);
			m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_NAME, strFileName);	
			m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_CATEGORY, strCate);
			m_SelectedList.SetCell(nRows, COL_SELECTED_LIST_FILE_REG_KEY, m_strLastLocationKey);
			m_SelectedList.SetRowData(nRows, STATUS_CURRENT); //need to reset later.
		}
	}
}

void TransferFilesDlg::removeFileFromList()
{
	vector<uint> vnSelectedRows;	
	m_SelectedList.GetSelRows(vnSelectedRows);
	
	for (int i = vnSelectedRows.GetSize() - 1 ; i >= 0 ; --i)
	{
		///------ Tony 08/06/2012 when check show current user files ,only new files should be delete in vnSelectedRows
		Button btn = GetItem(IDC_CHECK_SHOW_USER_FILES);
		if (btn.Check && m_SelectedList.GetRowData(vnSelectedRows[i]) != STATUS_PREVIEW && m_SelectedList.GetRowData(vnSelectedRows[i]) != STATUS_NEW)
		{
			m_SelectedList.SetCell(vnSelectedRows[i], COL_SELECTED_LIST_FILE_REG_KEY, m_vsSourceKeys[m_nCurrentLocationIndex]);
			m_SelectedList.SetCell(vnSelectedRows[i], COL_SELECTED_LIST_FILE_STATUS, _get_status_string(STATUS_PREVIEW));
			m_SelectedList.SetRowData(vnSelectedRows[i], STATUS_PREVIEW);
			updateStatusColor(m_SelectedList, vnSelectedRows[i], 0, STATUS_PREVIEW);
		}
		///----- END
		if ( m_SelectedList.GetRowData(vnSelectedRows[i]) == STATUS_PREVIEW )
			continue;
		m_SelectedList.DeleteRow(vnSelectedRows[i]);
	}
}

///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
void TransferFilesDlg::transferFileToList(bool bGroupFolder)
{
	vector<int> vnStatus;
	vector<uint> vnSelectedRows;	
	vector<string> vsRegKey;
	vector<string> vsSourcePathList;
	vector<string> vsCurrentPathList;
	vector<string> vsSelectedPathList;
	if(bGroupFolder)
	{
		m_SelectedList.GetSelRows(vnSelectedRows);
		m_SelectedList.GetFilePathList(vsSourcePathList);
	}
	else
	{
		m_SourceList.GetSelRows(vnSelectedRows);
		m_SourceList.GetFilePathList(vsSourcePathList, vsCurrentPathList);
	}
	
	if (vnSelectedRows.GetSize() == 0)
		return;

	vnStatus.SetSize(0);
	vsSelectedPathList.SetSize(0);
	for(int ii = 0; ii < vnSelectedRows.GetSize(); ii++)
	{
		if(bGroupFolder)
			vnStatus.Add(m_SelectedList.GetRowData(vnSelectedRows[ii]));
		else	
			vnStatus.Add(m_SourceList.GetRowData(vnSelectedRows[ii]));
		vsSelectedPathList.Add(vsSourcePathList[vnSelectedRows[ii] - 1]);
		vsRegKey.Add(m_vsSourceKeys[m_nCurrentLocationIndex]);
	}

	checkRemoveOlder(vsSelectedPathList, vsRegKey, vnStatus);
	
	int nFileTransfered = m_helper.TransferFiles(vsRegKey, m_strSpecifiedFolder, vsSelectedPathList, !bGroupFolder);
	///------ End SHOW_TRANSFERRED_FILES
	string strOutInfo;
	ocu_load_err_msg_str(MSG_NUM_FILES_TRANSFERRED, strOutInfo);
	strOutInfo.Format(strOutInfo, nFileTransfered);

	if(0 != nFileTransfered)
	{
		for(int ii = 0; ii < vnSelectedRows.GetSize(); ii++)
		{
			if(bGroupFolder)
			{
				m_SelectedList.SetRowData(vnSelectedRows[ii], STATUS_SAME);
				m_SelectedList.SetRowColor(vnSelectedRows[ii], COLOR_BLUE);
			}
			else
			{
				m_SourceList.SetRowData(vnSelectedRows[ii], STATUS_SAME);
				m_SourceList.SetRowColor(vnSelectedRows[ii], COLOR_BLUE);
			}
		}
	}
	
	warning_msg_box(strOutInfo, false, 'W');

	GetItem(IDC_TRANSFER).Enable = true;
	INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
	iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);

	if(bGroupFolder)
	{
		updateSourceFileList();
	}
	else
	{
		updateGroupFolderList();
	}
}
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

void TransferFilesDlg::doTransferFiles()
{
	vector<string> vsFilesPath;
	vector<string> vsRegKey;
	m_SelectedList.GetFilePathList(vsFilesPath, false);
	m_SelectedList.GetRegKey(vsRegKey, false);
	
	checkOlderFile(vsRegKey, vsFilesPath);
	///------ Tony 07/26/2012 ORG-6330-S7 SHOW_TRANSFERRED_FILES
	//	int nFileTransfered = m_helper.TransferFiles(vsRegKey, m_strSpecifiedFolder, vsFilesPath);
	int nFileTransfered = m_helper.TransferFiles(vsRegKey, m_strSpecifiedFolder, vsFilesPath, true, m_vsTransferredFiles, m_vsTransferredRegKey);
	///------ End SHOW_TRANSFERRED_FILES
	string strOutInfo;
	ocu_load_err_msg_str(MSG_NUM_FILES_TRANSFERRED, strOutInfo);
	strOutInfo.Format(strOutInfo, nFileTransfered);
	///------ Tony 07/24/2012 ORG-6330-S1 CANCEL_CHANGE_TO_CLOSE_AFTER_TRANSFER
	if(0 != nFileTransfered)
	{
		Button btnCancel = GetItem(IDCANCEL);
		btnCancel.Text = STR_BTN_NAME_CLOSE;
	}
	///------ End CANCEL_CHANGE_TO_CLOSE_AFTER_TRANSFER
	warning_msg_box(strOutInfo, false, 'W');
}

bool TransferFilesDlg::checkOlderFile(vector<string> & vsRegKey, vector<string> & vsFilesPath)
{
	vector<int> vnStatus;
	m_SelectedList.GetFileStatus(vnStatus);
	
	bool bSkipOlder = false;
	int i;
	
	for (i = vnStatus.GetSize() - 1 ; i >= 0  ; --i)
	{
		if (vnStatus[i] == STATUS_OLDER)
		{
			bSkipOlder = (OM_RETURN_NO == OptionalMessage("FBReplaceNewerWithOlder", MB_YESNO));
			break;
		}
	}
	
	///------ Tony 07/12/2012 ORG-2840-P5 VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH
	int jj = 0;		
	//for (i = vnStatus.GetSize() - 1 ; i >= 0  ; --i)
	for (i = 0; i < vnStatus.GetSize(); i++)
	///------END VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH
	{
		bool bNoNeedTransfer = (vnStatus[i] == STATUS_CURRENT || vnStatus[i] == STATUS_SAME || (bSkipOlder && (vnStatus[i] == STATUS_OLDER)));
		if (bNoNeedTransfer)
		{
			///------ Tony 07/12/2012 ORG-2840-P5 VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH
			//vsRegKey.RemoveAt(i);
			//vsFilesPath.RemoveAt(i);
			vsRegKey.RemoveAt(jj);
			vsFilesPath.RemoveAt(jj);
			///------ End VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH
		}
		else if(vnStatus[i] != STATUS_PREVIEW)
			jj++;		///------ Tony 07/12/2012 ORG-2840-P5 VNSTATUS_AND_VSREGKEY_VECTOR_NOT_MATCH
	}
	
	return bSkipOlder;
}

///------ Tony 08/07/2012 ORG-6325-S1 UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG
bool TransferFilesDlg::checkRemoveOlder(vector<string>& vsFilesPath, vector<string>& vsRegKey, vector<int>& vnStatus)
{
	bool bSkipOlder = false;
	
	for (int i = vnStatus.GetSize() - 1 ; i >= 0  ; --i)
	{
		if (vnStatus[i] == STATUS_OLDER)
		{
			bSkipOlder = (OM_RETURN_NO == OptionalMessage("FBReplaceNewerWithOlder", MB_YESNO));
			break;
		}
	}
	
	for (i = 0; i < vnStatus.GetSize(); i++)
	{
		bool bNoNeedTransfer = ( vnStatus[i] == STATUS_SAME || (bSkipOlder && (vnStatus[i] == STATUS_OLDER)));
		if (bNoNeedTransfer)
		{
			vsFilesPath.RemoveAt(i);
			vnStatus.RemoveAt(i);
			vsRegKey.RemoveAt(i);
		}
	}
	
	return bSkipOlder;
}
///------ End UPTATE_GROUP_FOLDER_MANAGER_GUI_AS_NEW_TRANSFER_FILES_DIALOG

void TransferFilesDlg::exportFiles()
{
	string strOpxFileName;
	
	vector<string> vsFileNames;
	init_fdlog_with_group_name("*.opx");
	if( 0 == GetFDLogBox(vsFileNames, FDLOG_TYPE_SAVE_AS) )
		return;
	
	strOpxFileName = vsFileNames[0];
	
	vector<string> vsFilesPath;
	vector<string> vsRegKey;
	///------ Tony 08/20/2012 ORG-6330-S3 EXPORT_FILES_SHOULD_NOT_INCLUDE_PREVIEW_FILES
	//m_SelectedList.GetFilePathList(vsFilesPath);
	//m_SelectedList.GetRegKey(vsRegKey);
	m_SelectedList.GetFilePathList(vsFilesPath, false);
	m_SelectedList.GetRegKey(vsRegKey, false);
	///------ End EXPORT_FILES_NOT_INCLUDE_PREVIEW_FILES
	m_helper.ExportFiles(vsRegKey, m_strSpecifiedFolder, vsFilesPath, strOpxFileName);
	///------ Tony 07/24/2012 ORG-6330-S2 OUTPUT_FILEPATH_TO_MESSAGE_LOG_AFTER_OPX
	string strOutInfo;
	strOutInfo = "Exported to " + strOpxFileName;
	warning_msg_box(strOutInfo, false, 'W');
	///------ End OUTPUT_FILEPATH_TO_MESSAGE_LOG_AFTER_OPX
}

///------ Tony 07/12/2012 ORG-2840-P4 FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX
bool TransferFilesDlg::checkExportOPX()
{
	Button btn = GetItem(IDC_CHECK_ALLOW_EXPORT_OPX);
	return btn.Check;
}
///------ End FIX_BROWSE_SPECIFIED_FOLDER_AND_EXPORT_TO_OPX

void TransferFilesDlg::saveSetting()
{
	dlg_save_to_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strLastLocationKey);

	DWORD dwFileType = getFileType();
	dlg_save_to_registry(m_strDlgName, STR_CHECK_BOX, dwFileType);

	dlg_save_to_registry(m_strDlgName, STR_USER_SPECIFIED_FOLDER, m_strSpecifiedFolder);
}

void TransferFilesDlg::loadSetting()
{
	dlg_load_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strLastLocationKey);
	
	DWORD dwFileType = 0;
	dlg_load_registry(m_strDlgName, STR_CHECK_BOX, dwFileType, CHECK_FITTING | CHECK_THEME);
	setFileTypeCheckBox(dwFileType);

	dlg_load_registry(m_strDlgName, STR_USER_SPECIFIED_FOLDER, m_strSpecifiedFolder);
}

BOOL OpenTransferFileDlg(HWND hParent = NULL)
{
	TransferFilesDlg dlg;
	return (IDOK == dlg.DoModalEx(hParent));
}

BOOL OpenGroupFolderManagerDlg(HWND hParent = NULL)
{
	TransferFilesDlg dlg(true);
	return (IDOK == dlg.DoModalEx(hParent));
	
}
