/*------------------------------------------------------------------------------*
 * File Name: ThemeGalleryListCtrl.c											*
 * Creation: Kit 10/18/2011														*
 * Purpose: Origin C support for a Theme Gallery List Control					*
 * Copyright (c) OriginLab Corp. 2011											*
 * All Rights Reserved															*
 * 																				*
 *	Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY		*
 *------------------------------------------------------------------------------*/
#include <origin.h>
#include "ThemeGalleryListCtrl.h"

#define _CAT "Theme"

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//// the following is the col arrangement, so the str and the enum must be consistent
////--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
////#define STR_THEME_GRID_COLS "System|Location|Contents|Name"
////#define STR_THEME_GRID_COLS "System|Name|Size|Date|Path" //CPY 4/25/03 ADD_FILE_DATE added date column
////#define STR_THEME_GRID_COLS _LC("System|Name|Size|Date|Path", _CAT) ///AW 10/21/07 MORE_ON_LOCALIZATION
//#define STR_THEME_GRID_COLS _LC("System|Name|Size|Path|Date", _CAT)	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH 
////---
////#define STR_ANALYSIS_THEME_GRID_COLS "System|Menu|Name|Function|Category|Scope|Size|Date|Path" ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
////#define STR_ANALYSIS_THEME_GRID_COLS _LC("System|Menu|Name|Function|Category|Scope|Size|Date|Path", _CAT) ///AW 10/21/07 MORE_ON_LOCALIZATION
//#define STR_ANALYSIS_THEME_GRID_COLS _LC("System|Menu|Name|Function|Category|Scope|Size|Path|Date", _CAT)	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH

#define STR_GRID_LIST_COLS_NAME _LC("System|Menu|Name|Function|Category|Scope|Size|Path|Date|Extension", _CAT)
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

/************************************************************************/
/* ThemeGWListControlMenu
/************************************************************************/
///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
//ThemeGWListControlMenu(bool bEdit, bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//ThemeGWListControlMenu::ThemeGWListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
ThemeGWListControlMenu::ThemeGWListControlMenu(DWORD dwMenuBis)
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
{
	m_nChoice = -1;
	Add(_L("Add &New"), OnMenuItem);
	Add(NULL, OnMenuItem);
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//Add(_L("&Edit..."), OnMenuItem, (bEdit && bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	Add(_L("&Edit..."), OnMenuItem, (O_QUERY_BOOL(dwMenuBis, PMS_InsideGrid)&& !O_QUERY_BOOL(dwMenuBis, PMS_MultiSel)) ? MF_ENABLED : MF_GRAYED);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	Add(_L("&Delete"), OnMenuItem, O_QUERY_BOOL(dwMenuBis, PMS_InsideGrid) ? MF_ENABLED : MF_GRAYED);
	Add(NULL, OnMenuItem);
	Add(_L("D&uplicate"), OnMenuItem, (O_QUERY_BOOL(dwMenuBis, PMS_InsideGrid) && !O_QUERY_BOOL(dwMenuBis, PMS_MultiSel)) ? MF_ENABLED : MF_GRAYED);
	Add(_L("Com&bine"), OnMenuItem, (O_QUERY_BOOL(dwMenuBis, PMS_InsideGrid) && O_QUERY_BOOL(dwMenuBis, PMS_MultiSel)) ? MF_ENABLED : MF_GRAYED);

	Add(NULL, OnMenuItem);

	const bool bEnableSetAsSysTheme = O_QUERY_BOOL(dwMenuBis, PMS_CanBeSystemTheme) && O_QUERY_BOOL(dwMenuBis, PMS_InsideGrid) 
									&& !O_QUERY_BOOL(dwMenuBis, PMS_SystemTheme) && !O_QUERY_BOOL(dwMenuBis, PMS_MultiSel);

	Add(_L("&Set as System Theme"), OnMenuItem, bEnableSetAsSysTheme ? MF_ENABLED : MF_GRAYED );
	Add(_L("&Clear System Theme"), OnMenuItem, O_QUERY_BOOL(dwMenuBis, PMS_HasSystemTheme) ? MF_ENABLED : MF_GRAYED );

	Add(NULL, OnMenuItem);

	Add(_L("Show &Tooltips"), OnMenuItem, O_QUERY_BOOL(dwMenuBis, PMS_ShowToolTips) ? MF_CHECKED : MF_UNCHECKED);
}

bool ThemeGWListControlMenu::GetCommand(int& nChoice)
{
	if(m_nChoice >= THEME_ADD && m_nChoice <= THEME_SHOW_TOOLTIPS)
	{
		nChoice = m_nChoice;
		return true;
	}
	return false;
}
/************************************************************************/
/* ThemeAnalysisListControlMenu
/************************************************************************/
///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//ThemeDialogListControlMenu::ThemeDialogListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
ThemeDialogListControlMenu::ThemeDialogListControlMenu(DWORD dwMenuBits)
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
{
	m_nChoice = -1;
	//Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
	Add(_L("&Delete"), OnMenuItem, O_QUERY_BOOL(dwMenuBits, PMS_InsideGrid) ? MF_ENABLED : MF_GRAYED);
	Add(NULL, OnMenuItem);
	Add(_L("D&uplicate"), OnMenuItem, (O_QUERY_BOOL(dwMenuBits, PMS_InsideGrid) && !O_QUERY_BOOL(dwMenuBits, PMS_MultiSel)) ? MF_ENABLED : MF_GRAYED);
	//Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
	Add(NULL, OnMenuItem);

	Add(_L("Show &Tooltips"), OnMenuItem, O_QUERY_BOOL(dwMenuBits, PMS_ShowToolTips) ? MF_CHECKED : MF_UNCHECKED);
}	

bool ThemeDialogListControlMenu::GetCommand(int& nChoice)
{
	//if(m_nChoice >= ANALYSIS_THEME_EDIT && m_nChoice <= ANALYSIS_THEME_SHOW_TOOLTIPS)
	if(m_nChoice >= ANALYSIS_THEME_DELETE && m_nChoice <= ANALYSIS_THEME_SHOW_TOOLTIPS)
	{
		nChoice = m_nChoice;
		return true;
	}
	return false;
}

/************************************************************************/
/* ThemeListControlBase
/************************************************************************/
void ThemeListCtrlBase::Init(int nID, Dialog& dlg)
{	
	GridListControl::Init(nID, dlg);
	ClearAll();
	Reset();
	SetAlternateRowColors();
	///Joseph 11/08/06  CLEAR_ROW_CONTENT	
	//m_flx.Rows = 1;
	//m_flx.FixedRows = 1;
	///End CLEAR_ROW_CONTENT

	///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	//hidecolAndsetFormat();
	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	m_flx.FixedCols = 0;//hide the Row heading

	m_flx.ExtendLastCol = true;
	m_flx.SelectionMode = flexSelectionListBox;
	m_flx.AllowUserResizing = flexResizeColumns;
	m_flx.AutoSizeMode = flexAutoSizeColWidth;
	m_flx.AllowSelection = true;
	m_flx.Editable = flexEDKbdMouse;
	// allow sorting
	m_flx.ExplorerBar = flexExSortShow;
}

void ThemeListCtrlBase::Reset()
{
	m_flx.Rows = 1;	// 1 for fix row
	m_flx.FixedRows = 1;
	
	m_flx.Cols = LIST_COL_TOTAL;

	SetFormatStrLocal(STR_GRID_LIST_COLS_NAME, _CAT);
	hidecolAndsetFormat();
	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
}

// this function logical is copy from ThemeGallery afterEditUsed()
bool ThemeListCtrlBase::OnAfterEdit(LPCTSTR lpcszOldNameBeforeEdit, int nRow, int nCol)
{
	const string strNewAfterEdit = GetCell(nRow, nCol);
	if( strNewAfterEdit.CompareNoCase(lpcszOldNameBeforeEdit) != 0 )
	{
		const int nPathThpe = GetCellData(nRow, LIST_COL_PATH_TYPE);

		return OnAfterEditRename(lpcszOldNameBeforeEdit, strNewAfterEdit, nPathThpe);
	}

	return false;
}

// move from ThemeGallery.c
bool ThemeListCtrlBase::GetSelThemeFile(string &strSelFile)
{
	const int nSelRow = GetSelectedRow();
	if(nSelRow < 0)
		return false;

	strSelFile = GetThemeFileName(nSelRow);
	return true;
}
// move from ThemeGallery.c
bool ThemeListCtrlBase::GetSelThemeFiles(vector<string> &vsSelFiles)
{
	vector<uint> vnRows;

	if( !GetSelRows(vnRows) )
		return false;

	if( !vsSelFiles.SetSize(vnRows.GetSize()) )
		return false;

	for(int ii=0; ii<vnRows.GetSize(); ii++)
		vsSelFiles[ii] = GetThemeFileName(vnRows[ii]);

	return true;

}

MenuCmdMsg ThemeListCtrlBase::OnShowMenu(bool bShowTooltips, bool bHasSystemTheme, HWND hWndDlg, int nx, int ny)
{
	DWORD dwMenuBis = 0L;
	O_SET_BIT(dwMenuBis, PMS_ShowToolTips, bShowTooltips);
	O_SET_BIT(dwMenuBis, PMS_HasSystemTheme, bHasSystemTheme);

	int nRow, nCol;
	O_SET_BIT(dwMenuBis, PMS_InsideGrid ,IsInsideGrid(nx, ny, nRow, nCol));
	O_SET_BIT(dwMenuBis, PMS_SystemTheme, GetCheck(nRow, LIST_COL_IS_SYSTEM));

	vector<uint> vnRows;
	const bool bMulti = GetSelRows(vnRows) && (vnRows.GetSize() > 1);
	O_SET_BIT(dwMenuBis, PMS_MultiSel, bMulti);

	const bool bIsCanbeSystemTheme = !(bMulti || IsIncrementListRow(nRow));	// increment list theme is shown as italic
	O_SET_BIT(dwMenuBis, PMS_CanBeSystemTheme, bIsCanbeSystemTheme);

	return PopupMenu(dwMenuBis, hWndDlg, nx, ny);
}

//bool ThemeListCtrlBase::CheckSystemTheme(int nRowToCheck, string &strSysTheme)
//{
//	string strThemeName;
//	int nRowBeg = nRowToCheck, nRowEnd = nRowToCheck;
//
//	if(nRowToCheck < 0)
//	{
//		GetRowRange(nRowBeg, nRowEnd);
//	}
//
//	string strSystemTheme;
//
//	//-- read system theme from ini once, not each time in the loop
//	string strSysThemeINI, strSysThemePathKeyWordINI;
//	
//	strSysThemeINI = okutil_theme_get_system_theme(m_nThemeType);
//
//	for(int nRow = nRowBeg; nRow <= nRowEnd; nRow++)
//	{
//		strThemeName = GetCell(nRow, LIST_COL_NAME);
//		
//		const int nPathType = m_pThemeList->GetCellData(nRow, LIST_COL_PATH_TYPE);
//		// Category NULL for graph and wks themes
//		strThemeName = okutil_composite_name_from_components(nPathType, NULL, strThemeName);
//
//		/// DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME  read system theme from ini once, not each time in the loop
//		//-- check if theme agrees with system theme from ini file
//		const bool bCheck = (0 == strThemeName.CompareNoCase(strSysThemeINI));
//		if(bCheck)
//			strSystemTheme = strThemeName;
//
//		SetCheck(nRow, LIST_COL_IS_SYSTEM, bCheck);
//		SetBold(nRow, -1, bCheck);
//		
//	}
//	return true;
//}

void ThemeListCtrlBase::ConvColOrRowtoIndex(string& strTool)
{
	if(strTool.Find("DescStats") == 0)
	{
		if(strTool.Find("(Row)"))
			strTool.Replace("(Row)","_1");
		if(strTool.Find("(Col)"))
			strTool.Replace("(Col)","");
	}
}

bool ThemeListCtrlBase::IsInsideGrid(int nx, int ny, int &nRow, int &nCol)
{
	return (nx < 0 || ny < 0) ? GetSelCell(nx, ny, nRow, nCol) : FindCell(nx, ny, nRow, nCol);		
}

bool ThemeListCtrlBase::IsIncrementListRow(int nRow)
{
	return IsItalic(nRow, LIST_COL_NAME);
}

int ThemeListCtrlBase::PopupMenu(const ThemeListControlMenuBase &menu, HWND hWndDlg, int nx, int ny)
{
	menu.TrackPopupMenu(0,  nx, ny, hWndDlg);
	int nCmd;
	if ( !menu.GetCommand(nCmd) )
		return -1;

	return nCmd;
}

bool ThemeListCtrlBase::DelThemeFiles(LPCTSTR lpcszPath, const vector<string> &vsThemeFiles, vector<string> &vsClassOption)
{
	const int count = vsThemeFiles.GetSize();
	for(int ii = 0; ii < count; ii++)
	{
		CopyThemeFileToDeleteFolder(lpcszPath, vsThemeFiles[ii]);
		DeleteFile(vsThemeFiles[ii]);

		//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
		string strName, strTool, strScope, strCategory;
		theme_filename_to_options(vsThemeFiles[ii], strName, strTool, strScope ,strCategory);
		if ( vsClassOption.Find(strTool) < 0 )
			vsClassOption.Add(strTool);
		//------				
	}

	return (0 < count);
}

int ThemeListCtrlBase::AddTheme(const string& str, int nType, bool bIsIncrementList)
{
	int	nRow = m_flx.Rows;
	m_flx.AddItem(str);
	setAddCellFormat(nRow, nType, bIsIncrementList);
	return nRow;
}

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
void ThemeListCtrlBase::hideListCols()
{
	vector<bool> vbHideCols(LIST_COL_TOTAL);
	GetHideCols(vbHideCols);

	const size_t count = vbHideCols.GetSize();
	for ( size_t ii = 0; ii < count; ++ii )
	{
		HideCol(ii, !vbHideCols[ii]);
	}
}

void ThemeListCtrlBase::hidecolAndsetFormat()
{
	SetColFormat(LIST_COL_DATE, COL_DATE_FORMAT_TYPE_GeneralDate); //"Medium Date";
	SetColDataType(LIST_COL_DATE, flexDTDate);
	SetColDataType(LIST_COL_NAME, flexDTString);
	hideListCols();
}

void ThemeListCtrlBase::setAddCellFormat(int nRow, int nType, bool bIsIncrementList)
{
	SetCellData(nRow, LIST_COL_PATH_TYPE, nType);
	SetItalic(nRow, LIST_COL_NAME, bIsIncrementList);
}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

/************************************************************************/
/* ThemeGWListControl
/************************************************************************/

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeGWListCtrl::Reset()
//{
//	///Joseph 11/08/06  CLEAR_ROW_CONTENT
//	m_flx.Rows = 1;
//	m_flx.FixedRows = 1;
//	///End CLEAR_ROW_CONTENT
//	m_flx.Cols = GRID_COL_TOTAL;
//
//	///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//	SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
//	hidecolAndsetFormat();
//	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//}

//virtual 
int	ThemeGWListCtrl::GetHideCols(vector<bool> &vbHideCols)
{
	vbHideCols = true;
	vbHideCols[LIST_COL_IS_SYSTEM] = vbHideCols[LIST_COL_MENU] = 
	vbHideCols[LIST_COL_FUNCTION] = vbHideCols[LIST_COL_CATEGORY] = 
	vbHideCols[LIST_COL_SCOPE] = vbHideCols[LIST_COL_FILE_EXT] = false;
	return 5; // hide 5 cols
}

//virtual
string ThemeGWListCtrl::GetThemeFileName(int nRow)
{
	const string strTheme = GetCell(nRow, LIST_COL_NAME);
	const int nPathType = GetCellData(nRow, LIST_COL_PATH_TYPE);
	ASSERT(EXIST_NONE != nPathType);
	return okutil_theme_get_theme_file_name(strTheme, GetThemeType(), nPathType);
}

//virtual 
bool ThemeGWListCtrl::FindAllThemeFiles(TreeNode &trTheme)
{
	ASSERT(trTheme.IsValid());
	return theme_find_all_theme_files(trTheme, ORIGIN_PATH_UNDEF, GetThemeType()) > 0;
}

//virtual 
bool ThemeGWListCtrl::GetCopyOfThemeFileName(LPCTSTR lpcszOldFileName, string &strCopyFileName)
{
	string strOldThemeFilename = GetFileName(lpcszOldFileName, TRUE); // remove ext, and add later
	strCopyFileName.Format(_L("Copy of %s"), strOldThemeFilename);
	strCopyFileName += "." + THEME_FILE_EXT;
	return true;
}

//virtual 
int ThemeGWListCtrl::GetThemeFileType(LPCTSTR lpcszThemeFileWithExt)
{
	// lpcszThemeFileWithExt is not necessary!
	return GetThemeType();
}

//virtual 
bool ThemeGWListCtrl::OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType)
{
	return theme_rename(lpcszNewNameAfterEdit, lpcszOldNameBeforeEdit, nPathType, GetThemeType());
}

//virtual
MenuCmdMsg ThemeGWListCtrl::PopupMenu(DWORD dwMenuBits, HWND hWndDlg, int nx, int ny)
{
	ThemeGWListControlMenu	myMenu(dwMenuBits);

	const int nCmd = PopupMenu(myMenu, hWndDlg, nx, ny);
	if ( nCmd < 0  )
		return MCM_ERROR;

	const int msgCmds[] = {MCM_ADD, MCM_ERROR, MCM_EDIT, MCM_DELETE, MCM_ERROR
						, MCM_DUPLICATE, MCM_COMBINE, MCM_ERROR, MCM_SET_SYSTEM
						, MCM_CLEAR_SYSTEM, MCM_ERROR, MCM_SHOW_TOOLTIPS};

	return msgCmds[nCmd];
}

//virtual 
bool ThemeGWListCtrl::OnDelTheme(const vector<string> &vsThemeFiles, vector<string> &vsClassOption)
{
	string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, GetThemeType());
	strPath += THEME_FILE_DELETED_FOLDER;

	if( !CheckMakePath(strPath) )
		return false;
	
	return DelThemeFiles(strPath, vsThemeFiles, vsClassOption);
}

//virtual 
void ThemeGWListCtrl::CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName)
{
	string strTemp = GetFileName(lpcszFullFileName);
	string strDstFullPath = lpcszPath;
	strDstFullPath += "\\" + strTemp;
	FileCopy(lpcszFullFileName, strDstFullPath);
}

//virtual 
string ThemeGWListCtrl::GetColHeadingTooltips(int nCol)
{
	switch(nCol)
	{
	case LIST_COL_IS_SYSTEM:
		//strTemp = "Click to check one of the theme to become a System Theme";
		return "";
	case LIST_COL_SIZE:
		return _L("Size = total number of properties, click to sort");
	case LIST_COL_NAME:
		return _L("double-click a Theme's name to rename");
	case LIST_COL_DATE:
		return _L("Last time a Theme file was modified, click to sort");
		
	case LIST_COL_PATH_TYPE:
		return _L("Theme files are stored in Origin's system folder or in user's Origin folder");	
	default:
		ASSERT(false);
		break;
	}
	
	return "";
}

/************************************************************************/
/*  ThemeGraphListCtrl
/************************************************************************/
//virtual 
int	ThemeGraphListCtrl::GetApplyOffset(bool bCurrentPage)
{
	return bCurrentPage ? THEMEAPPLY_PAGE : THEMEAPPLY_FOLDER;
}

//virtual
bool ThemeGraphListCtrl::GetApplyListToCombox(int nPageType, bool bCurrentPage, ComboBox &combo)
{
	if( bCurrentPage )
		combo.AddString(_L("Current Graph")); 
	combo.AddString(_L("Graphs in Folder"));
	combo.AddString(_L("Graphs in Project"));

	if(EXIST_WKS == nPageType)	///Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS
		combo.AddString(_L("Graphs in Current Sheet"));

	return true;
}

//virtual 
bool ThemeGraphListCtrl::GetTabShowPostion(bool &bShowRight, bool &bShowBottom)
{
	bShowRight = true;
	bShowBottom = true;
	return true;
}

//virtual 
string ThemeGraphListCtrl::GetChangeDescription()
{
	return _L("A system theme can be applied automatically when making new graphs");
}

/************************************************************************/
/*  ThemeWorksheetListCtrl
/************************************************************************/
//virtual 
int	ThemeWorksheetListCtrl::GetApplyOffset(bool bCurrentPage)
{
	return bCurrentPage ? THEMEAPPLY_LAYER : THEMEAPPLY_PAGE;
}

//virtual
bool ThemeWorksheetListCtrl::GetApplyListToCombox(int nPageType, bool bCurrentPage, ComboBox &combo)
{
	if( bCurrentPage )
		combo.AddString(_L("Current Sheet")); 
	combo.AddString(_L("Sheets in Book"));
	combo.AddString(_L("Sheets in Folder"));
	combo.AddString(_L("Sheets in Project"));

	return true;
}

//virtual 
bool ThemeWorksheetListCtrl::GetTabShowPostion(bool &bShowRight, bool &bShowBottom)
{
	bShowRight = true;
	bShowBottom = false;
	return true;
}

//virtual 
string ThemeWorksheetListCtrl::GetChangeDescription()
{
	return _L("A system theme can be applied automatically when making new worksheet");
}


///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeGWListCtrl::hidecolAndsetFormat()
//{	
//	///-----Kit 03/30/2011 ORG-2126-P2 SUPPORT_COLUMN_SHORT_DATE_SORT
//	//SetColFormat(GRID_COL_DATE, "General Date"); //"Medium Date";
//	SetColFormat(GRID_COL_DATE, COL_DATE_FORMAT_TYPE_GeneralDate); //"Medium Date";
//	///-----End SUPPORT_COLUMN_SHORT_DATE_SORT
//	SetColDataType(GRID_COL_DATE, flexDTDate);
//	SetColDataType(GRID_COL_NAME, flexDTString);
//	HideCol(-1, false);	///Jasmine 07/20/07 NAME_COL_WAS_HIDDEN, show all columns
//	HideCol(GRID_COL_IS_SYSTEM);
//
//	///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//	//SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
//	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//}
//
//
//void ThemeGWListCtrl::setAddCellFormat(int nRow, int nType, bool bIsIncrementList)
//{
//	SetCellData(nRow, GRID_COL_PATH_TYPE, nType);
//	SetItalic(nRow, GRID_COL_NAME, bIsIncrementList);
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE



/************************************************************************/
/*   ThemeAnalysisListControl
/************************************************************************/

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeDialogListCtrl::Reset()
//{
//	///Joseph 11/08/06  CLEAR_ROW_CONTENT
//	m_flx.Rows = 1;
//	m_flx.FixedRows = 1;
//	///End CLEAR_ROW_CONTENT
//	m_flx.Cols = ANALYSIS_GRID_COL_TOTAL;
//	SetColDataType(ANALYSIS_GRID_COL_MENU, flexDTBoolean);
//
//	///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//	SetFormatStrLocal(STR_ANALYSIS_THEME_GRID_COLS, _CAT);
//	hidecolAndsetFormat();
//	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

//virtual 
int	ThemeDialogListCtrl::GetHideCols(vector<bool> &vbHideCols)
{
	vbHideCols = true;
	vbHideCols[LIST_COL_IS_SYSTEM] = vbHideCols[LIST_COL_MENU] = 
	vbHideCols[LIST_COL_CATEGORY] = vbHideCols[LIST_COL_SCOPE] = 
	vbHideCols[LIST_COL_FILE_EXT] = false;
	return 4; // hide 4 cols
}

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeDialogListCtrl::hidecolAndsetFormat()
//{
//	//SetColDataType(ANALYSIS_GRID_COL_FUNCTION, flexDTString);  ///Joe 9/05/06  LET_FUNCTION_NAME_SORT
//
//	/////-----Kit 03/30/2011 ORG-2126-P2 SUPPORT_COLUMN_SHORT_DATE_SORT
//	//SetColFormat(ANALYSIS_GRID_COL_DATE, "General Date"); //"Medium Date";
//	SetColFormat(ANALYSIS_GRID_COL_DATE, COL_DATE_FORMAT_TYPE_GeneralDate); //"Medium Date";
//	///-----End SUPPORT_COLUMN_SHORT_DATE_SORT
//	SetColDataType(ANALYSIS_GRID_COL_DATE, flexDTDate);
//	HideCol(-1, false);	///Jasmine 07/20/07 NAME_COL_WAS_HIDDEN, show all columns
//	HideCol(ANALYSIS_GRID_COL_IS_SYSTEM);
//	HideCol(ANALYSIS_GRID_COL_MENU);	///Joseph 05/05/07 	HIDE_THIS_CODE_TEMPORY
//	///Jasmine 08/19/09 CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY
//	HideCol(ANALYSIS_GRID_COL_CATEGORY);
//	HideCol(ANALYSIS_GRID_COL_SCOPE);
//	///End CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY
//
//	///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//	//SetFormatStrLocal(STR_ANALYSIS_THEME_GRID_COLS, _CAT); ///Jasmine 07/20/07 comment the duplicate code
//	///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
//}
//
//void ThemeDialogListCtrl::setAddCellFormat(int nRow, int nType, bool bIsIncrementList)
//{
//	SetCellData(nRow, ANALYSIS_GRID_COL_PATH_TYPE, nType);
//	SetItalic(nRow, ANALYSIS_GRID_COL_NAME, bIsIncrementList);
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

//virtual 
string ThemeDialogListCtrl::GetThemeFileName(int nRow)
{
	const string strTheme = GetCell(nRow, LIST_COL_NAME);
	const string strScopeName = GetCell(nRow, LIST_COL_SCOPE);
	const string strTool = GetCell(nRow, LIST_COL_FUNCTION);

	ConvColOrRowtoIndex(strTool);

	const string strCategory = GetCell(nRow, LIST_COL_CATEGORY);
	const int nScope = theme_scopename_to_scopeindex(strScopeName);
	const int nPathType = GetCellData(nRow, LIST_COL_PATH_TYPE);		// see set cell data in base class
	const int nThemeType = getSelRowThemeType(nRow);
	return okutil_theme_construct_filename(strTheme, nThemeType, nPathType, nScope, strTool, strCategory);
}

//virtual
bool ThemeDialogListCtrl::GetTabShowPostion(bool &bShowRight, bool &bShowBottom)
{
	bShowRight = false;
	bShowBottom = true;
	return true;
}

//virtual
string ThemeDialogListCtrl::GetChangeDescription()
{
	return _L("A dialog theme can be applied automatically when reopen its corresponding dialog");
}

//virtual 
bool ThemeDialogListCtrl::FindAllThemeFiles(TreeNode &trTheme)
{
	ASSERT(trTheme.IsValid());
	const int themeTypes[] = {THTYPE_ANALYSIS, THTYPE_DIALOG};
#define ARRAY_SIZE(_arr)	(sizeof(_arr)/sizeof(_arr[0]))
	for ( size_t ii = 0; ii < ARRAY_SIZE(themeTypes); ++ii )
	{
		Tree trCur;
		theme_find_all_theme_files(trCur, ORIGIN_PATH_UNDEF, themeTypes[ii]);
		foreach(TreeNode tr in trCur.Children)
		{
			tr.SetAttribute(STR_THEME_TYPE_ATTRIB, themeTypes[ii]);
			trTheme.AddNode(tr);
		}
	}
#undef ARRAY_SIZE(_arr)
	return true;
}

//virtual 
bool ThemeDialogListCtrl::GetCopyOfThemeFileName(LPCTSTR lpcszOldFileName, string &strCopyFileName)
{
	string strOldThemeFileName = GetFileName(lpcszOldFileName, TRUE);	// remove ext
	/// EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME
	// OIS file name syntax is "<#>-<XFuncName>-<ThemeName>.ois"
	// ReverseFind can not support dash in theme name. Safer to find 2nd dash from beginning of string.
	///int nScopeIndex = strOldThemeFilename.ReverseFind('-');
	int nScopeIndex = strOldThemeFileName.Find('-');
	if( nScopeIndex >= 0 ) // If found first dash 
		nScopeIndex = strOldThemeFileName.Find('-', nScopeIndex + 1); // Find 2nd dash
	/// end SUPPORT_DASH_IN_THEME_NAME
	strOldThemeFileName.Insert(nScopeIndex + 1, "Copy of ");

	const int nRow = GetSelectedRow();
	ASSERT(0 <= nRow && nRow < GetRows());
	strCopyFileName = strOldThemeFileName + GetCell(nRow, LIST_COL_FILE_EXT);

	return true;
}

//virtual 
int ThemeDialogListCtrl::GetThemeFileType(LPCTSTR lpcszThemeFileWithExt)
{
	if ( NULL == lpcszThemeFileWithExt )
	{
		ASSERT(false);
		error_report("can not pass NULL pointer to int ThemeDialogListCtrl::GetThemeFileType(LPCTSTR lpcszThemeFileWithExt)!!");
		return THTYPE_UNDEF;
	}

	return getSelThemeFileType(lpcszThemeFileWithExt);
}

//virtual 
bool ThemeDialogListCtrl::OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType)
{
	string strFullNewName, strFullOldName;
	GetSelThemeFile(strFullNewName);
	
	const int nThemeType = getSelThemeFileType(strFullNewName);	///-----Kit 10/27/2011 ORG-4121-P2 CAN_NOT_RENAME_USER_DEFINE_DIALOG_THEME

	strFullOldName = strFullNewName = GetFileName(strFullNewName, TRUE);
	strFullOldName.Replace(lpcszNewNameAfterEdit, lpcszOldNameBeforeEdit);

	///-----Kit 10/27/2011 ORG-4121-P2 CAN_NOT_RENAME_USER_DEFINE_DIALOG_THEME
	//return theme_rename(strFullNewName, strFullOldName, nPathType, getSelThemeFileType(strFullNewName));
	return theme_rename(strFullNewName, strFullOldName, nPathType, nThemeType);
	///-----End CAN_NOT_RENAME_USER_DEFINE_DIALOG_THEME
}

//virtual
MenuCmdMsg ThemeDialogListCtrl::PopupMenu(DWORD dwMenuBits, HWND hWndDlg, int nx, int ny)
{
	ThemeDialogListControlMenu	myMenu(dwMenuBits);

	const int nCmd = PopupMenu(myMenu, hWndDlg, nx, ny);
	if ( nCmd < 0  )
		return MCM_ERROR;

	const int msgCmds[] = { MCM_DELETE, MCM_ERROR, MCM_DUPLICATE, MCM_ERROR, MCM_SHOW_TOOLTIPS};

	return msgCmds[nCmd];
}

//virtual 
string ThemeDialogListCtrl::GetColHeadingTooltips(int nCol)
{
	switch(nCol)
	{
	case LIST_COL_IS_SYSTEM:
		//strTemp = "Click to check one of the theme to become a System Theme";
		return "";
	case LIST_COL_MENU:
		return _L("Whether the theme will be shown on the menu");
	case LIST_COL_SIZE:
		return _L("Size = total number of properties, click to sort");
	case LIST_COL_FUNCTION:
		return _L("the name of the XFunction that the theme used");
	case LIST_COL_CATEGORY:
		return _L("The category that the theme belong to");
	case LIST_COL_SCOPE:
		return _L("the scope that the theme be used");
	case LIST_COL_NAME:
		return _L("double-click a Theme's name to rename");
	case LIST_COL_DATE:
		return _L("Last time a Theme file was modified, click to sort");
	case LIST_COL_PATH_TYPE:
		return _L("Theme files are stored in Origin's system folder or in user's Origin folder");
	default:
		ASSERT(false);
		break;
	}

	return "";
}

//virtual
bool ThemeDialogListCtrl::OnDelTheme(const vector<string> &vsThemeFiles, vector<string> &vsClassOption)
{
	return DelThemeFiles(NULL, vsThemeFiles, vsClassOption);
}

//virtual 
void ThemeDialogListCtrl::CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName)
{
	string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, getSelThemeFileType(lpcszFullFileName));
	strPath += THEME_FILE_DELETED_FOLDER;

	CheckMakePath(strPath);
}

int	ThemeDialogListCtrl::getSelThemeFileType(LPCTSTR lpcszFileNameWithExt)
{
	string strExt;
	separate_file_name_ext(lpcszFileNameWithExt, NULL, &strExt);
	ASSERT(!strExt.IsEmpty() && strExt.Find('.') >= 0);
	if ( strExt == ANALYSIS_THEME_FILE_EXT )
		return THTYPE_ANALYSIS;

	ASSERT(strExt.CompareNoCase(DIALOG_THEME_FILE_EXT) == 0);
	return THTYPE_DIALOG;
}

int ThemeDialogListCtrl::getSelRowThemeType(int nSelRow)
{
	string strExt = GetCell(nSelRow, LIST_COL_FILE_EXT);
	ASSERT(!strExt.IsEmpty());
	if ( strExt.Find(DIALOG_THEME_FILE_EXT) >= 0 )
		return THTYPE_DIALOG;
	ASSERT(strExt.Find(ANALYSIS_THEME_FILE_EXT) >= 0);
	return THTYPE_ANALYSIS;
}


///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
/************************************************************************/
/*   ThemeFuncListCtrl
/************************************************************************/
//virtual 
int		ThemeFuncListCtrl::GetThemeFileType(LPCTSTR lpcszThemeFileWithExt)
{
	return GetThemeType();
}
//virtual 
string 	ThemeFuncListCtrl::GetThemeFileName(int nRow)
{
	const string strTheme = GetCell(nRow, LIST_COL_NAME);
	const string strScopeName = GetCell(nRow, LIST_COL_SCOPE);
	const string strTool = GetCell(nRow, LIST_COL_FUNCTION);

	ConvColOrRowtoIndex(strTool);

	const string strCategory = GetCell(nRow, LIST_COL_CATEGORY);
	const int nScope = theme_scopename_to_scopeindex(strScopeName);
	const int nPathType = GetCellData(nRow, LIST_COL_PATH_TYPE);		// see set cell data in base class
	const int nThemeType = GetThemeType();
	return okutil_theme_construct_filename(strTheme, nThemeType, nPathType, nScope, strTool, strCategory);
}
//virtual 
string	ThemeFuncListCtrl::GetChangeDescription()
{
	return _L("A function theme can be applied automatically when reopen its corresponding dialog");
}
//virtual 
bool	ThemeFuncListCtrl::FindAllThemeFiles(TreeNode &trTheme)
{
	ASSERT(trTheme.IsValid());
	return theme_find_all_theme_files(trTheme, ORIGIN_PATH_UNDEF, GetThemeType()) > 0;
}
//virtual 
bool	ThemeFuncListCtrl::OnAfterEditRename(LPCTSTR lpcszOldNameBeforeEdit, LPCTSTR lpcszNewNameAfterEdit, int nPathType)
{
	return theme_rename(lpcszNewNameAfterEdit, lpcszOldNameBeforeEdit, nPathType, GetThemeType());
}
//virtual 
void	ThemeFuncListCtrl::CopyThemeFileToDeleteFolder(LPCTSTR lpcszPath, LPCTSTR lpcszFullFileName)
{
	string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, GetThemeType());
	strPath += THEME_FILE_DELETED_FOLDER;

	CheckMakePath(strPath);
}
///End NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY

ThemeListCtrlBase* create_theme_list_ctrl(int nSelTab)
{
	switch(nSelTab)
	{
	case THEME_GRAPH_TAB:
		return new ThemeGraphListCtrl;
	case THEME_WORKSHEET_TAB:
		return new ThemeWorksheetListCtrl;
	case THEME_DIALOG_TAB:
		return new ThemeDialogListCtrl;
	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	case THEME_FUNCTION_TAB:
		return new ThemeFuncListCtrl;
	///End NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	}

	return NULL;
}