/*------------------------------------------------------------------------------*
 * File Name: ThemeApply.c														*
 * Creation: CPY 1/27/03														*
 * Purpose: Origin C support for a Theme Gallery and Apply dialog				*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON										*
 *	CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS									*
 *	CPY 4/30/03 ADD_UNDO_APPLY													*				
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW										*
 *	CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT							*
 *	CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1						*
 *  Danice 8/11/04 QA70-6638 v8.0114 MARK_SYSTEM_THEME_WITH_NAME_AND_PATH		*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	DSC 2/16/05 GET_ORIGIN_PATH													*
 *	DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE										*
 *	DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME						*
 *	Jasmine 02/15/06 ADD_TYPE_TAB												*
 *  Joseph 8/02/06  ADD_THEME_TO_CORRECT_FOLDER                                 *
 *  Joseph 8/08/06  ADD_ANALYSIS_THEME_TO_TAB                                   *
 *  Joseph 9/05/06  LET_FUNCTION_NAME_SORT										*
 *	Joseph 9/05/06  DISABLE_APPLY_THEME											*
 *  Joseph 10/25/06 HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB							*
 *  Joseph 11/08/06  CLEAR_ROW_CONTENT											*
 *	Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS								*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE							    *
 *	Jasmine 07/20/07 NAME_COL_WAS_HIDDEN										*
 *	Folger 08/31/07 EXCLUDE_LAST_USED_THEME										*
 *	Jasmine 09/07/07 QA70-10355 NOT_APPLY_THEME_TO_REPORT_SHEET					*
 *	Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME						*
 *	Jasmine 09/29/07 QA70-7416 FIX_RENAME_ANALYSIS_THEME_BUG					*
 *	Sim 10-10-2007 FIX_THEME_NAME_ASSIGNED_ERROR								*
 *	AW 10/21/07 MORE_ON_LOCALIZATION											*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_DELTE_THEME						*
 *	Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME				*
 *	Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER					*
 *	EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME						*
 *	Jasmine 08/19/09 CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY					*
 *	Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH			*
 *	Jasmine QA81-14829 SELECT_CORRESPONDING_THEME								*
 *	Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME		*
 *	Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
 *	Hong 11/15/10 ORG-1375 FIX_THEME_EDITOR_FAIL_SORT_COL_FIRST_TIME_CLICK_ON_HEADER
 *	Kit 03/30/2011 ORG-2126-P2 SUPPORT_COLUMN_SHORT_DATE_SORT					*
 *	Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
//#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
//#include <utilities.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "ResizeDialog.h"
///	#include <vsFlexGrid.h>
///	#include "theme_utils.h"
///	#include "Odlg.h"
///	#include "HelpID.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "ThemeGalleryListCtrl.h"
#include "ThemeGallery.h"

//#define _DBINT(_STR, _INT)	//out_int(_STR, _INT);
//#define _DBSTR(_STR)		//out_str(_STR);
//#define _DBPRINTF(_FMT, _ARG)	//printf(_FMT, _ARG);

//putting ';' in front of labtalk to make the execution delayed, so it will be executed after
//event has been handled, which is safer
#define STR_THEME_REMINDER_MSG_RENAME	";type -M ThemeHowToRename"
#define STR_THEME_REMINDER_MSG_DEL		";type -M ThemeFolderOfDel"

///End ADD_ANALYSIS_THEME_TO_TAB
#define NUM_DATA_PTS 20

//////////////////////////////////////////////////////////
/////////// Tooltips  ////////////////////////////////////
//////////////////////////////////////////////////////////
///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//static string get_gw_col_heading_tooltips(int nCol) //graph and worksheet ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//{
//	string strTemp;
//	switch(nCol)
//	{
//	case GRID_COL_IS_SYSTEM:
//		//strTemp = "Click to check one of the theme to become a System Theme";
//		break;
//	case GRID_COL_SIZE:
//		strTemp = _L("Size = total number of properties, click to sort");
//		break;
//	case GRID_COL_NAME:
//		strTemp = _L("double-click a Theme's name to rename");
//		break;
//	case GRID_COL_DATE:
//		strTemp = _L("Last time a Theme file was modified, click to sort");
//		break;
//	case GRID_COL_PATH_TYPE:
//		strTemp = _L("Theme files are stored in Origin's system folder or in user's Origin folder");
//		break;		
//	}
//	return strTemp;
//}
//
/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//static string get_analysis_col_heading_tooltips(int nCol) //graph and worksheet 
//{
//	string strTemp;
//	switch(nCol)
//	{
//	case ANALYSIS_GRID_COL_IS_SYSTEM:
//		//strTemp = "Click to check one of the theme to become a System Theme";
//		break;
//	case ANALYSIS_GRID_COL_MENU:
//		strTemp = _L("Whether the theme will be shown on the menu");
//		break;
//	case ANALYSIS_GRID_COL_SIZE:
//		strTemp = _L("Size = total number of properties, click to sort");
//		break;
//	case ANALYSIS_GRID_COL_FUNCTION:
//		strTemp = _L("the name of the XFunction that the theme used");
//		break;
//	case ANALYSIS_GRID_COL_CATEGORY:
//		strTemp = _L("The category that the theme belong to");
//		break;
//	case ANALYSIS_GRID_COL_SCOPE:
//		strTemp = _L("the scope that the theme be used");
//		break;
//	case ANALYSIS_GRID_COL_NAME:
//		strTemp = _L("double-click a Theme's name to rename");
//		break;
//	case ANALYSIS_GRID_COL_DATE:
//		strTemp = _L("Last time a Theme file was modified, click to sort");
//		break;
//	case ANALYSIS_GRID_COL_PATH_TYPE:
//		strTemp = _L("Theme files are stored in Origin's system folder or in user's Origin folder");
//		break;		
//	}
//	return strTemp;
//}
/////End ADD_ANALYSIS_THEME_TO_TAB
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

//////////////////////////////////////////////////////////
/////////// Theme Collection//////////////////////////////
//////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
/////////// end	    //////////////////////////////////////
//////////////////////////////////////////////////////////

//--WAIT_FIX, cannot put into constructors
//bool bIsSystemTheme;
//bool bMultiSel = false;
//---
///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//class ThemeListControlMenu : public Menu
//{
//public:
	//ThemeListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips) : Menu()
	//{
		//m_nChoice = -1;
		//Add(_L("Add &New"), OnMenuItem);
		//Add(NULL, OnMenuItem);
		//Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//Add(_L("&Delete"), OnMenuItem, bIsInThemeList? MF_ENABLED : MF_GRAYED);
		//Add(NULL, OnMenuItem);
		//Add(_L("D&uplicate"), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//
		//Add(NULL, OnMenuItem);
//
		//Add(_L("&Set as System Theme"), OnMenuItem, (bIsCanbeSystemTheme && bIsInThemeList && !bIsSystemTheme && !bMultiSel) ? MF_ENABLED : MF_GRAYED );
		//Add(_L("&Clear System Theme"), OnMenuItem, bHasSystemTheme? MF_ENABLED : MF_GRAYED );
		//
		//Add(NULL, OnMenuItem);
		//
		//Add(_L("Show &Tooltips"), OnMenuItem, bShowTips?MF_CHECKED : MF_UNCHECKED);
	//}
	//void OnMenuItem(UINT nPos)
	//{
		//m_nChoice = nPos;
	//}
	//bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= THEME_ADD && m_nChoice <= THEME_SHOW_TOOLTIPS)
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
//private:
	//int	m_nChoice;
//};

///End ADD_ANALYSIS_THEME_TO_TAB
///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
//typedef bool (* P_THEME_EDITOR)(LPCSTR lpcszThemeFilename, HWND hWndParent);
typedef bool (* P_THEME_EDITOR)(LPCSTR lpcszThemeFilename, HWND hWndParent, string* pstrEditingFile = NULL);
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

/************************************************************************/
/*  ThemeGalleryDlg
/************************************************************************/
ThemeGalleryDlg::ThemeGalleryDlg() : ResizeDialog(IDD_THEME_GALLERY80, "ODlg8") //IDD_THEME_GALLERY, "ODlg")///Jasmine 02/15/06 ADD_TYPE_TAB, separate from 75's resource
{
	m_pThemeList = NULL;	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE	
	//-- get active page type
	Page pg = Project.Pages();		
	if(!pg)
		m_nPageType = EXIST_NONE;
	else
		m_nPageType = pg.GetType();

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//m_nThemeType = theme_get_type_from_page_type(m_nPageType);///dsc 2/23/05
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	m_bExcludeIncremenTypes = true;
	m_bExcludeLastUsed = true;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME

	m_nUndoStackCount = 0;
	m_strOptionsSecName = "ThemeGallery";
	m_strOptionsValName = "Options";
}
///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
ThemeGalleryDlg::~ThemeGalleryDlg()
{
	NICE_SAFE_REMOVAL(m_pThemeList);
}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

int ThemeGalleryDlg::DoModalEx(HWND hWndParent /*= NULL*/)
{
	InitMsgMap();// will be called from internal later
	int nRet = DoModal(hWndParent);

	return nRet;
}

int ThemeGalleryDlg::ShowTab(int nPageType)
{
	int nSelTab;
	switch(nPageType)
	{
	case EXIST_WKS:
		nSelTab = THEME_WORKSHEET_TAB;
		break;
	case EXIST_PLOT:	
	default:
		nSelTab = THEME_GRAPH_TAB; 
		break;
	}
	m_tabPage.SetCurSel(nSelTab);  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	Control cntrl;
	OnTabChange(cntrl);
	return nSelTab;
}

BOOL ThemeGalleryDlg::OnInitDialog()
{
	waitCursor junk;
	ResizeDialog::OnInitDialog(IDC_THEME_GRID);

	loadOptions();

	m_cntrlSystemTheme = GetItem(IDC_THEME_CURRENT_SYSTEM);
	m_cmbApplyTo = GetItem(IDC_THEME_APPLY_TO);
	m_cmbApplyTo.SetCurSel(0);
	//m_themGWList.Init(IDC_THEME_GRID, *this);  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB

	///Jasmine 02/15/06 ADD_TYPE_TAB
	m_tabPage = GetItem(IDC_THEME_TAB);
	m_tabPage.InsertItem(THEME_GRAPH_TAB, _L("Graph"));
	m_tabPage.InsertItem(THEME_WORKSHEET_TAB, _L("Worksheet"));
	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	//change name
	//m_tabPage.InsertItem(THEME_ANALYSIS_TAB, "Analysis");  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	m_tabPage.InsertItem(THEME_DIALOG_TAB, _L("Dialog"));  
	///End CLEAN_THEME_ORGANIZER
	m_tabPage.InsertItem(THEME_FUNCTION_TAB, _L("Function"));  	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	ShowTab(m_nPageType);
	///End ADD_TYPE_TAB

	Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
	btnShowGraphTypes.Check = m_bExcludeIncremenTypes;

	//load_themes_to_grid(false, false);///Jasmine 02/15/06 ADD_TYPE_TAB

	Button btnApply = GetItem(IDC_THEME_APPLY);
	btnApply.Enable = false;

	//--- CPY 4/30/03 ADD_UNDO_APPLY
	undoEnabled(true, 0);
	//---

	//CPY 8/20/03
	OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	return TRUE;
}

BOOL ThemeGalleryDlg::OnDestroy()
{
	saveOptions();
	Worksheet wks(m_strWksName);
	if(wks)
		wks.Destroy();
	m_strWksName.Empty();

	if(m_strThemeFilename.IsFile())
		DeleteFile(m_strThemeFilename);
	m_strThemeFilename.Empty();

	//m_trThemes.Reset();
	return TRUE;
}
BOOL ThemeGalleryDlg::OnDlgResize(int nType, int cx, int cy)
{
	MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	uint nCntrlsRight[] = {
		IDC_THEME_APPLY_GROUP,
		IDC_THEME_APPLY_TO,
		IDC_THEME_APPLY,
		IDC_THEME_UNDO,
		IDCANCEL,
		0
	};

	uint nCntrlsBottom[] = {
		IDC_THEME_SHOW_GRAPH_ONLY,
		0
	};
	///Jasmine 02/15/06 ADD_TYPE_TAB
	//ResizeMoveControlsRightBottom(IDC_THEME_GRID, nCntrlsRight, nCntrlsBottom, cx, cy);
	ResizeMoveControlsRightBottom(IDC_THEME_TAB, nCntrlsRight, nCntrlsBottom, cx, cy);
	//ArrangeMainItemAndControls(nCntrlsBottom, IDC_THEME_TAB, nCntrlsRight);
	RECT rTab;
	GetClientRect(m_tabPage, rTab);

	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	//on tab change, resize the dlg
	int nEdge = GetControlGap();
	if( THEME_DIALOG_TAB == m_tabPage.GetCurSel()
		|| THEME_FUNCTION_TAB == m_tabPage.GetCurSel())	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	{
		rTab.right = cx - nEdge;
		MoveControl(m_tabPage, rTab);
	}
	///End  CLEAN_THEME_ORGANIZER       

	m_tabPage.AdjustRect(FALSE, &rTab);
	Control ctrlGrid=GetItem(IDC_THEME_GRID);
	ctrlGrid.MoveWindow(&rTab);
	///End ADD_TYPE_TAB

	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	Control ctrlClose = GetItem(IDCANCEL);
	GetClientRect(ctrlClose, rTab);
	int nButtonHeight = rTab.bottom - rTab.top;
	rTab.bottom = cy - nEdge;
	//---Jasmine 12/04/08 v8.0982b correct wrong resizing code
	//rTab.top = cy - nButtonHeight;
	rTab.top = rTab.bottom - nButtonHeight;
	//---end
	MoveControl(ctrlClose, rTab);
	///End  CLEAN_THEME_ORGANIZER



	return TRUE;
}
BOOL ThemeGalleryDlg::OnShowThemeTypes(Control cntrl)
{
	Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
	//m_bExcludeIncremenTypes = btnShowGraphTypes.Check;
	int nSelTab = m_tabPage.GetCurSel();
	switch (nSelTab)
	{
	case THEME_GRAPH_TAB:
		m_bExcludeIncremenTypes = btnShowGraphTypes.Check;
		break;
	case THEME_DIALOG_TAB:
	case THEME_FUNCTION_TAB:		///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
		m_bExcludeLastUsed = btnShowGraphTypes.Check;
		break;
	default:
		break;
	}
	//------ End EXCLUDE_LAST_USED_THEME
	//loadThemesToGrid(true, false);
	loadThemesToGrid();

	return TRUE;
}

BOOL ThemeGalleryDlg::OnAdd(Control cntrl)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	ThemeGWListCtrl *pGWListCtrl = getGWListCtrl();
	const int nThemeType = pGWListCtrl->GetThemeType();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	string strFilename;
	///Joe  08/02/2006  ADD_THEME_TO_CORRECT_FOLDER
	if(!theme_get_next_file_name(strFilename,true, nThemeType))
		//if(!theme_get_next_file_name(strFilename))
		///End ADD_THEME_TO_CORRECT_FOLDER
		return false;

	/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
	//GraphPage gp;
	//gp.Create(NULL, CREATE_HIDDEN);
	//Tree trTheme;
	//trTheme = gp.GetFormat();
	//gp.Destroy();
	Tree trTheme;
	trTheme = Project.CreateNewTheme();
	/// end OBJECT_PROPERTY_ACCESS

	trTheme.Save(strFilename);
	///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
	if(strFilename.IsFile())
	{
		//load_themes_to_grid();
		//add_theme_to_grid(strFilename);
		LT_execute(STR_THEME_REMINDER_MSG_RENAME);
	}

	string strName = GetFileName(strFilename, TRUE);
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	refreshGridList(strName);
	///End ADD_ANALYSIS_THEME_TO_TAB
	///End SELECT_CORRESPONDING_THEME
	return TRUE;
}

BOOL ThemeGalleryDlg::OnDuplicate(Control cntrl)
{
	string		strSelThemeFile;
	if(!getSelThemeFile(strSelThemeFile))
		return TRUE; // nothing to do

	string strFilename;
	if(!getCopyOfThemeFileName(strFilename, strSelThemeFile))
		return false;
	///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
	if(FileCopy(strSelThemeFile, strFilename, FILE_ATTRIBUTE_NORMAL, true))
	{
		//add_theme_to_grid(strFilename);	//do not add theme to the end, refreshGridList will add it to proper place
		LT_execute(STR_THEME_REMINDER_MSG_RENAME);
	}

	string strName = GetFileName(strFilename, TRUE);
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	refreshGridList(strName);  
	///End ADD_ANALYSIS_THEME_TO_TAB
	///End SELECT_CORRESPONDING_THEME
	return TRUE;
}

BOOL ThemeGalleryDlg::OnCombine(Control cntrl)
{
	StringArray vstrThemeFilenames;

	if( !getSelThemeFiles(vstrThemeFilenames) )
		return TRUE; // nothing to do

	string strFilename;
	if(!getCombineThemeFileName(strFilename, vstrThemeFilenames[0]))
		return false;
	///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
	if( FileCopy(vstrThemeFilenames[0], strFilename, FILE_ATTRIBUTE_NORMAL, true) )
	{
		for(int ii=1; ii<vstrThemeFilenames.GetSize(); ii++)
		{
			if( !CombineThemes(strFilename, vstrThemeFilenames[ii]) )
				return FALSE;
		}

		//add_theme_to_grid(strFilename);

		LT_execute(STR_THEME_REMINDER_MSG_RENAME);
	}

	string strName = GetFileName(strFilename, TRUE);
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	refreshGridList(strName);
	///End ADD_ANALYSIS_THEME_TO_TAB
	///End SELECT_CORRESPONDING_THEME
	return TRUE;
}

BOOL ThemeGalleryDlg::OnApplyToComboChange(Control cntrl)
{
	enableButtons();
	return TRUE;
}	

BOOL ThemeGalleryDlg::OnApplyButton(Control cntrl)
{		
	string		strApplyFile;

	if( !getSelThemeFile(strApplyFile) )
		return TRUE; // nothing to do

	BOOL bResult = theme_apply(getThemeApply(), strApplyFile);

	undoEnabled(true, 1); 

	return bResult;     
}

//---- CPY 4/30/03 ADD_UNDO_APPLY
BOOL ThemeGalleryDlg::OnUndoApplyButton(Control cntrl)
{
	if(undoEnabled())
	{
		Project.Undo();
		undoEnabled(true, -1);
	}

	return true;
}
//---- end

///Jasmine 02/15/06 ADD_TYPE_TAB 
BOOL ThemeGalleryDlg::OnTabChange(Control cntrl)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//const int nSelTab = m_tabPage.GetCurSel();
	//switch(nSelTab)
	//{
	//	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//	//case THEME_GRAPH_TAB:
	//	//nPageType = EXIST_PLOT;
	//	//break;
	//	//case THEME_WORKSHEET_TAB:
	//	//nPageType = EXIST_WKS;
	//	//break;
	//case THEME_GRAPH_TAB:
	//	m_themeGWList.Init(IDC_THEME_GRID, *this);
	//	nPageType = EXIST_PLOT;
	//	m_nThemeType = THTYPE_GRAPH;
	//	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
	//	btnShowGraphTypes.Text = _L("Exclude increment lists");
	//	btnShowGraphTypes.Check = m_bExcludeIncremenTypes;
	//	//------ End EXCLUDE_LAST_USED_THEME
	//	break;			
	//case THEME_WORKSHEET_TAB:
	//	m_themeGWList.Init(IDC_THEME_GRID, *this);
	//	nPageType = EXIST_WKS;
	//	m_nThemeType = THTYPE_WORKSHEET;
	//	break;
	//case THEME_DIALOG_TAB:
	//	m_themeDialogList.Init(IDC_THEME_GRID, *this);
	//	m_nThemeType = THTYPE_ANALYSIS;
	//	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
	//	btnShowGraphTypes.Text = _L("Exclude <last used> theme");
	//	btnShowGraphTypes.Check = m_bExcludeLastUsed;
	//	//------ End EXCLUDE_LAST_USED_THEME
	//	break;
	//	///End ADD_ANALYSIS_THEME_TO_TAB
	//}
	initThemeListCtrl();
	ASSERT(NULL != m_pThemeList);
	const int nPageType = m_pThemeList->GetPageType();

	Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME

	const int nSelTab = m_pThemeList->GetThemeTabType();
	if ( THEME_DIALOG_TAB == nSelTab 
		|| THEME_FUNCTION_TAB == nSelTab )		///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	{
		btnShowGraphTypes.Text = _L("Exclude <last used> theme");
		btnShowGraphTypes.Check = m_bExcludeLastUsed;
	}
	else if ( THEME_GRAPH_TAB == nSelTab )
	{
		btnShowGraphTypes.Text = _L("Exclude increment lists");
		btnShowGraphTypes.Check = m_bExcludeIncremenTypes;
	}
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	btnShowGraphTypes.Visible = false;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME

	onChangeDescription();///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
	//m_bCurrentPage = (nPageType == m_nPageType);
	m_bCurrentPage = isCurrentLayerAvailable(nPageType);
	///End NOT_APPLY_THEME_TO_REPORT_SHEET
	loadThemesToGrid();
	//setApplyToList();
	//enable_buttons();
	onTabShowRightBottom();///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	return TRUE;
}
///End ADD_TYPE_TAB

//////////////////////////
// Delete Theme
// move file into folder called "Deleted"
//////////////////////////

BOOL ThemeGalleryDlg::OnDelTheme(Control cntrl)
{
	waitCursor junk;

	StringArray vstrThemeFilenames;

	if( !getSelThemeFiles(vstrThemeFilenames) )
		return TRUE; // nothing to do
	
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, m_nThemeType);
	////------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER
	////strPath += "Deleted";
	//strPath += THEME_FILE_DELETED_FOLDER;
	////------

	//if( CheckMakePath(strPath) )
	//{
	//	bool bDeleted = false;

	//	//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
	//	vector<string>		vsClassOption;
	//	//------
	//
	//	for(int ii=0; ii<vstrThemeFilenames.GetSize(); ii++)
	//	{
	//		string strTemp = GetFileName(vstrThemeFilenames[ii]);
	//		FileCopy(vstrThemeFilenames[ii], strPath + "\\" + strTemp);
	//		DeleteFile(vstrThemeFilenames[ii]);
	//		bDeleted = true;

	//		//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
	//		string strName, strTool, strScope, strCategory;
	//		theme_filename_to_options(vstrThemeFilenames[ii], strName, strTool, strScope ,strCategory);
	//		if ( vsClassOption.Find(strTool) < 0 )
	//			vsClassOption.Add(strTool);
	//		//------				
	//	}

	//	if( bDeleted )
	//	{	
	//		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//		refreshGridList();
	//		///End ADD_ANALYSIS_THEME_TO_TAB

	//		LT_execute(STR_THEME_REMINDER_MSG_DEL);

	//		//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
	//		/*
	//		//------ Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_DELTE_THEME
	//		refresh_origin_main_menu();
	//		//------
	//		*/
	//		for ( int jj=0; jj<vsClassOption.GetSize(); ++jj )
	//			UpdateThemesMenuItems(vsClassOption[jj]);
	//		//------
	//	}
	//}

	vector<string> vsClassOption;
	if ( !m_pThemeList->OnDelTheme(vstrThemeFilenames, vsClassOption) )
		return FALSE;

	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	refreshGridList();
	///End ADD_ANALYSIS_THEME_TO_TAB
	LT_execute(STR_THEME_REMINDER_MSG_DEL);
	//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
	/*
	//------ Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_DELTE_THEME
	refresh_origin_main_menu();
	//------
	*/
	for ( int jj=0; jj<vsClassOption.GetSize(); ++jj )
		UpdateThemesMenuItems(vsClassOption[jj]);
	//------
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	return TRUE;
}

BOOL ThemeGalleryDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	if(IDC_THEME_GRID == nResIDCtrl)
	{
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//int nRow = 0, nCol = 0;
		//bool bIsInsideGrid = false;
		//if(nx < 0 || ny < 0) // keyboard activated 
		//	bIsInsideGrid = m_themeGWList.GetSelCell(nx, ny, nRow, nCol);
		//else
		//	bIsInsideGrid = m_themeGWList.FindCell(nx, ny, nRow, nCol);

		//const bool bHasSystemTheme = hasSystemTheme();

		//bool bIsSystemTheme = m_themeGWList.GetCheck(nRow, GRID_COL_IS_SYSTEM);

		//bool bIsCanbeSystemTheme = false;
		//StringArray vstrThemes;
		//getSelThemeFiles(vstrThemes);

		//bool bMulti = vstrThemes.GetSize() > 1;
		////---- CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT
		//if(!bMulti && !isIncrementListRow(nRow)) // increment list theme is shown as italic
		//	bIsCanbeSystemTheme = true;
		////----
		/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		////ThemeListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
		////myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
		////int nCmd;
		////if(myMenu.GetCommand(nCmd))
		////{
		////Control flxControl = GetItem(IDC_THEME_GRID);
		////switch(nCmd)
		////{
		////case THEME_ADD:
		////OnAdd(flxControl);
		////break;
		////case THEME_EDIT:
		////OnEditTheme(flxControl);
		////break;
		////case THEME_DELETE:
		////OnDelTheme(flxControl);
		////break;
		////case THEME_DUPLICATE:
		////OnDuplicate(flxControl);
		////break;
		////case THEME_COMBINE:
		////OnCombine(flxControl);
		////break;
		////case THEME_SET_SYSTEM:
		////setSystemTheme(nRow);
		////break;
		////case THEME_CLEAR_SYSTEM:
		////clearSystemTheme();
		////break;
		////case THEME_SHOW_TOOLTIPS:
		////m_bShowTooltips = m_bShowTooltips? false:true;
		////break;
		////}
		////}
		//if(m_nThemeType == THTYPE_ANALYSIS)
		//{
		//	ThemeDialogListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
		//	popupAnalysisMenu(myMenu, nx, ny);
		//}
		//else
		//{
		//	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		//	//bool bEdit = isAllowEdit(nRow);///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
		//	//ThemeGWListControlMenu	myMenu(bEdit, bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
		//	ThemeGWListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
		//	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		//	popupGWListMenu(myMenu, nRow, nx, ny); //graph and worksheet
		//}
		/////End ADD_ANALYSIS_THEME_TO_TAB
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		ASSERT(NULL != m_pThemeList);
		const int nRow = m_pThemeList->GetSelectedRow();
		const MenuCmdMsg msgCmd = m_pThemeList->OnShowMenu(m_bShowTooltips, hasSystemTheme(), m_wndDlg.GetSafeHwnd(), nx, ny);

		if ( MCM_ERROR == msgCmd )
			return FALSE;

		Control flxControl = GetItem(IDC_THEME_GRID);

		BOOL bRet = FALSE;
		switch( msgCmd )
		{
		case MCM_ADD:
			bRet = OnAdd(flxControl);
			break;
		case MCM_EDIT:
			bRet = OnEditTheme(flxControl);
			break;
		case MCM_DELETE:
			bRet = OnDelTheme(flxControl);
			break;
		case MCM_DUPLICATE:
			bRet = OnDuplicate(flxControl);
			break;
		case MCM_COMBINE:
			bRet = OnCombine(flxControl);
			break;
		case MCM_SET_SYSTEM:
			setSystemTheme(nRow);
			break;
		case MCM_CLEAR_SYSTEM:
			clearSystemTheme();
		case MCM_SHOW_TOOLTIPS:
			m_bShowTooltips = !m_bShowTooltips;
			break;
		default :
			ASSERT(false);
			return FALSE;
		}
	}
	return TRUE;
}	
//------------ vcFlex Grid Event Handlers ------------
/////////////////////////////////////////
//
void ThemeGalleryDlg::OnBeforeMouseDown(Control flxControl, short nButton, short nShift, float X, float Y, BOOL* pCancel) // listCols arg not used for now, maybe needed later
{
	ASSERT(NULL != m_pThemeList);
	int nRow, nCol, nx, ny;
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//bool bIsInsideGrid = m_themeGWList.GetMousePixel(X, Y, nRow, nCol, nx, ny);
	///// Hong 11/15/10 ORG-1375 FIX_THEME_EDITOR_FAIL_SORT_COL_FIRST_TIME_CLICK_ON_HEADER
	//if ( nRow < m_themeGWList.GetRowOffset() )
	//	return ;
	///// end FIX_THEME_EDITOR_FAIL_SORT_COL_FIRST_TIME_CLICK_ON_HEADER
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//{
	//	if(m_themeDialogList.CheckSelRow(nRow, false))
	//		*pCancel= TRUE;
	//	return;
	//}
	/////End ADD_ANALYSIS_THEME_TO_TAB
	//if(m_themeGWList.CheckSelRow(nRow, false))
	//{
	//	*pCancel= TRUE;
	//	if(nRow < 0)
	//		enableButtons();
	//}
	bool bIsInsideGrid = m_pThemeList->GetMousePixel(X, Y, nRow, nCol, nx, ny);
	if ( nRow < m_pThemeList->GetRowOffset() )
		return ;

	if ( m_pThemeList->CheckSelRow(nRow, false) )
	{
		*pCancel = TRUE;
		if ( nRow < 0 )
			enableButtons();
	}
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}

void ThemeGalleryDlg::OnDblClick(Control flxControl)
{		
	int nRow = 0, nCol = 0;
	int nx = -1, ny = -1;
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//	return;	
	/////End ADD_ANALYSIS_THEME_TO_TAB
	//m_themeGWList.GetSelCell(nx, ny, nRow, nCol);
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->GetSelCell(nx, ny, nRow, nCol);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//if(nCol != GRID_COL_NAME && isAllowEdit(nRow))	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME		
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//if(nCol != GRID_COL_NAME )
	//	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//	OnEditTheme(flxControl);
	if ( LIST_COL_NAME != nCol )
	{
		ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType() && THEME_FUNCTION_TAB != m_pThemeList->GetThemeTabType() );	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
		OnEditTheme(flxControl);
	}
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}

void ThemeGalleryDlg::OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{	
	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	if(!isAllowEdit(nRow))
	{
		*pCancel = TRUE;
		return;
	}
	///End NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS) 
	//{
	//	if(nCol != ANALYSIS_GRID_COL_NAME && nCol != ANALYSIS_GRID_COL_IS_SYSTEM && nCol != ANALYSIS_GRID_COL_MENU)
	//	{
	//		*pCancel = TRUE;
	//		return;
	//	}
	//	if( ANALYSIS_GRID_COL_NAME == nCol)
	//		m_strOldStr = m_themeDialogList.GetCell(nRow, nCol);
	//	else
	//		m_strOldStr = "";
	//}
	//else
	//{
	//	if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM)
	//		//---
	//	{
	//		*pCancel = TRUE;
	//		return;
	//	}

	//	if( GRID_COL_NAME == nCol)
	//		m_strOldStr = m_themeGWList.GetCell(nRow, nCol);
	//	else
	//		m_strOldStr = "";
	//}
	if ( LIST_COL_NAME != nCol && LIST_COL_IS_SYSTEM != nCol && LIST_COL_MENU != nCol )
	{
		*pCancel = TRUE;
		return ;
	}

	ASSERT(NULL != m_pThemeList);
	m_strOldStr = (LIST_COL_NAME == nCol) ? m_pThemeList->GetCell(nRow, nCol) : "";
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	////--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
	////if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM && nCol != GRID_COL_EDIT)
	//if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM)
	////---
	//{
	//*pCancel = TRUE;
	//return;
	//}
	//
	//if( GRID_COL_NAME == nCol)
	//m_strOldStr = m_themeList.GetCell(nRow, nCol);
	//else
	//m_strOldStr = "";
	///End ADD_ANALYSIS_THEME_TO_TAB
}

void ThemeGalleryDlg::OnAfterEdit(Control flxControl, int nRow, int nCol)
{
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(GRID_COL_NAME == nCol)
	//{
	//string strNew = m_themGWList.GetCell(nRow, nCol);
	//if(strNew.CompareNoCase(m_strOldStr) != 0)
	//{
	//// need to rename file
	/////DSC 2/15/05 GET_ORIGIN_PATH
	//// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
	//// if(!theme_rename(strNew, m_strOldStr, bIsEXEPath))
	//int nPathThpe = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
	//// if(!theme_rename(strNew, m_strOldStr, nPathThpe))
	//if(!theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType))
	/////end 2/15/05 GET_ORIGIN_PATH
	//m_themGWList.SetCell(nRow, nCol, m_strOldStr);
	//else
	//checkSystemTheme(nRow);
	//}
	//return;
	//}
	///*
	//else if(GRID_COL_IS_SYSTEM == nCol)
	//{
	//bool bCheck = m_themGWList.GetCheck(nRow, nCol);
	//string strTheme = m_themGWList.GetCell(nRow, GRID_COL_NAME);
	//bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
	//theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
	//// next we need to clean those other checked since only one system theme is allowed
	//checkSystemTheme();
	//}
	//*/

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//if(m_nThemeType == THTYPE_ANALYSIS) 
	//{			
	//	afterEditUsed(m_themeDialogList, nCol, nRow, ANALYSIS_GRID_COL_NAME, ANALYSIS_GRID_COL_PATH_TYPE);
	//}
	//else
	//{
	//	afterEditUsed(m_themeGWList, nCol, nRow, GRID_COL_NAME, GRID_COL_PATH_TYPE);
	//}
	if(LIST_COL_NAME != nCol)
		return ;

	ASSERT(NULL != m_pThemeList);

	if ( m_pThemeList->OnAfterEdit(m_strOldStr, nRow, nCol) )
	{
		checkSystemTheme(nRow);
	}
	else
	{
		m_pThemeList->SetCell(nRow, nCol, m_strOldStr);
	}
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///End  ADD_ANALYSIS_THEME_TO_TAB
}
void ThemeGalleryDlg::OnSelChange(Control flxControl)
{
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//if(m_nThemeType == THTYPE_ANALYSIS)
	if ( m_pThemeList->GetThemeTabType() == THEME_DIALOG_TAB 
		|| m_pThemeList->GetThemeTabType() == THEME_FUNCTION_TAB )///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		return;
	///End ADD_ANALYSIS_THEME_TO_TAB
	enableButtons();	
}	
BOOL ThemeGalleryDlg::OnEditTheme(Control cntrl)
{
	ASSERT(NULL != m_pThemeList);
	ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType() && THEME_FUNCTION_TAB != m_pThemeList->GetThemeTabType());	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY

	string		strThemeFile;
	if(!getSelThemeFile(strThemeFile))
		return TRUE; // nothing to do

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nSelRow = m_themeGWList.GetSelectedRow();
	const int nSelRow = m_pThemeList->GetSelectedRow();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	P_THEME_EDITOR fnThemeEditor = Project.FindFunction("ThemeEditor");
	if(fnThemeEditor)
	{
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		/*
		if(fnThemeEditor(strThemeFile, GetSafeHwnd()))
		{
		// need to update size col
		Tree themeTree(strThemeFile);
		if(themeTree)
		{
		//if(m_nThemeType == THTYPE_ANALYSIS)
		//m_themAnalysisList.SetCell(nSelRow, ANALYSIS_GRID_COL_SIZE, tree_count_items(themeTree));
		//else
		m_themGWList.SetCell(nSelRow, GRID_COL_SIZE, tree_count_items(themeTree));
		}
		}
		*/
		string strEditingFile;
		fnThemeEditor(strThemeFile, GetSafeHwnd(), &strEditingFile);

		string strName = GetFileName(strEditingFile, TRUE);
		refreshGridList(strName);
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	}
	return TRUE;
}
//---------- CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
void ThemeGalleryDlg::OnMouseMove(Control flxControl, short nButton, short nShift, float X, float Y)
{
	string strTooltips;
	if(!m_bShowTooltips)
		return;

	int nRow, nCol;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//{			
	//	if(!m_themeDialogList.GetMouseCell(nRow, nCol))
	//		return;

	//	if(m_themeDialogList.IsColHeadingRow(nRow))
	//		strTooltips = get_analysis_col_heading_tooltips(nCol);
	//	else if(ANALYSIS_GRID_COL_NAME == nCol)
	//		strTooltips = getThemeTooltips(nRow);	
	//}
	//else
	//	///End ADD_ANALYSIS_THEME_TO_TAB
	//{

	//	if(!m_themeGWList.GetMouseCell(nRow, nCol))
	//		return;

	//	if(m_themeGWList.IsColHeadingRow(nRow))
	//		strTooltips = get_gw_col_heading_tooltips(nCol);
	//	else if(GRID_COL_NAME == nCol)
	//		strTooltips = getThemeTooltips(nRow);	
	//}
	ASSERT(NULL != m_pThemeList);
	if ( !m_pThemeList->GetMouseCell(nRow, nCol) )
		return ;

	if ( m_pThemeList->IsColHeadingRow(nRow) )
		strTooltips = m_pThemeList->GetColHeadingTooltips(nCol);
	else if ( LIST_COL_NAME == nCol )
		strTooltips = getThemeTooltips(nRow);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	// this is not working, will need a ADO version, I suspect
	//flx.ToolTipText = strTooltips;
	showTooltipText(strTooltips);

}
//---------- end ADD_TOOLTIPS

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
bool ThemeGalleryDlg::initThemeListCtrl()
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	const int nSelTab = m_tabPage.GetCurSel();
	ASSERT(THEME_GRAPH_TAB <= nSelTab && nSelTab < THEME_TAB_TOTAL);//ASSERT(THEME_GRAPH_TAB <= nSelTab && nSelTab <= THEME_DIALOG_TAB);///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	NICE_SAFE_REMOVAL(m_pThemeList);
	m_pThemeList = create_theme_list_ctrl(nSelTab);
	if ( NULL == m_pThemeList )
		return false;

	m_pThemeList->Init(IDC_THEME_GRID, *this);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	return true;
}

ThemeGWListCtrl* ThemeGalleryDlg::getGWListCtrl()
{
	ASSERT(NULL != m_pThemeList);
	ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType() && THEME_FUNCTION_TAB != m_pThemeList->GetThemeTabType());	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	ThemeGWListCtrl *pGWListCtrl = (ThemeGWListCtrl*)(m_pThemeList);
	ASSERT(NULL != pGWListCtrl);
	return pGWListCtrl;
}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
bool ThemeGalleryDlg::isAllowEdit(int nRow)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nPathType = m_themeGWList.GetCellData(nRow, GRID_COL_PATH_TYPE);
	//return (ORIGIN_PATH_GROUP == nPathType || ORIGIN_PATH_SYSTEM == nPathType)? false : true;
	const int nPathType = m_pThemeList->GetCellData(nRow, LIST_COL_PATH_TYPE);
	return (ORIGIN_PATH_GROUP != nPathType && ORIGIN_PATH_SYSTEM != nPathType);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	
}
///End NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
bool ThemeGalleryDlg::isCurrentLayerAvailable(int nTabType)
{
	if(nTabType == m_nPageType)
	{
		if(EXIST_WKS == m_nPageType)
		{
			Worksheet wks = Project.ActiveLayer();
			return !(wks.GetSystemParam(0) & WP_SHEET_HIERARCHY);
		}
		return true;
	}
	return false;
}
///End NOT_APPLY_THEME_TO_REPORT_SHEET
///Joseph 10/25/06 HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB
void ThemeGalleryDlg::onTabShowRightBottom()
{
	bool bShowRight, bShowBottom;
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//switch(m_nThemeType)
	//{
	//case THTYPE_GRAPH:
	//	bShowRight = true;
	//	bShowBottom = true;
	//	break;
	//case THTYPE_WORKSHEET:
	//	bShowRight = true;
	//	bShowBottom = false;
	//	break;
	//case THTYPE_ANALYSIS:
	//	bShowRight = false;
	//	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
	//	//bShowBottom = false;
	//	bShowBottom = true;
	//	//------ End EXCLUDE_LAST_USED_THEME
	//	break;
	//default:
	//	break;
	//}
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->GetTabShowPostion(bShowRight, bShowBottom);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	uint uRightControl[] = {IDC_STATIC_SET_SYSTEM_THEME, IDC_STATIC_CURRENT_SYSTEM_THEME, IDC_THEME_CURRENT_SYSTEM, IDC_THEME_APPLY_TO, IDC_THEME_APPLY_GROUP, IDC_THEME_APPLY, IDC_THEME_UNDO, 0};
	ShowControls(uRightControl, bShowRight);

	uint uBottomControl[] = {IDC_THEME_SHOW_GRAPH_ONLY , 0}
	ShowControls(uBottomControl, bShowBottom);
	if(bShowRight)
	{
		setApplyToList();
		enableButtons();
	}			
	OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
}
///End HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB
bool ThemeGalleryDlg::hasSystemTheme()
{
	string str = m_cntrlSystemTheme.Text;
	return str.IsEmpty()? false:true;
}

void ThemeGalleryDlg::setSystemTheme(int nRow)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	ThemeGWListCtrl *pGWListCtrl = getGWListCtrl();
	const int nThemeType = pGWListCtrl->GetThemeType();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	if(nRow < 0)
		return;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nCol = GRID_COL_IS_SYSTEM;
	//bool bCheck = m_themeGWList.GetCheck(nRow, nCol);
	const int nCol = LIST_COL_IS_SYSTEM;
	bool bCheck = m_pThemeList->GetCheck(nRow, nCol);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	if(bCheck)
		return;

	bCheck = true;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//string strTheme = m_themeGWList.GetCell(nRow, GRID_COL_NAME);
	const string strTheme = m_pThemeList->GetCell(nRow, LIST_COL_NAME);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
	// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
	// theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nPathType = m_themeGWList.GetCellData(nRow, GRID_COL_PATH_TYPE);
	const int nPathType = m_pThemeList->GetCellData(nRow, LIST_COL_PATH_TYPE);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	theme_system_getset(strTheme, true, bCheck, nPathType, nThemeType);
	///end USE_ENUM_ORIGIN_PATH_TYPE

	// next we need to clean those other checked since only one system theme is allowed
	checkSystemTheme();
}

void ThemeGalleryDlg::clearSystemTheme() // can ignore this for now
{
	bool bCheck;//, bIsEXEPath
	int nRowBeg, nRowEnd;
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//m_themeGWList.GetRowRange(nRow1, nRow2);
	ThemeGWListCtrl *pGWListCtrl = getGWListCtrl();
	const int nThemeType = pGWListCtrl->GetThemeType();
	pGWListCtrl->GetRowRange(nRowBeg, nRowEnd);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	string strTheme;
	for(int nRow = nRowBeg; nRow <= nRowEnd; nRow++)
	{
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//strTheme = m_themeGWList.GetCell(nRow, GRID_COL_NAME);
		strTheme = pGWListCtrl->GetCell(nRow, LIST_COL_NAME);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

		///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
		// bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
		// bCheck = theme_system_getset(strTheme, false, false, bIsEXEPath)? true : false;	///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//int nPathType = m_themeGWList.GetCellData(nRow, GRID_COL_PATH_TYPE);
		//bCheck = theme_system_getset(strTheme, false, false, nPathType, m_nThemeType);
		const int nPathType = pGWListCtrl->GetCellData(nRow, LIST_COL_PATH_TYPE);
		bCheck = theme_system_getset(strTheme, false, false, nPathType, nThemeType);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		///end USE_ENUM_ORIGIN_PATH_TYPE

		if(bCheck)
		{
			bCheck = false;
			///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
			// theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
			theme_system_getset(strTheme, true, bCheck, nPathType, nThemeType);
			///end USE_ENUM_ORIGIN_PATH_TYPE

			///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
			//m_themeGWList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
			////---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
			////m_themGWList.SetBold(nRow, GRID_COL_NAME, bCheck);
			//m_themeGWList.SetBold(nRow, -1, bCheck);
			////---
			pGWListCtrl->SetCheck(nRow, LIST_COL_IS_SYSTEM, bCheck);
			pGWListCtrl->SetBold(nRow, -1, bCheck);
			///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		}
	}
	m_cntrlSystemTheme.Text = "";
}

bool ThemeGalleryDlg::getNextThemeFileName(string& strFilename)
{	
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//string strThemePath = okutil_theme_get_path();
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//string strThemePath = okutil_theme_get_path(ORIGIN_PATH_USER, m_nThemeType);
	ASSERT(NULL != m_pThemeList);
	string strThemePath = okutil_theme_get_path(ORIGIN_PATH_USER, m_pThemeList->GetThemeFileType(strFilename));
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///End ADD_ANALYSIS_THEME_TO_TAB
	strFilename = strThemePath + strFilename;
	return get_next_file_name(strFilename);
}

bool ThemeGalleryDlg::getCopyOfThemeFileName(string& strFilename, const string& strThemeFilename)
{
	//---- CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
	//string strOldThemeFilename = GetFileName(strThemeFilename);
	//strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//string strOldThemeFilename = GetFileName(strThemeFilename, TRUE); // remove ext, and add later
	//strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
	//strFilename += "." + THEME_FILE_EXT;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//string strOldThemeFilename = GetFileName(strThemeFilename, TRUE); // remove ext, and add later
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//{
	//	/// EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME
	//	// OIS file name syntax is "<#>-<XFuncName>-<ThemeName>.ois"
	//	// ReverseFind can not support dash in theme name. Safer to find 2nd dash from beginning of string.
	//	///int nScopeIndex = strOldThemeFilename.ReverseFind('-');
	//	int nScopeIndex = strOldThemeFilename.Find('-');
	//	if( nScopeIndex >= 0 ) // If found first dash 
	//		nScopeIndex = strOldThemeFilename.Find('-', nScopeIndex + 1); // Find 2nd dash
	//	/// end SUPPORT_DASH_IN_THEME_NAME
	//	strOldThemeFilename.Insert(nScopeIndex + 1, "Copy of ");
	//	strFilename = strOldThemeFilename + "." + ANALYSIS_THEME_FILE_EXT;
	//}
	//else
	//{
	//	strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
	//	strFilename += "." + THEME_FILE_EXT;
	//}
	/////End ADD_ANALYSIS_THEME_TO_TAB
	////---- end THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->GetCopyOfThemeFileName(strThemeFilename, strFilename);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	return getNextThemeFileName(strFilename);
}

bool ThemeGalleryDlg::getCombineThemeFileName(string& strFilename, const string& strThemeFilename)
{
	strFilename = _L("Combined theme");
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//	add_file_extension(strFilename, ANALYSIS_THEME_FILE_EXT);
	//else
	//	///End ADD_ANALYSIS_THEME_TO_TAB
	//	add_file_extension(strFilename, THEME_FILE_EXT);
	// in dialog theme, it can't be combined!!!
	ASSERT(NULL != m_pThemeList);
	ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType() && THEME_FUNCTION_TAB != m_pThemeList->GetThemeTabType());	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	add_file_extension(strFilename, THEME_FILE_EXT);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	return getNextThemeFileName(strFilename);
}

bool ThemeGalleryDlg::getSelThemeFile(string& strThemeFilename)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nSelRow = m_themeGWList.GetSelectedRow();
	//if(nSelRow < 0)
	//	return false;

	//strThemeFilename = getThemeFileName(nSelRow);		
	//return true;
	ASSERT(NULL != m_pThemeList);
	return m_pThemeList->GetSelThemeFile(strThemeFilename);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}
bool ThemeGalleryDlg::getSelThemeFiles(StringArray& vstrThemeFilenames)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//vector<uint> vnRows;

	//if( !m_themeGWList.GetSelRows(vnRows) )
	//	return false;

	//if( !vstrThemeFilenames.SetSize(vnRows.GetSize()) )
	//	return false;

	//for(int ii=0; ii<vnRows.GetSize(); ii++)
	//	vstrThemeFilenames[ii] = getThemeFileName(vnRows[ii]);

	//return true;
	ASSERT(NULL != m_pThemeList);
	return m_pThemeList->GetSelThemeFiles(vstrThemeFilenames);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}
string ThemeGalleryDlg::getThemeFileName(int nRow)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	/////Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//{
	//	string strTheme = m_themeDialogList.GetCell(nRow, ANALYSIS_GRID_COL_NAME);
	//	string strScopeName = m_themeDialogList.GetCell(nRow, ANALYSIS_GRID_COL_SCOPE);
	//	string strTool = m_themeDialogList.GetCell(nRow, ANALYSIS_GRID_COL_FUNCTION);
	//	convColOrRowtoIndex(strTool);
	//	string strCategory = m_themeDialogList.GetCell(nRow, ANALYSIS_GRID_COL_CATEGORY);
	//	int nScope = theme_scopename_to_scopeindex(strScopeName);
	//	int nPathType = m_themeGWList.GetCellData(nRow, ANALYSIS_GRID_COL_PATH_TYPE);
	//	string strFileName = okutil_theme_construct_filename(strTheme, m_nThemeType , nPathType, nScope, strTool, strCategory);	
	//	return strFileName;
	//}
	//else
	//	///End ADD_ANALYSIS_THEME_TO_TAB
	//{			
	//	string strTheme = m_themeGWList.GetCell(nRow, GRID_COL_NAME);
	//	///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
	//	// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
	//	// return theme_get_theme_file_name(strTheme, bIsEXEPath);
	//	int nPathType = m_themeGWList.GetCellData(nRow, GRID_COL_PATH_TYPE);
	//	///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME
	//	//return theme_get_theme_file_name(strTheme, nPathType);
	//	//return theme_get_theme_file_name(strTheme, THTYPE_GRAPH, nPathType);
	//	return okutil_theme_get_theme_file_name(strTheme, m_nThemeType, nPathType);///DSC 2/23/05
	//	///end UPDATE_THEME_GET_FILENAME
	//	///end USE_ENUM_ORIGIN_PATH_TYPE
	//}
	ASSERT(NULL != m_pThemeList);
	return m_pThemeList->GetThemeFileName(nRow);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}
string ThemeGalleryDlg::getThemeTooltips(int nRow)
{
	string strThemeFile = getThemeFileName(nRow);
	string strComments;
	Tree trTemp(strThemeFile);
	if(trTemp)
		trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);

	return strComments;
}
// there seems to be no tooltip support for this version of vsFlex, so
// just use dialog title for now
void ThemeGalleryDlg::showTooltipText(string& str)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//m_themeGWList.SetToolTipsText(str);
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->SetToolTipsText(str);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}

int ThemeGalleryDlg::getThemeApply()
{
	int nApplyTo = m_cmbApplyTo.GetCurSel();

	if( nApplyTo < 0 )
		nApplyTo = 0;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nOffset = THEMEAPPLY_FOLDER;
	/////Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET 
	////if( m_bCurrentPage )
	////{
	//switch( m_nThemeType )
	//{
	//case THTYPE_GRAPH:
	//	if(m_bCurrentPage)
	//		nOffset = THEMEAPPLY_PAGE;
	//	break;

	//case THTYPE_WORKSHEET:
	//	nOffset = m_bCurrentPage? THEMEAPPLY_LAYER : THEMEAPPLY_PAGE;
	//	break;
	//}
	ThemeGWListCtrl *pGWThemeList = getGWListCtrl();
	const int nOffset = pGWThemeList->GetApplyOffset(m_bCurrentPage);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//}
	///End NOT_APPLY_THEME_TO_REPORT_SHEET
	return nOffset + nApplyTo;
}

void ThemeGalleryDlg::enableButtons()
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nSelRow = m_themeGWList.GetSelectedRow();
	//bool bEnable = nSelRow<0? false:true;
	ASSERT(NULL != m_pThemeList);
	ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType() && THEME_FUNCTION_TAB != m_pThemeList->GetThemeTabType());	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
	const bool bEnable = (0 <= m_pThemeList->GetSelectedRow());
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	//if(m_tabPage)
	//{
	//Button btn = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
	//btn.Enable = (m_tabPage.GetCurSel() == THEME_GRAPH_TAB);
	//}		
	///End CLEAN_THEME_ORGANIZER

	int nBtnIds[] = {IDC_THEME_APPLY,0};//, IDC_THEME_APPLY_TO, IDC_THEME_UNDO, 0};
	for(int ii=0; nBtnIds[ii] > 0; ii++)
	{
		Button btn = GetItem(nBtnIds[ii]);
		btn.Enable = bEnable;
	}
}
///Jasmine 02/15/06 ADD_TYPE_TAB 
void ThemeGalleryDlg::showButtons(bool bShow /*= true*/)
{
	int nBtnIds[] = {IDC_THEME_APPLY,0};
	int ii = 0;
	while(nBtnIds[ii] > 0)
	{
		Button btn = GetItem(nBtnIds[ii++]);
		btn.Enable = bShow;
	}
}
void ThemeGalleryDlg::setApplyToList()
{
	m_cmbApplyTo.ResetContent();

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//switch(m_nThemeType)
	//{
	//case THTYPE_GRAPH:
	//	if( m_bCurrentPage )
	//		m_cmbApplyTo.AddString(_L("Current Graph")); 
	//	m_cmbApplyTo.AddString(_L("Graphs in Folder"));
	//	m_cmbApplyTo.AddString(_L("Graphs in Project"));
	//	if(EXIST_WKS == m_nPageType)	///Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS
	//		m_cmbApplyTo.AddString(_L("Graphs in Current Sheet"));
	//	break;

	//case THTYPE_WORKSHEET:
	//	if( m_bCurrentPage )
	//		m_cmbApplyTo.AddString(_L("Current Sheet")); 
	//	m_cmbApplyTo.AddString(_L("Sheets in Book"));
	//	m_cmbApplyTo.AddString(_L("Sheets in Folder"));
	//	m_cmbApplyTo.AddString(_L("Sheets in Project"));
	//	break;

	//default:
	//	return;
	//}
	ThemeGWListCtrl *pGWListCtrl = getGWListCtrl();
	pGWListCtrl->GetApplyListToCombox(m_bCurrentPage, m_nPageType, m_cmbApplyTo);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	m_cmbApplyTo.SetCurSel(0);
}
///End ADD_TYPE_TAB

// if bUpdateButton, then
// nInc = 0 --> init
// inc > 0 or < 0, inc/decrement count
bool ThemeGalleryDlg::undoEnabled(bool bUpdateButton /*= false*/, int nInc /*= 0*/)
{
	Button btnUndo = GetItem(IDC_THEME_UNDO);
	if(bUpdateButton)
	{
		if(0==nInc)
			m_nUndoStackCount = 0;
		else
			m_nUndoStackCount += nInc;

		btnUndo.Enable = m_nUndoStackCount > 0? true:false;
	}

	return btnUndo.Enable;
}

void ThemeGalleryDlg::checkSystemTheme(int nRowToCheck /*= -1*/) // 
{	
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	ASSERT(NULL != m_pThemeList);
	if ( THEME_DIALOG_TAB == m_pThemeList->GetThemeTabType() 
		|| THEME_FUNCTION_TAB == m_pThemeList->GetThemeTabType() )	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
		return ;
	ThemeGWListCtrl *pGWListCtrl = getGWListCtrl();
	const int nThemeType = pGWListCtrl->GetThemeType();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	
	string strThemeName;
	int nRowBeg = nRowToCheck, nRowEnd = nRowToCheck;
	
	if(nRowToCheck < 0)
	{
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//m_themeGWList.GetRowRange(nRowBeg, nRowEnd);
		pGWListCtrl->GetRowRange(nRowBeg, nRowEnd);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	}
	string strSystemTheme;

	/// DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME
	//-- read system theme from ini once, not each time in the loop
	string strSysThemeINI, strSysThemePathKeyWordINI;
	//strSysThemeINI = theme_get_system_theme(&strSysThemePathKeyWordINI);
	strSysThemeINI = okutil_theme_get_system_theme(nThemeType);
	///end CLEANUP_GET_SYSTEM_THEME

	for(int nRow = nRowBeg; nRow <= nRowEnd; nRow++)
	{
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//strThemeName = m_themeGWList.GetCell(nRow, GRID_COL_NAME);
		strThemeName = pGWListCtrl->GetCell(nRow, LIST_COL_NAME);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

		///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
		// ///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
		// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
		// bool bCheck = theme_system_getset(strThemeName, false, false, bIsEXEPath)? true : false;
		// ///end
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//int nPathType = m_themeGWList.GetCellData(nRow, GRID_COL_PATH_TYPE);
		const int nPathType = pGWListCtrl->GetCellData(nRow, LIST_COL_PATH_TYPE);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

		// Category NULL for graph and wks themes
		// strThemeName = okutil_str_construct_path_category_name(nPathType, NULL, strThemeName);
		strThemeName = okutil_composite_name_from_components(nPathType, NULL, strThemeName);

		/// DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME  read system theme from ini once, not each time in the loop
		// bool bCheck = theme_system_getset(strThemeName, false, false, nPathType)? true : false;
		//-- check if theme agrees with system theme from ini file
		bool bCheck = false;
		// if( 0==strThemeName.CompareNoCase(strSysThemeINI) && 0==strSysThemePathKeyWordINI.CompareNoCase(get_origin_path_keyword(nPathType)) )
		if( 0 == strThemeName.CompareNoCase(strSysThemeINI))
			bCheck = true;
		///end CLEANUP_GET_SYSTEM_THEME

		///end USE_ENUM_ORIGIN_PATH_TYPE
		if(bCheck)
			strSystemTheme = strThemeName;

		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//m_themeGWList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
		////---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
		////m_themGWList.SetBold(nRow, GRID_COL_NAME, bCheck);
		//m_themeGWList.SetBold(nRow, -1, bCheck);
		////---
		pGWListCtrl->SetCheck(nRow, LIST_COL_IS_SYSTEM, bCheck);
		pGWListCtrl->SetBold(nRow, -1, bCheck);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	}
	///Sophy 3/13/2012 ORG-5161-P1 AMP_TRANSLATED_IN_RANGE_STRING_FROM_STATUSBAR_CONTEXT_MENU
	okutil_ampersand_string_for_display(strSystemTheme, TRUE);
	///end AMP_TRANSLATED_IN_RANGE_STRING_FROM_STATUSBAR_CONTEXT_MENU
	m_cntrlSystemTheme.Text = strSystemTheme;
}

int ThemeGalleryDlg::addThemes(TreeNode& trNode)
{
	int nRow = -1;
	string str, strLocation, strThemeName;
	foreach(TreeNode tn in trNode.Children)
	{			
		int nType;
		tn.GetAttribute(THEME_TYPE_ATTRIBUTE, nType);

		///DSC 2/16/05 GET_ORIGIN_PATH 
		// bool bIsEXEPath = nType == THTYPE_SYSTEM? true:false;
		// if(bIsEXEPath)
		// 	strLocation = STR_THEME_TYPE_SYSTEM;
		// else
		// 	strLocation = STR_THEME_TYPE_USER;
		strLocation = okutil_get_origin_path_keyword(nType);
		///end GET_ORIGIN_PATH


		strThemeName = tn.strVal;
		//--- CPY 4/1/03 CHECK_BOX_TO_SHOW_ONLY_GRAPH_THEME
		///DSC 2/16/05 GET_ORIGIN_PATH
		// string strThemeFilename = theme_get_theme_file_name(strThemeName, bIsEXEPath);
		///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME
		//string strThemeFilename = theme_get_theme_file_name(strThemeName, nType);
		// string strThemeFilename = theme_get_theme_file_name(strThemeName, THTYPE_GRAPH, nType);
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//string strThemeFilename = okutil_theme_get_theme_file_name(strThemeName, m_nThemeType, nType);///DSC 2/23/05
		int nThemeType;
		if ( !tn.GetAttribute(STR_THEME_TYPE_ATTRIB, nThemeType) )
		{
			ASSERT(THEME_DIALOG_TAB != m_pThemeList->GetThemeTabType());
			nThemeType = m_pThemeList->GetThemeFileType(NULL);
		}

		string strThemeFilename = okutil_theme_get_theme_file_name(strThemeName, nThemeType, nType);///DSC 2/23/05
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		///end UPDATE_THEME_GET_FILENAME
		///end GET_ORIGIN_PATH
		bool bIsIncrementList = theme_is_increment_theme(strThemeFilename);
		if(m_bExcludeIncremenTypes && bIsIncrementList)
			continue;
		//--- 
		string strDate = GetFileModificationDate(strThemeFilename, LDF_SHORT_AND_HHMM_SEPARCOLON); //CPY 4/25/03 ADD_FILE_DATE

		//----- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
		//str = "\t" + strLocation + "\t" + "click->" + "\t" + strThemeName;
		int nSize = theme_count_properties(strThemeFilename);	
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB  	
		//str = "\t" + strThemeName + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
		////-----
		//nRow = m_themGWList.AddTheme(str, nType, bIsIncrementList);

		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//if(m_nThemeType == THTYPE_ANALYSIS)
		//{
		//	string strName, strTool, strScope, strCategory;
		//	theme_filename_to_options(strThemeName, strName, strTool, strScope ,strCategory);
		//	//------ Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE
		//	////------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
		//	//if (m_bExcludeLastUsed && strName.CompareNoCase("Last used") == 0)
		//	//continue;
		//	////------ End EXCLUDE_LAST_USED_THEME
		//	if (m_bExcludeLastUsed && is_theme_last_used(strName))
		//		continue;
		//	//------ End CORRECT_THEME_TYPE_COMPARE
		//	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
		//	//str = "\t" + "" + "\t" + strName + "\t" + strTool + "\t" + strCategory + "\t" + strScope + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
		//	vector<string> vsColValues(ANALYSIS_GRID_COL_TOTAL);
		//	vsColValues[ ANALYSIS_GRID_COL_IS_SYSTEM ] = "";
		//	vsColValues[ ANALYSIS_GRID_COL_MENU ] = "";
		//	vsColValues[ ANALYSIS_GRID_COL_NAME ] = strName;
		//	vsColValues[ ANALYSIS_GRID_COL_FUNCTION ] = strTool;
		//	vsColValues[ ANALYSIS_GRID_COL_CATEGORY ] = strCategory;
		//	vsColValues[ ANALYSIS_GRID_COL_SCOPE ]= strScope;
		//	vsColValues[ ANALYSIS_GRID_COL_SIZE ] = (string)nSize;
		//	vsColValues[ ANALYSIS_GRID_COL_PATH_TYPE ] = strLocation;
		//	vsColValues[ ANALYSIS_GRID_COL_DATE ] = strDate;
		//	str.SetTokens(vsColValues, '\t');
		//	///End USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
		//	nRow = m_themeDialogList.AddTheme(str, nType, bIsIncrementList);
		//}
		//else			
		//{
		//	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
		//	//str = "\t" + strThemeName + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
		//	vector<string> vsColValues(GRID_COL_TOTAL);
		//	vsColValues[ GRID_COL_IS_SYSTEM ]= "";
		//	vsColValues[ GRID_COL_NAME ] = strThemeName;
		//	vsColValues[ GRID_COL_SIZE ]= (string)nSize;
		//	vsColValues[ GRID_COL_PATH_TYPE ] = strLocation;
		//	vsColValues[ GRID_COL_DATE ]= strDate;
		//	str.SetTokens(vsColValues, '\t');
		//	///End USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
		//	nRow = m_themeGWList.AddTheme(str, nType, bIsIncrementList);
		//}
		/////End ADD_ANALYSIS_THEME_TO_TAB
		vector<string> vsColValues(LIST_COL_TOTAL);

		if ( THEME_DIALOG_TAB == m_pThemeList->GetThemeTabType() 
			|| THEME_FUNCTION_TAB == m_pThemeList->GetThemeTabType() )	///Jasmine 06/07/2012 ORG-5923-4 NEW_TAB_FOR_FUNC_THEME_IN_THEME_GALLERY
		{
			string strName, strTool, strScope, strCategory;
			theme_filename_to_options(strThemeName, strName, strTool, strScope ,strCategory);
		
			if ( m_bExcludeLastUsed && is_theme_last_used(strName) )
				continue;

			strThemeName						= strName;
			vsColValues[LIST_COL_MENU]			= "";
			vsColValues[LIST_COL_FUNCTION]		= strTool;
			vsColValues[LIST_COL_CATEGORY]		= strCategory;
			vsColValues[LIST_COL_SCOPE]			= strScope;
			vsColValues[LIST_COL_FILE_EXT]		= okutil_theme_get_file_extension(nThemeType);
		}

		vsColValues[LIST_COL_IS_SYSTEM]		= "";
		vsColValues[LIST_COL_NAME]			= strThemeName;
		vsColValues[LIST_COL_SIZE]			= (string)nSize;
		vsColValues[LIST_COL_PATH_TYPE]		= strLocation;
		vsColValues[LIST_COL_DATE]			= strDate;
		str.SetTokens(vsColValues, '\t');
		nRow = m_pThemeList->AddTheme(str, nType, bIsIncrementList);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	}
	return nRow;
}

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//bool ThemeGalleryDlg::isIncrementListRow(int nRow)
//{
//	return m_themeGWList.IsItalic(nRow, GRID_COL_NAME);	
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeGalleryDlg::loadThemesToGrid(bool bRemoveOld /*= true*/, bool bSelLast /*= true*/)
void ThemeGalleryDlg::loadThemesToGrid()
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//if(bRemoveOld)
	//{	
	//	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB 
	//	//m_themeList.Reset();
	//	if(m_nThemeType == THTYPE_ANALYSIS)
	//		m_themeDialogList.Reset();
	//	else
	//		m_themeGWList.Reset();
	//	///End ADD_ANALYSIS_THEME_TO_TAB
	//}
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->Reset();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	Tree trTemp;
	trTemp.AddNode("Themes");

	// theme_find_all_theme_files(trTemp.FirstNode);

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//theme_find_all_theme_files(trTemp.FirstNode, ORIGIN_PATH_UNDEF, m_nThemeType);///DSC 2/23/05
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->FindAllThemeFiles(trTemp.FirstNode);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

	addThemes(trTemp.FirstNode);
	checkSystemTheme();
	resizeThemeCols();
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB 

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//	m_themeDialogList.SelRow(-1, false);
	//else
	//	m_themeGWList.SelRow(-1, false);
	m_pThemeList->SelRow(-1, false);	// false mean not select last row
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	///End ADD_ANALYSIS_THEME_TO_TAB
}

///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
// no need to use
//void ThemeGalleryDlg::addThemeToGrid(const string& strThemeFilename, bool bUser /*= true*/, bool bSelIt /*= true*/)
//{
//	Tree trTemp;
//	trTemp.AddNode("Themes");
//	//theme_add_one_theme_file(trTemp.FirstNode, strThemeFilename, bUser);	///Jasmine 12/30/09 see DSC 2/16/05 GET_ORIGIN_PATH
//	///Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
//	//theme_add_one_theme_file(trTemp.FirstNode, strThemeFilename, bUser? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM);
//	theme_add_one_theme_file(trTemp.FirstNode, GetFileName(strThemeFilename, true), bUser? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM);
//	///End theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
//	int nRow = addThemes(trTemp.FirstNode);
//	checkSystemTheme();
//	resizeThemeCols();	
//	if(bSelIt)
//		m_themeGWList.SelRow(nRow, true);
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

void ThemeGalleryDlg::resizeThemeCols()
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//m_themeGWList.ResizeCols(2);// was 3, Easwar said he has theme name longer	
	ASSERT(NULL != m_pThemeList);
	m_pThemeList->ResizeCols(2);
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}
void ThemeGalleryDlg::loadOptions()
{
	m_bShowTooltips = true;
	vector<byte> vbCheckSettings;
	if(load_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName) && vbCheckSettings.GetSize() > 0)
		m_bShowTooltips = vbCheckSettings[0];
}
void ThemeGalleryDlg::saveOptions()
{
	vector<byte> vbCheckSettings;
	vbCheckSettings.Add(m_bShowTooltips);
	save_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName);
}

/// Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
//void ThemeGalleryDlg::afterEditUsed(ThemeListCtrlBase &ThemeList, int nCol, int nRow, int nColName, int nColLocation)
//{
//	if(nColName == nCol)
//	{
//		string strNew = ThemeList.GetCell(nRow, nCol);
//		if(strNew.CompareNoCase(m_strOldStr) != 0)
//		{
//			// need to rename file
//			///DSC 2/15/05 GET_ORIGIN_PATH
//			// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
//			// if(!theme_rename(strNew, m_strOldStr, bIsEXEPath))
//			int nPathThpe = ThemeList.GetCellData(nRow, nColLocation);
//			// if(!theme_rename(strNew, m_strOldStr, nPathThpe))
//			///Jasmine 09/29/07 QA70-7416 FIX_RENAME_ANALYSIS_THEME_BUG
//			//if(!theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType))
//			bool bRet;
//			if(m_nThemeType == THTYPE_ANALYSIS) 
//			{
//				string strFullNewName, strFullOldName;
//				getSelThemeFile(strFullNewName);
//				strFullOldName = strFullNewName = GetFileName(strFullNewName, TRUE);
//				strFullOldName.Replace(strNew, m_strOldStr);
//				bRet = theme_rename(strFullNewName, strFullOldName, nPathThpe, m_nThemeType);
//			}
//			else
//				bRet = theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType);
//			///End FIX_RENAME_ANALYSIS_THEME_BUG
//			if(!bRet)
//				///end 2/15/05 GET_ORIGIN_PATH
//				ThemeList.SetCell(nRow, nCol, m_strOldStr);
//			else
//				checkSystemTheme(nRow);
//		}
//	}
//}

//void ThemeGalleryDlg::popupAnalysisMenu(ThemeListControlMenuBase& myMenu, int nx, int ny)
//{
//	myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
//	int nCmd;
//	if(myMenu.GetCommand(nCmd))
//	{
//		Control flxControl = GetItem(IDC_THEME_GRID);
//		switch(nCmd)
//		{
//			//case ANALYSIS_THEME_EDIT:
//			//OnEditTheme(flxControl);
//			//break;
//		case ANALYSIS_THEME_DELETE:
//			OnDelTheme(flxControl);
//			break;
//		case ANALYSIS_THEME_DUPLICATE:
//			OnDuplicate(flxControl);
//			break;
//			//case ANALYSIS_THEME_COMBINE:
//			//OnCombine(flxControl);
//			//break;
//		case ANALYSIS_THEME_SHOW_TOOLTIPS:
//			m_bShowTooltips = !m_bShowTooltips;
//			break;
//		}
//	}
//}
//void ThemeGalleryDlg::popupGWListMenu(ThemeListControlMenuBase& myMenu, int nRow, int nx, int ny)
//{
//	myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
//	int nCmd;
//	if(myMenu.GetCommand(nCmd))
//	{
//		Control flxControl = GetItem(IDC_THEME_GRID);
//		switch(nCmd)
//		{
//		case THEME_ADD:
//			OnAdd(flxControl);
//			break;
//		case THEME_EDIT:
//			OnEditTheme(flxControl);
//			break;
//		case THEME_DELETE:
//			OnDelTheme(flxControl);
//			break;
//		case THEME_DUPLICATE:
//			OnDuplicate(flxControl);
//			break;
//		case THEME_COMBINE:
//			OnCombine(flxControl);
//			break;
//		case THEME_SET_SYSTEM:
//			setSystemTheme(nRow);
//			break;
//		case THEME_CLEAR_SYSTEM:
//			clearSystemTheme();
//			break;
//		case THEME_SHOW_TOOLTIPS:
//			m_bShowTooltips = m_bShowTooltips? false:true;
//			break;
//		}
//	}
//}

// move to ThemeListCtrlBase
//void ThemeGalleryDlg::convColOrRowtoIndex(string& strTool)
//{
//	if(strTool.Find("DescStats") == 0)
//	{
//		///---Sim 10-10-2007 FIX_THEME_NAME_ASSIGNED_ERROR
//		/*
//		if(strTool.Find("(Row)"))
//		strTool.Replace("(Row)","");
//		if(strTool.Find("(Col)"))
//		strTool.Replace("(Col)","_1");
//		*/
//		if(strTool.Find("(Row)"))
//			strTool.Replace("(Row)","_1");
//		if(strTool.Find("(Col)"))
//			strTool.Replace("(Col)","");
//		///---END FIX_THEME_NAME_ASSIGNED_ERROR
//	}
//}
///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE

///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
void ThemeGalleryDlg::refreshGridList(LPCSTR lpcszThemeName /*= NULL*/)
{
	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//int nNameCol;
	//ThemeListCtrlBase* pList = NULL; 
	//if(m_nThemeType == THTYPE_ANALYSIS)
	//{
	//	nNameCol = ANALYSIS_GRID_COL_NAME;
	//	pList = &m_themeDialogList;
	//}
	//else
	//{
	//	nNameCol = GRID_COL_NAME;
	//	pList = &m_themeGWList;
	//}

	//if(pList == NULL)
	//	return;
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//pList->ClearAll();	//load_themes_to_grid will reset the grid

	ASSERT(NULL != m_pThemeList);
	loadThemesToGrid();

	if(lpcszThemeName)
	{
		///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
		//int nRow = pList->FindRow(lpcszThemeName, nNameCol);
		//pList->SelRow(nRow);
		int nRow = m_pThemeList->FindRow(lpcszThemeName, LIST_COL_NAME);
		m_pThemeList->SelRow(nRow);
		///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	}
}
///End SELECT_CORRESPONDING_THEME
///End ADD_ANALYSIS_THEME_TO_TAB
///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
void ThemeGalleryDlg::onChangeDescription()
{
	Control ctrl = GetItem(IDC_STATIC_SYSTEM_THEME_DESCIPTION);
	if(!ctrl)
		return;

	///-----Kit 10/17/2011 ORG-4121-S1 SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
	//switch(m_nThemeType)
	//{
	//case THTYPE_GRAPH:
	//	ctrl.Text = _L("A system theme can be applied automatically when making new graphs");
	//	break;
	//case THTYPE_WORKSHEET:
	//	ctrl.Text = _L("A system theme can be applied automatically when making new worksheet");
	//	break;
	//case THTYPE_ANALYSIS:
	//	ctrl.Text = _L("A dialog theme can be applied automatically when reopen its corresponding dialog");
	//	break;
	//}
	ASSERT(NULL != m_pThemeList);
	ctrl.Text = m_pThemeList->GetChangeDescription();
	///-----End SUPPORT_THEME_GALLERY_TO_LOAD_ODT_FILE
}
///End CLEAN_THEME_ORGANIZER

 
#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

int ThemeGallery()
{
	ThemeGalleryDlg themeDlg;
	
	int nRet = themeDlg.DoModalEx( GetWindow() );
	
	return 0;
}


