/*------------------------------------------------------------------------------*
 * File Name:ThemeEditor.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for ThemeEditing Dialog						*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/21/03 EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS						*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	DSC 2/2/2005 v8.0189 SHOW_TIME_OF_THEME_MODIFICATION						*
 *	Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	 					*
 *	RVD 10/13/2005 BRING_BACK_SHOW_COLLECTION									*
 *	Jasmine 04/06/06 QA70-8603 v8.0385  WKS_THEME_EDITOR						*
 *	CPY 4/15/06 THEME_TREE_NEEDS_IMPROVED_INFO_DISPLAY							*
 *	CPY 6/27/2006 GRID_TABLE_FORMATTING											*
 *  Joseph 9/4/06 SAVE_FILE_TO_CORRECT_FOLDER									*
 *	Joseph 01/18/07	MOVE_DECLERATION_TO_HEADER_FILE								*
 *	Jasmine 08/13/07 MAKE_APPLY_UNDOABLE										*
 *	CPY 8/23/2007 REMOVE_THEME_EDITOR_H_AND_MOVE_CODES_TO_THIS_FILE				*
 *	Jasmine 09/07/07 FILTER_BUTTON_ONLY_FOR_GRAPH_THEME							*
 *	Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING		*
 *	RVD 8/4/2009 qa70-14064 DELETE_WKS_NAMED_STYLE_PROPERTY						*
 *	Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME		*
 *	Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES								*
 *	Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID			*
 *	Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY			*
 *	Kyle 07/13/2011 ORG-3222-P1 COMPARE_THEME_SUB_FOLDER_NO_CASE				*
 *	CPY 5/11/2012 ORG-5603 GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE				*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
//#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
//#include <utilities.h>
//#include <tree_utils.h>
///	#include "ResizeDialog.h" /// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <TreeEditor.h>
///	#include <vsFlexGrid.h>	/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include "GridControl.h"
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
///	#include "HelpID.h"
///	#include "theme_utils.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#define _USE_GENERAL_OBJ_THEME_TREE_DLG_ //CPY 5/11/2012 ORG-5603 GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE

///------------ CPY 8/23/2007 REMOVE_THEME_EDITOR_H_AND_MOVE_CODES_TO_THIS_FILE
//#include "ThemeEditor.h"
// I found "ThemeEditor.h" is no longer on VSS, so I find an older version and put here
class ThemeTreeControl : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg);
	
	bool Load(LPCSTR lpcszFilename);
	
	bool Save(LPCSTR lpcszFilename);
	
	bool GetTree(Tree& tr);
	
private:
	string getFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute);
	
	void setFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute, LPCSTR lpcszVal);
	
private:
	TreeEditor	m_treeEditor;
};


///Joseph 01/11/06 ADD_NEW_THEME_EDITOR_BASE_CLASS
class ThemeEditorDlg : public ResizeDialog
{
public:
	ThemeEditorDlg() : ResizeDialog(IDD_STYLSHT_EDITOR, "ODlg")
	{
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		m_nThemeType = THTYPE_UNDEF;
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	}   
	
	
	BOOL GetEditingFile(string& strEditingFile);			///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

protected:
///----------------- Message Map ----------------
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	
	ON_SIZE(OnDlgResize)		
	ON_BN_CLICKED(IDC_STYLSHT_LIST_VIEW, OnListViewCheck)
	ON_BN_CLICKED(IDC_STYLSHT_SHOW_EMPTY, OnShowCheck)
	ON_BN_CLICKED(IDC_STYLSHT_SHOW_COLLECTION, OnShowCheck)
	ON_BN_CLICKED(IDC_WKS_THEME_SAVE_AS, OnSaveAs)			///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	ON_DESTROY(OnDestroy)
EVENTS_END
///----------------------------------------------
	
	BOOL OnListViewCheck(Control oCntrl);
	
	BOOL OnShowCheck(Control oCntrl);
	
	void updateViewTree();
	
	virtual BOOL OnDestroy(void){	return FALSE;	}
	
	virtual BOOL OnInitDialog(){	return FALSE;	}
	
	virtual BOOL OnDlgResize() {	return FALSE;	}


	virtual void updateViewTreeSize(){}

	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	int		GetFileThemeType(LPCSTR lpcszFile);
	virtual BOOL OnSaveAs(Control ctrl);
	virtual BOOL SaveTreeEditor(LPCSTR lpcszFile)	{	return FALSE;	}
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	
private:
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	bool inputThemeName(string& strName, string& strComment, bool& bSys);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

	
protected:
	Button				m_btnShowEmpty;
	Button				m_btnShowCollection;
	string				m_strThemeFileName;	

	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	int					m_nThemeType;
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
};
///End ADD_NEW_THEME_EDITOR_BASE_CLASS


class OrganizerThemeEditerDlg : public ThemeEditorDlg
{
public:
	bool Init(LPCSTR lpcszThemeFilename);
	
	BOOL OnInitDialog();
	
	BOOL OnDlgResize(int nType, int cx, int cy);
	
	int DoModalEx(HWND hWndParent = NULL);
	
	BOOL OnOK();
	
	BOOL OnTreeChanged(uint wParam, uint lParam);
	
	BOOL OnThemeFilter(Control oCntrl);
		
protected:
	DECLARE_MESSAGE_MAP

	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	// virtual
	BOOL	SaveTreeEditor(LPCSTR lpcszFile);

	// virtual
	BOOL OnSaveAs(Control ctrl);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
private:
	void updateTreeViewSize(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID =0);
	void initThemeInfo();		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	
private:
	string			m_strComments;
	bool			m_bReadOnly;
	ThemeTreeControl 		m_treeCntrl;
	Control			m_cSave;		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	Control			m_cFilename;
	Control			m_cReadOnly;
	Control			m_cModified;
	Edit 			m_editComments;
	TempThemeFile	m_tempThemeFile;
};

//---------- end ///------------ CPY 8/23/2007 REMOVE_THEME_EDITOR_H_AND_MOVE_CODES_TO_THIS_FILE


///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
//bool ThemeEditor(LPCSTR lpcszThemeFilename, HWND hWndParent)//= NULL)
bool ThemeEditor(LPCSTR lpcszThemeFilename, HWND hWndParent, string* pstrEditingFile = NULL)
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
{
	///Joseph 01/11/06 MOVE_DECLERATION_TO_HEADER_FILE
	//ThemeEditorDlg	ThemeEditor;
	//if(!ThemeEditor.Init(lpcszThemeFilename))
		//return false;
	OrganizerThemeEditerDlg ThemeEditor;
	if(! ThemeEditor.Init(lpcszThemeFilename))
		return false;
	///End MOVE_DECLERATION_TO_HEADER_FILE
	int nRet = ThemeEditor.DoModalEx(hWndParent);

	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	if( pstrEditingFile )
		ThemeEditor.GetEditingFile(*pstrEditingFile);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

	return (IDCANCEL == nRet)? false:true;
}


#define STR_ATTRIB_COLLAPSE "Collaps"	//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED

void ThemeTreeControl::Init(int nID, Dialog& dlg)
{
	GridListControl::InitControl(nID, dlg);
	m_treeEditor = dlg.GetItem(nID);
	/// Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	m_flx = m_treeEditor.GetGridCtrlInterface();
#else		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
	m_flx = m_treeEditor.GetActiveXControl();
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__ /// Hong 16/09/10 ORG-35 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

	SetFont();
}

bool ThemeTreeControl::Load(LPCSTR lpcszFilename)
{
	return m_treeEditor.Load(lpcszFilename);
}

bool ThemeTreeControl::Save(LPCSTR lpcszFilename)
{
	return m_treeEditor.Save(lpcszFilename);
}
bool ThemeTreeControl::GetTree(Tree& tr)
{
	//TreeNode tr1 = m_treeEditor.Root;
	tr = m_treeEditor.Root;
	return tr.IsValid()?true:false;
}

//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
string ThemeTreeControl::getFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute)
{
	string str;
	Tree trTemp(lpcszFile);
	if(trTemp.IsValid())
	{
		trTemp.GetAttribute(lpcszAttribute, str);
	}
	return str;
}
void ThemeTreeControl::setFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute, LPCSTR lpcszVal)
{
	string str;
	Tree trTemp(lpcszFile);
	if(trTemp.IsValid())
	{
		trTemp.SetAttribute(lpcszAttribute, lpcszVal);
	}
}
//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED

///Class ThemeEditorDlg, Base Class
BOOL ThemeEditorDlg::OnListViewCheck(Control oCntrl)
{
	Button btnListView = oCntrl;
	if(btnListView.Check)
	{
		m_btnShowEmpty.Enable = false;
		m_btnShowCollection.Enable = false;
	}
	else
	{
		m_btnShowEmpty.Enable = true;
		m_btnShowCollection.Enable = true;
	}
		
	updateViewTree();
	return TRUE;
}
	
BOOL ThemeEditorDlg::OnShowCheck(Control oCntrl)
{
	updateViewTree();
	return TRUE;
}

void ThemeEditorDlg::updateViewTree()
{
	Button btnListView = GetItem(IDC_STYLSHT_LIST_VIEW);
	bool btnListViewCheck  = btnListView.Check;
	
	TreeEditor tree = GetItem(IDC_STYLSHT_TREE);
	
	/// RVD 10/13/2005 BRING_BACK_SHOW_COLLECTION
	//DWORD dwSettings = theme_update_tree_list_view(btnListViewCheck);
	DWORD dwSettings = theme_update_tree_list_view(btnListViewCheck, m_btnShowCollection.Check, m_btnShowEmpty.Check);
	/// end BRING_BACK_SHOW_COLLECTION

	tree.View = dwSettings;
}

///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
int ThemeEditorDlg::GetFileThemeType(LPCSTR lpcszFile)
{
	vector<uint> vnTHType = {THTYPE_GRAPH, THTYPE_WORKSHEET, THTYPE_MATRIX};
	
	string strFileName = GetFileName(lpcszFile);
	///Kyle 07/13/2011 ORG-3222-P1 COMPARE_THEME_SUB_FOLDER_NO_CASE
	string strThemeFileName = m_strThemeFileName;
	strThemeFileName.MakeUpper();
	strFileName.MakeUpper();
	///End COMPARE_THEME_SUB_FOLDER_NO_CASE
	for(int ii=0; ii<vnTHType.GetSize(); ii++)
	{
		string strSubPath;
		strSubPath.Format("%s\%s", okutil_theme_get_sub_special_folder(vnTHType[ii]), strFileName);
		///Kyle 07/13/2011 ORG-3222-P1 COMPARE_THEME_SUB_FOLDER_NO_CASE
		//if( 0 <= m_strThemeFileName.Find(strSubPath) )
		strSubPath.MakeUpper();
		if( 0 <= strThemeFileName.Find(strSubPath) )
		///End COMPARE_THEME_SUB_FOLDER_NO_CASE
			return vnTHType[ii];
	}

	return THTYPE_UNDEF;
}

BOOL ThemeEditorDlg::GetEditingFile(string& strEditingFile)
{
	if( m_strThemeFileName.IsFile() )
	{
		strEditingFile = m_strThemeFileName;
		return true;
	}

	strEditingFile.Empty();
	return false;
}
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME, move to base class
//bool WksThemeEditorDlg::inputThemeName(string& strName, string& strComment, bool& bSys)
bool ThemeEditorDlg::inputThemeName(string& strName, string& strComment, bool& bSys)
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
{
	///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
	StringArray saFiles;
	DWORD dwCtrl = GFL_GET_FIRST_ONLY | GFL_REMOVE_PATH; //finding all, keeping duplicates, not GFL_GET_FIRST_ONLY
	okutil_get_theme_file_list(&saFiles, NULL,  ORIGIN_PATH_UNDEF, m_nThemeType, dwCtrl);
	
	int nSize = saFiles.GetSize();
	for(int ii = 0; ii < nSize; ii++)
	{
		saFiles[ii] = GetFileName(saFiles[ii], TRUE);
	}
	saFiles.Sort();
	
	string strThemeList;
	strThemeList.SetTokens(saFiles, '|');
	strThemeList = "|"+strThemeList;
	///End SHOW_EXIST_THEMES
	
	GETN_TREE(trSave)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_STRLIST(ThemeName, _L("Name of the new theme"), "", strThemeList) ///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
	GETN_STR(Descrition, _L("Description"), "")	GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	GETN_CHECK(System,_L("Set as System Theme"), false)
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//Window Wnd = GetWindow();
	//if(!Wnd || !GetNBox(trSave, _L("Save Formats as Theme..."), _L("Input name for new theme"), NULL, NULL, Wnd.GetSafeHwnd()))
	if(!GetNBox(trSave, _L("Save Formats as Theme..."), _L("Input name for new theme"), NULL, NULL, GetSafeHwnd()))
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		return false;
	strName 	= trSave.ThemeName.strVal;
	strComment 	= trSave.Descrition.strVal;
	bSys		= trSave.System.nVal;
	return true;
}

///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME, move to base class
//BOOL WksThemeEditorDlg::OnSaveAs(Control oCntrl)
BOOL ThemeEditorDlg::OnSaveAs(Control ctrl)
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
{
	//same as SaveFormatAsTheme.c
	string strThemeName, strComments;
	bool bSystem;
	inputThemeName(strThemeName, strComments, bSystem);
	if(strThemeName.IsEmpty())
		return FALSE;
	if(!is_str_valid_for_filename(strThemeName))
	{
		/// Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
		//MessageBox(GetSafeHwnd(), "The specified theme name is not a valid file name.", "Theme Saving", MB_OK);
		MessageBox(GetSafeHwnd(), STR_SAVE_THEME_BAD_FILENAME, STR_SAVE_THEME_CAPTION, MB_OK);
		/// end SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
		return FALSE;
	}
	string strTempThemeFilename;
	GetTempFileName(strTempThemeFilename);
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//m_tree.Save(strTempThemeFilename);
	if( !SaveTreeEditor(strTempThemeFilename) )
		return FALSE;
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	if(!strTempThemeFilename.IsFile())
	{
		out_str("Err, Save Theme dialog error!");
		return TRUE;
	}
	// description
	if(!strComments.IsEmpty())
	{
		Tree trTemp(strTempThemeFilename);
		trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
		trTemp.Save(strTempThemeFilename);
	}
	
	string strThemeFile = okutil_theme_get_theme_file_name(strThemeName, m_nThemeType);		
	string strPathOnly = GetFilePath(strThemeFile);
	if(CheckMakePath(strPathOnly))
	{		
		/// Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
		//if(strThemeFile.IsFile() && MessageBox(GetSafeHwnd(), "The named theme file already existed, do you want to replace it?", "Theme Saving", MB_OKCANCEL) == IDCANCEL)
		if(strThemeFile.IsFile() && MessageBox(GetSafeHwnd(), STR_SAVE_THEME_ASK_REPLACE, STR_SAVE_THEME_CAPTION, MB_OKCANCEL) == IDCANCEL)
		/// end SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
		{
			DeleteFile(strTempThemeFilename); 
			return FALSE;
		}
		///Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		//CopyFile(strTempThemeFilename, strThemeFile);
		if( !CopyFile(strTempThemeFilename, strThemeFile) )
			popup_errmsg_save_readonly_file( strThemeFile, GetSafeHwnd() );
		///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		
		if(bSystem)
			theme_system_getset(strThemeName, true, true, ORIGIN_PATH_USER, m_nThemeType);
			
		DeleteFile(strTempThemeFilename);
		
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		m_strThemeFileName = strThemeFile;
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

		return TRUE;
	}
	else
	{
		DeleteFile(strTempThemeFilename);
		return false;
	}
}

bool OrganizerThemeEditerDlg::Init(LPCSTR lpcszThemeFilename)
{
	m_strThemeFileName = lpcszThemeFilename;
	if(!m_strThemeFileName.IsFile())
		return false;
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	m_nThemeType = GetFileThemeType(m_strThemeFileName);
	if( THTYPE_UNDEF==m_nThemeType )
		return false;
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	if(m_tempThemeFile.Init(lpcszThemeFilename))
	{
		DWORD	dwAttributes = GetFileAttributes(lpcszThemeFilename);
		m_bReadOnly = (dwAttributes & FILE_ATTRIBUTE_READONLY)? true:false; // will need to add testing for folder readonly later
		
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		if( !m_bReadOnly )		// check if built-in or group theme
		{
			string strFilePath = GetFilePath(m_strThemeFileName);;
			string strSysThemePath = okutil_theme_get_path(ORIGIN_PATH_SYSTEM, m_nThemeType);
			string strGroupThemePath = okutil_theme_get_path(ORIGIN_PATH_GROUP, m_nThemeType);

			m_bReadOnly = (0==strSysThemePath.CompareNoCase(strFilePath)) || (0==strGroupThemePath.CompareNoCase(strFilePath));
		}
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		return true;
	}
	return false;
}

int OrganizerThemeEditerDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();// will be called from internal later
	int nRet = DoModal(hWndParent);
	
	return nRet;
}

BOOL OrganizerThemeEditerDlg::OnInitDialog()
{
	waitCursor junk;
	ResizeDialog::OnInitDialog();
	m_treeCntrl.Init(IDC_STYLSHT_TREE, *this);
	///Jasmine 09/07/07 FILTER_BUTTON_ONLY_FOR_GRAPH_THEME
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	/*
	string strSubPath;
	strSubPath.Format("%s\%s", okutil_theme_get_sub_special_folder(THTYPE_GRAPH), GetFileName(m_strThemeFileName));
	bool bGraphTheme = 0 <= m_strThemeFileName.Find(strSubPath);
	GetItem(IDC_STYLSHT_FILTER).Visible = bGraphTheme;
	///End FILTER_BUTTON_ONLY_FOR_GRAPH_THEME
	// load from s_strTempFilename
	m_cFilename = GetItem(IDC_STYLSHT_FILENAME);
	m_cFilename.Text = m_strThemeFileName;
	//m_treeEditor.Load(m_tempThemeFile.GetFileName());
	m_treeCntrl.Load(m_tempThemeFile.GetFileName());	
	
	m_btnShowEmpty = GetItem(IDC_STYLSHT_SHOW_EMPTY);
	m_btnShowCollection = GetItem(IDC_STYLSHT_SHOW_COLLECTION);
	
	updateViewTree();
	///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	//theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT);
	updateTreeViewSize(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT);
	///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
			// use this text to get basic edge
	RECT r1;
	if(GetControlClientRect(IDC_STYLSHT_READONLY, r1, &m_cReadOnly))
		SetControlGap(r1.left);
	m_cReadOnly.Visible = m_bReadOnly;
	
	m_cModified = GetItem(IDC_STYLSHT_DATE);

	///DSC 2/2/05 SHOW_TIME_OF_THEME_MODIFICATION
	//m_cModified.Text = GetFileModificationDate(m_strThemeFilename);
	m_cModified.Text = GetFileModificationDate(m_strThemeFileName, LDF_SHORT_AND_HHMMSS_SEPARCOLON);
	///end SHOW_TIME_OF_THEME_MODIFICATION
	
	m_strComments.Empty();
	
	Tree trTemp(m_tempThemeFile.GetFileName());
	
	m_editComments = GetItem(IDC_STYLSHT_COMMENT);
	m_editComments.Enable = m_bReadOnly? false:true;
	
	if(trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, m_strComments))
		m_editComments.Text = m_strComments;
	*/
	m_cSave = GetItem(IDOK);
	m_cFilename = GetItem(IDC_STYLSHT_FILENAME);
	m_btnShowEmpty = GetItem(IDC_STYLSHT_SHOW_EMPTY);
	m_btnShowCollection = GetItem(IDC_STYLSHT_SHOW_COLLECTION);
	RECT r1;
	if(GetControlClientRect(IDC_STYLSHT_READONLY, r1, &m_cReadOnly))
		SetControlGap(r1.left);
	m_cModified = GetItem(IDC_STYLSHT_DATE);
	m_editComments = GetItem(IDC_STYLSHT_COMMENT);

	m_treeCntrl.Load(m_tempThemeFile.GetFileName());
	updateViewTree();
	updateTreeViewSize(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT);

	initThemeInfo();
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

	return TRUE;	
}

BOOL OrganizerThemeEditerDlg::OnDlgResize(int nType, int cx, int cy)
{
	uint nBtnIds[] =
	{
		IDOK,
		IDCANCEL,
		IDC_WKS_THEME_SAVE_AS,			///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		IDC_STYLSHT_FILTER,
		IDC_STYLSHT_LIST_VIEW,
		IDC_STYLSHT_SHOW_EMPTY,
		IDC_STYLSHT_SHOW_COLLECTION,
		0
	};
		
	ResizeMoveControlsRightBottom(IDC_STYLSHT_TREE, nBtnIds, NULL, cx, cy);
	return TRUE;
}

///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
void OrganizerThemeEditerDlg::initThemeInfo()
{
	m_cSave.Enable = (m_bReadOnly ? false : true);				// runtime error here

	GetItem(IDC_STYLSHT_FILTER).Visible = THTYPE_GRAPH==m_nThemeType;
	///Sophy 3/13/2012 ORG-5161-P1 AMP_TRANSLATED_IN_RANGE_STRING_FROM_STATUSBAR_CONTEXT_MENU
	//m_cFilename.Text = m_strThemeFileName;
	string strDispFileName = m_strThemeFileName;
	okutil_ampersand_string_for_display(&strDispFileName, TRUE);
	m_cFilename.Text = strDispFileName;
	///end AMP_TRANSLATED_IN_RANGE_STRING_FROM_STATUSBAR_CONTEXT_MENU
	m_cReadOnly.Visible = m_bReadOnly;
	m_cModified.Text = GetFileModificationDate(m_strThemeFileName, LDF_SHORT_AND_HHMMSS_SEPARCOLON);

	m_strComments.Empty();
	Tree trTemp(m_tempThemeFile.GetFileName());
	if( trTemp.IsValid() )
		trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, m_strComments);
	if(m_editComments)
	{
		m_editComments.Enable = m_bReadOnly? false:true;
		m_editComments.Text = m_strComments;
	}
}

// virtual
BOOL OrganizerThemeEditerDlg::SaveTreeEditor(LPCSTR lpcszFile)
{
	return m_treeCntrl.Save(lpcszFile);
}

// virtual
BOOL OrganizerThemeEditerDlg::OnSaveAs(Control ctrl)
{
	if( ThemeEditorDlg::OnSaveAs(ctrl) )
	{
		CopyFile(m_strThemeFileName, m_tempThemeFile.GetFileName());		// copy the new saved file to temporary file
		m_bReadOnly = false;
		initThemeInfo();
		return true;
	}
	return false;
}
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

void OrganizerThemeEditerDlg::updateTreeViewSize(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID) //=0
{
	if(nTreeID)
	{
		TreeEditor tree = theDlg.GetItem(nTreeID);
		tree.Save(lpcszFilename);
	}
	int nCount = 0;
	Tree themeTree(lpcszFilename);
	if(themeTree)
		nCount = tree_count_items(themeTree);
	
	Control cTreeLeafCounts = theDlg.GetItem(nSizeID);
	cTreeLeafCounts.Text = nCount;
}



BEGIN_MESSAGE_MAP_DERIV(OrganizerThemeEditerDlg, ThemeEditorDlg)
	ON_SIZE(OnDlgResize)	
	ON_OK(OnOK)
	ON_USER_MSG(WM_USER_ON_CONTROL_CHANGE, OnTreeChanged)
	ON_BN_CLICKED(IDC_STYLSHT_FILTER, OnThemeFilter)
END_MESSAGE_MAP_DERIV

BOOL OrganizerThemeEditerDlg::OnOK()
{
	if(!m_bReadOnly)
	{
		//m_treeEditor.Save(m_strThemeFilename);
		//---- CPY 8/21/03 EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS
		/*
		m_treeCntrl.Save(m_strThemeFilename);
		string strComments = m_editComments.Text;
		if(strComments.CompareNoCase(m_strComments) != 0)
		{
			Tree trTemp(m_strThemeFilename);
			trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
			trTemp.Save(m_strThemeFilename);
		}
		*/
		Tree trTemp;			
		m_treeCntrl.GetTree(trTemp);
		string strComments = m_editComments.Text;
		trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
		
		//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
		/*
		vector<byte> vn;
		if(m_treeCntrl.GetCollapsed(vn) > 1)
		{
			BitsHex temp;
			string	strTemp;
			temp.BitsToHexStr(vn, strTemp);
			trTemp.SetAttribute(STR_ATTRIB_COLLAPSE, strTemp);
		}
		*/
		//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED

		trTemp.Save(m_strThemeFileName);
		//---- end EMPTY_THEME_SOMETIMES_NOT_SAVING_COMMENTS
	}
	return TRUE;
}

BOOL OrganizerThemeEditerDlg::OnTreeChanged(uint wParam, uint lParam)
{
	///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	//theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
	updateTreeViewSize(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
	///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	return TRUE;
}
BOOL OrganizerThemeEditerDlg::OnThemeFilter(Control oCntrl)
{
	///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	/*
	if(theme_filter_dialog(*this, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE))
		theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
	*/
	string strTempThemeFile;
	if(!GetTempFileName(strTempThemeFile))
		return false;

	TreeEditor tree = GetItem(IDC_STYLSHT_TREE);
		
	tree.Save(strTempThemeFile);
	if(theme_filter_dialog(GetSafeHwnd(), strTempThemeFile))
	{
		tree.Load(strTempThemeFile);
		updateViewTree();
		
		updateTreeViewSize(*this, m_tempThemeFile.GetFileName(), IDC_STYLSHT_COUNT, IDC_STYLSHT_TREE);
	}
	if(strTempThemeFile.IsFile())
		DeleteFile(strTempThemeFile);
	
	///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	return TRUE;
}	
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//---- CPY 5/11/2012 ORG-5603 GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE
#ifdef _USE_GENERAL_OBJ_THEME_TREE_DLG_
class ObjThemeEditorDlg : public ThemeEditorDlg
{	
public:
	ObjThemeEditorDlg() : ThemeEditorDlg() {}

	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = DoModal(hWndParent);
		return nRet;
	}
protected:
	DECLARE_MESSAGE_MAP
protected:	
	BOOL OnInitDialog() {
		waitCursor junk;
		ResizeDialog::OnInitDialog();
		Window Wnd = GetWindow();
		Wnd.Text = GetDlgTitle(); 
		string strTempThemeFilename;
		//GetTempFileName(m_strThemeFileName);/// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
		GetTempFileName(strTempThemeFilename);
		OnInitObject(strTempThemeFilename);
		m_tree = GetItem(IDC_STYLSHT_TREE);
		m_tree.Load(strTempThemeFilename);
		Button btnClose		= GetItem(IDCANCEL);
		btnClose.Text = _L("Close");
		m_btnShowEmpty 		= GetItem(IDC_STYLSHT_SHOW_EMPTY);
		m_btnShowCollection = GetItem(IDC_STYLSHT_SHOW_COLLECTION);
		m_btnShowCollection.Check = true;
		//stretch
		Button btnTop = GetItem(IDC_STYLSHT_FILENAME);
		RECT rTop, rBottom;
		GetClientRect(btnTop, rTop);
		GetClientRect(m_tree, rBottom);
		StretchControlHeight(IDC_STYLSHT_TREE, rBottom.left, rTop.top, rBottom.bottom);
		//show some and hide some
		OnShowControls();
		updateViewTree();
		m_nThemeType = GetThemeType();
		return TRUE;	
	}
	BOOL OnApply(Control oCntrl) {
		if(m_obj)
		{
			Tree trTheme;			
			trTheme = m_tree.Root;
			m_obj.ApplyFormat(STYLE_REPAINT|STYLE_RELATIVE|STYLE_UNDO|STYLE_COMPLETE, trTheme);
		}
		return TRUE;
	}
	void SetObject(OriginObject obj) {m_obj = obj;}
	virtual void OnInitObject(LPCSTR lpcszTempThemeFile) {}
	virtual int  GetThemeType() {return THTYPE_UNDEF;}
	// virtual
	BOOL SaveTreeEditor(LPCSTR lpcszFile) {return m_tree.Save(lpcszFile);return true;}
	BOOL OnDestroy(void) {return true;}
	BOOL OnDlgResize(int nType, int cx, int cy){
		uint nBtnIds[] =
		{
			IDC_WKS_THEME_APPLY,
			IDC_WKS_THEME_SAVE_AS,
			IDCANCEL,
			IDC_STYLSHT_LIST_VIEW,
			IDC_STYLSHT_SHOW_EMPTY,
			IDC_STYLSHT_SHOW_COLLECTION,
			0
		};
		ResizeMoveControlsRightBottom(IDC_STYLSHT_TREE, nBtnIds, NULL, cx, cy);
		return TRUE;
	}
private:
	void updateTreeViewSize(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID =0, int nTreeID =0) {
		if(nTreeID)
		{
			TreeEditor tree = theDlg.GetItem(nTreeID);
			tree.Save(lpcszFilename);
		}
	}
	virtual void OnShowControls() {}
	virtual string GetDlgTitle() {return "No Name";}
private:
	TreeEditor			m_tree;
	OriginObject		m_obj;
};
BEGIN_MESSAGE_MAP_DERIV(ObjThemeEditorDlg, ThemeEditorDlg)
	ON_SIZE(OnDlgResize)		
	ON_BN_CLICKED(IDC_WKS_THEME_APPLY, OnApply)
END_MESSAGE_MAP_DERIV

class WksThemeEditorDlg : public ObjThemeEditorDlg
{	
public:
	WksThemeEditorDlg() : ObjThemeEditorDlg() {}

	WksThemeEditorDlg(Grid& gg) : ObjThemeEditorDlg()
	{
		m_grid = gg;
	}
protected:
	//virtual 
	void OnInitObject(LPCSTR lpcszTempThemeFilePath) {
		Datasheet wks = Project.ActiveLayer();
		if(wks)
			m_grid.Attach(wks);
		if(m_grid)
		{
			SetObject(m_grid);
			Tree trTheme;
			trTheme = m_grid.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
			theme_update_display_attributes_for_easier_edit(trTheme);
			trTheme.Save(lpcszTempThemeFilePath);
		}
	}
	//virtual 
	int  GetThemeType() {return THTYPE_WORKSHEET;}
	//virtual
	void OnShowControls() {
		uint nBtnHides[] =
		{
			IDOK,
			IDC_STYLSHT_FILTER,
			IDC_STYLSHT_READONLY,
			IDC_STYLSHT_FILENAME,
			IDC_STYLSHT_COMMENT,
			IDC_STYLSHT_COUNT,
			IDC_STYLSHT_DATE,
			0
		};	
		ShowControls(nBtnHides, 0);
		uint nBtnShows[] =
		{
			IDC_WKS_THEME_APPLY,
			IDC_WKS_THEME_SAVE_AS,
			0
		};	
		ShowControls(nBtnShows, 1);
	}
	//virtual
	string GetDlgTitle() {return _L("Worksheet Theme Editor");}
private:
	Grid				m_grid;
};

class OriginObjThemeEditorDlg : public ObjThemeEditorDlg
{	
public:
	OriginObjThemeEditorDlg() : ObjThemeEditorDlg() {}

protected:
	//virtual 
	void OnInitObject(LPCSTR lpcszTempThemeFilePath) {
		OriginObject OrgObj;
		OrgObj = Selection.Objects(0);
		if(OrgObj)
		{
			SetObject(OrgObj);
			Tree trTheme;
			trTheme = OrgObj.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
			theme_update_display_attributes_for_easier_edit(trTheme);
			trTheme.Save(lpcszTempThemeFilePath);
		}
	}
	//virtual 
	//int  GetThemeType() {return THTYPE_WORKSHEET;}
	//virtual
	void OnShowControls() {
		uint nBtnHides[] =
		{
			IDOK,
			IDC_STYLSHT_FILTER,
			IDC_STYLSHT_READONLY,
			IDC_STYLSHT_FILENAME,
			IDC_STYLSHT_COMMENT,
			IDC_STYLSHT_COUNT,
			IDC_STYLSHT_DATE,
			IDC_WKS_THEME_SAVE_AS,
			0
		};	
		ShowControls(nBtnHides, 0);
		uint nBtnShows[] =
		{
			IDC_WKS_THEME_APPLY,
			0
		};	
		ShowControls(nBtnShows, 1);
	}
	//virtual
	string GetDlgTitle() {return _L("Origin Object Theme Editor");}
};

#endif //_USE_GENERAL_OBJ_THEME_TREE_DLG_
//---- end GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE

#ifndef _USE_GENERAL_OBJ_THEME_TREE_DLG_
class WksThemeEditorDlg : public ThemeEditorDlg
{	
public:
	WksThemeEditorDlg() : ThemeEditorDlg() {}

	WksThemeEditorDlg(Grid& gg) : ThemeEditorDlg()
	{
		m_grid = gg;
	}

	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = DoModal(hWndParent);
		return nRet;
	}
	
protected:
	DECLARE_MESSAGE_MAP
	
protected:	
	BOOL OnInitDialog();
	
	BOOL OnApply(Control oCntrl);
	
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME, move to base class
	//BOOL OnSaveAs(Control oCntrl);

	// virtual
	BOOL SaveTreeEditor(LPCSTR lpcszFile);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	
	BOOL OnDestroy(void);

	BOOL OnDlgResize(int nType, int cx, int cy);
	
private:
	void updateTreeViewSize(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID =0, int nTreeID =0);
	
	void showControls();
	
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//bool inputThemeName(string& strName, string& strComment, bool& bSys);
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	
private:
	TreeEditor			m_tree;
	
	Grid				m_grid;
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME, move to base class
	//int					m_nThemeType;			
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
};
#endif //_USE_GENERAL_OBJ_THEME_TREE_DLG_

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
#ifndef _USE_GENERAL_OBJ_THEME_TREE_DLG_
BEGIN_MESSAGE_MAP_DERIV(WksThemeEditorDlg, ThemeEditorDlg)
	ON_SIZE(OnDlgResize)		
	ON_BN_CLICKED(IDC_WKS_THEME_APPLY, OnApply)
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME, move to base class
	//ON_BN_CLICKED(IDC_WKS_THEME_SAVE_AS, OnSaveAs)
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
END_MESSAGE_MAP_DERIV	

BOOL WksThemeEditorDlg::OnApply(Control oCntrl)
{
	if(m_grid)
	{
		Tree trTheme;			
		trTheme = m_tree.Root;
		//trTemp.Save(m_strThemeFileName);
		//theme_apply(THEMEAPPLY_LAYER, m_strThemeFileName);
		/// RVD 8/4/2009 qa70-14064 DELETE_WKS_NAMED_STYLE_PROPERTY
		//m_grid.ApplyFormat(trTheme, TRUE, TRUE, TRUE);	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE	
		m_grid.ApplyFormat(STYLE_REPAINT|STYLE_RELATIVE|STYLE_UNDO|STYLE_COMPLETE, trTheme);
		/// end DELETE_WKS_NAMED_STYLE_PROPERTY
	}
	return TRUE;
}

///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
// virtual
BOOL WksThemeEditorDlg::SaveTreeEditor(LPCSTR lpcszFile)
{
	return m_tree.Save(lpcszFile);
}
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

BOOL WksThemeEditorDlg::OnInitDialog()
{
	waitCursor junk;
	ResizeDialog::OnInitDialog();
	Window Wnd = GetWindow();
	Wnd.Text = _L("Worksheet Theme Editor"); 
	
	//----- CPY 6/27/2006 GRID_TABLE_FORMATTING
	//if(!copyAllFormats())	//set m_strThemeFileName
	//	return false;
	//TreeEditor
	//addNameStyleLabel();
	
	string strTempThemeFilename; /// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY

	/// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	//GetTempFileName(m_strThemeFileName);
	GetTempFileName(strTempThemeFilename);
	/// End THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	if(!m_grid)
	{
		//---- CPY 4/29/08 QA70-10823 MAT_ROW_HEADING_SHOULD_NOT_MERGE, need to turn on support to edit format for matrix
		//Worksheet wks = Project.ActiveLayer();
		Datasheet wks = Project.ActiveLayer();
		//----
		if(wks)
			m_grid.Attach(wks);
	}
	if(m_grid)
	{
		Tree trTheme;
		trTheme = m_grid.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
		theme_update_display_attributes_for_easier_edit(trTheme);
		/// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
		//trTheme.Save(m_strThemeFileName);
		trTheme.Save(strTempThemeFilename);
		/// End THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	}
	//-----
	m_tree = GetItem(IDC_STYLSHT_TREE);
	/// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	//m_tree.Load(m_strThemeFileName);
	m_tree.Load(strTempThemeFilename);
	/// End THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	
	Button btnClose		= GetItem(IDCANCEL);
	btnClose.Text = _L("Close");
	m_btnShowEmpty 		= GetItem(IDC_STYLSHT_SHOW_EMPTY);
	m_btnShowCollection = GetItem(IDC_STYLSHT_SHOW_COLLECTION);
	m_btnShowCollection.Check = true;
	
	//stretch
	Button btnTop = GetItem(IDC_STYLSHT_FILENAME);
	RECT rTop, rBottom;
	GetClientRect(btnTop, rTop);
	GetClientRect(m_tree, rBottom);
	StretchControlHeight(IDC_STYLSHT_TREE, rBottom.left, rTop.top, rBottom.bottom);
	
	//show some and hide some
	showControls();
	updateViewTree();
	m_nThemeType = THTYPE_WORKSHEET;   ///Joseph 9/4/06 SAVE_FILE_TO_CORRECT_FOLDER
	return TRUE;	
}

BOOL WksThemeEditorDlg::OnDestroy(void)
{
	/// Bill 01/05/2011 ORG-1153-P1 THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	//if(m_strThemeFileName.IsFile())
	//	DeleteFile(m_strThemeFileName);
	//m_strThemeFileName.Empty();
	/// End THEME_FILE_DELETED_WHEN_DIALOG_DESTORY
	return TRUE;
}

BOOL WksThemeEditorDlg::OnDlgResize(int nType, int cx, int cy)
{
	uint nBtnIds[] =
	{
		IDC_WKS_THEME_APPLY,
		IDC_WKS_THEME_SAVE_AS,
		IDCANCEL,
		IDC_STYLSHT_LIST_VIEW,
		IDC_STYLSHT_SHOW_EMPTY,
		IDC_STYLSHT_SHOW_COLLECTION,
		0
	};
	ResizeMoveControlsRightBottom(IDC_STYLSHT_TREE, nBtnIds, NULL, cx, cy);
	return TRUE;
}

void WksThemeEditorDlg::updateTreeViewSize(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID)
{
	if(nTreeID)
	{
		TreeEditor tree = theDlg.GetItem(nTreeID);
		tree.Save(lpcszFilename);
	}
}

void WksThemeEditorDlg::showControls()
{
	uint nBtnHides[] =
	{
		IDOK,
		IDC_STYLSHT_FILTER,
		IDC_STYLSHT_READONLY,
		IDC_STYLSHT_FILENAME,
		IDC_STYLSHT_COMMENT,
		IDC_STYLSHT_COUNT,
		IDC_STYLSHT_DATE,
		0
	};	
	ShowControls(nBtnHides, 0);
	uint nBtnShows[] =
	{
		IDC_WKS_THEME_APPLY,
		IDC_WKS_THEME_SAVE_AS,
		0
	};	
	ShowControls(nBtnShows, 1);
}

#endif //_USE_GENERAL_OBJ_THEME_TREE_DLG_

//---- CPY 6/27/2006 GRID_TABLE_FORMATTING
BOOL EditGridTheme(Grid& gg)
{
	WksThemeEditorDlg	WksThemeEditor(gg);
	int nRet = WksThemeEditor.DoModalEx(GetWindow());
	return (IDCANCEL == nRet)? false:true;
}
//----

///End WKS_THEME_EDITOR

///#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
BOOL EditWksTheme()
{
	WksThemeEditorDlg	WksThemeEditor;
	int nRet = WksThemeEditor.DoModalEx(GetWindow());
	return (IDCANCEL == nRet)? false:true;
}

//---- CPY 5/11/2012 ORG-5603 GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE
#ifdef _USE_GENERAL_OBJ_THEME_TREE_DLG_
void ObjectEdit()
{
	OriginObjThemeEditorDlg dlg;
	dlg.DoModalEx(GetWindow());
}
#endif //_USE_GENERAL_OBJ_THEME_TREE_DLG_
//---- end GENERAL_THEME_EDITOR_FOR_DEBUG_PURPOSE

