/*------------------------------------------------------------------------------*
 * File Name: OC_Const.h														*
 * Creation: CPY 6/5/2001														*
 * Purpose: Origin C enum and define constants shared with internal codes		*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * CPY 10/5/05 CLASS_FORWARD_DECLARATION_MUST_USE_PTR							*
 * Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX							*
 * Jasmine 12/19/05 v8.0349 MODIFICATION_ON_BUTTONS								*
 * Jasmine 12/28/05 QA70-6475 v8.0351 REMEMBER_LAST_SELECTION					*
 * Jasmine 12/29/05 OPEN_PLOT_SETUP_DIALOG										*
 * SY 02/01/2006 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS				*
 * Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI						*
 * Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY						*
 * Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND							*
 * Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML						*
 * Folger 08/24/07 FIND_TEMPLATE_AND_CATEGORY_IN_M_TRTP							*
 * Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL					*
 * Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML							*
 * Folger 10/10/07 CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE			*
 * Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
 * Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH							*
 * Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE				*
 * Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF					*
 * Folger 01/10/08 FIX_BUGS_WHEN_CATEGORY_AND_TEMPLATE_HAVE_THE_SAME_NAME		*
 *	Folger 07/02/08 QA80-10951-P4 KEEP_EMPTY_CATEGORY_IN_TEMPLATE_ORGANIZER		*
 *	Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER			*
 *	Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
 *	Sim 05-20-2009 QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC					*
 *	Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION					*
 *------------------------------------------------------------------------------*/

#ifndef _TO_TEMPLATEORGANIZER_H_
#define	_TO_TEMPLATEORGANIZER_H_
#include <Control.h>
/// SY 02/01/2006 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS
///	///DG 8/9/05
///	enum {
///		TP_TYPE_UNDEFINED=-1,
///		TP_TYPE_GRAPH,
///		TP_TYPE_WORKBOOK,
///		TP_TYPE_MATRIX,
///		
///		TP_TOTAL_TYPES
///	};
#define TP_TYPE_UNDEFINED 	EXIST_NONE
#define TP_TYPE_WORKBOOK	EXIST_WKS
#define TP_TYPE_GRAPH		EXIST_GRAPH
#define TP_TYPE_MATRIX		EXIST_MATRIX
/// end TEMPLATE_INFO_INTERNAL_ACCESS

enum {
	TP_LEVEL_BRANCH   = 1,
	TP_LEVEL_CATEGORY,
	TP_LEVEL_TEMPLATE,
};
///jasmine 12/26/05
enum{
	TP_BTN_NEW = 0,
	TP_BTN_ADD,
	TP_BTN_DELETE,
	TP_BTN_OK,
	TP_BTN_PLOTSETUP,
	
	TP_BTN_CANCEL
};

#include <Array.h>
#include <ocGDI.h>

/// SY 02/01/2006 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS
// Move to oc_const.h
///	#define STR_TEMPLATE_NODE		"Template"
///	#define STR_BRANCH_NODE			"Category"
///	#define STR_NEW_CATEGORY_PREFIX	"NewCategory"
///	#define STR_DELETE_SECTION		"DeletedSystemFile"
//------ Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
//#define STR_DELETE_SECTION 			STR_DELETED_SYSTEM_FILE
//------ End LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
/// end TEMPLATE_INFO_INTERNAL_ACCESS

#define STR_USER_PATH 			okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE)
#define STR_SYSTEM_PATH 		okutil_get_origin_path(ORIGIN_PATH_SYSTEM, NULL, TRUE)
//#define STR_TEMPLATE_FILE		STR_USER_PATH + "Template.xml"	///Jasmine 03/31/09 DUPLICATE_OF__STR_TEMPLATE_XML
#define STR_PICT_NO_PREVIEW		"No Preview available"	///Jasmine 12/26/05 PICT_NO_PREVIEW	
#define WM_USER_BTNS_STATUS 		(WM_USER + 1022)	///Jasmine 12/26/05
typedef BOOL (*FUNC_BOOL_INT_STR_HWND) (BOOL bNewPlot, int nPlotID, LPCSTR lpcszTemplate, HWND hWndParent);///Jasmine 12/29/05 OPEN_PLOT_SETUP_DIALOG

///---Sim 05-20-2009 QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC
// move to OC_const.h
//#define STR_USER_PATH_ATTRIB "User"
///---END QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC

///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
//#define STR_PREVIEW_GRAPH_TEMPLATE  okutil_get_origin_path(ORIGIN_PATH_SYSTEM, "Templates\Previews")
///------ End NO_PREVIEW_EMF_LOCALIZATION

class TemplateOrganizer
{
public:
	TemplateOrganizer(HWND hParent = NULL);///Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND
	~TemplateOrganizer();
	
	bool GetTemplateListFile(Tree& tr);
	string GetLabel(TreeNode& tr);
	bool IsTemplateNode(TreeNode& tr);
	int GetTemplateType();
	//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	//virtual Control& GetCtrl();
	//virtual void DestroyControl() {;}
	//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	virtual string GetTemplateExt() {return "";}
//---- Kevin	
	//virtual bool LoadTemplate(LPCSTR lpcszTemplate) {return false;}
	virtual BOOL LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl) {return false;}
	//virtual void ConstructSubTree(TreeNode &tr){return;}///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
		
	TreeNode NewCategory(TreeNode &tr, string &strCategory);
	TreeNode AddTemplate(TreeNode &trCate, string strFullName, string* pstrName = NULL, bool bRestore = false);	///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
	TreeNode DelCateOrTemp(TreeNode &trParent, TreeNode &trDel);
	int GetMultiOpenBox(vector<string>& vsFilePaths, LPCSTR lpcszPath = NULL); //=NULL
	bool CategoryRename(TreeNode& tr, string strName);	///Jasmine 12/26/05 DBCLICK_RENAME
	bool FindTemplate(const TreeNode &tr, string strTemplate, TreeNode &trTemplate, TreeNode &trCategory = NULL);	//------ Folger 08/24/07 FIND_TEMPLATE_AND_CATEGORY_IN_M_TRTP
	bool FindCategory(const TreeNode &tr, string strCategory, TreeNode &trCategory);		//------ Folger 10/10/07 CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE
	///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
	//virtual TreeNode ScanUserTemplates(TreeNode &trXML){return NULL;}			///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	TreeNode ScanUserTemplates(TreeNode &trXML);
	///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
protected:
	BOOL loadImage(PictureControl& picCtrl, LPCSTR lpcszPict);
	//void addNodeFromTempFiles(TreeNode& tr);///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
	TreeNode treeAddCateNode(TreeNode& trParent, string& strCateName);
	TreeNode treeAddTempNode(TreeNode& trParent, string strTempName, string strFileName);
	//void getTemplateFile(StringArray& saFile, string strType, bool bUser);///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI

	///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
	string		NoPreviewPicture();
	///------ End NO_PREVIEW_EMF_LOCALIZATION

private:
	///Jasmine 09/27/06 MECHANISM_CHANGE
	//string checkExist(string strName, TreeNode& trParent, bool bCheckAll);
	//string checkExist(string strName, TreeNode& trParent, bool bTemplate = true, string* pstrFile = NULL);///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
	TreeNode checkExist(string strName, TreeNode& trParent, bool bTemplate = true, string* pstrFile = NULL, string* pstrCate = NULL);	
	///End MECHANISM_CHANGE
	void   moveFromDel(string strDel, TreeNode& trDelBranch);
	bool constructXMLTree(TreeNode &trXML, const TreeNode &trPart, int nPath);	//------ Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	bool removeDeleteFileFromXML(TreeNode &trXML, const TreeNode &trUser);		//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	void filterOpenGLTemplate(TreeNode& trXML);			///Jasmine 10/10/2012 ORG-7074-S1 SEPARATE_BUILT_IN_OPENGL_TMPLATE
	
protected:	
	bool extract_template_to_image(LPCSTR lpcszTemplate, LPCSTR lpcszImage);//--CPY 4/4/08 TEMPLATE_SAVE_BROKEN_DUE_TO_FUNC_NOT_FOUND

protected:
	HWND			m_hwnd;
	int				m_nType;
};
class GraphTemplate : public TemplateOrganizer
{
public:
	GraphTemplate(HWND hParent = NULL) : TemplateOrganizer(hParent)///Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND
	{
		m_nType = TP_TYPE_GRAPH;
		///Jasmine 12/20/05 SAMPLE_DATA_TO_SHOW_PLOT
		/*
		//DG 8/24/05 : sample data to show plot
		WorksheetPage wp;
		wp.Create("origin", CREATE_HIDDEN);
		m_wksData = wp.Layers(0);
		Dataset dsX(m_wksData, 0), dsY(m_wksData, 1);
		dsX.Data(-10.0, 10.0, 0.05);
		dsY.SetSize(dsX.GetSize());
		for (int i = 0; i < dsX.GetSize(); i++)
		{
			dsY[i] = 100.0 * exp(-0.5 * dsX[i]*dsX[i]);	//gauss data
		}
		*/
	}
	~GraphTemplate()
	{
		/*
		if(m_wksData)
		{
			m_wksData.GetPage().Destroy();
		}
		*/
		///End SAMPLE_DATA_TO_SHOW_PLOT
	}
	
	//virtual
	//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	//Control& GetCtrl();
	//void DestroyControl();
	//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	string GetTemplateExt(){return "otp";}
//---- Kevin	
	//bool LoadTemplate(LPCSTR lpcszTemplate);
	BOOL LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl);
	//void ConstructSubTree(TreeNode &tr);///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
	
	///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
	/////Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	////virtual
	//TreeNode ScanUserTemplates(TreeNode &trXML);
	/////End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
private:
	
private:
	//GraphControl			m_CtrlGraph;		//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	//GraphPageControl		m_graph;
	GraphPage				m_graphPage;
	//Worksheet				m_wksData;	///Jasmine 12/20/05 SAMPLE_DATA_TO_SHOW_PLOT
};
class WorkbookTemplate : public TemplateOrganizer
{
public:
	WorkbookTemplate(HWND hParent = NULL) : TemplateOrganizer(hParent)///Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND
	{
		m_nType = TP_TYPE_WORKBOOK;
	}
	
	//virtual
	//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	//Control& GetCtrl();
	//void DestroyControl();
	//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	string GetTemplateExt(){return "otw";}
//---- Kevin
	//bool LoadTemplate(LPCSTR lpcszTemplate);
	BOOL LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl);
//----
	//void ConstructSubTree(TreeNode &tr);///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
private:
	
private:
	//WorksheetControl		m_CtrlWorkbook;		//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
};
class MatrixTemplate : public TemplateOrganizer
{
public:
	MatrixTemplate(HWND hParent = NULL) : TemplateOrganizer(hParent)///Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND
	{
		m_nType = TP_TYPE_MATRIX;
	}
	
	//virtual
	//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	//Control& GetCtrl();
	//void DestroyControl();
	//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	string GetTemplateExt(){return "otm";}
//---- Kevin
	//bool LoadTemplate(LPCSTR lpcszTemplate);
	BOOL LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl);
//----

	//void ConstructSubTree(TreeNode &tr);///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
private:
	
private:
	//MatrixControl			m_CtrlMatrix;		//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	
};


/////////////////////////////////////////////////////////////////////////////
////////////////////////////	TemplateOrganizer	/////////////////////////
/////////////////////////////////////////////////////////////////////////////

TemplateOrganizer::TemplateOrganizer(HWND hParent)// = NULL
{
	m_hwnd = hParent;
	m_nType = TP_TYPE_UNDEFINED;
}
TemplateOrganizer::~TemplateOrganizer()
{
}

bool TemplateOrganizer::GetTemplateListFile(Tree& tr)
{
	string strFile = STR_TEMPLATE_XML;
	///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
	//use the same codes as template_saveas
	//if(strFile.IsFile() && tr.Load(strFile))
	///Jasmine 11/22/06 REMOVE_TEMPLATE_NODE_IF_FILE_INVALID
	/*
	if(!strFile.IsFile())
		construct_template_organizer_tree();
	if(tr.Load(strFile))
	*/
	
	//------ Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	//if(load_template_tree(tr))	
	/////End REMOVE_TEMPLATE_NODE_IF_FILE_INVALID
	/////End ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
		//return true;
	//return false;
	///Jasmine 10/10/2012 ORG-7074-S1 SEPARATE_BUILT_IN_OPENGL_TMPLATE
	//if (!load_template_tree(tr))
		//return false;
	if (!load_template_tree(tr, TEMPLATE_LOCATION_SYSTEM_FOLDER))
		return false;
	filterOpenGLTemplate(tr);
	///End SEPARATE_BUILT_IN_OPENGL_TMPLATE
	Tree trUser, trGroup;
	if (load_template_tree(trUser, TEMPLATE_LOCATION_USER_FOLDER))
	{
		removeDeleteFileFromXML(tr, trUser);		//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
		constructXMLTree(tr, trUser, ORIGIN_PATH_USER);
	}
	if (load_template_tree(trGroup, TEMPLATE_LOCATION_GROUP_FOLDER))
		constructXMLTree(tr, trGroup, ORIGIN_PATH_GROUP);	
	return true;
	//------ End COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
}
string TemplateOrganizer::GetLabel(TreeNode& tr)
{
	string str;
	tr.GetAttribute(STR_LABEL_ATTRIB, str);
	return str;
}
bool TemplateOrganizer::IsTemplateNode(TreeNode& tr)
{
	if(!tr.IsValid())
		return false;
	string str;
	return tr.GetAttribute(STR_FILENAME_ATTRIB, str);
}
int TemplateOrganizer::GetTemplateType()
{
	return m_nType;
}
//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
//Control& TemplateOrganizer::GetCtrl()
//{
	//ASSERT(0);
	//Control cc;
	//return cc;
//}
//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
TreeNode TemplateOrganizer::NewCategory(TreeNode &trBranch, string &strName)
{
	TreeNode trNewCategory = treeAddCateNode(trBranch, strName);	
	return trNewCategory;
}
///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
TreeNode TemplateOrganizer::AddTemplate(TreeNode &trCate, string strFullName, string* pstrName, bool bRestore)//NULL
{
	TreeNode trNewTemp;
	if(!trCate || !strFullName.IsFile())
		return trNewTemp;
	
	//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	if ( !bRestore && ( template_get_origin_path_type(strFullName) == ORIGIN_PATH_SYSTEM || template_get_origin_path_type(strFullName) == ORIGIN_PATH_GROUP ) )
	{
		MessageBox(m_hwnd, _L("Cannot add template from System Folder or Group Folder"), _L("Attention!"), MB_OK);
		return trNewTemp;
	}
	//------
	
	///Jasmine 09/27/06 MECHANISM_CHANGE
	//StringArray strTokens;
	//strFullName.GetTokens(strTokens, '\\') ;
	//string strTempNameExt = strTokens[strTokens.GetSize()-1];
	//string strTempName = GetFileName(strFullName, true);//strTempNameExt.GetToken(0,'.');
	
	//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
	//string strTempName = okutil_composite_name_from_file_path(strFullName, "Templates");	///Jasmine 07/30/07 #8854 SHOW_TEMPLATE_UNDER_GROUP_FOLDER	
	string strTemplate = GetFileName(strFullName, true);
	//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	//string strTempName = okutil_xft_GetFunctionNameStr(strTemplate, ORIGIN_PATH_USER);
	
	//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	//string strTempName = okutil_xft_GetFunctionNameStr(strTemplate, bRestore ? ORIGIN_PATH_SYSTEM : ORIGIN_PATH_USER);
	string strTempName = template_composite_name_from_file_path(strFullName, "Templates");
	//------
	
	//------ End FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	char szFileName[100];
	char szExt[20];
	lstrcat(szFileName, strFullName);
	check_add_file_ext(szFileName, NULL, szExt);
	//------ End COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
	
	//check if already exist
	string strExistPath;
	string strExistCate;// = checkExist(strTempName, trCate, true, &strExistPath);
	TreeNode trOld = checkExist(strTempName, trCate, true, &strExistPath, &strExistCate);	
	if(!strExistCate.IsEmpty())
	{
		/*
		string strWarning ="Template "+ strTempNameExt +" already exist in Category "+ strExistCate;
		MessageBox(NULL, strWarning, "Error!", MB_OK | MB_ICONSTOP);
		trNewTemp.Remove();
		return trNewTemp;
		*/
		string strMsg1, strMsg2;
		if(strFullName.CompareNoCase(strExistPath))
		{
			//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
			/*
			//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
			//string strWarning = "Fail to add "+ strFullName + "\nTemplate name "+ strTempName + " is used by "+ strExistPath;
			//MessageBox(NULL, strWarning, "Name used", MB_OK|MB_ICONEXCLAMATION);
			//trNewTemp.Remove();
			//return trNewTemp;			
			//strMsg1.Format(_L("used by %s"), strExistPath);
			//strMsg2.Format(_L("replace it by %s"), strFullName);
			
			string strWarning;
			string strTmpPath, strTmpCate;
			while (checkExist(strTempName, trCate, true, &strTmpPath, &strTmpCate))
			{
				strWarning.Format(_L("The template name \"%s\" is used by another template."), strTemplate);
				GETN_TREE(trRename)
				GETN_STR(Warn, "", strWarning)	GETN_READ_ONLY_COLOR
				GETN_STR(Name, _L("Template Name"), strTemplate)
				if(!GetNBox(trRename, _L("Rename")))//, strWarning, NULL, NULL, NULL))
					return trNewTemp;
				strTemplate = trRename.Name.strVal;
				strTempName = okutil_xft_GetFunctionNameStr(strTemplate, ORIGIN_PATH_USER);
			}
			//------ End COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
			*/
			string strWarning;
			strWarning.Format(_L("File Path of %s in Template Library will be changed, continue ?"), strTempName);
			if(IDNO == MessageBox(m_hwnd, strWarning, _L("Attention!"), MB_YESNO | MB_DEFBUTTON2 | MB_ICONEXCLAMATION))
			{
				//trNewTemp.Remove();
				return trNewTemp;				
			}
			if(trOld)
				trOld.Remove();
			if(pstrName)
				*pstrName = strTempName;
			//------ End SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF			
		}
		//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
		else
		{
		//------ End COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE	
		string strCate;
		trCate.GetAttribute(STR_LABEL_ATTRIB, strCate);	
		if(!lstrlen(strCate))
			strCate = trCate.tagName;
		if(!strCate.CompareNoCase(strExistCate) && strMsg1.IsEmpty())
		{
			//trNewTemp.Remove();
			return trNewTemp;
		}
		if(strCate.CompareNoCase(strExistCate))
		{
			string strWarn1, strWarn2;
			strWarn1.Format(_L("in Category %s"), strExistCate);
			strWarn2.Format(_L("move it to Category %s"), strCate);
			if(!strMsg1.IsEmpty())
				strWarn1 = " " + strWarn1;
			strMsg1 += strWarn1;
			if(!strMsg2.IsEmpty())
				strWarn2 = " " + _L("and") + " " + strWarn2;
			strMsg2 += strWarn2;
		}
		if(!strMsg1.IsEmpty())
		{
			string strWarning;
			strWarning.Format(_L("%s is %s.\nDo you want to %s?"), strTempName, strMsg1, strMsg2);
			if(IDNO == MessageBox(m_hwnd, strWarning, _L("Attention!"), MB_YESNO | MB_DEFBUTTON2 | MB_ICONEXCLAMATION))
			{
				//trNewTemp.Remove();
				return trNewTemp;				
			}
			if(trOld)
				trOld.Remove();
			if(pstrName)
				*pstrName = strTempName;
		}
		
		}		//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
	}
///End ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
	///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
	/* 
	//copy file to user folder...
	if(strFullName.CompareNoCase(STR_USER_PATH + strTempNameExt))			
	{
		string strFile = STR_USER_PATH + strTempNameExt;
		if(strFile.IsFile())
		{
			string strWarning = strFile +" is already in user folder. Would you like to replace the existing file?";
			if(IDNO == MessageBox(NULL, strWarning, "Attention!", MB_YESNO | MB_DEFBUTTON2 | MB_ICONEXCLAMATION))
			{
				trNewTemp.Remove();
				return trNewTemp;
			}
		}
		bool flag = CopyFile(strFullName, STR_USER_PATH + strTempNameExt);
	}
	*/
	///End SAVE_FULL_PATH
	///Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
	//check if in DeletedSystemFile
	//------ Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
	//TreeNode trDelBranch = trCate.Parent().Parent().FindNodeByAttribute(STR_LABEL_ATTRIB, STR_DELETE_SECTION);
	TreeNode trDelBranch = tree_get_node_by_tagname(trCate.Parent().Parent(), STR_DELETE_SECTION_TAGNAME, true);
	//------ End LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
	//strExistCate = checkExist(GetFileName(strFullName), trDelBranch, false);
	checkExist(GetFileName(strFullName), trDelBranch, false, NULL, &strExistCate);///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
	if(!strExistCate.IsEmpty())
		moveFromDel(GetFileName(strFullName), trDelBranch);
	///End BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
	///End MECHANISM_CHANGE
	//trNewTemp = treeAddTempNode(trCate, strTempName, strTempName);///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
	
	//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
	//trNewTemp = treeAddTempNode(trCate, strTempName, strFullName);
	//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	/*
	string strDesPath = okutil_get_origin_path(bRestore ? ORIGIN_PATH_SYSTEM : ORIGIN_PATH_USER, NULL, TRUE) + strTemplate + '.' + szExt;
	if (strDesPath.CompareNoCase(strFullName))
	{
		if(strDesPath.IsFile())
		{
			string strWarning;
			ocu_load_msg_str(XFWARN_TEMPLATE_ALREADY_EXISTS, &strWarning, strDesPath);
			if(IDNO == MessageBox(NULL, strWarning, "Save As", MB_YESNO|MB_ICONEXCLAMATION))
				return trNewTemp;
		}
		CopyFile(strFullName, strDesPath);
		string strExt = szExt;
		if (strExt.CompareNoCase("OTP") == 0)
		{
			string strPicture = get_graph_template_preview_file(strFullName);
			lstrcat(szFileName, strPicture);
			check_add_file_ext(szFileName, NULL, szExt);
			string strDesPicture = GetFilePath(strDesPath) + strTemplate + '.' + szExt;
			
			if (strDesPicture.CompareNoCase(strPicture))
				CopyFile(strPicture, strDesPicture);
		}
	}
	trNewTemp = treeAddTempNode(trCate, strTempName, strDesPath);
	*/
	trNewTemp = treeAddTempNode(trCate, strTempName, strFullName);
	//------ End SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	
	//------ End COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE
	
	return trNewTemp;
}
TreeNode TemplateOrganizer::DelCateOrTemp(TreeNode &trParent, TreeNode &trDel)
{
	///Jasmine 09/27/06 MECHANISM_CHANGE
	bool flag;
	TreeNode trSysTemp;
	string strFileName;
	if(TP_LEVEL_TEMPLATE == tree_get_level(trDel))
	{
		//string strFileName, strPath;
		///Jasmine 12/23/05 remove category or template from TemplateOrganizer without deleting files
		//flag = trDel.GetAttribute(STR_LABEL_ATTRIB, strFileName);
		//strPath = STR_USER_PATH + strFileName +"."+ GetTemplateExt();
		//if(strPath.IsFile())//user file
			//DeleteFile(strPath);
		//else 
		/*
		flag = trDel.GetAttribute(STR_FILENAME_ATTRIB, strPath);
		
		if(-1 < strPath.Find(STR_SYSTEM_PATH))//system file
		{
			//strPath = STR_SYSTEM_PATH + strFileName +"."+ GetTemplateExt();
		///End
			if(strPath.IsFile())//system file
			{
		*/
		trDel.GetAttribute(STR_FILENAME_ATTRIB, strFileName);
		///Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
		/*
		strPath = GetFilePath(strFileName);
		if(!strPath.CompareNoCase(STR_SYSTEM_PATH))//system file
		*/
		if(is_built_in_template(m_nType, GetFileName(strFileName, true), strFileName))
		///End BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
		{
			if(strFileName.IsFile())
			{
				//TreeNode trDelBranch = trParent.Parent().Parent().FindNodeByAttribute(STR_LABEL_ATTRIB, STR_DELETE_SECTION);
				trSysTemp = trDel;
				//flag = trDelBranch.AddNode(trSysTemp, FALSE);
			}
		}
	}
	flag = trParent.RemoveChild(trDel);
	
		//string strTemplate;
		//trDel.GetAttribute(STR_LABEL_ATTRIB, strTemplate);
		
		///End
	TreeNode tr;
	if(trSysTemp)//find the same name template
	{
		///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
		string strTemplate, strCate;
		trParent.GetAttribute(STR_LABEL_ATTRIB, strCate);
		if(!lstrlen(strCate))
			strCate = trParent.tagName;
		trSysTemp.GetAttribute(STR_LABEL_ATTRIB, strTemplate);
		//------ Folger 01/10/08 FIX_BUGS_WHEN_CATEGORY_AND_TEMPLATE_HAVE_THE_SAME_NAME
		//if(trParent.Parent() && !trParent.Parent().FindNodeByAttribute(STR_LABEL_ATTRIB, strTemplate))
		TreeNode trNode;
		if( trParent.Parent() &&
			(!(trNode = trParent.Parent().FindNodeByAttribute(STR_LABEL_ATTRIB, strTemplate)) ||
			tree_get_level(trNode) < TP_LEVEL_TEMPLATE) )
		//-----
		{	//add to trDelBranch
			tr = trSysTemp;
			///Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
			tr.SetAttribute(STR_LABEL_ATTRIB, GetFileName(strFileName));//in DelSection, show name with extension 
			tr.SetAttribute(STR_CHANGED_ATTRIB, strCate);
			tr.SetAttribute(STR_USER_PATH_ATTRIB, 1);			//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
		///End RESTORE_DEL_TEMPLATE
			//------ Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
			//TreeNode trDelBranch = trParent.Parent().Parent().FindNodeByAttribute(STR_LABEL_ATTRIB, STR_DELETE_SECTION);
			TreeNode trDelBranch = tree_get_node_by_tagname(trParent.Parent().Parent(), STR_DELETE_SECTION_TAGNAME, true);
			//------ End LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
			trDelBranch.AddNode(tr, FALSE);
			///End BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER
		}
	}
	return tr;
	///End MECHANISM_CHANGE
}
int TemplateOrganizer::GetMultiOpenBox(vector<string>& vsFilePaths, LPCSTR lpcszPath) //=NULL
{
	string strExt = "*." + GetTemplateExt();
	
	return GetMultiOpenBox(vsFilePaths, strExt, lpcszPath);
}
///Jasmine 12/26/05 DBCLICK_RENAME
bool TemplateOrganizer::CategoryRename(TreeNode& tr, string strName)
{
	TreeNode trParent = tr.Parent();
	string strExist;// = checkExist(strName, trParent, false);
	checkExist(strName, trParent, false, NULL, &strExist);///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
	if(!strExist.IsEmpty())
		return false;
	return tr.SetAttribute(STR_LABEL_ATTRIB, strName);
}

//------ Folger 08/24/07 FIND_TEMPLATE_AND_CATEGORY_IN_M_TRTP
bool TemplateOrganizer::FindTemplate(const TreeNode &tr, string strTemplate, TreeNode &trTemplate, TreeNode &trCategory)
{
	if(!tr)
		return false;
	//------ Folger 10/10/07 CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE
	//trTemplate = tr.FindNodeByAttribute(STR_LABEL_ATTRIB, strTemplate);
	//
	//if (!trTemplate.IsValid())
		//return false;
	//if (trCategory != NULL)
	//{
		//trCategory = trTemplate.Parent();
		//if (!trCategory.IsValid())
			//return false;
	//}
	//return true;
	
	foreach (TreeNode trCate in tr.Children)
	{
		TreeNode trTemp = trCate.FindNodeByAttribute(STR_LABEL_ATTRIB, strTemplate);
		if (trTemp)
		{
			trTemplate = trTemp;
			///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
			//trCategory = trCate;
			if(trCategory.IsValid())
				trCategory = trCate;
			///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
			return true;
		}
	}
	return false;
	//------ End CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE
}
//------ End FIND_TEMPLATE_AND_CATEGORY_IN_M_TRTP

//------ Folger 10/10/07 CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE
bool TemplateOrganizer::FindCategory(const TreeNode &tr, string strCategory, TreeNode &trCategory)
{
	foreach (TreeNode trCate in tr.Children)
	{
		string strCate;
		trCate.GetAttribute(STR_LABEL_ATTRIB, strCate);
		if (strCate.CompareNoCase(strCategory) == 0)
		{
			trCategory = trCate;
			return true;
		}
	}
	return false;
}
//------ End CORRECT_BEHAVIOR_OF_FINDING_CATEGORY_AND_TEMPLATE

///End
///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
/*
void TemplateOrganizer::addNodeFromTempFiles(TreeNode& trCate)
{
	StringArray saUserFile;//filename with extension     
	string strType = GetTemplateExt(), strTempName;
	
	//get file from user folder
	getTemplateFile(saUserFile, strType, true);
	for(int ii = 0; ii < saUserFile.GetSize(); ii++ )
	{
		if(saUserFile[ii].IsEmpty())continue;
		strTempName = saUserFile[ii].GetToken(0,'.');
		//treeAddTempNode(trCate , strTempName, strTempName);	///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
		treeAddTempNode(trCate , strTempName, STR_USER_PATH + saUserFile[ii]);
	}
		
	//get file from system folder
	StringArray saSystemFile;
	getTemplateFile(saSystemFile, strType, false);
	//compare with user files, remove if exist
	for(ii = 0; ii < saSystemFile.GetSize(); ii++ )
	{
		for(int nn = 0; nn < saUserFile.GetSize(); nn++)
		{
			if(!saSystemFile[ii].CompareNoCase(saUserFile[nn]))
			{
				saSystemFile[ii].Empty();
				break;
			}
		}
	}
	for(ii = 0; ii < saSystemFile.GetSize(); ii++ )
	{
		if(saSystemFile[ii].IsEmpty())continue;
		strTempName = saSystemFile[ii].GetToken(0,'.');
		//treeAddTempNode(trCate, strTempName, strTempName); ///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
		treeAddTempNode(trCate, strTempName, STR_SYSTEM_PATH + saSystemFile[ii]);
	}
}
*/
TreeNode TemplateOrganizer::treeAddCateNode(TreeNode& trParent, string& strCateName)
{
	string strCateNode = tree_get_enum_node_name(trParent, STR_CATEGORY_NODE);//STR_BRANCH_NODE);	///Jasmine 02/05/06 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE
	TreeNode trCate = trParent.AddNode(strCateNode, TRGP_BRANCH);
	if(strCateName.IsEmpty())
		strCateName = tree_get_enum_attribute_value(trParent, STR_LABEL_ATTRIB, STR_NEW_CATEGORY_PREFIX);
	
	trCate.SetAttribute(STR_USER_PATH_ATTRIB, 1);		//------ Folger 07/02/08 QA80-10951-P4 KEEP_EMPTY_CATEGORY_IN_TEMPLATE_ORGANIZER
	
	bool flag = trCate.SetAttribute(STR_LABEL_ATTRIB, strCateName);
	return trCate;
}
TreeNode TemplateOrganizer::treeAddTempNode(TreeNode& trParent, string strTempName, string strFileName)
{
	///---Sim 05-20-2009 QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC
	/*
	string strTempNode = tree_get_enum_node_name(trParent, STR_TEMPLATE_NODE);
	TreeNode trTemplate = trParent.AddNode(strTempNode, ONODETYPE_TREE_NODE);
	bool flag = trTemplate.SetAttribute(STR_LABEL_ATTRIB, strTempName);
	flag = trTemplate.SetAttribute(STR_FILENAME_ATTRIB, strFileName);
	
	//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	//flag = trTemplate.SetAttribute(STR_NAME_ATTRIB, GetFileName(strFileName));		//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
	flag = trTemplate.SetAttribute(STR_NAME_ATTRIB, template_get_origin_path_type(strFileName) == ORIGIN_PATH_UNDEF ? strFileName : GetFileName(strFileName));
	//------
	
	//------ Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	string strPath = GetFilePath(strFileName);
	
	//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	//if (strPath.CompareNoCase(okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE)) == 0)
	if ( template_get_origin_path_type(strPath) == ORIGIN_PATH_USER || template_get_origin_path_type(strPath) == ORIGIN_PATH_UNDEF )
	//------
		trTemplate.SetAttribute(STR_USER_PATH_ATTRIB, 1);
	//------ End COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	return trTemplate;
	*/
	TreeNode trNode;
	okutil_add_template_node(&trNode, &trParent, strTempName, strFileName);
	return trNode;
	///---END QA80-13612 MOVE_TEMPLATE_UTILS_FROM_OC_TO_VC
}

///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
string		TemplateOrganizer::NoPreviewPicture()
{
	return GetFullPath(STR_PICT_NO_PREVIEW ".emf", "Templates\\Previews", TRUE);
}
///------ End NO_PREVIEW_EMF_LOCALIZATION

///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
/*
void TemplateOrganizer::getTemplateFile(StringArray& saFile, string strType, bool bUser)
{	
	int nPath;
	if(bUser)
	    nPath = ORIGIN_PATH_USER;
	else
	    nPath = ORIGIN_PATH_SYSTEM;
	
	FindFiles(saFile, okutil_get_origin_path(nPath , NULL, TRUE), strType);
	saFile.Sort(SORT_ASCENDING);	
}
*/
///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
///Jasmine 09/27/06 MECHANISM_CHANGE
//string TemplateOrganizer::checkExist(string strName, TreeNode& trParent, bool bCheckAll)
//string TemplateOrganizer::checkExist(string strName, TreeNode& trParent, bool bTemplate, string* pstrFile)//true, NULL
TreeNode TemplateOrganizer::checkExist(string strName, TreeNode& trParent, bool bTemplate, string* pstrFile, string* pstrCate)//true, NULL, NULL
{
	/*
	bool flag;
	string strCate;
	TreeNode tr = trParent;
	//if strName = Category3,4,5..., usually, the tr already exists, as the treenode's tagname is Category1,2 ... 
	if(tr.FindNodeByAttribute(STR_LABEL_ATTRIB, strName).IsValid() || tr.GetNode(strName).IsValid())
	{
		flag = tr.GetAttribute(STR_LABEL_ATTRIB, strCate);			
		if(!lstrlen(strCate))
			strCate = tr.tagName;
	}
	else if(bCheckAll)
	{
		TreeNode trGrandParent = trParent.Parent();
		tr = trGrandParent.FirstNode;
		for( ; tr; tr = tr.NextNode)
		{
			if(tr.FindNodeByAttribute(STR_LABEL_ATTRIB, strName).IsValid() || tr.GetNode(strName).IsValid())
			{
				flag = tr.GetAttribute(STR_LABEL_ATTRIB, strCate);
				if(!lstrlen(strCate))
					strCate = tr.tagName;
				break;
			}
		}
	}*/
	string strFile, strCate;
	TreeNode tr = trParent.FindNodeByAttribute(STR_LABEL_ATTRIB, strName);	
	if(!bTemplate)
	{
		if(!tr)
			tr = trParent.GetNode(strName);
		if(tr)
		{
			tr.GetAttribute(STR_LABEL_ATTRIB, strCate);			
			if(!lstrlen(strCate))
				strCate = tr.tagName;
			if(pstrCate)
				*pstrCate = strCate;
		}
		//return strCate;
		return tr;
	}
	if(!tr.IsValid())
	{
		TreeNode trBranch = trParent.Parent();
		if(trBranch.IsValid())
		//------ Folger 01/10/08 FIX_BUGS_WHEN_CATEGORY_AND_TEMPLATE_HAVE_THE_SAME_NAME
			//tr = trBranch.FindNodeByAttribute(STR_LABEL_ATTRIB, strName);
		{
			TreeNode trCate;
			FindTemplate(trBranch, strName, tr, trCate);
		}
		//------
	}
	if(tr.IsValid() && tr.Parent().IsValid())
	{
		tr.GetAttribute(STR_FILENAME_ATTRIB, strFile);
		//tr = tr.Parent();
		//tr.GetAttribute(STR_LABEL_ATTRIB, strCate);
		tr.Parent().GetAttribute(STR_LABEL_ATTRIB, strCate);
		if(!lstrlen(strCate))
			strCate = tr.tagName;
		if(pstrFile)
			*pstrFile = strFile;
		if(pstrCate)
			*pstrCate = strCate;
	}	
	///End MECHANISM_CHANGE
	//return strCate;
	return tr;
}
///End ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
void TemplateOrganizer::moveFromDel(string strDel, TreeNode& trDelBranch)
{
	TreeNode trDel = trDelBranch.FindNodeByAttribute(STR_LABEL_ATTRIB, strDel);
	trDelBranch.RemoveChild(trDel);	
}
///Jasmine 08/17/06 CLEAN_UP_CODE
BOOL TemplateOrganizer::loadImage(PictureControl& picCtrl, LPCSTR lpcszPict)
{
	string strImage(lpcszPict);
	/// Sophy 5/12/2008 QA80-11457-P1 FIX_TEMPLATE_PREVIEW_NOT_SHOWN_UNDER_PATH_CONTAINING_DOT
	//string strExt = strImage.GetToken(1,'.');
	string strExt;
	if( !separate_file_name_ext(lpcszPict, NULL, &strExt) )
		return FALSE;	//Extention name not exists
	/// End FIX_TEMPLATE_PREVIEW_NOT_SHOWN_UNDER_PATH_CONTAINING_DOT
	BOOL bRet = FALSE;  //Picture not loaded initially
 	if(!strExt.CompareNoCase("EMF"))
	{
		HENHMETAFILE henhmf1 = load_enhanced_metafile(lpcszPict);
		bRet = picCtrl.SetEnhMetaFile(henhmf1);
	}
	if(!strExt.CompareNoCase("BMP"))
	{
		///Jasmine 08/22/06 BMP_NO_STRETCH 
		//PictureHolder phDst;
		//phDst.Load(lpcszPict);
		//bRet = picCtrl.SetPicture(phDst);
		HDIB	hDIB = load_dib(lpcszPict);
		HBITMAP hBMP = DDB_from_DIB(hDIB);
		bRet = picCtrl.SetBitMap(hBMP);
		///End BMP_NO_STRETCH
	}
	return bRet;	
}
//------ Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
bool TemplateOrganizer::constructXMLTree(TreeNode &trXML, const TreeNode &trPart, int nPath)
{
	string strPath = okutil_get_origin_path(nPath, NULL, TRUE);
	vector<int>  vnType = { EXIST_GRAPH, EXIST_WKS, EXIST_MATRIX};
	for(int ii = 0; ii < vnType.GetSize(); ii++)
	{
		//------ Folger 12/05/07 SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
		/*
		vector<string> vsFiles;
		FindFiles(vsFiles, strPath, page_get_template_ext(vnType[ii]));
		int nSize = vsFiles.GetSize();
		
		for (int jj=0; jj<nSize; jj++)
		{
			string strCategory;
			string strFile = strPath + vsFiles[jj];
			string strTemplate = GetFileName(vsFiles[jj], TRUE);
			strTemplate = okutil_xft_GetFunctionNameStr(strTemplate, nPath);
			
			TreeNode trBH = tree_get_node_by_id(trXML, vnType[ii]);
			TreeNode trBranch = tree_get_node_by_id(trPart, vnType[ii]);
			
			TreeNode trTemplate = trBranch.FindNodeByAttribute(STR_LABEL_ATTRIB, strTemplate);
			if(!trTemplate)
				continue;
			
			trTemplate.Parent().GetAttribute(STR_LABEL_ATTRIB, strCategory);				
			TreeNode trCategory = trBH.FindNodeByAttribute(STR_LABEL_ATTRIB, strCategory);
			if(!trCategory)
				trCategory = treeAddCateNode(trBH, strCategory);
			treeAddTempNode(trCategory, strTemplate, strFile);
		}
		*/
		TreeNode trBH = tree_get_node_by_id(trXML, vnType[ii]);
		TreeNode trBranch = tree_get_node_by_id(trPart, vnType[ii]);
		foreach ( TreeNode trCate in trBranch.Children )
		{
			string strCategory;
			trCate.GetAttribute(STR_LABEL_ATTRIB, strCategory);
			
			//------ Folger 07/02/08 QA80-10951-P4 KEEP_EMPTY_CATEGORY_IN_TEMPLATE_ORGANIZER
			TreeNode trCategory = trBH.FindNodeByAttribute(STR_LABEL_ATTRIB, strCategory);
			if (!trCategory)
				trCategory = treeAddCateNode(trBH, strCategory);
			//------
			
			foreach ( TreeNode trTemp in trCate.Children )
			{			
				string strTemplate, strFile;
				trTemp.GetAttribute(STR_LABEL_ATTRIB, strTemplate);
				trTemp.GetAttribute(STR_FILENAME_ATTRIB, strFile);
				treeAddTempNode(trCategory, strTemplate, strFile);		
			}
		}
		//------ End SHOULD_NOT_COPY_UNKNOWN_TEMPLATE_FILE_TO_UFF
	}
	
	return true;
}
//------ End COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML

//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
bool TemplateOrganizer::removeDeleteFileFromXML(TreeNode &trXML, const TreeNode &trUser)
{
	TreeNode trDeleteUser = tree_get_node_by_tagname(trUser, STR_DELETE_SECTION_TAGNAME, true);
	TreeNode trDeleteXML = tree_get_node_by_tagname(trXML, STR_DELETE_SECTION_TAGNAME, true);
	if (trDeleteUser)
	{
		foreach(TreeNode trNode in trDeleteUser.Children)
		{
			string strName;
			trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
			TreeNode trTmp = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, strName);
			if (trTmp)
			{
				trTmp.Remove();
				trNode.SetAttribute(STR_USER_PATH_ATTRIB, 1);	//------ Folger 01/10/08 FIX_BUGS_WHEN_CATEGORY_AND_TEMPLATE_HAVE_THE_SAME_NAME
				trDeleteXML.AddNode(trNode);
			}
		}
	}
	return true;
}
//------ End FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE

///Jasmine 10/10/2012 ORG-7074-S1 SEPARATE_BUILT_IN_OPENGL_TMPLATE
void TemplateOrganizer::filterOpenGLTemplate(TreeNode& trXML)
{
	TreeNode trGraphBranch = trXML.branchGraph;
	if(!trGraphBranch)
		return;
	
	bool	bOGL = is_OGL();
	vector<string> vsLabels, vsOpenGLLabels;
	tree_get_attributes(trGraphBranch, vsLabels, STR_LABEL_ATTRIB, false);	
	int 	nOpenGLCount = okutil_find_strings(&vsOpenGLLabels, &vsLabels, "gl", OFS_MATCH_START_STRING);	
	for(int ii = 0; ii < nOpenGLCount; ii++)
	{
		string strLabel = vsOpenGLLabels[ii];
		if(bOGL)
			strLabel.Delete(0, 2);
		
		TreeNode trFind = trGraphBranch.FindNodeByAttribute(STR_LABEL_ATTRIB, strLabel);
		if(trFind)
			trFind.Show = 0;
	}
	
	tree_remove_children_by_attrib(trGraphBranch, STR_SHOW_ATTRIB, 0);
}
///End SEPARATE_BUILT_IN_OPENGL_TMPLATE

///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
TreeNode TemplateOrganizer::ScanUserTemplates(TreeNode &trXML)
{
	TreeNode trCategory;
	if(!trXML)
		return trCategory;
	TreeNode trBranchGraph = tree_get_node_by_id(trXML, m_nType);
	if(!trBranchGraph)
		return trCategory;

	string strExt = GetTemplateExt();
	string strPath = okutil_get_origin_path(ORIGIN_PATH_USER);
	vector<string> vsFiles;
	if(!FindFiles(vsFiles, strPath, strExt) || vsFiles.GetSize() <= 0)
		return trCategory;

	string strCategory = STR_UDL_PREFIX;
	
	if(!FindCategory(trBranchGraph, strCategory, trCategory))
		trCategory = treeAddCateNode(trBranchGraph, strCategory);

	for(int ii=vsFiles.GetSize()-1; ii>=0; ii--)
	{
		string 	strFileName = strPath + vsFiles[ii],
				strTempName = okutil_composite_name_from_file_path(strFileName, "Templates");
		TreeNode trTemplate;
		if(!FindTemplate(trBranchGraph, strTempName, trTemplate))
			trTemplate = treeAddTempNode(trCategory, strTempName, strFileName);
	}

	return trCategory;
}
///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE


/////////////////////////////////////////////////////////////////////////////
////////////////////////////	GraphTemplate	/////////////////////////
/////////////////////////////////////////////////////////////////////////////

BOOL GraphTemplate::LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl)
{
	string strSystem = "Templates\\Previews\\";	//system template previews
	string strPath 		= GetFilePath(lpcszTemplate);
	string strNameOnly 	= GetFileName(lpcszTemplate, true);
	string strEMF 		= strPath + strNameOnly + ".emf";
	string strBMP 		= strPath + strNameOnly + ".bmp";
	string strPicture;
	//look for existing file first
	if(strEMF.IsFile() || strBMP.IsFile())
		//------ Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
		//strPicture = file_modified_time_compare(strEMF, strBMP)? strEMF : strBMP;
		strPicture = file_last_modified_time_compare(strBMP, strEMF) > 0 ? strBMP : strEMF;
		//------ End USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
	else
	{
		strEMF = strPath + strSystem + strNameOnly + ".emf";
		strBMP = strPath + strSystem + strNameOnly + ".bmp";
		if(strEMF.IsFile() || strBMP.IsFile())
			//------ Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
			//strPicture = file_modified_time_compare(strEMF, strBMP)? strEMF : strBMP;
			strPicture = file_last_modified_time_compare(strBMP, strEMF) > 0 ? strBMP : strEMF;
			//------ End USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
	}
	///Jasmine 09/27/06 MECHANISM_CHANGE
	//don't make preview here. User can make preview  by template_saveas
	/*
	if( !strPicture.IsFile() &&	_extract_template_to_image(lpcszTemplate, strEMF) )
		strPicture = strEMF;
	*/
	///Sophy 04/03/2008 RESTORE_PREVIEW_IMAGE_IN_CASE_FILE_DELETED
	if( !strPicture.IsFile() &&	extract_template_to_image(lpcszTemplate, strEMF) )
		strPicture = strEMF;
	///End RESTORE_PREVIEW_IMAGE_IN_CASE_FILE_DELETED
	if( loadImage(picCtrl, strPicture) )
	{
		/// Sophy 5/12/2008 QA80-11457-P1 FIX_TEMPLATE_PREVIEW_NOT_SHOWN_UNDER_PATH_CONTAINING_DOT
		//picCtrl.DrawMode = strPicture.GetToken(1, '.').CompareNoCase("emf")? PCDM_NO_STRETCH : PCDM_STRETCH_KEEP_ASPECT_RATIO;
		string strExt;
		separate_file_name_ext(strPicture, NULL, &strExt );
		picCtrl.DrawMode = strExt.CompareNoCase("emf")? PCDM_NO_STRETCH : PCDM_STRETCH_KEEP_ASPECT_RATIO;
		/// End FIX_TEMPLATE_PREVIEW_NOT_SHOWN_UNDER_PATH_CONTAINING_DOT
		return TRUE;//load an existing emf/bmp or the newly created emf
	}
	
	//if(!_extract_template_to_image(lpcszTemplate, strBMP) || !loadImage(picCtrl, strBMP) )
	///Jake 07/11/07 FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH
	//if(!loadImage(picCtrl, strBMP) )
	///Jake 07/13/07 FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH_ONECE_MORE
	/*
	if(!loadImage(picCtrl, strBMP) || strPicture.IsEmpty())
	*/
	if(!strBMP.IsFile() || !loadImage(picCtrl, strBMP) )
	///end FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH_ONECE_MORE
	///end FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH
	///End MECHANISM_CHANGE
	{
		///Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
		//strPicture = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".bmp";
		///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
		//strPicture = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".emf";
		strPicture = NoPreviewPicture();
		///------ End NO_PREVIEW_EMF_LOCALIZATION
		///end LOAD_NEW_IMAGE_FOR_NO_PREVIEW
		picCtrl.DrawMode = PCDM_STRETCH_FILL;
		return loadImage(picCtrl, strPicture);//load the No Preview pict or fail
	}
	picCtrl.DrawMode = PCDM_NO_STRETCH;
	///End MECHANISM_CHANGE
	return TRUE;//load the newly created bmp
}
///End CLEAN_UP_CODE

///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
/////Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
////virtual
//TreeNode GraphTemplate::ScanUserTemplates(TreeNode &trXML)
//{
	//TreeNode trCategory;
	//if(!trXML)
		//return trCategory;
	//TreeNode trBranchGraph = tree_get_node_by_id(trXML, EXIST_GRAPH);
	//if(!trBranchGraph)
		//return trCategory;
//
	//string strExt = GetTemplateExt();
	//string strPath = okutil_get_origin_path(ORIGIN_PATH_USER);
	//vector<string> vsFiles;
	//if(!FindFiles(vsFiles, strPath, strExt) || vsFiles.GetSize() <= 0)
		//return trCategory;
//
	//string strCategory = STR_UDL_PREFIX;
	//
	//if(!FindCategory(trBranchGraph, strCategory, trCategory))
		//trCategory = treeAddCateNode(trBranchGraph, strCategory);
//
	//for(int ii=vsFiles.GetSize()-1; ii>=0; ii--)
	//{
		//string 	strFileName = strPath + vsFiles[ii],
				//strTempName = okutil_composite_name_from_file_path(strFileName, "Templates");
		//TreeNode trTemplate;
		//if(!FindTemplate(trBranchGraph, strTempName, trTemplate))
			//trTemplate = treeAddTempNode(trCategory, strTempName, strFileName);
	//}
//
	//return trCategory;
//}
/////End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE

///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
/*
void GraphTemplate::ConstructSubTree(TreeNode &tr)
{
	TreeNode trGraph, trCate, trTemplate;
	///Jasmine 12/19/05 COMPARE_INI_MODIFICATION_TIME_WITH_XML
	trGraph = tr.FindNodeByAttribute(STR_LABEL_ATTRIB,"Graph");
	if(trGraph.IsValid())
		trGraph.Reset(true);
	else
	{
		GETN_USE(tr)	
		GETN_BEGIN_BRANCH(branchGraph, "Graph")	
		GETN_CURRENT_SUBNODE.DataID=TP_TYPE_GRAPH;
		GETN_END_BRANCH(branchGraph)
		trGraph = tr.branchGraph;
	}
	///End COMPARE_INI_MODIFICATION_TIME_WITH_XML
	trGraph.DataID = TP_TYPE_GRAPH;
	//read ini file
	string strINIFilePath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE);
	strINIFilePath += "Template.ini" ;
	INIFile iniTemplate(strINIFilePath);	
	string strSection = "Categories";
	StringArray saSections;
	iniTemplate.GetKeyNames(saSections, strSection);
	
	//construct graph tree
	for( int iSection = 1; iSection < saSections.GetSize(); iSection++ )
	{
		string strCategory = iniTemplate.ReadString(strSection, saSections[iSection]);
		trCate = treeAddCateNode(trGraph, strCategory);
		
		StringArray saKeys;
		iniTemplate.GetKeyNames(saKeys, strCategory);
		for( int iKey = 0; iKey < saKeys.GetSize(); iKey++ )
			trTemplate = treeAddTempNode(trCate, saKeys[iKey], STR_SYSTEM_PATH + saKeys[iKey] + "." + GetTemplateExt());
		
	}
}
*/
/////////////////////////////////////////////////////////////////////////////
////////////////////////////	WorkbookTemplate	/////////////////////////
/////////////////////////////////////////////////////////////////////////////
//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
//Control& WorkbookTemplate::GetCtrl()
//{
	//return m_CtrlWorkbook;
//}
//void WorkbookTemplate::DestroyControl()
//{
//}
//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
BOOL WorkbookTemplate::LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl)
{
	///Jasmine 12/26/05 PICT_NO_PREVIEW	
	///Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	//string strPath = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".bmp";
	///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
	//string strPath = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".emf";
	string strPath = NoPreviewPicture();
	///------ End NO_PREVIEW_EMF_LOCALIZATION
	//PictureHolder phDst;
	///end LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	if(strPath.IsFile())
	{
		///Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
		/*
		phDst.Load(strPath);
		picCtrl.SetPicture(phDst);
		return true;
		*/
		picCtrl.DrawMode = PCDM_STRETCH_FILL;
		return loadImage(picCtrl, strPath);	
		///end LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	}
	///End
	return false;
}
///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
/*
void WorkbookTemplate::ConstructSubTree(TreeNode &tr)
{
	TreeNode trWorkbook, trCate;
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(branchWorkbook, "Workbook")
	GETN_CURRENT_SUBNODE.DataID=TP_TYPE_WORKBOOK;
	GETN_END_BRANCH(branchWorkbook)
	trWorkbook = tr.branchWorkbook;
	
	string strCate = "Category";
	trCate = treeAddCateNode(trWorkbook, strCate);
	
	//search .otw files both in user and system folder, add to tree
	addNodeFromTempFiles(trCate);
	
}
*/
/////////////////////////////////////////////////////////////////////////////
////////////////////////////	MatrixTemplate	/////////////////////////
/////////////////////////////////////////////////////////////////////////////
//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
//Control& MatrixTemplate::GetCtrl()
//{
	//return m_CtrlMatrix;
//}
//void MatrixTemplate::DestroyControl()
//{
	//m_CtrlMatrix.DetachPage();
	//
	//m_CtrlMatrix.SendMessage(WM_CLOSE);
	//while(m_CtrlMatrix)	//wait untill control be destroyed
	//{
		//;
	//}
//}
//------ End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
BOOL MatrixTemplate::LoadTemplate(LPCSTR lpcszTemplate, PictureControl& picCtrl)
{
	///Jasmine 12/26/05 PICT_NO_PREVIEW	
	///Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	//string strPath = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".bmp";
	///------ Folger 10/11/2011 ORG-3815-P11 NO_PREVIEW_EMF_LOCALIZATION
	//string strPath = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".emf";
	string strPath = NoPreviewPicture();
	///------ End NO_PREVIEW_EMF_LOCALIZATION
	///end LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	PictureHolder phDst;
	if(strPath.IsFile())
	{
		///Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
		/*
		phDst.Load(strPath);
		picCtrl.SetPicture(phDst);
		return true;
		*/
		picCtrl.DrawMode = PCDM_STRETCH_FILL;
		return loadImage(picCtrl, strPath);	
		///end LOAD_NEW_IMAGE_FOR_NO_PREVIEW
	}
	///End
	return false;
}
///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
/*
void MatrixTemplate::ConstructSubTree(TreeNode &tr)
{
	TreeNode trMatrix, trCate;
	GETN_USE(tr)
	GETN_BEGIN_BRANCH(branchMatrix, "Matrix")
	GETN_CURRENT_SUBNODE.DataID=TP_TYPE_MATRIX;
	GETN_END_BRANCH(branchMatrix)
	trMatrix = tr.branchMatrix;
	
	string strCate = "Category";
	trCate = treeAddCateNode(trMatrix, strCate);
	
	//search .otm files both in user and system folder, add to tree
	addNodeFromTempFiles(trCate);
	
}
*/
//--CPY 4/4/08 TEMPLATE_SAVE_BROKEN_DUE_TO_FUNC_NOT_FOUND
// I have take code directly as is from .c file written by ??? after unlinkable change from ///Sophy 04/03/2008 RESTORE_PREVIEW_IMAGE_IN_CASE_FILE_DELETED
bool TemplateOrganizer::extract_template_to_image(LPCSTR lpcszTemplate, LPCSTR lpcszImage)
{
	string strImage(lpcszImage);
	string strExt = strImage.GetToken(1,'.');
	
	int	nOption = CREATE_NO_REMOVE_TEMPLATEPICT;
	GraphPage grph;
	grph.Create(lpcszTemplate, nOption);
	GraphLayer lay = grph.Layers(0);
	GraphObject	grPict;
	grPict = lay.GraphObjects("Template" + strExt);
	BOOL bRet = FALSE;
	if(grPict.IsValid())
		bRet = grPict.ExtractImageToFile(lpcszImage);
	grph.Destroy();
	return bRet;
}
//--

#endif _TO_TEMPLATEORGANIZER_H_
