/*------------------------------------------------------------------------------*
 * File Name:TXdisplayDlgBase.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
//--------------------------------------------------------------------------
// You can include just this typical header file for most Origin built-in
// functions and classes and it takes a reasonable amount of time to compile, 
// This file include most of the other header files except the NAG header, which
// takes longer to compile NAG routines.
//--------------------------------------------------------------------------

#ifndef _TXDISPLAY_DLG_BASE_H
#define _TXDISPLAY_DLG_BASE_H
#include "TXdefines.h"



/**

*/
class TXDisplayDlgBase: public ResizeDialog
{
public:
	TXDisplayDlgBase() : ResizeDialog( IDD_TX_DISPLAY, "ODlg8" ){}
	int DoModalEx(HWND hParent)
	{ 
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hParent);
		if(IDOK == nRet)
		{
			return 1;
		}
		return 0;
	}	

	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = ResizeDialog::Create(hParent);
		
		return nRet;
	}

	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
EVENTS_END
	BOOL OnInitDialog()
	{	
		/// AW 11/01/05 MOVE_KEYBOARD_HANDLE_TO_CLASS
		//.m_hklCurrent = GetKeyboardLayout(); //CPY 10/18/05 TX_CONTROL_AUTO_SWITCH_KEYBOARD_LAYOUT
		/// END MOVE_KEYBOARD_HANDLE_TO_CLASS
		
		ResizeDialog::OnInitDialog(0, "TX Diaply dialog"); // ??str for reg remembering dialog pos etc info
		
		try 
		{
			Control TXTextControl;
			TXTextControl = GetItem(IDC_TX1);
			
			if(TXTextControl)
				m_txText = TXTextControl.GetActiveXControl();
		}
		catch (int nErr)
		{
			return error_report("Fail to init TX control");
		}
		
		return true;
	}
	virtual BOOL OnReady()
	{
		/// AW 11/01/05 MOVE_KEYBOARD_HANDLE_TO_CLASS
		//ActivateKeyboardLayout(m_hklCurrent); //CPY 10/18/05 TX_CONTROL_AUTO_SWITCH_KEYBOARD_LAYOUT
		m_myKeyboard.RestoreKeyboard();
		/// END MOVE_KEYBOARD_HANDLE_TO_CLASS
		return true;
	}
	BOOL OnDestroy(void)
	{
		ResizeDialog::OnDestroy();
		/// AW 11/01/05 MOVE_KEYBOARD_HANDLE_TO_CLASS
		//ActivateKeyboardLayout(m_hklCurrent); //CPY 10/18/05 TX_CONTROL_AUTO_SWITCH_KEYBOARD_LAYOUT
		m_myKeyboard.RestoreKeyboard();
		/// END MOVE_KEYBOARD_HANDLE_TO_CLASS
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
	
		PositionControl(IDC_TX1,0,0);
		SizeControl(IDC_TX1, cx, cy);
		return TRUE;
	}
public:
	Object GetTxObj()
	{
		return m_txText;
	}

public:
protected:
	/// AW 11/01/05 MOVE_KEYBOARD_HANDLE_TO_CLASS
	//HKL				m_hklCurrent; //CPY 10/18/05 TX_CONTROL_AUTO_SWITCH_KEYBOARD_LAYOUT
	TXKeyboardHandle	m_myKeyboard;
	/// END MOVE_KEYBOARD_HANDLE_TO_CLASS
	Object			m_txText;	
};

#endif // _TXDISPLAY_DLG_BASE_H