#ifndef _TP_SPLITTER_H_
#define _TP_SPLITTER_H_

enum {
	TR_LEVEL_BRANCH   = 1,
	TR_LEVEL_CATEGORY,
	TR_LEVEL_TEMPLATE,
};

//#define STR_DELETE_SECTION		"DeletedSystemFile"		//------ Folger 11/07/07 LOCALIZE_DELETE_SYSTEM_FILE_BRANCH
///Jasmine 12/26/05 ADD_CONTEXT_MENU
enum {
	TP_MENU_NEW_CATEGORY, 
	//TP_MENU_RENAME, 
	TP_MENU_ADD_TEMPLATE,
	TP_MENU_DELETE,
	TP_MENU_MOVE,		//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
	TP_MENU_RESTORE,	///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
	TP_MENU_LAST_ITEM = 10000
};
//The context menu of TPSplitter
class TPMenu : public Menu
{
public:
	//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
	//TPMenu(int nLevel)
	///Jasmine 12/16/10 ORG-1730 DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
	//TPMenu(int nLevel, bool bMoveable = false)
	TPMenu(int nLevel, bool bMoveable = false, bool bUserTemplate = false)
	///End DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
	//------
	{
		m_nChoice = -1;	
		//Add(_L("New Category"), OnMenuItem,  MF_STRING | (TP_LEVEL_TEMPLATE > nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);///Jasmine 02/06/06 BLOCK_IN_DEL_SECTION
		Add(_L("New Category"), OnMenuItem,  MF_STRING | (TP_LEVEL_TEMPLATE > nLevel && 0 < nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		//Add(_L("Rename"), OnMenuItem,  MF_STRING | (TP_LEVEL_CATEGORY == nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		Add(_L("Add Template"), OnMenuItem,  MF_STRING | (TP_LEVEL_BRANCH < nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		
		///Jasmine 12/16/10 ORG-1730 DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
		//Add(_L("Delete"), OnMenuItem,  MF_STRING | (TP_LEVEL_BRANCH < nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		string strDeleteMenu = (TP_LEVEL_TEMPLATE == nLevel && !bUserTemplate)? _L("Remove from List") : _L("Delete");		
		Add(strDeleteMenu, OnMenuItem,  MF_STRING | (TP_LEVEL_BRANCH < nLevel)? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		///End DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
		
		//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
		Add(_L("Move"), OnMenuItem, MF_STRING | TP_LEVEL_TEMPLATE == nLevel && bMoveable ? MF_ENABLED : MF_DISABLED|MF_GRAYED);
		//------
		///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
		if(!nLevel)//in del section
			Add(_L("Restore"), OnMenuItem,  MF_STRING);	
		///End RESTORE_DEL_TEMPLATE
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= TP_MENU_NEW_CATEGORY && m_nChoice < TP_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}

private:
	int	m_nChoice;
};
///End ADD_CONTEXT_MENU

class GridTreeTemplateList : public GridTreeControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		m_nId = nID;
		GridTreeControl::Init(nID, dlg);

		m_flx.SelectionMode = flexSelectionByRow;
		//m_flx.AllowSelection = true;
		//m_flx.Editable = flexEDKbdMouse;	
		m_flx.Editable = flexEDNone;
		
	}
	
	bool IsReady()
	{
		return m_trList.IsValid();
	}
	
	void SetAllCollapsed()
	{
		int		nRow = m_flx.Rows;
		vector<byte>	vecCollapsed(nRow);
		vecCollapsed =1;
		SetCollapsed(vecCollapsed);
	}	
	void SetCollapsed(int nRow, int nState = flexOutlineCollapsed)
	{
		///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
		if(nRow < 0 || nRow >= m_flx.Rows)
			return;
		///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
		SetIsCollapsed(nRow, nState);
	}
	int GetCollapsed(int nRow){return GetIsCollapsed(nRow);}
	
	//void ShowTemplateList(const TreeNode& trFuncList)	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	void ShowTemplateList(const TreeNode& trFuncList, int nTemplateType = 0)
	{
		m_trList = trFuncList;
		m_flx.Rows=0;	//clear all
		if(m_trList.GetNodeCount()>0)
			//AddTreeNodes(m_trList, ATRN_STOP_LEVEL | 3);	///DG 8/18/05 simple tree
			AddTreeNodes(m_trList, 0, NULL, -1, NULL, true, 0);
			
		//showBranchOnly();	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
		int nRow = GetRow(STR_DELETE_SECTION);
		if(0 < nRow)
			SetCollapsed(nRow);
		///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
		//int nRowStart, nRowEnd, nLevel, ii;//no need
		///Jasmine 07/31/07 USE_FILE_TYPE_STRING_FOR_BRANCH_LABEL
		vector<int> vnTypes;
		vnTypes.SetSize(2);
		switch(nTemplateType)
		{
		case EXIST_NONE:
			return;
		case EXIST_PLOT:
			//hideBranch("Workbook");
			//hideBranch("Matrix");
			vnTypes[0] = EXIST_WKS;
			vnTypes[1] = EXIST_MATRIX;
			break;
		case EXIST_MATRIX:
			//hideBranch("Graph");
			//hideBranch("Workbook");
			vnTypes[0] = EXIST_PLOT;
			vnTypes[1] = EXIST_WKS;
			break;
		case EXIST_WKS:	
			//hideBranch("Graph");
			//hideBranch("Matrix");
			vnTypes[0] = EXIST_PLOT;
			vnTypes[1] = EXIST_MATRIX;
			break;
		default:			
		}
		for(int ii = 0; ii < vnTypes.GetSize(); ii++)
		{
			string strLabel, strType;
			string strExt = page_get_template_ext(vnTypes[ii], strType);
			strLabel.Format(_L("%s Template (*%s)"), strType, strExt);
			hideBranch(strLabel);
		}
		///End USE_FILE_TYPE_STRING_FOR_BRANCH_LABEL
		hideBranch(STR_DELETE_SECTION);//hide when nTemplateType!=0
		///End GET_TEMPLATE_BOX
	}
	void AddNewToList(TreeNode &tr, int& nFromRow)
	{
		int nParentLevel;
		int nRowToAdd = findRowToAdd(tr, nFromRow, nParentLevel);
		
		//check template if in DeletedSystemFile
		if(TR_LEVEL_CATEGORY == nParentLevel)
		{
			string strTrName;
			bool flag = tr.GetAttribute(STR_FILENAME_ATTRIB, strTrName);//STR_LABEL_ATTRIB
			int nDelBranchRow = GetRow(STR_DELETE_SECTION);
			int nRowDel = GetRow(GetFileName(strTrName), nDelBranchRow);
			if(-1 != nRowDel)
			{
				DelSection(nRowDel);
			}
		}
		
		AddTreeNodes(tr, 0, NULL, nParentLevel, &nRowToAdd, false, 0);
		//AddTreeNodes(TreeNode& tr, DWORD dwCntrl=0, LPCSTR lpcszAttribute=NULL, 
						//int nLevel = -1, int *pnFromRow = NULL,
						//bool bCollapseAll = true, int nCols = 0);
		nFromRow = --nRowToAdd;
		for(int nParentRow = nRowToAdd - 1; nParentLevel < GetLevel(nParentRow) + 1; nParentRow--)
			;
		
		SetCollapsed(nParentRow,flexOutlineExpanded);
		ShowNewMember(m_trList, nRowToAdd);
	}
	void ShowNewMember(TreeNode& trNew, int nRow)
	{
		SelRow(nRow);
		//SetSectionUnsave(trNew);
	}
	
	TreeNode GetTreeNode(int nRow)
	{
		return tree_get_node(m_trList, nRow);
	}
	/*
	int AddTemplateToList(TreeNode& trNewFunc, int nRow, int nLevel = 1)
	{
		string strFuncName, strTemp;
		if(trNewFunc && trNewFunc.GetAttribute(STR_LABEL_ATTRIB, strFuncName))
		{
			if(trNewFunc.GetAttribute(STR_CHANGED_ATTRIB, strTemp))
				strFuncName+=5;
			m_flx.AddItem(strFuncName, nRow);
			m_flx.IsSubtotal(nRow) = true;
			m_flx.RowOutlineLevel(nRow) = nLevel;
		}
		return nRow;
	}	
	*/
	
	void DelSection(int nRow)
	{
		if(TR_LEVEL_CATEGORY == GetLevel(nRow)+1)
		//if(1 == GetLevel(nRow))
		{
			int nRows = m_flx.Rows;
			for(; nRows > nRow+1 && TR_LEVEL_CATEGORY < GetLevel(nRow+1)+1;)
			//for(; nRows > nRow+1 && 1 != GetLevel(nRow+1);)	
			{
				m_flx.RemoveItem(nRow+1);
				nRows--;
			}
			if(nRows <= nRow+1 && 0 < nRow)
			{
				for(int nSelRow = nRow-1; TR_LEVEL_CATEGORY < GetLevel(nSelRow)+1; nSelRow--)
				//for(int nSelRow = nRow-1; 1 != GetLevel(nSelRow); nSelRow--)
					;
				m_flx.Row = nSelRow;
			}
			m_flx.RemoveItem(nRow);
		}
		else if(TR_LEVEL_TEMPLATE == GetLevel(nRow)+1)
		//else if(2 == GetLevel(nRow))//delete single function
		{
			if(TR_LEVEL_TEMPLATE > GetLevel(nRow+1)+1)
				m_flx.Row = nRow-1;
			m_flx.RemoveItem(nRow);
		}
	}
	void DelFromList(int& nFromRow, TreeNode trSysTemp)
	{
		int nLevel = GetLevel(nFromRow);
		
		if(trSysTemp.IsValid())
		{
			int nLastRow = m_flx.Rows;
			AddTreeNodes(trSysTemp, 0, NULL, TP_LEVEL_BRANCH, &nLastRow, false, 0);
		}
		
		DelSection(nFromRow);
		
		if(nLevel != GetLevel(nFromRow))
			nFromRow--;
		for( ; IsHide(nFromRow); nFromRow--)
			;
		SelRow(nFromRow);
	}
	int GetRow(string strRowText, int nFromRow = -1)
	{
		return FindRow(strRowText, 0, false, true, nFromRow);
			 //FindRow(LPCSTR lpcszRowText, int nCol = 0,bool bCaseSensitive = false,
				    	//bool bFullmatch = true, int nStartRow = -1);
	}
	///Jasmine 11/28/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	bool IsHide(int nRow)
	{
		if(nRow < 0 || nRow >= m_flx.Rows)
			return false;
		
		return GetIsRowHidden(nRow);
	}
	void ShowBranchOnly()
	{
		int		nRow = m_flx.Rows;
		vector<byte>	vecCollapsed(nRow);
		for(int iRow=0; iRow<vecCollapsed.GetSize(); iRow++)
		{
			///Jasmine 12/19/05 MODIFICATION_ON_TPLIST_DISPLAY
			if(IsHide(iRow))
				continue;
			///End
			if(GetLevel(iRow))
				SetCollapsed(iRow);
			else
				SetCollapsed(iRow,flexOutlineExpanded);
		}
	}
	///End GET_TEMPLATE_BOX
private:
	int findRowToAdd(TreeNode &trNewItem, int nCurrentRow, int &nCurLevel)
	{
		nCurLevel = tree_get_level(trNewItem)-1;
		int nRow = nCurrentRow+1;
		for(int nLevel = GetLevel(nRow)+1; nCurLevel < nLevel; )
		{
			nRow++;
			nLevel = GetLevel(nRow)+1;
		}
		return nRow;
	}
	///Jasmine 11/28/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	void hideBranch(string strBranch)
	{
		int nRowStart, nLevel;
		nRowStart = GetRow(strBranch);
		/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
		if( nRowStart < 0 )
			return;
		/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
		
		nLevel = GetLevel(nRowStart);
		HideRow(nRowStart);
		for(int ii = nRowStart + 1; GetLevel(ii) > nLevel; ii++)
			HideRow(ii);
	}
	///End GET_TEMPLATE_BOX
private:
	TreeNode	m_trList;
	int 		m_nId; // child ID of control
};

///DG 8/9/05
/*
class TPSplitter : public TreeEditSplitter
{
public:
	TPSplitter() : TreeEditSplitter(true, true)
	{
		m_nCurrentLevel = -1;
	}
	
protected:
EVENTS_BEGIN

	//------------- begin required events
	// the following events are required for the splitter and related controls
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)

	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnRowChange)
	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	//------------- end required events
	
EVENTS_END

	BOOL OnInitSplitter()
	{
		GUID clsid; // defualt clsid will use vsFlexGrid, make sure you have the license to do development in vsFlexGridPro
		// the following creation order must follow 1st and 2nd pane
		// and must be consistent with the constructor argument bTreeEditSecond
		CreateMainActiveXPane(clsid);		
		CreateTreeEditPane(); // bTreeEditSecond = true, then put this as second creation
		
		TreeNode trTO = m_trTemplate.AddNode("TO");
		TreeNode trTOInfo = m_trTemplate.AddNode("TemplateInfo");
		m_TPList.Init(GetMainPaneID(), *this);
		
		if(!m_TO.ConstructTOTree(trTO))
			return false;
		m_TPList.ShowTemplateList(trTO);
		
		constructTemplateInfoTree(trTOInfo);
		
		m_nSelectRow = -1;	//Default select none
		return 	SetReady();
	}
	
	BOOL OnDestroy()
	{
		return true;
	}
	
	void	OnRowChange( Control ctrl)
	{
		int nNewSelect = m_TPList.GetSelectedRow();
		int nSelectLevel = m_TPList.GetLevel(nNewSelect);
		
		if( m_nCurrentLevel != nSelectLevel)
		{
			m_nCurrentLevel = nSelectLevel;
			if(!UpdateDesription(nSelectLevel))
				return;
		}
		refreshDescription(nNewSelect, nSelectLevel);
	}
	
	bool 	UpdateDesription( int nSelectLevel = 0 )
	{
		TreeNode trGetNTree;
		switch(nSelectLevel)
		{
		case 0:
			trGetNTree = m_trTemplate.TemplateInfo.MainLevel.GetNTree;
			break;
		case 1:
			trGetNTree = m_trTemplate.TemplateInfo.TemplateCategory.GetNTree;
			break;
		case 2:
			trGetNTree = m_trTemplate.TemplateInfo.Template.GetNTree;
			break;
		default :
			return false;
		}
		if(!trGetNTree)
			return false;
		GETN_USE(trGetNTree);
		//m_treeEditCntrl.SetReady(false);//---------- CPY 9/11/04 OPERATION_OUTPUT_TREE_IN_SPLITTER, prevent edit cell to become selected during update
		m_paramTree = trGetNTree;
		m_treeEditCntrl.Update(m_paramTree, true, true);
		return true;	
	}
	//Use this name for the over loading, do this to reset GetNTree
	void ConstructTree()
	{
		GETN_TREE(toTree)
		GETN_STR(Message, "Welcome :" , "Click the list in the left to view the Template")
		GETN_READ_ONLY
		
		m_paramTree = toTree;
	}

private:
	bool	refreshDescription(int nNewSelect, int nSelectLevel)
	{
		switch(nSelectLevel)
		{
		case 0:
			updateMainCategory(nNewSelect);
			break;
		case 1:
			updateCategory(nNewSelect);
			break;
		case 2:
			updateTemplate(nNewSelect);
			break;
		default :
			return false;
		}
		Update();
		return true;	
	}
	void updateMainCategory(int nSelectRow)
	{
		tree_clear_all_value(m_paramTree);
		string 		strMainCategoryName;
		TreeNode trMainCate = tree_get_node(m_trTemplate.TO,nSelectRow, 3 );
		
		if(trMainCate.GetAttribute(STR_LABEL_ATTRIB, strMainCategoryName))
		{
			m_paramTree.MainLevel.strVal = strMainCategoryName;
		}
		
	}
	void updateCategory(int nSelectRow)
	{
		tree_clear_all_value(m_paramTree);
		string 		strCategoryName;
		TreeNode trCate = tree_get_node(m_trTemplate.TO,nSelectRow, 3 );
		
		if(trCate.GetAttribute(STR_LABEL_ATTRIB, strCategoryName))
		{
			m_paramTree.Category.strVal = strCategoryName;
			m_paramTree.Description.strVal = getDescription(nSelectRow);	//Temp solution, can't find the description of category
		}
	}
	string	getDescription(int nSelectRow )
	{
		return " ";
	}
	void updateTemplate(int nSelectRow)
	{
		//tree_clear_all_value(m_paramTree);
		string 		strTemplateName;
		string 		strTemplatePath;
		string		strCategoreName;
		string		strShareUserName;
		TreeNode trTemplate = tree_get_node(m_trTemplate.TO,nSelectRow, 3 );
		
		if(trTemplate.GetAttribute(STR_LABEL_ATTRIB, strTemplateName))
		{
			if(!trTemplate.Parent().GetAttribute(STR_LABEL_ATTRIB,strCategoreName))
				return;
			m_paramTree.Category.strVal = strCategoreName;
			
			m_paramTree.Template.strVal = strTemplateName;
			
			if(trTemplate.GetAttribute(STR_TEMPLATE_FOLDER_ATTRIB, strTemplatePath) && strTemplatePath.Compare("") != 0)
				m_paramTree.Path.strVal = strTemplatePath;
			else
				m_paramTree.Path.strVal = GetAppPath(true);
				
			if(trTemplate.GetAttribute(STR_SHARE_ATTRIB, strShareUserName) )
				m_paramTree.Share.nVal = 1;
			else
				m_paramTree.Share.nVal = 0;
		}
	}
	
	void constructTemplateInfoTree( TreeNode &tr)
	{
		constructMainLevelTree(tr);
		constructCategoryTree(tr);
		constructTemplateTree(tr);
	}
	void constructMainLevelTree(TreeNode &tr)
	{
		TreeNode trNode = tr.AddNode("MainLevel");
		trNode.SetAttribute(STR_LABEL_ATTRIB, "Main Level");
		
		GETN_TREE(trMainLevel)
		GETN_STR(MainLevel, "Main level name", "Graph")
		trNode.AddNode(trMainLevel);
	}
	void constructCategoryTree(TreeNode &tr)
	{
		TreeNode trNode = tr.AddNode("TemplateCategory");
		trNode.SetAttribute(STR_LABEL_ATTRIB,"Template Category");
		
		GETN_TREE(trCategory)
		GETN_STR(Category, "Category Name", "Graph")
		GETN_STR(Description, "Description", "Graph")
		trNode.AddNode(trCategory);
	}
	void constructTemplateTree(TreeNode &tr)
	{
		TreeNode trNode = tr.AddNode("Template");
		trNode.SetAttribute(STR_LABEL_ATTRIB,"Template");
		
		GETN_TREE(trTemplate)
		GETN_STR(Category, "Category", "Standard 2D Graphs")
		GETN_STR(Template, "Template Name", "Line")
		GETN_STR(Path, "Template Path", GetAppPath(true))
		GETN_CHECK(Share,"Share ?", false)
		trNode.AddNode(trTemplate);
	}
	
private :
	int 							m_nCurrentLevel;
	GridTreeTemplateList			m_TPList;
	Tree							m_trTemplate;						
	TemplateOrganizer				m_TO;
	int								m_nSelectRow;
};
*/
#define PANE_ROW_COL_LIST		0,0
#define PANE_ROW_COL_PAGE		0,1

class TPSplitter : public SplitterControl
{
public:
	TPSplitter()
	{
		m_bReady = false;
		
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName, bool bVisible = true, string strCurrentTemplate = "", int nShowType = EXIST_NONE, int nCurentRow = -1)///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	{
		m_nShowType = nShowType;	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
		
		SetGridSize(1,2);
		m_IDTreePane = GetDlgCtrlID(PANE_ROW_COL_LIST);
		m_IDPagePane = GetDlgCtrlID(PANE_ROW_COL_PAGE);

		InitMsgMap();
		SplitterControl::Init(nCntrlID, wndParent, 1, lpcszDlgName);// 1 = 2nd splitter in dialog
		///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
		//show template named strCurrentTemplate if it is a valid template name 
		int nSelRow = (strCurrentTemplate.IsEmpty())?nCurentRow : m_tplist.GetRow(strCurrentTemplate);///Jasmine 12/28/05 REMEMBER_LAST_SELECTION		
		if(m_tplist.IsHide(nSelRow))
			nSelRow = -1;
		///Jasmine 12/19/05 MODIFICATION_ON_TPLIST_DISPLAY
		m_tplist.ShowBranchOnly();
		if(-1 == nSelRow || inDelSection(nSelRow))
			return;		
		m_tplist.SetCollapsed(m_tplist.GetParent(nSelRow),flexOutlineExpanded);
		///End MODIFICATION_ON_TPLIST_DISPLAY
		m_tplist.SelRow( nSelRow );
		///jasmine 12/27/05 MODIFICATION_ONROWCHANGE, comment duplicated code with OnRowChange
		/*
		TreeNode trSelNode=GetTreeNode(m_nSelRow);			
		TemplateOrganizer& tpNew=GetCurrentOrganizer(m_nSelRow, true); 
		if ( tpNew.IsTemplateNode(trSelNode) ) 
		{
			m_picCtrl.Visible = false;
			tpNew.LoadTemplate(tpNew.GetLabel(trSelNode), m_picCtrl);
			m_picCtrl.Visible = true;
		}
		*/ 
		///End MODIFICATION_ONROWCHANGE
		///End GET_TEMPLATE_BOX
	}
	///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
	void OnReady()
	{
		SplitterControl::OnReady();
		
	}
	///End SPLITTER_INIT_SIZE_ON_READY
	void NewCategory();
	void AddTemplate();
	void DelCateOrTemp();
	bool Restore(TreeNode& tr);	///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
	string GetSel(int& nRow);	///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
	//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
	string GetCategoryDescription();
	//------
	///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	void ScanUserTemplates();
	///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	
	///Jasmine 12/15/10 ORG-1730 DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
	bool IsTemplateFileDeleteable(const TreeNode& trNode);
	void DeleteTemplateFile(LPCSTR strFile);
	///End DELETE_BUILT_IN_TEMPLATE_DIFFERENT_BEHAVIOR
	
private:
	bool inDelSection(int nRow);
protected:
EVENTS_BEGIN

	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	///Jasmine 04/07/06 SPLITTER_INIT_SIZE_NOT_CALL
	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnRowChange)
	ON_CONTEXTMENU(OnShowMenu)///Jasmine 12/26/05 ADD_CONTEXT_MENU
	///Jasmine 12/26/05 DBCLICK_RENAME
	ON_GRID_DBLCLICK(GetMainPaneID(), OnDblClick)
	ON_GRID_AFTER_EDIT(GetMainPaneID(), OnAfterEdit)
	///End DBCLICK_RENAME
EVENTS_END

	BOOL OnInitSplitter();
	BOOL OnDestroy();
	BOOL OnResize(int nType, int cx, int cy);
	
	void OnRowChange(Control ctrl);
	void ChangeBtnStatus();///Jasmine 12/26/05 CHANGE_BTN_STATUS
	///Jasmine 12/26/05 ADD_CONTEXT_MENU
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	BOOL OnCmdWndMenu(int nx, int ny);
	///End ADD_CONTEXT_MENU
	///Jasmine 12/26/05 DBCLICK_RENAME
	void OnDblClick(Control flxControl);
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	///End DBCLICK_RENAME
protected:
	int GetMainPaneID();
	int GetPagePaneID();
	
	TemplateOrganizer& GetCurrentOrganizer(int nRow=-1, bool SetAsCurrentOrganizer=false);
	TemplateOrganizer& GetOrganizer(int nID, bool SetAsCurrentOrganizer=false);	///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
	TreeNode GetTreeNode(int nRow);
	
	//void CreatePageControl(TemplateOrganizer& tpOld, TemplateOrganizer& tpNew);		//Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
	
private:
	void initOrganizerArray();

	int getSelTPArrayIndex(TreeNode& trSelNode);
	int getSelTPArrayIndex(int nDataID);	///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
	
	//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
	bool isCategoryRenameable(LPCSTR lpcszCategory, int nType = EXIST_WKS);
	//------
	
	//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
	bool isTemplateMoveable(const TreeNode &trTemplate);
	bool getCategories(vector<string> &vsCategories, const TreeNode &trBranch);
	//------
	
private:
	int 						m_IDTreePane;
	int							m_IDPagePane;
	
	GridTreeTemplateList		m_tplist;
	Array<TemplateOrganizer&>	m_arrTP;
	int							m_nCurOrganizerIndex;
	
	//Control						*m_pPageCtrl;
	PictureControl				m_picCtrl;
	
	bool						m_bReady;
	
	Tree						m_trTP;
	
	int							m_nSelRow;
	int 						m_nShowType;	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
};

#endif  _TP_SPLITTER_H_
