/*------------------------------------------------------------------------------*
 * File Name:  TDMFile.h				 													*
 * Creation: AW 11/29/06																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:
 *------------------------------------------------------------------------------*/

#ifndef _TDM_FILE_H
#define _TDM_FILE_H

#define TDM_ERROR_INVALID_TDM_FILE			1000	
#define TDM_ERROR_INVALID_USI_STRING		1001
#define TDM_ERROR_INVALID_CHANNEL_GROUP		1002
#define TDM_ERROR_INVALID_CHANNEL			1003
#define TDM_ERROR_INVALID_COLUMN			1004
#define TDM_ERROR_INVALID_BALOCK			1005	
#define TDM_ERROR_INVALID_WKS_PAGE			1006	
#define TDM_ERROR_INVALID_TDX_FILE			1007	
#define TDM_ERROR_READ_TDX					1008

class OCTDMFile : public Tree
{
public:
	OCTDMFile(int nType = 0);
//	OCTDMFile(Worksheet& wks, LPCSTR File, int nType = 0);
	~OCTDMFile() {}
protected:
	DataRange	m_drRange;/// Hong 12/06/06 MORE_INFO_FOR_ORGANIZER
	TreeNode	m_trData;
	TreeNode	m_trFile;
	BOOL		m_bValid;
	BOOL		m_bLittleEndian;
	string		m_strTDXFileName;
	string		m_strTDMFileName;
	WorksheetPage		m_wksPage;
public:
	/// Hong 12/06/06 ADD_DATA_SELECTION
	//int Load(WorksheetPage wksPage, TreeNode& trInfo, LPCSTR File, int nType = 0);
	int Load(WorksheetPage wksPage, TreeNode& trFileNode, TreeNode& trInfo, LPCSTR lpcszFile, int nType = 0);
	/// end ADD_DATA_SELECTION

	int GetGroupChannelNum(LPCSTR lpcszFile, vector<int>& vnChannenNum);
protected:
	/// Hong 12/06/06 ADD_DATA_SELECTION
	//int handleRootNode(TreeNode& trInfo);	
	//int handleGroupsNode(StringArray& vsUSI, TreeNode& trRoot);
	//int handleChannelsNode(Worksheet& wks, StringArray& vsUSI, TreeNode& trGroup);
	int handleRootNode(TreeNode& trFileNode, TreeNode& trInfo);
	int handleGroupsNode(StringArray& vsUSI, TreeNode& trRoot, TreeNode& trFileNode);
	int handleChannelsNode(Worksheet& wks, StringArray& vsUSI, TreeNode& trGroup, TreeNode& trFileNode);
	/// end ADD_DATA_SELECTION
	int handleColumnNode(Column& col, StringArray& vsUSI, TreeNode& trChannel);
	/// Hong 12/01/06 FIX_DATE_TIME_DATA_IMPROT_ERRRO
	//int getColumnData(Column& cc, int nOffset, int nLength);
	int getColumnData(Column& cc, int nOffset, int nLength, bool bTime);
	/// end FIX_DATE_TIME_DATA_IMPROT_ERRRO

	
private:
	int init();
};

#endif  //_TDM_FILE_H