/*------------------------------------------------------------------------------*
 * File Name: SwitchLanguage.c 													*
 * Creation : Folger															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2007										*
 * All Rights Reserved															*
 *-----------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"

class SwitchLanguageDlg : public ResizeDialog
{
public:
	SwitchLanguageDlg() : ResizeDialog(IDD_SWITCH_LANGUAGE, "ODlg8")
	{
		
	}
	int DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hParent);
		return nRet;
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_OK(OnOK)
EVENTS_END
	
	bool OnInitDialog()
	{
		ResizeDialog::OnInitDialog(IDD_SWITCH_LANGUAGE);
		m_Cb = GetItem(IDC_COMBO_LANGUAGE);
		okutil_is_language_supported("E", m_Lang, false);
		m_chCur = okutil_get_current_lang();
		for (int ii=0; m_Lang[ii]!=0; ii++)
		{
			switch (m_Lang[ii])
			{
			case 'E':
				m_Cb.InsertString(ii, _L("English"));
				break;
			case 'G':
				m_Cb.InsertString(ii, _L("German"));
				break;
			case 'J':
				m_Cb.InsertString(ii, _L("Japanese"));
				break;
			case 'C':
				m_Cb.InsertString(ii, _L("Chinese"));
				break;
			default:
				break;
			}
			if (m_Lang[ii] == m_chCur)
			{
				m_Cb.SetCurSel(ii);
			}
		}
		return true;
	}
	
	bool OnOK()
	{
		int nIndex = m_Cb.GetCurSel();
		string strText = m_Lang[nIndex];
		if (strText[0] != m_chCur)
		{
			okutil_set_resource_lang(strText);
		}
		return true;
	}
	

private:
	char m_chCur;
	char m_Lang[5];
	ComboBox m_Cb;
};
/*
int SwitchLanguage()
{
	SwitchLanguageDlg slDlg;
	int nRet = slDlg.DoModalEx();
	return 0;
}
*/

int SwitchLanguage(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	SwitchLanguageDlg myDlg;
	HWND hParent = lpData;
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
		return error_report("Language Setting already open");
	Window winNewDlg(hParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hParent;
	if(hWnd)
		return (IDOK == myDlg.DoModalEx(hWnd));
	return false;
}
