/*----------------------------------------------------------------------------------------------*
 * File Name: StartLaunchTipsDlg.c																*
 * Creation: 																					*
 * Purpose: OriginC Source C file																*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012		*
 * All Rights Reserved																			*
 * 																								*
 * Modification Log:																			*
 * Iris 3/02/2011 ORG-2196-S4 NOT_SHOW_UFF_INFO													*
 * Iris 3/09/2011 ORG-2196-P4 FIX_START_TIPS_DLG_SHOW_WHEN_ORIGIN_IS_HIDDEN_RUNNING				*
 * Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB												*
 * Iris 3/29/2011 ORG-2196-S12 ADD_ELLIPSIS_DOWN_VERSIONS										*
 * Kit 04/18/2011 ORG-2664-P1 WIN7_JAPANESE_HINT_NOT_SHOW_CORRECTLY								*
 *	Folger 07/19/2012 ORG-6262-P1 FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN					*
 *	Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG										*
 *----------------------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "DialogEx.h"
#include "StartLaunchTipsDlg.h"

#define STR_DLG_NAME "StartLaunchTipsDlg"

enum {
	TAB_CHECK_FOR_UPDATE,
	TAB_TRANSFER_USER_FILE,
	TAB_OPEN_SAMPLES,
};

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
int StartLaunchTipsReminderDlg::DoModalEx(HWND hParent)
{ 
	InitMsgMap();// will be called from internal later
	return DoModal(hParent);
}

bool StartLaunchTipsReminderDlg::IsOpenSamplesFolder()
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//return m_bOpenSamples;
	return O_QUERY_BOOL(m_dwItemSel, SUI_OpenSamples);
	///-----End ADD_INIT_TOOLBAR_TAB
}

bool StartLaunchTipsReminderDlg::IsTransferUserFile()
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//return m_bTransferUserFile;
	return O_QUERY_BOOL(m_dwItemSel, SUI_OpenTransferUserFile);
	///-----End ADD_INIT_TOOLBAR_TAB
}

bool StartLaunchTipsReminderDlg::IsOpenCheckForUpdateDlg()
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//return m_bCheckForUpdate;
	return O_QUERY_BOOL(m_dwItemSel, SUI_CheckForUpdate);
	///-----End ADD_INIT_TOOLBAR_TAB
}

///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
bool StartLaunchTipsReminderDlg::IsInitToolBars()
{
	return O_QUERY_BOOL(m_dwItemSel, SUI_InitToolBars);
}
///-----End ADD_INIT_TOOLBAR_TAB
	
/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
string StartLaunchTipsReminderDlg::GetSelectedSampleProjectFile()
{	
	if ( !m_strOPJ.IsEmpty() )
		return m_strOPJ;

	int nSel = m_cmbSampleProjects.GetCurSel();
	if( nSel < m_vsSampleProjectFiles.GetSize() )
		return m_vsSampleProjectFiles[nSel];
	return "";
}
///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG

BOOL StartLaunchTipsReminderDlg::OnClickTransferUserFilesButton(Control ctrl)
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//m_bTransferUserFile = true;
	O_ADD_BIT(m_dwItemSel, SUI_OpenTransferUserFile);
	///-----End ADD_INIT_TOOLBAR_TAB
	PostMessage( WM_CLOSE );
	return true;
}

BOOL StartLaunchTipsReminderDlg::OnClickOpenSamplesProjectButton(Control ctrl)
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//m_bOpenSamples = true;
	O_ADD_BIT(m_dwItemSel, SUI_OpenSamples);
	///-----End ADD_INIT_TOOLBAR_TAB
	m_strOPJ = GetSelectedSampleProjectFile(); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	PostMessage( WM_CLOSE );
	return true;
}

BOOL StartLaunchTipsReminderDlg::OnClickCheckForUpdateButton(Control ctrl)
{
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//m_bCheckForUpdate = true;
	O_ADD_BIT(m_dwItemSel, SUI_CheckForUpdate);
	///-----End ADD_INIT_TOOLBAR_TAB
	PostMessage( WM_CLOSE );
	return true;
}

///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
BOOL StartLaunchTipsReminderDlg::OnReInitToolBars(Control ctrl)
{
	O_ADD_BIT(m_dwItemSel, SUI_InitToolBars);
	PostMessage(WM_CLOSE);
	return TRUE;
}
///-----End ADD_INIT_TOOLBAR_TAB

BOOL StartLaunchTipsReminderDlg::OnClose(Control ctrl)
{
	PostMessage( WM_CLOSE );
	return true;
}

BOOL StartLaunchTipsReminderDlg::OnInitDialog()
{		
	ResizeDialog::OnInitDialog(0, STR_DLG_NAME); 	

	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	/*
	m_bTransferUserFile = false;
	m_bOpenSamples = false;
	m_bCheckForUpdate = false;
	*/
	///-----End ADD_INIT_TOOLBAR_TAB
	
	GetItem(IDC_GROUP_CHECK_FOR_UPDATE).Visible =
	GetItem(IDC_GROUP_TRANSFER_UF).Visible =
	GetItem(IDC_GROUP_OPEN_SAMPLE_PROJECT).Visible =
	GetItem(IDC_CHECK_FOR_UPDATE_NOW).Visible =
	GetItem(IDC_TRANSFER_UF_NOW).Visible =
	GetItem(IDC_OPEN_SAMPLES_OPJ).Visible =
	GetItem(IDC_STATIC_CHECK_FOR_UPDATE_TIPS).Visible =
	GetItem(IDC_STATIC_TRANSFER_UF).Visible =
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	//GetItem(IDC_STATIC_OPEN_SAMPLES_FLD).Visible = false;
	GetItem(IDC_STATIC_OPEN_SAMPLES_FLD).Visible = 
	GetItem(IDC_CHECK_INIT_TOOLBAR_BTN).Visible = 
	GetItem(IDC_GROUP_INIT_TOOLBAR).Visible = 
	GetItem(IDC_STATIC_INIT_TOOLBAR_TIPS).Visible = false;
	///-----End ADD_INIT_TOOLBAR_TAB

	m_ckDlgNeverShow = GetItem(IDC_CHECK_NEVER_SHOW);
	
	// get and display the Origin older version info
	vector vVersions;
	vector<string> vsKeys, vsSysFolder, vsUFFs;
	if( okutil_get_installed_origins(&vVersions, &vsKeys, &vsSysFolder, &vsUFFs, GETINSTALLEDORG_SORT_BY_VERSION|GETINSTALLEDORG_OLDER_VERSIONS) )
	{
#define MAX_VERSIONS_TO_LIST	2

		int nVersions = vsKeys.GetSize();
		int nOldest = (nVersions > MAX_VERSIONS_TO_LIST) ? (nVersions-MAX_VERSIONS_TO_LIST): 0;

		string strOldVersions;
		char czGap[] = "  ";
		for(int ii = nVersions-1; ii >= nOldest; ii--)
		{
			if( !strOldVersions.IsEmpty() )
				strOldVersions += "\r\n";
			strOldVersions += (string)czGap + vsKeys[ii];
		}
		/// Iris 3/29/2011 ORG-2196-S12 ADD_ELLIPSIS_DOWN_VERSIONS
		if( nVersions > MAX_VERSIONS_TO_LIST )
			strOldVersions += "\r\n" + (string)czGap + "..."; 
		///End ADD_ELLIPSIS_DOWN_VERSIONS
		
		string strText;
		Control ctrlTransferUF = GetItem(IDC_STATIC_TRANSFER_UF);
		strText.Format(ctrlTransferUF.Text, strOldVersions);
		ctrlTransferUF.Text = strText;
	}
	else
	{
		if( m_dwOptions & FIRST_POP_ENABLE_TRANSFER_UF )
		{
			m_dwOptions &= ~FIRST_POP_ENABLE_TRANSFER_UF;			
		}
	}
	
	/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	m_cmbSampleProjects = GetItem(IDC_SAMPLE_OPJ_COMBO);
	if( m_cmbSampleProjects )
	{		
		vector<string> vsDisplayNames;
		okutil_get_sample_opjs(&m_vsSampleProjectFiles, &vsDisplayNames);
		
		for(int index = 0; index < vsDisplayNames.GetSize(); ++index)
		{
			m_cmbSampleProjects.AddString(vsDisplayNames[index]);
		}
		m_cmbSampleProjects.AdjustDroppedWidth();
		m_cmbSampleProjects.SetCurSel(0);
	}
	///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	
	showControls();	
	resizeControls();

	return true;
}

BOOL StartLaunchTipsReminderDlg::OnReady()
{
	SetInitReady( true );
	return true;
}


BOOL StartLaunchTipsReminderDlg::OnDestroy(void)
{
	if( m_ckDlgNeverShow.Check )
	{
		///-----Kit 03/28/2011 ORG-2196-S11 EXPORT_SAVE_LOAD_REMINDER_MSG_FUNC
		/*
		INIFile inifile;
		if( m_bIsProduct )
		{
			int nKey = 0x4E4e;
			inifile.WriteInt("ReminderMessages", (string)nKey, 1);
		}
		else
		{
			int nKey = 0x4E4d;
			inifile.WriteInt("ReminderMessages", (string)nKey, 1);		
		}
		*/
		///-----Kit 03/28/2011 !!!when modify these id, please keep coincidence with ids.h!!!
#define IDSM_ORG_PRODUCT_FIST_TIME_RUNNING_POP_DLG	0x4E4e
#define IDSM_ORG_DEMO_FIST_TIME_RUNNING_POP_DLG		0x4E4d
		SaveOptionalReminderMessageFlag(m_bIsProduct ? IDSM_ORG_PRODUCT_FIST_TIME_RUNNING_POP_DLG : IDSM_ORG_DEMO_FIST_TIME_RUNNING_POP_DLG, OM_RETURN_OK);
		///-----End EXPORT_SAVE_LOAD_REMINDER_MSG_FUNC
	}
	
	ResizeDialog::OnDestroy();
	return true;
}
/*
BOOL StartLaunchTipsReminderDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
	pSz->top = -1;
	pSz->left =-1;
	pSz->width = GetTotalWidth();
	pSz->height = GetTotalHeight();
	
	return TRUE;
}
	
//virtual
int StartLaunchTipsReminderDlg::GetTotalHeight(bool bGetMin)
{
	if( bGetMin )
	{
		return ResizeDialog::GetTotalHeight(bGetMin);
	}
	else
	{
		switch( m_vnGroupIDs.GetSize() )
		{
		case 1:
			return 180;
		case 2:
			return 230;
		case 3:
			return 360;
		}
		ASSERT(0);
		return 0;
	}
}

//virtual
int StartLaunchTipsReminderDlg::GetTotalWidth(bool bGetMin)
{
	if( bGetMin )
	{
		RECT rrNeverShow, rrClose;
		GetControlClientRect(IDC_CHECK_NEVER_SHOW, rrNeverShow);
		GetControlClientRect(IDB_CLOSE, rrClose);
		return 3 * GetControlGap() + RECT_WIDTH(rrNeverShow) + RECT_WIDTH(rrClose);
	}
	else
	{
		if( m_vnGroupIDs.GetSize() > 1 )
			return 350;
		else
			return 300;
	}
}

BOOL StartLaunchTipsReminderDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;	
		
	resizeControls(false);	
	return false;
}
*/

void StartLaunchTipsReminderDlg::showControls()
{
	if( O_QUERY_BOOL(m_dwOptions, FIRST_POP_ENABLE_CHECK_FOR_UPDATE) )
	{
		m_vnGroupIDs.Add(IDC_GROUP_CHECK_FOR_UPDATE);
		m_vuTipsControlIDs.Add(IDC_STATIC_CHECK_FOR_UPDATE_TIPS);
		m_vuButtonIDs.Add(IDC_CHECK_FOR_UPDATE_NOW);
		m_vnComboIDs.Add(0); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	}
	
	if( O_QUERY_BOOL( m_dwOptions, FIRST_POP_ENABLE_TRANSFER_UF) )
	{
		m_vnGroupIDs.Add(IDC_GROUP_TRANSFER_UF);
		m_vuTipsControlIDs.Add(IDC_STATIC_TRANSFER_UF);
		m_vuButtonIDs.Add(IDC_TRANSFER_UF_NOW);		
		m_vnComboIDs.Add(0); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	}
	
	if( O_QUERY_BOOL( m_dwOptions, FIRST_POP_ENABLE_OPEN_SAMPLES) )
	{
		m_vnGroupIDs.Add(IDC_GROUP_OPEN_SAMPLE_PROJECT);
		m_vuTipsControlIDs.Add(IDC_STATIC_OPEN_SAMPLES_FLD);
		m_vuButtonIDs.Add(IDC_OPEN_SAMPLES_OPJ);
		m_vnComboIDs.Add(IDC_SAMPLE_OPJ_COMBO); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG 
	}
	
	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	if( O_QUERY_BOOL(m_dwOptions, FIRST_POP_ENABLE_INIT_TOOLBAR) )
	{
		m_vnGroupIDs.Add(IDC_GROUP_INIT_TOOLBAR);
		m_vuTipsControlIDs.Add(IDC_STATIC_INIT_TOOLBAR_TIPS);
		m_vuButtonIDs.Add(IDC_CHECK_INIT_TOOLBAR_BTN);
		m_vnComboIDs.Add(0); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	}
	///-----End ADD_INIT_TOOLBAR_TAB

	ASSERT( m_vuTipsControlIDs.GetSize() > 0 && m_vnGroupIDs.GetSize() == m_vuTipsControlIDs.GetSize() && m_vuButtonIDs.GetSize() == m_vuTipsControlIDs.GetSize());
	ASSERT( m_vnComboIDs.GetSize() == m_vuTipsControlIDs.GetSize() );
	if( m_vuTipsControlIDs.GetSize() == 0 )
		return;	

	for(int index = 0; index < m_vuTipsControlIDs.GetSize(); index++)
	{
		/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		//GetItem(m_vnGroupIDs[index]).Visible = (m_vnGroupIDs.GetSize() > 1);
		GetItem(m_vnGroupIDs[index]).Visible = true;
		///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		GetItem(m_vuTipsControlIDs[index]).Visible = true;
		GetItem(m_vuButtonIDs[index]).Visible = true;
		
		/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		Control ctrlCombo = GetItem(m_vnComboIDs[index]);
		if( ctrlCombo )
			ctrlCombo.Visible = true;
		///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
	}	
}

void StartLaunchTipsReminderDlg::resizeControls()
{
	RECT rrDlg;	
	GetWindowRect(&rrDlg);
	ScreenToClient(&rrDlg);	
	
	int nGap = GetControlGap();		
	int nLeft = nGap;
	int nTop = nGap;
	MoveControlsHelper	_temp(this);
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	//bool bOnlyOneTips = m_vnGroupIDs.GetSize() == 1;
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	
	Control btnNeverShow, btnClose;
	RECT rrNeverShow, rrClose;
	GetControlClientRect(IDC_CHECK_NEVER_SHOW, rrNeverShow, &btnNeverShow);
	GetControlClientRect(IDB_CLOSE, rrClose, &btnClose);
	
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	/*
	if( bOnlyOneTips ) // open sample tips very short, so need make dialog width narrow; else just keep the dialog width in rc.
	{
		rrDlg.right = rrDlg.left + RECT_WIDTH(rrNeverShow) + 4 * nGap + RECT_WIDTH(rrClose);
	}
	*/
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	
	RECT rrGroup, rrStatic, rrButton;
	int nWidth, nHeight;
	for(int index = 0; index < m_vuTipsControlIDs.GetSize(); index++)
	{
		/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		// Button RECT
		Control btn = GetItem(m_vuButtonIDs[index]);
		GetClientRect(btn, rrButton);
		nWidth = RECT_WIDTH(rrButton);
		nHeight = RECT_HEIGHT(rrButton);
		rrButton.top = nTop;
		rrButton.left = nLeft + 2 * nGap;
		rrButton.bottom = rrButton.top + nHeight;
		rrButton.right = rrButton.left + nWidth;
		///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		
		// Group RECT expect bottom
		rrGroup.left = nLeft;
		/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		//rrGroup.top = nTop;
		rrGroup.top = nTop + RECT_HEIGHT(rrButton) / 3.0;
		///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		rrGroup.right = rrDlg.right - 2 * nGap;		
		
		/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		// Combo Rext
		RECT rrCombo;
		Control ctrlCombo = GetItem(m_vnComboIDs[index]);
		if( ctrlCombo )
		{
			GetClientRect(ctrlCombo, rrCombo);
			nWidth = RECT_WIDTH(rrCombo);
			nHeight = RECT_HEIGHT(rrCombo);
			
			rrCombo.left = rrButton.left;
			rrCombo.right = rrCombo.left + nWidth;
			//------ Iris 7/18/2012 to fix too big gap between button with static text
			//rrCombo.top = rrGroup.top + 5 * nGap;
			rrCombo.top = rrButton.bottom + nGap; 
			//------
			rrCombo.bottom = rrCombo.top + nHeight;
			
		}
		///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		
		// Static RECT
		Control ctrlStatic = GetItem(m_vuTipsControlIDs[index]);	
		GetClientRect(ctrlStatic, rrStatic);
		///-----Kit 04/18/2011 ORG-2664-P1 WIN7_JAPANESE_HINT_NOT_SHOW_CORRECTLY
		//nWidth = RECT_WIDTH(rrStatic);
		nWidth = RECT_WIDTH(rrGroup) - nGap;
		///-----End WIN7_JAPANESE_HINT_NOT_SHOW_CORRECTLY

		nHeight = ctrlStatic.Measure(ctrlStatic.Text, &nWidth, false);			
		/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		/*
		rrStatic.left = bOnlyOneTips ? nGap : rrGroup.left + nGap; // if only one tips, will not show tips with Group control
		rrStatic.right = bOnlyOneTips ? rrDlg.right - nGap : rrGroup.right - nGap;
		rrStatic.top = bOnlyOneTips? nTop : rrGroup.top + 4 * nGap;
		*/
		rrStatic.left = rrGroup.left + nGap;
		///-----Kit 04/18/2011 ORG-2664-P1 WIN7_JAPANESE_HINT_NOT_SHOW_CORRECTLY
		//rrStatic.right = rrGroup.right - nGap;
		rrStatic.right = rrStatic.left + nWidth;
		///-----End WIN7_JAPANESE_HINT_NOT_SHOW_CORRECTLY
		
		/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		//rrStatic.top = rrGroup.top + 5 * nGap;
		//------ Iris 7/18/2012 to fix too big gap between button with static text
		//rrStatic.top = m_vnComboIDs[index] > 0 ? rrCombo.bottom + nGap : rrGroup.top + 5 * nGap;
		rrStatic.top = m_vnComboIDs[index] > 0 ? rrCombo.bottom + nGap : rrButton.bottom + nGap;
		//------
		///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		rrStatic.bottom = rrStatic.top + nHeight;
		
		/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		/*
		// Button RECT
		Control btn = GetItem(m_vuButtonIDs[index]);
		GetClientRect(btn, rrButton);
		nWidth = RECT_WIDTH(rrButton);
		nHeight = RECT_HEIGHT(rrButton);
		rrButton.top = rrStatic.bottom + nGap;
		rrButton.bottom = rrButton.top + nHeight;	
		rrButton.right = bOnlyOneTips? rrGroup.right : rrGroup.right - nGap;
		rrButton.left = rrButton.right - nWidth;
		
		// set the bottom of Group according to the position of Button
		rrGroup.bottom = rrButton.bottom + nGap;
		*/
		///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
		
		rrGroup.bottom = rrStatic.bottom + 2 * nGap;
		
		// Moving Controls
		Control ctrlGroup = GetItem(m_vnGroupIDs[index]);		
		MoveControl(ctrlGroup, rrGroup);
		MoveControl(ctrlCombo, rrCombo); /// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG 
		MoveControl(btn, rrButton);		
		MoveControl(ctrlStatic, rrStatic);		
		ctrlStatic.InvalidateOnResize();		
		
		// get the top of next Group
		GetClientRect(ctrlGroup, rrGroup);
		nTop = rrGroup.bottom + 2 * nGap;
	}	
	
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	/*
	const int nDlgMinHeight = 130;
	bool bDlgResizeDone = false;
	if( bOnlyOneTips && RECT_HEIGHT(rrStatic) + RECT_HEIGHT(rrButton) + RECT_HEIGHT(rrClose) + 4 * nGap < nDlgMinHeight )
	{
		rrDlg.bottom = rrDlg.top + nDlgMinHeight;
		bDlgResizeDone = true;
	}
	*/
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS

	nWidth = RECT_WIDTH(rrNeverShow);
	nHeight = RECT_HEIGHT(rrNeverShow);
	rrNeverShow.left = nLeft;
	rrNeverShow.right = rrNeverShow.left + nWidth;
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	/*	
	rrNeverShow.top = bDlgResizeDone ? rrDlg.bottom - nGap - nHeight : nTop;
	rrNeverShow.bottom = bDlgResizeDone ? rrDlg.bottom - nGap : rrNeverShow.top + nHeight;
	rrNeverShow.top = nTop;
	*/
	rrNeverShow.top = rrGroup.bottom + nGap;
	rrNeverShow.bottom = rrNeverShow.top + nHeight;
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	MoveControl(btnNeverShow, rrNeverShow);
	
	nWidth = RECT_WIDTH(rrClose);
	nHeight = RECT_HEIGHT(rrClose);
	rrClose.right = rrGroup.right;
	rrClose.left = rrClose.right - nWidth;
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	/*	
	rrClose.top = bDlgResizeDone ? rrDlg.bottom - nGap - nHeight : nTop;
	rrClose.bottom = bDlgResizeDone ? rrDlg.bottom - nGap : rrClose.top + nHeight;
	*/
	rrClose.top = rrGroup.bottom + nGap;
	rrClose.bottom = rrClose.top + nHeight;
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	MoveControl(btnClose, rrClose);

	// reject the position of dialog
	/// Iris 3/14/2011 ORG-2196-S10 THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS		
	/*
	if( !bDlgResizeDone )
		rrDlg.bottom = rrClose.bottom + nGap;
	*/
	rrDlg.bottom = rrClose.bottom + 2 * nGap;
	///End THE_TITLE_OF_GROUP_REPLACE_WITH_BUTTONS
	ClientToScreen(&rrDlg);		
	MoveWindow(&rrDlg);
}


int StartLaunchTipsDlg(int nMsg, DWORD dwCntrl, LPVOID lpData)
{
	/// Iris 3/09/2011 ORG-2196-P4 FIX_START_TIPS_DLG_SHOW_WHEN_ORIGIN_IS_HIDDEN_RUNNING
	if( !IsWindowVisible(GetWindow()) ) // if Origin is hidden, should not show this dlg
		return 0;
	///End FIX_START_TIPS_DLG_SHOW_WHEN_ORIGIN_IS_HIDDEN_RUNNING
	
	bool bIsProduct = dwCntrl;
	StartLaunchTipsReminderDlg dlg(*(int*)(lpData), bIsProduct);
	int nRet = dlg.DoModalEx(GetWindow());
	
	if( dlg.IsOpenCheckForUpdateDlg() )
	{
		LT_execute("run.LoadOC(Originlab\ChkForUpdatesDlg.c, 16); DoCheckForUpdatesDlg;");
	}
	
	if( dlg.IsTransferUserFile() )
	{
		///------ Folger 07/19/2012 ORG-6262-P1 FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN
		//LT_execute("updateUFF");
		//LT_execute("updateUFFNew");
		LT_execute("updateUFF");   //tony 9/18/2012 fix unenable open uff dialog
		///------ End FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN
	}
	
	if( dlg.IsOpenSamplesFolder() )
	{
		/// Iris 6/27/2012 ORG-6079-S2 ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
		//string strFile = GetOriginPath() + "Samples\\Samples.opj";
		string strFile = dlg.GetSelectedSampleProjectFile();
		if( strFile.IsFile() )
		///End ADD_SAMPLE_OPJ_COMBO_TO_START_LAUNCH_TIPS_DLG
			Project.Open(strFile);
	}

	///-----Kit 03/28/2011 ORG-2196-S11 ADD_INIT_TOOLBAR_TAB
	if( dlg.IsInitToolBars() )
	{
		ReinitToolBars();
	}
	///-----End ADD_INIT_TOOLBAR_TAB

	return nRet;
}

void testDlg()
{
	DWORD dwCntrl = FIRST_POP_ENABLE_CHECK_FOR_UPDATE | FIRST_POP_ENABLE_TRANSFER_UF | FIRST_POP_ENABLE_OPEN_SAMPLES | FIRST_POP_ENABLE_INIT_TOOLBAR;
	StartLaunchTipsDlg(0, 1, (int*)&dwCntrl);

}



//Sophy 8/27/2012 ORG-6636-S1 USE_INI_TO_TRACE_OPENGL_DRAWING_CRASH
#include <ocu.h>
int		COriginErrorInfoDlg::DoModalEx(HWND hParent)
{
	InitMsgMap();
	return DoModal(hParent);
}

virtual BOOL	COriginErrorInfoDlg::OnInitDialog()
{
	Control ctrl = GetItem(IDC_ERROR_INFO);
	m_errInfo.CreateControl(ctrl.GetSafeHwnd());
	InitDisplayText();
	return TRUE;
}

virtual BOOL	COriginErrorInfoDlg::InitDisplayText()
{
	string strErrMsg;
	ocu_load_err_msg_str(m_nErrorCode, &strErrMsg);
	vector<string> vsTokens;
	strErrMsg.GetTokens(vsTokens, '|');
	ASSERT(vsTokens.GetSize() == 2);
	string strDisplay;
	if ( vsTokens.GetSize() == 2 )
		strDisplay.Format("<p>Origin crash last time due to <font color=red>%s</font>, for details, click <a ID=LinkOLabURL target=_blank href=%s>here</a>.</p>", vsTokens[0], vsTokens[1]);
	else
		strDisplay = "<p><font color=red>Fail to load error information.</font></p>";
	m_errInfo.SetHtmlText(strDisplay);
	return TRUE;
}

///Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG
//virtual
BOOL 	OpenGLCrashInfoDlg::OnInitDialog()
{
	COriginErrorInfoDlg::OnInitDialog();
	
	Text = _L("OpenGL Failure Reminder");
	GetItem(IDC_ERR_STR1).Text = _L("Origin/OriginPro terminated unexpectedly last time. This problem is typically related to video driver issues. You may avoid this problem by checking the following checkboxes to turn off some of the OpenGL features: ");
	Button chk1 = GetItem(IDC_CHECK1);
	chk1.Text = _L("Disable Transparency");
	chk1.Check = TRUE;
	Button chk2 = GetItem(IDC_CHECK2);
	chk2.Text = _L("Disable Anti-aliasing");
	chk2.Check = TRUE;
	GetItem(IDC_ERR_STR2).Text = _L("You can try to update your video driver and then goto Tools: 3D OpenGL Settings to turn these back on later.");
	
	return TRUE;
}

//virtual 
BOOL	OpenGLCrashInfoDlg::InitDisplayText()
{
	string strErrMsg;
	ocu_load_err_msg_str(m_nErrorCode, &strErrMsg);
	vector<string> vsTokens;
	strErrMsg.GetTokens(vsTokens, '|');
	ASSERT(vsTokens.GetSize() == 2);
	string strDisplay;
	if ( vsTokens.GetSize() == 2 )
		strDisplay.Format("<p><font size=\"-1\">%s <a ID=LinkOLabURL target=_blank href=%s>%s</a>.<font></p>", _L("For more information, please visit"), vsTokens[1], _L("this website page"));
	else
		strDisplay.Format("<p><font color=red>%s</font></p>", _L("Fail to load error information."));
	m_errInfo.SetHtmlText(strDisplay);
	return TRUE;
}

typedef void (*PFN_CHANGE_SYS_VAR)(const vector<string>& vsVarNames, const vector<string>& vsVarVals, const vector<string>& vsComment);

BOOL	OpenGLCrashInfoDlg::OnOK()
{
	vector<string> vsNames, vsValues, vsComment;
	
	Button chk1 = GetItem(IDC_CHECK1);
	if(chk1.Check)
	{
		disableOpenGLSysVar("@OGLT", -1, vsNames, vsValues);
	}
	
	Button chk2 = GetItem(IDC_CHECK2);
	if(chk2.Check)
	{
		disableOpenGLSysVar("@OGLFA", 0, vsNames, vsValues);
		disableOpenGLSysVar("@OGLFAE", 0, vsNames, vsValues);
	}
	
	if(vsNames.GetSize() > 0)
	{		
		vsComment.SetSize( vsNames.GetSize() );
		vsComment = ";//";
		PFN_CHANGE_SYS_VAR pfn = Project.FindFunction("change_system_variables_in_start_up", "OriginLab\\SystemVariableDlg", TRUE);
		if(pfn)
			pfn(vsNames, vsValues, vsComment);
	}
	
	return TRUE;
}

void 	OpenGLCrashInfoDlg::disableOpenGLSysVar(LPCSTR lpczVar, int nn, vector<string>& vsNames, vector<string>& vsValues)
{
	string 	strMessage;
	double 	dd;
	LT_get_var(lpczVar, &dd);
	if( !is_equal(dd, nn) )
	{
		strMessage.Format(_L("%s is set to %d from %d"), lpczVar, nn, (int)dd);
		vsNames.Add(lpczVar);
		vsValues.Add((string)nn);
	}
	else
	{
		strMessage.Format(_L("%s is already %d."), lpczVar, nn);
	}
	warning_msg_box(strMessage, false, 'I');
}
///End OPENGL_CRASH_INFO_DLG

int		LaunchDisplayErrorDlg(int nErrCode, DWORD dwCtrl, LPVOID lpData)
{
	///Jasminie 09/07/2012 ORG-6636-S1 OPENGL_CRASH_INFO_DLG
	//COriginErrorInfoDlg dlg(nErrCode, dwCtrl);
	//int nRet = dlg.DoModalEx(GetWindow());
	//return nRet;
	int nRet;
	switch(nErrCode)
	{
	case CER_OGL_CRASH:
		{
			OpenGLCrashInfoDlg dlg(nErrCode, dwCtrl);
			nRet = dlg.DoModalEx(GetWindow());
			break;
		}
	default:
		{
	///End OPENGL_CRASH_INFO_DLG
			COriginErrorInfoDlg dlg(IDD_ERROR_INFO, nErrCode, dwCtrl);
			nRet = dlg.DoModalEx(GetWindow());
			break;
		}
	}
	
	return nRet;
}


void	test_LaunchDisplayErrorDlg()
{
	LaunchDisplayErrorDlg(CER_OGL_CRASH, 0, NULL);
	return;
}


///end USE_INI_TO_TRACE_OPENGL_DRAWING_CRASH
