/*------------------------------------------------------------------------------*
 * File Name: SimpleColumnFilterDlg.h 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
 *	Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER		*
 *------------------------------------------------------------------------------*/
 
class SimpleColumnFilterDlg
{
public:
	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	//SimpleColumnFilterDlg(const Column& col);
	SimpleColumnFilterDlg(const Column& col, PEVENT_GETN pfnEvent = NULL);
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	~SimpleColumnFilterDlg();
	
	bool	DoDlg();

protected:
	virtual void	InitSettings();
	virtual	void	InitDlg() 								{}
	virtual	bool	DataToGUI(int nType, LPVOID pData)		{return false;}
	virtual	bool	GUIToData(int& nType, LPVOID& pData)	{return false;}
	
protected:
	Column					m_col;
	Tree					m_tr;
	PEVENT_GETN				m_pfnEvent;		/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	string					m_strTitle;
};

class SimpleColumnFilterNumericGeneralDlg : public SimpleColumnFilterDlg
{
public:
	SimpleColumnFilterNumericGeneralDlg(const Column& col, int nEntry);
	~SimpleColumnFilterNumericGeneralDlg();

protected:
	virtual	void	InitDlg();
	virtual bool	DataToGUI(int nType, LPVOID pData);
	virtual bool	GUIToData(int& nType, LPVOID& pData);

	bool			OneConditionToNumControl(TreeNode& tn, CustomColumnFilterConditionData& data);
	
private:	
	int							m_nEntry;
	CustomColumnFilterData		m_data;
	string						m_strVal[CUSTOM_COLUMN_FILTER_CONDITION_NUM];
};

class SimpleColumnFilterNumericBetweenDlg : public SimpleColumnFilterDlg
{
public:
	SimpleColumnFilterNumericBetweenDlg(const Column& col);
	~SimpleColumnFilterNumericBetweenDlg();

protected:
	virtual	void	InitDlg();
	virtual bool	DataToGUI(int nType, LPVOID pData);
	virtual bool	GUIToData(int& nType, LPVOID& pData);

private:
	DatasetFuncColumnFilterData	m_data;
	string						m_strFunc;
	string						m_strArgs;
};

class SimpleColumnFilterDateTimeGeneralDlg : public SimpleColumnFilterDlg
{
public:
	SimpleColumnFilterDateTimeGeneralDlg(const Column& col, int nEntry);
	~SimpleColumnFilterDateTimeGeneralDlg();

protected:
	virtual void	InitSettings();
	virtual	void	InitDlg();
	virtual bool	DataToGUI(int nType, LPVOID pData);
	virtual bool	GUIToData(int& nType, LPVOID& pData);
	
	bool			OneConditionToDateTimeControl(TreeNode& tn, CustomColumnFilterConditionData& data);

private:
	bool						m_bTime;
	string						m_strDisplayFmt;
	string						m_strFuncFmt;	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	bool						m_bForDateTimePicker;
	int							m_nEntry;
	CustomColumnFilterData		m_data;
	string						m_strValue[CUSTOM_COLUMN_FILTER_CONDITION_NUM];
};

class SimpleColumnFilterDateTimeBetweenDlg : public SimpleColumnFilterDlg
{
public:
	SimpleColumnFilterDateTimeBetweenDlg(const Column& col);
	~SimpleColumnFilterDateTimeBetweenDlg();

protected:
	virtual void	InitSettings();
	virtual	void	InitDlg();
	virtual bool	DataToGUI(int nType, LPVOID pData);
	virtual bool	GUIToData(int& nType, LPVOID& pData);

private:
	bool						m_bTime;
	string						m_strDisplayFmt;
	string						m_strFuncFmt;	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	bool						m_bForDateTimePicker;
	DatasetFuncColumnFilterData	m_data;
	string						m_strFunc;
	string						m_strArgs;
};

class SimpleColumnFilterNumericTopNBottomNDlg : public SimpleColumnFilterDlg
{
public:
	SimpleColumnFilterNumericTopNBottomNDlg(const Column& col, int nEntry);
	~SimpleColumnFilterNumericTopNBottomNDlg();

protected:
	virtual	void	InitDlg();
	virtual bool	DataToGUI(int nType, LPVOID pData);
	virtual bool	GUIToData(int& nType, LPVOID& pData);

private:
	int							m_nEntry;
	DatasetFuncColumnFilterData	m_data;
	string						m_strFunc;
	string						m_strArgs;
};


