/*------------------------------------------------------------------------------*
 * File Name: SimpleColumnFilterDlg.cpp											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 08/06/2012 ORG-6266-S4 SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL
 *	Folger 08/09/2012 ORG-6490-P1 TOP_BOTTOM_FILTER_SHOULD_FOLLOW_MENU_ITEM_SELECTED
 *	Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
 *	Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG				*
 *	Zech 09/18/2012 ORG-6865-S1 SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER		*
 *	Zech 09/20/2012 ORG-6818-P4 DATA_FILTER_SHOULD_NOT_CLEAR_YYMMDD_DATA_IF_ONE_OF_THEM_IS_IN_FORMAT
 *	Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <GetNBox.h>
#include <ocu.h>		/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
#include <o8dlg.h> ///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG

#include "SimpleColumnFilterDlg.h"
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define _RESET_UNSHOWN_DATETIME_DATA(_strFmt, _strPart, _data, _valInit)	\
	if (_strFmt.Find(_strPart) < 0)\
	_data = (_valInit)

/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
#define _GET_ORIGIN_DATE_TIME_FORMAT_FROM_DISPLAY_FORMAT(_strDisFmt, _bPicker)	(_strDisFmt.Mid(_bPicker ? 0 : 1))
/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER

void	_trim_system_time_unshown_data(SYSTEMTIME& st, string strFmt)
{
	
	/// Zech 09/20/2012 ORG-6818-P4 DATA_FILTER_SHOULD_NOT_CLEAR_YYMMDD_DATA_IF_ONE_OF_THEM_IS_IN_FORMAT
	/*
	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "y",		st.wYear,			0);
	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "M",		st.wMonth,			1);
	*/
	/// END DATA_FILTER_SHOULD_NOT_CLEAR_YYMMDD_DATA_IF_ONE_OF_THEM_IS_IN_FORMAT
	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "ddd",		st.wDayOfWeek,		1);

	// Trim day data
	string strFmtTemp = strFmt;
	strFmtTemp.Replace("dddd", "");	
	strFmtTemp.Replace("ddd",  "");	
	
	/// Zech 09/20/2012 ORG-6818-P4 DATA_FILTER_SHOULD_NOT_CLEAR_YYMMDD_DATA_IF_ONE_OF_THEM_IS_IN_FORMAT
	//_RESET_UNSHOWN_DATETIME_DATA(strFmtTemp, "d",		st.wDay,			1);
	if (strFmt.Find("y") < 0 && strFmt.Find("M") < 0 && strFmt.Find("d") < 0)
	{
		st.wYear 	= 0;
		st.wMonth 	= 1;
		st.wDay 	= 1;
	}
	/// END DATA_FILTER_SHOULD_NOT_CLEAR_YYMMDD_DATA_IF_ONE_OF_THEM_IS_IN_FORMAT
	// Trim hour data
	if (strFmt.Find("h") < 0 && strFmt.Find("H") < 0)
		st.wHour = 0;

	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "m",		st.wMinute,			0);
	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "s",		st.wSecond,			0);
	_RESET_UNSHOWN_DATETIME_DATA(strFmt, "#",		st.wMilliseconds,	0);
}

string _get_date_time_func_string(double dDateTime, const string& strDisplayFmt, bool bTime)
{
	string	strRet,
			strFunc		= bTime ? "Time" : "Date",
			strDisplay	= bTime ? get_time_str(dDateTime, LTF_OBJ_CUSTOM, strDisplayFmt) : get_date_str(dDateTime, LDF_OBJ_CUSTOM, strDisplayFmt);
	strRet.Format("%s(\"%s\",\"%s\")", strFunc, strDisplay, strDisplayFmt);
	return strRet;
}

/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
#define		STR_DATE_TIME_FORMAT	"DateTimeFormat"
/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
#define		STR_DATA_FILTER_DATE_TIME_FUNC_HINT		(_L("The correct format should be:"))	
/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER

int _date_time_general_dlg_event(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	BOOL bTime;
	string strDisplayFmt;
	if (tr.GetAttribute(STR_DATE_TIME_FORMAT, strDisplayFmt))
	{
		int nLoop = SIMPLECOLUMNFILTER_LOGIC_NONE == tr.Condition2.nVal ? 1 : 2;
		double dVal[2];
		dVal[0] = tr.Time1.dVal;
		dVal[1] = tr.Time2.dVal;

		for (int ii = 0; ii < nLoop; ii++)
		{
			if (NANUM == dVal[ii])
			{
				/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
				//ocu_load_err_msg_str(CER_INVALID_DATE_TIME_DATA, strErrMsg);
				string strErrTemp;
				ocu_load_err_msg_str(CER_INVALID_DATE_TIME_DATA, strErrTemp);
				strErrMsg.Format("%s. %s %s", strErrTemp, STR_DATA_FILTER_DATE_TIME_FUNC_HINT, strDisplayFmt);
				/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
				O_SET_BIT(dwEnables, GETNGEVT_OK_ENABLE, FALSE);
			}
		}
	}

	return true;
}

int _date_time_between_dlg_event(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	bool bTime;
	string strDisplayFmt;
	if (tr.GetAttribute(STR_DATE_TIME_FORMAT, strDisplayFmt))
	{
		double	dTimeFrom	= tr.TimeFrom.dVal,
				dTimeTo		= tr.TimeTo.dVal;
		if (NANUM == dTimeFrom || NANUM == dTimeTo)
		{
			/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
			//ocu_load_err_msg_str(CER_INVALID_DATE_TIME_DATA, strErrMsg);
			string strErrTemp;
			ocu_load_err_msg_str(CER_INVALID_DATE_TIME_DATA, strErrTemp);
			strErrMsg.Format("%s. %s %s", strErrTemp, STR_DATA_FILTER_DATE_TIME_FUNC_HINT, strDisplayFmt);
			/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
			O_SET_BIT(dwEnables, GETNGEVT_OK_ENABLE, FALSE);
		}
	}
	
	return true;
}
/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID

/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
int			_get_millisecond_format_char_count_in_date_format(LPCSTR lpcszFmt)
{
	int nPos = find_exposed_char_pos(lpcszFmt, '#');
	if	(nPos < 0)
		return 0;

	// '#' found, return the count
	int	ii;
	for (ii = nPos; '\0' != lpcszFmt[ii]; ++ii)
	{
		if ('#' != lpcszFmt[ii])
			break;
	}

	return ii - nPos;
}

static	string	_get_full_date_format_string(int nMillisecond)
{
	string strFmt;
	strFmt.Format("%s %s", get_date_format_str(LDF_SHORT), "HH:mm:ss");
	if (nMillisecond > 0)
	{
		string strMillisecond, strTemp('#', nMillisecond);
		strMillisecond.Format(":%s", strTemp);

		strFmt += strMillisecond;
	}	
		
	return strFmt;
}
/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER

/// Zech 09/18/2012 ORG-6865-S1 SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
static	string	_get_time_format_string(int nFormat)
{
	CurrentDateTimeDisplayHelper dtHelper;
	string str = dtHelper.TimeList();
	str.Replace("pm", "tt");
	return str.GetToken(nFormat, '|');
}

/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
//void	_dialog_get_date_time_info(Column& col, bool& bTime, string& strFmt, bool& bForDateTimePicker)
void	_dialog_get_date_time_info(Column& col, bool& bTime, string& strDisplayFmt, string& strFuncFmt, bool& bForDateTimePicker)
/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
{
	bTime = (col.GetFormat() == OKCOLTYPE_TIME);
	int nSubFmt = col.GetSubFormat();
	if (bTime)
	{
		bForDateTimePicker = false;
		/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		//strFmt = "T" + ((LTF_OBJ_CUSTOM == nSubFmt) ? col.GetCustomDisplay() : _get_time_format_string(nSubFmt));
		strFuncFmt = ((LTF_OBJ_CUSTOM == nSubFmt) ? col.GetCustomDisplay() : _get_time_format_string(nSubFmt));
		strDisplayFmt = "T" + strFuncFmt;
		/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	}
	else
	{
		/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		//bForDateTimePicker = true;
		//get_lt_datetime_display_format(col, strFmt, bForDateTimePicker);
		string strDateFmt;
		if (LDF_OBJ_CUSTOM == nSubFmt)
		{
			strDateFmt = col.GetCustomDisplay();
		}
		else
		{
			switch (nSubFmt)
			{
			case LDF_ALPHAWEEKDAY_1CHR:
				nSubFmt = LDF_ALPHAWEEKDAY_3CHR;
				break;
			case LDF_ALPHAMON_1CHR:
				nSubFmt = LDF_ALPHAMON_3CHR;
				break;
			case LDF_QUARTER:
				nSubFmt = LDF_SHORT;
				break;
			}

			strDateFmt = get_date_format_str(nSubFmt);
		}

		int nMsCount = _get_millisecond_format_char_count_in_date_format(strDateFmt);
		strFuncFmt = _get_full_date_format_string(nMsCount);
		if (nMsCount > 0)
		{
			strDisplayFmt = "D" + strFuncFmt;
			bForDateTimePicker = false;
		}
		else
		{
			strDisplayFmt = strDateFmt;
			bForDateTimePicker = true;
		}
		/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	}
}
/// END SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterDlg

/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
//SimpleColumnFilterDlg::SimpleColumnFilterDlg(const Column& col)
SimpleColumnFilterDlg::SimpleColumnFilterDlg(const Column& col, PEVENT_GETN pfnEvent/*= NULL*/)
/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
{
	m_col = col;
	m_pfnEvent = pfnEvent;		/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	m_tr.AddNode("trRoot");
}

SimpleColumnFilterDlg::~SimpleColumnFilterDlg()
{
}

bool	SimpleColumnFilterDlg::DoDlg()
{
	InitSettings();

	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	//if (GetNBox(m_tr.trRoot, m_strTitle))
	if (GetNBox(m_tr.trRoot, m_pfnEvent, m_strTitle))
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	{
		int						nType;
		LPVOID					data;
		UndoBlock				ub;
		if (GUIToData(nType, data) && m_col.SetFilter(nType, &data, TRUE))
		{
			if (!m_col.IsFilterDisabled())
			{
				Worksheet	wks;
				m_col.GetParent(wks);
				wks.RunFilter(0, 0, -1, true);
			}

			return true;
		}
	}
	
	return false;
}

void	SimpleColumnFilterDlg::InitSettings()
{
	int nType;
	LPVOID pData;
	if (m_col.GetFilter(nType, &pData))
		DataToGUI(nType, pData);
}

enum
{
	SIMPLECOLUMNFILTER_LOGIC_NONE						= 0,
	SIMPLECOLUMNFILTER_LOGIC_ALL_AND,
	SIMPLECOLUMNFILTER_LOGIC_ALL_OR,
};

#define LOGIC_CUSTOM_ENUM_TO_COMBO_ENUM(_enum) ((_enum) == CUSTOM_COLUMN_FILTER_LOGIC_ALL_OR ? SIMPLECOLUMNFILTER_LOGIC_ALL_OR : SIMPLECOLUMNFILTER_LOGIC_ALL_AND)
#define LOGIC_COMBO_ENUM_TO_CUSTOM_ENUM(_enum) ((_enum) == SIMPLECOLUMNFILTER_LOGIC_ALL_OR ? CUSTOM_COLUMN_FILTER_LOGIC_ALL_OR : CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND)

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterNumericGeneralDlg

// Please keep these enum in the same order as those in CustomColumnFilterConditionFormulaType
enum
{
	SIMPLECOLUMNFILTER_NUMERIC_LIST_NONE				= -1,
	
	SIMPLECOLUMNFILTER_NUMERIC_LIST_BEGIN				= 0,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL				= SIMPLECOLUMNFILTER_NUMERIC_LIST_BEGIN,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_NOT_EQUAL,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_LARGER,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_LARGER_OR_EQUAL,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_LESS,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_LESS_OR_EUQAL,
	SIMPLECOLUMNFILTER_NUMERIC_LIST_END,	
};

#define STR_NUMERIC_FORMULA_TYPES_COMBO_ITMES	_L("equals|does not equal|is greater than|is greater than or equal to\
	|is less than|is less than or equal to")

#define NUMERIC_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(_enum)		((_enum) - CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_EQUAL + SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL)
#define NUMERIC_FORMULA_COMBO_ENUM_TO_CUSTOM_ENUM(_enum)		((_enum) - SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL + CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_EQUAL)
	
SimpleColumnFilterNumericGeneralDlg::SimpleColumnFilterNumericGeneralDlg(const Column& col, int nEntry) 
	: SimpleColumnFilterDlg(col)
{
	m_nEntry = nEntry;
	InitDlg();
}

SimpleColumnFilterNumericGeneralDlg::~SimpleColumnFilterNumericGeneralDlg()
{
}

static bool _on_numeric_condition2_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	tr.FormulaType2.Show = tr.Value2.Show = trNode.nVal != 0;
	return true;
}
	
//virtual	
void	SimpleColumnFilterNumericGeneralDlg::InitDlg()
{
	m_strTitle = _L("Simple Numeric Filter");
	double	dSel = 0;
	switch (m_nEntry)
	{
	case ColumnFilterMenuEntry_Equal:
		dSel = SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL;
		break;
	case ColumnFilterMenuEntry_LessThan:
		dSel = SIMPLECOLUMNFILTER_NUMERIC_LIST_LESS;
		break; 
	case ColumnFilterMenuEntry_GreaterThan:
		dSel = SIMPLECOLUMNFILTER_NUMERIC_LIST_LARGER;
		break;
	default:
		ASSERT(FALSE);
	}

	///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	m_tr.trRoot.SetAttribute(STR_HELPID_ATTRIB, IDD_SIMPLE_FILTER_DLG_NUMERIC);
	///------ End ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	GETN_USE(m_tr.trRoot)
	GETN_LIST(FormulaType1, _L("Formula Type"), dSel, STR_NUMERIC_FORMULA_TYPES_COMBO_ITMES)
	GETN_NUM(Value1, _L("Value"), 0); GETN_SET_DEFAULT_FOCUS ///------ Folger 08/06/2012 ORG-6266-S4 SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL
	GETN_LIST(Condition2, _L("Condition2"), SIMPLECOLUMNFILTER_LOGIC_NONE, _L("None|And|Or")) GETN_OPTION_EVENT_EX(_on_numeric_condition2_change)
	GETN_LIST(FormulaType2, _L("Formula Type"), SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL, STR_NUMERIC_FORMULA_TYPES_COMBO_ITMES)
	GETN_NUM(Value2, _L("Value"), 0);
}

//virtual
bool	SimpleColumnFilterNumericGeneralDlg::DataToGUI(int nType, LPVOID pData)
{
	if (COLUMN_FILTER_TYPE_CUSTOM == nType)
	{
		CustomColumnFilterData *pCustomData = (CustomColumnFilterData*) pData;
		
		int nObjType1 = pCustomData->cond[0].nObjType,
			nObjType2 = pCustomData->cond[1].nObjType,
			nFormulaType1 = pCustomData->cond[0].nFormulaType,
			nFormulaType2 = pCustomData->cond[1].nFormulaType;
		
		if ( CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC == nObjType1
			&& (CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC == nObjType2 || CUSTOM_COLUMN_FILTER_OBJECT_NONE == nObjType2))
		{
			bool	bInit = false;
			switch (m_nEntry)
			{
			case ColumnFilterMenuEntry_Equal:
				bInit = CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_EQUAL == nFormulaType1 || CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_NOT_EQUAL == nFormulaType1;
				break;
			case ColumnFilterMenuEntry_LessThan:
				bInit = CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_LESS == nFormulaType1 || CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_LESS_OR_EUQAL == nFormulaType1;
				break; 
			case ColumnFilterMenuEntry_GreaterThan:
				bInit = CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_LARGER == nFormulaType1 || CUSTOM_COLUMN_FILTER_FORMULA_NUMERIC_LARGER_OR_EQUAL == nFormulaType1;
				break;
			default:
				ASSERT(FALSE);
				return false;
			}
			
			if (bInit)
			{
				m_tr.trRoot.FormulaType1.dVal = NUMERIC_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(nFormulaType1);
				OneConditionToNumControl(m_tr.trRoot.Value1, pCustomData->cond[0]);

				if (CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC == nObjType2)
				{
					m_tr.trRoot.Condition2.nVal = LOGIC_CUSTOM_ENUM_TO_COMBO_ENUM(pCustomData->nLogic);

					m_tr.trRoot.FormulaType2.dVal = NUMERIC_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(nFormulaType2);
					OneConditionToNumControl(m_tr.trRoot.Value2, pCustomData->cond[1]);
				}

				return true;
			}
		}
	}
	
	return false;
}

//virtual
bool	SimpleColumnFilterNumericGeneralDlg::GUIToData(int& nType, LPVOID& pData)
{
	nType = COLUMN_FILTER_TYPE_CUSTOM;
	int nLoop = 2;
	double	dCombo[2];
	
	TreeNode tn = m_tr.trRoot;
	dCombo[0] = tn.FormulaType1.dVal;
	dCombo[1] = tn.FormulaType2.dVal;
	m_strVal[0] = ftoa(tn.Value1.dVal);
	m_strVal[1] = ftoa(tn.Value2.dVal);
	
	if (SIMPLECOLUMNFILTER_LOGIC_NONE == tn.Condition2.nVal)
	{
		nLoop = 1;
		m_data.cond[1].nObjType = CUSTOM_COLUMN_FILTER_FORMULA_NONE;
		m_data.nLogic = CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND;
	}
	else
	{
		m_data.nLogic = LOGIC_COMBO_ENUM_TO_CUSTOM_ENUM(tn.Condition2.nVal);
	}
	
	for (int ii = 0; ii < nLoop; ii++)
	{
		m_data.cond[ii].nObjType = CUSTOM_COLUMN_FILTER_OBJECT_NUMERIC;
		m_data.cond[ii].nFormulaType = NUMERIC_FORMULA_COMBO_ENUM_TO_CUSTOM_ENUM(dCombo[ii]);
		m_data.cond[ii].lpcszValue = m_strVal[ii];
		m_data.cond[ii].dValue = 0;
		m_data.cond[ii].dwOption = 0;
	}
	
	pData = &m_data;
	return true;
}

bool	SimpleColumnFilterNumericGeneralDlg::OneConditionToNumControl(TreeNode& tn, CustomColumnFilterConditionData& data)
{
	if (O_QUERY_BOOL(data.dwOption, CUSTOM_COLUMN_FILTER_OPTION_USING_DOUBLE))
		tn.dVal =data.dValue;
	else
	{
		if (NULL == data.lpcszValue && 0 == *data.lpcszValue)
			return false;

		tn.strVal = data.lpcszValue;
	}

	return true;
}

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterNumericBetweenDlg

SimpleColumnFilterNumericBetweenDlg::SimpleColumnFilterNumericBetweenDlg(const Column& col)
	: SimpleColumnFilterDlg(col)
{
	InitDlg();
}

SimpleColumnFilterNumericBetweenDlg::~SimpleColumnFilterNumericBetweenDlg()
{
}

//virtual
void	SimpleColumnFilterNumericBetweenDlg::InitDlg()
{
	m_strTitle = _L("Between");

	vectorbase& vv = m_col.GetDataObject();
	double rMin, rMax;
	vv.GetMinMax(rMin, rMax);
	
	///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	m_tr.trRoot.SetAttribute(STR_HELPID_ATTRIB, IDD_SIMPLE_FILTER_DLG_NUMERIC);
	///------ End ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	GETN_USE(m_tr.trRoot)
	GETN_NUM(ValueFrom, _L("From"), rMin);
	GETN_NUM(ValueTo, _L("To"), rMax);
}

//virtual
bool	SimpleColumnFilterNumericBetweenDlg::DataToGUI(int nType, LPVOID pData)
{
	if (COLUMN_FILTER_TYPE_DATASET_FUNC == nType)
	{
		DatasetFuncColumnFilterData *pDataseetData = (DatasetFuncColumnFilterData*) pData;
		if (0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_BETWEEN))
		{
			StringArray arrArgs;
			string strArgs(pDataseetData->lpcszArgs);
			if (2 == strArgs.GetTokens(arrArgs, ','))
			{
				bool	bAllNumeric = true;
				for (int ii = 0; ii < 2; ++ii)
				{
					arrArgs[ii].TrimLeft();
					arrArgs[ii].TrimRight();
					if (!is_numeric(arrArgs[ii]))
					{
						bAllNumeric = false;
						break;
					}
				}

				if (bAllNumeric)
				{
					m_tr.trRoot.ValueFrom.dVal = atof(arrArgs[0]);
					m_tr.trRoot.ValueTo.dVal = atof(arrArgs[1]);
					return true;
				}
			}
		}
	}

	return false;
}

static string _convert_dataset_filter_function(LPCSTR lpcszFunc)
{
	string strFunc = lpcszFunc;
	strFunc.MakeLower();
	return strFunc;
}

//virtual
bool	SimpleColumnFilterNumericBetweenDlg::GUIToData(int& nType, LPVOID& pData)
{
	nType = COLUMN_FILTER_TYPE_DATASET_FUNC;
	m_strFunc = STR_SERIES_FITLER_FUNC_BETWEEN;
	m_strArgs.Format("%s,%s", ftoa(m_tr.trRoot.ValueFrom.dVal), ftoa(m_tr.trRoot.ValueTo.dVal));
	m_data.lpcszFunc = m_strFunc;
	m_data.lpcszArgs = m_strArgs;

	pData = &m_data;
	return true;
}

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterDateTimeGeneralDlg

#define STR_DATETIME_FUNC_DATE		"Date"
#define STR_DATETIME_FUNC_TIME		"Time"

enum
{
	SIMPLECOLUMNFILTER_DATETIME_LIST_NONE				= -1,

	SIMPLECOLUMNFILTER_DATETIME_LIST_BEGIN				= 0,
	SIMPLECOLUMNFILTER_DATETIME_LIST_IS				= SIMPLECOLUMNFILTER_NUMERIC_LIST_BEGIN,
	SIMPLECOLUMNFILTER_DATETIME_LIST_IS_NOT,
	SIMPLECOLUMNFILTER_DATETIME_LIST_AFTER,
	SIMPLECOLUMNFILTER_DATETIME_LIST_ON_OR_AFTER,
	SIMPLECOLUMNFILTER_DATETIME_LIST_BEFORE,
	SIMPLECOLUMNFILTER_DATETIME_LIST_ON_OR_BEFORE,
	SIMPLECOLUMNFILTER_DATETIME_LIST_END,	
};

#define STR_DATE_FORMULA_TYPES_COMBO_ITMES	_L("equals|does not equal|after|on or after|before|on or before")

#define DATETIME_FORMULA_CUSTOM_ENUM(_btime)							(_btime ? CUSTOM_COLUMN_FILTER_FORMULA_TIME_IS : CUSTOM_COLUMN_FILTER_FORMULA_DATE_IS)
#define DATETIME_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(_enum, _btime)		((_enum) - DATETIME_FORMULA_CUSTOM_ENUM(_btime) + SIMPLECOLUMNFILTER_DATETIME_LIST_IS)
#define DATETIME_FORMULA_COMBO_ENUM_TO_CUSTOM_ENUM(_enum, _btime)		((_enum) - SIMPLECOLUMNFILTER_DATETIME_LIST_IS + DATETIME_FORMULA_CUSTOM_ENUM(_btime))

SimpleColumnFilterDateTimeGeneralDlg::SimpleColumnFilterDateTimeGeneralDlg(const Column& col, int nEntry) 
	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	//: SimpleColumnFilterDlg(col)
	: SimpleColumnFilterDlg(col, _date_time_general_dlg_event)
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
{
	m_nEntry = nEntry;
	/// Zech 09/18/2012 ORG-6865-S1 SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	//m_bForDateTimePicker = true;
	//m_bTime = get_lt_datetime_display_format(m_col, m_strDisplayFmt, m_bForDateTimePicker) == LT_FORMAT_TIME;
	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	//_dialog_get_date_time_info(m_col, m_bTime, m_strDisplayFmt, m_bForDateTimePicker);
	_dialog_get_date_time_info(m_col, m_bTime, m_strDisplayFmt, m_strFuncFmt, m_bForDateTimePicker);
	/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	/// END SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	InitDlg();
}

SimpleColumnFilterDateTimeGeneralDlg::~SimpleColumnFilterDateTimeGeneralDlg()
{
}

static bool _on_datetime_condition2_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	tr.FormulaType2.Show = tr.Time2.Show = trNode.nVal != 0;
	return true;
}

//virtual
void	SimpleColumnFilterDateTimeGeneralDlg::InitSettings()
{
	/// Zech 09/18/2012 ORG-6865-S1 SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	if (!m_bTime)
	/// END SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	{
		SYSTEMTIME st;
		get_current_time(st);

		_trim_system_time_unshown_data(st, m_strDisplayFmt);

		double dDate;
		SystemTimeToJulianDate(&dDate, &st);
		m_tr.trRoot.Time1.dVal = dDate;
		m_tr.trRoot.Time2.dVal = dDate;
	}
	
	set_node_datetime_picker(m_tr.trRoot.Time1, m_strDisplayFmt, !m_bTime, m_bForDateTimePicker);
	set_node_datetime_picker(m_tr.trRoot.Time2, m_strDisplayFmt, !m_bTime, m_bForDateTimePicker);

	SimpleColumnFilterDlg::InitSettings();
}

//virtual	
void	SimpleColumnFilterDateTimeGeneralDlg::InitDlg()
{
	m_strTitle = _L("Simple Date Filter");
	double	dSel = 0;
	switch (m_nEntry)
	{
	case ColumnFilterMenuEntry_Equal:
		dSel = SIMPLECOLUMNFILTER_DATETIME_LIST_IS;
		break;
	case ColumnFilterMenuEntry_LessThan:
		dSel = SIMPLECOLUMNFILTER_DATETIME_LIST_BEFORE;
		break; 
	case ColumnFilterMenuEntry_GreaterThan:
		dSel = SIMPLECOLUMNFILTER_DATETIME_LIST_AFTER;
		break;
	default:
		ASSERT(FALSE);
	}

	///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	m_tr.trRoot.SetAttribute(STR_HELPID_ATTRIB, IDD_SIMPLE_FILTER_DLG_DATETIME);
	///------ End ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	if (!m_bTime)
	{
		GETN_USE(m_tr.trRoot)
		GETN_LIST(FormulaType1, _L("Formula Type"), dSel, STR_DATE_FORMULA_TYPES_COMBO_ITMES)
		GETN_DATE(Time1, _L("Value"), 0); GETN_SET_DEFAULT_FOCUS
		GETN_LIST(Condition2, _L("Condition2"), SIMPLECOLUMNFILTER_LOGIC_NONE, _L("None|And|Or")) GETN_OPTION_EVENT_EX(_on_datetime_condition2_change)
		GETN_LIST(FormulaType2, _L("Formula Type"), SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL, STR_DATE_FORMULA_TYPES_COMBO_ITMES)
		GETN_DATE(Time2, _L("Value"), 0)
	}
	else
	{
		GETN_USE(m_tr.trRoot)
		GETN_LIST(FormulaType1, _L("Formula Type"), dSel, STR_DATE_FORMULA_TYPES_COMBO_ITMES)
		GETN_TIME(Time1, _L("Value"), 0)
		GETN_LIST(Condition2, _L("Condition2"), 0, _L("None|And|Or")) GETN_OPTION_EVENT_EX(_on_datetime_condition2_change)
		GETN_LIST(FormulaType2, _L("Formula Type"), SIMPLECOLUMNFILTER_NUMERIC_LIST_EQUAL, STR_DATE_FORMULA_TYPES_COMBO_ITMES)
		GETN_TIME(Time2, _L("Value"), 0)
	}
	
	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	//m_tr.trRoot.SetAttribute(STR_DATE_TIME_FORMAT, m_strDisplayFmt);
	m_tr.trRoot.SetAttribute(STR_DATE_TIME_FORMAT, _GET_ORIGIN_DATE_TIME_FORMAT_FROM_DISPLAY_FORMAT(m_strDisplayFmt, m_bForDateTimePicker));
	/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
}

#define IS_CUSTOM_COLUMN_FILTER_OBJECT_DATETIME(_ObjType) (CUSTOM_COLUMN_FILTER_OBJECT_DATE == (_ObjType) || CUSTOM_COLUMN_FILTER_OBJECT_TIME == (_ObjType))

//virtual
bool	SimpleColumnFilterDateTimeGeneralDlg::DataToGUI(int nType, LPVOID pData)
{
	if (COLUMN_FILTER_TYPE_CUSTOM == nType)
	{
		CustomColumnFilterData *pCustomData = (CustomColumnFilterData*) pData;

		int nObjType1 = pCustomData->cond[0].nObjType,
			nObjType2 = pCustomData->cond[1].nObjType,
			nFormulaType1 = pCustomData->cond[0].nFormulaType,
			nFormulaType2 = pCustomData->cond[1].nFormulaType;

		if ( IS_CUSTOM_COLUMN_FILTER_OBJECT_DATETIME(nObjType1)
			&& (IS_CUSTOM_COLUMN_FILTER_OBJECT_DATETIME(nObjType2) || CUSTOM_COLUMN_FILTER_OBJECT_NONE == nObjType2))
		{
			bool	bInit = false;
			int		nComboEnum = DATETIME_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(nFormulaType1, CUSTOM_COLUMN_FILTER_OBJECT_TIME == nObjType1);
			switch (m_nEntry)
			{
			case ColumnFilterMenuEntry_Equal:
				bInit = SIMPLECOLUMNFILTER_DATETIME_LIST_IS == nComboEnum || SIMPLECOLUMNFILTER_DATETIME_LIST_IS_NOT == nComboEnum;
				break;
			case ColumnFilterMenuEntry_LessThan:
				bInit = SIMPLECOLUMNFILTER_DATETIME_LIST_BEFORE == nComboEnum || SIMPLECOLUMNFILTER_DATETIME_LIST_ON_OR_BEFORE == nComboEnum;
				break; 
			case ColumnFilterMenuEntry_GreaterThan:
				bInit = SIMPLECOLUMNFILTER_DATETIME_LIST_AFTER == nComboEnum || SIMPLECOLUMNFILTER_DATETIME_LIST_ON_OR_AFTER == nComboEnum;
				break;
			default:
				ASSERT(FALSE);
				return false;
			}

			if (bInit)
			{
				m_tr.trRoot.FormulaType1.dVal = DATETIME_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(nFormulaType1, CUSTOM_COLUMN_FILTER_OBJECT_TIME == nObjType1);
				OneConditionToDateTimeControl(m_tr.trRoot.Time1, pCustomData->cond[0]);

				if (IS_CUSTOM_COLUMN_FILTER_OBJECT_DATETIME(nObjType2))
				{
					m_tr.trRoot.Condition2.nVal = LOGIC_CUSTOM_ENUM_TO_COMBO_ENUM(pCustomData->nLogic);
					
					m_tr.trRoot.FormulaType2.dVal = DATETIME_FORMULA_CUSTOM_ENUM_TO_COMBO_ENUM(nFormulaType2, CUSTOM_COLUMN_FILTER_OBJECT_TIME == nObjType2);
					OneConditionToDateTimeControl(m_tr.trRoot.Time2, pCustomData->cond[1]);
				}

				return true;
			}
		}
	}

	return false;
}

//virtual
bool	SimpleColumnFilterDateTimeGeneralDlg::GUIToData(int& nType, LPVOID& pData)
{
	nType = COLUMN_FILTER_TYPE_CUSTOM;
	int nLoop = 2;
	double	dCombo[2], dValue[2];

	TreeNode tn = m_tr.trRoot;
	dCombo[0] = tn.FormulaType1.dVal;
	dCombo[1] = tn.FormulaType2.dVal;
	dValue[0] = tn.Time1.dVal;
	dValue[1] = tn.Time2.dVal;

	if (SIMPLECOLUMNFILTER_LOGIC_NONE == tn.Condition2.nVal)
	{
		nLoop = 1;
		m_data.cond[1].nObjType = CUSTOM_COLUMN_FILTER_FORMULA_NONE;
		m_data.nLogic = CUSTOM_COLUMN_FILTER_LOGIC_ALL_AND;
	}
	else
		m_data.nLogic = LOGIC_COMBO_ENUM_TO_CUSTOM_ENUM(tn.Condition2.nVal);

	for (int ii = 0; ii < nLoop; ii++)
	{
		/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		//string	strFunc, strTime, strDisplayFmt = m_strDisplayFmt.Mid(m_bForDateTimePicker ? 0 : 1);
		string	strFunc, strTime;
		/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER

		if (m_bTime)
		{
			m_data.cond[ii].nObjType = CUSTOM_COLUMN_FILTER_OBJECT_TIME;
			strFunc = STR_DATETIME_FUNC_TIME;
			/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
			//strTime = get_time_str(dValue[ii], LTF_OBJ_CUSTOM, strDisplayFmt);
			strTime = get_time_str(dValue[ii], LTF_OBJ_CUSTOM, m_strFuncFmt);
			/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		}
		else
		{
			m_data.cond[ii].nObjType = CUSTOM_COLUMN_FILTER_OBJECT_DATE;
			strFunc = STR_DATETIME_FUNC_DATE;
			/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
			//strTime = get_date_str(dValue[ii], LDF_OBJ_CUSTOM, strDisplayFmt);
			strTime = get_date_str(dValue[ii], LDF_OBJ_CUSTOM, m_strFuncFmt);
			/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		}
		m_data.cond[ii].nFormulaType = DATETIME_FORMULA_COMBO_ENUM_TO_CUSTOM_ENUM(dCombo[ii], m_bTime);
		
		/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		//m_strValue[ii].Format("%s(\"%s\", \"%s\")", strFunc, strTime, strDisplayFmt);
		m_strValue[ii].Format("%s(\"%s\", \"%s\")", strFunc, strTime, m_strFuncFmt);
		/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
		m_data.cond[ii].lpcszValue = m_strValue[ii];
		m_data.cond[ii].dValue = 0;
		m_data.cond[ii].dwOption = 0;		
	}


	pData = &m_data;
	return true;
}

bool	SimpleColumnFilterDateTimeGeneralDlg::OneConditionToDateTimeControl(TreeNode& tn, CustomColumnFilterConditionData& data)
{
	if (O_QUERY_BOOL(data.dwOption, CUSTOM_COLUMN_FILTER_OPTION_USING_DOUBLE))
		tn.dVal =data.dValue;
	else
	{
		if (NULL == data.lpcszValue && 0 == *data.lpcszValue)
			return false;

		double dTime;
		if (!LT_evaluate(data.lpcszValue, &dTime))
			return false;

		tn.dVal = dTime;
	}
	
	return true;
}

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterDateTimeBetweenDlg

SimpleColumnFilterDateTimeBetweenDlg::SimpleColumnFilterDateTimeBetweenDlg(const Column& col)
	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	//: SimpleColumnFilterDlg(col)
	: SimpleColumnFilterDlg(col, _date_time_between_dlg_event)
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
{
	/// Zech 09/18/2012 ORG-6865-S1 SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	//m_bForDateTimePicker = true;
	//m_bTime = get_lt_datetime_display_format(m_col, m_strDisplayFmt, m_bForDateTimePicker) == LT_FORMAT_TIME;
	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	//_dialog_get_date_time_info(m_col, m_bTime, m_strDisplayFmt, m_bForDateTimePicker);
	_dialog_get_date_time_info(m_col, m_bTime, m_strDisplayFmt, m_strFuncFmt, m_bForDateTimePicker);
	/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	/// END SIMPLE_DATA_FILTER_DLG_CANCEL_TIME_PICKER
	InitDlg();
}

SimpleColumnFilterDateTimeBetweenDlg::~SimpleColumnFilterDateTimeBetweenDlg()
{
}

//virtual
void	SimpleColumnFilterDateTimeBetweenDlg::InitSettings()
{
	set_node_datetime_picker(m_tr.trRoot.TimeFrom, m_strDisplayFmt, !m_bTime, m_bForDateTimePicker);
	set_node_datetime_picker(m_tr.trRoot.TimeTo, m_strDisplayFmt, !m_bTime, m_bForDateTimePicker);

	SimpleColumnFilterDlg::InitSettings();
}

//virtual	
void	SimpleColumnFilterDateTimeBetweenDlg::InitDlg()
{
	m_strTitle = _L("Between");

	vectorbase& vv = m_col.GetDataObject();
	double rMin, rMax;
	vv.GetMinMax(rMin, rMax);

	///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	m_tr.trRoot.SetAttribute(STR_HELPID_ATTRIB, IDD_SIMPLE_FILTER_DLG_DATETIME);
	///------ End ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	if (!m_bTime)
	{
		GETN_USE(m_tr.trRoot)
		GETN_DATE(TimeFrom, _L("From"), rMin)
		GETN_DATE(TimeTo, _L("To"), rMax)
	}
	else
	{
		GETN_USE(m_tr.trRoot)
		GETN_TIME(TimeFrom, _L("From"), rMin)
		GETN_TIME(TimeTo, _L("To"), rMax)
	}

	/// Zech 08/29/2012 ORG-5851-P10 SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	//m_tr.trRoot.SetAttribute(STR_DATE_TIME_FORMAT, m_strDisplayFmt);
	m_tr.trRoot.SetAttribute(STR_DATE_TIME_FORMAT, _GET_ORIGIN_DATE_TIME_FORMAT_FROM_DISPLAY_FORMAT(m_strDisplayFmt, m_bForDateTimePicker));
	/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	/// END SIMPLE_DATA_FILTER_DLG_SHOW_ERROR_MSG_IF_DATE_TIME_INVALID
}

//virtual
bool	SimpleColumnFilterDateTimeBetweenDlg::DataToGUI(int nType, LPVOID pData)
{
	if (COLUMN_FILTER_TYPE_DATASET_FUNC == nType)
	{
		DatasetFuncColumnFilterData *pDataseetData = (DatasetFuncColumnFilterData*) pData;
		if (0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_BETWEEN))
		{
			string	strArgs(pDataseetData->lpcszArgs);

			int		nTokenPos = find_exposed_char_pos(strArgs, ',');
			string	strArg1 = strArgs.Left(nTokenPos),
					strArg2 = strArgs.Mid(nTokenPos+1),
					strFunc = m_bTime ? STR_DATETIME_FUNC_TIME : STR_DATETIME_FUNC_DATE;

			if (strArg1.Find(strFunc) >= 0 && strArg2.Find(strFunc) >= 0)
			{
				double dTimeFrom, dTimeTo;
				if (LT_evaluate(strArg1, &dTimeFrom) && LT_evaluate(strArg2, &dTimeTo))
				{
					m_tr.trRoot.TimeFrom.dVal = dTimeFrom;
					m_tr.trRoot.TimeTo.dVal = dTimeTo;
					return true;
				}
			}
		}
	}

	return false;
}

//virtual
bool	SimpleColumnFilterDateTimeBetweenDlg::GUIToData(int& nType, LPVOID& pData)
{
	nType = COLUMN_FILTER_TYPE_DATASET_FUNC;
	m_strFunc = STR_SERIES_FITLER_FUNC_BETWEEN;

	double	dTimeFrom = m_tr.trRoot.TimeFrom.dVal,
			dTimeTo = m_tr.trRoot.TimeTo.dVal;
	
	/// Zech 09/24/2012 ORG-6818-P3 CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	/*
	string	strDisplayFmt = m_strDisplayFmt.Mid(m_bForDateTimePicker ? 0 : 1);
	
	string	strTimeFrom = m_bTime ? get_time_str(dTimeFrom, LTF_OBJ_CUSTOM, strDisplayFmt) : get_date_str(dTimeFrom, LDF_OBJ_CUSTOM, strDisplayFmt),
			strTimeTo = m_bTime ? get_time_str(dTimeTo, LTF_OBJ_CUSTOM, strDisplayFmt) : get_date_str(dTimeTo, LDF_OBJ_CUSTOM, strDisplayFmt),
			strArgFunc = m_bTime ? "Time" : "Date";
	m_strArgs.Format("%s, %s"
					, _get_date_time_func_string(dTimeFrom, strDisplayFmt, m_bTime)
					, _get_date_time_func_string(dTimeTo, strDisplayFmt, m_bTime)
					);
	*/
	string	strTimeFrom = m_bTime ? get_time_str(dTimeFrom, LTF_OBJ_CUSTOM, m_strFuncFmt) : get_date_str(dTimeFrom, LDF_OBJ_CUSTOM, m_strFuncFmt),
			strTimeTo = m_bTime ? get_time_str(dTimeTo, LTF_OBJ_CUSTOM, m_strFuncFmt) : get_date_str(dTimeTo, LDF_OBJ_CUSTOM, m_strFuncFmt),
			strArgFunc = m_bTime ? "Time" : "Date";
	m_strArgs.Format("%s, %s"
		, _get_date_time_func_string(dTimeFrom, m_strFuncFmt, m_bTime)
		, _get_date_time_func_string(dTimeTo, m_strFuncFmt, m_bTime)
		);
	/// END CHANGE_FROMAT_DESIGN_FOR_DATE_DATA_FILTER
	m_data.lpcszFunc = m_strFunc;
	m_data.lpcszArgs = m_strArgs;

	pData = &m_data;
	return true;
}

////////////////////////////////////////////////////////////////////////////////////
// SimpleColumnFilterNumericTopNBottomNDlg

enum
{
	TOPNCOLUMNFILTER_TOPN		= 0,
	TOPNCOLUMNFILTER_BOTTOMN,
};

enum
{
	TOPNCOLUMNFILTER_ITEMS		= 0,
	TOPNCOLUMNFILTER_PERCENT,
};

SimpleColumnFilterNumericTopNBottomNDlg::SimpleColumnFilterNumericTopNBottomNDlg(const Column& col, int nEntry)
	: SimpleColumnFilterDlg(col)
{
	m_nEntry = nEntry;
	InitDlg();
}

SimpleColumnFilterNumericTopNBottomNDlg::~SimpleColumnFilterNumericTopNBottomNDlg()
{
}

//virtual	
void	SimpleColumnFilterNumericTopNBottomNDlg::InitDlg()
{
	m_strTitle = _L("Top N");
	double	dSel = 0;
	switch(m_nEntry)
	{
	case ColumnFilterMenuEntry_TopN:
		dSel = TOPNCOLUMNFILTER_TOPN;
		break;
	case ColumnFilterMenuEntry_BottomN:
		dSel = TOPNCOLUMNFILTER_BOTTOMN;
		break;
	default:
		ASSERT(FALSE);
	}

	///------ Folger 09/19/2012 QA-1291-P1 ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	m_tr.trRoot.SetAttribute(STR_HELPID_ATTRIB, IDD_SIMPLE_FILTER_DLG_NUMERIC);
	///------ End ORIGIN_HELP_FOR_SIMPLE_FILTER_DLG
	GETN_USE(m_tr.trRoot)
	GETN_LIST(Collection, _L("Collection"), dSel, _L("Top|Bottom"));
	GETN_LIST(Items, _L("Items"), 0, _L("Items|Percent"));
	GETN_NUM(Number, _L("Number"), 10); GETN_SET_DEFAULT_FOCUS ///------ Folger 08/06/2012 ORG-6266-S4 SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL
}

//virtual
bool	SimpleColumnFilterNumericTopNBottomNDlg::DataToGUI(int nType, LPVOID pData)
{
	if (COLUMN_FILTER_TYPE_DATASET_FUNC == nType)
	{
		DatasetFuncColumnFilterData *pDataseetData = (DatasetFuncColumnFilterData*) pData;
		///------ Folger 08/09/2012 ORG-6490-P1 TOP_BOTTOM_FILTER_SHOULD_FOLLOW_MENU_ITEM_SELECTED
		//if (0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_TOPN))
			//m_tr.trRoot.Collection.dVal = TOPNCOLUMNFILTER_TOPN;
		//else if (0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_BOTTOMN))
			//m_tr.trRoot.Collection.dVal = TOPNCOLUMNFILTER_BOTTOMN;
		//else
			//return false;
		if (!(0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_TOPN) || 0 == _stricmp(pDataseetData->lpcszFunc, STR_SERIES_FITLER_FUNC_BOTTOMN)))
			return false;
		///------ End TOP_BOTTOM_FILTER_SHOULD_FOLLOW_MENU_ITEM_SELECTED

		StringArray arrArgs;
		string strArgs(pDataseetData->lpcszArgs);
		if (2 == strArgs.GetTokens(arrArgs, ','))
		{
			bool	bAllNumeric = true;
			for (int ii = 0; ii < 2; ++ii)
			{
				arrArgs[ii].TrimLeft();
				arrArgs[ii].TrimRight();
				if (!is_numeric(arrArgs[ii]))
				{
					bAllNumeric = false;
					break;
				}
			}

			if (bAllNumeric)
			{
				m_tr.trRoot.Number.dVal = atof(arrArgs[0]);
				m_tr.trRoot.Items.dVal = (0 == atoi(arrArgs[1])) ? TOPNCOLUMNFILTER_ITEMS : TOPNCOLUMNFILTER_PERCENT;
				return true;
			}
		}
	}
}

//virtual
bool	SimpleColumnFilterNumericTopNBottomNDlg::GUIToData(int& nType, LPVOID& pData)
{
	nType = COLUMN_FILTER_TYPE_DATASET_FUNC;
	switch ((int)m_tr.trRoot.Collection.dVal)
	{
	case TOPNCOLUMNFILTER_TOPN:
		m_strFunc = STR_SERIES_FITLER_FUNC_TOPN;
		break;
	case TOPNCOLUMNFILTER_BOTTOMN:
		m_strFunc = STR_SERIES_FITLER_FUNC_BOTTOMN;
		break;
	default:
		ASSERT(FALSE);
		return false;
	}

	m_strArgs.Format("%s,%d", ftoa(m_tr.trRoot.Number.dVal), 0 == m_tr.trRoot.Items.dVal ? 0 : 1);
	m_data.lpcszFunc = m_strFunc;
	m_data.lpcszArgs = m_strArgs;

	pData = &m_data;
	return true;
}