/*------------------------------------------------------------------------------*
 * File Name: ScriptExampleDlg.c												*
 * Creation: Jasmine 05/23/07 QA80-9815											*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 5/24/07 XF_INFO_NEED_FASTER_LOADING										*
 *	CPY 5/27/07 SCRIPT_SAMPLE_BETTER_FONT_NEEDED								*
 *	CPY 5/29/07 SHOW_BOLD_ON_BRANCH_IF_ANY_HAS_SCRIPTS							*
 *	CPY 5/31/07 SYS_XF_READ_ONLY												*
 *	Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO						*
 *	Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT							*
 *	CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS							*
 *	CPY 6/5/2007 RUN_SCRIPT_SHOULD_ADD_CR_TO_LF									*
 *	Jasmine 06/07/07 EDIT_USAGE													*
 *	CPY 6/7/2007 GET_HAS_SCRIPT_INFO_FROM_MAP									*
 *	CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME					*
 *	CPY 6/11/07 SAVE_BUTTON_NOT_CALLING_CENTRALIZED_CODE						*
 *	Jasmine 06/14/07 SET_CELL_STATE												*
 *	CPY 6/14/07 SCRIPT_SAMPLE_DLG_SWITCHING_LOCATION_AUTOMATION_ERR				*
 *	Folger 11/22/07 FIX_RUNTIME_ERROR_WHEN_NO_ROW_SELECTED						*
 *	CPY 11/24/2007 REPLACE_ALL_LOAD_WITH_LoadNoLocalize							*
 * Format 06/04/08 ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION						*
 *	Folger 07/15/08 QA80-11230 FIX_SCRIPT_EDIT_READONLY_WHEN_COMBO_CHANGE		*
 *	Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG		*
 *	Folger 07/15/08 QA80-11230 SHOULD_CLEAR_USAGE_STRING_WHEN_SELECTED_ROW_CHANGE
 *	Folger 08/22/08 NEED_UPDATE_EDIT_CONTENT_BEFORE_RUN_SCRIPT					*
 *	Folger 10/08/08 QA80-12328 SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES	*
 *	Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN		*
 *	Sophy 1/28/2011 ORG-2131-P1 IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE		*
 *	Folger 04/12/2011 ORG-2633-P1 XF_SCRIPT_EXAMPLE_DLG_WRONG_CATEGORY_BOLD_STATUS
 *	Sophy 7/21/2011 ORG-3293-P1 XF_SAMPLE_CODE_PARSING_PROBLEM_AS_EDIT_TEXT_WITHOUT_NL_BUT_CR
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h"
#include "SplitterControl.h"
#include "XFunctionEx.h"
#include "XFScriptEdit.h" // CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS

#define STR_DLG_NAME			_L("XF Script Dialog")
#define STR_SAVE_WARNING		_L("XF %s: Script is changed.\nDo you want to save the change?")
#define STR_LAST_SEL_XF_NAME	"LastSelection"
#define STR_LOCATION			"Location"			///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
#define STR_SCRIPT_ATTRIB		"HasScript" 
#define STR_INFO_SEPARATOR		"|"

#define PANE_ROW_COL_LIST		0,0
#define PANE_ROW_COL_SCRIPT		0,1

//---- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
//#define WM_USER_ON_SCRIPT_CHANGE		(WM_USER + 1018)
//----
#define WM_USER_ON_UPDATE_INFO			(WM_USER + 1018)

//----- CPY 5/31/07 SYS_XF_READ_ONLY
//#define COLOR_GRAY		RGB(150,150,150)
#define COLOR_READ_ONLY		RGB(127,127,127)
#define COLOR_SYSTEM		RGB(0,0,255)
//-----

#pragma labtalk(0) //---- CPY 5/23/07 QA70-9815 XF_SCRIPT_EXAMPLE_DIALOG
enum{SYS_BRANCH, USER_BRANCH, GROUP_BRANCH, LAST_BRANCH};	///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO	
enum{EDIT_SCRIPT_CONTENT, EDIT_USAGE_CONTENT};	///Jasmine 06/07/07 EDIT_USAGE	

//--- CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME
static int _comboLocation_to_path_location(int nCombo)
{
	vector<int> vn = {SYS_FOLDER, ALL_USER_FOLDER, USER_FOLDER};
	return vn[nCombo];
}
//---

//---- CPY 5/23/06 XF_LISTING_GIVEN_CATEGORY
/*
static bool xf_has_script(LPCSTR lpcszXFName, string* pstrXFScript = NULL)
{
	if(lstrlen(lpcszXFName) == 0)
		return false;
	
	XFunction xfunc;
	Tree trXF;
	if ( !xfunc.Load(&trXF, lpcszXFName) )
		return false;
	
	TreeNode trScriptSample = xfunc.GetHelp(IDV_HELP_LT_SCRIPT_SAMPLE);
	
	if ( !trScriptSample )
		return false;
	
	string strXFScript = trScriptSample.strVal;
	if(pstrXFScript)
		*pstrXFScript = strXFScript;
	return !strXFScript.IsEmpty();
}
*/
//list_x_functions(strFileName, strDisplay, strCategory, nLocation, 0, "", &vsXFs);
#define _LOAD_XF_TREE_DIRECTLY
#ifdef _LOAD_XF_TREE_DIRECTLY
static int _xf_has_script_direct_load_tree(LPCSTR lpcszXF, string* pstrScript)
{
	Tree trXF(lpcszXF);
	if(trXF)
	{
		TreeNode trHelp = trXF.helpe;
		if(trHelp && trHelp.script)
		{
			string strXFScript = trHelp.script.strVal;
			if(pstrScript)
				*pstrScript = strXFScript;
			return strXFScript.IsEmpty()? 0:1;
		}
		return -2;
	}
	return -1;
}
#endif

//---- CPY 6/7/2007 GET_HAS_SCRIPT_INFO_FROM_MAP
static bool _xf_has_script_from_map_cache(LPCSTR lpcszXFfilepath)
{
	DWORD dw = 0;
	if(okutil_get_file_info_from_internal_map(lpcszXFfilepath, &dw) && 
		(dw & XFBIT_HAS_SCRIPT_SAMPLE))
		return true;
		
	return false;
}
//----

static int _xf_has_script(LPCSTR lpcszXF, int nLocation = UNDEF_FOLDER, string* pstrScript = NULL)
{
	///------ Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	//DWORD dwCntrl = LTXF_LIST;
	DWORD dwCntrl = 0;
	///------ End QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	if(is_str_has_path(lpcszXF))
	{
		//---- CPY 6/7/2007 GET_HAS_SCRIPT_INFO_FROM_MAP
		if(NULL == pstrScript)
			return _xf_has_script_from_map_cache(lpcszXF);
		//----
		dwCntrl |= LTXF_BY_FILENAME;
#ifdef _LOAD_XF_TREE_DIRECTLY
		return _xf_has_script_direct_load_tree(lpcszXF, pstrScript);
#endif
	}
	
	XFunction xf;
	Tree trXF;
	if(!xf.LoadNoLocalize(&trXF, lpcszXF, dwCntrl, false, false, false))
		return -1;

	TreeNode trScriptSample = xf.GetHelp(IDV_HELP_LT_SCRIPT_SAMPLE);
	if ( !trScriptSample )
		return -2;
	
	string strXFScript = trScriptSample.strVal;
	if(pstrScript)
		*pstrScript = strXFScript;
	return strXFScript.IsEmpty()? 0:1;
}

enum {
	XFBIT_READ_ONLY = 0x01,
	XFBIT_HAS_SCRIPT = 0x02,
	XFBIT_SYSTEM  = 0x04, //----- CPY 5/31/07 SYS_XF_READ_ONLY
};
//CPY 5/24/07 XF_INFO_NEED_FASTER_LOADING added vnInfo
int get_XF_list(LPCSTR lpcszCategory, vector<string>& vsXFnames, vector<uint>& vnInfo, DWORD dwUsgCntxt, int nLocation, int& nHasScripts, DWORD dwTestXFbits = XFBIT_READ_ONLY|XFBIT_HAS_SCRIPT)
{
	if(UNDEF_FOLDER == nLocation)
		return 0;
	nHasScripts = 0;
	vector<string> vsNames, vsFiles;
	int nFiles = okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &dwUsgCntxt, 1, NULL, NULL, nLocation);
	if(nFiles > 0)
	{
		int nPathType = UNDEF_FOLDER;
		string strCat;
		//---- CPY 6/7/2007 GET_HAS_SCRIPT_INFO_FROM_MAP
		// the loading is now fast, so no need to show on status bar
		//string strMsg;strMsg.Format("Loading X-Functions from %s", lpcszCategory);SetStatusBarText(strMsg);
		//----
		waitCursor www;
		
		for(int ii = 0; ii < nFiles; ii++)
		{
			string strName = okutil_separate_composite_name(vsNames[ii], &nPathType, &strCat);
			if(strCat.CompareNoCase(lpcszCategory)==0)
			{
				vsXFnames.Add(strName);
				DWORD dwBits = 0;
				if(XFBIT_READ_ONLY & dwTestXFbits)
				{
					//----- CPY 5/31/07 SYS_XF_READ_ONLY
					if(SYS_FOLDER == nPathType)
						dwBits |= XFBIT_SYSTEM;
					//-----
					
					DWORD	dwAttributes = GetFileAttributes(vsFiles[ii]);
					if(dwAttributes & FILE_ATTRIBUTE_READONLY) 
						dwBits |= XFBIT_READ_ONLY;
				}
				if((XFBIT_HAS_SCRIPT & dwTestXFbits) && _xf_has_script(vsFiles[ii]) > 0)
				{
					dwBits |= XFBIT_HAS_SCRIPT;
					nHasScripts++;
				}
				
				vnInfo.Add(dwBits);
			}
		}
		//SetStatusBarText("");
		return vsXFnames.GetSize();
	}
	return 0;
}	
//---------------
// CPY 5/23/06 I have modified this function without comments, I see no need to have more then one level of
// tree, so the top level can be just directly like "Data Manipulation\Worksheet"
static bool make_XF_categories_tree(TreeNode& trXFList, int nLocation = USER_FOLDER)
{
	if ( !trXFList )
		return false;
	
	string strFileName = "", strCategory = "", strDisplay = "";
	
	vector<string> vsXFs;
	list_x_functions(strFileName, strDisplay, strCategory, nLocation, 1, NULL, &vsXFs);	
	
	//string strRootPath = GetAppPath(!bUserFolder) + "X-Functions\\";
	string strRootPath = xf_get_function_folder(nLocation);
	TreeNode trNode = trXFList;
	for (int ii = 0; ii  < vsXFs.GetSize(); ii++)
	{
		TreeNode trTemp;
		string strTagName;
		strTagName.Format("Category_%d", ii+1); 
		trTemp = trNode.AddNode(strTagName);
		string strXFCategory = vsXFs[ii];
		trTemp.SetAttribute(STR_LABEL_ATTRIB, strXFCategory);
		//trTemp.SetAttribute(STR_CATEGORY_NODE, strXFCategory); // why is this needed?
		trTemp.SetAttribute(STR_PATH_ATTRIB, strRootPath + strXFCategory + "\\");
		trTemp.SetAttribute(STR_DISPLAY_ATTRIB, get_page_display_id(-1));
	}
	return true;
}
//---------------

bool make_category_xfs_tree(TreeNode& trXFCategory, int nLocation = USER_FOLDER)
{
	if ( !trXFCategory )
		return false;
		
	string strCategory;
	
	foreach ( TreeNode trChild in trXFCategory.Children )
	{
		trChild.GetAttribute(STR_LABEL_ATTRIB, strCategory);
		vector<string> vsXFs;
		vector<uint> vnInfo;
		int nHasScripts;
		get_XF_list(strCategory, vsXFs, vnInfo, IDXF_USGCTXT_LABTALK, nLocation, nHasScripts);
		for (int ii = 0; ii < vsXFs.GetSize(); ii++)
		{
			TreeNode trNode = trChild.AddNode(cvt_str_to_tag_name(vsXFs[ii]));
			trNode.SetAttribute(STR_LABEL_ATTRIB, vsXFs[ii]);
			trNode.SetAttribute(STR_DISPLAY_ATTRIB, IDR_IMPORTED_FILE);
			int nn = vnInfo[ii];
			trNode.SetAttribute(STR_DATA_ATTRIB, nn);//CPY 5/24/07 XF_INFO_NEED_FASTER_LOADING added vnInfo
		}
		trChild.SetAttribute(STR_DATA_ATTRIB, nHasScripts);//---- CPY 5/29/07 SHOW_BOLD_ON_BRANCH_IF_ANY_HAS_SCRIPTS
	}
	
	return true;
}
///Sophy 1/28/2011 ORG-2131-P1 IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
//this class only open ini once. if from network file, it will largely speed up.
class XFTreeCreateHelper
{
public:
	XFTreeCreateHelper(TreeNode& trXFList, int nLocation)
	{
		m_trXFList = trXFList;
		m_nLocation = nLocation;
		MakeXFTree();
	}
	~XFTreeCreateHelper(){}
	void	MakeXFTree()
	{
		if ( !m_trXFList || UNDEF_FOLDER == m_nLocation )
			return;
		waitCursor wc;
		DWORD dwUsgContext = IDXF_USGCTXT_LABTALK;
		vector<string> vsNames, vsFiles;
		int nFiles = okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &dwUsgContext, 1, NULL, NULL, m_nLocation);
		int nPathType = UNDEF_FOLDER;
		string strRootPath = xf_get_function_folder(m_nLocation);
		for ( int iFile = 0; iFile < nFiles; iFile++ )
		{
			string strCat;
			string strName = okutil_separate_composite_name(vsNames[iFile], &nPathType, &strCat);
			TreeNode trCat = tree_check_get_node_by_label(m_trXFList, strCat);
			DWORD dwBits = 0;
			if ( trCat )
			{
				if ( SYS_FOLDER == nPathType )
					dwBits |= XFBIT_SYSTEM;
				DWORD dwAttribs = GetFileAttributes(vsFiles[iFile]);
				if ( dwAttribs & FILE_ATTRIBUTE_READONLY )
					dwBits |= XFBIT_READ_ONLY;
				if ( _xf_has_script(vsFiles[iFile]) > 0 )
					dwBits |= XFBIT_HAS_SCRIPT;
				int nScripts = 0;
				if ( !trCat.GetAttribute(STR_DATA_ATTRIB, nScripts) ) //newly added category
				{
					trCat.SetAttribute(STR_LABEL_ATTRIB, strCat);
					trCat.SetAttribute(STR_PATH_ATTRIB, strRootPath + strCat + "\\");
					trCat.SetAttribute(STR_DISPLAY_ATTRIB, get_page_display_id(-1));
				}
				///------ Folger 04/12/2011 ORG-2633-P1 XF_SCRIPT_EXAMPLE_DLG_WRONG_CATEGORY_BOLD_STATUS
				if ( O_QUERY_BOOL(dwBits, XFBIT_HAS_SCRIPT) )
				///------ End XF_SCRIPT_EXAMPLE_DLG_WRONG_CATEGORY_BOLD_STATUS
					nScripts++;
				trCat.SetAttribute(STR_DATA_ATTRIB, nScripts);
				
				//add xf to category tree
				TreeNode trXF = trCat.AddNode(cvt_str_to_tag_name(strName));
				trXF.SetAttribute(STR_LABEL_ATTRIB, strName);
				trXF.SetAttribute(STR_DISPLAY_ATTRIB, IDR_IMPORTED_FILE);
				trXF.SetAttribute(STR_DATA_ATTRIB, dwBits);
			}
		}
	}
private:
	TreeNode	m_trXFList;
	int			m_nLocation;
};
///end IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
static void make_xf_tree(TreeNode& trXFList, int nLocation)
{
	///Sophy 1/28/2011 ORG-2131-P1 IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
#define	__USE_XFTREECREATEHELPER__
#ifdef	__USE_XFTREECREATEHELPER__
	XFTreeCreateHelper xfhelper(trXFList, nLocation);
#else	//!__USE_XFTREECREATEHELPER__
	///end IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
	make_XF_categories_tree(trXFList, nLocation);
	make_category_xfs_tree(trXFList, nLocation);
	///Sophy 1/28/2011 ORG-2131-P1 IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
#endif	//__USE_XFTREECREATEHELPER__
	///end IMPROVE_LOAD_XF_CATEGORY_AND_FUNCTION_TREE
}

static bool save_xf_script(LPCSTR lpcszXFName, LPCSTR lpcszXFScript, LPCSTR lpcszUsage)
{
	//---- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	string strXFfilname = lpcszXFName;
	add_file_extension(strXFfilname, "OXF");
	//----
	XFunction xfunc;
	Tree trXF;
	if ( !xfunc.LoadNoLocalize(&trXF, strXFfilname, LTXF_BY_FILENAME) )
		return false;
	
	TreeNode trScriptSample = xf_get_help_node(trXF, IDV_HELP_LT_SCRIPT_SAMPLE, _get_current_language());//xfunc.GetHelp(IDV_HELP_LT_SCRIPT_SAMPLE);
	
	if ( !trScriptSample )
		return false;
	
	trScriptSample.strVal = (string)lpcszXFScript;
	///Jasmine 06/07/07 EDIT_USAGE	
	TreeNode trUsage = xf_get_help_node(trXF, IDXF_SYNTAX, _get_current_language());//xfunc.GetHelp(IDV_HELP_LT_SCRIPT_SAMPLE);
	if ( !trUsage )
		return false;
	trUsage.strVal = (string)lpcszUsage;	
	///End EDIT_USAGE
	string strXFileName;
	trXF.GetAttribute("FileName", strXFileName); // file name with file path
	
	return xf_save(trXF, strXFileName);
}


static bool get_xf_info(string& strVarList, string& strInfo, string& strXFScript, string& strUsage, LPCSTR lpcszXFName
, DWORD dwDisplayOptions = LIST_XF_ARG_NAME | LIST_XF_ARG_TYPES | LIST_XF_ARG_DEFAULTS)
{
	if(lstrlen(lpcszXFName) == 0)//---CPY 5/23/06 
		return false;
	
	XFunction xfunc;
	Tree trXF;
	if ( !xfunc.LoadNoLocalize(&trXF, lpcszXFName) )
		return false;
	
	int nLan = _get_current_language();
	
	strVarList = xfunc.GetVarsInfo(dwDisplayOptions, nLan);
	
	//--- CPY 5/23/06 SHOULD_MAKE_USE_OF_XF_CLASS
	/*
	TreeNode trDescript = xfunc.GetHelp(IDV_HELP_BRIEF_INFO, nLan);
	
	if ( !trDescript )
		return false;
	
	strDescription = trDescript.strVal;
	*/
	/// Hong 05/24/07 ADD_LANGUAGE_SUPPORT
	//strInfo = xfunc.GetHelpInfo();
	strInfo = xfunc.GetHelpInfo(true, nLan);
	/// end ADD_LANGUAGE_SUPPORT
	//----
	strUsage = xfunc.GetHelpText(IDXF_SYNTAX, nLan);	///Jasmine 06/07/07 EDIT_USAGE	
	TreeNode trScriptSample = xfunc.GetHelp(IDV_HELP_LT_SCRIPT_SAMPLE);
	
	if ( !trScriptSample )
		return false;
	
	strXFScript = trScriptSample.strVal;
	
	return true;
}

//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG
enum {
	XF_SCRIPT_MENU_CUT,
	XF_SCRIPT_MENU_COPY,
	XF_SCRIPT_MENU_PASTE,
	XF_SCRIPT_MENU_DELETE,
	XF_SCRIPT_MENU_SEPARATOR,
	XF_SCRIPT_MENU_SELECT_ALL,

	XF_SCRIPT_MENU_LAST_ITEM,
};

class XFScriptMenu : public Menu
{
public:
	XFScriptMenu(bool bTextSel, bool bReadOnly)
	{
		m_nChoice = -1;
		Add(_L("Cut"), OnMenuItem,  MF_STRING | (bTextSel && !bReadOnly ? MF_ENABLED : MF_GRAYED));
		Add(_L("Copy"), OnMenuItem,  MF_STRING | (bTextSel ? MF_ENABLED : MF_GRAYED));
		Add(_L("Paste"), OnMenuItem,  MF_STRING | (!bReadOnly ? MF_ENABLED : MF_GRAYED));
		Add(_L("Delete"), OnMenuItem,  MF_STRING | (bTextSel && !bReadOnly ? MF_ENABLED : MF_GRAYED));
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		Add(_L("Select All"), OnMenuItem,  MF_STRING);
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= XF_SCRIPT_MENU_CUT && m_nChoice < XF_SCRIPT_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};

//------ End SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG

class XFTreeList : public GridTreeControl
{
public:
	XFTreeList()
	{
		///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO	
		//m_nSystemTreeStart = -1;
		//m_nSystemTreeEnd = -1;
		//m_nUserTreeStart = -1;
		//m_nUserTreeEnd 	= -1;
		//----CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME
		//m_vnStart.SetSize(LAST_BRANCH);
		//m_vnStart = -1;
		//m_vnEnd.SetSize(LAST_BRANCH);
		//m_vnEnd = -1;
		//----
		m_vsSelXF.SetSize(LAST_BRANCH);
		m_nLocation = -1;
	}
	//--------- CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME
	bool IsReadOnly()
	{
		//------ Folger 07/15/08 QA80-11230 FIX_SCRIPT_EDIT_READONLY_WHEN_COMBO_CHANGE
		//if(m_nLocation < 0 || SYS_BRANCH == m_nLocation)
		if(m_nLocation < 0 || SYS_BRANCH == m_nLocation || IsReadOnlyRow())
		//------
			return true;
		return false;
	}
	//---------

	void UpdateXFList(int nLocation)//bool bUser)
	{
		if(!IsReady())
			return;
		if(nLocation < 0)
			return;
		
		// save current selected XF first
		if(-1 != m_nLocation)
			m_vsSelXF[m_nLocation] = GetSel();
		m_nLocation = nLocation;
		// find tree from given folder location
		TreeNode trFolder = m_tree.FindNodeByAttribute(STR_ID_ATTRIB, nLocation, FALSE); 
		if(!trFolder.IsValid())
			trFolder = m_tree.AddNode("Folder"+nLocation, nLocation);
		
		if(!trFolder.GetNodeCount())// if does not exist, we will need to create it
			make_xf_tree(trFolder, _comboLocation_to_path_location(nLocation));
		
		if(trFolder.GetNodeCount())
			UpdateSimpleTree(trFolder);
		else
			ClearAll();// folder has nothing
		
		// update display according to row data
		for(int nRow = GetRowOffset(); nRow < GetRows(); nRow++)
		{
			if(IsBranchRow(nRow))
			{
				int nHasScripts = GetRowData(nRow);
				if(nHasScripts > 0)
					SetBold(nRow, 0);
				continue;
			}
			DWORD dwXFBits = GetRowData(nRow);
			if(dwXFBits & XFBIT_HAS_SCRIPT)
				SetBold(nRow, 0);
			if(dwXFBits & XFBIT_SYSTEM)
				SetCellColor(nRow, 0, COLOR_SYSTEM);
			else if(dwXFBits & XFBIT_READ_ONLY)
				SetCellColor(nRow, 0, COLOR_READ_ONLY);
		}
		SetAllCollapsed();
		SetSel(m_vsSelXF[m_nLocation]);	
	}
	string GetSel(string* pstrPath = NULL)
	{
		string strXF;
		int nRow = GetSelectedRow();
		TreeNode trFolder = m_tree.FindNodeByAttribute(STR_ID_ATTRIB, m_nLocation, FALSE); ///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
		if(0 > nRow || !trFolder.IsValid())
			return "";
		if(!IsBranchRow(nRow))
			m_nSelRow = nRow;
		strXF = GetCell(m_nSelRow, 0);
		if(pstrPath && !strXF.IsEmpty())
		{
			TreeNode tr;
			foreach(TreeNode trNode in trFolder.Children)
			{
				tr = trNode.FindNodeByAttribute(STR_LABEL_ATTRIB, strXF);
				if(tr.IsValid())
					break;
			}
			if(tr.IsValid())
			{
				string strPath;
				tr.Parent().GetAttribute(STR_PATH_ATTRIB, strPath);
				*pstrPath = strPath + strXF;
			}
		}
		return strXF;
	}
	void 	SetSel(LPCSTR lpcszXF)
	{
		if(0 > m_nLocation)
			return;
		int nSelRow = FindRow(lpcszXF, 0, true, true, 0);
		//------ Folger 11/22/07 FIX_RUNTIME_ERROR_WHEN_NO_ROW_SELECTED
		if (nSelRow < 0)
			nSelRow = 0;
		//------
		if(nSelRow >= 0)
		{
			SetCollapsed(GetParent(nSelRow), flexOutlineExpanded);
			SelRow( nSelRow );
		}
	}
	//---CPY 6/14/07 SCRIPT_SAMPLE_DLG_SWITCHING_LOCATION_AUTOMATION_ERR
	// should hide IsBranchRow and expose IsShowInfoRow instead
	bool IsShowInfoRow()
	{
		if(GetRows() - GetRowOffset() <= 0)
			return false;
		
		return !IsBranchRow();
	}
protected:
	//---
	bool IsBranchRow()
	{
		int nRow = GetSelectedRow();
		return -1 < nRow? IsBranchRow(nRow) : true;
	}
public:
	bool IsReadOnlyRow()
	{
		//------ Folger 07/15/08 QA80-11230 FIX_SCRIPT_EDIT_READONLY_WHEN_COMBO_CHANGE
		if ( IsBranchRow() )
			return true;
		//------
		
		int nRow = GetSelectedRow();
		DWORD dwXFbits = GetRowData(nRow);
		//---- CPY 5/31/07 SYS_XF_READ_ONLY
		//return (dwXFbits & XFBIT_READ_ONLY);
		return (dwXFbits & (XFBIT_SYSTEM | XFBIT_READ_ONLY));
		//----
	}
	//-----CPY 5/24/07 XF_INFO_NEED_FASTER_LOADING
	//bool HasScript(LPCSTR lpcszXF)
	//{
	//	return _xf_has_script(lpcszXF) > 0? true:false;
	//}
	bool HasScript(bool bUpdate =true, int nRow = -1)
	{
		if(nRow < 0) nRow = m_nSelRow;
		DWORD dwXFbits = GetRowData(nRow);
		if(bUpdate)
		{	
			string strXF = GetCell(nRow, 0);
			///Jasmine 06/14/07 SET_CELL_STATE
			bool bHasScript = _xf_has_script(strXF) > 0? true:false;
			DWORD dwTemp = dwXFbits;
			dwTemp &=~XFBIT_HAS_SCRIPT;
			if(bHasScript)
				dwTemp |= XFBIT_HAS_SCRIPT;
			if(dwTemp != dwXFbits)
			{
				dwXFbits = dwTemp;
				SetRowData(nRow, dwXFbits);//SetCellData(nRow, 0, dwXFbits);
				
				int nParent = GetParent(nRow);
				int nHasScript = GetRowData(nParent);
				nHasScript = (dwXFbits & XFBIT_HAS_SCRIPT)? (nHasScript + 1) : (nHasScript - 1);
				SetRowData(nParent, nHasScript);
				TreeNode trFolder = m_tree.FindNodeByAttribute(STR_ID_ATTRIB, m_nLocation, FALSE); ///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
				if(trFolder)
				{
					TreeNode trXF = trFolder.FindNodeByAttribute(STR_LABEL_ATTRIB, strXF);
					if(trXF)
					{
						trXF.SetAttribute(STR_DATA_ATTRIB, (int)dwXFbits);
						trXF.Parent().SetAttribute(STR_DATA_ATTRIB, nHasScript);
					}
				}
			}
			///End SET_CELL_STATE
		}
		if(dwXFbits & XFBIT_HAS_SCRIPT)
			return true;
		
		return false;
	}
	//-----
	void SetCellState()
	{
		bool bSet = HasScript();
		SetCellState(m_nSelRow, 0, bSet);
		///Jasmine 06/14/07 SET_CELL_STATE
		int nParent = GetParent(m_nSelRow);
		int nHasScript = GetRowData(nParent);
		SetCellState(nParent, 0, nHasScript > 0);
		///End SET_CELL_STATE
	}
private:
	Tree 			m_tree;
	///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
	//Tree			m_SystemTree;
	//Tree			m_UserTree;
	//string			m_strXF;
	vector<string>	m_vsSelXF;
//----CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME
//	vector<int>		m_vnStart, m_vnEnd;
//----
	int				m_nLocation;
	int				m_nSelRow;
	//int 			m_nSystemTreeStart;
	//int				m_nSystemTreeEnd;
	//int				m_nUserTreeStart;
	//int				m_nUserTreeEnd;
	//bool			m_bUser;
	///End REPLACE_CHECKBOX_WITH_COMBO
};

class XFScriptSplitter : public SplitterControl
{
public:
	XFScriptSplitter()
	{		
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName)
	{
		SetGridSize(1,2);
		m_IDTreePane	= GetDlgCtrlID(PANE_ROW_COL_LIST);
		m_IDScriptPane 	= GetDlgCtrlID(PANE_ROW_COL_SCRIPT);

		InitMsgMap();
		SplitterControl::Init(nCntrlID, wndParent, 1, lpcszDlgName);// 1 = 2nd splitter in dialog
	}
	void OnReady()
	{
		m_XFlist.SetReady();
		SplitterControl::OnReady();
		m_bReady = true;
	}
	BOOL OnDestroy()
	{
		CheckSave();
		return SplitterControl::OnDestroy();
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)
	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnRowChange)
	ON_GRID_DBLCLICK(GetMainPaneID(), OnListDblClick)		//------ Folger 10/08/08 QA80-12328 SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES
	ON_EN_CHANGE(m_IDScriptPane, OnScriptChange)

	//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG
	ON_CONTEXTMENU(OnShowMenu)
	//------
	
	//ON_CLICK_KEY(OnKey) 
	//ON_EN_KILLFOCUS(m_IDScriptPane, OnKillFocus)
EVENTS_END

	BOOL OnInitSplitter()
	{	
		DWORD dwStyle = WS_CHILD | WS_VISIBLE  | ES_MULTILINE| ES_AUTOVSCROLL | ES_AUTOHSCROLL | WS_VSCROLL | WS_HSCROLL | WS_EX_WINDOWEDGE | ES_WANTRETURN;
		CreatePane(m_reScript, PANE_ROW_COL_SCRIPT, -1, -1, dwStyle);
		
		GUID clsid; 
		CreateActiveXPane(clsid, PANE_ROW_COL_LIST);		
		m_XFlist.Init(m_IDTreePane, *this);
		m_XFlist.SetSelection(flexSelectionByRow);
		//--- CPY 5/27/07 SCRIPT_SAMPLE_BETTER_FONT_NEEDED
		//----------- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
		//m_reScript.SetFont(ORIGIN_FIXED_FONT);
		m_reScript.OnInit();
		//-----------
		//---
		SetReady();		
		return TRUE;
	}
	void OnRowChange(Control ctrl)
	{
		if(!m_bReady)
			return;
		CheckSave();
		//------ Folger 07/15/08 QA80-11230 SHOULD_CLEAR_USAGE_STRING_WHEN_SELECTED_ROW_CHANGE
		//m_strScript = m_strXFFilename = "";
		m_strUsage = m_strScript = m_strXFFilename = "";
		//------
		m_reScript.SetText("");
		m_reScript.SetReadOnly(true);
		//---- CPY 5/31/07 SYS_XF_READ_ONLY
		//m_reScript.Enable = false;
		//----
		m_bReady = false;
		//------ CPY 6/14/07 SCRIPT_SAMPLE_DLG_SWITCHING_LOCATION_AUTOMATION_ERR
		//if(!m_XFlist.IsBranchRow())
		if(m_XFlist.IsShowInfoRow())
		//------
		{
			///Jasmine 06/07/07 EDIT_USAGE
			string strVarList, strInfo, strXFScript, strUsage, strXFName, strPath;
			strXFName = m_XFlist.GetSel(strPath);
			//---- CPY 5/31/07 SYS_XF_READ_ONLY
			//DWORD dw = LIST_XF_ARG_NAME | LIST_XF_ARG_TYPES | LIST_XF_ARG_DEFAULTS;
			//----	
			get_xf_info(strVarList, strInfo, strXFScript, strUsage, strXFName);
			m_strScript = strXFScript;
			m_strUsage = strUsage;
			//m_reScript.SetText(m_strScript);
			/*
			string strSysXFPath = xf_get_function_folder(SYS_FOLDER);	
			m_reScript.SetReadOnly(-1 < strPath.Find(strSysXFPath));
			m_reScript.Enable = 0 > strPath.Find(strSysXFPath);
			*/
			//---- CPY 5/31/07 SYS_XF_READ_ONLY
			//bool bReadOnly = m_XFlist.IsReadOnlyRow();
			//m_reScript.SetReadOnly(bReadOnly);
			//m_reScript.Enable = !bReadOnly;
			//m_reScript.SetReadOnly(m_XFlist.IsReadOnlyRow());
			//----
			ChangeEditContent(m_nType);
			///End EDIT_USAGE
			//---- CPY 5/23/07 SHOULD_MAKE_USE_OF_XF_CLASS
			//m_strInfo = strDescription + "\n" + strVarList;
			//m_strInfo = strPath + STR_INFO_SEPARATOR + m_strInfo;	
			string strTemp;
			okutil_check_LF_without_CR(strInfo, &strTemp);
			m_strXFFilename = strPath;
			m_strXFInfo = strTemp;
			//----
		}
		m_bReady = true;

		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_ON_UPDATE_INFO, 0);
	}
	BOOL OnScriptChange(Control ctrl)
	{
		//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
		if(!m_bReady)
			return true;
		//-----
		//--------- CPY 6/8/07 SIMPLIFY_FOLDER_TO_ONE_TREE_AND_CLEAN_EACH_TIME
		if(m_XFlist.IsReadOnly())
			return true;
		//---------

		//if(m_bChange)
			//return TRUE;
		//out_str("OnScriptChange");
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_ON_UPDATE_INFO, 1);
		return TRUE;
	}
	//---- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	/*
	BOOL OnKey(BOOL bRollingUp)
	{
		if(bRollingUp)
			return TRUE;
		Control ctrl;
		return OnScriptChange(ctrl);
	}
	BOOL OnKillFocus(Control ctrl)
	{
		if(!m_strScript.Compare(m_reScript.Text))
			return TRUE;
		m_strScript = m_reScript.Text;
		//if(m_bChange)
			//return TRUE;
		return OnScriptChange(ctrl);
	}
	*/
	
	//------ Folger 07/15/08 QA80-11230 SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{ 
		if( GetScriptPaneID() == nResIDCtrl )
			return ShowScriptPaneMenu(nx, ny);
		
		return FALSE;
	}

	bool ShowScriptPaneMenu(int nx, int ny)
	{
		int nCmd;		
		XFScriptMenu myMenu(!m_reScript.IsSelEmpty(), m_XFlist.IsReadOnlyRow());
		myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
		if(myMenu.GetCommand(nCmd))
		{			
			switch(nCmd)
			{
			case XF_SCRIPT_MENU_CUT:
				m_reScript.OnCut();
				return TRUE;
				
			case XF_SCRIPT_MENU_COPY:
				m_reScript.Copy();
				return TRUE;
				
			case XF_SCRIPT_MENU_PASTE:
				m_reScript.Paste();
				return TRUE;
				
			case XF_SCRIPT_MENU_DELETE:
				m_reScript.OnDelete();
				return TRUE;
				
			case XF_SCRIPT_MENU_SELECT_ALL:
				m_reScript.OnSelectAll();
				return TRUE;
				
			default:
				break;
			}
		}	
		
		return FALSE;
	}	
	//------ End SUPPORT_SHORTCUT_MENU_IN_XF_SCRIPT_DIALOG
	
	int GetMainPaneID(){ return m_IDTreePane;}
	int GetScriptPaneID(){return m_IDScriptPane;}
	
	//------ Folger 10/08/08 QA80-12328 SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES
	void OnListDblClick(Control ctrl)
	{
		int nClickRow, nClickCol;
		m_XFlist.GetMouseCell(nClickRow, nClickCol);
		forceCollapse(nClickRow, true);
	}
	//------ End SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES
	
public:	
	void 	UpdateXFList(int nLocation)//bool bUser)///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
	{
		CheckSave();
		m_XFlist.UpdateXFList(nLocation);
		Control ctrl;
		OnRowChange(ctrl);
	}
	///Jasmine 06/07/07 EDIT_USAGE	
	void UpdateEditContent()
	{
		string strContent;
		m_reScript.GetText(strContent);
		switch(m_nType)
		{
		case EDIT_SCRIPT_CONTENT:
			m_strScript = strContent;
			break;
		case EDIT_USAGE_CONTENT:
			m_strUsage = strContent;
			break;
		}		
	}
	void ChangeEditContent(int nType = EDIT_SCRIPT_CONTENT)
	{
		m_bReady = false;
		if(nType != m_nType)
		{
			UpdateEditContent();
			m_nType = nType;
		}
		string strContent;
		switch(nType)
		{
		case EDIT_SCRIPT_CONTENT:
			strContent = m_strScript;
			break;
		case EDIT_USAGE_CONTENT:
			strContent = m_strUsage;
			break;
		default:
			strContent = "";
			break;
		}
		m_reScript.SetText(strContent);
		m_reScript.SetReadOnly(m_XFlist.IsReadOnlyRow());
		m_bReady = true;
	}
	///End EDIT_USAGE
	//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	//string 	GetInfo(){ return m_strInfo;}
	//string	GetScript(){ return m_reScript.Text;}
	string	GetScript(bool bSkipLeadComments=false, bool bAddCR=false)
	{
		string str = m_strScript;
		//m_reScript.GetText(str);	///Jasmine 06/07/07 EDIT_USAGE
		if(bSkipLeadComments)
		{
			///Sophy 7/21/2011 ORG-3293-P1 XF_SAMPLE_CODE_PARSING_PROBLEM_AS_EDIT_TEXT_WITHOUT_NL_BUT_CR
			//in ocu_skip_C_comments, the code base on '\n' but not  '\r' to detect line ending, while code get from edit control with CRichEditCtrl::GetSelText contains \r\r, but not \n\n as we originally set, MFC bug?
			if ( str.Find('\n') < 0 && str.Find('\r') >= 0 )
				str.Replace('\r', '\n');
			///end XF_SAMPLE_CODE_PARSING_PROBLEM_AS_EDIT_TEXT_WITHOUT_NL_BUT_CR
			int nRet = ocu_skip_C_comments(&str);
			str.TrimLeft();
			str.TrimRight();
		}
		//---------- CPY 6/5/2007 RUN_SCRIPT_SHOULD_ADD_CR_TO_LF
		if(bAddCR)
		{
			string strTemp = str;
			str = okutil_code_to_edit(strTemp, STC_NL_TO_CRNL);
		}
		//----------
		return str;
	}
	string GetPath() { return m_strXFFilename;}
	string GetInfo() { return m_strXFInfo;}
	//-----
	void 	SaveScript()
	{
		saveScript();
	}
	void 	SetSel(LPCSTR lpcszXF)
	{
		m_XFlist.SetSel(lpcszXF);
	}
public:
	void CheckSave(bool bAsk = true)
	{
		if(!m_bChange)
			return;
		string strWarning, strXF;
		//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
		/*
		int nIndex = m_strInfo.Find(STR_INFO_SEPARATOR);
		if(-1 < nIndex)
		{
			string strPath = m_strInfo.Left(nIndex);
			strXF = GetFileName(strPath, true);
		}
		*/
		BOOL bChanged = true;
		strXF = GetFileName(m_strXFFilename, true);
		strWarning.Format(STR_SAVE_WARNING, strXF);
		if(!bAsk || IDYES == MessageBox(GetParent().GetSafeHwnd(), strWarning, _L("Attention"), MB_YESNO))
			bChanged = saveScript()? false:true;
		//---- CPY 6/8/07 CLICK_NO_TO_SAVE_DID_NOT_STOP_DIALOG
		else
			bChanged = false;
		
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.SendMessage(WM_USER_ON_UPDATE_INFO, bChanged?1:0);
		//----
	}
private:
	
	//------ Folger 10/08/08 QA80-12328 SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES
	void forceCollapse(int nRow, bool bForceChange=false)
	{
		int nState=m_XFlist.GetCollapsed(nRow);
		if(flexOutlineCollapsed == nState)
			m_XFlist.SetCollapsed(nRow, flexOutlineExpanded);
		else if(bForceChange && flexOutlineExpanded == nState)
			m_XFlist.SetCollapsed(nRow, flexOutlineCollapsed);
	}
	//------ End SUPPORT_DOUBLE_CLICK_TO_EXPAND_COLLAPSE_BRANCHES
	
	bool saveScript()
	{
		//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
		//if(!m_bChange) 
		//	return;
		//string strXF = lpcszXF;
		//save_xf_script(strXF, m_reScript.Text);
		//m_bChange = false;
		///Jasmine 06/07/07 EDIT_USAGE
		UpdateEditContent();
		if(!save_xf_script(m_strXFFilename, GetScript(), m_strUsage))	
		{
			printf("saving %s failed!\n", m_strXFFilename);
			return false;
		}
		//-----
		
		string strVarList, strInfo, strXFScript, strUsage, strXF, strTemp;
		//DWORD dw = LIST_XF_ARG_NAME | LIST_XF_ARG_TYPES | LIST_XF_ARG_DEFAULTS;
		strXF = GetFileName(m_strXFFilename, true);
		get_xf_info(strVarList, strInfo, strXFScript, strUsage, strXF);
		//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
		//m_reScript.Text = strXFScript;
		//m_reScript.SetText(strXFScript);
		okutil_check_LF_without_CR(strInfo, &strTemp);
		m_strScript = strXFScript;
		m_strUsage = strUsage;
		m_strXFInfo = strTemp;
		ChangeEditContent(m_nType);
		//-----
		m_XFlist.SetCellState();
		//---- CPY 6/8/07 CLICK_NO_TO_SAVE_DID_NOT_STOP_DIALOG
		/*
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage(WM_USER_ON_UPDATE_INFO);
		*/
		return true;
		//----
	}
private:
	XFTreeList		m_XFlist;
	//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	//RichEdit		m_reScript;
	XFScriptEdit	m_reScript;
	//----
	int				m_IDTreePane;	
	int				m_IDScriptPane;	
	int				m_nType;	///Jasmine 06/07/07 EDIT_USAGE
	bool			m_bReady;
	string			m_strScript;
	string			m_strUsage;	///Jasmine 06/07/07 EDIT_USAGE	
	//----- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	//string 			m_strInfo;
	//bool			m_bChange;
	string			m_strXFFilename;
	string			m_strXFInfo;
public:
	bool			m_bChange;
	//-----

};

class XFScriptDlg;
static XFScriptDlg *s_pXFScriptDlg = NULL;

class XFScriptDlg : public MultiPaneDlg
{
public:
	XFScriptDlg(LPCSTR lpcszXF = NULL) : MultiPaneDlg(IDD_XF_SCRIPT_DLG, "ODlg8")
	{		
		m_strXF = lpcszXF;
	}
	
	int Create(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = Create(hWndParent, 0);
		Visible = true;
		return nRet;
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	
	ON_INIT_SIZE(OnInitSize)	
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_SYSCOMMAND(OnSystemCommand)
	
	ON_BN_CLICKED(IDC_XF_SCRIPT_SHOW, OnShowBottomPane)
	
	ON_BN_CLICKED(IDC_XF_SCRIPT_SAVE, OnClickSave)
	ON_BN_CLICKED(IDC_XF_SCRIPT_RUN, OnClickRun)
	//ON_BN_CLICKED(IDC_XF_SCRIPT_CHECK, OnCheckListUserXF)	
	ON_CBN_SELCHANGE(IDC_XF_SCRIPT_COMBO, OnComboChangeLocation)	///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
	ON_CBN_SELCHANGE(IDC_XF_SCRIPT_EDIT_COMBO, OnEditComboChange)	///Jasmine 06/07/07 EDIT_USAGE
	//ON_USER_MSG(WM_USER_ON_SCRIPT_CHANGE, OnMarkChange)
	ON_USER_MSG(WM_USER_ON_UPDATE_INFO, OnUpdateInfo)
EVENTS_END

	BOOL OnInitDialog()
	{		
		Text = STR_DLG_NAME;
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show More Info");
		vstrTipsUpDown[1] = _L("Hide Less Info");
		MultiPaneDlg::OnInitDialog(IDC_XF_SCRIPT_SPLITTER, IDC_XF_SCRIPT_SHOW, IDC_XF_SCRIPT_INFO, vstrTipsUpDown, STR_DLG_NAME, 0,NULL, 0);
		
		m_splitter.Init(IDC_XF_SCRIPT_SPLITTER, *this, STR_DLG_NAME);
		///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
		//ResizeDialog::LoadCheckBoxSettings(STR_DLG_NAME, IDC_XF_SCRIPT_CHECK);
		int nLocation = LoadSetting(STR_LOCATION, 0, STR_DLG_NAME);
		ComboBox combo = GetItem(IDC_XF_SCRIPT_COMBO);
		combo.SetCurSel(nLocation);
		///End REPLACE_CHECKBOX_WITH_COMBO
		///Jasmine 06/07/07 EDIT_USAGE
		combo = GetItem(IDC_XF_SCRIPT_EDIT_COMBO);
		combo.SetCurSel(0);
		//End EDIT_USAGE
		GetItem(IDC_XF_SCRIPT_INFO).Visible = IsBottomPaneShown();
		return true;
	}
	BOOL OnReady()
	{
		//UpdateDlgSize();	//We update dlgsize  on function OnRestoreDlg now
		UpdateDlgShow();	
		SetInitReady();
		
		m_splitter.OnReady();
		
		if(0 == HasPreviousSize(STR_DLG_NAME))
			m_splitter.SetColSize(0, 60);
		///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
		//Button btn = GetItem(IDC_XF_SCRIPT_CHECK);
		//m_splitter.UpdateXFList(btn.Check);
		Control ctrl;
		OnComboChangeLocation(ctrl);
		///End REPLACE_CHECKBOX_WITH_COMBO
		if(m_strXF.IsEmpty() || !m_strXF.Compare("(null)"))
			LoadSetting(STR_LAST_SEL_XF_NAME, m_strXF, STR_DLG_NAME);
		if(!m_strXF.IsEmpty())
			m_splitter.SetSel(m_strXF);
		return TRUE;
	}
	BOOL OnDestroy()
	{
		ComboBox combo = GetItem(IDC_XF_SCRIPT_COMBO);
		SaveSetting(STR_LOCATION, combo.GetCurSel(), STR_DLG_NAME);	///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
		SaveSetting(STR_LAST_SEL_XF_NAME, m_strXF, STR_DLG_NAME);
		
		m_splitter.OnDestroy();
		
		ResizeDialog::SaveCheckBoxSettings();
		MultiPaneDlg::OnDestroy();
		
		delete this;
		s_pXFScriptDlg = NULL;
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		MoveControlsHelper	_temp(this);
		uint nButtonIDs[] = { IDCANCEL, IDC_XF_SCRIPT_RUN, IDC_XF_SCRIPT_SAVE, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		m_splitter.OnDlgResize(nType, cx, cy);
		return TRUE;
	}
	BOOL	OnInitSize()
	{
		return FALSE;
	}
	BOOL OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
			
		SIZE sz;
		GetDlgOptimalSize(sz);
		pSz->top = -1;
		pSz->left = -1;
		pSz->width = sz.cx;
		pSz->height = sz.cy;
		///Format 06/04/08 ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION
		//SetBottomPaneHeight(120);
		if(0 == HasPreviousSize(STR_DLG_NAME))
		{
			SetBottomPaneHeight(120);
		}
		///End ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION

		return TRUE;
	}
	bool GetDlgOptimalSize(SIZE& sze)
	{
		//hard code
		sze.cx = 600;
		sze.cy = 300;
		return true;
	}
	BOOL OnClickSave(Control ctrl)
	{
		//---- CPY 6/11/07 SAVE_BUTTON_NOT_CALLING_CENTRALIZED_CODE
		/*
		m_splitter.SaveScript();
		GetItem(IDC_XF_SCRIPT_SAVE).Enable = false;
		if(!Text.Right(1).Compare("*"))
		{
			string strTitle = Text;
			strTitle.TrimRight('*');
			Text = strTitle;
		}
		*/
		m_splitter.CheckSave(false);
		//----
		return TRUE;
	}
	BOOL OnClickRun(Control ctrl)
	{
		//---- CPY 6/5/2007 RUN_SCRIPT_SHOULD_ADD_CR_TO_LF
		//string strScript = m_splitter.GetScript();
		//int nRet = ocu_skip_C_comments(&strScript);	///Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT
		//strScript.TrimLeft();
		//strScript.TrimRight();
		//------ Folger 08/22/08 NEED_UPDATE_EDIT_CONTENT_BEFORE_RUN_SCRIPT
		m_splitter.UpdateEditContent();
		//------
		string strScript = m_splitter.GetScript(true, true);
		//----
		if(!strScript.IsEmpty())
		{
			strScript = ";" + strScript;
			LT_execute(strScript);
		}
		return TRUE;
	}
	///Jasmine 06/01/07 QA80-9815 REPLACE_CHECKBOX_WITH_COMBO
	/*
	BOOL OnCheckListUserXF(Control ctrl)
	{
		Button btn = GetItem(IDC_XF_SCRIPT_CHECK);
		m_splitter.UpdateXFList(btn.Check);
		return TRUE;
	}
	*/
	BOOL OnComboChangeLocation(Control ctrl)
	{
		ComboBox combo = GetItem(IDC_XF_SCRIPT_COMBO);
		m_splitter.UpdateXFList(combo.GetCurSel());
		return TRUE;
	}
	///End REPLACE_CHECKBOX_WITH_COMBO
	///Jasmine 06/07/07 EDIT_USAGE
	BOOL OnEditComboChange(Control ctrl)
	{
		ComboBox combo = GetItem(IDC_XF_SCRIPT_EDIT_COMBO);
		m_splitter.ChangeEditContent(combo.GetCurSel());
		return TRUE;
	}
	///End EDIT_USAGE
	//---- CPY 6/4/07 CHANGE_SCRIPT_EDITBOX_TO_SEPARATE_CLASS
	/*
	void OnMarkChange(DWORD wParam = 0, DWORD lParam = 0)
	{
		GetItem(IDC_XF_SCRIPT_SAVE).Enable = true;
		if(Text.Right(1).Compare("*"))
			Text += "*";
		UpdateRunButton();	///Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT
	}
	void OnUpdateInfo(DWORD wParam = 0, DWORD lParam = 0)
	{
		Text = STR_DLG_NAME;
		string strInfo = m_splitter.GetInfo();
		int nIndex = strInfo.Find(STR_INFO_SEPARATOR);
		if(-1 < nIndex)
		{
			string strPath = strInfo.Left(nIndex);
			if(!strPath.IsEmpty())
			{
				Text += " - " + strPath;
				m_strXF = GetFileName(strPath, true);
			}
			strInfo.Delete(0, nIndex + lstrlen(STR_INFO_SEPARATOR));
		}
		GetItem(IDC_XF_SCRIPT_INFO).Text = strInfo;
		GetItem(IDC_XF_SCRIPT_SAVE).Enable = false;
		UpdateRunButton();	///Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT
	}
	*/
	//wParam > 0 if script changed 
	void OnUpdateInfo(DWORD wParam = 0, DWORD lParam = 0)
	{
		m_splitter.m_bChange = wParam;
		string strPath = m_splitter.GetPath();
		m_strXF = GetFileName(strPath, true);
		GetItem(IDC_XF_SCRIPT_INFO).Text = m_splitter.GetInfo();
		GetItem(IDC_XF_SCRIPT_SAVE).Enable = wParam;
		string strTemp;
		strTemp.Format("%s - %s", STR_DLG_NAME, strPath);
		if(wParam)
		{
			strTemp += "*";
		}
		Text = strTemp;
		UpdateRunButton();	///Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT
	}
	
	///Jasmine 06/01/07 QA80-9815 TRIM_COMMENT_IN_SCRIPT
	void UpdateRunButton()
	{
		//---- CPY 6/5/2007 RUN_SCRIPT_SHOULD_ADD_CR_TO_LF
		//string strScript = m_splitter.GetScript();
		//int nRet = ocu_skip_C_comments(&strScript);
		//strScript.TrimLeft();
		//strScript.TrimRight();
		string strScript = m_splitter.GetScript(true);
		//----
		GetItem(IDC_XF_SCRIPT_RUN).Enable = !strScript.IsEmpty();
	}
	///End TRIM_COMMENT_IN_SCRIPT
private:
	XFScriptSplitter 	m_splitter;
	string				m_strXF;
};

//---- CPY 5/23/07 QA70-9815 XF_SCRIPT_EXAMPLE_DIALOG
// changed into static as we dont need internal invoke for this, just from file.ogs is enough
static int _ScriptExampleDlg(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;

	if(bClose)
	{
		if(s_pXFScriptDlg)
		{
			Window winDlg = s_pXFScriptDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			delete s_pXFScriptDlg;
			s_pXFScriptDlg = NULL;
		}
		return 0;
	}
	// open or update
	if(!s_pXFScriptDlg)
	{
		if(bUpdate)
			return 1;// not possible to update, since dialog not opened
		string str;
		str.Format("%s", lpData);

		s_pXFScriptDlg = new XFScriptDlg(str);
		HWND hWndParent = GetWindow(OGW_MDICLIENT);
		s_pXFScriptDlg->Create(hWndParent);
	}
	if(bUpdate)
		;
	
	return 0;
}

//---- CPY 5/23/07 QA70-9815 XF_SCRIPT_EXAMPLE_DIALOG
/*
void test_op()
{
	ScriptExampleDlg(OMSG_OPEN);
}
void test_close()
{
	ScriptExampleDlg(OMSG_CLOSE);
}
*/
#pragma labtalk(2)

void XFScriptSamples(int nOpen = 1)
{
	if(nOpen)
		_ScriptExampleDlg(OMSG_OPEN);
	else
		_ScriptExampleDlg(OMSG_CLOSE);
}

//-----




