/*------------------------------------------------------------------------------*
 * File Name: SPEFile.h															*
 * Creation: Sim 07-17-2006														*
 * Copyright (c) OriginLab Corp. 2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 08/01/07 v8.0671b MATRIX_START_NEW_COLUMNS_CHANGE_NEW_SHEET			*
 *------------------------------------------------------------------------------*/

#ifndef _SPEFILE_H
#define _SPEFILE_H

#include <Origin.h>
#include <..\OriginLab\file_utils.h>
#include "SPE_FileHeader.h"

///Sophy 7/12/2012 ORG-6030-S1 UPDATE_ORIIGNC_SUPPORT_SPE_FROM_LIGHTFIELD
#define	STR_DATA_FORMAT		"DataFormat"
#define	STR_DATA_BLOCK		"DataBlock"
#define	STR_CALIBRATIONS	"Calibrations"
#define	STR_SENSORINFO		"SensorInformation"
#define	STR_SENSORMAP		"SensorMapping"

#define	STR_CALIBID_ATTRIB		"id"
#define	STR_COUNT_ATTRIB		"count"
#define	STR_WIDTH_ATTRIB		"width"
#define	STR_HEIGHT_ATTRIB		"height"
#define	STR_X_ATTRIB			"x"
#define	STR_Y_ATTRIB			"y"
#define	STR_ORIENT_ATTRIB		"orientation"
#define	STR_CALIBS_ATTRIB		"calibrations"
#define	STR_TYPE_ATTRIB			"type"
#define	STR_PIXEL_FMT_ATTRIB	"pixelFormat"
#define	STR_SIZE_ATTRIB			"size"
#define	STR_STRIDE_ATTRIB		"stride"
///end UPDATE_ORIIGNC_SUPPORT_SPE_FROM_LIGHTFIELD

class SPEFile : public BinFile
{
public:
	SPEFile(BOOL bImport=true);
	~SPEFile();
	
public:
	
//--------------------------------------------------------------------------
// ImportPrincetonInstrumentsFile
//
// This function is called by Origin's Import Wizard.
//
// Return:
//	zero for success
//	non-zero for error
//--------------------------------------------------------------------------
	bool		IsValidPrincetonFile(LPCSTR lpcszFileName);	///Sophy 7/14/2010 ORG-568 IAEA_SPE_FILES_LEAD_TO_INFINITE_LOOP
	//virtual int Import(LPCSTR lpcszFileName, Page &pgTarget, TreeNode& trFileInfo, TreeNode &trFilter);
	virtual int Import(LPCSTR lpcszFileName, Page &pgTarget, TreeNode& trFileInfo, TreeNode &trFilter, int c1); // Hong 01/27/07 ADD_APPEND_COLUMN_MODE
	/// AW 07/19/06 SOME_WORK_ON_PROTOTYPE_OF_SPE
	//virtual int ReadHeader(LPCSTR lpcszFileName, TreeNode& trFileInfo, SPEHEADER &spehdr);
	//virtual int ReadData(Page &pgTarget, TreeNode& trFileInfo, SPEHEADER &spehdr);
	int ReadHeader(LPCSTR lpcszFileName, SPEHEADER &spehdr);
	//int ReadData(Page &pgTarget, SPEHEADER &spehdr);
	int ReadData(Page &pgTarget, SPEHEADER &spehdr, int c1); // Hong 01/27/07 ADD_APPEND_COLUMN_MODE
	int ImportToMatrix(MatrixPage &pgTarget, SPEHEADER &spehdr);
	//int ImportToWks(WorksheetPage &pgTarget, SPEHEADER &spehdr);  /// AW 08/16/06 BACK_ONE_SPE_XF
	/// END SOME_WORK_ON_PROTOTYPE_OF_SPE

	/// Hong 08/01/07 v8.0671b MATRIX_START_NEW_COLUMNS_CHANGE_NEW_SHEET
	int GetDimesion(LPCSTR lpcszFileName, int& nErr);
	/// end MATRIX_START_NEW_COLUMNS_CHANGE_NEW_SHEET
protected:
	//int Import1DimToPage(Page& pgTarget, SPEHEADER& spehdr);
	int Import1DimToPage(Page& pgTarget, SPEHEADER& spehdr, int c1); // Hong 01/27/07 ADD_APPEND_COLUMN_MODE
	int Import2DimToPage(Page& pgTarget, SPEHEADER& spehdr);
	/// AW 07/19/06 SOME_WORK_ON_SPE
	//int DataToMatrix(Matrix& mat, SPEHEADER& spehdr);
	// int SeekToFrameData(SPEHEADER& spehdr, int nFrame);  
	int DataToMatrix(Matrix& mat, int nDataType, int nRows, int nCols, int nBytesToRead);
	 /// END SOME_WORK_ON_SPE
	int GetBytesPerFrame(int& nBytesPerFrame, SPEHEADER& spehdr);
	
private:
	//int headerToNotes(Page& pg, TreeNode trFileInfo, LPCSTR lpcszFile); ///---Sim 11-13-2006 NO_NEED_FOR_HEADER_INFO
	void setPageNameAndLabel(Page& pg, SPEHEADER& spehdr, LPCSTR lpcszFile);
	void setInfoMeaning(TreeNode &trFileInfo); ///---Sim 08-06-2006 SET_FILE_INFO_MEANING
	int prepareReadMatrix(SPEHEADER& spehdr, int& nRows, int& nCols, int& nBytesToRead); /// AW 07/19/06 SOME_WORK_ON_SPE
	int prepareReadPage(SPEHEADER& spehdr, int& nFrame, int& nRows, int& nCols, int& nBytesToRead); /// AW 07/19/06 SOME_WORK_ON_PROTOTYPE_OF_SPE
	//BOOL tree2str(TreeNode& tr, string& str, int nLevel = 0);
	///Sophy 7/12/2012 ORG-6030-S1 UPDATE_ORIIGNC_SUPPORT_SPE_FROM_LIGHTFIELD
	void	copyXMLInfoToHeader(SPEHEADER& spehdr);
	int		import2DFramesV3(SPEHEADER& spehdr, MatrixLayer& ml);
protected:
	Tree	m_trXML;
	///end UPDATE_ORIIGNC_SUPPORT_SPE_FROM_LIGHTFIELD
};

#endif // _SPEFILE_H
