/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 06/20/07 MODIFY_ON_NAME_EVENTS										*
 *	Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <Array.h>
enum
{
	RB_NEW = 0,
	RB_ACTIVE,
	RB_EXISTING,
	RB_INPUT,
	RB_SAME,
};

#include <wndContainer.h>		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW

///////////////////////////////////////////////////////////////////////////////
// class RangeBuilderEventHandlerBranch
///////////////////////////////////////////////////////////////////////////////
class	RangeBuilderEventHandlerBranch
{
public:
	//-----------------------------------------------------------
	void	SetBranch(TreeNode& trBranch)
	{
		m_trBranch = trBranch;
	}

	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	void	SetParentHwnd(HWND hWnd)
	{
		m_hWnd = hWnd;
	}
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW

public:
	TreeNode	Root()
	{
		return m_trBranch;
	}
	
	TreeNode	Name()
	{
		return Root().Name;
	}

public:
	//-----------------------------------------------------------
	void	Expand(BOOL bOn = TRUE)
	{
		/*
		int nCurrent;
		Root().GetAttribute(STR_ATTRIB_BRANCH, nCurrent);
		if( bOn )
		{
			nCurrent |= GETNBRANCH_OPEN;
		}
		else
		{
			nCurrent &=~GETNBRANCH_OPEN;
		}
		m_trBranch.SetAttribute(STR_ATTRIB_BRANCH, nCurrent);
		*/
	}
	
		//-----------------------------------------------------------
	virtual void	OnRootChangeEx(int nVal)
	{
	}
	
	virtual BOOL	GetColumnNames(StringArray& arrNames)
	{
		return FALSE;
	}
	
	virtual int	GetTypeFromUse(int nVal)
	{
		return nVal;
	}
	
	bool	OnRootChange(int nVal)
	{
		Root().Use = nVal;
		
		nVal = GetTypeFromUse(nVal);
		switch( nVal )
		{
		case RB_NEW:
			ConvertToNew();
			break;
			
		case RB_ACTIVE:
			ConvertToActive();
			break;
			
		case RB_EXISTING:
			ConvertToExisting();
			break;
			
		case RB_INPUT:
			ConvertToInput();
			break;
			
		case RB_SAME:
			ConvertToSame();
			break;
		default:
			return false;
		}
		
		OnRootChangeEx(nVal);
		
		return true;
	}
	
	//-----------------------------------------------------------
public:
	void	EnableRoot(BOOL bOn)
	{
		if( bOn )
		{
			Root().RemoveAttribute(STR_BRANCH_COMBO_DISABLE_ATTRIB);
		}
		else
		{
			Root().SetAttribute(STR_BRANCH_COMBO_DISABLE_ATTRIB, 1);
		}
	}
	
	virtual void	ConvertToNew()
	{
		Name().Show = TRUE;
		Expand(TRUE);
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToActive()
	{
		Name().Show = TRUE;
		Expand(TRUE);
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToExisting()
	{
		Name().Show = TRUE;
		Expand(TRUE);
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToInput()
	{
		Name().Show = FALSE;
		Expand(FALSE);
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToSame()
	{
		Name().Show = FALSE;
		Expand(FALSE);
	}
	
	//-----------------------------------------------------------
public:
	void	SetAuxHandler(RangeBuilderEventHandlerBranch* pHandler)
	{
		m_pAuxHandler = pHandler;
	}
	
protected:
	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	HWND	GetParentHwnd()
	{
		return m_hWnd ? m_hWnd : GetWindow();
	}
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW

	TreeNode m_trBranch;
	
	// for page handler m_pAuxHandler is layer handler and visaversa
	RangeBuilderEventHandlerBranch*	m_pAuxHandler;

	HWND		m_hWnd;			///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
};


class RangeBuilderEventHandlerObjectBranch;
///////////////////////////////////////////////////////////////////////////////
// class RangeBuilderEventHandlerPageLayerBranch
///////////////////////////////////////////////////////////////////////////////
class	RangeBuilderEventHandlerPageLayerBranch	:	public RangeBuilderEventHandlerBranch
{
public:
	TreeNode	Template()
	{
		return Root().Template;
	}
	
	virtual void	ConvertToNew()
	{
		RangeBuilderEventHandlerBranch::ConvertToNew();
		Template().Show = TRUE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToActive()
	{
		RangeBuilderEventHandlerBranch::ConvertToActive();
		Template().Show = FALSE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToExisting()
	{
		RangeBuilderEventHandlerBranch::ConvertToExisting();
		Template().Show = FALSE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToInput()
	{
		RangeBuilderEventHandlerBranch::ConvertToInput();
		Template().Show = FALSE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToSame()
	{
		RangeBuilderEventHandlerBranch::ConvertToSame();
		Template().Show = FALSE;
	}
	
	bool	OnTemplateEvent()
	{
		string strSelectedName;
		string strPath = "Originlab\\TemplateOrganizer.c";
		FUNC_STR_INT_HWND pfn = Project.FindFunction("ProjectBrowseTemplate", strPath);
		if(pfn)
		{
			///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			//if(pfn(strSelectedName, EXIST_WKS, GetWindow()) && !strSelectedName.IsEmpty() )
			if ( pfn(strSelectedName, EXIST_WKS, GetParentHwnd()) && !strSelectedName.IsEmpty() )
			///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			{
				Template().strVal = strSelectedName;
				return true;
			}
		}	
		
		return false;
	}
	void	UpdateObjectNames()
	{
		for( int ii = 0; ii < ObjectHandlers()->GetSize();ii++ )
		{
			ObjectHandlers()->GetAt(ii).UpdateNames()
		}
	}
	
	void	SetObjectHandlers(Array<RangeBuilderEventHandlerObjectBranch&>* pArr)	{m_parrObjectHandlers = pArr;}	
protected:
	Array<RangeBuilderEventHandlerObjectBranch&>*	ObjectHandlers(){return m_parrObjectHandlers;}
	
private:	
	Array<RangeBuilderEventHandlerObjectBranch&>*	m_parrObjectHandlers;
};

///////////////////////////////////////////////////////////////////////////////
// class RangeBuilderEventHandlerPageBranch
///////////////////////////////////////////////////////////////////////////////
class	RangeBuilderEventHandlerPageBranch	:	public RangeBuilderEventHandlerPageLayerBranch
{
public:
	TreeNode&	Visible()
	{
		return m_trBranch.Visible;
	}
	
	virtual BOOL	GetColumnNames(StringArray& arrNames)
	{
		return LayerHandler()->GetColumnNames(arrNames);
	}
	
	virtual void	ConvertToNew()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToNew();
		Visible().Show = TRUE;
	}
	
	virtual void	ConvertToActive()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToActive();
		Visible().Show = FALSE;
		WorksheetPage pgActive = Project.Pages();
		if( pgActive )
		{
			Name().strVal = pgActive.GetName();
		}
	}
	
	virtual void	ConvertToExisting()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToExisting();
		Visible().Show = FALSE;
	}
	
	virtual void	ConvertToInput()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToInput();
		Visible().Show = FALSE;
	}
	
	virtual void	ConvertToSame()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToSame();
		Visible().Show = FALSE;
	}
	
	virtual void	OnRootChangeEx(int nVal)
	{
		RangeBuilderEventHandlerPageLayerBranch::OnRootChangeEx(nVal);
		if( nVal == RB_NEW )
		{
			LayerHandler()->OnRootChange(RB_NEW);
		}
	}
	
	bool	OnNameEvent(BOOL bButton)
	{
		if( bButton )
		{
			string strSelectedName;
			string strPath = "Originlab\\ProjectBrowser.c";
			FUNC_STR_DWORD_HWND_BOOL pfn;
			pfn = Project.FindFunction("ProjectBrowseBook", strPath);
			///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			//if( pfn && pfn(strSelectedName, 0, GetWindow(), TRUE) && !strSelectedName.IsEmpty() )
			if( pfn && pfn(strSelectedName, 0, GetParentHwnd(), TRUE) && !strSelectedName.IsEmpty() )
			///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			{
				Name().strVal = strSelectedName;
				OnRootChange(RB_EXISTING);
				UpdateObjectNames();
				return true;
			}
		}
		else
		{
			if( Root().Use != RB_NEW && Root().Use != RB_EXISTING )
				OnRootChange(RB_EXISTING);
			
			UpdateObjectNames();
			return true;
		}
		
		return false;
	}
	
protected:
	RangeBuilderEventHandlerBranch*	LayerHandler()	{return m_pAuxHandler;}	
};

static bool	_get_column_names(LPCSTR lpcszPage, LPCSTR lpcszLayer, StringArray& arrNames)
{
	WorksheetPage pg = Project.Pages(lpcszPage);
	if( pg )
	{
		Worksheet wks = pg.Layers(lpcszLayer);
		if( wks )
		{
			foreach( Column col in wks.Columns )
			{
				string strName = col.GetLongName();
				if( strName.IsEmpty() )
					strName = col.GetName();
				if( !strName.IsEmpty() )
				{
					string strFormatted;
					strFormatted.Format("Col(%s)", strName);
					arrNames.Add(strFormatted);
				}
			}
			
			return arrNames.GetSize() > 0;
		}
	}
	
	return false;
}

///////////////////////////////////////////////////////////////////////////////
// class RangeBuilderEventHandlerPageBranch
///////////////////////////////////////////////////////////////////////////////
class	RangeBuilderEventHandlerLayerBranch	:	public RangeBuilderEventHandlerPageLayerBranch
{
	// because of OC bug described in 9220 i have to have this functions
public:
	TreeNode		Index()
	{
		return Root().Index;
	}
	
	virtual BOOL	GetColumnNames(StringArray& arrNames)
	{
		if( Root().Use == RB_EXISTING || Root().Use == RB_ACTIVE )
		{
			string strPage = PageHandler()->Name().strVal;	
			string strLayer = Name().strVal;
			return _get_column_names(strPage, strLayer, arrNames);
		}
		
		return FALSE;
	}
	
	virtual void	ConvertToNew()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToNew();
		Index().Show = TRUE;
	}

	//-----------------------------------------------------------
	virtual void	ConvertToActive()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToActive();
		Index().Show = FALSE;
		
		WorksheetPage pgActive(PageHandler()->Name().strVal);
		if( pgActive )
		{
			Worksheet wks = pgActive.Layers();
			if( wks )
				Name().strVal = wks.GetName();
		}
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToExisting()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToExisting();
		Index().Show = FALSE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToInput()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToInput();
		Index().Show = FALSE;
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToSame()
	{
		RangeBuilderEventHandlerPageLayerBranch::ConvertToSame();
		Index().Show = FALSE;
	}
	
	virtual void	OnRootChangeEx(int nVal)
	{
		RangeBuilderEventHandlerPageLayerBranch::OnRootChangeEx(nVal);
		switch( nVal )
		{
		case RB_SAME:
		case RB_INPUT:
		 	PageHandler()->OnRootChange(nVal);
			break;
		
		case RB_EXISTING:
		case RB_ACTIVE:
			if( PageHandler()->Root().Use == RB_NEW )
			{
				PageHandler()->OnRootChange(RB_EXISTING);
			}
			break;
			
		case RB_NEW:
			{
				for( int nObject = 0; nObject < ObjectHandlers()->GetSize(); nObject++ )
				{
					ObjectHandlers()->GetAt(nObject).OnRootChange(RB_NEW);
				}
			}
			break;
		}
	}
	
	bool	OnNameEvent(BOOL bButton)
	{
		if( bButton )
		{
			string strSelectedName;
			string strPath = "Originlab\\ProjectBrowser.c";
			///Folger 06/20/07 MODIFY_ON_NAME_EVENTS
			//FUNC_STR_DWORD_HWND_LPCSTR pfn;
			//pfn = Project.FindFunction("ProjectBrowseSheet", strPath);
			//if( pfn && pfn(strSelectedName, 0, GetWindow(), PageHandler()->Name().strVal) && !strSelectedName.IsEmpty() )
			//{
			FUNC_VECTORSTR_DWORD_HWND_BOOL pfn;
			pfn = Project.FindFunction("ProjectBrowseSheets", strPath);
			vector<string> vsResult;
			strSelectedName.GetTokens(vsResult, STR_PAGE_LIST_SEPARATOR);
			///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			//if( pfn && pfn(vsResult, 0, GetWindow(), false) )
			if( pfn && pfn(vsResult, 0, GetParentHwnd(), false) )
			///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			{
				strSelectedName.SetTokens(vsResult, STR_PAGE_LIST_SEPARATOR);
				if (strSelectedName.IsEmpty())
					return false;
			///End MODIFY_ON_NAME_EVENTS
				string strBook;
				string strSheet;
				if( okutil_get_book_sheet_info(&strBook, strSheet, strSelectedName) )
				{
					Name().strVal = strSheet;
					PageHandler()->Name().strVal = strBook;
					PageHandler()->OnRootChange(RB_EXISTING);
					OnRootChange(RB_EXISTING);
				}
				UpdateObjectNames();
				return true;
			}
		}
		else
		{
			if( Root().Use != RB_NEW && Root().Use != RB_EXISTING )
				OnRootChange(RB_EXISTING);
			
			UpdateObjectNames();
			return true;
		}
		
		return false;
	}

protected:
	RangeBuilderEventHandlerBranch*					PageHandler()	{return m_pAuxHandler;}	
};

class RangeBuilderEventHandlerObjectBranch	:	public RangeBuilderEventHandlerBranch
{
public:
	TreeNode		Index()
	{
		return Root().Index;
	}

	virtual int	GetTypeFromUse(int nVal)
	{
		if( nVal == RB_NEW )
			return RB_NEW;
		
		return RB_EXISTING;
	}
	
	virtual void	OnRootChangeEx(int nVal)
	{
		if( RB_EXISTING == nVal )
		{
			if( LayerHandler()->Root().Use == RB_NEW )
				LayerHandler()->OnRootChange(RB_EXISTING);
		}
	}
	
	virtual void	ConvertToNew()
	{
		RangeBuilderEventHandlerBranch::ConvertToNew();
		Index().Show = TRUE;
		string strLabel = STR_NAME;
		Name().SetAttribute(STR_LABEL_ATTRIB, STR_NAME);
		Name().ID = TRGP_STR;
		Name().RemoveAttribute(STR_COMBO_ATTRIB);
	}

	
	//-----------------------------------------------------------
#define	RANGE_STRING_BUILDER_NUMBER_OF_COLUMNS_TO_SHOW	10
	void			UpdateNames()
	{
		Name().ID = TRGP_STR;
		Name().RemoveAttribute(STR_COMBO_ATTRIB);
		if( RB_EXISTING == GetTypeFromUse(Root().Use) )
		{
			StringArray arrColumns;
			if( LayerHandler()->GetColumnNames(arrColumns) )
			{
				if( arrColumns.GetSize() > RANGE_STRING_BUILDER_NUMBER_OF_COLUMNS_TO_SHOW )
				{
					string strComboString = "...";
					Name().ID = TRGP_STR_BUTTON;
					Name().SetAttribute(STR_COMBO_ATTRIB, strComboString);
				}
				else
				{
					string strComboString;
					for( int ii = 0; ii < arrColumns.GetSize(); ii++ )
					{
						if( 0 == ii )
						{
							
						}
						strComboString += "|";
						strComboString += arrColumns[ii];
					}
					Name().SetAttribute(STR_COMBO_ATTRIB, strComboString);
				}
			}
		}
	}
	
	virtual void	ConvertToExisting()
	{
		RangeBuilderEventHandlerBranch::ConvertToExisting();
		Index().Show = FALSE;
		string strLabel;
		strLabel.Format("%s/%s", STR_NAME, STR_INDEX);
		Name().SetAttribute(STR_LABEL_ATTRIB, strLabel);
		UpdateNames();
	}

	//-----------------------------------------------------------
	virtual void	ConvertToActive()
	{
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToInput()
	{
	}
	
	//-----------------------------------------------------------
	virtual void	ConvertToSame()
	{
	}
	
	bool	OnNameEvent(BOOL bButton)
	{
		if( bButton )
		{
			StringArray arrColumns;
			if( LayerHandler()->GetColumnNames(arrColumns) )
			{
				int nSel = ListInputBox(&arrColumns, "");
				if( nSel >= 0 && nSel < arrColumns.GetSize() )
				{
					Name().strVal = arrColumns[nSel];
					return true;
				}
			}
		}
		else
		{
			return true;
		}
		
		return false;
	}
	
protected:
	RangeBuilderEventHandlerBranch*	LayerHandler()	{return m_pAuxHandler;}	
};


class	RangeBuilderEventHandler
{
public:
	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	//RangeBuilderEventHandler(TreeNode& tr)
	RangeBuilderEventHandler(TreeNode& tr, HWND hWnd)
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	{
		m_arrObjectHandlers.SetAsOwner(TRUE);
		if( tr.GetNodeCount() > 0 )
			m_trBranch = tr;
		else
			m_trBranch = tr.Parent();
			
		TreeNode trOneData = m_trBranch.Parent();
		setBranches(trOneData.Book, trOneData.Sheet);

		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		m_clPageHandler.SetParentHwnd(hWnd);
		m_clLayerHandler.SetParentHwnd(hWnd);
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		
		m_clPageHandler.SetAuxHandler(&m_clLayerHandler);
		m_clLayerHandler.SetAuxHandler(&m_clPageHandler);
		
		m_clLayerHandler.SetObjectHandlers(&m_arrObjectHandlers);
		m_clPageHandler.SetObjectHandlers(&m_arrObjectHandlers);
		
		TreeNode trObjects = trOneData.Sheet.NextNode;
		while( trObjects )
		{
			RangeBuilderEventHandlerObjectBranch* pObjHandler = new RangeBuilderEventHandlerObjectBranch;
			///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			pObjHandler->SetParentHwnd(hWnd);
			///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
			pObjHandler->SetBranch(trObjects);
			m_arrObjectHandlers.Add(*pObjHandler);
			trObjects = trObjects.NextNode;
		}

		for( int ii = 0; ii < m_arrObjectHandlers.GetSize(); ii++ )
		{
			m_arrObjectHandlers.GetAt(ii).SetAuxHandler(&m_clLayerHandler);
		}
	}
	//-----------------------------------------------------------
	
public:
	bool	OnPageRootChange(int nVal)
	{
		return m_clPageHandler.OnRootChange(nVal);
	}
	
	//-----------------------------------------------------------
	bool	OnLayerRootChange(int nVal)
	{
		return m_clLayerHandler.OnRootChange(nVal);
	}
	
	#define	RANGE_STRING_BUILDER_OBJECT_INDEX_ATTRIB	"RBObjectIndex"
	RangeBuilderEventHandlerObjectBranch&	GetObjectHandler()
	{
		int nObjectIndex = -1;
		if( !m_trBranch.GetAttribute(RANGE_STRING_BUILDER_OBJECT_INDEX_ATTRIB, nObjectIndex) )
			return NULL;
		
		if( nObjectIndex < 0 || nObjectIndex >= m_arrObjectHandlers.GetSize() )
			return NULL;
		
		return m_arrObjectHandlers.GetAt(nObjectIndex);
	}
	
	bool	OnObjectRootChange(int nVal)
	{
		RangeBuilderEventHandlerObjectBranch& clHanlder = GetObjectHandler();
		if( NULL != clHanlder )
			return clHanlder.OnRootChange(nVal);
		
		return false
	}
	
	//-----------------------------------------------------------
	bool	OnObjectNameEvent(BOOL bButton)
	{
		RangeBuilderEventHandlerObjectBranch& clHanlder = GetObjectHandler();
		if( NULL != clHanlder )
			return clHanlder.OnNameEvent(bButton);
		
		return false
	}
	
	bool	OnPageNameEvent(BOOL bButton)
	{
		return m_clPageHandler.OnNameEvent(bButton);
	}
	
	bool	OnLayerNameEvent(BOOL bButton)
	{
		return m_clLayerHandler.OnNameEvent(bButton);
	}
	
	bool	OnPageTemplateEvent()
	{
		return m_clPageHandler.OnTemplateEvent();
	}
	
	bool	OnLayerTemplateEvent()
	{
		return m_clLayerHandler.OnTemplateEvent();
	}
	
private:
	void	setBranches(TreeNode& trPage, TreeNode& trLayer)
	{
		m_clPageHandler.SetBranch(trPage);
		m_clLayerHandler.SetBranch(trLayer);
	}

private:
	RangeBuilderEventHandlerPageBranch		m_clPageHandler;
	RangeBuilderEventHandlerLayerBranch		m_clLayerHandler;
	TreeNode 								m_trBranch;
	Array<RangeBuilderEventHandlerObjectBranch&>	m_arrObjectHandlers;
};

////////////////////////////////////////////////////////////////////////////////////
static bool _range_string_builder_page_root_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	//RangeBuilderEventHandler clHandler(trNode);
	RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	return clHandler.OnPageRootChange(trNode.Use);
}

static bool _range_string_builder_layer_root_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	//RangeBuilderEventHandler clHandler(trNode);
	RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	return clHandler.OnLayerRootChange(trNode.Use);
}

static bool _range_string_builder_object_root_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	//RangeBuilderEventHandler clHandler(trNode);
	RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
	///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
	return clHandler.OnObjectRootChange(trNode.Use);
}

static bool _range_string_builder_page_name_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( !(nEventInfo & GETNEVENT_ON_INIT) ) 
	{
		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		//RangeBuilderEventHandler clHandler(trNode);
		RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		return clHandler.OnPageNameEvent(nType == TRGP_STR_BUTTON);
	}
	
	return false;
}

static bool _range_string_builder_object_name_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( !(nEventInfo & GETNEVENT_ON_INIT) )
	{
		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		//RangeBuilderEventHandler clHandler(trNode);
		RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		return clHandler.OnObjectNameEvent(nType == TRGP_STR_BUTTON);
	}
	
	return false;
}

static bool _range_string_builder_layer_name_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( !(nEventInfo & GETNEVENT_ON_INIT) )
	{
		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		//RangeBuilderEventHandler clHandler(trNode);
		RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		return clHandler.OnLayerNameEvent(nType == TRGP_STR_BUTTON);
	}
	
	return false;
}

static bool _range_string_builder_page_template_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( !(nEventInfo & GETNEVENT_ON_INIT) && nType == TRGP_STR_BUTTON )
	{
		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		//RangeBuilderEventHandler clHandler(trNode);
		RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		return clHandler.OnPageTemplateEvent();
	}
	
	return false;
}

static bool _range_string_builder_layer_template_event_ex(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( !(nEventInfo & GETNEVENT_ON_INIT) && nType == TRGP_STR_BUTTON )
	{
		///------ Folger 12/06/2011 ORG-4529-P1 BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		//RangeBuilderEventHandler clHandler(trNode);
		RangeBuilderEventHandler clHandler(trNode, getNContainer.GetSafeHwnd());
		///------ End BROWSER_IN_RANGE_STRING_BUILDER_CORRECT_PARENT_WINDOW
		return clHandler.OnLayerTemplateEvent();
	}
	
	return false;
}
