/*------------------------------------------------------------------------------*
 * File Name:	QueryBldrDlg.c 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY AW 03/16/06 ADD_RECENT_FILE_LIST_CLASS									*
 *	CPY 11/4/2007 CLEAN_ERR_MSG													*
 *	CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include "DialogEx.h"
#include <okocUtils.h> ///--- CPY 11/4/2007 CLEAN_ERR_MSG
#include "datasource.h"
#include "FileList.h"		///CPY AW 03/16/06 ADD_RECENT_FILE_LIST_CLASS
#include "QueryBldrDlg.h"

BOOL testQ()
{
	ADOBuildQueryDlg dlgADO;
	HWND hParent = GetWindow();
	dlgADO.DoModalEx(hParent);
	return dlgADO.IsValid();
}

static QueryEditDlg* s_pEditSQLdlg = NULL; //--CPY 4/21/06 change into using pointer
static ADOBuildQueryDlg* s_pADODlg = NULL;

BOOL ADOBuildQueryDlg::OnShowSQLBox(Control ctrl)
{
	//---CPY 4/21/06 rewritten this part to use pointer
	if(s_pEditSQLdlg)
	{
		Window winDlg = s_pEditSQLdlg->GetWindow();
		if(winDlg)
			winDlg.SendMessage(WM_CLOSE);
		delete s_pEditSQLdlg;
		s_pEditSQLdlg = NULL;
		//Button btn = GetItem(IDC_ADO_BN_SQL);
		m_btnShowSQL.Text = STR_SHOW_SQL;
		return true;
	}
	// show
	s_pEditSQLdlg = new QueryEditDlg;
	s_pEditSQLdlg->Create(GetSafeHwnd());
	Window winDlg = s_pEditSQLdlg->GetWindow();
	if( winDlg )	//open success 
	{
		s_pEditSQLdlg->ShowDialog();
		//Button btn = GetItem(IDC_ADO_BN_SQL);
		m_btnShowSQL.Text = STR_HIDE_SQL;
		s_pEditSQLdlg->UpdateQueryText(m_strSQL);
	}
	else
	{
		//---- CPY 11/4/2007 CLEAN_ERR_MSG
		//out_str("fail to open Query Edit Box!");
		okoc_out_msg(_L("Fail to open Query Edit Box!"), 'E');
		//----
		delete s_pEditSQLdlg;
		s_pEditSQLdlg = NULL;
	}
	return false;
}


void ADOBuildQueryDlg::updateSQLBox(LPCSTR lpcszSQL) //= NULL
{
	if(s_pEditSQLdlg)	//Query Edit Box is open
	{
		if(lpcszSQL)
			s_pEditSQLdlg->UpdateQueryText(lpcszSQL);
		else
			s_pEditSQLdlg->UpdateQueryText(m_strSQL);
	}
}
string ADOBuildQueryDlg::getSQLBoxStr()
{
	string strSQL;
	if(s_pEditSQLdlg)	//Query Edit Box is open
		strSQL = s_pEditSQLdlg->GetQueryText();
	
	return strSQL;
}

BOOL QueryEditDlg::OnDestroy()
{
	m_edSQL.Text = "";
	Window Wnd = GetParent();
	HWND hwnd = Wnd.GetSafeHwnd();
	if(Wnd)
		Wnd.PostMessage(WM_USER_SQL_BOX_CLOSE);
	ResizeDialog::OnDestroy();
	//--- CPY 4/21/06
	delete this;
	s_pEditSQLdlg = NULL;
	//---
	return true;
}

//------------------ CPY 1/21/2008 QA70-10972-P3 QUERY_BUILDER_SHOULD_BE_MODAL
//int QueryBldrDlg(int nMsg, DWORD dwCntrl)
int QueryBldrDlg(Worksheet& wks)
{
	///Sophy 10/27/2011 ORG-3865-P1 ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT
#ifdef	_OWIN64
	{
		///Sophy 12/2/2011 ORG-3935-S1 MSG_FOR_TOOLS_NOT_SUPPORTED_IN_ORIGIN_64BIT
		//warning_msg_box(_L("Query Builder is not supported in 64bit Origin."), true, 'E');
		string strMsg;
		strMsg.Format(STR_NOT_SUPPORT_MSG, _L("Query Builder"));
		warning_msg_box(strMsg, true, 'E');
		///end MSG_FOR_TOOLS_NOT_SUPPORTED_IN_ORIGIN_64BIT
		return IDCANCEL;
	}
#endif	//_OWIN64
	///end ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT	
	ADOBuildQueryDlg myQB(wks);
	
	return myQB.DoModalEx();
}
int QueryBldrDlgModeless(int nMsg, DWORD dwCntrl)
//------------------
{	
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	Window winDlg;
	
	// if close
	if(bClose)
	{
		if( s_pADODlg )
		{
			winDlg = s_pADODlg->GetWindow();
			if( winDlg )
				//winDlg.SendMessage(WM_CLOSE);
				DestroyWindow(winDlg.GetSafeHwnd());
			delete s_pADODlg;
			s_pADODlg = NULL;
		}
		return true;
	}
	
	// Open or Visiable
	if(NULL == s_pADODlg)
		s_pADODlg = new ADOBuildQueryDlg;

	winDlg = s_pADODlg->GetWindow();
	if(!winDlg)
		s_pADODlg->Create(GetWindow());
	else
	{
		/// AW 06/05/2006 MORE_ON_LOAD_ODQ
		if ( 0 !=  dwCntrl )
		{
			return s_pADODlg->UpdateDlgFromWks();			
		}
		/// END MORE_ON_LOAD_ODQ
		//---- CPY 11/4/2007 CLEAN_ERR_MSG
		//out_str("Query Builder already open.");
		okoc_out_msg(_L("Query Builder already open."), 'W');
		//----
		return false;
	}
	winDlg = s_pADODlg->GetWindow();
	if(winDlg)
		s_pADODlg->ShowDialog(); // in case it was rollled up
	else
		//---- CPY 11/4/2007 CLEAN_ERR_MSG
		//out_str("failed to open dialog");
		okoc_out_msg(_L("Failed to open dialog"), 'E');
		//----
	
	return true;
}

