/*------------------------------------------------------------------------------*
 * File Name:	ProjectBrowser.c												*
 * Creation: Frank	5/24/05														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 7/26/05 CHANGE_TO_INLINE_FUNCTION										*
 *	Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL						*
 *	Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER							*
 *	Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER			*
 *	Jasmine 05/08/07 QA80-9654 OPEN_COLUMN_BROWSER								*
 *	Jasmine 05/31/07 ADD_OPTION_TO_EXCLUDE_SPECIFIED_PAGE						*
 *	Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET									*
 *	Folger 07/13/07 OPEN_MATOBJ_BROWSER											*
 *	Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED			*
 *	Jasmine 02/21/10 QA81-14826-P1 GIVE_A_BETTER_NAME_TO_SHEET_BROWSER			*
 *	Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET				*
 *	EJP 2012-03-22 ORG-4928 ADD_GRAPH_BROWSER_TO_VIDEO_BUILDER					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "DialogEx.h"
//#include <Profiler.h>
//#define HOUR_GLASS			///waitCursor junk;
//#define _SHOW_TIME		///	Profiler junk;
#define	STR_DLG_NAME			"Project Browser"
#define PROJECT_LIST_CLASS				PBLayerList
//#define PROJECT_LIST_CLASS				PBPageList
#include "ProjectBrowser.h"
#define		CHAR_FILENAME_SEPARATOR  	'"'


#define  _DMSG_PB(_str)  //out_str(_str);
///Example
/**

void find_pb_book()  
{
	string strSelectedName;
	string strPath = "Originlab\\ProjectBrowser.c";
	FUNC_STR_DWORD_HWND_BOOL pfn = Project.FindFunction("ProjectBrowseBook", strPath);
	
	if(pfn)
	{
		if(pfn(strSelectedName, 0, GetWindow(), true))
			printf("Selected Book name %s\n", strSelectedName);
	}
}
void find_pb_layer()
{
	string strSelectedName;
	string strPath = "Originlab\\ProjectBrowser.c";
	FUNC_STR_DWORD_HWND_LPCSTR pfn = Project.FindFunction("ProjectBrowseSheet", strPath);
	
	if(pfn)
	{
		if(pfn(strSelectedName, 0, GetWindow(), NULL))
			printf("Selected Book name %s\n", strSelectedName);
	}
}
void find_pb_graphs()
{
	string strSelectedName;
	string strPath = "Originlab\\ProjectBrowser.c";
	FUNC_VECTOR_STR_DWORD_HWND_BOOL pfn = Project.FindFunction("ProjectBrowseGraphs", strPath);
	vector<string> vs;
	if(pfn)
	{
		if(pfn(vs, 0, GetWindow(), 0))
			printf("Selected Book name %s\n", strSelectedName);
	}
}

void find_pb_columns()
{
	BOOL bMultipleSelect = true;
	string strSelectedName, strInput;// = "[Book1]GaussFit.DAT!1, [Book1]GaussFit.DAT!3";
	vector<string> vs;
	//---CPY
	Worksheet wks = Project.ActiveLayer();
	if(wks)
	{
		int nC2 = wks.GetNumCols()-1;
		strInput = make_range_string(wks, wks.Columns(0).GetName(), wks.Columns(0).GetName());

	}
	vs.Add(strInput);
	//----
	string strPath = "Originlab\\ProjectBrowser.c";
	FUNC_VECTOR_STR_DWORD_HWND_BOOL pfn = Project.FindFunction("ProjectBrowseColumns", strPath);
	if(pfn)
	{
		if(pfn(vs, 0, GetWindow(), bMultipleSelect))
			printf("Selected Book name %s\n", strSelectedName);
	}
}
*/
static ProjectBrowserDlg s_PBDlg; 
bool OpenPB()
{
	Window winDlg = s_PBDlg.GetWindow();
	
	s_PBDlg.SetPBDlgOption();
	
	if(winDlg)
	{
		out_str("Dialog already open");
		return false;
	}
	int nRet = s_PBDlg.Create(GetWindow());
	return true;
} 


///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER

///Jasmine 05/08/07 QA80-9654 OPEN_COLUMN_BROWSER
//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
//BOOL ProjectBrowseColumns(vector<string>& vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true, LPCSTR lpcszExcludeGraph = NULL)///Jasmine 05/31/07 ADD_OPTION_TO_EXCLUDE_SPECIFIED_PAGE
BOOL ProjectBrowseColumns(vector<string>& vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true, LPCSTR lpcszExcludeGraph = NULL, bool bResultSheet = false)
//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
{
	vector<int> vn = {EXIST_WKS};	
	///Jasmine 02/21/10 QA81-14826-P1 GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	//ProjectBrowserDlg  PBDlg(_L("Project Browser Column(s)"), true);//bMultipleSelect);	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION, always show bottom grid
	ProjectBrowserDlg  PBDlg(_L("Column Browser"), true);
	///End GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	//PBDlg.SetPBDlgOption(PB_BROWSER_OBJECT_LIST, vn ,bMultipleSelect, PTL_LAYER);
	PBDlg.SetPBDlgOption(PB_BROWSER_OBJECT_LIST, vn ,bMultipleSelect, PTL_LAYER, NULL, bResultSheet);
	//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	
	string strInput;
	strInput.SetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	PBDlg.SetDefaultShow(strInput);
	
	Window winDlg(hWnd);
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;
		
	int nRet=PBDlg.DoModal( hParent ); 
	
	string strResult = PBDlg.GetSelectedPages();
	strResult.TrimLeft(CHAR_RANGE_SEPARATOR);
	strResult.TrimRight(CHAR_RANGE_SEPARATOR);
	strResult.GetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	if( 0 == vsResult.GetSize())
		return FALSE;
	return TRUE;
}
///End OPEN_COLUMN_BROWSER
//End IMPROVE_PB_FOR_COLUMN_BROWSER

//-------Folger 07/13/07 OPEN_MATOBJ_BROWSER
BOOL ProjectBrowseMatObjs(vector<string>& vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true, LPCSTR lpcszExcludeGraph = NULL, bool bResultSheet = false)
{
	vector<int> vn = {EXIST_MATRIX};	
	///Jasmine 02/21/10 QA81-14826-P1 GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	//ProjectBrowserDlg  PBDlg(_L("Project Browser MatObj(s)"), true);
	ProjectBrowserDlg  PBDlg(_L("Matrix Browser"), true);
	///End GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	PBDlg.SetPBDlgOption(PB_BROWSER_OBJECT_LIST, vn ,bMultipleSelect, PTL_LAYER);
	
	string strInput;
	strInput.SetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	PBDlg.SetDefaultShow(strInput);
	
	Window winDlg(hWnd);
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;
		
	int nRet=PBDlg.DoModal( hParent ); 
	
	string strResult = PBDlg.GetSelectedPages();
	strResult.TrimLeft(CHAR_RANGE_SEPARATOR);
	strResult.TrimRight(CHAR_RANGE_SEPARATOR);
	strResult.GetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	if( 0 == vsResult.GetSize())
		return FALSE;
	return TRUE; 
}
//-------End OPEN_MATOBJ_BROWSER

//pick WB or MB
BOOL ProjectBrowseBook(string& strResult, DWORD dwHwnd, HWND hWnd, bool bWks = true)
{
	vector<int> vn = {EXIST_WKS};
	
	/// Iris 04/03/2007 v8.0595 CHANGE_TITLE from Snow's email
	//string 		strPBTitle = "Project Browser Worksheet";
	string 		strPBTitle = _L("Workbook Browser");
	///end CHANGE_TITLE
	
	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	//int			nPageType = EXIST_WKS;
	if(!bWks)
	{
		vn.RemoveAll();
		vn.Add(EXIST_MATRIX);
		/// Iris 04/03/2007 v8.0595 CHANGE_TITLE
		//strPBTitle = "Project Browser Matrix";
		strPBTitle = _L("Matrix Browser");
		///end CHANGE_TITLE
		//nPageType = EXIST_MATRIX;
	}
	
	ProjectBrowserDlg  PBDlg(strPBTitle );	
	
	//PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST,vn ,SINGLE_SELECT, EXIST_WKS);	///Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL
	//PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST, vn, SINGLE_SELECT, PTL_FOLDER, EXIST_WKS);  /// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	//PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST, vn, SINGLE_SELECT, PTL_FOLDER, nPageType);
	PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST, vn, SINGLE_SELECT, PTL_FOLDER);
	///End BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	/*Window winDlg = PBDlg.GetWindow();
	if(winDlg)
	{
		out_str("Project Browser Dialog already open");
		return false;
	}
	int nRet=PBDlg.DoModal( NULL ); 
	*/
	Window winDlg(hWnd);// = PBDlg.GetWindow();
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;
		
	int nRet=PBDlg.DoModal( hParent ); 
	
	strResult = PBDlg.GetSelectedPages();
	return true;
}
//pick Worksheet
///strResult = [book1]:Sheet2
/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
//	BOOL ProjectBrowseSheet(string& strResult, DWORD dwHwnd, HWND hWnd)
///Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET
//BOOL ProjectBrowseSheet(string& strResult, DWORD dwHwnd, HWND hWnd, LPCSTR lpcszDefaultShow)///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
//BOOL ProjectBrowseSheets(vector<string> &vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true)
BOOL ProjectBrowseSheets(vector<string> &vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect = true, bool bIncludeReportSheet = false)
///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
///End MODIFY_PROJECT_BROWSE_SHEET
/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
{
	vector<int> vn = {EXIST_WKS};
	string strPBTitle = _L("Sheet Browser");//_L("Project Browser Sheets");///Jasmine 02/21/10 QA81-14826-P1 GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	///Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET
	//ProjectBrowserDlg  PBDlg(strPBTitle );
	ProjectBrowserDlg  PBDlg(strPBTitle, bMultipleSelect);
	///End MODIFY_PROJECT_BROWSE_SHEET
	//PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST,vn ,SINGLE_SELECT, EXIST_WKS);///Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL
	//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
	//PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST,vn ,SINGLE_SELECT, PTL_FOLDER, EXIST_WKS);
	//PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST,vn ,SINGLE_SELECT, PTL_PAGE, EXIST_WKS);
	///Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET
	//PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST, vn ,SINGLE_SELECT, PTL_PAGE);
	///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
	//PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST, vn ,bMultipleSelect, PTL_PAGE);
	PBDlg.SetPBDlgOption(PB_BROWSER_LAYER_LIST, vn ,bMultipleSelect, PTL_PAGE, NULL, bIncludeReportSheet);
	///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
	///End MODIFY_PROJECT_BROWSE_SHEET
	//-----
	
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	///Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET
	//PBDlg.SetDefaultShow(lpcszDefaultShow);///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
	string strInput;
	strInput.SetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	PBDlg.SetDefaultShow(strInput);
	///End MODIFY_PROJECT_BROWSE_SHEET
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	/*
	Window winDlg = PBDlg.GetWindow();
	if(winDlg)
	{
		out_str("Project Browser Dialog already open");
		return false;
	}
	int nRet=PBDlg.DoModal( NULL ); 
	*/
	Window winDlg(hWnd);// = PBDlg.GetWindow();
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;
		
	int nRet=PBDlg.DoModal( hParent ); 
	
	///Folger 06/20/07 MODIFY_PROJECT_BROWSE_SHEET
	//strResult = PBDlg.GetSelectedPages();
	string strResult = PBDlg.GetSelectedPages();
	strResult.TrimLeft(CHAR_RANGE_SEPARATOR);
	strResult.TrimRight(CHAR_RANGE_SEPARATOR);
	strResult.GetTokens(vsResult, CHAR_RANGE_SEPARATOR);
	if( 0 == vsResult.GetSize())
		return FALSE;
	///End MODIFY_PROJECT_BROWSE_SHEET
	return true;
}
///strResult = [book1]:Sheet2!
BOOL ProjectBrowseGraphs(vector<string>& vsGraphs, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect)
{
	vector<int> vn = {EXIST_GRAPH};
	string strPBTitle = _L("Graph Browser");//_L("Project Browser Graphs");///Jasmine 02/21/10 QA81-14826-P1 GIVE_A_BETTER_NAME_TO_DIFFERENT_BROWSER
	
	ProjectBrowserDlg  PBDlg(strPBTitle, true);	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	
	//PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST,vn ,MULTIPLE_SELECT, EXIST_GRAPH);///Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL
	//PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST,vn ,MULTIPLE_SELECT, PTL_FOLDER, EXIST_GRAPH);	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	/// EJP 2012-03-22 ORG-4928 ADD_GRAPH_BROWSER_TO_VIDEO_BUILDER
	///PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST,vn ,MULTIPLE_SELECT, PTL_FOLDER);
	PBDlg.SetPBDlgOption(PB_BROWSER_PAGE_LIST,vn ,(bMultipleSelect ? MULTIPLE_SELECT : SINGLE_SELECT), PTL_FOLDER);
	/// end ADD_GRAPH_BROWSER_TO_VIDEO_BUILDER
	Window winDlg(hWnd);// = PBDlg.GetWindow();
	HWND hParent = GetWindow();
	if(winDlg)
		hParent = hWnd;
		
	int nRet=PBDlg.DoModal( hParent ); 
	
	string strSel = PBDlg.GetSelectedPages();

	strSel.TrimLeft(CHAR_FILENAME_SEPARATOR);
	strSel.TrimRight(CHAR_FILENAME_SEPARATOR);
	strSel.GetTokens(vsGraphs, CHAR_FILENAME_SEPARATOR);
	if( 0 == vsGraphs.GetSize())
		return FALSE;

	return true;
}

void OpenPBMo()
{
	vector<int> vn = {EXIST_WKS};
	PBopen(NULL, vn);
}

void test_pb()
{
	string str = PBUsingWksSelect();
	out_str("Selected page is "+ str);
}
string PBUsingWksSelect(HWND hParent = NULL)
{
	string strTitle = _L("Select One Workbook");
	string strSelectPage ;
	vector<int> vn = {/*EXIST_WKS,*/ EXIST_GRAPH/*, EXIST_MATRIX*/};
	//strSelectPage = PBopen(hParent,vn,strTitle,SINGLE_SELECT, EXIST_GRAPH);
	//strSelectPage = PBopen(hParent,vn,strTitle,SINGLE_SELECT, EXIST_WKS);
	//strSelectPage = PBopen(hParent,vn,strTitle,SINGLE_SELECT, EXIST_NONE);
///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE	
	strSelectPage = PBopen(hParent,vn,strTitle,MULTIPLE_SELECT, true);
	return strSelectPage;
}
///Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL
//string PBopen(HWND hParent = NULL, vector<int> &vnTypeList = NULL, string strTitle = "Project Browser", int nSelectedMode =MULTIPLE_SELECT, int nOnlyShowLayers  =  EXIST_NONE)	//modal dialog	
//string PBopen(HWND hParent = NULL, vector<int> &vnTypeList = NULL, string strTitle = "Project Browser", int nSelectedMode =MULTIPLE_SELECT, int nLevel = PTL_FOLDER, int nOnlyShowLayers  =  EXIST_NONE)
string PBopen(HWND hParent = NULL, vector<int> &vnTypeList = NULL, string strTitle = "Project Browser", int nSelectedMode =MULTIPLE_SELECT, int nLevel = PTL_FOLDER, bool bMultiPane = false)
{
	string strEmpty;
	//ProjectBrowserDlg  PBDlg;
	//ProjectBrowserDlg  PBDlg(strTitle , nSelectedMode,nOnlyShowLayers);
	//ProjectBrowserDlg  PBDlg(strTitle , vnTypeList, nSelectedMode,nOnlyShowLayers);
	ProjectBrowserDlg  PBDlg(strTitle, bMultiPane);
	
	//PBDlg.SetPBDlgOption( PB_BROWSER_PAGE_LIST, vnTypeList, nSelectedMode, nOnlyShowLayers);///Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL
	//PBDlg.SetPBDlgOption( PB_BROWSER_PAGE_LIST, vnTypeList, nSelectedMode, nLevel, nOnlyShowLayers);
	PBDlg.SetPBDlgOption( PB_BROWSER_OBJECT_LIST, vnTypeList, nSelectedMode, PTL_LAYER);
///End BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	Window winDlg = PBDlg.GetWindow();
	if(winDlg)
	{
		out_str("Project Browser Dialog already open");
		return strEmpty;
	}
	if(NULL == hParent)
		hParent=GetWindow();
	int nRet=PBDlg.DoModal( hParent ); 

	if(IDOK == nRet || IDCLOSE == nRet || IDCANCEL == nRet)
		return PBDlg.GetSelectedPages();
	
	return strEmpty;
}