/*------------------------------------------------------------------------------*
 * File Name: PickPeak.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET		*
 *	Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK		*
 *	Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL					*
 *	Jasmine 11/30/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING	*
 *	Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO	*
 *	Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM			*
 *	Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR						*
 *	Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA				*
 *	Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE				*
 *	Jasmine 12/09/10 ORG-1697-S1 OUTPUT_MORE_PEAK_QUANTITIES					*
 *	Jasmine 12/09/10 ORG-1697-S2 ADD_MORE_SETTINGS_FOR_OUTPUT					*
 *	Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI								*
 *	Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI				*
 *------------------------------------------------------------------------------*/

#ifndef _PICK_PEAK_H__
#define _PICK_PEAK_H__

enum
{
	PEAK_PICK_BRANCH_ID_BASELINE				= 1,
	PEAK_PICK_BRANCH_ID_FIND_PEAK,
	///------ Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	PEAK_PICK_BRANCH_ID_AREA,
	///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	PEAK_PICK_BRANCH_ID_ROI_BOX,
	
	PEAK_PICK_BRANCH_ID_EXISTING_DATASET,
	PEAK_PICK_BRANCH_ID_DATASET_RANGE1,

	PEAK_PICK_BRANCH_ID_REFERENCE_DATA,
	PEAK_PICK_BRANCH_ID_DATA_RANGE1,

	//PEAK_PICK_BRANCH_ID_DIRECTION,
	PEAK_PICK_BRANCH_ID_PEAK_FINDING_SETTINGS,
	PEAK_PICK_BRANCH_ID_DERIV_SMOOTH,
	PEAK_PICK_BRANCH_ID_PEAK_FILTERING,
	PEAK_PICK_BRANCH_ID_PEAK_DISPLAY,
	PEAK_PICK_BRANCH_ID_RESULT,
	PEAK_PICK_BRANCH_ID_XSCALE,
	///Jasmine 12/09/10 ORG-1697-S1 OUTPUT_MORE_PEAK_QUANTITIES
	PEAK_PICK_BRANCH_ID_QUANTITIES,
	PEAK_PICK_BRANCH_ID_OUTPUT_QUANTITIES,
	///End OUTPUT_MORE_PEAK_QUANTITIES
	
	///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
	PEAK_PICK_BRANCH_ID_DISPLAY_PEAK_MARKER,
	PEAK_PICK_BRANCH_ID_DISPLAY_PEAK_LABEL,
	PEAK_PICK_BRANCH_ID_DISPLAY_BASE_MARKER,
	///End MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
};

enum
{
	PEAK_PICK_VAR_ID_BASELINE_MODE		= DATAID_USER_BASE,
	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	PEAK_PICK_VAR_ID_BASELINE_RANGE,
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE
	//PEAK_PICK_VAR_ID_EXISTING_DATASET,
	PEAK_PICK_VAR_ID_DATASET_X,
	PEAK_PICK_VAR_ID_DATASET_Y,
	PEAK_PICK_VAR_ID_DATASET_ED,
	PEAK_PICK_VAR_ID_BASELINE_CONST,
	PEAK_PICK_VAR_ID_BASELINE_CREATION,
	//PEAK_PICK_VAR_ID_REFERENCE_DATA,
	PEAK_PICK_VAR_ID_DATA_X,
	PEAK_PICK_VAR_ID_DATA_Y,
	PEAK_PICK_VAR_ID_DATA_ED,
	PEAK_PICK_VAR_ID_Y_BASE,
	///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
	PEAK_PICK_VAR_ID_BASELINE_SMOOTH_METHOD,
	PEAK_PICK_VAR_ID_BASELINE_WIN_SIZE,
	PEAK_PICK_VAR_ID_BASELINE_THRESHOLD,
	PEAK_PICK_VAR_ID_BASELINE_POLY_ORDER,
	///End IMPROVE_BASELINE_DETECTION
	//PEAK_PICK_VAR_ID_BASELINE_SNAP,		///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
	PEAK_PICK_VAR_ID_BASELINE_N_POINTS,
	PEAK_PICK_VAR_ID_BASELINE_CONNECT,
	
	PEAK_PICK_VAR_ID_BASELINE_ENDPOINT, ///Jasmine 12/06/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING

	//PEAK_PICK_VAR_ID_POSITIVE,
	//PEAK_PICK_VAR_ID_NEGATIVE,
	PEAK_PICK_VAR_ID_DIRECTION,

	PEAK_PICK_VAR_ID_METHOD,
	PEAK_PICK_VAR_ID_LOCAL_POINTS,
	PEAK_PICK_VAR_ID_SIZE_OPTION,
	PEAK_PICK_VAR_ID_HEIGHT,
	PEAK_PICK_VAR_ID_WIDTH,

	PEAK_PICK_VAR_ID_FIRST,
	PEAK_PICK_VAR_ID_SECOND,
	PEAK_PICK_VAR_ID_FFT_CUTOFF,
	PEAK_PICK_VAR_ID_DERIV_POLY,
	PEAK_PICK_VAR_ID_DERIV_NPTS,

	PEAK_PICK_VAR_ID_FILTER,
	//PEAK_PICK_VAR_ID_VALUE,
	PEAK_PICK_VAR_ID_VAL_HEIGHT,
	PEAK_PICK_VAR_ID_VAL_NUM,

	PEAK_PICK_VAR_ID_OUTPUT,
	///Jasmine 12/09/10 ORG-1697-S2 ADD_MORE_SETTINGS_FOR_OUTPUT
	PEAK_PICK_VAR_ID_OUTPUT_SCRIPT_WIN,
	PEAK_PICK_VAR_ID_OUTPUT_RESULT_LOG,
	PEAK_PICK_VAR_ID_OUTPUT_CHECK,
	
	PEAK_PICK_VAR_ID_OUTPUT_BASE_CHECK,
	PEAK_PICK_VAR_ID_OUTPUT_BASE,
	///End ADD_MORE_SETTINGS_FOR_OUTPUT
	
	///Jasmine 12/09/10 ORG-1697-S1 OUTPUT_MORE_PEAK_QUANTITIES
	PEAK_PICK_VAR_ID_DATASET,
	PEAK_PICK_VAR_ID_PEAK_ID,
	PEAK_PICK_VAR_ID_PEAK_ROW,
	PEAK_PICK_VAR_ID_PEAK_X,
	PEAK_PICK_VAR_ID_PEAK_Y,
	PEAK_PICK_VAR_ID_PEAK_HEIGHT,
	PEAK_PICK_VAR_ID_PEAK_AREA,
	PEAK_PICK_VAR_ID_PERCENT_AREA,
	PEAK_PICK_VAR_ID_CURVE_AREA,
	PEAK_PICK_VAR_ID_FWHM,
	PEAK_PICK_VAR_ID_CENTROID,
	PEAK_PICK_VAR_ID_LEFT_HALF_WIDTH,
	PEAK_PICK_VAR_ID_RIGHT_HALF_WIDTH,
	PEAK_PICK_VAR_ID_LEFT_BASE_MARKER_INDEX,
	PEAK_PICK_VAR_ID_LEFT_BASE_MARK_X,
	PEAK_PICK_VAR_ID_LEFT_BASE_MARK_Y,
	PEAK_PICK_VAR_ID_RIGHT_BASE_MARKER_INDEX,
	PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_X,
	PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_Y,
	PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_INFO,
	///End OUTPUT_MORE_PEAK_QUANTITIES

	///------ Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	PEAK_PICK_VAR_ID_INTEGFROM,
	PEAK_PICK_VAR_ID_SHOW_INTEG_AREA,
	///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

	PEAK_PICK_VAR_ID_LEFT_X,
	PEAK_PICK_VAR_ID_RIGHT_X,
	PEAK_PICK_VAR_ID_FIXSCALE,

	PEAK_PICK_VAR_ID_TOOL_NAME,
	///------ Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL
	PEAK_PICK_VAR_ID_SHOW_PEAK_NUM,
	///------ End SHOW_PEAK_NUM_ON_ROI_LABEL
	PEAK_PICK_VAR_ID_RECT_COLOR,

	///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
	PEAK_PICK_VAR_ID_PEAK_MARKER_COLOR,
	///------ End SUPPORT_PEAK_MARKER_COLOR
	
	PEAK_PICK_VAR_ID_SHOW_LABEL,
	PEAK_PICK_VAR_ID_CENTER_LABEL,
	PEAK_PICK_VAR_ID_ROLATE_LABEL,
	PEAK_PICK_VAR_ID_LABEL_COLOR,

	///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	PEAK_PICK_VAR_ID_BASE_MARKER_COLOR,
	///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	
	/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
	PEAK_PICK_VAR_ID_LABEL_HIRIZONTAL,
	/// end NEW_PEAK_DISPLAY_GUI
	
	///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
	PEAK_PICK_VAR_ID_PEAK_MARKER_SIZE,
	PEAK_PICK_VAR_ID_BASE_MARKER_SIZE,
	///End MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
};

///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
///Sophy 10/21/2011 CENTRALIZE_BASELINE_RANGE_CODE
//enum
//{
	//PEAK_BASELINE_RANGE_FULL			= 0,
	//PEAK_BASELINE_RANGE_WITHIN_ROI,
//};
///end CENTRALIZE_BASELINE_RANGE_CODE
///------ End CREATE_BASELINE_USING_WHOLE_CURVE

enum
{
	///------ Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
	PEAK_BASELINE_MODE_NONE,
	///------ End ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
	PEAK_BASELINE_MODE_CONSTANT,
	PEAK_BASELINE_MODE_AUTO,
	PEAK_BASELINE_MODE_USE_EXISTING_DATASET,
	PEAK_BASELINE_MODE_USE_MINMAX,
	PEAK_BASELINE_MODE_END_POINT_WEIGHTED,	///Jasmine 12/06/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
};

enum
{
	PEAK_BASELINE_CREATION_GLOBAL,
	PEAK_BASELINE_CREATION_SEPARATE,
};

enum
{
	PEAK_BASELINE_CONST_MIN,
	PEAK_BASELINE_CONST_MAX,
	PEAK_BASELINE_CONST_MEAN,
	PEAK_BASELINE_CONST_MEDIAN,
	PEAK_BASELINE_CONST_CUSTOM,
};

enum
{
	PEAK_BASELINE_CONNECT_METHOD_LINE,
	PEAK_BASELINE_CONNECT_METHOD_SPLINE,
	PEAK_BASELINE_CONNECT_METHOD_BSPLINE,
};

enum
{
	PEAK_DIRECTION_POSITIVE,
	PEAK_DIRECTION_NEGATIVE,
	PEAK_DIRECTION_BOTH
};

enum
{
	PEAK_FINDING_METHOD_MAX,
	PEAK_FINDING_METHOD_WIN,
	PEAK_FINDING_METHOD_FIRST,
	PEAK_FINDING_METHOD_SECOND,
	PEAK_FINDING_METHOD_RESIDUE,
};

enum
{
	SIZE_OPTION_RAW_SIZE,
	SIZE_OPTION_PERCENT_OF_RAW_DATA,
};

enum
{
	PEAK_FILTER_NONE,
	PEAK_FILTER_HEIGHT,
	PEAK_FILTER_NUM,
};

enum
{
	PEAK_CENTER_LABEL_X,
	PEAK_CENTER_LABEL_Y,
	//PEAK_CENTER_LABEL_INDICES,
	PEAK_CENTER_LABEL_XY,
};

struct BaselineInfo
{
	int		m_nMode;

	string	m_strRefer;

	int		m_nConstant;
	double	m_dCustom;

	double	m_dEndPoints;	///Jasmine 11/30/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	
	///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
	int		m_nSmoothMethod;
	int		m_nWindowSize;
	double	m_dThreshold;
	int		m_nPolyOrder;
	///End IMPROVE_BASELINE_DETECTION
	int		m_nAnchor;
	//bool	m_bSnap;		///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
	int		m_nConnect;
};

///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
#define STR_PICKPEAK_BASELINE_SMOOTHMETHOD			_L("Smoothing Method")
#define STR_PICKPEAK_BASELINE_SMOOTHMETHOD_LIST 	_L("Adjacent-Averaging|Savitzky-Golay")
#define STR_PICKPEAK_BASELINE_WINDOWSIZE		 	_L("Window Size")
#define STR_PICKPEAK_BASELINE_THRESHOLD				_L("Threshold")
#define STR_PICKPEAK_BASELINE_OLYORDER				_L("Polynomial Order")
///End IMPROVE_BASELINE_DETECTION

///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA
#define STR_DATASETOBJ_SOURCE_CURVE			"PickPeakSource"
///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA

bool	baseline_creation_multi_sel_attrib_access(TreeNode& trBaseline, bool bGet = true, bool bMultiSel = false);

void	construct_pick_peak_gui(TreeNode& trGUI);

int		open_pick_peak_tool(TreeNode& trGUI);
///Sophy 3/5/2011 ORG-2351-P1 CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
bool	quick_peaks_error_check(TreeNode& trGetN, string& strErrMsg, bool bShowError = false);
///end CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
//move to GraphObjTools.c/h
//bool	check_update_roi_x_position(TreeNode& trXScale);
#define XFNAME					"addtool_quickpeaks"
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
bool convert_pickpeak_settings_to_pa_theme(const TreeNode& trPickPeak, LPCSTR lpczPATheme);
///End QUICK_PEAKS_SWICTH_TO_PA
#endif // _PICK_PEAK_H__
