/*------------------------------------------------------------------------------*
 * File Name: PickPeak.cpp	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 03/18/10 QA81-15209 IMPROVE_PA_FIND_PEAKS_FOR_NONE_BASELINE			*
 *	Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET		*
 *	Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION							*
 *	Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK		*
 *	Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE				*
 *	Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL					*
 *	Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO	*
 *	Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK				*
 *	Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM			*
 *	Folger 12/07/2010 ORG-1652-S1 SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES*
 *	Folger 12/07/2010 ORG-1652-S3 ADD_PEAK_ID_AND_INDEX_TO_REPORT				*
 *	Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR						*
 *	Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA				*
 *	Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE				*
 *	Folger 12/08/2010 ORG-1675-S8 BASE_MARKER_FOLLOW_BASELINE_RANGE				*
 *	Folger 12/08/2010 ORG-1675-S2 BETTER_HINT_FOR_BASELINE_MODE					*
 *	Folger 12/15/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA*
 *	Folger 12/31/2010 ORG-1897-P1 REDUNDANT_LABEL_SHOW_FOR_RIGHT_BASE_MARKER	*
 *	Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
 *	Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
 *	Kyle 01/10/2011 ORG-1736-S3 IMPROVE_HINTS_FOR_MIN_MAX_MODE					*
 *	Kyle 01/10/2011 ORG-1736-S5 BETTER_LABEL_FOR_OUTPUT_BASELINE				*
 *	Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA	*
 *	Kyle 01/14/2011 ORG-2031-P1 HANDLE_INPUT_EVEN_SAMPLING						*
 *	Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
 *	Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
 *	Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI								*
 *	Hong 01/20/11 ORG-2067-P1 DEFAULT_SIZE_TOO_LARGE_SAID_SNOW					*
 *	Hong 01/21/11 ORG-2067-P2 MARKER_OBJ_DEFAULT_SHOULD_DISABLE_MOVE			*
 *	Hong 01/24/11 ORG-2067-S1 MARKER_LABEL_NON_EXPANDABLE						*
 *	Hong 01/20/11 ORG-2067-P3  CENTRE_LABEL										*
 *	Sophy 1/25/2011 ORG-2099-S2 QUICKPEAKS_REPORT_MULTIPEAKS_INFO_WITH_MERGE_ROWS
 *	Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING	*
 *	Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE					*
 *	Kit 02/21/2011 ORG-2229-P2 BRING_ALL_RELATE_OBJS_TO_FRONT_WHEN_CLICK_TRIANGLE_BTN
 *	Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
 *	Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI				*
 *	Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET			*
 *	Folger 04/26/2011 ORG-2647-P1 QUICK_PEAKS_OUTPUT_CURVE_SHOULD_BE_DELETED_AFTER_PARENT_PLOT_IS_REMOVED
 *	Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA		*
 *	Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND			*
 *	Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA						*
 *	Kyle 06/14/2011 ORG-2507-P1 FIND_PEAKS_RETURN_ORDER_FOR_PEAK_INDICES		*
 *	Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA	*
 *	Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Jasmine 05/30/2012 ORG-1352-S1 CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
 *	Jasmine 06/25/2012 ORG-1352-P2 END_POINTS_WEIGHTED_READY_IN_PA				*
 *	Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
 *	Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS	*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
#include <event_utils.h>
#include "nlsf_utils.h"
/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
#include "DialogEx.h"
#define		BASE_WINDOW		ResizeDialog
#define		DYNA_TAB_ID		IDC_PICK_PEAK_TAB
#include "dynadlg.h"
#include "PickPeak.h"

#include "curve_utils.h"
#include "grobj_utils.h"
#include "GraphObjTools.h"
#include "graph_utils.h"


/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
#define		SYMBOL_SHAPE		16
/// Hong 01/20/11 ORG-2067-P1 DEFAULT_SIZE_TOO_LARGE_SAID_SNOW
//#define		SYMBOL_SIZE			25
#define		SYMBOL_SIZE			20
/// end DEFAULT_SIZE_TOO_LARGE_SAID_SNOW
/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
#define		MARKER_LABEL_CUSTOM_COLL_TAGNAME				"Points"
#define		MARKER_LABEL_CUSTOM_ITEM_TAGNAME_PREFIX			"Point"
/// end PEAK_MARKER_BE_POSITION_SENSITIVE


bool OpenPickPeakPreferDlg(TreeNode& trSettings, bool& bBaselineChanged)
{
	GETN_FIRST_SUBNODES_AS_TABS(trSettings);
	PickPeakPreferDlg dlg(trSettings);
	if( IDOK == dlg.DoModalEx() )
	{
		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		if ( !dlg.NeedApply() )
			return false;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

		Tree trTmpBaseline;
		trTmpBaseline.Replace(trSettings.baseline);

		trSettings = dlg.GetSettings();
		bBaselineChanged = _check_if_baseline_setting_changed(trTmpBaseline, trSettings.baseline);

		return true;
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////// class PickPeakPreferDlg /////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MIN_TAB_WIDTH		450
#define MIN_TAB_HEIGHT		300

#define STR_PICK_PEAK_PREFER_DLG		"Quick Peaks Preferences"
#define STR_PICK_PEAK_PREFER_DLG_L		_L("Quick Peaks Preferences")

class PickPeakPreferDlg : public DynaDlg
{
public:
	PickPeakPreferDlg(TreeNode& trSettings) : DynaDlg(IDD_PICK_PEAK_PREFERENCE, trSettings, "ODlg8")
	{
		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		m_trOriginal = trSettings;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	}

	int		DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = DynaDlg::DoModal(hWndParent);
		return nRet;
	}
	
	TreeNode GetSettings()
	{
		return GetTree();
	}

	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	BOOL	NeedApply()
	{
		return m_bNeedApply;
	}
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

protected:

EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_USER_MSG(WM_USER_DYNACTRL_EXPAND_COLLAPSE, OnAfterExpandCollapse)
	ON_GETNDLG_MSGS(IDC_PICK_PEAK_DYNA)
	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	
EVENTS_END

	BOOL OnInitDialog()
	{
		DynaDlg::OnInitDialog();
		InitDynaControl(IDC_PICK_PEAK_DYNA);
	
		InitTabControl();
		UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true);

		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		m_btnApply = GetItem(IDC_APPLY);
		m_btnOK = GetItem(IDOK);
		m_btnApply.Enable = FALSE;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

		Text = STR_PICK_PEAK_PREFER_DLG_L;
		return false;
	}
	
	BOOL OnDestroy()
	{
		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		m_bNeedApply = m_btnApply.Enable;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		return DynaDlg::OnDestroy();
	}

	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		resizeDlgToFit(cx, cy);
		return TRUE;
	}

	virtual string GetDlgTitle()
	{
		return STR_PICK_PEAK_PREFER_DLG;
	}

	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	BOOL	OnApply(Control ctrl)
	{
		m_btnApply.Enable = FALSE;

		string	strMainObj;
		m_trOriginal.GetAttribute(STR_MAINOBJ_NAME_ATTRIB, strMainObj);

		PickPeakTool itool;
		itool.Init(strMainObj);
		TreeNode&		tr = GetTree();
		return itool.ApplySettingsEx(tr, _check_if_baseline_setting_changed(m_trOriginal.baseline, tr.baseline));
	}
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	
private:
	//virtual
	void  resizeDlgToFit(int cx = 0, int cy = 0)
	{
		SIZE	szDynaCtrl;
		TREE_CTRL_VAR.GetOptimalSize(szDynaCtrl);
	
		RECT rrTab, rrDyna, rrBottomBtn;
		rrDyna.right = szDynaCtrl.cx;
		rrDyna.bottom = szDynaCtrl.cy;
		DYNA_TAB_CNTRL.AdjustRect(TRUE, &rrDyna);
	
		SIZE	szTab;
		szTab.cx = max(RECT_WIDTH(rrDyna), MIN_TAB_WIDTH);
		szTab.cy = max(RECT_HEIGHT(rrDyna), MIN_TAB_HEIGHT);
	
		int nGap = GetControlGap();
	
		rrTab.left = rrTab.top = nGap;
		rrTab.right = rrTab.left + szTab.cx;
		rrTab.bottom = rrTab.top + szTab.cy;
		MoveControl(DYNA_TAB_CNTRL, rrTab);
	
		rrDyna = rrTab;
		DYNA_TAB_CNTRL.AdjustRect(FALSE, &rrDyna);
		MoveControl(TREE_CTRL_VAR, rrDyna);
	
		RECT rrCancle;
		Control ctrlCancle;
		GetControlClientRect(IDCANCEL, rrCancle, &ctrlCancle);
	
		int nBtnWidth = RECT_WIDTH(rrCancle);
		int nBtnHeight = RECT_HEIGHT(rrCancle);
	
		rrBottomBtn.right = rrTab.right;
		rrBottomBtn.left = rrBottomBtn.right - nBtnWidth;
		rrBottomBtn.top = rrTab.bottom + nGap;
		rrBottomBtn.bottom = rrBottomBtn.top + nBtnHeight;
		MoveControl(ctrlCancle, rrBottomBtn);
		
		rrBottomBtn.right = rrBottomBtn.left - nGap;
		rrBottomBtn.left = rrBottomBtn.right - nBtnWidth;
		MoveControl(m_btnOK, rrBottomBtn);

		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		rrBottomBtn.right = rrBottomBtn.left - nGap;
		rrBottomBtn.left = rrBottomBtn.right - nBtnWidth;
		MoveControl(m_btnApply, rrBottomBtn);
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	
		// resize dlg
		int nClientWidth = szTab.cx + 2 * nGap;
		int nClientHeight = szTab.cy + nBtnHeight + 3 * nGap;
	
		RECT rrClient;
		GetClientRect(&rrClient);
		rrClient.right = rrClient.left + nClientWidth;
		rrClient.bottom = rrClient.top + nClientHeight;
		ClientToScreen(&rrClient);
	
		RECT rtDlg;
		GetWindowRect(&rtDlg);
		rtDlg.right = rrClient.right;
		rtDlg.bottom = rrClient.bottom;
		MoveWindow(&rtDlg, true);
	
		InvalidateRect(GetSafeHwnd(), NULL, TRUE);
	}

	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	virtual void AfterUpdateDynaControl(DWORD dwEventType)
	{
		if ( GETNEVENT_ON_GUI_CHANGED & dwEventType )
		{
			m_btnApply.Enable = TRUE;
		}
		DynaDlg::AfterUpdateDynaControl(dwEventType);
	}
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

private:
	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	Button		m_btnApply;
	Button		m_btnOK;

	Tree		m_trOriginal;
	BOOL		m_bNeedApply;
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////// class PickPeakTool //////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////

///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
#define		SideMarkers(_vv, _vBaseMarkers, _bRight) \
			_vv = _vBaseMarkers; \
			vector<int>		_vnIndices; \
			_vnIndices.Data(!_bRight, _vv.GetSize(), 2); \
			_vnIndices.SetSize(_vnIndices.GetSize() - 1); \
			_vv.RemoveAt(_vnIndices);
			
struct FINDPEAKMOREINFO
{
	void	Append(FINDPEAKMOREINFO& stMoreInfo)
	{
		vnPeakIndices.Append(stMoreInfo.vnPeakIndices);
		vxBaseMarkers.Append(stMoreInfo.vxBaseMarkers);
		vyBaseMarkers.Append(stMoreInfo.vyBaseMarkers);
		vArea.Append(stMoreInfo.vArea);
		vFWHM.Append(stMoreInfo.vFWHM);
		/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH, folger's mistake, he said
		vnBaseMarkerIndices.Append(stMoreInfo.vnBaseMarkerIndices);
		vCentroid.Append(stMoreInfo.vCentroid);
		vxLeft.Append(stMoreInfo.vxLeft);
		vxRight.Append(stMoreInfo.vxRight);
		/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		vyBaseLine.Append(stMoreInfo.vyBaseLine);
		/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
	}
	
	/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
	void	LeftMakerIndices(vector<int>& vv)
	{
		SideMarkers(vv, vnBaseMarkerIndices, FALSE);
	}
	void	RightMakerIndices(vector<int>& vv)
	{
		SideMarkers(vv, vnBaseMarkerIndices, TRUE);
	}
	/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
	
	void	LeftMakerIndices(vector& vv)
	{
		SideMarkers(vv, vnBaseMarkerIndices, FALSE);
	}
	
	void	RightMakerIndices(vector& vv)
	{
		SideMarkers(vv, vnBaseMarkerIndices, TRUE);
	}

	void	LeftMarkersX(vector& vv)
	{
		SideMarkers(vv, vxBaseMarkers, FALSE);
	}

	void	LeftMarkersY(vector& vv)
	{
		SideMarkers(vv, vyBaseMarkers, FALSE);
	}

	void	RightMarkersX(vector& vv)
	{
		SideMarkers(vv, vxBaseMarkers, TRUE);
	}

	void	RightMarkersY(vector& vv)
	{
		SideMarkers(vv, vyBaseMarkers, TRUE);
	}

	vector<int>		vnPeakIndices;
	vector<int>		vnBaseMarkerIndices;
	vector			vxBaseMarkers;
	vector			vyBaseMarkers;

	///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	vector			vArea;
	vector			vFWHM;
	vector			vCentroid;
	vector			vxLeft;
	vector			vxRight;
	///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
	vector			vyBaseLine; // only baseline value at vnPeakIndices
	/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
};
///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

#define	TOOLNAME				_L("Quick Peaks Gadget")
#define	TOOL_PREFERENCES_TITLE	_L("Quick Peaks")

static	int*	_get_xf_treenode_evt_handle_state()
{
	static int nUpdated = 0;
	return &nUpdated;
}

enum
{
	//PICK_PEAK_CMD_OUTPUT_BASELINE_DATA			= GOT_CMD_CUSTOM,
	PICK_PEAK_CMD_SUBTRACT_BASELINE					= GOT_CMD_CUSTOM,
	///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
	GOT_PEAKS_FUNCTION_BEGIN						= GOT_CMD_CUSTOM | 0x0800,
	GOT_PEAKS_FUNCTION_END							= GOT_CMD_CUSTOM | 0x08FF, //allow 255 functions at most, and I think it's enough
	///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
};

enum {
	PICK_PEAK_TOOL_OBJ_FIRST = GOT_OBJ_TOTAL,
	PICK_PEAK_TOOL_OBJ_BASELINE,
	///------ Folger 12/07/2010 ORG-1652-S1 SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES
	PICK_PEAK_TOOL_OBJ_BASEMAKER,
	///------ End SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES
};

///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
#define	STR_PICK_PEAK_OBJ_STORAGE			"PickPeak"
///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

///------ Folger 12/03/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
enum
{
	PICKPEAKSTATES_APPLYSETTINGS		= 0x00000001,
};

static	DWORD		g_dwStates = 0;
class PickPeakUpdateEventHelper
{
public:
	PickPeakUpdateEventHelper()
	{
	}
	~PickPeakUpdateEventHelper()
	{
	}

	DWORD		IsDuringApplySettings()
	{
		return O_QUERY_BOOL(g_dwStates, PICKPEAKSTATES_APPLYSETTINGS);
	}
	void		SetDuringApplySettings(BOOL bOn)
	{
		O_SET_BIT(g_dwStates, PICKPEAKSTATES_APPLYSETTINGS, bOn);
	}

private:
};
///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

#define STR_DATASETOBJ_PICK_PEAK			"PickPeakResult"
///------ Folger 12/09/2010 ORG-1652-S1 SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES
#define STR_BASE_MARKER_CURVE				"BaseMakers"
///------ End SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES

class PickPeakTool : public GraphObjCurveTool
{
public:
	PickPeakTool(LPCSTR lpcszMainObjName = NULL) : GraphObjCurveTool(lpcszMainObjName)
	{
		m_vnObjIDs.Add(PICK_PEAK_TOOL_OBJ_BASELINE);
		m_vsObjNames.Add("BaselineCurve");
		///------ Folger 12/07/2010 ORG-1652-S1 SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES
		///Sophy 3/2/2011 basemarker NOT use hard-coded name any longer
		//m_vnObjIDs.Add(PICK_PEAK_TOOL_OBJ_BASEMAKER);
		//m_vsObjNames.Add(STR_BASE_MARKER_CURVE);
		///------ basemarker NOT use hard-coded name any longer
		///------ End SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES

		GraphLayer gl = Project.ActiveLayer();
		if( gl )
		{
			GraphPage gp = gl.GetPage();
			m_strPreviewDataWksName = "Tmp" + gp.GetName() + gl.GetIndex();
		}
		else
		{
			m_strPreviewDataWksName = "TmpPPrev"
		}
		
		m_strPreviewDataWksLongName = "Quick Peaks Data";
	}
	
	bool ApplySettings(TreeNode& trGUI = NULL)
	{
		///------ Folger 12/03/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		PickPeakUpdateEventHelper		clHelper;
		clHelper.SetDuringApplySettings(TRUE);
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		if( trGUI )
			///------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
			//SetGUITree(trGUI);
			///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
			//SetGUITreeUpdateLastUsed(trGUI);
			SetGUITree(trGUI, true);
			///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
			///------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME

		UpdateROIGUI();
		/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		//updatePeakLabels(m_wks, true);
		/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		
		///------ Folger 12/03/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		//return TRUE;
		clHelper.SetDuringApplySettings(FALSE);
		return OnMove();
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	}

	///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	BOOL	ApplySettingsEx(TreeNode& trGUI, BOOL bBaselineChanged)
	{
		if( bBaselineChanged )
		{
			bool	bSubtracted = false;
			foreach(DataPlot dp in m_gl.DataPlots)				// clear subtract baseline status
				_peak_gadget_baseline_subtracted_status(dp, bSubtracted, false);
		}
		return ApplySettings(trGUI);
	}
	///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE

	///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
	/// virtual
	void	ApplyAfterEdit(TreeNode& trGUI)
	{
		Tree	trGUIOld;
		GetGUITree(trGUIOld);
		SET_MODIFIED_OUTSIDE(trGUI, false);	///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE

		ApplySettingsEx(trGUI, _check_if_baseline_setting_changed(trGUI.baseline, trGUIOld.baseline));
	}

	virtual	double	GetVersion()
	{
		return 8.103;
	}
	///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

protected:

	/// Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	//virtual 
	BOOL	OnBeforePlotChanged()
	{
		if ( m_gl )
			RemovePreviewPeakLabels();
		return TRUE;
	}
	/// end FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	


	#define			PICK_PEAKS_PREVIEW_PEAK_X				0
	#define			PICK_PEAKS_PREVIEW_PEAK_Y				1
	#define			PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_X	2
	#define			PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_Y	3
	#define			PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_X	4
	#define			PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_Y	5

	///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
	BOOL	OnNoDataSelected()
	{
		DataPlot dp;
		if ( GetSelectedPlot(dp) )
		{
			vector vHeight;
			FINDPEAKMOREINFO stMoreInfo; //empty information
			checkUpdatePeakLabels(dp, true, &stMoreInfo, true, vHeight);
			RemoveAreas();
		}
		return TRUE;
	}
	///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
	
	//virtual 
	BOOL OnMove()
	{
		///------ Folger 12/03/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		PickPeakUpdateEventHelper		clHelper;
		if ( clHelper.IsDuringApplySettings() )
			return FALSE;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		
		if(!OnPreMove()) return false;

		if(!GetData())
		{
			ConnectToTempPreviewDataAndGraph();
			if( m_wks )
				m_wks.SetSize(0, -1);
			if( m_gl )
			{
				GraphPage gp = m_gl.GetPage();
				gp.Refresh();
			}
			if( m_goBaseline ) 
			{
				m_goBaseline.Show(false);
			}

			///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#ifndef	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
			return true; // no data, nothing to do, not an error
#else
			return OnNoDataSelected();
#endif	//__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
			///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
		}

		///------ Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL
		//UpdateTopLabel("No Message", true);
		///------ End SHOW_PEAK_NUM_ON_ROI_LABEL		

		if( CheckPreviewDataWks() > 0 )
		{
			m_wks.SetSize(-1, 6);
			m_wks.Columns(PICK_PEAKS_PREVIEW_PEAK_Y).SetComments(_L("Peak for Preview"));
			m_wks.Columns(PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_Y).SetComments(_L("Left Base Markers"));
			m_wks.Columns(PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_Y).SetComments(_L("Right Base Markers"));
		}

		vector vxPeaks, vyPeaks;
		///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		//if( findAllPlotsPeaks(vxPeaks, vyPeaks) )
		FINDPEAKMOREINFO	stMoreInfo;
		if( findAllPlotsPeaks(vxPeaks, vyPeaks, false, false, &stMoreInfo) )
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		{
			Dataset dsX(m_wks, PICK_PEAKS_PREVIEW_PEAK_X);
			dsX = vxPeaks;

			Dataset dsY(m_wks, PICK_PEAKS_PREVIEW_PEAK_Y);
			dsY = vyPeaks;

			Dataset dsLeftBaseMarkersX(m_wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_X);
			stMoreInfo.LeftMarkersX(dsLeftBaseMarkersX);

			Dataset dsLeftBaseMarkersY(m_wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_Y);
			stMoreInfo.LeftMarkersY(dsLeftBaseMarkersY);
			
			Dataset dsRightBaseMarkersX(m_wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_X);
			stMoreInfo.RightMarkersX(dsRightBaseMarkersX);
			
			Dataset dsRightBaseMarkersY(m_wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_Y);
			stMoreInfo.RightMarkersY(dsRightBaseMarkersY);
		}
		
		///------ Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL
		int		nNumPeaks = vxPeaks.GetSize();
		if ( IsShowPeakNum() )
		{
			string	strMessage;
			strMessage.Format(_L("%d peak(s) found"), nNumPeaks);
			UpdateTopLabel(strMessage, TRUE);
		}
		else
		{
			UpdateTopLabel("", FALSE);
		}
		///------ End SHOW_PEAK_NUM_ON_ROI_LABEL

		updateBaselinePrev();
		/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		//updatePeakLabels(m_wks, true);
		/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

		///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		//if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_ON_MOVE_EVENT) )		expand to full range should also update the gui
		//{
			//Tree trGUI;
			//if( GetGUITree(trGUI) )
			//{
				//Tree tr;
				//tr = m_go.GetFormat(FPB_DATA, FOB_SPECIAL, true, true);
				//
				//vector vx;
				//vx = tr.Root.Data.X.dVals;
				//if( vx.GetSize() > 2 )
				//{
					//trGUI.roi.XScale.leftx.strVal = get_value_by_format(m_dp, vx[0]);
					//trGUI.roi.XScale.rightx.strVal = get_value_by_format(m_dp, vx[1]);
					//SetGUITree(trGUI);
				//}
				//else
				//{
					//ASSERT(false);
				//}
			//}
		//}
		//Sophy, centralize the code above in base class!!!
		///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		return GraphObjCurveTool::OnMove();
	}

	///-----Kit 02/21/2011 ORG-2229-P2 BRING_ALL_RELATE_OBJS_TO_FRONT_WHEN_CLICK_TRIANGLE_BTN
	// virtual
	bool	OnSelect()
	{
		GraphObjCurveTool::OnSelect();

		if( !IsShowIntegArea() )
			return false;

		Tree trIntegAreaGrObj;
		if( !( m_go.GetBinaryStorage(STR_PICK_PEAK_OBJ_STORAGE, trIntegAreaGrObj) 
			&& trIntegAreaGrObj.Areas.IsValid() ) )
		{
			ASSERT(false);
			return false;
		}
		
		vector<string> vsNames;
		vsNames = trIntegAreaGrObj.Areas.strVals;
		for( int ii = 0; ii < vsNames.GetSize(); ++ii )
		{
			GraphObject go = m_gl.GraphObjects(vsNames[ii]);
			if( !go.IsValid() )
			{
				ASSERT(false);
				continue;
			}
			
			go.MoveObject(MO_TOP);
		}
		
		
		return true;
	}
	///-----End BRING_ALL_RELATE_OBJS_TO_FRONT_WHEN_CLICK_TRIANGLE_BTN

	//virtual
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	//bool 	DoOutput(bool bUpdateLastOutput)
	bool 	DoOutput(bool bUpdateLastOutput, bool bMarkerOnly = false)
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	{
		vector vx, vy;
		if(!getDataRange(vx, vy))
			return false;

		//if( bUpdateLastOutput )			// update peaks points and baseline
		//{
		//	OutputBaselineData();
		//}
		/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
		//OutputPeaksValues(bUpdateLastOutput);
		OutputPeaksValues(bUpdateLastOutput, bMarkerOnly);
		/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS

		return true;
	}

	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	bool	OutputPeaksValues(bool bReplace, bool bMarkerOnly = false)
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	{
		/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
		//if( !findAllPlotsPeaks(NULL, NULL, true, bReplace) )
		if( !findAllPlotsPeaks(NULL, NULL, true, bReplace, NULL, bMarkerOnly) )
		/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
			return false;

		return true;
	}

	/*
	bool	OutputBaselineData()
	{
		Worksheet wksReport;
		if( !PrepareReportWks(wksReport) )
		{
			error_report("Invalid Report Worksheet!");
			return false;
		}
		GetData();
		vector vxb, vyb;
		bool bBaselineShared;
		CreateBaseline(vxb, vyb, bBaselineShared, m_dp);

		Dataset dsX(wksReport, PICK_PEAK_REPORT_COL_BASELINE_X);
		dsX = vxb;

		Dataset dsY(wksReport, PICK_PEAK_REPORT_COL_BASELINE_Y);
		dsY = vyb;

		return true;
	}
	*/

	bool	CreateBaseline(vector& vxb, vector& vyb, bool& bGlobalGL, const DataPlot& dpSrc, BaselineInfo* pBLInfo)
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return FALSE;
		GetData();
		
		double dROIFrom, dROITo;
		if( !GetMainObjectXPosition(dROIFrom, dROITo) )
			return false;

		if( !_create_baseline(trGUI.baseline, vxb, vyb, bGlobalGL, dROIFrom, dROITo, m_gl.X.From, m_gl.X.To, GetMultiPlotsState(), dpSrc, pBLInfo
			///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
			, IsLocalBaseline()
			///------ End CREATE_BASELINE_USING_WHOLE_CURVE
			) )
		{
			vxb.SetSize(0);
			vyb.SetSize(0);
			return false;
		}
		
		return true;
	}

	bool	SubtractBaseline()
	{
		bool	bSubtracted = false;
		if( GetMultiPlotsState() )
		{
			m_bGlobalBL = false;
			int nSubtractCount = 0;
			foreach(DataPlot dp in m_gl.DataPlots)
			{
				if( isPlotfiltered(dp) )
					continue;

				_peak_gadget_baseline_subtracted_status(dp, bSubtracted);
				if( bSubtracted )
					continue;

				if( !m_bGlobalBL )
					prepareBaseline(dp, NULL);

				if( SubtrctBaseline(dp, m_vxBaseline, m_vyBaseline) )
				{
					nSubtractCount++;
					bSubtracted = true;
					_peak_gadget_baseline_subtracted_status(dp, bSubtracted, false);
				}
			}

			if( nSubtractCount < 1 )
				return false;
		}
		else
		{
			if(!GetData())
			{
				error_report("GetData() form Grobj error!");
				return false;
			}
			ASSERT(m_dp);

			_peak_gadget_baseline_subtracted_status(m_dp, bSubtracted);
			if( bSubtracted )
				return false;

			prepareBaseline(m_dp, NULL);
			if( SubtrctBaseline(m_dp, m_vxBaseline, m_vyBaseline) )
			{
				bSubtracted = true;
				_peak_gadget_baseline_subtracted_status(m_dp, bSubtracted, false);
			}
		}
		return true;
	}

	bool	SubtrctBaseline(DataPlot& dp, const vector& vxb, const vector& vyb)
	{
		ASSERT( dp );

		XYRange dr;
		if( !dp.GetDataRange(dr) || !dr )
			return false;

		vector vx, vy;
		if( !dr.GetData(vy, vx) )
			return false;
		subtract_baseline(vx, vy, vxb, vyb);

		return dr.SetData(&vy, NULL);
	}
	
	//virtual
	bool	IsPlotForROI(const DataPlot& dp)
	{
		return is_plot_for_ROI(dp, m_go, STR_DATASETOBJ_PICK_PEAK);
	}

	//virtual
	int CreateAttachments()
	{
		int nRet = GraphObjCurveTool::CreateAttachments();
		if ( 0 != nRet )
			return nRet;

		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);
		GraphObject go;
		if ( 0 > CreateAttachment(go, PICK_PEAK_TOOL_OBJ_BASELINE, CTP_FREE_1, GROBJ_TN_POLYLINE) )
			return -1;
		set_go_selectable(go, false); //forbit moving polyline object.
		set_go_color(go, SYSCOLOR_RED);

		return 0;
	}

	//virtual
	int	GetAttachments()
	{
		int nRet = GraphObjCurveTool::GetAttachments();
		if ( 0 != nRet )
			return nRet;
		
		return GetAttachment(m_goBaseline, PICK_PEAK_TOOL_OBJ_BASELINE);
	}
	
	//virtual
	bool	SetMultiPlotsState(bool bOn = true)
	{
		if( !IsSupportMultiPlots() )
			return false;

		if( bOn != GetMultiPlotsState() )
		{
			// dirty code, show/hide refer data
			Tree	trGUI;
			GetGUITree(trGUI);
			baseline_creation_multi_sel_attrib_access(trGUI.baseline, false, bOn);
			SetGUITree(trGUI);

			GraphObjCurveTool::SetMultiPlotsState(bOn);
		}
		return true;
	}

	//virtual
	void	UpdateGUIOnThemeChange(TreeNode& trGUI)
	{
		baseline_creation_multi_sel_attrib_access(trGUI.baseline, false, GetMultiPlotsState());

		///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		//check_update_roi_x_position(trGUI.roi.XScale);
		check_update_roi_x_position(trGUI.roi.XScale, GetXFName());
		///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

		GraphObjCurveTool::UpdateGUIOnThemeChange(trGUI);
	}

	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL centralize to base class
	//virtual
	//BOOL	IsExpandable()
	//{
		//Tree	trGUI;
		//GetGUITree(trGUI);
		//TreeNode	trFixed = trGUI.roi.XScale.fixscale;
		//return !(trFixed && trFixed.nVal);
	//}
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

	//virtual
	bool CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth, double& y0, double& y1)
	{
		TreeNode trXScale = trGUI.roi.XScale;
		bFixWidth = trXScale && trXScale.fixscale && trXScale.fixscale.nVal;

		TreeNode trXFrom = trXScale.leftx;
		TreeNode trXTo = trXScale.rightx;

		if( !trXFrom || !trXTo )
		{
			ASSERT(false);
			return false;
		}
		///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		//x0 = get_value_by_format(m_dp, trXFrom.strVal);
		//x1 = get_value_by_format(m_dp, trXTo.strVal);
		///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		//double dOffsetX = m_gl.X.From;
		//x0 = get_value_by_format(m_dp, trXFrom.strVal, true, &dOffsetX);
		//x1 = get_value_by_format(m_dp, trXTo.strVal, true, &dOffsetX);
		x0 = trXFrom.dVal;
		x1 = trXTo.dVal;
		///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL

		return true;
	}

	//virtual
	TreeNode	GetFillColorNode(const TreeNode& trGUI)
	{
		TreeNode trRectColor;
		if( trGUI.roi )
			trRectColor = trGUI.roi.rectcolor;
		return trRectColor;
	}

	//virtual
	TreeNode	GetToolNameNode(const TreeNode& trGUI)
	{
		TreeNode trToolName;
		if( trGUI.roi )
			trToolName = trGUI.roi.toolname;
		return trToolName;
	}

	//virtual
	int	GetPointsLimit(){ return 3; }
	
	//virtual
	//bool	IsSupportMultiPlots() { return true; }

	//virtual
	bool	DoEdit(HWND hWndParent = NULL)
	{
		Tree trGUI;
		if(!GetGUITree(trGUI))
			return false;

		// for safe, may come from newer build
		if( !IsSupportMultiPlots() )
			baseline_creation_multi_sel_attrib_access(trGUI.baseline, false, false);

		///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		SetGUITree(trGUI);
		///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

		bool bBaselineChanged = false;
		///------ Folger 12/02/2010 ORG-1511-S7 ADD_APPLY_TO_PICK_PEAK_PREFERENCE
		/*
		if( OpenPickPeakPreferDlg(trGUI, bBaselineChanged) )
		{
			
			if( bBaselineChanged )
			{
				bool	bSubtracted = false;
				foreach(DataPlot dp in m_gl.DataPlots)				// clear subtract baseline status
					_peak_gadget_baseline_subtracted_status(dp, bSubtracted, false);
			}
			return ApplySettings(trGUI);
		}
		return false;
		*/
		///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA
		DataRange	dr;
		if ( GetData() )
		{
			m_dp.GetDataRange(dr);
			tag_columns_in_data_range(dr, STR_DATASETOBJ_SOURCE_CURVE);
		}
		///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA
		///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		//bool	bReturn = OpenPickPeakPreferDlg(trGUI, bBaselineChanged);
		bool	bReturn = GraphObjCurveTool::DoEdit(hWndParent);
		///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA
		if ( dr )
		{
			tag_columns_in_data_range(dr, "");
		}
		///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA		
		///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		//if ( bReturn )
			//bReturn = ApplySettingsEx(trGUI, bBaselineChanged);
		///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		return bReturn;
		///------ End ADD_APPLY_TO_PICK_PEAK_PREFERENCE
	}
	
	virtual	bool	UpdateROIGUI()
	{
		bool bXPosChanged = true;
		Tree trGUI;
		if( GetGUITree(trGUI) )
		{
			TreeNode trXScale = trGUI.roi.XScale;

			double x0 = get_value_by_format(m_dp, trXScale.leftx.strVal);
			double x1 = get_value_by_format(m_dp, trXScale.rightx.strVal);
			CheckSetMainObjectXPosition(x0, x1);

			bool bDisable = trXScale.fixscale.nVal;
			disable_go_move(m_go, true, true, false, !bDisable);
		}

		return GraphObjCurveTool::UpdateROIGUI();
	}

	//virtual
	BOOL OnDestroy()
	{
		///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
		RemoveAreas();
		///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
		ConnectToTempPreviewDataAndGraph();
		if( m_gl )
		{
			/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
			/*
			if( m_wks )
			{
				XYRange dr;
				dr.Add(m_wks, 0, "X");
				dr.Add(m_wks, 1, "Y");

				XYRange		xyLeftBaseMarkers;
				XYRange		xyRightBaseMarkers;
				xyLeftBaseMarkers.Add(m_wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_X, "X");
				xyLeftBaseMarkers.Add(m_wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_Y, "Y");
				
				xyRightBaseMarkers.Add(m_wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_X, "X");
				xyRightBaseMarkers.Add(m_wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_Y, "Y");
	
				_update_peaks_labels(m_gl, dr, false, false, LABEL_Y_VAL_GUI, false, -1, xyLeftBaseMarkers, xyRightBaseMarkers);
			}
			m_gl.LT_execute("legend -s");
			*/
			RemovePreviewPeakLabels();
			/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

			bool	bSubtracted = false;
			foreach(DataPlot dp in m_gl.DataPlots)				// clear subtract baseline status
				_peak_gadget_baseline_subtracted_status(dp, bSubtracted, false);
		}

		// the base class may leave the wks if there is a tool on another layer
		if( m_wks )
			m_wks.Destroy();

		return GraphObjCurveTool::OnDestroy();
	}

	///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
	//virtual	
	bool DoFit()
	{ 
		UndoBlock	ub;
		
		string	strLayer;
		m_gl.GetRangeString(strLayer);
		QuickFitROIObjsCleanupHelper	clHelper(strLayer, m_go.GetName());
		
		string strRange = getPlotRangeString();
		
		Tree trGUI;
		GetGUITree(trGUI);
		
		string strTheme = "QuickPeaks";// (System)";	///Jasmine 05/30/2012 ORG-1352-S1 CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
		if( !strRange.IsEmpty() && convert_pickpeak_settings_to_pa_theme(trGUI, strTheme) )
		{
			string strLT; 
			strLT.Format("pa iy:=%s theme:=\"%s\" smode:=0", strRange, strTheme);
			LT_execute(strLT);
		}		
		else
			error_report("Fail to switch to Peak Analyzer!");
		
		return true;
	}
	///End QUICK_PEAKS_SWICTH_TO_PA
	
	///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
	bool MakePeaksFunctionMenu(Menu& pm)
	{
		vector<string>	vsFiles;
		string	strCategory = STR_CATEGORY_TYPE_PEAK_FUNCTIONS;
		if ( !nslf_get_func_list(m_vsFunctions, vsFiles, strCategory) )
			return false;
		///Sophy 3/2/2011 ORG-2351-S1 VERSION_CHECKING_ON_QUICK_PEAKS_FLYOUT_MENU_FOR_PEAK_FITTING
		DWORD dwFlag = MF_STRING;
		///Sophy 1/5/2012 ORG-4782-S1 CHANGE_MIXED_PRO_OPTIONS_TO_PURE_REGULAR_TOOLS
		//if ( !is_pro_version() )
			//dwFlag |= MF_GRAYED;
		///end CHANGE_MIXED_PRO_OPTIONS_TO_PURE_REGULAR_TOOLS
		///end VERSION_CHECKING_ON_QUICK_PEAKS_FLYOUT_MENU_FOR_PEAK_FITTING
		int nSize = m_vsFunctions.GetSize();
		ASSERT(nSize < GOT_PEAKS_FUNCTION_END - GOT_PEAKS_FUNCTION_BEGIN);
		for ( int iItem = 0; iItem < nSize; iItem++ )
		{
			pm.Add(m_vsFunctions[iItem], GOT_PEAKS_FUNCTION_BEGIN + iItem, dwFlag);
		}
		return true;
	}
	///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
	//virtual
	bool AddUpdateLastOutputSubmenu(Menu& pm, uint& nPosition)
	{
		DWORD dwFlags = MF_STRING;
		DataPlot dpSource;
		Worksheet wksReport;
		if( !GetSelectedPlot(dpSource) || !GetReportWorksheet(wksReport) )
		{
			dwFlags |= MF_GRAYED;
		}
		///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
		pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING

		/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
		pm.Add(_L("Tag Peaks"), GOT_BTN_OUTPUT_MARKER_ONLY, MF_STRING | (dpSource ? 0: MF_GRAYED));
		nPosition++;
		/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
		///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
		Menu peaks;
		if ( MakePeaksFunctionMenu(peaks) )
		{
			///Sophy 3/2/2011 ORG-2351-S1 VERSION_CHECKING_ON_QUICK_PEAKS_FLYOUT_MENU_FOR_PEAK_FITTING
			//pm.AddPopup(_L("Fit Peaks"), peaks); nPosition++
			///Sophy 1/5/2012 ORG-4782-S1 CHANGE_MIXED_PRO_OPTIONS_TO_PURE_REGULAR_TOOLS
			//pm.AddPopup(_L("Fit Peaks") + " " + STR_PRO_POSTFIX, peaks); nPosition++
			pm.AddPopup(_L("Fit Peaks"), peaks); nPosition++
			///end CHANGE_MIXED_PRO_OPTIONS_TO_PURE_REGULAR_TOOLS
			///end VERSION_CHECKING_ON_QUICK_PEAKS_FLYOUT_MENU_FOR_PEAK_FITTING
		}
		pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
		
		///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
		pm.Add(_L("Switch to Peak Analyzer") + STR_THREE_DOTS, GOT_BTN_FIT, MF_STRING);
		pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		///End QUICK_PEAKS_SWICTH_TO_PA
		
		pm.Add(_L("Update Output"), GOT_BTN_UPDATE_LAST_OUTPUT, dwFlags);
		nPosition++;
		return true;
	}

	//virtual
	bool	UpdateContextMenu(Menu& pm, uint& nPosition)
	{
		for(int nPos = 0; nPos < nPosition; nPos++)
		{
			if( GOT_BTN_OUTPUT == pm.GetMenuItemID(nPos) )
				break;
			nPos++;
		}
		if( nPos >= nPosition )
			return false;
		nPos++;				// insert after

		///Sophy 1/24/2011 ORG-2099-S1 QUICK_PEAKS_GADGET_OUTPUT_REPORT_USE_GENERAL_LABEL
		//pm.ModifyMenu(GOT_BTN_OUTPUT, MF_STRING, GOT_BTN_OUTPUT, _L("Output Peak Values"));
		///end QUICK_PEAKS_GADGET_OUTPUT_REPORT_USE_GENERAL_LABEL

		bool bHasBaseline = hasBaseline();
		int nFlags = MF_STRING | MF_BYPOSITION;
		///Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
		//if( !bHasBaseline )
		if( !bHasBaseline || isPlotsSubtracted() )
		///end QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
			nFlags |= MF_GRAYED;
		pm.InsertMenu(nPos, nFlags, PICK_PEAK_CMD_SUBTRACT_BASELINE, _L("Subtract Baseline"));		nPosition++;
		//pm.InsertMenu(nPos, nFlags, PICK_PEAK_CMD_OUTPUT_BASELINE_DATA, _L("Output Baseline Data"));			nPosition++;

		return true;
	}

	//virtual
	bool OnCmdCustom(int nCmdID)
	{
		///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
		if ( nCmdID >= GOT_PEAKS_FUNCTION_BEGIN && nCmdID < GOT_PEAKS_FUNCTION_END )
		{
			if ( !GetData() ) //attach to plot.
				return false;
			string strFunctionName = m_vsFunctions[nCmdID - GOT_PEAKS_FUNCTION_BEGIN];
			string strInputRange;
			///Sophy 1/27/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING_NEED_RANGE_SUPPORT
			//m_dp.GetRangeString(strInputRange);
			///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
			//BOOL bWholePlotRange = FALSE;
			//if ( m_i2 == m_vY.GetSize() - 1 )
				//bWholePlotRange = TRUE;
			//if ( bWholePlotRange )
				//strInputRange.Format("[%s]%d!%d", m_gp.GetName(), m_gl.GetIndex() + 1, m_dp.GetIndex() + 1);
			//else
				//strInputRange.Format("[%s]%d!%d[%d:%d]", m_gp.GetName(), m_gl.GetIndex() + 1, m_dp.GetIndex() + 1, m_i1 + 1, m_i2 + 1);
			strInputRange = getPlotRangeString();
			if( strInputRange.IsEmpty() )
				return error_report("Fail to fit peak!");
			///End QUICK_PEAKS_SWICTH_TO_PA
			///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING_NEED_RANGE_SUPPORT
			int nUseQP = 2;
			string strLTCmd;
			strLTCmd.Format("nlfitpeaks iy:=%s func:=%s useqp:=%d", strInputRange, strFunctionName, nUseQP);
			BOOL bRet = LT_execute(strLTCmd);
			return bRet;
		}
		///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
		switch(nCmdID)
		{
		//case PICK_PEAK_CMD_OUTPUT_BASELINE_DATA:
		//	return OutputBaselineData();
		//	break;

		case PICK_PEAK_CMD_SUBTRACT_BASELINE:
			///Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
			int nRet = warning_msg_box(_L("Source Data will be subtracted without undo. Do you want to proceed?"),
										true, 'W', MB_OKCANCEL);
			if(IDOK != nRet)
				return false;
			///end QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
			return SubtractBaseline();
			break;
			
		default:
			return false;
		}
		
		return true;
	}

	//virtual
	BOOL	GetReportWorksheet(Worksheet& wksReport)
	{
		string strReportSheet = GetReportSheet();
		if( strReportSheet.IsEmpty() )
			return false;
		wksReport.Attach(strReportSheet);

		return wksReport.IsValid();
	}

	#define		GET_REPORT_SHEET(_Node) \
				Tree tr; \
				GetGUITree(tr); \
				string	strSheet = tr.outputsettings._Node.strVal; \
				okutil_arg_copy(&strSheet); \
				return strSheet
	
	string	GetReportSheet()
	{
		GET_REPORT_SHEET(output);
	}

	string	GetBaselineReportSheet()
	{
		GET_REPORT_SHEET(BaselineWorksheetName);
	}

protected:

	///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual
	BOOL	IsAllowLockedROI() { return TRUE; }
	//virtual
	TreeNode	GetGUILockNode(TreeNode& trGUI)
	{
		TreeNode trFixScale = trGUI.roi.XScale.fixscale;
		return trFixScale;
	}
	
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	BOOL	InvalidateResults()
	{
		return OnMove();
	}
	
	//virtaul
	string GetSignature()
	{
		return "xf_" XFNAME;
	}

	//virtual
	string	GetXFName(){ return XFNAME; }
	
	//virtual
	int*	GetXFEventHandlersState() { return _get_xf_treenode_evt_handle_state(); }

	//virtual
	string	GetToolName(){ return TOOLNAME; }

	//virtual
	string	GetPreferenceTitle(){ return TOOL_PREFERENCES_TITLE; }

private:
	///Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
	bool isPlotsSubtracted()
	{
		if(GetMultiPlotsState())
		{
			foreach(DataPlot dp in m_gl.DataPlots)
			{
				bool bCurrPlotSubed;
				_peak_gadget_baseline_subtracted_status(dp, bCurrPlotSubed);
				if(!bCurrPlotSubed)
					return false;
			}
			return true;
		}
		bool bSubtracted;
		if(!GetData())
			return false;
		ASSERT(m_dp);
		_peak_gadget_baseline_subtracted_status(m_dp, bSubtracted);
		return bSubtracted;
	}
	///end QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
	///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
	string 	getPlotRangeString()
	{
		if( !GetData() )
			return "";
		
		string strInputRange;
		
		BOOL bWholePlotRange = FALSE;
		if ( m_i2 == m_vY.GetSize() - 1 )
			bWholePlotRange = TRUE;
		if ( bWholePlotRange )
			strInputRange.Format("[%s]%d!%d", m_gp.GetName(), m_gl.GetIndex() + 1, m_dp.GetIndex() + 1);
		else
			strInputRange.Format("[%s]%d!%d[%d:%d]", m_gp.GetName(), m_gl.GetIndex() + 1, m_dp.GetIndex() + 1, m_i1 + 1, m_i2 + 1);
		
		return strInputRange;
	}
	///End QUICK_PEAKS_SWICTH_TO_PA

	bool getDataRange(vector& vx = NULL, vector &vy = NULL)
	{
		if(!GetData())
		{
			error_report("GetData() form Grobj error!");
			return false;
		}

		if(!m_dp.GetDataRange(m_dr, m_i1, m_i2))
		{
			error_report("GetDataRange from dataplot error!");
			return false;
		}

		if(vx != NULL && vy != NULL)
		{
			if ( m_dp.GetDataPoints(m_i1, m_i2, vx, vy) <= 0 )
			{
				error_report("GetDataPoints from DataPlot Error!");
				return false;
			}
		}

		return true;
	}
	
	#define		STR_PEAK_X					_L("Peak X")
	#define		STR_PEAK_Y					_L("Peak Y")
	#define		STR_LEFT_BASE_MARKERS_X		_L("Left Base Marker X")
	#define		STR_LEFT_BASE_MARKERS_Y		_L("Left Base Marker Y")
	#define		STR_RIGHT_BASE_MARKERS_X		_L("Right Base Marker X")
	#define		STR_RIGHT_BASE_MARKERS_Y		_L("Right Base Marker Y")

	void	CreatePlotRange(XYRange& xy, Worksheet& wks, LPCSTR lpcszX, LPCSTR lpcszY)
	{
		Column	colX = wks.FindCol(lpcszX);
		Column	colY = wks.FindCol(lpcszY);
		if ( colX )
			xy.Add(wks, colX.GetIndex(), "X");
		if ( colY )
			xy.Add(wks, colY.GetIndex(), "Y");
	}

	/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
	GraphObject getMarkerObject(DataPlot& dp, bool bPreview, LPCSTR lpcszObjKey, bool bCreate = false)
	{
		ASSERT( dp );
		GraphLayer		gl;
		dp.GetParent(gl);

		string			strObjName = nlf_get_qpmkr_object_name(lpcszObjKey, bPreview);

		Collection<GraphObject>		collMarker;
		gl.GetSpecialGraphicObjectsCollection(collMarker, strObjName);
		bool			bAlreadyExist = false;
		vector<string>	vsNames(collMarker.Count());
		int				nIndex = 0;
		foreach ( GraphObject go in collMarker )
		{
			if ( is_obj_connected_to(go, dp) )
			{
				strObjName = go.GetName();
				bAlreadyExist = true;
				break;
			}
			vsNames[nIndex++] = go.GetName();
		}
		if ( !bAlreadyExist )
		{
			int				nEnumNum = get_list_enum_number(vsNames, strObjName);
			if ( nEnumNum > 0 )
				strObjName += nEnumNum;
		}
		GraphObject		goMkr = gl.GraphObjects(strObjName);
		if ( !goMkr && bCreate )
		{
			goMkr = gl.CreateGraphObject(GROBJ_TN_MARKER, strObjName);
			///------ Folger 04/26/2011 ORG-2647-P1 QUICK_PEAKS_OUTPUT_CURVE_SHOULD_BE_DELETED_AFTER_PARENT_PLOT_IS_REMOVED
			goMkr.SetSelfDeleteIfNotConnected(TRUE);
			///------ End QUICK_PEAKS_OUTPUT_CURVE_SHOULD_BE_DELETED_AFTER_PARENT_PLOT_IS_REMOVED
			goMkr.ConnectTo(dp, -1, -1, FALSE);
			/// Hong 01/21/11 ORG-2067-P2 MARKER_OBJ_DEFAULT_SHOULD_DISABLE_MOVE
			update_go_states(goMkr, GOC_NO_EDIT);
			/// end MARKER_OBJ_DEFAULT_SHOULD_DISABLE_MOVE
		}
		
		return goMkr;
	}
	
	bool	getLabelsShownOption(bool& bShowPeak, bool& bShowLBaseMkr, bool& bShowRBaseMkr)
	{
		Tree trGUI;
		if( !GetGUITree(trGUI) )
			return false;

		TreeNode 	trDisplay = tree_get_node_by_tagname(trGUI, "Display", true);
		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//TreeNode	trPeakColor = trDisplay.PeakMarkerColor;
		//TreeNode	trBaseMarkerColor = trDisplay.BaseMarkerColor;
		//bShowPeak = !is_optional_by_dyna_use_checkbox(trPeakColor);
		//bShowLBaseMkr = bShowRBaseMkr = !is_optional_by_dyna_use_checkbox(trBaseMarkerColor);
		TreeNode	trPeakMarker = trDisplay.PeakMarker;
		TreeNode	trBaseMarker = trDisplay.BaseMarker;
		bShowPeak = trPeakMarker.Use;
		bShowLBaseMkr = bShowRBaseMkr = trBaseMarker.Use;
		/// end NEW_PEAK_DISPLAY_GUI
		return true;
	}

	/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
	//bool	checkUpdatePeakLabels(DataPlot& dp, bool bPreview, FINDPEAKMOREINFO* pstMoreInfo)
	/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
	//bool	checkUpdatePeakLabels(DataPlot& dp, bool bPreview, FINDPEAKMOREINFO* pstMoreInfo, bool bReplace = false)
	bool	checkUpdatePeakLabels(DataPlot& dp, bool bPreview, FINDPEAKMOREINFO* pstMoreInfo, bool bReplace = false, vector& vPeakHeight = NULL)
	/// end PEAK_MARKER_BE_POSITION_SENSITIVE
	/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
	{
		if ( !dp && pstMoreInfo )
			return false;
		
		bool			bShowPeak = true, bShowLBaseMkr = false, bShowRBaseMkr = false;
		if ( !getLabelsShownOption(bShowPeak, bShowLBaseMkr, bShowRBaseMkr) )
			return false;
		bool		bShowLabel, bRotateLabel;
		int			nLabelXYType, nLabelColor;
		if ( !getLabelsOption(bShowLabel, nLabelXYType, nLabelColor, bRotateLabel) )
			return false;

		GraphObject		goPeak, goLBaseMkr, goRBaseMkr;
		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//if ( (goPeak = getMarkerObject(dp, bPreview, STR_QPMKR_KEY_PEAK, bShowPeak)) )
		//{
		//	goPeak.Show(bShowPeak);
		if ( (goPeak = getMarkerObject(dp, bPreview, STR_QPMKR_KEY_PEAK, bShowPeak || bShowLabel)) )
		{
			goPeak.Show(bShowPeak || bShowLabel);
		/// end NEW_PEAK_DISPLAY_GUI
			if ( !bPreview )
				nlf_qpmkr_set_baseline_info(goPeak, pstMoreInfo->vyBaseLine, pstMoreInfo->vnPeakIndices, true);
			/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
			//_updateMarkerValues(goPeak, pstMoreInfo->vnPeakIndices, !bPreview);
			/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
			//_updateMarkerValues(goPeak, pstMoreInfo->vnPeakIndices, !bPreview && !bReplace);
			_updateMarkerValues(goPeak, pstMoreInfo->vnPeakIndices, !bPreview && !bReplace, vPeakHeight, bRotateLabel);
			/// end PEAK_MARKER_BE_POSITION_SENSITIVE
			/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
			/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
			//_updateMakerProperty(goPeak, PeakMarkerColor(), bShowLabel, nLabelXYType, bRotateLabel, nLabelColor);
			_updateMakerProperty(goPeak, PeakMarkerColor(), PeakMarkerSize(), bShowLabel, nLabelXYType, bRotateLabel, nLabelColor, !bShowPeak);
			/// end NEW_PEAK_DISPLAY_GUI
		}
		vector<int>			vnIndices;
		if ( (goLBaseMkr = getMarkerObject(dp, bPreview, STR_QPMKR_KEY_LBASEMKR, bShowLBaseMkr)) )
		{
			goLBaseMkr.Show(bShowLBaseMkr);
			pstMoreInfo->LeftMakerIndices(vnIndices);
			_updateMarkerValues(goLBaseMkr, vnIndices, false);
			/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
			//_updateMakerProperty(goLBaseMkr, BaseMarkerColor(), FALSE);
			_updateMakerProperty(goLBaseMkr, BaseMarkerColor(), BaseMarkerSize(), FALSE);
			/// end NEW_PEAK_DISPLAY_GUI
		}
		if ( (goRBaseMkr = getMarkerObject(dp, bPreview, STR_QPMKR_KEY_RBASEMKR, bShowRBaseMkr)) )
		{
			goRBaseMkr.Show(bShowRBaseMkr);
			pstMoreInfo->RightMakerIndices(vnIndices);
			_updateMarkerValues(goRBaseMkr, vnIndices, false);
			/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
			//_updateMakerProperty(goRBaseMkr, BaseMarkerColor(), FALSE);
			_updateMakerProperty(goRBaseMkr, BaseMarkerColor(), BaseMarkerSize(), FALSE);
			/// end NEW_PEAK_DISPLAY_GUI
		}

		return true;
	}

#define			REMOVE_PREVIEW_MARKER_OBJECT(_dp, _key)	\
	if ( (go = getMarkerObject(_dp, true, _key)) )		\
			go.Destroy();

	void	RemovePreviewPeakLabels()
	{
		ASSERT( m_gl );
		GraphObject		go;
		foreach ( DataPlot dp in m_gl.DataPlots)
		{
			REMOVE_PREVIEW_MARKER_OBJECT(dp, STR_QPMKR_KEY_PEAK);
			REMOVE_PREVIEW_MARKER_OBJECT(dp, STR_QPMKR_KEY_LBASEMKR);
			REMOVE_PREVIEW_MARKER_OBJECT(dp, STR_QPMKR_KEY_RBASEMKR);
		}
	}
	/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

	bool	updatePeakLabels(Worksheet& wks, bool bPreview)
	{
		if( !wks )
			return false;
		XYRange		dr;
		XYRange		xyLeftBaseMarkers;
		XYRange		xyRightBaseMarkers;
		if( bPreview )
		{
			dr.Add(wks, PICK_PEAKS_PREVIEW_PEAK_X, "X");
			dr.Add(wks, PICK_PEAKS_PREVIEW_PEAK_Y, "Y");

			xyLeftBaseMarkers.Add(wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_X, "X");
			xyLeftBaseMarkers.Add(wks, PICK_PEAKS_PREVIEW_LEFT_BASE_MARKERS_Y, "Y");

			xyRightBaseMarkers.Add(wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_X, "X");
			xyRightBaseMarkers.Add(wks, PICK_PEAKS_PREVIEW_RIGHT_BASE_MARKERS_Y, "Y");
		}
		else
		{
			CreatePlotRange(dr, wks, STR_PEAK_X, STR_PEAK_Y);
			CreatePlotRange(xyLeftBaseMarkers, wks, STR_LEFT_BASE_MARKERS_X, STR_LEFT_BASE_MARKERS_Y);
			CreatePlotRange(xyRightBaseMarkers, wks, STR_RIGHT_BASE_MARKERS_X, STR_RIGHT_BASE_MARKERS_Y);
		}
		
		tag_columns_in_data_range(dr, STR_DATASETOBJ_PICK_PEAK);
		tag_columns_in_data_range(xyLeftBaseMarkers, STR_DATASETOBJ_PICK_PEAK);
		tag_columns_in_data_range(xyRightBaseMarkers, STR_DATASETOBJ_PICK_PEAK);
		
		bool bShowLabel, bRotateLabel;
		int nLabelXYType, nLabelColor;
		getLabelsOption(bShowLabel, nLabelXYType, nLabelColor, bRotateLabel);

		_update_peaks_labels(m_gl, dr, true, bShowLabel, nLabelXYType, bRotateLabel, nLabelColor, xyLeftBaseMarkers, xyRightBaseMarkers, BaseMarkerColor(), PeakMarkerColor());
		return true;
	}

	bool	getLabelsOption(bool& bShowLabel, int& nLabelXYType, int& nLabelColor, bool& bRotateLabel)
	{
		Tree trGUI;
		if( !GetGUITree(trGUI) )
			return false;

		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//TreeNode trDisplay = tree_get_node_by_tagname(trGUI, "Display", true);
		//switch(trDisplay.lc.nVal)
		TreeNode 		trBranch = tree_get_node_by_tagname(trGUI, "PeakLabel", true);
		bShowLabel = trBranch.Use;
		switch ( trBranch.Label.nVal )
		/// end NEW_PEAK_DISPLAY_GUI
		{
		case PEAK_CENTER_LABEL_X:
			nLabelXYType = LABEL_X_VAL_GUI;
			break;

		case PEAK_CENTER_LABEL_Y:
			nLabelXYType = LABEL_Y_VAL_GUI;
			break;

		//case PEAK_CENTER_LABEL_INDICES:
		//	nLabelXYType = LABEL_ROW_NUM_GUI;
		//	break;

		case PEAK_CENTER_LABEL_XY:
			nLabelXYType = LABEL_XY_VAL_GUI;
			break;

		default:
			nLabelXYType = LABEL_X_VAL_GUI;
		}

		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//nLabelColor = trDisplay.labelcolor.nVal;
		//bRotateLabel = trDisplay.lr.nVal;
		nLabelColor = trBranch.Color.nVal;
		bRotateLabel = trBranch.Horizontal.nVal ? false : true;
		/// end NEW_PEAK_DISPLAY_GUI

		return true;
	}

	bool	getPeakFilterOption(int& nFilter, double& dValue, const TreeNode& trFilter, const vector& vxSrc, const vector& vySrc)
	{
		nFilter = trFilter.method.nVal;
		dValue = NANUM;

		switch(nFilter)
		{
		case PEAK_FILTER_HEIGHT:
			{
				TreeNode trValue = trFilter.val_height;
				if( 1 == octree_get_auto_support(&trValue) )
					dValue = 20;
				else
					dValue = trValue.dVal;

				dValue *= getTotalHeight(vySrc) / 100;
			}
			break;
		
		case PEAK_FILTER_NUM:
			{
				TreeNode trValue = trFilter.val_num;
				if( 1 == octree_get_auto_support(&trValue) )
				{
					double dAutoHeightThres;
					double dDefaultHeightPer = 0.20;	
					dAutoHeightThres = getTotalHeight(vySrc) * dDefaultHeightPer;

					int iPeakNum = 1;
					compute_peaks_number_by_filter_height(vxSrc, vySrc, dAutoHeightThres, iPeakNum);
					dValue = iPeakNum;
				}
				else
				{
					dValue = trValue.dVal;
				}
			}
			break;
			
		default:
			return true;
		}

		return true;
	}
	
	bool	getWinSearchHeightWidth(double& dHeight, double& dWidth, int nOption, TreeNode& trHeight, TreeNode& trWidth, const vector& vxSrc, const vector& vySrc)
	{
		if( 1 == octree_get_auto_support(&trHeight) )
		{
			dHeight = 20;
			if ( SIZE_OPTION_RAW_SIZE == nOption ) //raw size
			{
				dHeight *= getTotalHeight(vySrc) / 100;
			}
		}
		else
		{
			dHeight = trHeight.dVal;
		}

		if( 1 == octree_get_auto_support(&trWidth) )
		{
			dWidth = 50;
			if ( SIZE_OPTION_RAW_SIZE == nOption ) //raw size
			{
				///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
				/*
				double dMin, dMax, dTotalWidth;
				vxSrc.GetMinMax(dMin, dMax);
				dTotalWidth = abs(dMax - dMin);
				*/
				double dTotalWidth = _get_total_width(vxSrc);
				///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

				dWidth *= dTotalWidth/100;
			}
		}
		else
		{
			dWidth = trWidth.dVal;
		}
		return true;
	}
	
	bool	hasBaseline()
	{
		Tree trGUI;
		if( !GetGUITree(trGUI) )
			return false;
		return PEAK_BASELINE_MODE_USE_MINMAX != trGUI.baseline.mode.nVal;
	}

	bool	prepareBaseline(const DataPlot& dpSrc, BaselineInfo* pBLInfo)
	{
		CreateBaseline(m_vxBaseline, m_vyBaseline, m_bGlobalBL, dpSrc, pBLInfo);
		return true;
	}

	bool	updateBaselinePrev()
	{
		bool bMultiBaseline = GetMultiPlotsState() && !m_bGlobalBL;

		vector vx, vy;
		if( !bMultiBaseline && intersectBaseline(vx, vy) )
		{
			m_goBaseline.Show(true);
			m_goBaseline.SetPoints(vx, vy);
		}
		else
			m_goBaseline.Show(false);

		m_gp.Refresh();

		return true;
	}

	bool intersectBaseline(vector& vx, vector& vy)
	{
		///------ Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
		if ( PEAK_BASELINE_MODE_NONE == BaselineMode() )
			return false;
		///------ End ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
		
		if( m_vxBaseline.GetSize() < 1 || m_vxBaseline.GetSize() != m_vyBaseline.GetSize() )
			return false;

		///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
		if ( !IsLocalBaseline() )
		{
			vx = m_vxBaseline;
			vy = m_vyBaseline;
			return true;
		}
		///------ End CREATE_BASELINE_USING_WHOLE_CURVE

		double x0, x1;
		if( !GetMainObjectXPosition(x0, x1) )
			return false;

		double dMin, dMax;
		if( !findDataMinMax(dMin, dMax, true) )
			return false;

		if( dMin < x0 )
			dMin = x0;
		if( dMax > x1 )
			dMax = x1;
		if( dMax < dMin )
			return false;

		vx = m_vxBaseline;
		vx.Replace(dMin, dMin, MATREPL_TEST_LESSTHAN);
		vx.Replace(dMax, dMax, MATREPL_TEST_GREATER);
		vx.Sort();
		for(int ii = vx.GetSize()-1; ii > 0; ii--)
		{
			if( vx[ii] == vx[ii-1] )
				vx.RemoveAt(ii);
		}
		if( vx.GetSize() < 2 )
			return false;

		vy.SetSize(vx.GetSize());
		return OE_NOERROR == ocmath_interpolate(vx, vy, vx.GetSize(), m_vxBaseline, m_vyBaseline, m_vxBaseline.GetSize());
	}
	
	bool findDataMinMax(double& dMin, double& dMax, bool bXData = true)
	{
		dMin = dMax = NANUM;
		if( GetMultiPlotsState() )
		{
			if( !m_gl )
				return false;

			double dDataMin, dDataMax;
			foreach(DataPlot dp in m_gl.DataPlots)
			{
				if ( isPlotfiltered(dp) )
					continue;

				if( findPlotMinMax(dp, dDataMin, dDataMax, bXData) )
				{
					if( dMin == NANUM || dMin > dDataMin )
						dMin = dDataMin;
					if( dMax == NANUM || dMax < dDataMax )
						dMax = dDataMax;
				}
			}
		}
		else
			return m_dp.IsValid() && findPlotMinMax(m_dp, dMin, dMax, bXData);

		return true;
	}
	
	bool findPlotMinMax(const DataPlot& dp, double& dMin, double& dMax, bool bXData = true)
	{
		ASSERT( dp );

		XYRange xy;
		if( !dp.GetDataRange(xy) )
			return false;

		///Kyle 01/14/2011 ORG-2031-P1 HANDLE_INPUT_EVEN_SAMPLING
//		Column col;
//		if( bXData )
//			xy.GetXColumn(col);
//		else
//			xy.GetYColumn(col);
//		if( !col )
//			return false;
//
//		Dataset ds(col);
//		return ds.IsValid() && ds.GetMinMax(dMin, dMax) > 0;			// not all missing values
		vector vy, vx;
		if( !xy.GetData(vy, vx) || vx.GetSize() <= 0 || vy.GetSize() <= 0 )
			return false;

		return bXData ? (vx.GetMinMax(dMin, dMax) > 0) : (vy.GetMinMax(dMin, dMax) > 0);
		///End HANDLE_INPUT_EVEN_SAMPLING
	}
	
	bool isPlotfiltered(const DataPlot& dp)
	{
		ASSERT(dp.IsValid());

		XYRange xy;
		Column colY;

		return !dp.GetDataRange(xy) || !xy.GetYColumn(colY) || is_dataobj_tagged(colY, STR_DATASETOBJ_PICK_PEAK);
	}

	#define		GENERATE_RESULT_NODE(_NODE, _V, _DESIG) \
				if ( trQuantities._NODE.nVal ) \
				{ \
					trResults._NODE.dVals = _V; \
					trResults._NODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, _DESIG); \
					tree_node_copy_attribute(trQuantities._NODE, trResults._NODE, STR_LABEL_ATTRIB); \
				}
	
	bool	outputPeaks(	const vector& vxPeaks, const vector& vyPeaks, const vector& vHeights, LPCSTR lpcszDataset,
							const BaselineInfo* pBLInfo, const vector& vxBaseline = NULL, const vector& vyBaseline = NULL
							, FINDPEAKMOREINFO*	lpstMoreInfo = NULL
							///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
							, DataPlot& dp = NULL
							///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
							)
	{

		Tree	trGUI;
		GetGUITree(trGUI);

		TreeNode	trQuantities = trGUI.quantities.OutputQuantities;

		m_trOutput.Reset();
		TreeNode	trResults = m_trOutput.AddNode("Results");
		
		int		nNumPeaks = vxPeaks.GetSize();
		if ( trQuantities.DatasetName.nVal )
		{
			vector<string>	vs(nNumPeaks);
			for ( int ii=0; ii<nNumPeaks; ++ii )
			{
				vs[ii] = lpcszDataset;
			}
			trResults.DatasetName.strVals = vs;
			tree_node_copy_attribute(trQuantities.DatasetName, trResults.DatasetName, STR_LABEL_ATTRIB);
		}
		if ( trQuantities.PeakID.nVal )
		{
			vector<string>	vs(nNumPeaks);
			for ( int ii=0; ii<nNumPeaks; ++ii )
			{
				vs[ii].Format("Peak %d", ii + 1);
			}
			trResults.PeakID.strVals = vs;
			tree_node_copy_attribute(trQuantities.PeakID, trResults.PeakID, STR_LABEL_ATTRIB);
		}

		vector		vTemp;

		vTemp = lpstMoreInfo->vnPeakIndices + 1;
		GENERATE_RESULT_NODE(PeakRow, vTemp, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(PeakX, vxPeaks, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(PeakY, vyPeaks, OKDATAOBJ_DESIGNATION_Y);
		GENERATE_RESULT_NODE(Height, vHeights, OKDATAOBJ_DESIGNATION_Y);
		trResults.Height.SetAttribute(STR_COL_COMMENTS_LABEL_ATTRIB, _L("Peak Height from Baseline"));

		GENERATE_RESULT_NODE(PeakArea, lpstMoreInfo->vArea, OKDATAOBJ_DESIGNATION_Y);

		GENERATE_RESULT_NODE(FWHM, lpstMoreInfo->vFWHM, OKDATAOBJ_DESIGNATION_Y);

		GENERATE_RESULT_NODE(Centroid, lpstMoreInfo->vCentroid, OKDATAOBJ_DESIGNATION_X);

		vector		vLeftBaseMarkersX, vLeftBaseMarkersY, vRightBaseMarkersX, vRightBaseMarkersY;
		lpstMoreInfo->LeftMarkersX(vLeftBaseMarkersX);
		lpstMoreInfo->LeftMarkersY(vLeftBaseMarkersY);
		lpstMoreInfo->RightMarkersX(vRightBaseMarkersX);
		lpstMoreInfo->RightMarkersY(vRightBaseMarkersY);

		vTemp = vxPeaks - lpstMoreInfo->vxLeft;
		GENERATE_RESULT_NODE(LeftHalfWidth, vTemp, OKDATAOBJ_DESIGNATION_Y);

		vTemp = lpstMoreInfo->vxRight - vxPeaks;
		GENERATE_RESULT_NODE(RightHalfWidth, vTemp, OKDATAOBJ_DESIGNATION_Y);

		lpstMoreInfo->LeftMakerIndices(vTemp);
		vTemp += 1;
		GENERATE_RESULT_NODE(LeftBaseMarkerIndex, vTemp, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(LeftBaseMarkerX, vLeftBaseMarkersX, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(LeftBaseMarkerY, vLeftBaseMarkersY, OKDATAOBJ_DESIGNATION_Y);

		lpstMoreInfo->RightMakerIndices(vTemp);
		vTemp += 1;
		GENERATE_RESULT_NODE(RightBaseMarkerIndex, vTemp, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(RightBaseMarkerX, vRightBaseMarkersX, OKDATAOBJ_DESIGNATION_X);
		GENERATE_RESULT_NODE(RightBaseMarkerY, vRightBaseMarkersY, OKDATAOBJ_DESIGNATION_Y);

		///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
		Column		colX, colY;
		if ( dp )
		{
			if ( GetColumns(colX, colY, dp) )
			{
				if ( colX )
				{
					copy_report_column_data_format(colX, trResults.PeakX);
				}
				if ( colY )
				{
					copy_report_column_data_format(colY, trResults.PeakY);
				}
			}
		}
		///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT

		if ( trQuantities.Info.nVal )
		{
			string	strBaseline;
			///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
			//_info_2_text(strBaseline, *pBLInfo, vxBaseline, vyBaseline, lpstMoreInfo);
			vector<string>		vsXBaseline, vsYBaseline;
			convert_double_vector_to_string_vector(vxBaseline, vsXBaseline, vxBaseline.GetSize(), NULL, colX);
			convert_double_vector_to_string_vector(vyBaseline, vsYBaseline, vyBaseline.GetSize(), NULL, colY);
			_info_2_text(strBaseline, *pBLInfo, vsXBaseline, vsYBaseline, lpstMoreInfo);
			///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
			trResults.Info.strVal = strBaseline;
			trResults.Info.TypeID = TNVAL_TYPE_CSTRING;
			trResults.Info.SetAttribute(STR_TR2WKS_CNTRLS_ATTRIB, TR2WKSCNTRLS_SET_STRING_AS_NOTE);
			///Sophy 1/25/2011 ORG-2099-S2 QUICKPEAKS_REPORT_MULTIPEAKS_INFO_WITH_MERGE_ROWS
			int nMergeRows = 1;
			if ( vyPeaks.GetSize() > nMergeRows )
				nMergeRows = vyPeaks.GetSize();
			trResults.Info.SetAttribute(STR_ROW_MERGE_SIZE, nMergeRows);
			///end QUICKPEAKS_REPORT_MULTIPEAKS_INFO_WITH_MERGE_ROWS
			tree_node_copy_attribute(trQuantities.Info, trResults.Info, STR_LABEL_ATTRIB);
		}

		TreeNode	trOutput = trGUI.outputsettings;
		OutputResultTree(trOutput.ScriptWindow.nVal, trOutput.ResultLog.nVal, trOutput.AppendtoWorksheet.nVal, GetReportSheet(), 0);

		if ( trOutput.OutputBaseline.nVal )
		{
			Tree	trBaseline;
			trBaseline.X.dVals = vxBaseline;
			trBaseline.Y.dVals = vyBaseline;
			trBaseline.X.SetAttribute(STR_LABEL_ATTRIB, _L("Baseline X"));
			trBaseline.Y.SetAttribute(STR_LABEL_ATTRIB, _L("Baseline Y"));
			trBaseline.SetAttribute(STR_TR2WKS_CNTRLS_ATTRIB, TR2WKSCNTRLS_VECTOR_ASSIGN_VALS_NOT_APPEND);

			out_tree_to_wks(trBaseline, GetBaselineReportSheet());
		}
		return true;
	}

	///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	//bool	findAllPlotsPeaks(vector& vxPeaks, vector& vyPeaks, bool bOutput = false, bool bReplace = false)
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	//bool	findAllPlotsPeaks(vector& vxPeaks, vector& vyPeaks, bool bOutput = false, bool bReplace = false, FINDPEAKMOREINFO* lpstMoreInfo = NULL)
	bool	findAllPlotsPeaks(vector& vxPeaks, vector& vyPeaks, bool bOutput = false, bool bReplace = false, FINDPEAKMOREINFO* lpstMoreInfo = NULL, bool bMarkerOnly = false)
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	{
		if( !(bOutput || (vxPeaks && vyPeaks)) )
		{
			ASSERT(0);
			return false;
		}

		if ( bReplace )
		{
			Worksheet	wks(GetReportSheet());
			wks.SetSize(-1, 0, WSS_CLEAR_DATA | WSS_CLEAR_EMBEDDING);
		}

		vector vxOneDataPeaks, vyOneDataPeaks;
		BaselineInfo blInfo, *pBLInfo = NULL;
		if( bOutput )
			pBLInfo = &blInfo;
		
		m_bHasNonMonoData = false;		///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA

		bool bRet = true;
		if( GetMultiPlotsState() )
		{
			m_bGlobalBL = false;			// reset this to update baseline

			int nPlots = m_gl.DataPlots.Count();
			for(int ii = 0; ii < nPlots; ii++)			// will add plots in the loop
			{
				DataPlot dp = m_gl.DataPlots(ii);
				ASSERT( dp.IsValid() );
				if ( isPlotfiltered(dp) )
					continue;

				if( !m_bGlobalBL )
					prepareBaseline(dp, pBLInfo);

				///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
				//findOnePlotPeaks(dp, vxPeaks, vyPeaks, pBLInfo, true);
				/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
				//findOnePlotPeaks(dp, vxPeaks, vyPeaks, pBLInfo, true, lpstMoreInfo);
				/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
				findOnePlotPeaks(dp, vxPeaks, vyPeaks, pBLInfo, bMarkerOnly, lpstMoreInfo, bReplace);
				/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
				/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
				///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
			}
		}
		else
		{
			m_bGlobalBL = true;

			if(!GetData())
				return error_report("GetData() form Grobj error!");
			ASSERT(m_dp);

			prepareBaseline(m_dp, pBLInfo);
			///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
			//return findOnePlotPeaks(m_dp, vxPeaks, vyPeaks, wksReport, pBLInfo, true);
			/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
			//return findOnePlotPeaks(m_dp, vxPeaks, vyPeaks, pBLInfo, true, lpstMoreInfo);
			/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
			//return findOnePlotPeaks(m_dp, vxPeaks, vyPeaks, pBLInfo, true, lpstMoreInfo, bReplace);
			bRet = findOnePlotPeaks(m_dp, vxPeaks, vyPeaks, pBLInfo, bMarkerOnly, lpstMoreInfo, bReplace);
			/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
			/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
			///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		}
		///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
		if( m_bHasNonMonoData )
			warning_msg_box(XFERR_NON_MONOTONIC_INPUT, NULL, false, 'W');
		///End PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
		
		return bRet;
	}

	///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	//bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, const BaselineInfo* pBLInfo, bool bUpdateCurve = false)
	/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
	//bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, const BaselineInfo* pBLInfo, bool bUpdateCurve = false, FINDPEAKMOREINFO* lpstMoreInfo = NULL)
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	//bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, const BaselineInfo* pBLInfo, bool bUpdateCurve = false, FINDPEAKMOREINFO* lpstMoreInfo = NULL, bool bReplace = false)
	bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, const BaselineInfo* pBLInfo, bool bMarkerOnly = false, FINDPEAKMOREINFO* lpstMoreInfo = NULL, bool bReplace = false)
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
	///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	{
		ASSERT(dp.IsValid());

		vector vxOneDataPeaks, vyOneDataPeaks, vOneDataHeights;
		///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		//if( !findOnePlotPeaks(dp, vxOneDataPeaks, vyOneDataPeaks, vOneDataHeights) )
		FINDPEAKMOREINFO	stMoreInfo;
		if( !findOnePlotPeaks(dp, vxOneDataPeaks, vyOneDataPeaks, vOneDataHeights, &stMoreInfo) )
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
			return false;

		ASSERT(vxOneDataPeaks.GetSize() == vyOneDataPeaks.GetSize());

		///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#ifndef	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
		if( vxOneDataPeaks.GetSize() < 1 )
			return true;
		///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#endif	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND

		if( vxPeaks && vyPeaks )
		{
			vxPeaks.Append(vxOneDataPeaks);
			vyPeaks.Append(vyOneDataPeaks);
		}
		///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		if ( lpstMoreInfo )
		{
			lpstMoreInfo->Append(stMoreInfo);
		}
		else
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		{
			string strDataset = getRangeString(dp);
			///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
			//outputPeaks(wksReport, vxOneDataPeaks, vyOneDataPeaks, vOneDataHeights, strDataset, pBLInfo, m_vxBaseline, m_vyBaseline);
			if ( !bMarkerOnly ) /// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
				outputPeaks(vxOneDataPeaks, vyOneDataPeaks, vOneDataHeights, strDataset, pBLInfo, m_vxBaseline, m_vyBaseline, &stMoreInfo
				///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
				, dp
				///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
				);
			///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

			/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
			//if( bUpdateCurve )
			//{
			//	Worksheet	wks(GetReportSheet());
			//	updatePeakLabels(wks, false);
			//}
			/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		}
		/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
		//if ( bUpdateCurve )
		/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
			/// Hong 01/20/11 ORG-1944-P5 UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
			//checkUpdatePeakLabels(dp, lpstMoreInfo ? true : false, &stMoreInfo);
			/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
			//checkUpdatePeakLabels(dp, lpstMoreInfo ? true : false, &stMoreInfo, bReplace);
			checkUpdatePeakLabels(dp, lpstMoreInfo ? true : false, &stMoreInfo, bReplace, vOneDataHeights);
			/// end PEAK_MARKER_BE_POSITION_SENSITIVE
			/// end UPDATE_OUTPUT_SHOULD_REMOVE_EXISTING_PEAKS_IN_MARER_OBJ
		/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

		return true;
	}
	
	///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	//bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, vector& vHeight)		// height from baseline
	bool	findOnePlotPeaks(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, vector& vHeight, FINDPEAKMOREINFO* lpstMoreInfo = NULL)		// height from baseline
	///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	{
		int i1, i2;
		if( !getData(dp, i1, i2) )
			return false;

		XYRange xySrc;
		if( !dp.GetDataRange(xySrc, i1, i2) )
			return false;

		vector vxSrc, vySrc;
		if ( dp.GetDataPoints(i1, i2, vxSrc, vySrc) <= 0 )
			return false;

		if( vxSrc.GetSize() < GetPointsLimit() )
			return false;

		bool bSubtracted;
		vector vxSrcTmp, vySrcTmp;
		_peak_gadget_baseline_subtracted_status(dp, bSubtracted);
		if( !bSubtracted && m_vxBaseline.GetSize() > 1 )
		{
			vxSrcTmp = vxSrc;
			vySrcTmp = vySrc;
			subtract_baseline(vxSrc, vySrc, m_vxBaseline, m_vyBaseline);
		}

		Tree trGUI;
		if( !GetGUITree(trGUI) )
			return false;

		TreeNode trFindPeak = trGUI.findpeak;
		int			nDirection = trFindPeak.dir.nVal + 1;			//

		TreeNode trSettings = trFindPeak.settings;
		int			nMethod = trSettings.method.nVal;
		int			nPts = trSettings.npts.nVal;
		int 		nOption = trSettings.option.nVal;
		//double 		dHeight = trSettings.height.dVal;
		//double 		dWidth = trSettings.width.dVal;
		double dHeight, dWidth;
		TreeNode trHeight = trSettings.height;
		TreeNode trWidth = trSettings.width;
		getWinSearchHeightWidth(dHeight, dWidth, nOption, trHeight, trWidth, vxSrc, vySrc);
		int nSmoothMethod;
		if( nMethod == PEAK_FINDING_METHOD_FIRST || nMethod == PEAK_FINDING_METHOD_RESIDUE)
			nSmoothMethod = trSettings.deriv_smooth.first.nVal;
		else if(nMethod == PEAK_FINDING_METHOD_SECOND)
			nSmoothMethod =  trSettings.deriv_smooth.second.nVal;
		
		int nPtsSmooth = 0;

		int 		nDerivPts = trSettings.deriv_smooth.deriv_npts.nVal;
		double 		dFFTCutOff = trSettings.deriv_smooth.fft_cutoff.dVal;
		double		dDerivPoly = trSettings.deriv_smooth.deriv_poly.nVal;

		int nFilter;
		double dValue;
		getPeakFilterOption(nFilter, dValue, trFindPeak.filter, vxSrc, vySrc);

		int nSize = vySrc.GetSize();
		vector<int> vPeaksInd(nSize);
		///------ Folger 12/03/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		int		nBaseMin = -1;
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

		///Kyle 06/14/2011 ORG-2507-P1 FIND_PEAKS_RETURN_ORDER_FOR_PEAK_INDICES
// 		///------ Folger 03/18/10 QA81-15209 IMPROVE_PA_FIND_PEAKS_FOR_NONE_BASELINE
// 		//int nRet = find_peaks(vxSrc, vySrc, vxPeaks, vyPeaks, vPeaksInd, nMethod, dWidth, dHeight, nPtsSmooth, nDirection, nPts, nOption, nFilter-1, &dValue,
// 						//nSmoothMethod, NULL, nDerivPts, dFFTCutOff, dDerivPoly);
// 		int		nRet = hasBaseline() ?
// 						find_peaks(vxSrc, vySrc, vxPeaks, vyPeaks, vPeaksInd, nMethod, dWidth, dHeight, nPtsSmooth, nDirection, nPts, nOption, nFilter-1, &dValue,
// 							nSmoothMethod, NULL, nDerivPts, dFFTCutOff, dDerivPoly)
// 						:
// 						find_peaks_without_baseline(vxSrc, vySrc, vxPeaks, vyPeaks, vPeaksInd, nMethod, dWidth, dHeight, nPtsSmooth, nDirection, nPts, nOption, nFilter-1, &dValue,
// 						nSmoothMethod, NULL, nDerivPts, dFFTCutOff, dDerivPoly
// 						///------ Folger 12/03/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
// 						, &nBaseMin);
// 						///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
// 		///------ End IMPROVE_PA_FIND_PEAKS_FOR_NONE_BASELINE
		FindPeaksParameter param;
		init_find_peaks_parameter(	param,
									nMethod,
									dWidth, dHeight,
									nPtsSmooth, nDirection, nPts, nOption, nFilter - 1, &dValue,
									nSmoothMethod, NULL, nDerivPts, dFFTCutOff, dDerivPoly);

		vector<uint> vnOrder;
		int nRet = hasBaseline() ?
						find_peaks(vxSrc, vySrc, vxPeaks, vyPeaks, vPeaksInd, param, vnOrder)
						:
						find_peaks_without_baseline(vxSrc, vySrc, vxPeaks, vyPeaks, vPeaksInd, param, &nBaseMin, vnOrder);
		///End FIND_PEAKS_RETURN_ORDER_FOR_PEAK_INDICES
		
		///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
		if( vnOrder.GetSize() > 0 )
			m_bHasNonMonoData = true;
		///End PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA

		if ( nRet != OE_NOERROR && nRet !=  OE_POINT_OUTSIDE_RECT )
		{
			vPeaksInd.SetSize(0);
			vxPeaks.SetSize(0);
			vyPeaks.SetSize(0);
		}
		vHeight = vyPeaks;		///Kyle 09/14/2010 ORG-998-S1 PICK_PEAKS_OUTPUT_PEAK_HEIGHT_FROM_BASELINE

		//match peaks' position to preview graph no matter subtracted or not
		if( vxSrcTmp.GetSize() > 0 )
		{
			///Kyle 06/14/2011 ORG-2507-P1 FIND_PEAKS_RETURN_ORDER_FOR_PEAK_INDICES
			if( vnOrder.GetSize() > 0 )
			{
				for(int ii = vPeaksInd.GetSize() - 1; ii >= 0; --ii)
					vPeaksInd[ii] = vnOrder[vPeaksInd[ii]];
			}
			///End FIND_PEAKS_RETURN_ORDER_FOR_PEAK_INDICES

			ASSERT(vxSrcTmp.GetSize() == vySrcTmp.GetSize());
			match_peaks_centers_by_index(vxSrcTmp, vySrcTmp, vxPeaks.GetSize(), vPeaksInd, vxPeaks, vyPeaks);
		}
		else
		{
			match_peaks_centers_by_index(vxSrc, vySrc, vxPeaks.GetSize(), vPeaksInd, vxPeaks, vyPeaks);
		}

		vector<uint> vn;
		if ( hasBaseline() )
		{
			vxPeaks.Sort(SORT_ASCENDING, true, vn);
			vyPeaks.Reorder(vn);
			vHeight.Reorder(vn);	///Kyle 09/14/2010 ORG-998-S1 PICK_PEAKS_OUTPUT_PEAK_HEIGHT_FROM_BASELINE
		}
		///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		if ( lpstMoreInfo )
		{
			///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#ifndef	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
			lpstMoreInfo->vnPeakIndices = vPeaksInd + i1;
#else	//__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
			if ( vPeaksInd.GetSize() > 0 )
				lpstMoreInfo->vnPeakIndices = vPeaksInd + i1;
#endif	//__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
			///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
			if ( hasBaseline() )
				lpstMoreInfo->vnPeakIndices.Reorder(vn);
			MakeBaseMarkers(dp, vxPeaks, vyPeaks, lpstMoreInfo, nBaseMin);
			/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
			lpstMoreInfo->vyBaseLine = vyPeaks - vHeight;
			/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		}
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

		return true;
	}
	
	string	getRangeString(const DataPlot& dp)
	{
		//string str;
		//dp.GetLegend(str);
		//return str;

		XYRange xy;
		if( dp.GetDataRange(xy) && xy.IsValid() )
			return xy.GetDescription(GETLC_NO_DESIGNATIONS | GETLC_NO_ROWS);
		return "";
	}
	
	bool getData(const DataPlot& dp, int& i1, int& i2)
	{
		vector<int> vI1, vI2;
		if( !is_plot_for_ROI(dp, m_go, STR_DATASETOBJ_PICK_PEAK, vI1, vI2) )
			return false;
		if( vI1.GetSize() < 1 || vI2.GetSize() < 1 )		// no data
			return false;

		double dMin, dMax;
		vI1.GetMinMax(dMin, dMax);		i1 = dMin;
		vI2.GetMinMax(dMin, dMax);		i2 = dMax;

		return true;
	}

	double		getTotalHeight(const vector& vy)
	{
		///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
		/*
		double dMin, dMax, dTotalHeight;
		vy.GetMinMax(dMin, dMax);
		return hasBaseline() ? max(abs(dMax), abs(dMin)) : dMax - dMin;
		*/
		return _get_total_height(vy, hasBaseline());
		///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK
	}

	///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
	///------ Folger 12/17/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
	#define		__BASE_MARKERS_ALGORITHM_AS_PA__
	#ifndef		__BASE_MARKERS_ALGORITHM_AS_PA__
	///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
	#define		MAKE_BASE_MARKERS(_BMIndices, _BMX, _BMY, _nBMSize, _PeakIndices, _nPeakSize, _vbx, _vby) \
				ocmath_interpolate(vx, vbyInterp, vx.GetSize(), _vbx, _vby, _vbx.GetSize()); \
				if ( OE_NOERROR != ocmath_make_base_markers(_BMIndices, _BMX, _BMY, _nBMSize \
														, _PeakIndices, _nPeakSize \
														, vx, vy, vx, vbyInterp, vx.GetSize()) ) \
					;
	///------ Folger 12/17/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
	#else		/// __BASE_MARKERS_ALGORITHM_AS_PA__
	void MakeBaseMarkers(vector<int>& vnMarkerIndices, const vector& vx, const vector& vy, const vector& vbx, const vector& vby, const vector& vxPeaks,
	                     bool bSubtracted = false) ///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
	{
		vector		vxx, vyy;
		vxx = vx, vyy = vy;
		if(!bSubtracted) ///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			subtract_baseline(vxx, vyy, vbx, vby);
		find_markers_of_peak_centers(vxx, vyy, vxPeaks, vnMarkerIndices);
	}
	#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
	///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA

	/// see Curve::FindPeaksFromBaseline in c\modll\LABCURVE\CURVE.cpp
	BOOL	MakeBaseMarkers(const DataPlot& dp, vector& vxPeaks, vector& vyPeaks, FINDPEAKMOREINFO* lpstMoreInfo, int nBaseMin)
	{
		if ( NULL == lpstMoreInfo )
			return FALSE;
		
		int i1, i2;
		if( !getData(dp, i1, i2) )
			return FALSE;

		///------ Folger 12/08/2010 ORG-1675-S8 BASE_MARKER_FOLLOW_BASELINE_RANGE
		BOOL	bLocalBaseline = IsLocalBaseline();
		if ( !bLocalBaseline )
		{
			i1 = 0;
			i2 = -1;
		}
		///------ End BASE_MARKER_FOLLOW_BASELINE_RANGE

		vector		vx, vy;
		if ( !dp.GetDataPoints(i1, i2, vx, vy) )
			return FALSE;

		vector<int>		vnPeakIndices;
		vnPeakIndices = lpstMoreInfo->vnPeakIndices;
		///------ Folger 12/08/2010 ORG-1675-S8 BASE_MARKER_FOLLOW_BASELINE_RANGE
		///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#ifndef	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		if ( bLocalBaseline )
#else	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		if ( bLocalBaseline && vnPeakIndices.GetSize() > 0 )
#endif	//__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		///end PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
			vnPeakIndices -= i1;
		///------ End BASE_MARKER_FOLLOW_BASELINE_RANGE

		int			nSize = vxPeaks.GetSize();
		int			nBMSize = nSize * 2;
		lpstMoreInfo->vnBaseMarkerIndices.SetSize(nBMSize);
		lpstMoreInfo->vxBaseMarkers.SetSize(nBMSize);
		lpstMoreInfo->vyBaseMarkers.SetSize(nBMSize);

		///------ Folger 12/17/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
		#ifdef		__BASE_MARKERS_ALGORITHM_AS_PA__
		vector		vbyInterp(vx.GetSize());
		#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
		///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
		if ( hasBaseline() )
		{
			///------ Folger 12/17/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
			#ifndef		__BASE_MARKERS_ALGORITHM_AS_PA__
			///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
			MAKE_BASE_MARKERS(lpstMoreInfo->vnBaseMarkerIndices, lpstMoreInfo->vxBaseMarkers, lpstMoreInfo->vyBaseMarkers, nBMSize, vnPeakIndices, nSize, m_vxBaseline, m_vyBaseline)
			#else		/// __BASE_MARKERS_ALGORITHM_AS_PA__
			///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			bool bSubtracted;
			_peak_gadget_baseline_subtracted_status(dp, bSubtracted);
			///end QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			MakeBaseMarkers(lpstMoreInfo->vnBaseMarkerIndices, vx, vy, m_vxBaseline, m_vyBaseline, vxPeaks,
			                bSubtracted); ///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
			///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
		}
		else
		{
			vector vbx(2), vby(2);
			double dxmin, dxmax;
			vx.GetMinMax(dxmin, dxmax);
			vbx[0] = dxmin;
			vbx[1] = dxmax;

			double dymin, dymax;
			vy.GetMinMax(dymin, dymax);
			if ( nBaseMin < 0 )
			{
				vby = dymin;
				///------ Folger 12/17/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
				#ifndef		__BASE_MARKERS_ALGORITHM_AS_PA__
				MAKE_BASE_MARKERS(lpstMoreInfo->vnBaseMarkerIndices, lpstMoreInfo->vxBaseMarkers, lpstMoreInfo->vyBaseMarkers, nBMSize, vnPeakIndices, nSize, vbx, vby)
				#else		/// __BASE_MARKERS_ALGORITHM_AS_PA__
				MakeBaseMarkers(lpstMoreInfo->vnBaseMarkerIndices, vx, vy, vbx, vby, vxPeaks);
				#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
				///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
			}
			else
			{
				int*		pBMIndices = lpstMoreInfo->vnBaseMarkerIndices;
				double*		pBMX = lpstMoreInfo->vxBaseMarkers;
				double*		pBMY = lpstMoreInfo->vyBaseMarkers;
				int*		pPeakIndices = vnPeakIndices;

				if ( nBaseMin > 0 )
				{
					vby = dymin;
					///------ Folger 12/16/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
					#ifndef		__BASE_MARKERS_ALGORITHM_AS_PA__
					MAKE_BASE_MARKERS(pBMIndices, pBMX, pBMY, nBMSize, pPeakIndices, nSize, vbx, vby)
					#else		/// __BASE_MARKERS_ALGORITHM_AS_PA__
					vector			vPeaksX;
					vxPeaks.GetSubVector(vPeaksX, 0, nBaseMin - 1);
					MakeBaseMarkers(lpstMoreInfo->vnBaseMarkerIndices, vx, vy, vbx, vby, vPeaksX);
					#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
					///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
				}

				///------ Folger 12/16/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
				#ifndef		__BASE_MARKERS_ALGORITHM_AS_PA__
				MAKE_BASE_MARKERS(pBMIndices + 2 * nBaseMin, pBMX + 2 * nBaseMin, pBMY + 2 * nBaseMin, nBMSize - 2 * nBaseMin, pPeakIndices + nBaseMin, nSize - nBaseMin, vbx, vby)
				#else		/// __BASE_MARKERS_ALGORITHM_AS_PA__
				if ( nBaseMin < nSize )
				{
					vby = dymax;
					vector			vPeaksX;
					vector<int>		vnMarkerIndices;
					vxPeaks.GetSubVector(vPeaksX, nBaseMin, nSize - 1);
					MakeBaseMarkers(vnMarkerIndices, vx, vy, vbx, vby, vPeaksX);
					lpstMoreInfo->vnBaseMarkerIndices.Append(vnMarkerIndices);
				}
				#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
				///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
			}
		}
		///------ Folger 12/16/2010 ORG-1741-P1 QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA
		#ifdef		__BASE_MARKERS_ALGORITHM_AS_PA__
		for ( int ii=0; ii<nBMSize; ++ii )
		{
			int		nIndex = lpstMoreInfo->vnBaseMarkerIndices[ii];
			lpstMoreInfo->vxBaseMarkers[ii] = vx[nIndex];
			lpstMoreInfo->vyBaseMarkers[ii] = vy[nIndex];
		}
		#endif		/// __BASE_MARKERS_ALGORITHM_AS_PA__
		///------ End QUICK_PEAKS_FOLLOW_SAME_MARKER_ALGORITHM_AS_PA

		///------ Folger 12/08/2010 ORG-1675-S8 BASE_MARKER_FOLLOW_BASELINE_RANGE
		///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
#ifndef	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		if ( bLocalBaseline )
#else
		if ( bLocalBaseline && lpstMoreInfo->vnBaseMarkerIndices.GetSize() > 0 )
#endif	//__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__
		///end ///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
		{
			lpstMoreInfo->vnBaseMarkerIndices += i1;
		}
		///------ End BASE_MARKER_FOLLOW_BASELINE_RANGE
		///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
		//return TRUE;
		dp.GetDataPoints(0, -1, vx, vy);
		return UpdateIntegArea(dp, nSize, vx, vy, lpstMoreInfo, nBaseMin);
		///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	}
	///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

	///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	#define		GET_GUI_SETTING(_NAME) \
				Tree trGUI; \
				if( !GetGUITree(trGUI) ) \
					return FALSE; \	
				TreeNode tr = trGUI._NAME; \
				if ( !tr ) \
					return FALSE; \	
				return tr.nVal;

	BOOL	IsShowIntegArea()
	{
		GET_GUI_SETTING(area.ShowIntegArea);
	}

	int		IntegFrom()
	{
		GET_GUI_SETTING(area.IntegFrom);
	}
	
	BOOL	RemoveAreas()
	{
		Tree	tr;
		if ( !m_go.GetBinaryStorage(STR_PICK_PEAK_OBJ_STORAGE, tr) )
			return FALSE;
		
		vector<string>		vs;
		vs = tr.Areas.strVals;
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			GraphObject	go = m_gl.GraphObjects(vs[ii]);
			if ( go )
				go.Destroy();
		}
		return TRUE;
	}
	
	BOOL	UpdateIntegArea(const DataPlot& dp, int nPeakSize, vector& vx, vector& vy, FINDPEAKMOREINFO* lpstMoreInfo, int nBaseMin)
	{
		RemoveAreas();
		string				strBaseName;
		GetMainObjName(strBaseName);
		strBaseName += "IntegArea";
		vector<string>		vsNames(nPeakSize);
		BOOL				bShowIntegArea = IsShowIntegArea();
		int					nIntegFrom = IntegFrom();	
		///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
		bool bHasBaseline = hasBaseline();
		bool bSubtracted = false;
		if(bHasBaseline)
			_peak_gadget_baseline_subtracted_status(dp, bSubtracted);
		///end QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL

		vector vbx(2), vby(2);
		double dxmin, dxmax;
		double dymin, dymax;
		if ( !bHasBaseline )//if ( !hasBaseline() ) ///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
		{
			vx.GetMinMax(dxmin, dxmax);
			vbx[0] = dxmin;
			vbx[1] = dxmax;
			vy.GetMinMax(dymin, dymax);
		}
		
		///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
		vector<uint> vnOrder;
		check_sort_data_for_find_peaks(vy, vx, vnOrder);
		///End PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA

		for ( int ii=0; ii<nPeakSize; ++ii )
		{
			double				x1, x2;
			vector				vvx, vvy;
			int					n1 = lpstMoreInfo->vnBaseMarkerIndices[2 * ii];
			int					n2 = lpstMoreInfo->vnBaseMarkerIndices[2 * ii + 1];
			///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
			//if ( dp.GetDataPoints(n1, n2, vvx, vvy) <= 0 )
			//{
			//	O_A_FAIL;
			//	continue;
			//}
			if( vnOrder.GetSize() )
			{
				vector<uint> vecIndex;
				
				if( vnOrder.Find(vecIndex, n1) <= 0 )
					continue;
				n1 = vecIndex[0];
				if( vnOrder.Find(vecIndex, n2) <= 0 )
					continue;
				n2 = vecIndex[0];
			}
			if( n1 > n2 )
			{
				int nn = n1;
				n1 = n2;
				n2 = nn;
			}
			vx.GetSubVector(vvx, n1, n2);
			vy.GetSubVector(vvy, n1, n2);
			///End PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA

			
			///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
			//IntegToolHelper	area(vvx, vvy, x1, x2);
			IntegToolHelper	area(vvx, vvy, x1, x2, &vx, &vy);
			///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
			///Sophy 10/18/2011 ORG-4111-P1 WRONG_INTEG_AREA_WHEN_X_DATA_CONTAINS_MINUS_VALUE
			GetRectCoordinate(area.m_s1, area.m_s2);
			///end WRONG_INTEG_AREA_WHEN_X_DATA_CONTAINS_MINUS_VALUE
			area.m_vbx = vx;
			
			///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			//if ( INTEGFROM_BASELINE == nIntegFrom )
			if ( INTEGFROM_BASELINE == nIntegFrom && !bSubtracted )
			///end QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
			{
				area.m_vby.SetSize(vx.GetSize());
				if ( bHasBaseline )//if ( hasBaseline() ) ///Philip 09/05/2012 ORG-6662-P1 QUICK_PEAKS_WRONG_SHADED_AREA_AFTER_SUBTRACT_BL
				{
					ocmath_interpolate(vx, area.m_vby, vx.GetSize(), m_vxBaseline, m_vyBaseline, m_vxBaseline.GetSize());
				}
				else
				{
					if ( nBaseMin < 0 || ii < nBaseMin )
					{
						vby = dymin;
					}
					else
					{
						vby = dymax;
					}
					ocmath_interpolate(vx, area.m_vby, vx.GetSize(), vbx, vby, vbx.GetSize());
				}
			}
			else
			{
				area.m_vby = 0;
				area.m_vby.SetSize(vx.GetSize());
			}

			if ( lpstMoreInfo )
			{
				IntegrationResult		integResult;
				ocmath_integrate_with_bounds(lpstMoreInfo->vxBaseMarkers[2 * ii], lpstMoreInfo->vxBaseMarkers[2 * ii + 1], vx.GetSize(), vx, vy, &integResult, area.m_vby);
				lpstMoreInfo->vArea.Add(integResult.Area);
				lpstMoreInfo->vFWHM.Add(integResult.dxPeak);
				lpstMoreInfo->vCentroid.Add(integResult.xCentroid);
				lpstMoreInfo->vxLeft.Add(integResult.xLeft);
				lpstMoreInfo->vxRight.Add(integResult.xRight);
			}

			if ( bShowIntegArea )
			{
				if ( vvx.GetSize() < 3 )
					continue;
				vsNames[ii].Format("%s%d", strBaseName, ii + 1);
				vsNames[ii] = area.CreateArea(m_gl, vsNames[ii]);
				area.UpdateIntegArea(dp);
			}
		}

		if ( bShowIntegArea )
		{
			Tree	tr;
			tr.Areas.strVals = vsNames;
			return m_go.PutBinaryStorage(STR_PICK_PEAK_OBJ_STORAGE, tr);
		}
		
		return m_go.SetMemory(STR_PICK_PEAK_OBJ_STORAGE, NULL);
	}
	///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

	///------ Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL
	BOOL	IsShowPeakNum()
	{
		GET_GUI_SETTING(roi.ShowPeakNum);
	}
	///------ End SHOW_PEAK_NUM_ON_ROI_LABEL

	///------ Folger 12/07/2010 ORG-1652-S1 SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES
	int		BaseMarkerColor()
	{
		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//GET_GUI_SETTING(findpeak.Display.BaseMarkerColor);
		GET_GUI_SETTING(findpeak.Display.BaseMarker.Color);
		/// end NEW_PEAK_DISPLAY_GUI
	}
	///------ End SUPPORT_BASE_MARKER_AS_GROBJ_AND_DUMP_TO_NOTES

	/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
	int		BaseMarkerSize()
	{
		GET_GUI_SETTING(findpeak.Display.BaseMarker.Size);
	}
	
	int		PeakMarkerSize()
	{
		GET_GUI_SETTING(findpeak.Display.PeakMarker.Size);
	}
	/// end NEW_PEAK_DISPLAY_GUI
	
	///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
	int		PeakMarkerColor()
	{
		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		//GET_GUI_SETTING(findpeak.Display.PeakMarkerColor);
		GET_GUI_SETTING(findpeak.Display.PeakMarker.Color);
		/// end NEW_PEAK_DISPLAY_GUI
	}
	///------ End SUPPORT_PEAK_MARKER_COLOR

	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	int		BaselineRange()
	{
		GET_GUI_SETTING(baseline.Range);
	}
	
	int		BaselineMode()
	{
		GET_GUI_SETTING(baseline.mode);
	}

	BOOL	IsLocalBaseline()
	{
		return BASELINE_RANGE_WITHIN_ROI == BaselineRange();
	}
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE

	virtual bool GetResultsTree(TreeNode& trResults)
	{
		trResults = m_trOutput.Results;
		trResults.SetAttribute(STR_TR2WKS_NO_RENAME_SNAME_ATTRIB, TRUE);
		return true;
	}

	///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
	BOOL	GetColumns(Column& colX, Column& colY, DataPlot& dp)
	{
		XYRange		xy;
		if ( !dp.GetDataRange(xy) || !xy )
			return FALSE;

		xy.GetXColumn(colX);
		return xy.GetYColumn(colY);
	}
	///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT

private:
	DataRange				m_dr;

	bool					m_bGlobalBL;
	vector					m_vxBaseline;
	vector					m_vyBaseline;
	PolylineGraphObject		m_goBaseline;
	///Sophy 1/26/2011 ORG-2116-S1 QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
	vector<string>			m_vsFunctions;
	///end QUICK_PEAKS_FLYOUT_MENU_FOR_EASY_PEAK_FITTING
	Tree					m_trOutput;
	
	bool					m_bHasNonMonoData;		///Kyle 08/05/2011 ORG-2507-P3 PEAK_MARKERS_FINDING_ALLOW_NON_MONOTONIC_DATA
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////// global functions //////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////

#define STR_REF_DATA_MULTI_SEL_ATTRIB			"RefMultiSel"
bool baseline_creation_multi_sel_attrib_access(TreeNode& trBaseline, bool bGet, bool bMultiSel)		// true, false
{
	if( !trBaseline )
	{
		ASSERT(0);
		return false;
	}
	TreeNode trCreation = trBaseline.creation;
	if(trCreation)
	{
		int nMultiSel;
		if( bGet )
		{
			if( trCreation.GetAttribute(STR_REF_DATA_MULTI_SEL_ATTRIB, nMultiSel) && nMultiSel )
				return true;
		}
		else
		{
			if( bMultiSel )
			{
				nMultiSel = 1;
				trCreation.SetAttribute(STR_REF_DATA_MULTI_SEL_ATTRIB, nMultiSel);
			}
			else
			{
				trCreation.RemoveAttribute(STR_REF_DATA_MULTI_SEL_ATTRIB);
			}
			_show_hide_baseline_creation_refer_data(trBaseline);
			return true;
		}
	}
	return false;
}

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
//bool check_update_roi_x_position(TreeNode& trXScale)
//{
	//if( trXScale.fixscale.nVal )	// Fixed checkbox default is unchecked, if it is fixed load from theme, should use x position settings in theme.
		//return false;
//
	//GraphLayer gl = Project.ActiveLayer();
	//if( !gl )
		//return false;
//
	//string strLeft, strRight, strRect;
//
	//get_ROI_main_obj_name(gl, XFNAME, strRect);
	//if( check_get_roi_x_position(gl, strLeft, strRight, strRect) )
	//{
		//trXScale.leftx.strVal = strLeft;
		//trXScale.rightx.strVal = strRight;
//
		//return true;
	//}
//
	//return false;
//}
///ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
int	getn_handle_quickpeaks(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES
		
	if ( GETNE_ON_APPLY == nEvent || GETNE_ON_INIT == nEvent )
	{
		bApplyEnable = false;
	}
	return 0;
}

bool	quickpeaks_apply_handle(TreeNode& tr)
{
	GUI_TREE(trGUI, tr);
	string	strMainObjName;
	if ( trGUI.GetAttribute(STR_MAINOBJ_NAME_ATTRIB, strMainObjName) )
	{
		PickPeakTool	tool(strMainObjName);
		tool.ApplyAfterEdit(trGUI);
		return true;
	}
	return false;
}
///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

void construct_pick_peak_gui(TreeNode& trGUI)
{
	if( !trGUI )
		return;
	
	trGUI.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);

	TreeNode trROI = trGUI.AddNode("roi");
	trROI.SetAttribute(STR_LABEL_ATTRIB, _L("ROI Box"));
	_construct_peak_gadget_roi_gui(trROI);

	TreeNode trBaseline = trGUI.AddNode("baseline");
	trBaseline.SetAttribute(STR_LABEL_ATTRIB, _L("Baseline"));
	_construct_peak_gadget_baseline_gui(trBaseline);
	
	TreeNode trFindPeak = trGUI.AddNode("findpeak");
	trFindPeak.SetAttribute(STR_LABEL_ATTRIB, _L("Find Peak"));
	_construct_peak_gadget_find_peak_gui(trFindPeak);

	///------ Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	TreeNode trArea = trGUI.AddNode("area");
	trArea.SetAttribute(STR_LABEL_ATTRIB, _L("Area"));
	_construct_peak_gadget_roi_area(trArea);
	///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
	
	///Jasmine 12/09/10 ORG-1697-S2 ADD_MORE_SETTINGS_FOR_OUTPUT
	TreeNode trOutput = trGUI.AddNode("outputsettings");
	trOutput.SetAttribute(STR_LABEL_ATTRIB, _L("Output to"));
	_construct_peak_gadget_output(trOutput);
	///End ADD_MORE_SETTINGS_FOR_OUTPUT
	
	///Jasmine 12/09/10 ORG-1697-S1 OUTPUT_MORE_PEAK_QUANTITIES	
	TreeNode trQualities = trGUI.AddNode("quantities");
	trQualities.SetAttribute(STR_LABEL_ATTRIB, _L("Quantities"));
	_construct_peak_gadget_quantities(trQualities);
	///End OUTPUT_MORE_PEAK_QUANTITIES

	///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
	gadget_gui_apply_support(trGUI, getn_handle_quickpeaks, quickpeaks_apply_handle);
	///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
}

int open_pick_peak_tool(TreeNode& trGUI)
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return XFERR_NO_ACTIVE_GRAPHPAGE;

	int nErr = 0;
	string strMainObjName;
	if ( get_ROI_main_obj_name(gl, XFNAME, strMainObjName) ) //attach to existing tool
	{
		PickPeakTool qtool(strMainObjName);
		Tree tr;
		qtool.GetTree(tr);

		tr.GUI.Replace(trGUI.Clone(), true, true, true); //need to keep version attribute for checking.
		qtool.UpdateAttribsInGUITree(tr.GUI);

		qtool.SetTree(tr);
		qtool.ApplySettings();

		graphobjtool_events(qtool, strMainObjName, OE_MOVE);
	}
	else
	{
		PickPeakTool itool;
		nErr = itool.Create(XFNAME, 0, trGUI);
	}

	return nErr;
}

void addtool_quickpeaks_events(string strGrName, int nEvent, int nMsg = 0)
{
	PickPeakTool itool;
	graphobjtool_events(itool, strGrName, nEvent, nMsg);
}

///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
int	addtool_quickpeaks_msg(LPVOID lpMsgInfo)
{
	PickPeakTool itool;
	return graphobjtool_msg(itool, lpMsgInfo);
}
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
int	GlobalGadget_addtool_quickpeaks(int nMsg, WPARAM wParam, LPARAM lParam)
{
	PickPeakTool itool;
	return GlobalGadget_graphobjtool(itool, nMsg, wParam, lParam);
}
///------ End GLOBAL_GADGET_MANAGER

///////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////// static functions //////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////
#define GETN_INPUT_RANGE_OPTION(nInputOptions)		\
	GETN_CURRENT_SUBNODE.SetAttribute(STR_XF_VAR_IO_ATTRIB, IO_INPUT);		\
	GETN_CURRENT_SUBNODE.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, nInputOptions);	\
	/*///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA*/ \
	/*GETN_CURRENT_SUBNODE.SetAttribute(STR_ACTION_FILTER_TAGS, STR_DATASETOBJ_PICK_PEAK);*/ \
	GETN_CURRENT_SUBNODE.SetAttribute(STR_ACTION_FILTER_TAGS, STR_DATASETOBJ_PICK_PEAK "|" STR_DATASETOBJ_SOURCE_CURVE);
	/*///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA*/
	
	
///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
double _get_total_height(const vector& vy, bool bHasBaseline)
{
	double dMin, dMax;
	vy.GetMinMax(dMin, dMax);
	return bHasBaseline ? max(abs(dMax), abs(dMin)) : dMax - dMin;
}

double _get_total_width(const vector& vx)
{
	double dMin, dMax;
	vx.GetMinMax(dMin, dMax);
	return abs(dMax - dMin);
}

static bool _get_current_source_data(vector& vxSrc, vector& vySrc, double dRectFrom, double dRectTo)
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return false;

	string strRect;
	get_ROI_main_obj_name(gl, XFNAME, strRect);

	DataPlot dp;
	int i1, i2;
	if( find_intersect_dataplot(dp, i1, i2, gl, strRect, dRectFrom, dRectTo) )
	{
		dp.GetDataPoints(i1, i2, vxSrc, vySrc);
		return vxSrc.GetSize() > 0;
	}

	return false;
}
///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

static void _set_xy_range_subnode_id(TreeNode& trInput, int nBranchID, int nRange1ID, int nXID, int nYID, int nEdID)
{
	trInput.DataID = nBranchID;

	TreeNode trRange1 = trInput.FirstNode;
	trRange1.DataID = nRange1ID;

	trRange1.X.DataID = nXID;
	trRange1.Y.DataID = nYID;
	trRange1.ED.DataID = nEdID;
}

static void _construct_peak_gadget_baseline_gui(TreeNode& tr)
{
	if( !tr )
		return;
	
	int nInputOptions = ICOPT_RESTRICT_TO_ONE_DATA | ICOPT_RESTRICT_TO_Y_COLUMNS;

	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_BASELINE)		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)

	///Jasmine 12/06/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	//GETN_LIST(mode, "Mode", PEAK_BASELINE_MODE_AUTO, _L("Min/Max|Use Existing Dataset|Constant|2nd Derivative"))
	///------ Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
	//GETN_LIST(mode, "Mode", PEAK_BASELINE_MODE_AUTO, _L("Min/Max|Use Existing Dataset|Constant|2nd Derivative|End Points Weighted"))
	GETN_LIST(mode, _L("Mode"), PEAK_BASELINE_MODE_AUTO, _L("None|Constant|2nd Derivative|Use Existing Dataset|Min&Max|End Points Weighted"))
	///------ End ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
	///End  ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_MODE)		GETN_OPTION_EVENT_EX(_on_update_gui_baseline_mode)
	
	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	GETN_RADIO_INDEX_EX(Range, _L("Range"), BASELINE_RANGE_WITHIN_ROI, _L("Full Plot Range|Curve Within ROI"))	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_RANGE)
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE

	GETN_XYRANGE(dataset, _L("Dataset"), 1, STR_OPTIONAL)
	GETN_INPUT_RANGE_OPTION(nInputOptions)				GETN_CURRENT_SUBNODE.Show = false;		GETN_OPTION_INTERACTIVE_CONTROL(ICOPT_KEEP_ACTIVE_DATA | ICOPT_RESTRICT_TO_ONE_DATA)
	_set_xy_range_subnode_id(GETN_CURRENT_SUBNODE, PEAK_PICK_BRANCH_ID_EXISTING_DATASET, PEAK_PICK_BRANCH_ID_DATASET_RANGE1, PEAK_PICK_VAR_ID_DATASET_X, PEAK_PICK_VAR_ID_DATASET_Y, PEAK_PICK_VAR_ID_DATASET_ED);

	GETN_LIST(constant, _L("Constant"), 0, _L("Minimum|Maximum|Mean|Median|Custom"))
	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_CONST)	GETN_OPTION_EVENT_EX(_on_update_gui_baseline_const)		GETN_CURRENT_SUBNODE.Show = false;

	GETN_LIST(creation, _L("Baseline Creation"), PEAK_BASELINE_CREATION_GLOBAL, _L("Use a Global Baseline for All Plots|Use its Own Baseline for Each Plot"))
	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_CREATION)			GETN_OPTION_EVENT_EX(_on_update_gui_baseline_creation)		GETN_CURRENT_SUBNODE.Show = false;

	GETN_XYRANGE(refer, _L("Reference Data"), 1, STR_OPTIONAL)
	GETN_INPUT_RANGE_OPTION(nInputOptions)				GETN_CURRENT_SUBNODE.Show = false;
	_set_xy_range_subnode_id(GETN_CURRENT_SUBNODE, PEAK_PICK_BRANCH_ID_REFERENCE_DATA, PEAK_PICK_BRANCH_ID_DATA_RANGE1, PEAK_PICK_VAR_ID_DATA_X, PEAK_PICK_VAR_ID_DATA_Y, PEAK_PICK_VAR_ID_DATA_ED);

	GETN_NUM(ybase, _L("Y ="), 0)
	GETN_ID(PEAK_PICK_VAR_ID_Y_BASE)		GETN_CURRENT_SUBNODE.Show = false;

	///------ Folger 12/08/2010 ORG-1675-S2 BETTER_HINT_FOR_BASELINE_MODE
	///Kyle 01/10/2011 ORG-1736-S3 IMPROVE_HINTS_FOR_MIN_MAX_MODE
	//GETN_STR(HintMinMax, _L("Use minimum and maximum Y as baseline separately to find peak twice"), "")		GETN_HINT_EX(TRUE, FALSE)
	GETN_STR(HintMinMax, _L("Use minimum Y as baseline to find positive peaks. Use Maximum Y as baseline to find negative peaks."), "")		GETN_HINT_EX(TRUE, FALSE)
	///End IMPROVE_HINTS_FOR_MIN_MAX_MODE
	///------ End BETTER_HINT_FOR_BASELINE_MODE

	///Jasmine 12/06/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	GETN_NUM(EndPoints, _L("End Points(%)"), 12.5)										GETN_ID(PEAK_PICK_VAR_ID_BASELINE_ENDPOINT)
	///End ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	
	///------ Folger 12/08/2010 ORG-1675-S2 BETTER_HINT_FOR_BASELINE_MODE
	GETN_STR(HintEndPoints, _L("Create a smoothed curve using data points from two ends"), "")					GETN_HINT_EX(TRUE, FALSE)
	///------ End BETTER_HINT_FOR_BASELINE_MODE
	
	///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
	GETN_BEGIN_BRANCH(SmoothMethodBranch, STR_PICKPEAK_BASELINE_SMOOTHMETHOD)			GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_RADIO_INDEX(SmoothMethod, 0, STR_PICKPEAK_BASELINE_SMOOTHMETHOD_LIST)		GETN_ID(PEAK_PICK_VAR_ID_BASELINE_SMOOTH_METHOD)
			GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	
			GETN_OPTION_EVENT_EX(_on_update_gui_baseline_smooth_method)
		GETN_NUM(WindowSize, STR_PICKPEAK_BASELINE_WINDOWSIZE, 1)						GETN_ID(PEAK_PICK_VAR_ID_BASELINE_WIN_SIZE)
		GETN_NUM(Threshold, STR_PICKPEAK_BASELINE_THRESHOLD, 0.05)						GETN_ID(PEAK_PICK_VAR_ID_BASELINE_THRESHOLD)
		GETN_COMBO(PolyOrder, STR_PICKPEAK_BASELINE_OLYORDER, 2, "1|2|3|4|5|6|7|8|9")	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_POLY_ORDER)
	GETN_END_BRANCH(SmoothMethodBranch)
	///End IMPROVE_BASELINE_DETECTION
	GETN_NUM(npoints, _L("Maximum Anchor Points"), 8)	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_N_POINTS)
		GETN_CURRENT_SUBNODE.Show = false;
	///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
	//GETN_CHECK(snap, _L("Snap to Spectrum"), 0)				GETN_ID(PEAK_PICK_VAR_ID_BASELINE_SNAP)
	//	GETN_CURRENT_SUBNODE.Show = false;
	///End REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
	GETN_LIST(connect, _L("Connect Method"), 0, _L("Line|Spline|BSpline"))	GETN_ID(PEAK_PICK_VAR_ID_BASELINE_CONNECT)
		GETN_CURRENT_SUBNODE.Show = false;

}

static void _construct_peak_gadget_find_peak_gui(TreeNode& tr)
{
	if( !tr )
		return;

	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_FIND_PEAK)		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)

	GETN_LIST(dir, _L("Direction"), PEAK_DIRECTION_BOTH, _L("Positive|Negative|Both"))				GETN_ID(PEAK_PICK_VAR_ID_DIRECTION)

	GETN_BEGIN_BRANCH(settings, _L("Peak Finding Settings"))	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_PEAK_FINDING_SETTINGS)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		///Sophy 3/5/2011 ORG-2351-P1 CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
		//GETN_LIST(method, _L("Method"), 0, _L("Local Maximum|Window Search|1st Derivative|2nd Derivative (Search Hidden Peaks)|Residuals (Search Hidden Peaks)"))
		GETN_LIST(method, _L("Method"), 0, get_find_peak_methods())
		///end CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
		GETN_ID(PEAK_PICK_VAR_ID_METHOD) GETN_OPTION_EVENT_EX(_on_update_gui_peak_finding_method)

		GETN_NUM(npts, _L("Local Points"), 2)
		GETN_ID(PEAK_PICK_VAR_ID_LOCAL_POINTS)

		GETN_LIST(option, _L("Size Option"), SIZE_OPTION_PERCENT_OF_RAW_DATA, _L("Raw Size|Percent of Raw Data"))
		GETN_ID(PEAK_PICK_VAR_ID_SIZE_OPTION)		GETN_OPTION_EVENT_EX(_on_update_gui_size_option)					GETN_CURRENT_SUBNODE.Show = false;
		GETN_NUM(height, _L("Height"), 20)
		GETN_ID(PEAK_PICK_VAR_ID_HEIGHT)			GETN_ADD_AUTO(1)	GETN_OPTION_EVENT_EX(_on_update_gui_height)		GETN_CURRENT_SUBNODE.Show = false;
		GETN_NUM(width, _L("Width"), 50)
		GETN_ID(PEAK_PICK_VAR_ID_WIDTH)				GETN_ADD_AUTO(1)	GETN_OPTION_EVENT_EX(_on_update_gui_width)		GETN_CURRENT_SUBNODE.Show = false;
		
		GETN_BEGIN_BRANCH(deriv_smooth, _L("Smooth Derivative"))
		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_DERIV_SMOOTH)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)							GETN_CURRENT_NODE.Show = false;
			GETN_LIST(first,_L("Method"), 0, _L("None|Savitzky-Golay")) 																GETN_ID(PEAK_PICK_VAR_ID_FIRST)		GETN_OPTION_EVENT_EX(_on_update_gui_deriv_smooth)
			GETN_LIST(second,_L("Method"), 0, _L("None|FFT Filter|Adjacent-Averaging|Savitzky-Golay|Quadratic Savitzky-Golay"))		    GETN_ID(PEAK_PICK_VAR_ID_SECOND)	GETN_OPTION_EVENT_EX(_on_update_gui_deriv_smooth)
			GETN_NUM(fft_cutoff, _L("Cut Off Frequency"), 0.2) 																			GETN_ID(PEAK_PICK_VAR_ID_FFT_CUTOFF)
			GETN_NUM(deriv_poly, _L("Polynomial Order"), 2) 																			GETN_ID(PEAK_PICK_VAR_ID_DERIV_POLY)
			GETN_NUM(deriv_npts, _L("Points of Window"), 20) 																			GETN_ID(PEAK_PICK_VAR_ID_DERIV_NPTS)
		GETN_END_BRANCH(deriv_smooth)
	GETN_END_BRANCH(settings)

	GETN_BEGIN_BRANCH(filter, _L("Peak Filtering"))	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_PEAK_FILTERING)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_LIST(method, _L("Method"), PEAK_FILTER_HEIGHT, _L("None|By Height|By Number")) 		GETN_ID(PEAK_PICK_VAR_ID_FILTER)		GETN_OPTION_EVENT_EX(_on_update_gui_filter_params_status)
		GETN_NUM(val_height, _L("Threshold Height(%)"), 20)		GETN_ADD_AUTO(1)
		GETN_ID(PEAK_PICK_VAR_ID_VAL_HEIGHT)	GETN_OPTION_EVENT_EX(_on_update_gui_filter_value)
		GETN_NUM(val_num, _L("Number of Peaks"), NANUM)			GETN_ADD_AUTO(1)		GETN_CURRENT_SUBNODE.Show = false;
		GETN_ID(PEAK_PICK_VAR_ID_VAL_NUM)		GETN_OPTION_EVENT_EX(_on_update_gui_filter_value)
	GETN_END_BRANCH(filter)

	GETN_BEGIN_BRANCH(Display, _L("Peak Display"))	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_PEAK_DISPLAY)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
		/*
		///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
		GETN_COLOR(PeakMarkerColor, _L("Peak Marker Color"), SYSCOLOR_RED)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE | COLORLIST_CUSTOM | COLORLIST_SINGLE) GETN_ID(PEAK_PICK_VAR_ID_PEAK_MARKER_COLOR)		GETN_OPTION_EVENT_EX(_on_update_gui_show_label)
		GETN_CONTROL_OPTION_BOX(1) /// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		///------ End SUPPORT_PEAK_MARKER_COLOR
		GETN_CHECK(sl, _L("Show Center Label"), 1)													GETN_ID(PEAK_PICK_VAR_ID_SHOW_LABEL)	GETN_OPTION_EVENT_EX(_on_update_gui_show_label) GETN_BEGIN_GROUP("Test Fake Branch") SET_BRANCH_AS_GROUP_BOX(_L("Peak Label"))
		GETN_LIST(lc, _L("Center Label"), 0, _L("X of Peaks|Y of Peaks|(X,Y) of Peaks"))			GETN_ID(PEAK_PICK_VAR_ID_CENTER_LABEL)
		GETN_CHECK(lr, _L("Rotate Center Label"), 1)												GETN_ID(PEAK_PICK_VAR_ID_ROLATE_LABEL)
		GETN_COLOR(labelcolor, _L("Label Color"), 0)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE) GETN_ID(PEAK_PICK_VAR_ID_LABEL_COLOR) GETN_END_GROUP
		///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		GETN_COLOR(BaseMarkerColor, _L("Base Marker Color"), SYSCOLOR_BLUE)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE | COLORLIST_CUSTOM | COLORLIST_SINGLE) GETN_ID(PEAK_PICK_VAR_ID_BASE_MARKER_COLOR)
		GETN_CONTROL_OPTION_BOX(0) /// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
		///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
		*/
		GETN_BEGIN_BRANCH(PeakMarker, _L("Peak Marker"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		GETN_CHECKBOX_BRANCH(1)
		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_DISPLAY_PEAK_MARKER)			///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
			GETN_COLOR(Color, _L("Color"), SYSCOLOR_RED)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE)	GETN_ID(PEAK_PICK_VAR_ID_PEAK_MARKER_COLOR)
			GETN_COMBO(Size, _L("Size"), 10, "|10|15|20|25|30")
			GETN_ID(PEAK_PICK_VAR_ID_PEAK_MARKER_SIZE)					///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
		GETN_END_BRANCH(PeakMarker)
		GETN_BEGIN_BRANCH(PeakLabel, _L("Peak Label"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		GETN_CHECKBOX_BRANCH(1)
		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_DISPLAY_PEAK_LABEL)			///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
			GETN_LIST(Label, _L("Label"), 0, _L("X of Peaks|Y of Peaks|(X,Y) of Peaks"))			GETN_ID(PEAK_PICK_VAR_ID_CENTER_LABEL)
			GETN_CHECK(Horizontal, _L("Horizontal"), 0)		GETN_ID(PEAK_PICK_VAR_ID_LABEL_HIRIZONTAL)
			GETN_COLOR(Color, _L("Color"), SYSCOLOR_BLACK)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE)	GETN_ID(PEAK_PICK_VAR_ID_LABEL_COLOR)
		GETN_END_BRANCH(PeakLabel)					
		GETN_BEGIN_BRANCH(BaseMarker, _L("Base Marker"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		GETN_CHECKBOX_BRANCH(0)
		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_DISPLAY_BASE_MARKER)			///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
			GETN_COLOR(Color, _L("Color"), SYSCOLOR_BLUE)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE)	GETN_ID(PEAK_PICK_VAR_ID_BASE_MARKER_COLOR)
			GETN_COMBO(Size, _L("Size"), 10, "|10|15|20|25|30")
			GETN_ID(PEAK_PICK_VAR_ID_BASE_MARKER_SIZE)					///Kyle 03/23/2011 ORG-2067-P8 MISSING_BRANCH_ID_IN_QUICK_PEAK_GUI
		GETN_END_BRANCH(BaseMarker)
		/// end NEW_PEAK_DISPLAY_GUI
	GETN_END_BRANCH(Display)

	///Jasmine 12/09/10 ORG-1697 OUTPUT_MORE_PEAK_QUANTITIES
	//GETN_BEGIN_BRANCH(result, _L("Result"))		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_RESULT)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	///End OUTPUT_MORE_PEAK_QUANTITIES

	string strMapping;
	vector<string> vsList;
	TreeNode trDerivSmooth = tr.settings.deriv_smooth;

	vector<int> vnID1 = {DERIV_SMOOTH_NONE,	DERIV_SMOOTH_SG};
	convert_int_vector_to_string_vector(vnID1, vsList);
	strMapping.SetTokens(vsList, '|');
	trDerivSmooth.first.SetAttribute(STR_INTMAP_ATTRIB, strMapping);

	vector<int> vnID2 = {DERIV_SMOOTH_NONE, DERIV_SMOOTH_FFT, DERIV_SMOOTH_ADJ, DERIV_SMOOTH_SG, DERIV_SMOOTH_QSG};
	convert_int_vector_to_string_vector(vnID2, vsList);
	strMapping.SetTokens(vsList, '|');
	trDerivSmooth.second.SetAttribute(STR_INTMAP_ATTRIB, strMapping);
}

///------ Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
enum
{
	INTEGFROM_BASELINE		= 0,
	INTEGFROM_Y0,
};

static void _construct_peak_gadget_roi_area(TreeNode& tr)
{
	if( !tr )
		return;
	
	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_AREA)
	GETN_STR(hint, _L("Integrate Individual Peaks within Base Markers"), "")				GETN_HINT_EX(FALSE, FALSE)
	GETN_LIST(IntegFrom, _L("Integration from"), INTEGFROM_BASELINE, _L("Baseline|Y=0"))	GETN_ID(PEAK_PICK_VAR_ID_INTEGFROM)
	GETN_CHECK(ShowIntegArea, _L("Show Integrated Area"), 1)								GETN_ID(PEAK_PICK_VAR_ID_SHOW_INTEG_AREA)
}
///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

static void _construct_peak_gadget_roi_gui(TreeNode& tr)
{
	if( !tr )
		return;

	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_ROI_BOX)		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	
	GETN_BEGIN_BRANCH(XScale, _L("X Scale"))		GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_XSCALE)  GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		//GETN_NUM(leftx, _L("From"), 0)									GETN_ID(PEAK_PICK_VAR_ID_LEFT_X)
		//GETN_NUM(rightx, _L("To"), 10)									GETN_ID(PEAK_PICK_VAR_ID_RIGHT_X)
		GETN_STR(leftx, _L("From"), "0")									GETN_ID(PEAK_PICK_VAR_ID_LEFT_X)
		GETN_STR(rightx, _L("To"), "10")									GETN_ID(PEAK_PICK_VAR_ID_RIGHT_X)
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		GETN_CHECK(fixscale, _L("Fixed(Prevent moving by ROI)"), 0)		GETN_ID(PEAK_PICK_VAR_ID_FIXSCALE)
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	GETN_END_BRANCH(XScale)

	GETN_STR(toolname, STR_TOOLNAME, TOOLNAME)	GETN_ID(PEAK_PICK_VAR_ID_TOOL_NAME)	GETN_CONTROL_OPTION_BOX(0)
	///------ Folger 12/02/2010 ORG-1511-S3 SHOW_PEAK_NUM_ON_ROI_LABEL
	GETN_CHECK_L(ShowPeakNum, _L("Show Number of Peaks on Center-Top"), 1)	GETN_ID(PEAK_PICK_VAR_ID_SHOW_PEAK_NUM)
	///------ End SHOW_PEAK_NUM_ON_ROI_LABEL
	///Sophy 2/17/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	//GETN_COLOR(rectcolor, STR_FILL_COLOR, 20)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE) GETN_ID(PEAK_PICK_VAR_ID_RECT_COLOR)
	GETN_COLOR(rectcolor, STR_FILL_COLOR, INDEX_COLOR_AUTOMATIC)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE | COLORLIST_AUTO) GETN_ID(PEAK_PICK_VAR_ID_RECT_COLOR)
	GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_AUTO_COLOR, SYSCOLOR_LTYELLOW);	
	///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
}

///Jasmine 12/09/10 ORG-1697-S2 ADD_MORE_SETTINGS_FOR_OUTPUT
static void _construct_peak_gadget_output(TreeNode& tr)
{
	if( !tr )
		return;

	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_RESULT)	
	
	GETN_CHECK(ScriptWindow, _L("Script Window"), 0)					GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_SCRIPT_WIN)
	GETN_CHECK(ResultLog, _L("Result Log"), 0)							GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_RESULT_LOG)
	GETN_CHECK(AppendtoWorksheet, _L("Append to Worksheet"), 1)			GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_CHECK)
		GETN_OPTION_EVENT_EX(_on_check_output_result)	
	GETN_STR(output, _L("Result Worksheet Name"), "[QkPeak]%C_Result")	GETN_ID(PEAK_PICK_VAR_ID_OUTPUT)
	
	GETN_SEPARATOR_LINE	
	///Kyle 01/10/2011 ORG-1736-S5 BETTER_LABEL_FOR_OUTPUT_BASELINE
	//GETN_CHECK(OutputBaseline, _L("Output Baseline"), 0)									GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_BASE_CHECK)
	GETN_CHECK(OutputBaseline, _L("Output Baseline to Worksheet"), 0)									GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_BASE_CHECK)
	///End BETTER_LABEL_FOR_OUTPUT_BASELINE
		GETN_OPTION_EVENT_EX(_on_check_output_baseline)	
	GETN_STR(BaselineWorksheetName, _L("Baseline Worksheet Name"), "[QkPeak]%C_Baseline")	GETN_ID(PEAK_PICK_VAR_ID_OUTPUT_BASE)
}
///End ADD_MORE_SETTINGS_FOR_OUTPUT

///Jasmine 12/09/10 ORG-1697-S1 OUTPUT_MORE_PEAK_QUANTITIES	
static void _construct_peak_gadget_quantities(TreeNode& tr)
{
	if( !tr )
		return;

	GETN_USE(tr)
	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_QUANTITIES)	
	
	GETN_BEGIN_BRANCH(OutputQuantities, _L("Output Quantities"))	GETN_ID_BRANCH(PEAK_PICK_BRANCH_ID_OUTPUT_QUANTITIES)  
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN|GETNBRANCH_CHECK_CONTROL)
		
		GETN_CHECK(DatasetName, _L("Dataset Name"), 1)	GETN_ID(PEAK_PICK_VAR_ID_DATASET)
		GETN_CHECK(PeakID, _L("Peak ID"), 1)			GETN_ID(PEAK_PICK_VAR_ID_PEAK_ID)
		GETN_CHECK(PeakRow, _L("Peak Row"), 1)			GETN_ID(PEAK_PICK_VAR_ID_PEAK_ROW)
		GETN_CHECK(PeakX, STR_PEAK_X, 1)				GETN_ID(PEAK_PICK_VAR_ID_PEAK_X)
		GETN_CHECK(PeakY, STR_PEAK_Y, 1)				GETN_ID(PEAK_PICK_VAR_ID_PEAK_Y)
		GETN_CHECK(Height, _L("Height"), 1)				GETN_ID(PEAK_PICK_VAR_ID_PEAK_HEIGHT)
		GETN_CHECK(PeakArea, _L("Peak Area"), 1)		GETN_ID(PEAK_PICK_VAR_ID_PEAK_AREA)
		GETN_CHECK(FWHM, _L("FWHM"), 1)					GETN_ID(PEAK_PICK_VAR_ID_FWHM)
		GETN_CHECK(Centroid, _L("Centroid"), 0)			GETN_ID(PEAK_PICK_VAR_ID_CENTROID)
		GETN_CHECK(LeftHalfWidth, _L("Left Half Width"), 0)					GETN_ID(PEAK_PICK_VAR_ID_LEFT_HALF_WIDTH)
		GETN_CHECK(RightHalfWidth, _L("Right Half Width"), 0)				GETN_ID(PEAK_PICK_VAR_ID_RIGHT_HALF_WIDTH)
		GETN_CHECK(LeftBaseMarkerIndex, _L("Left Base Marker Row"), 0)		GETN_ID(PEAK_PICK_VAR_ID_LEFT_BASE_MARKER_INDEX)
		GETN_CHECK(LeftBaseMarkerX, STR_LEFT_BASE_MARKERS_X, 0)	GETN_ID(PEAK_PICK_VAR_ID_LEFT_BASE_MARK_X)
		GETN_CHECK(LeftBaseMarkerY, STR_LEFT_BASE_MARKERS_Y, 0)	GETN_ID(PEAK_PICK_VAR_ID_LEFT_BASE_MARK_Y)
		GETN_CHECK(RightBaseMarkerIndex, _L("Right Base Marker Row"), 0)	GETN_ID(PEAK_PICK_VAR_ID_RIGHT_BASE_MARKER_INDEX)
		GETN_CHECK(RightBaseMarkerX, STR_RIGHT_BASE_MARKERS_X, 0)	GETN_ID(PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_X)
		GETN_CHECK(RightBaseMarkerY, STR_RIGHT_BASE_MARKERS_Y, 0)	GETN_ID(PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_Y)
		GETN_CHECK(Info, _L("Info"), 1)								GETN_ID(PEAK_PICK_VAR_ID_RIGHT_BASE_MARK_INFO)
	GETN_END_BRANCH(OutputQuantities)
}
///End OUTPUT_MORE_PEAK_QUANTITIES

static void _get_deriv_status(TreeNode& trSettings, bool& bHasBasicDerivSmoothMethods, bool& bHas2ndDerivSmoothMethods, 
								bool& bUseDerivSmooth, bool& bUseSG, bool& bUseADJ, bool& bUseFFT)
{
	TreeNode trDerivSmooth 		= trSettings.deriv_smooth;
	bHasBasicDerivSmoothMethods = (trSettings.method.nVal == PEAK_FINDING_METHOD_FIRST || trSettings.method.nVal == PEAK_FINDING_METHOD_RESIDUE);
	bHas2ndDerivSmoothMethods 	= (trSettings.method.nVal == PEAK_FINDING_METHOD_SECOND);
	bUseDerivSmooth 			= (bHasBasicDerivSmoothMethods || bHas2ndDerivSmoothMethods) ;
	bUseSG						= (bHasBasicDerivSmoothMethods && (trDerivSmooth.first.nVal == DERIV_SMOOTH_SG))
									|| (bHas2ndDerivSmoothMethods && ((trDerivSmooth.second.nVal == DERIV_SMOOTH_SG) 
									|| (trDerivSmooth.second.nVal == DERIV_SMOOTH_QSG)));
	bUseADJ 					= (bHas2ndDerivSmoothMethods && (trDerivSmooth.second.nVal == DERIV_SMOOTH_ADJ));
	bUseFFT 					= (bHas2ndDerivSmoothMethods && (trDerivSmooth.second.nVal == DERIV_SMOOTH_FFT));
}

static void _update_gui_deriv_smooth(TreeNode& trSettings)
{
	bool bHasBasicDerivSmoothMethods,  bHas2ndDerivSmoothMethods, bUseDerivSmooth, bUseSG, bUseADJ, bUseFFT;
	_get_deriv_status(trSettings, bHasBasicDerivSmoothMethods, bHas2ndDerivSmoothMethods, bUseDerivSmooth,  bUseSG, bUseADJ, bUseFFT);
	TreeNode trDerivSmooth = trSettings.deriv_smooth;
	trDerivSmooth.first.Show = bHasBasicDerivSmoothMethods;
	trDerivSmooth.second.Show = bHas2ndDerivSmoothMethods;	
	trDerivSmooth.fft_cutoff.Show = bUseFFT;
	trDerivSmooth.deriv_npts.Show = (bUseADJ || bUseSG);
	trDerivSmooth.deriv_poly.Show = bUseSG;
}

static bool _show_hide_baseline_creation_refer_data(TreeNode trBaseline)
{
	if( !trBaseline )
		return false;

	if( baseline_creation_multi_sel_attrib_access(trBaseline) )
	{
		bool bConstant = PEAK_BASELINE_MODE_CONSTANT==trBaseline.mode.nVal;
		bool bAuto = PEAK_BASELINE_MODE_AUTO==trBaseline.mode.nVal;
		bool bCreation = (bConstant && PEAK_BASELINE_CONST_CUSTOM!=trBaseline.constant.nVal) || bAuto;

		trBaseline.creation.Show = bCreation;
		trBaseline.refer.Show = bCreation && PEAK_BASELINE_CREATION_GLOBAL==trBaseline.creation.nVal;
	}
	else
	{
		trBaseline.creation.Show = false;
		trBaseline.refer.Show = false;
	}

	return true;
}

///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA
static	void	_check_update_existing_dataset(TreeNode& trDataset)
{
	string	strData;
	trDataset.GetAttribute(STR_DATA_ATTRIB, strData);
	int		nType = okutil_cvt_str_to_predefined_type(strData);
	if ( PDS_OPTIONAL == nType || PDS_UNASSIGNED == nType )
	{
		strData.Empty();
		GraphLayer	gl = Project.ActiveLayer();
		foreach ( DataPlot dp in gl.DataPlots )
		{
			XYRange		xy;
			if ( !dp.GetDataRange(xy) || !xy )
				continue;

			Column	colY;
			if ( !xy.GetYColumn(colY) || !colY )
				continue;

			if ( !is_dataobj_tagged(colY, STR_DATASETOBJ_PICK_PEAK) && !is_dataobj_tagged(colY, STR_DATASETOBJ_SOURCE_CURVE) )
			{
				if ( !strData.IsEmpty() )	/// more than 1
				{
					strData.Empty();
					break;
				}
				dp.GetRangeString(strData, NTYPE_FOR_RANGE);
			}
		}

		if ( !strData.IsEmpty() )
		{
			trDataset.SetAttribute(STR_DATA_ATTRIB, strData);
			okutil_getn_update_ranges(&trDataset);
		}
	}
}
///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA

static bool _on_update_gui_baseline_mode(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trBaseline = tree_get_node_by_tagname(tr, "baseline", true);
	bool bMinMax = PEAK_BASELINE_MODE_USE_MINMAX==trBaseline.mode.nVal;
	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	trBaseline.Range.Show = PEAK_BASELINE_MODE_NONE != trBaseline.mode.nVal;
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE
	
	trBaseline.dataset.Show = PEAK_BASELINE_MODE_USE_EXISTING_DATASET==trBaseline.mode.nVal;
	///------ Folger 12/08/2010 ORG-1675-S1 SMARTLY_AUTO_PICKUP_BASELINE_DATA
	if ( trBaseline.dataset.Show )
	{
		_check_update_existing_dataset(trBaseline.dataset);
	}
	///------ End SMARTLY_AUTO_PICKUP_BASELINE_DATA
	
	bool bConstant = PEAK_BASELINE_MODE_CONSTANT==trBaseline.mode.nVal;
	trBaseline.constant.Show = bConstant;
	trBaseline.ybase.Show = bConstant && PEAK_BASELINE_CONST_CUSTOM==trBaseline.constant.nVal;

	bool bAuto = PEAK_BASELINE_MODE_AUTO==trBaseline.mode.nVal;
	///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
	trBaseline.SmoothMethodBranch.Show = 		
	trBaseline.SmoothMethodBranch.SmoothMethod.Show = 
	trBaseline.SmoothMethodBranch.WindowSize.Show = 
	trBaseline.SmoothMethodBranch.Threshold.Show = 
	trBaseline.SmoothMethodBranch.PolyOrder.Show = 
	///End IMPROVE_BASELINE_DETECTION
	//trBaseline.snap.Show =			///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
	trBaseline.npoints.Show =
	trBaseline.connect.Show = bAuto;

	///------ Folger 12/08/2010 ORG-1675-S2 BETTER_HINT_FOR_BASELINE_MODE
	trBaseline.HintMinMax.Show = bMinMax;
	///------ End BETTER_HINT_FOR_BASELINE_MODE
	
	///Jasmine 12/06/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	bool bEndPoint = PEAK_BASELINE_MODE_END_POINT_WEIGHTED == trBaseline.mode.nVal;	
	trBaseline.EndPoints.Show = bEndPoint;
	///End ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	///------ Folger 12/08/2010 ORG-1675-S2 BETTER_HINT_FOR_BASELINE_MODE
	trBaseline.HintEndPoints.Show = bEndPoint;
	///------ End BETTER_HINT_FOR_BASELINE_MODE
	
	///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
	_on_update_gui_baseline_smooth_method(tr, nRow, nCol, trNode, dwCntrl, nType, theDlg);
	///End IMPROVE_BASELINE_DETECTION

	_show_hide_baseline_creation_refer_data(trBaseline);

	return true;
}

static bool _on_update_gui_baseline_const(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trBaseline = tree_get_node_by_tagname(tr, "baseline", true);
	_show_hide_baseline_creation_refer_data(trBaseline);
	trBaseline.ybase.Show = PEAK_BASELINE_MODE_CONSTANT==trBaseline.mode.nVal && PEAK_BASELINE_CONST_CUSTOM==trBaseline.constant.nVal;

	return true;
}

static bool _on_update_gui_baseline_creation(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trBaseline = tree_get_node_by_tagname(tr, "baseline", true);
	_show_hide_baseline_creation_refer_data(trBaseline);

	return true;
}

///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
static bool _on_update_gui_baseline_smooth_method(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trBaseline = tree_get_node_by_tagname(tr, "baseline", true);
	bool bAuto = PEAK_BASELINE_MODE_AUTO==trBaseline.mode.nVal;
	if(bAuto)
	{
		trBaseline.SmoothMethodBranch.PolyOrder.Show = (0 != trBaseline.SmoothMethodBranch.SmoothMethod.nVal);
	}
	return true;
}
///End IMPROVE_BASELINE_DETECTION

///Sophy 3/5/2011 ORG-2351-P1 CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
bool	quick_peaks_error_check(TreeNode& trGetN, string& strErrMsg, bool bShowError/* = false*/)
{
	TreeNode trSettings = tree_get_node_by_tagname(trGetN, "settings", true);
	if( !trSettings )
		return false;
	if ( !is_find_peak_method_available(trSettings.method.nVal) )
	{
		string strProOption = get_selected_string_from_combolist(trSettings.method);
		if ( bShowError )
		{
			warning_msg_box(XFERR_PRO_OPTION_WARNNING_MSG, strProOption, false, 'W');
			trSettings.method.nVal = PEAK_FINDING_METHOD_MAX;
		}
		else
		{
			strErrMsg = XFERR_PRO_OPTION_WARNNING_MSG;
			strErrMsg += ":" + strProOption;
		}
		return false;
	}
	return true;
}

static	bool	_is_event_from_preference_dlg(TreeNode& tr)
{
	return roi_is_event_from_preference_dlg(tr);
}
///end CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST


static bool _on_update_gui_peak_finding_method(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trSettings = tree_get_node_by_tagname(tr, "settings", true);
	if( !trSettings )
		return false;
	///Sophy 3/5/2011 ORG-2351-P1 CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
	string strErrMsg;
	BOOL bFromPreference = _is_event_from_preference_dlg(tr);
	quick_peaks_error_check(tr, strErrMsg, bFromPreference);
	///end CENTRALIZE_QUICK_PEAKS_FINDING_PEAKS_METHOD_COMBO_LIST
	bool bShowPts = PEAK_FINDING_METHOD_MAX == trSettings.method.nVal;
	trSettings.npts.Show = bShowPts;

	bool bShowWinParams = PEAK_FINDING_METHOD_WIN == trSettings.method.nVal;
	trSettings.option.Show = bShowWinParams;
	trSettings.height.Show = bShowWinParams;
	trSettings.width.Show = bShowWinParams;

	bool bShowDerivParams = !(bShowPts || bShowWinParams);
	trSettings.deriv_smooth.Show = bShowDerivParams;
	if( bShowDerivParams )
		_update_gui_deriv_smooth(trSettings);

	return true;
}

///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
//static void _update_size_option_height_width(int nSzOption, TreeNode& trHeight = NULL, TreeNode& trWidth = NULL)
static void _update_size_option_height_width(int nSzOption, bool bHasBaseline, double dRectFrom, double dRectTo, TreeNode& trHeight = NULL, TreeNode& trWidth = NULL)
///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK
{
	///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
//	if( trHeight && 1==octree_get_auto_support(&trHeight) )
//	{
//		trHeight.dVal = SIZE_OPTION_RAW_SIZE == nSzOption ? NANUM : 20;
//	}
//	if( trWidth && 1==octree_get_auto_support(&trWidth) )
//	{
//		trWidth.dVal = SIZE_OPTION_RAW_SIZE == nSzOption ? NANUM : 50;
//	}
	bool bHeightAuto = trHeight && 1==octree_get_auto_support(&trHeight);
	bool bWidthAuto = trWidth && 1==octree_get_auto_support(&trWidth);
	bool bRawSize = SIZE_OPTION_RAW_SIZE == nSzOption;

	vector vxSrc, vySrc;
	if( bRawSize && (bHeightAuto || bWidthAuto) )
	{
		_get_current_source_data(vxSrc, vySrc, dRectFrom, dRectTo);
	}

	if( bHeightAuto )
	{
		double dHeight = NANUM;
		if( bRawSize )
			dHeight = 0.2 * _get_total_height(vySrc, bHasBaseline);
		else
			dHeight = 20;

		trHeight.dVal = dHeight;
	}
	if( bWidthAuto )
	{
		double dWidth = NANUM;
		if( bRawSize )
			dWidth = 0.5 * _get_total_width(vxSrc);
		else
			dWidth = 50;

		trWidth.dVal = dWidth;
	}
	///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

}

///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
static void _get_gui_baseline_xscale_setting(TreeNode& tr, bool& bHasBaseline, double& dFrom, double& dTo)
{
	dFrom = dTo = NANUM;

	TreeNode trBaseline = tree_get_node_by_tagname(tr, "baseline", true);
	if(trBaseline)
		bHasBaseline = PEAK_BASELINE_MODE_USE_MINMAX != trBaseline.mode.nVal;

	TreeNode trXScale = tree_get_node_by_tagname(tr, "XScale", true);
	if( trXScale )
	{
		dFrom = atof(trXScale.leftx.strVal);
		dTo = atof(trXScale.rightx.strVal);
	}
}
///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

static bool _on_update_gui_size_option(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trOption = tree_get_node_by_tagname(tr, "option", true);
	if( !trOption )
		return false;
	///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
	bool bHasBaseline;
	double dRectFrom, dRectTo;
	_get_gui_baseline_xscale_setting(tr, bHasBaseline, dRectFrom, dRectTo);
	///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

	TreeNode trHeight = tree_get_node_by_tagname(tr, "height", true);
	TreeNode trWidth = tree_get_node_by_tagname(tr, "width", true);
	///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
	//_update_size_option_height_width(trOption.nVal, trHeight, trWidth);
	_update_size_option_height_width(trOption.nVal, bHasBaseline, dRectFrom, dRectTo, trHeight, trWidth);
	///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

	return true;
}

static bool _on_update_gui_height(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trOption = tree_get_node_by_tagname(tr, "option", true);
	TreeNode trHeight = tree_get_node_by_tagname(tr, "height", true);

	///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
	//_update_size_option_height_width(trOption.nVal, trHeight);
	bool bHasBaseline;
	double dRectFrom, dRectTo;
	_get_gui_baseline_xscale_setting(tr, bHasBaseline, dRectFrom, dRectTo);
	_update_size_option_height_width(trOption.nVal, bHasBaseline, dRectFrom, dRectTo, trHeight);
	///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

	return true;
}

static bool _on_update_gui_width(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trOption = tree_get_node_by_tagname(tr, "option", true);
	TreeNode trWidth = tree_get_node_by_tagname(tr, "width", true);
	///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
	//_update_size_option_height_width(trOption.nVal, NULL, trWidth);
	bool bHasBaseline;
	double dRectFrom, dRectTo;
	_get_gui_baseline_xscale_setting(tr, bHasBaseline, dRectFrom, dRectTo);
	_update_size_option_height_width(trOption.nVal, bHasBaseline, dRectFrom, dRectTo, NULL, trWidth);
	///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK

	return true;
}

static bool _on_update_gui_deriv_smooth(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trSettings = tree_get_node_by_tagname(tr, "settings", true);
	
	bool bShowPts = PEAK_FINDING_METHOD_MAX == trSettings.method.nVal;
	bool bShowWinParams = PEAK_FINDING_METHOD_WIN == trSettings.method.nVal;
	bool bShowDerivParams = !(bShowPts || bShowWinParams);
	trSettings.deriv_smooth.Show = bShowDerivParams;
	if( bShowDerivParams )
		_update_gui_deriv_smooth(trSettings);
	
	return true;
}

static bool _on_update_gui_filter_params_status(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trFilter = tree_get_node_by_tagname(tr, "filter", true);
	
	trFilter.val_height.Show = PEAK_FILTER_HEIGHT == trFilter.method.nVal;
	trFilter.val_num.Show = PEAK_FILTER_NUM == trFilter.method.nVal;

	return true;
}

static bool _on_update_gui_filter_value(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if( 1 == octree_get_auto_support(&trNode) )
	{
		if ( trNode.tagName.Compare("val_height") == 0 )
		{
			trNode.dVal = 20;
		}
		else if ( trNode.tagName.Compare("val_num") == 0 )
		{
			///Kyle 12/07/2010 ORG-1662-P1 PROPER_AUTO_VALUES_FOR_FINDING_PEAK
			//trNode.dVal = NANUM;
			bool bHasBaseline;
			double dRectFrom, dRectTo;
			_get_gui_baseline_xscale_setting(tr, bHasBaseline, dRectFrom, dRectTo);

			vector vxSrc, vySrc;
			_get_current_source_data(vxSrc, vySrc, dRectFrom, dRectTo);
			double dAutoHeightThres = 0.2 * _get_total_height(vySrc, bHasBaseline);

			int iPeakNum = 1;
			compute_peaks_number_by_filter_height(vxSrc, vySrc, dAutoHeightThres, iPeakNum);
			trNode.dVal = iPeakNum;
			///End PROPER_AUTO_VALUES_FOR_FINDING_PEAK
		}
		else
		{
			ASSERT(FALSE);
		}
		
		return true;
	}

	return false;
}

static bool _on_update_gui_show_label(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode	trPeakMarkerColor = tree_get_node_by_tagname(tr, "PeakMarkerColor", true);
	BOOL		bPeakMarkerColorNone = INDEX_COLOR_TRANSPARENT == trPeakMarkerColor.nVal;

	TreeNode trShowLabel = tree_get_node_by_tagname(tr, "sl", true);
	TreeNode trCenterLabel = tree_get_node_by_tagname(tr, "lc", true);
	TreeNode trRotateLabel = tree_get_node_by_tagname(tr, "lr", true);
	TreeNode trLabelColor = tree_get_node_by_tagname(tr, "labelcolor", true);

	trShowLabel.Show = !bPeakMarkerColorNone;
	BOOL	bShow = trShowLabel.Show && trShowLabel.nVal;
	trRotateLabel.Show = bShow;
	trLabelColor.Show = bShow;
	return true;
}
///Jasmine 12/09/10 ORG-1697-S2 ADD_MORE_SETTINGS_FOR_OUTPUT
static bool _on_check_output_result(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trOutputResult = tree_get_node_by_tagname(tr, "AppendtoWorksheet", true);
	TreeNode trResultSheet = tree_get_node_by_tagname(tr, "output", true);
	trResultSheet.Show = (trOutputResult.nVal);
	
	return true
}
static bool _on_check_output_baseline(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trOutputResult = tree_get_node_by_tagname(tr, "OutputBaseline", true);
	TreeNode trResultSheet = tree_get_node_by_tagname(tr, "BaselineWorksheetName", true);
	trResultSheet.Show = (trOutputResult.nVal);
	
	return true
}
///End ADD_MORE_SETTINGS_FOR_OUTPUT
static bool	_peak_gadget_baseline_subtracted_status(DataPlot& dp, bool& bSubtracted, bool bGet = true)
{
#define STR_PICK_PEAK_BASELINE_SUBTRACTED_BINARY_NAME		"BLSubtracted"

	if( !dp )
		return false;
	Tree tr;
	if( bGet )
	{
		bSubtracted = false;
		if( dp.GetBinaryStorage(STR_PICK_PEAK_BASELINE_SUBTRACTED_BINARY_NAME, tr) && tr.Subtracted )
			bSubtracted = tr.Subtracted.nVal;
	}
	else
	{
		if( bSubtracted )
		{
			tr.Subtracted.nVal = bSubtracted;
			dp.PutBinaryStorage(STR_PICK_PEAK_BASELINE_SUBTRACTED_BINARY_NAME, tr);
		}
		else
		{
			dp.SetMemory(STR_PICK_PEAK_BASELINE_SUBTRACTED_BINARY_NAME, NULL);
		}
	}

	return true;
}

static bool _check_if_baseline_setting_changed(const TreeNode& trBaseline1, const TreeNode& trBaseline2)
{
	if( !(trBaseline1 && trBaseline2) )
	{
		ASSERT(false);
		return false;
	}
	ASSERT( baseline_creation_multi_sel_attrib_access(trBaseline1) == baseline_creation_multi_sel_attrib_access(trBaseline2) );
	
	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	if( trBaseline1.Range.nVal != trBaseline2.Range.nVal )
		return true;
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE
	
	if( trBaseline1.mode.nVal != trBaseline2.mode.nVal )
		return true;

	bool bDiff = false;
	switch( trBaseline1.mode.nVal )
	{
	case PEAK_BASELINE_MODE_USE_EXISTING_DATASET:
		bDiff = _is_xy_range_diff(trBaseline1.dataset, trBaseline2.dataset, true, true);
		break;

	case PEAK_BASELINE_MODE_CONSTANT:
		bDiff = (trBaseline1.constant.nVal != trBaseline2.constant.nVal );
		if( !bDiff )
		{
			if( PEAK_BASELINE_CONST_CUSTOM == trBaseline1.constant.nVal )
			{
				bDiff = !is_equal(trBaseline1.ybase.dVal, trBaseline2.ybase.dVal);
			}
			else if( baseline_creation_multi_sel_attrib_access(trBaseline1) )
			{
				bDiff = (trBaseline1.creation.nVal!=trBaseline2.creation.nVal) || (PEAK_BASELINE_CREATION_GLOBAL==trBaseline1.creation.nVal && _is_xy_range_diff(trBaseline1.refer, trBaseline2.refer, true));
			}
		}
		break;
		
	case PEAK_BASELINE_MODE_AUTO:
		///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
		///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
		//bDiff = (trBaseline1.snap.nVal != trBaseline2.snap.nVal || trBaseline1.npoints.nVal != trBaseline2.npoints.nVal || trBaseline1.connect.nVal != trBaseline2.connect.nVal
		bDiff = (trBaseline1.npoints.nVal != trBaseline2.npoints.nVal || trBaseline1.connect.nVal != trBaseline2.connect.nVal
		///End REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
				|| trBaseline1.SmoothMethodBranch.SmoothMethod.nVal != trBaseline2.SmoothMethodBranch.SmoothMethod.nVal
				|| trBaseline1.SmoothMethodBranch.WindowSize.nVal != trBaseline2.SmoothMethodBranch.WindowSize.nVal
				|| trBaseline1.SmoothMethodBranch.Threshold.nVal != trBaseline2.SmoothMethodBranch.Threshold.nVal);
		if(!bDiff && trBaseline1.SmoothMethodBranch.SmoothMethod.nVal)
			bDiff = (trBaseline1.SmoothMethodBranch.PolyOrder.nVal != trBaseline2.SmoothMethodBranch.PolyOrder.nVal);		
		///End IMPROVE_BASELINE_DETECTION
		if( !bDiff && baseline_creation_multi_sel_attrib_access(trBaseline1) )
		{
			bDiff = (trBaseline1.creation.nVal!=trBaseline2.creation.nVal) || (PEAK_BASELINE_CREATION_GLOBAL==trBaseline1.creation.nVal && _is_xy_range_diff(trBaseline1.refer, trBaseline2.refer, true, true));
		}
		break;
	///Jasmine 11/30/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	case PEAK_BASELINE_MODE_END_POINT_WEIGHTED:
		bDiff = (trBaseline1.EndPoints.dVal != trBaseline2.EndPoints.dVal);		
		break;
	///End ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
	}

	return bDiff;
}

static bool _is_xy_range_diff(const TreeNode& trRng1, const TreeNode& trRng2, bool bCompareY = false, bool bCompareX = false)
{
	XYRange xy1, xy2;
	bool bValid1 = xy_range_from_GetN_data_node(trRng1, xy1);
	bool bValid2 = xy_range_from_GetN_data_node(trRng2, xy2);
	if( bValid1 != bValid2 )
		return true;
	if( !bValid1 )
		return false;

	DWORD wResults;
	if( bCompareX )
	{
		if( !(xy1.IsIntersect(xy2, "X", "X", &wResults) && RNGINTSCT_FULL==wResults) )
			return true;
	}
	if( bCompareY )
	{
		if( !(xy1.IsIntersect(xy2, "Y", "Y", &wResults) && RNGINTSCT_FULL==wResults) )
			return true;
	}

	return false;
}

static void _init_baseline_info(BaselineInfo& blInfo)
{
	blInfo.m_nMode = PEAK_BASELINE_MODE_USE_MINMAX;
	blInfo.m_strRefer = "";
}

static bool _intersect_baseline_refer_data(vector& vxRefer, vector& vyRefer, double dROIFrom, double dROITo, double dLayFrom, double dLayTo)
{
	if( vxRefer.GetSize() < 1 || vxRefer.GetSize() != vyRefer.GetSize() )
		return false;

	if( dROIFrom < dLayFrom )
		dROIFrom = dLayFrom;
	if( dROITo > dLayTo )
		dROITo = dLayTo;

	vector<uint> vIndex;

	vxRefer.Find(MATREPL_TEST_LESSTHAN, dROIFrom, vIndex);
	if( vIndex.GetSize() > 0 )
	{
		vector<int> vec;
		vec = vIndex;

		vxRefer.RemoveAt(vec);
		vyRefer.RemoveAt(vec);
	}

	vxRefer.Find(MATREPL_TEST_GREATER, dROITo, vIndex);
	if( vIndex.GetSize() > 0 )
	{
		vector<int> vec;
		vec = vIndex;

		vxRefer.RemoveAt(vec);
		vyRefer.RemoveAt(vec);
	}
	ASSERT( vxRefer.GetSize() == vyRefer.GetSize() );

	return vxRefer.GetSize() > 0;
}

static void _swap(double& d1, double& d2)
{
	double dT = d1;
	d1 = d2;
	d2 = dT;
}

static bool	_create_baseline(	const TreeNode& trBaseline, vector& vxb, vector& vyb, bool& bGlobalGL, double dROIFrom, double dROITo,
								double dLayFrom, double dLayTo, bool bMultiSel = true, const DataPlot& dpSrc = NULL,
								BaselineInfo* pBLInfo = NULL
								///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
								, BOOL bLocalBaseline = TRUE
								///------ End CREATE_BASELINE_USING_WHOLE_CURVE
								)
{
	vxb.SetSize(0);
	vyb.SetSize(0);

	if( !trBaseline )
		return false;
	if( !bMultiSel && !dpSrc)
		return false;

	XYRange xySrc;
	if( dpSrc )
		dpSrc.GetDataRange(xySrc);

	if( dLayFrom > dLayTo )
		_swap(dLayFrom, dLayTo);
	if( dROIFrom > dROITo )
		_swap(dROIFrom, dROITo);

	///------ Folger 12/08/2010 ORG-1675-S6 CREATE_BASELINE_USING_WHOLE_CURVE
	//bool bLocalBaseline = true;			// for now always use local baseline for constant and auto mode
	///------ End CREATE_BASELINE_USING_WHOLE_CURVE

	bGlobalGL = bMultiSel;

	if( pBLInfo )
	{
		_init_baseline_info(*pBLInfo);
		pBLInfo->m_nMode = trBaseline.mode.nVal;
	}

	switch(trBaseline.mode.nVal)
	{
	case PEAK_BASELINE_MODE_USE_MINMAX:
		{
			// do nothing
		}
		break;

	case PEAK_BASELINE_MODE_USE_EXISTING_DATASET:
		{
			XYRange xyExisting;
			if( !xy_range_from_GetN_data_node(trBaseline.dataset, xyExisting) )
				return false;
			if( !xyExisting.GetData(vyb, vxb) )
				return false;

			if( pBLInfo )
				pBLInfo->m_strRefer = xyExisting.GetDescription(GETLC_NO_DESIGNATIONS | GETLC_NO_ROWS);
		}
		break;

	case PEAK_BASELINE_MODE_CONSTANT:
			if( pBLInfo )
				pBLInfo->m_nConstant = trBaseline.constant.nVal;
	///------ Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
	case PEAK_BASELINE_MODE_NONE:
	///------ End ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
		{
			double dXFrom, dXTo;
			double dYBase = NANUM;

			///------ Folger 12/06/2010 ORG-1551-S8 ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
			if ( PEAK_BASELINE_MODE_NONE == trBaseline.mode.nVal )
			{
				dYBase = 0;
				dXFrom = max(dLayFrom, dROIFrom);
				dXTo = min(dLayTo, dROITo);
			}
			else
			///------ End ADD_BACK_NONE_BASELINE_OPTION_AS_Y_EQUAL_ZERO
			if( PEAK_BASELINE_CONST_CUSTOM == trBaseline.constant.nVal )
			{
				dYBase = trBaseline.ybase.dVal;
				if( pBLInfo )
					pBLInfo->m_dCustom = dYBase;
				if ( bLocalBaseline ) 
				{
					dXFrom = max(dLayFrom, dROIFrom);
					dXTo = min(dLayTo, dROITo);
				}
				else
				{
					dXFrom = dLayFrom;
					dXTo = dLayTo;
				}
			}
			else
			{
				vector vxRefer, vyRefer;
				if( bMultiSel && PEAK_BASELINE_CREATION_GLOBAL==trBaseline.creation.nVal )
				{
					bLocalBaseline = false;			// for now always use local baseline for constant and auto mode

					XYRange xyRefer;
					if( !xy_range_from_GetN_data_node(trBaseline.refer, xyRefer) || !xyRefer.GetData(vyRefer, vxRefer) )
						return false;
					
					if( pBLInfo )
						pBLInfo->m_strRefer = xyRefer.GetDescription(GETLC_NO_DESIGNATIONS | GETLC_NO_ROWS);
				}
				else
				{
					bGlobalGL = false;
					if( !xySrc || !xySrc.GetData(vyRefer, vxRefer) )
						return false;
				}

				if( bLocalBaseline )
				{
					if( !_intersect_baseline_refer_data(vxRefer, vyRefer, dROIFrom, dROITo, dLayFrom, dLayTo) )
						return false;
					dXFrom = max(dLayFrom, dROIFrom);
					dXTo = min(dLayTo, dROITo);
				}
				else
				{
					dXFrom = dLayFrom;
					dXTo = dLayTo, dROITo;
				}

				double dMin, dMax, dSum, dMedian;
				switch(trBaseline.constant.nVal)
				{
				case PEAK_BASELINE_CONST_MIN:
				case PEAK_BASELINE_CONST_MAX:
					vyRefer.GetMinMax(dMin, dMax);
					dYBase = PEAK_BASELINE_CONST_MIN == trBaseline.constant.nVal ? dMin : dMax;
					break;

				case PEAK_BASELINE_CONST_MEAN:
					if( 0 != vyRefer.Sum(dSum) )
						return false;
					dYBase = dSum / vyRefer.GetSize();
					break;

				case PEAK_BASELINE_CONST_MEDIAN:
					if( OE_NOERROR != ocmath_get_median_in_vector(vxRefer.GetSize(), vyRefer, &dMedian) )
						return false;
					dYBase = dMedian;
					break;
				}
			}

			vyb.SetSize(2);
			vyb = dYBase;

			vxb.SetSize(2);
			vxb[0] = dXFrom;
			vxb[1] = dXTo;
		}
		break;

	case PEAK_BASELINE_MODE_AUTO:
	case PEAK_BASELINE_MODE_END_POINT_WEIGHTED:
		{
			vector vxRefer, vyRefer;
			vector vxAnchor, vyAnchor;
			if( bMultiSel && PEAK_BASELINE_CREATION_GLOBAL==trBaseline.creation.nVal )
			{
				bLocalBaseline = false;

				XYRange xyRefer;
				if( !(xy_range_from_GetN_data_node(trBaseline.refer, xyRefer) &&xyRefer.GetData(vyRefer, vxRefer)) )
					return false;

				if( pBLInfo )
					pBLInfo->m_strRefer = xyRefer.GetDescription(GETLC_NO_DESIGNATIONS | GETLC_NO_ROWS);
			}
			else
			{
				bGlobalGL = false;
				if( !xySrc || !xySrc.GetData(vyRefer, vxRefer) )
					return false;
			}

			if( bLocalBaseline )
			{
				if( !_intersect_baseline_refer_data(vxRefer, vyRefer, dROIFrom, dROITo, dLayFrom, dLayTo) )
					return false;
			}

			///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
			if(PEAK_BASELINE_MODE_AUTO == trBaseline.mode.nVal)
			{
				//if( !auto_find_baseline_anchor_points(vxRefer, vyRefer, vxAnchor, vyAnchor, trBaseline.npoints.nVal) )
				bool bRet = auto_find_baseline_anchor_points(vxRefer, vyRefer, vxAnchor, vyAnchor, trBaseline.npoints.nVal,
															trBaseline.SmoothMethodBranch.SmoothMethod.nVal,
															trBaseline.SmoothMethodBranch.WindowSize.nVal, 
															trBaseline.SmoothMethodBranch.PolyOrder.nVal,
															trBaseline.SmoothMethodBranch.Threshold.dVal); 
															
				if(!bRet)
				///End IMPROVE_BASELINE_DETECTION										
					return false;
				///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
				//if( trBaseline.snap.nVal )
				//	snap_points_to_source_data(vxRefer, vyRefer, vxAnchor, vyAnchor);
				snap_points_to_source_data(vxRefer, vyRefer, vxAnchor, vyAnchor);
				///End REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
				int nRet = interpolate_baseline_base_on_data(vxAnchor, vyAnchor, vxRefer, vyRefer, vxRefer.GetSize(), trBaseline.connect.nVal);
				if(OE_NOERROR != nRet)
					return false;
	
				vxb = vxAnchor;
				vyb = vyAnchor;
	
				if( pBLInfo )
				{
					///Jasmine 11/30/10 ORG-239 IMPROVE_BASELINE_DETECTION
					pBLInfo->m_nSmoothMethod = trBaseline.SmoothMethodBranch.SmoothMethod.nVal;
					pBLInfo->m_nWindowSize = trBaseline.SmoothMethodBranch.WindowSize.nVal;
					pBLInfo->m_dThreshold = trBaseline.SmoothMethodBranch.Threshold.dVal;
					pBLInfo->m_nPolyOrder = trBaseline.SmoothMethodBranch.PolyOrder.nVal;
					///End IMPROVE_BASELINE_DETECTION
					pBLInfo->m_nAnchor = trBaseline.npoints.nVal;
					//pBLInfo->m_bSnap = trBaseline.snap.nVal;			///Kyle 12/07/2010 ORG-239-P1 REMOVE_SNAP_ANCHOR_POINTS_TO_SPECTRUM
					pBLInfo->m_nConnect = trBaseline.connect.nVal;
				}
			}
			///Jasmine 11/30/10 ORG-239-S2 ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
			else
			{
				ASSERT(PEAK_BASELINE_MODE_END_POINT_WEIGHTED == trBaseline.mode.nVal);
				bool bRet = find_baseline_by_end_points_weighted(vxRefer, vyRefer, vxAnchor, vyAnchor, trBaseline.EndPoints.dVal * 0.01);
				if(!bRet)
					return false;
				
				vxb = vxAnchor;
				vyb = vyAnchor;
				
				if( pBLInfo )
				{
					pBLInfo->m_dEndPoints	= trBaseline.EndPoints.dVal;
				}
			}
			///End ADD_END_POINTS_WEIGHTED_FOR_BASELINE_FINDING
		}
		break;

	default:
		return false;
	}

	return true;
}

static	void	_add_reference_data(TreeNode& trBaseline, LPCSTR lpcsz)
{
	trBaseline.ReferenceData.strVal = lpcsz;
	trBaseline.ReferenceData.SetAttribute(STR_LABEL_ATTRIB, "Reference Data");
}

///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
//static bool _info_2_text(string& strText, const BaselineInfo& blInfo, const vector& vxBaseline, const vector& vyBaseline, FINDPEAKMOREINFO*	lpstMoreInfo = NULL)
static bool _info_2_text(string& strText, const BaselineInfo& blInfo, const vector<string>& vxBaseline, const vector<string>& vyBaseline, FINDPEAKMOREINFO*	lpstMoreInfo = NULL)
///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT{
{
	Tree		trInfo;
	LPCSTR		lpcszBaseline = "Baseline";
	TreeNode	trBaseline = trInfo.AddNode(lpcszBaseline);
	trBaseline.SetAttribute(STR_LABEL_ATTRIB, GetLocalized(lpcszBaseline));

	LPCSTR		lpcszMode = "Mode";
	TreeNode	trMode = trBaseline.AddNode(lpcszMode);
	trMode.SetAttribute(STR_LABEL_ATTRIB, GetLocalized(lpcszMode));

	bool bAppendData = true;
	switch( blInfo.m_nMode )
	{
	case PEAK_BASELINE_MODE_USE_MINMAX:
		trMode.strVal = "Min&Max";
		bAppendData = false;
		break;

	case PEAK_BASELINE_MODE_USE_EXISTING_DATASET:
		trMode.strVal = "Use Existing Dataset";
		trBaseline.ReferenceDataset.strVal = blInfo.m_strRefer;
		trBaseline.ReferenceDataset.SetAttribute(STR_LABEL_ATTRIB, _L("Reference Dataset"));
		break;
		
	case PEAK_BASELINE_MODE_CONSTANT:
		{
			trMode.strVal = "Const";
			LPCSTR		lpcszConstant = "Constant";
			TreeNode	trConstant = trBaseline.AddNode(lpcszConstant);
			trConstant.SetAttribute(STR_LABEL_ATTRIB, lpcszConstant);

			bool bUseRefer = true;
			switch( blInfo.m_nConstant )
			{
			case PEAK_BASELINE_CONST_MIN:
				trConstant.strVal = "Min";
				break;

			case PEAK_BASELINE_CONST_MAX:
				trConstant.strVal = "Max";
				break;

			case PEAK_BASELINE_CONST_MEAN:
				trConstant.strVal = "Mean";
				break;

			case PEAK_BASELINE_CONST_MEDIAN:
				trConstant.strVal = "Median";
				break;
				
			case PEAK_BASELINE_CONST_CUSTOM:
				trConstant.strVal = "Custom";
				trBaseline.Base.strVal = ftoa(blInfo.m_dCustom);
				trBaseline.Base.SetAttribute(STR_LABEL_ATTRIB, _L("Base"));
				bUseRefer = false;
				break;
				
			default:
				ASSERT(0);
				return false;
			}

			if( bUseRefer && !blInfo.m_strRefer.IsEmpty() )
			{
				_add_reference_data(trBaseline, blInfo.m_strRefer);
			}
		}
		break;
		

	case PEAK_BASELINE_MODE_AUTO:
		{
			trMode.strVal = "2nd Derivative";
			if( !blInfo.m_strRefer.IsEmpty() )
				_add_reference_data(trBaseline, blInfo.m_strRefer);

			trBaseline.SmoothingMethod.strVal = STR_PICKPEAK_BASELINE_SMOOTHMETHOD_LIST.GetToken(blInfo.m_nSmoothMethod, '|');
			trBaseline.SmoothingMethod.SetAttribute(STR_LABEL_ATTRIB, STR_PICKPEAK_BASELINE_SMOOTHMETHOD);
			trBaseline.WindowSize.strVal = (string)blInfo.m_nWindowSize;
			trBaseline.WindowSize.SetAttribute(STR_LABEL_ATTRIB, STR_PICKPEAK_BASELINE_WINDOWSIZE);
			trBaseline.Threshold.strVal = ftoa(blInfo.m_dThreshold);
			trBaseline.Threshold.SetAttribute(STR_LABEL_ATTRIB, STR_PICKPEAK_BASELINE_THRESHOLD);
			if ( AUTO_FIND_BASELINE_SAVIT_GOL == blInfo.m_nSmoothMethod )
			{
				trBaseline.PolyOrder.strVal = (string)blInfo.m_nPolyOrder;
				trBaseline.PolyOrder.SetAttribute(STR_LABEL_ATTRIB, STR_PICKPEAK_BASELINE_OLYORDER);
			}
			
			trBaseline.NumberofAnchorPoints.strVal = (string)blInfo.m_nAnchor;
			trBaseline.NumberofAnchorPoints.SetAttribute(STR_LABEL_ATTRIB, _L("Number of Anchor Points"));

			TreeNode	trConnectType = trBaseline.AddNode("ConnectType");
			trConnectType.SetAttribute(STR_LABEL_ATTRIB, "Connect Type");
			switch( blInfo.m_nConnect )
			{
			case PEAK_BASELINE_CONNECT_METHOD_LINE:
				trConnectType.strVal = _L("Line");
				break;
				
			case PEAK_BASELINE_CONNECT_METHOD_SPLINE:
				trConnectType.strVal = _L("Spline");
				break;
				
			case PEAK_BASELINE_CONNECT_METHOD_BSPLINE:
				trConnectType.strVal = _L("B Spline");
				break;
				
			default:
				ASSERT(0);
				return false;
			}
		}
		break;

	case PEAK_BASELINE_MODE_END_POINT_WEIGHTED:
		trMode.strVal = _L("End Points Weighted");
		if( !blInfo.m_strRefer.IsEmpty() )
			_add_reference_data(trBaseline, blInfo.m_strRefer);
		trBaseline.EndPoints.strVal = ftoa(blInfo.m_dEndPoints);
		trBaseline.EndPoints.SetAttribute(STR_LABEL_ATTRIB, "End Points(%)");
		break;
		
	case PEAK_BASELINE_MODE_NONE:
		trMode.strVal = _L("None");
		bAppendData = false;
		break;
		
	default:
		ASSERT(0);
		return false;
	}

	if( bAppendData )
	{
		if( !(vxBaseline && vyBaseline) )
			return false;

		TreeNode	trBaselineData = trInfo.AddNode("BaselineData");
		trBaselineData.SetAttribute(STR_LABEL_ATTRIB, _L("Baseline Data"));

		///------ Folger 03/08/2011 ORG-2389-P1 QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
		//trBaselineData.X.dVals = vxBaseline;
		//trBaselineData.Y.dVals = vyBaseline;
		trBaselineData.X.strVals = vxBaseline;
		trBaselineData.Y.strVals = vyBaseline;
		///------ End QUICK_PEAK_LABELS_FAILED_TO_SHOW_DATE_TIME_FORMAT
	}
	
	okutil_convert_tree_to_ini_str(&trInfo, &strText);
	return true;
}

///------ Folger 11/29/2010 ORG-1551-S4 SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET
// static bool	_update_peaks_labels(GraphLayer gl, XYRange xyPeaksCenter,  bool bShowCenter, bool bShowLabel, int nLabelXYType = LABEL_Y_VAL_GUI, bool bRotateLabel = false, int nLabelColor = -1)
// {
// 	if( !(gl && xyPeaksCenter) )
// 		return false;
// 	
// 	DataPlot dp;
// 	get_plot_from_xyr_in_gl(gl, xyPeaksCenter, dp, IDM_PLOT_SCATTER);
// 	
// 	if( bShowCenter || bShowLabel )
// 	{
// 		if( !dp.IsValid() )
// 		{
// 			if( !(plot_xyr_to_graph(xyPeaksCenter, gl, IDM_PLOT_SCATTER, SYSCOLOR_RED, dp) && dp.IsValid()) )
// 				return false;
// 			set_dataplot_format(dp, 16, 15);
// 		}
// 		
// 		return _set_peak_center_format(dp, bShowCenter, bShowLabel, nLabelXYType, bRotateLabel, nLabelColor);
// 	}
// 	else if( dp.IsValid() )
// 	{
// 		legend_delete_plot(gl, dp.GetIndex());
// 		dp.Destroy();
// 	}
// 	
// 	return true;
// }

static	DataPlot	_update_peak_label_plot(GraphLayer& gl, XYRange& xy, int nColor, BOOL bShow)
{
	DataPlot	dp;
	get_plot_from_xyr_in_gl(gl, xy, dp, IDM_PLOT_SCATTER);

	///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
	if ( bShow )
	//if ( bShow  && INDEX_COLOR_TRANSPARENT != nColor )
	///------ End SUPPORT_PEAK_MARKER_COLOR
	{
		if ( !dp )
		{
			if( !(plot_xyr_to_graph(xy, gl, IDM_PLOT_SCATTER, nColor, dp) && dp.IsValid()) )
				return dp;
			set_dataplot_format(dp, SYMBOL_SHAPE, SYMBOL_SIZE);
		}
		///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
		if ( INDEX_COLOR_TRANSPARENT == nColor )
		{
			dp.Show = FALSE;
		}
		else
		{
			dp.Show = TRUE;
			dp.SetColor(nColor);
		}
		///------ End SUPPORT_PEAK_MARKER_COLOR
	}
	else if ( dp.IsValid() )
	{
		legend_delete_plot(gl, dp.GetIndex());
		dp.Destroy();
	}

	return dp;
}

static bool	_update_peaks_labels(GraphLayer gl, XYRange xyPeaksCenter,  bool bShowCenter, bool bShowLabel, int nLabelXYType = LABEL_Y_VAL_GUI, bool bRotateLabel = false, int nLabelColor = -1, XYRange& xyLeftBaseMarkers = NULL, XYRange& xyRightBaseMarkers = NULL, int nBaseMarkerColor = SYSCOLOR_BLUE
								 ///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
								 , int nPeakMarkerColor = SYSCOLOR_RED
								 ///------ End SUPPORT_PEAK_MARKER_COLOR
								 )
{
	if( !(gl && xyPeaksCenter) )
		return false;

	///------ Folger 12/08/2010 ORG-1675-S4 SUPPORT_PEAK_MARKER_COLOR
	//DataPlot dpLabel = _update_peak_label_plot(gl, xyPeaksCenter, SYSCOLOR_RED, bShowCenter || bShowLabel);
	DataPlot dpLabel = _update_peak_label_plot(gl, xyPeaksCenter, nPeakMarkerColor, bShowCenter || bShowLabel);
	///------ End SUPPORT_PEAK_MARKER_COLOR
	if ( dpLabel )
		_set_peak_center_format(dpLabel, bShowCenter, bShowLabel, nLabelXYType, bRotateLabel, nLabelColor);

	if ( xyLeftBaseMarkers && xyLeftBaseMarkers.IsValid() )
	{
		dpLabel = _update_peak_label_plot(gl, xyLeftBaseMarkers, nBaseMarkerColor, bShowCenter);
		///------ Folger 12/31/2010 ORG-1897-P1 REDUNDANT_LABEL_SHOW_FOR_RIGHT_BASE_MARKER
		_set_peak_center_format(dpLabel, TRUE, FALSE, nLabelXYType, bRotateLabel, nLabelColor);
		///------ End REDUNDANT_LABEL_SHOW_FOR_RIGHT_BASE_MARKER
		
	}
	if ( xyRightBaseMarkers && xyRightBaseMarkers.IsValid() )
	{
		dpLabel = _update_peak_label_plot(gl, xyRightBaseMarkers, nBaseMarkerColor, bShowCenter);
		///------ Folger 12/31/2010 ORG-1897-P1 REDUNDANT_LABEL_SHOW_FOR_RIGHT_BASE_MARKER
		_set_peak_center_format(dpLabel, TRUE, FALSE, nLabelXYType, bRotateLabel, nLabelColor);
		///------ End REDUNDANT_LABEL_SHOW_FOR_RIGHT_BASE_MARKER
	}

	return true;
}
///------ End SHOW_BASE_MARKERS_IN_PEAK_ANALYSIS_GADGET

static bool	_set_peak_center_format(DataPlot& dp, bool bShowCenter, bool bShowLabel, int nLabelXYType = LABEL_Y_VAL_GUI, bool bRotateLabel = false, int nLabelColor = -1)
{
	if( !dp.IsValid() )
		return false;

	Tree trFormat;
	trFormat.Root.Symbol.Shape.nVal = SYMBOL_SHAPE;
	trFormat.Root.Symbol.Size.dVal = bShowCenter ? SYMBOL_SIZE : 0;

	TreeNode trEnable = trFormat.Root.Label.AddNode("Enable");
	trEnable.nVal = bShowLabel;
	if( bShowLabel )
	{
		trFormat.Root.Label.Form.nVal = nLabelXYType;
		trFormat.Root.Label.Rotate.dVal = bRotateLabel ? 90 : 0;
		trFormat.Root.Label.Color.nVal = nLabelColor;
		trFormat.Root.Label.PosScatter.nVal = 3;			// above
	}

	return 0==dp.UpdateThemeIDs(trFormat.Root) && dp.ApplyFormat(trFormat, true, true);
}

/// Hong 01/07/11 ORG-1944 QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH
/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
//bool _updateMarkerValues(GraphObject& go, vector<int>& vnIndices, bool bRemoveDuplicate = false)
bool _updateMarkerValues(GraphObject& go, vector<int>& vnIndices, bool bRemoveDuplicate = false, vector& vPeakHeight = NULL, bool bRotateLabel = true)
/// end PEAK_MARKER_BE_POSITION_SENSITIVE
{
	if ( !go )
		return false;
	
	vector<int> 	vnIdx;
	/// Hong 01/30/11 ORG-2067-P4 PEAK_MARKER_BE_POSITION_SENSITIVE
	/*
	vnIdx = vnIndices;
	if ( bRemoveDuplicate )
	{
		Tree			trFmt;
		trFmt = go.GetFormat(FPB_DATA, FOB_ALL, TRUE, TRUE);
		vnIdx.Append(trFmt.Root.Data.X.dVals);
		
		vector<int>		vnMapIndices;
		vector<uint>	vnR1s;
		vector<string>	vstrIndices;
		convert_int_vector_to_string_vector(vnIdx, vstrIndices);
		vstrIndices.FindDuplicates(vnMapIndices, vnR1s);
		for ( int ii = vnIdx.GetSize() - 1; ii >= 0; ii-- )
		{
			int			nGroupIndex = vnMapIndices[ii];
			if ( -1 != nGroupIndex && ii != vnR1s[nGroupIndex] )
				vnIdx.RemoveAt(ii);
		}
	}

	Tree		tr;
	tr.Root.Data.X.dVals = vnIdx;
	tr.Root.Data.Y.dVals = vnIdx;
	*/
	const DWORD			dwMirror = bRotateLabel ? MLCM_MIRROR_Y_OFFSET | MLCM_MIRROR_JUSTIFY_HORZ : MLCM_MIRROR_Y_OFFSET | MLCM_MIRROR_JUSTIFY_VERT;
	Tree				tr;
	int					nOldCount = 0;
	if ( !bRemoveDuplicate )
		vnIdx = vnIndices;
	else
	{
		///Sophy 1/19/2012 ORG-4901-P1 PROPER_GET_THEME_SETTINGS_FOR_MODIFY_MARKER_POINTS
		//tr = go.GetFormat(FPB_DATA, FOB_ALL, TRUE, TRUE);
		tr = go.GetFormat(FPB_DATA | FPB_OTHER, FOB_ALL, TRUE, TRUE);
		///end PROPER_GET_THEME_SETTINGS_FOR_MODIFY_MARKER_POINTS
		vnIdx = tr.Root.Data.X.dVals;
		nOldCount = vnIdx.GetSize();
		vnIdx.Append(vnIndices);
		
	#ifdef		_BEGUG
		int				nExistingCount = nOldCount;
	#endif		//_BEGUG
	
		TreeNode		trPoints = tr.Root.GetNode(MARKER_LABEL_CUSTOM_COLL_TAGNAME);
		
		vector<int>		vnMapIndices;
		vector<uint>	vnR1s;
		vector<string>	vstrIndices;
		convert_int_vector_to_string_vector(vnIdx, vstrIndices);
		vstrIndices.FindDuplicates(vnMapIndices, vnR1s);
		for ( int ii = vnIdx.GetSize() - 1; ii >= 0; ii-- )
		{
			int			nGroupIndex = vnMapIndices[ii];
			if ( -1 != nGroupIndex && ii == vnR1s[nGroupIndex] )
			{
			#ifdef		_BEGUG
				ASSERT(nExistingCount > ii);
			#endif		//_BEGUG
				vnIdx.RemoveAt(ii);
				--nOldCount;
				
				if ( trPoints )
				{
					foreach ( TreeNode trPoint in trPoints.Children )
					{
						trPoint.Mirror.nVal = dwMirror;
						if ( ii == trPoint.Index.nVal )
							trPoint.Remove();
					}
				}
			}
		}		
	}
	///Sophy 10/20/2011 MORE_WORK_ON_PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
	if ( vnIdx.GetSize() == 0 )
	{
		//in COKPolylineObj::Create, IsCountValid will check the size of vnIdx and not allow vnIdx with 0 size.
		go.Show = false;
		return false;
	}
	else
	{
		go.Show = true;
	}
	///end MORE_WORK_ON_PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
	tr.Root.Data.X.dVals = vnIdx;
	tr.Root.Data.Y.dVals = vnIdx;
	
	if ( vPeakHeight )
	{
		TreeNode		trRoot = tr.Root;
		TreeNode		trPoints = tree_check_get_node(trRoot, MARKER_LABEL_CUSTOM_COLL_TAGNAME);
		
		string			strTagNamePrefix = MARKER_LABEL_CUSTOM_ITEM_TAGNAME_PREFIX;
		int				nEnum = 1;
		if ( trPoints.LastNode )
		{
			string		strTagName = trPoints.LastNode.tagName;
			strTagName.TrimLeft(strTagNamePrefix); // it must be Point&d
			nEnum = atoi(strTagName);
			++nEnum;
		}
		for ( int ii = 0; ii < vPeakHeight.GetSize(); ii++ )
		{
			if ( vPeakHeight[ii] < 0 )
			{
				string		strTagName;
				strTagName.Format("%s%d", strTagNamePrefix, nEnum++);
				TreeNode	trPoint = trPoints.AddNode(strTagName);
				trPoint.Index.nVal = ii + nOldCount;
				trPoint.Mirror.nVal = dwMirror;
			}
		}
	}
	/// end PEAK_MARKER_BE_POSITION_SENSITIVE
	
	return 0 == go.UpdateThemeIDs(tr.Root) && go.ApplyFormat(tr, TRUE, TRUE);
}

/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
//bool	_updateMakerProperty(GraphObject& go, int nColor, bool bShowLabel, int nLabelXYType = LABEL_Y_VAL_GUI, bool bRotateLabel = false, int nLabelColor = -1)
bool	_updateMakerProperty(GraphObject& go, int nColor, int nSize, bool bShowLabel, int nLabelXYType = LABEL_Y_VAL_GUI, bool bRotateLabel = false, int nLabelColor = -1, bool bZeroSymbolSize = false)
/// end NEW_PEAK_DISPLAY_GUI
{
	if( !go.IsValid() )
		return false;
	
	Tree 		trFormat;
	trFormat.Root.Symbol.Shape.nVal = SYMBOL_SHAPE;
	/// Hong 01/20/11 ORG-2067-S1 NEW_PEAK_DISPLAY_GUI
	//trFormat.Root.Symbol.Size.dVal = 0;//SYMBOL_SIZE;
	trFormat.Root.Symbol.Size.dVal = bZeroSymbolSize ? 0 : nSize;
	/// end NEW_PEAK_DISPLAY_GUI
	trFormat.Root.Symbol.EdgeColor.nVal = nColor;
	trFormat.Root.Color.nVal = INDEX_COLOR_TRANSPARENT;

	DWORD		dwMLCntrl = 0;
	if( bShowLabel )
	{
		trFormat.Root.Label.Angle.dVal = bRotateLabel ? 90 : 0;
		trFormat.Root.Label.Color.nVal = nLabelColor;
		/// Hong 01/20/11 ORG-2067-P3  CENTRE_LABEL
		trFormat.Root.Label.Dimension.YOffset.nVal = -120; // in percentage
		trFormat.Root.Label.Alignment.Horizontal.nVal = bRotateLabel ? 0 : 1; // left, center
		trFormat.Root.Label.Alignment.Vertical.nVal = bRotateLabel ? 1 : 3; // center, bottom
		/// end CENTRE_LABEL
		dwMLCntrl = MLC_SHOW;
		switch ( nLabelXYType )
		{
		case LABEL_X_VAL_GUI:
			dwMLCntrl |= MLC_LABEL_X;
			break;
		case LABEL_Y_VAL_GUI:
			dwMLCntrl |= MLC_LABEL_Y;
			break;
		case LABEL_XY_VAL_GUI:
		default:
			dwMLCntrl |= MLC_LABEL_XY;
			break;
		}
	}
	trFormat.Root.Label.Cntrl.nVal = dwMLCntrl;

	return 0 == go.UpdateThemeIDs(trFormat.Root) && go.ApplyFormat(trFormat, true, true);
}
/// end QUICK_PEAK_USE_MARKER_INSTEAD_OF_DATAPLOT_FOR_RESULT_IN_GRAPH

///Jasmine 05/19/2011 ORG-1352 QUICK_PEAKS_SWICTH_TO_PA
#define STR_ID_TO_TAGNAME(_id)			STR_THEME_NODE_TAGNAME_PREFIX+(string)_id

bool convert_pickpeak_settings_to_pa_theme(const TreeNode& trPickPeak, LPCSTR lpczPATheme)
{
	if(!trPickPeak)
		return false;
	
	string strBuiltinTheme(lpczPATheme);	strBuiltinTheme += " (System)";			///Jasmine 05/30/2012 ORG-1352-S1 CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
	string strClassOption = "PA";
	///Jasmine 05/30/2012 ORG-1352-S1 CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
	//string strThemeFilename = theme_get_settings_file(lpczPATheme, strClassOption);
	string strThemeFilename = theme_get_settings_file(strBuiltinTheme, strClassOption);
	string strUserThemeFile = theme_get_settings_file(lpczPATheme, strClassOption);
	///End CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
	if( !strThemeFilename.IsFile() )
	{
		vector<string> vsFilenames, vsList;
		int nCount = okutil_theme_get_class_settings(	strClassOption, &vsFilenames, &vsList, THTYPE_ANALYSIS, 
														/*bIncludeDefault = */false, /*bIncludeLastUsed = */false, 
														/*bIncludeCommon = */false, /*bBookTheme = */false, 
														/*bSheetTheme = */false, /*bIncludeFolderLastUsed = */false, 
														/*bIncludeSystem = */true);
		int nFind = vsList.Find(lpczPATheme);
		if(nFind >= 0)
			strThemeFilename = vsFilenames[nFind];
		if( !strThemeFilename.IsFile() )
			return false;
	}
	
	Tree trPATheme;
	trPATheme.Load(strThemeFilename);
	if( trPATheme.IsEmpty() )
		return false;
	
	vector<string> vsRemove = {	STR_XF_WIZ_THEME_SHARED,
								"ThemeFilter", 
								"pa_xpsbase"/*STR_PA_XFNAME_XPS*/,
								"pa_basetreat"/*PA_XFNAME_BASELINETREATMENT*/,
								"pa_basesubtr"/*STR_PA_XFNAME_BASESUBTR*/,
								"pa_fit"/*PA_XFNAME_FITPEAKS*/};
	for(int ii = 0; ii < vsRemove.GetSize(); ii++)
	{
		TreeNode trNode = trPATheme.GetNode( vsRemove[ii] );
		if(trNode)
			trNode.Remove();
	}
	
	//set goal to fit peak
	bool bRet = _set_node_value(trPATheme.GetNode("pa_goal"/*PA_XFNAME_GOAL*/), 393266, is_pro_version()? 4/*PA_GOAL_FIT_PEAK*/ : 0/*PA_GOAL_INTEGRATE_PEAK*/);
	
	//other settings
	_convert_baseline_settings_and_steps(trPickPeak, trPATheme);
	_convert_peak_settings(trPickPeak, trPATheme);
	_convert_integrate_settings(trPickPeak, trPATheme);
	
	vector<string> vsSteps = {"pa_goal", "pa_basemode", "pa_basetreat", "pa_peaks"};
	if( is_pro_version() )
		vsSteps.Add("pa_fit");
	else
		vsSteps.Add("pa_int");
	TreeNode trPath = tree_check_get_node(trPATheme, "Path");
	trPath.strVals = vsSteps;
	
	///Jasmine 05/30/2012 ORG-1352-S1 CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
	//if( !themes_tree_to_file(trPATheme, strThemeFilename) )
	if( !themes_tree_to_file(trPATheme, strUserThemeFile) )
	///End CANNOT_WRITE_BUILTIN_THEME_IN_WIN7_FOR_NORMAL_ACCOUNT
		error_report("Fail to set Quick Peaks settings to PA");
	return true;
}

#define _INVALID_NODE_ASSERT_RETURN(_node_)		if(!_node_){ASSERT(0);	return;	}
static void _convert_baseline_settings_and_steps(const TreeNode& trPickPeak, TreeNode& trPATheme)
{	
	TreeNode trPickPeakBaseline = trPickPeak.baseline;
	_INVALID_NODE_ASSERT_RETURN(trPickPeakBaseline)	
	
	int nMode = trPickPeakBaseline.mode? trPickPeakBaseline.mode.nVal : -1;
	int nPABaseMode;
	switch(nMode)
	{
	case PEAK_BASELINE_MODE_CONSTANT:
		nPABaseMode = 0;/*PA_BM_CONSTANT*/;
		break;
	case PEAK_BASELINE_MODE_AUTO:
		nPABaseMode = 1/*PA_BM_USERDEF*/;
		break;
	case PEAK_BASELINE_MODE_USE_EXISTING_DATASET:
		nPABaseMode = 2/*PA_BM_USE_EX*/;
		break;
	///Jasmine 06/25/2012 ORG-1352-P2 END_POINTS_WEIGHTED_READY_IN_PA
	case PEAK_BASELINE_MODE_END_POINT_WEIGHTED:
		nPABaseMode = 7/*PA_BM_End_Points_Weighted*/;
		break;
	///End END_POINTS_WEIGHTED_READY_IN_PA
	case PEAK_BASELINE_MODE_NONE:
	default:
	///---Jasmine 05/25/2011 not in PA
	//case PEAK_BASELINE_MODE_USE_MINMAX: 
	//case PEAK_BASELINE_MODE_END_POINT_WEIGHTED:
	///---End 
		nPABaseMode = 3/*PA_BM_None*/;
		break;
	}
	
	//according to getDefaultPathsByGoal and ChangeBaseMode
	vector<string> vsPaths = {	"pa_goal"		/*PA_XFNAME_GOAL*/, 
								"pa_basemode"	/*PA_XFNAME_BASELINEMODE*/,
								"pa_peaks"		/*PA_XFNAME_FINDPEAKS*/,
								"pa_fit"		/*PA_XFNAME_FITPEAKS*/			};
	if(!trPickPeakBaseline.mode)
		;
	else if(trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_CONSTANT				||
			trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_AUTO 				||
			trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_USE_EXISTING_DATASET	||
			trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_END_POINT_WEIGHTED	)		///Jasmine 06/25/2012 ORG-1352-P2 END_POINTS_WEIGHTED_READY_IN_PA
	{
		vsPaths.InsertAt(2, "pa_basetreat"/*PA_XFNAME_BASELINETREATMENT*/);
		
		if(trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_AUTO)
			vsPaths.InsertAt(2, "pa_basecreate"/*PA_XFNAME_CREATEBASELINE*/);
		
		///Jasmine 06/25/2012 ORG-1352-P2 END_POINTS_WEIGHTED_READY_IN_PA
		if(trPickPeakBaseline.mode.nVal == PEAK_BASELINE_MODE_END_POINT_WEIGHTED)
			vsPaths.InsertAt(2, "pa_epbase"/*STR_PA_XFNAME_END_POINTS*/);
		///End END_POINTS_WEIGHTED_READY_IN_PA
	}
	if(trPATheme.Path)	trPATheme.Path.strVals = vsPaths;
	
	
 	TreeNode trBasemode = trPATheme.GetNode("pa_basemode"/*PA_XFNAME_BASELINEMODE*/);
	if(trBasemode)
	{
		vector<int> vnReserve;
		if( _set_node_value(trBasemode, 196658, nPABaseMode) )
			vnReserve.Add(196658);
		
		
		//existing dataset
		if(trPickPeakBaseline.dataset)
		{
			string strDataset;
			trPickPeakBaseline.dataset.GetAttribute(STR_DATA_ATTRIB, strDataset);
			if( _set_node_value(trBasemode, 458802, strDataset) )
				vnReserve.Add(458802);
			if( _set_node_value(trBasemode, 524338, 0) )
				vnReserve.Add(524338);
		}
		
		
		//constant
		if(trPickPeakBaseline.constant && _set_node_value(trBasemode, 344076, trPickPeakBaseline.constant.nVal) )
			vnReserve.Add(344076);
		if(trPickPeakBaseline.ybase && _set_node_value(trBasemode, 344075, trPickPeakBaseline.ybase.dVal) )
			vnReserve.Add(344075);
		
		
		///---Jasmine 05/25/2011 not in PA
		//trPickPeakBaseline.creation.nVal;
		//trPickPeakBaseline.refer
		//trPickPeakBaseline.EndPoints.dVal
		///---End
		
		
		//user-defined
		TreeNode trSmooth = trPickPeakBaseline.SmoothMethodBranch;
		if(trSmooth)
		{
			if(trSmooth.SmoothMethod.nVal && _set_node_value(trBasemode, 409603, trSmooth.SmoothMethod.nVal) )
				vnReserve.Add(409603);
			if(trSmooth.WindowSize && _set_node_value(trBasemode, 409604, trSmooth.WindowSize.nVal) )
				vnReserve.Add(409604);
			if(trSmooth.Threshold && _set_node_value(trBasemode, 409606, trSmooth.Threshold.dVal) )
				vnReserve.Add(409606);
			if(trSmooth.PolyOrder && _set_node_value(trBasemode, 409607, trSmooth.PolyOrder.nVal)  )
				vnReserve.Add(409607);
		}
		
		
		//points and connect
		if(trPickPeakBaseline.npoints && _set_node_value(trBasemode, 409605, trPickPeakBaseline.npoints.nVal) )
			vnReserve.Add(409605);
		
		_remove_node(trBasemode, vnReserve);
	}
	
	
	TreeNode trBasecreate = trPATheme.GetNode("pa_basecreate"/*PA_XFNAME_CREATEBASELINE*/);
	if(trBasecreate)
	{		
		vector<int> vnReserve;
		
		if( _set_node_value(trBasecreate, 131122, 0/*connect_interpolate*/) )
			vnReserve.Add(131122);			
		if(trPickPeakBaseline.connect && _set_node_value(trBasecreate, 409601, trPickPeakBaseline.connect.nVal) )
			vnReserve.Add(409601);
		
		_remove_node(trBasecreate, vnReserve);
	}
	
	///Jasmine 06/25/2012 ORG-1352-P2 END_POINTS_WEIGHTED_READY_IN_PA
	TreeNode trEndPointsWeight = trPATheme.GetNode("pa_epbase"/*STR_PA_XFNAME_END_POINTS*/);
	if(trEndPointsWeight)
	{
		vector<int> vnReserve;
		
		if(trPickPeakBaseline.EndPoints && _set_node_value(trEndPointsWeight, 131122, trPickPeakBaseline.EndPoints.dVal) )
			vnReserve.Add(131122);
		
		_remove_node(trEndPointsWeight, vnReserve);
	}
	///End END_POINTS_WEIGHTED_READY_IN_PA
}
static void _convert_peak_settings(const TreeNode& trPickPeak, TreeNode& trPATheme)
{
	TreeNode trFindPeak = trPickPeak.findpeak;	
	_INVALID_NODE_ASSERT_RETURN(trFindPeak)
	TreeNode trPeakInTheme = trPATheme.GetNode("pa_peaks"/*PA_XFNAME_FINDPEAKS*/);
	_INVALID_NODE_ASSERT_RETURN(trPeakInTheme)
	
	vector<int> vnReserve;
	
	if( _set_node_value(trPeakInTheme, 196658, 1)/*Enable Auto Find*/ )
		vnReserve.Add(196658);		
	if( _set_node_value(trPeakInTheme, 524338, "::{Auto=0|Auto|1}0")/*Smoothing Window Size*/ )
		vnReserve.Add(524338);		
	if(trFindPeak.dir && _set_node_value(trPeakInTheme, 589874, trFindPeak.dir.nVal) )
		vnReserve.Add(589874);
	
	
	TreeNode trFindSettings = trFindPeak.settings;
	if(trFindSettings)
	{
		if(trFindSettings.method && _set_node_value(trPeakInTheme, 655410, trFindSettings.method.nVal) )
			vnReserve.Add(655410);
		if(trFindSettings.npts && _set_node_value(trPeakInTheme, 852018, trFindSettings.npts.nVal) )
			vnReserve.Add(852018);
		if(trFindSettings.option && _set_node_value(trPeakInTheme, 786482, trFindSettings.option.nVal) )
			vnReserve.Add(786482);
	}
	
	string strAutoThemeValue, strAutoAttrib;
	if(trFindSettings.height)
	{
		trFindSettings.height.GetAttribute(STR_ATTRIB_AUTO, strAutoAttrib);
		strAutoThemeValue.Format("::{Auto=%s}%g", strAutoAttrib, trFindSettings.height.dVal);
		if( _set_node_value(trPeakInTheme, 917554, strAutoThemeValue) )
			vnReserve.Add(917554);
	}
	
	if(trFindSettings.width)
	{
		trFindSettings.width.GetAttribute(STR_ATTRIB_AUTO, strAutoAttrib);
		strAutoThemeValue.Format("::{Auto=%s}%g", strAutoAttrib, trFindSettings.width.dVal);
		if( _set_node_value(trPeakInTheme, 983090, strAutoThemeValue) )
			vnReserve.Add(983090);
	}
	
	TreeNode trDerivSmooth = trFindSettings.deriv_smooth;
	if(trDerivSmooth)
	{
		if(trDerivSmooth.first && _set_node_value(trPeakInTheme, 737300, trDerivSmooth.first.nVal) )
			vnReserve.Add(737300);
		if(trDerivSmooth.second && _set_node_value(trPeakInTheme, 737301, trDerivSmooth.second.nVal) )
			vnReserve.Add(737301);
		if(trDerivSmooth.fft_cutoff && _set_node_value(trPeakInTheme, 737302, trDerivSmooth.fft_cutoff.dVal) )
			vnReserve.Add(737302);
		if(trDerivSmooth.deriv_poly && _set_node_value(trPeakInTheme, 737303, trDerivSmooth.deriv_poly.nVal) )
			vnReserve.Add(737303);
		if(trDerivSmooth.deriv_npts && _set_node_value(trPeakInTheme, 737304, trDerivSmooth.deriv_npts.nVal) )
			vnReserve.Add(737304);
	}
	
	
	TreeNode trPeakFilter = trFindPeak.filter;
	if(trPeakFilter && trPeakFilter.method)
	{
		if( _set_node_value(trPeakInTheme, 1048626, trPeakFilter.method.nVal) )
			vnReserve.Add(1048626);
		
		TreeNode trFilterValue = trPeakFilter.GetNode(PEAK_FILTER_HEIGHT == trPeakFilter.method.nVal? "val_height" : "val_num");
		if(trFilterValue)
		{
			trFilterValue.GetAttribute(STR_ATTRIB_AUTO, strAutoAttrib);
			strAutoThemeValue.Format("::{Auto=%s}%g", strAutoAttrib, trFilterValue.dVal);
			if( _set_node_value(trPeakInTheme, 1245234, strAutoThemeValue) )
				vnReserve.Add(1245234);
		}
	}
	
		
	if(trFindPeak.Display && trFindPeak.Display.PeakLabel)
	{
		TreeNode trPeakLabel = trFindPeak.Display.PeakLabel;
		if( _set_node_value(trPeakInTheme, 1310770, trPeakLabel.Use) )
			vnReserve.Add(1310770);
		
		int nLabel = trPeakLabel.Label? trPeakLabel.Label.nVal : -1;
		int nLabelContent;
		switch(nLabel)
		{
		case PEAK_CENTER_LABEL_Y:
			nLabelContent = LABEL_Y_VAL_GUI;
			break;
		case PEAK_CENTER_LABEL_XY:
			nLabelContent = LABEL_XY_VAL_GUI;
			break;
		case PEAK_CENTER_LABEL_X:
		//case PEAK_CENTER_LABEL_INDICES: LABEL_ROW_NUM_GUI ///Jasmine 05/25/2011 not in PickPeak
		default:
			nLabelContent = LABEL_X_VAL_GUI;
			break;
		}
		if( _set_node_value(trPeakInTheme, 1376306, nLabelContent) )
			vnReserve.Add(1376306);
		if(trPeakLabel.Horizontal && _set_node_value(trPeakInTheme, 1441842, trPeakLabel.Horizontal.nVal?false:true) )
			vnReserve.Add(1441842);
	}
	
	_remove_node(trPeakInTheme, vnReserve);
}
static void _convert_integrate_settings(const TreeNode& trPickPeak, TreeNode& trPATheme)
{
	TreeNode trPeakArea = trPickPeak.area;	
	_INVALID_NODE_ASSERT_RETURN(trPeakArea)
	TreeNode trIntegInTheme = trPATheme.GetNode("pa_int"/*STR_PA_XFNAME_INT*/);
	_INVALID_NODE_ASSERT_RETURN(trIntegInTheme)
	
	if(trPeakArea.IntegFrom && _set_node_value(trIntegInTheme, 458802, trPeakArea.IntegFrom.nVal) )
	{
		vector<int> vnReserve = {458802};
		_remove_node(trIntegInTheme, vnReserve);
	}
}

#define _SET_NODE_VALUE(_code_)			\ 
		if(!trParent || !trParent.ThemeTree) return error_report("fail to find trParent");\
		TreeNode trNode = tree_check_get_node(trParent.ThemeTree, STR_ID_TO_TAGNAME(id));\
		if(trNode)			\
		{					\
			_code_ ;		\
		}					\
		else				\
		{					\
			error_report("fail to set "+STR_ID_TO_TAGNAME(id)/*trNode.tagName*/);\
		}					\
		return trNode.IsValid();

static bool _set_node_value(TreeNode& trParent, int id, double dValue)
{
	_SET_NODE_VALUE( trNode.dVal = dValue )
}
static bool _set_node_value(TreeNode& trParent, int id, int nValue)
{
	_SET_NODE_VALUE( trNode.nVal = nValue )
}
static bool _set_node_value(TreeNode& trParent, int id, LPCSTR lpczValue)
{
	_SET_NODE_VALUE( trNode.strVal = lpczValue )
}

static void _remove_node(TreeNode& trParent, const vector<int>& vnReserve)
{
	TreeNode trThemeTree = tree_get_node_by_tagname(trParent, STR_XFBAR_MULITIMODE_THEME_TREE, true);
	if(!trThemeTree)
		return;
	
	foreach(TreeNode trNode in trThemeTree.Children)
	{
		string strID = trNode.tagName.Mid(4);
		vector<uint> vecIndex;
		if(vnReserve.Find(vecIndex, atof(strID)) <= 0)
			trNode.Remove();
	}
}
///End QUICK_PEAKS_SWICTH_TO_PA
