/*------------------------------------------------------------------------------*
 * File Name:	PeakEditDlg.h 													*
 * Creation: 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#ifndef		__PEAK_EDIT_DLG_H__
#define		__PEAK_EDIT_DLG_H__

#include "DialogEx.h"

#define STR_DLG_NAME				"PeakEditDlg"

#define		SET_COLUMN_HIDDEN(DW_, NN_)		DW_ |= (1 << NN_);
#define		IS_COLUMN_SHOWN(DW_, NN_)		!(DW_ & (1 << NN_))

#ifndef _BLPWIZ_H
enum
{
	PEAK_EDIT_OPTION_DISABLE = 0x00000001,
};
#endif

class PeakEditList : public GridListControl
{
public:
	PeakEditList();
	
	void Init(int nID, WndContainer &dlg, LPCSTR lpcszFunctionCategory, DWORD dwOption = 0);
	
	void AddRow();
	
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	
	bool SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight);
	
	bool GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight);
	
	void SetNewFlag();
	
private:
	
	int getMaxPeakIndex();
	
	bool isNumericCol(int nCol);
	
	void	setColReadonlyColor(int nCol);
	
public:
	
	static	const	int		PEAK_EDIT_DISABLE;
	static	const	int		PEAK_EDIT_NEW;
	
private:
	vector<string>			m_vsColHeadings;
	string					m_strOldValue;
	string					m_strDefaultFunc;
	vector<string> 			m_vsPlot, m_vsPeak, m_vsEnable, m_vsFuncs, m_vsCenter, m_vsWidth, m_vsHeight, m_vsChange;
	
	enum
	{
		PEAK_EDIT_PLOT,
		PEAK_EDIT_PEAK,
		PEAK_EDIT_ENABLE,
		PEAK_EDIT_FUNCTION,
		PEAK_EDIT_CENTER,
		PEAK_EDIT_WIDTH,
		PEAK_EDIT_HEIGHT,
		PEAK_EDIT_CHANGE,
		
		PEAK_EDIT_COL_NUM,
	};
	
	DWORD	m_dwOption;
	DWORD	m_dwHidden;		//------ Folger 04/15/08 FIX_PEAK_EDIT_GRID_HIDE_ALL_COLUMN_WHEN_INPUT_IS_EMPTY

};

class PeakEditDlg : public ResizeDialog
{
public:
	PeakEditDlg(LPCSTR lpcszFunctionCategory, DWORD dwOption = 0);
	
	int DoModalEx(HWND hWndParent = NULL);
	
protected:	

EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_BN_CLICKED(IDC_OPEN_PB_BUTTON, OnAdd)
	ON_BN_CLICKED(IDOK, OnOK)
	
	ON_GRID_BEFORE_EDIT(IDC_COL_LIST_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_COL_LIST_GRID, OnAfterEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_FUNC, OnComboChange)
	
EVENTS_END

	BOOL OnInitDialog();
	
	BOOL OnDlgResize(int nType, int cx, int cy);
	
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	
	BOOL OnAdd(Control ctrl);
	
	BOOL OnOK(Control ctrl);
	
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	
	BOOL OnComboChange(Control ctrl);
	
public:
	
	bool SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight);
	
	bool GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight);
	
private:
	PeakEditList			m_peList;
	ComboBox				m_combo;		//------ Folger 11/27/07 ADD_NEW_CONTROL_FEATURE
	DWORD					m_dwOption;		//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
	string					m_strFunctionCategory;
};

#endif		//__PEAK_EDIT_DLG_H__