/*------------------------------------------------------------------------------*
 * File Name:	PeakEditDlg.c 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 11/28/07 NEW_ROW_SHOULD_HAVE_THE_SAM_VALUE_AS_LAST_VALID_PEAK			*
 *	Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION								*
 *	Folger 04/02/08 HIDE_FUNCTION_COLUMN_AND_COMBO_SELECTION_AS_SANDY_SAID		*
 *	Folger 04/15/08 FIX_PEAK_EDIT_GRID_HIDE_ALL_COLUMN_WHEN_INPUT_IS_EMPTY		*
 *	Hong 09/02010 ORG-25 IMPROVE_CODE_NOT_DEPEND_ON_DEFAULT_SETTING_IN_RESOURCE	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "DialogEx.h"
#include "PeakEdit.h"
#include <..\OriginLab\nlsf_utils.h>
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

#define STR_DLG_NAME				"PeakEditDlg"

#define		SET_COLUMN_HIDDEN(DW_, NN_)		DW_ |= (1 << NN_);
#define		IS_COLUMN_SHOWN(DW_, NN_)		!(DW_ & (1 << NN_))

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
///		___PeakEditList___
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

class PeakEditList : public GridListControl
{
public:
	PeakEditList();
	
	void Init(int nID, WndContainer &dlg, LPCSTR lpcszFunctionCategory, DWORD dwOption = 0);
	
	void AddRow();
	
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	
	bool SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight);
	
	bool GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight);
	
	void SetNewFlag();
	
private:
	
	int getMaxPeakIndex();
	
	bool isNumericCol(int nCol);
	
	void	setColReadonlyColor(int nCol);
	
private:
	vector<string>			m_vsColHeadings;
	string					m_strOldValue;
	string					m_strDefaultFunc;
	vector<string> 			m_vsPlot, m_vsPeak, m_vsEnable, m_vsFuncs, m_vsCenter, m_vsWidth, m_vsHeight, m_vsChange;
	
	enum
	{
		PEAK_EDIT_PLOT,
		PEAK_EDIT_PEAK,
		PEAK_EDIT_ENABLE,
		PEAK_EDIT_FUNCTION,
		PEAK_EDIT_CENTER,
		PEAK_EDIT_WIDTH,
		PEAK_EDIT_HEIGHT,
		PEAK_EDIT_CHANGE,
		
		PEAK_EDIT_COL_NUM,
	};
	
	DWORD	m_dwOption;
	DWORD	m_dwHidden;		//------ Folger 04/15/08 FIX_PEAK_EDIT_GRID_HIDE_ALL_COLUMN_WHEN_INPUT_IS_EMPTY

};

PeakEditList::PeakEditList()
{
	m_dwOption = m_dwHidden = 0;
}

void PeakEditList::Init(int nID, WndContainer &dlg, LPCSTR lpcszFunctionCategory, DWORD dwOption)		// 0
{
	GridListControl::Init(nID, dlg);
	
	m_dwOption = dwOption;
	
	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable(flexEDKbdMouse);
	
	SetFixedColAlignment(-1, flexAlignCenterCenter);
	
	SetColDataType(PEAK_EDIT_PEAK, flexDTDouble);
	SetColDataType(PEAK_EDIT_CENTER, flexDTDouble);
	SetColDataType(PEAK_EDIT_WIDTH, flexDTDouble);
	SetColDataType(PEAK_EDIT_HEIGHT, flexDTDouble);
	SetColDataType(PEAK_EDIT_ENABLE, flexDTBoolean);
	
	m_flx.ExplorerBar = flexExSortShow;			//allow sort
	
	/// Hong 09/02010 ORG-25 IMPROVE_CODE_NOT_DEPEND_ON_DEFAULT_SETTING_IN_RESOURCE
	/*
	vector<string> vsFuncs, vsFiles;
	string strFuncs;
	nslf_get_func_list(vsFuncs, vsFiles, lpcszFunctionCategory);
	if (strFuncs.SetTokens(vsFuncs, '|'))
		m_strDefaultFunc = vsFuncs[0];
	SetColComboList(PEAK_EDIT_FUNCTION, strFuncs);		//set col combolist
	*/
	/// end IMPROVE_CODE_NOT_DEPEND_ON_DEFAULT_SETTING_IN_RESOURCE
	
	SetupRowsCols(1, 0,  -1, PEAK_EDIT_COL_NUM);
	GetFormatStrAsArray(_L("Plot|Peak|Enable|Function|Center|Width|Height|Change"), m_vsColHeadings);
	for (int ii=0; ii<m_vsColHeadings.GetSize(); ii++)
		SetColHeading(ii, m_vsColHeadings[ii]);
	
	/// Hong 09/02010 ORG-25 IMPROVE_CODE_NOT_DEPEND_ON_DEFAULT_SETTING_IN_RESOURCE
	vector<string> vsFuncs, vsFiles;
	string strFuncs;
	nslf_get_func_list(vsFuncs, vsFiles, lpcszFunctionCategory);
	if (strFuncs.SetTokens(vsFuncs, '|'))
		m_strDefaultFunc = vsFuncs[0];
	SetColComboList(PEAK_EDIT_FUNCTION, strFuncs);		//set col combolist
	/// end IMPROVE_CODE_NOT_DEPEND_ON_DEFAULT_SETTING_IN_RESOURCE
	
	vector<byte> vbHideCols(PEAK_EDIT_COL_NUM);
	vbHideCols[PEAK_EDIT_PLOT] = vbHideCols[PEAK_EDIT_CHANGE] = 1;
	//if ( bHideWidth )
		//vbHideCols[PEAK_EDIT_WIDTH] = 1;
		
	vbHideCols[PEAK_EDIT_FUNCTION] = 1;		//------ Folger 04/02/08 HIDE_FUNCTION_COLUMN_AND_COMBO_SELECTION_AS_SANDY_SAID
					
	SetColValues(PEAK_EDIT_PLOT, m_vsPlot, 0, true);		//hide already
	
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_PEAK) )
	{
		SetColValues(PEAK_EDIT_PEAK, m_vsPeak, 0, true);
		setColReadonlyColor(PEAK_EDIT_PEAK);
	}
	else
		vbHideCols[PEAK_EDIT_PEAK] = 1;
		
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_ENABLE) )
		SetColValues(PEAK_EDIT_ENABLE, m_vsEnable, 0, true);
	else
		vbHideCols[PEAK_EDIT_ENABLE] = 1;
	
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_FUNCTION) )
		SetColValues(PEAK_EDIT_FUNCTION, m_vsFuncs, 0, true);
	else
		vbHideCols[PEAK_EDIT_FUNCTION] = 1;
	
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_CENTER) )
		SetColValues(PEAK_EDIT_CENTER, m_vsCenter, 0, true);
	else
		vbHideCols[PEAK_EDIT_CENTER] = 1;
	
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_WIDTH) )
		SetColValues(PEAK_EDIT_WIDTH, m_vsWidth, 0, true);
	else
		vbHideCols[PEAK_EDIT_WIDTH] = 1;
	
	if ( IS_COLUMN_SHOWN(m_dwHidden, PEAK_EDIT_HEIGHT) )
		SetColValues(PEAK_EDIT_HEIGHT, m_vsHeight, 0, true);
	else
		vbHideCols[PEAK_EDIT_HEIGHT] = 1;
	
	SetColValues(PEAK_EDIT_CHANGE, m_vsChange, 0, true);		//hide already
	
	//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
	if ( dwOption & PEAK_EDIT_OPTION_DISABLE )
	{
		vbHideCols[PEAK_EDIT_ENABLE] = 1;
		setColReadonlyColor(PEAK_EDIT_CENTER);
		setColReadonlyColor(PEAK_EDIT_WIDTH);
		setColReadonlyColor(PEAK_EDIT_HEIGHT);
	}
	//------
	
	LoadHideCols(STR_DLG_NAME, "PeakEditList", &vbHideCols);
	
	ResizeCols();
	
	
	
	SetReady();
}
	
void PeakEditList::AddRow()
{
	int nRow = GetRows();
	//------ Folger 11/28/07 NEW_ROW_SHOULD_HAVE_THE_SAM_VALUE_AS_LAST_VALID_PEAK
	for (int ii=nRow-1; ii>0; --ii)
	{
		if (GetCell(ii, PEAK_EDIT_ENABLE).Compare("1") == 0)
			break;
	}
	//------
	SetRows(nRow + 1 - GetRowOffset());
	SetCell(nRow, PEAK_EDIT_PLOT, PEAK_EDIT_NEW);
	SetCell(nRow, PEAK_EDIT_PEAK, getMaxPeakIndex() + 1);
	SetCellColor(nRow, PEAK_EDIT_PEAK, COLOR_BLUE);
	SetCell(nRow, PEAK_EDIT_ENABLE, 1);
	//------ Folger 11/28/07 NEW_ROW_SHOULD_HAVE_THE_SAM_VALUE_AS_LAST_VALID_PEAK
	//SetCell(nRow, PEAK_EDIT_FUNCTION, m_strDefaultFunc);
	//SetCell(nRow, PEAK_EDIT_CENTER, 0);
	//SetCell(nRow, PEAK_EDIT_WIDTH, 0);
	//SetCell(nRow, PEAK_EDIT_HEIGHT, 0);
	SetCell(nRow, PEAK_EDIT_FUNCTION, ii > 0 ? GetCell(ii, PEAK_EDIT_FUNCTION) : m_strDefaultFunc);
	SetCell(nRow, PEAK_EDIT_CENTER, ii > 0 ? GetCell(ii, PEAK_EDIT_CENTER) : 0);
	SetCell(nRow, PEAK_EDIT_WIDTH, ii > 0 ? GetCell(ii, PEAK_EDIT_WIDTH) : 0);
	SetCell(nRow, PEAK_EDIT_HEIGHT, ii > 0 ? GetCell(ii, PEAK_EDIT_HEIGHT) : 0);
	
	if ( m_dwOption & PEAK_EDIT_OPTION_DISABLE )
	{
		SetCellColor(nRow, PEAK_EDIT_CENTER, COLOR_BLUE);
		SetCellColor(nRow, PEAK_EDIT_WIDTH, COLOR_BLUE);
		SetCellColor(nRow, PEAK_EDIT_HEIGHT, COLOR_BLUE);
	}
	//------
	SetCell(nRow, PEAK_EDIT_CHANGE, 1);
	ResizeCols();
}
	
void PeakEditList::OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	if (nCol == PEAK_EDIT_PEAK ||
		(m_dwOption & PEAK_EDIT_OPTION_DISABLE) && (nCol == PEAK_EDIT_CENTER || nCol == PEAK_EDIT_WIDTH || nCol == PEAK_EDIT_HEIGHT ) )
		*pCancel = true;
	if ( !(*pCancel) )
		m_strOldValue = GetCell(nRow, nCol);
}
	
void PeakEditList::OnAfterEdit(Control flxControl, int nRow, int nCol)
{
	string str = GetCell(nRow, nCol);
	if (str.Compare(m_strOldValue) == 0)
		return;
	else if(isNumericCol(nCol))
	{
		if (!is_numeric(str) || (nCol == PEAK_EDIT_WIDTH && atof(str) < 0))
		{
			SetCell(nRow, nCol, m_strOldValue);
			ResizeCols();
			return;
		}
	}
	SetCell(nRow, PEAK_EDIT_CHANGE, 1);
	ResizeCols();
}
	
bool PeakEditList::SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight)
{
	//int nPos1 = 0, nPos2 = 0;
	for (int ii=0; ii<vnPlotIndecies.GetSize(); ++ii)
	{
		//int nPos;
		//if (vnPeakIndecies[ii] < 0)
		//{
			//nPos = nPos2++;
		//}
		//else
		//{
			//nPos = nPos1++;
			//++nPos2;
		//}
		//m_vsPlot.InsertAt(nPos, (string)vnPlotIndecies[ii]);
		//m_vsPeak.InsertAt(nPos, vnPeakIndecies[ii] < 0 ? "" : (string)vnPeakIndecies[ii]);
		//m_vsEnable.InsertAt(nPos, vnPeakIndecies[ii] == PEAK_EDIT_DISABLE ? "0" : "1");
		//m_vsFuncs.InsertAt(nPos, vsFuncs[ii]);
		//m_vsCenter.InsertAt(nPos, (string)vCenter[ii]);
		//m_vsWidth.InsertAt(nPos, (string)vWidth[ii]);
		//m_vsHeight.InsertAt(nPos, (string)vHeight[ii]);
		//m_vsChange.InsertAt(nPos, "0");
		if ( vnPlotIndecies != NULL )
			m_vsPlot.Add((string)vnPlotIndecies[ii]);			
		if ( vnPeakIndecies != NULL )
			m_vsPeak.Add(vnPeakIndecies[ii] < 0 ? "" : (string)vnPeakIndecies[ii]);			
		if ( vnPeakIndecies != NULL )
			m_vsEnable.Add(vnPeakIndecies[ii] == PEAK_EDIT_DISABLE ? "0" : "1");
		if ( vsFuncs != NULL )
			m_vsFuncs.Add(vsFuncs[ii]);
		if ( vCenter != NULL )
			m_vsCenter.Add((string)vCenter[ii]);
		if ( vWidth != NULL )
			m_vsWidth.Add((string)vWidth[ii]);
		if ( vHeight != NULL )
			m_vsHeight.Add((string)vHeight[ii]);
		m_vsChange.Add("0");
	}
	
	//------ Folger 04/15/08 FIX_PEAK_EDIT_GRID_HIDE_ALL_COLUMN_WHEN_INPUT_IS_EMPTY
	if ( vnPeakIndecies == NULL )
	{
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_PEAK);
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_ENABLE);
	}
	
	if ( vsFuncs == NULL )
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_FUNCTION);
	
	if ( vCenter == NULL )
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_CENTER);
	
	if ( vWidth == NULL )
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_WIDTH);
	
	if ( vHeight == NULL )
		SET_COLUMN_HIDDEN(m_dwHidden, PEAK_EDIT_HEIGHT);
	//------ End FIX_PEAK_EDIT_GRID_HIDE_ALL_COLUMN_WHEN_INPUT_IS_EMPTY
	
	return true;
}
	
bool PeakEditList::GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight)
{
	if (!bOK)
		return false;
	
	vector<int> vnRow;
	vnRow.Data(1, GetRows() - 1);
	
	//find (!Enable && !New) || (Enable && New)
	for (int ii=vnRow.GetSize()-1; ii>=0; --ii)
	{
		int nEnable = atoi(GetCell(vnRow[ii], PEAK_EDIT_ENABLE));
		int nPlot = atoi(GetCell(vnRow[ii], PEAK_EDIT_PLOT));
		int nChange = atoi(GetCell(vnRow[ii], PEAK_EDIT_CHANGE));
		if ( nEnable && nPlot == PEAK_EDIT_NEW || !nEnable && nPlot != PEAK_EDIT_NEW && nChange )
		{
			SetCell(vnRow[ii], PEAK_EDIT_PEAK, nEnable ? PEAK_EDIT_NEW : PEAK_EDIT_DISABLE);
			vnRow.RemoveAt(ii);
		}
	}
	
	//find Changed
	for (ii=vnRow.GetSize()-1; ii>=0; --ii)
	{
		if (atoi(GetCell(vnRow[ii], PEAK_EDIT_CHANGE)) == 1)
			vnRow.RemoveAt(ii);
	}
	
	//delete Rows remain
	for (ii=vnRow.GetSize()-1; ii>=0; --ii)
	{
		DeleteRow(vnRow[ii]);
	}
	
	int nRowOffset = GetRowOffset();
	
	vector<string> vsPlot, vsPeak, vsCenter, vsWidth, vsHeight;
	
	GetColValues(PEAK_EDIT_PLOT, vsPlot, nRowOffset);
	GetColValues(PEAK_EDIT_PEAK, vsPeak, nRowOffset);
	if ( vsFuncs != NULL )
		GetColValues(PEAK_EDIT_FUNCTION, vsFuncs, nRowOffset);
	GetColValues(PEAK_EDIT_CENTER, vsCenter, nRowOffset);
	GetColValues(PEAK_EDIT_WIDTH, vsWidth, nRowOffset);
	GetColValues(PEAK_EDIT_HEIGHT, vsHeight, nRowOffset);

	if ( vnPlotIndecies != NULL )
		vnPlotIndecies.SetSize(0);
	if ( vnPeakIndecies != NULL )
		vnPeakIndecies.SetSize(0);
	if ( vCenter != NULL )
		vCenter.SetSize(0);
	if ( vWidth != NULL )
		vWidth.SetSize(0);
	if ( vHeight != NULL )
		vHeight.SetSize(0);
	for (ii=0; ii<vsPlot.GetSize(); ++ii)
	{
		if ( vnPlotIndecies != NULL )
			vnPlotIndecies.Add(atoi(vsPlot[ii]));
		if ( vnPeakIndecies != NULL )
			vnPeakIndecies.Add(atoi(vsPeak[ii]));
		if ( vCenter != NULL )
			vCenter.Add(atof(vsCenter[ii]));
		if ( vWidth != NULL )
			vWidth.Add(atof(vsWidth[ii]));
		if ( vHeight != NULL )
			vHeight.Add(atof(vsHeight[ii]));
	}
	
	return true;
}
	
void PeakEditList::SetNewFlag()
{
	//sort by PEAK_EDIT_PEAK
	if ( GetRows() > GetRowOffset() )
	{
		m_flx.Select(1, PEAK_EDIT_PEAK);
		m_flx.Sort = flexSortGenericAscending;
	}
	
	vector<string> vsPeak, vsEnable;
	GetColValues(PEAK_EDIT_PEAK, vsPeak, GetRowOffset());
	GetColValues(PEAK_EDIT_ENABLE, vsEnable, GetRowOffset());
	
	for (int ii=0; ii<vsPeak.GetSize(); ii++)
	{
		if (vsPeak[ii].IsEmpty() && atoi(vsEnable[ii]) == 1)
			SetCell(GetRowOffset() + ii, PEAK_EDIT_PEAK, PEAK_EDIT_NEW);
	}		
}
	
int PeakEditList::getMaxPeakIndex()
{
	vector<string> vsPeaks;
	GetColValues(PEAK_EDIT_PEAK, vsPeaks, GetRowOffset());
	int nMaxIndex = -1;
	for (int ii=0; ii<vsPeaks.GetSize(); ii++)
	{
		int nIndex;
		if ((nIndex = atoi(vsPeaks[ii])) > nMaxIndex)
			nMaxIndex = nIndex;
	}
	return nMaxIndex;
}

bool PeakEditList::isNumericCol(int nCol)
{
	return (nCol == PEAK_EDIT_CENTER || nCol == PEAK_EDIT_WIDTH || nCol == PEAK_EDIT_HEIGHT);		
}

void PeakEditList::setColReadonlyColor(int nCol)
{
	for (int ii=GetRowOffset(); ii<GetRows(); ++ii )
		SetCellColor(ii, nCol, COLOR_BLUE);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
///		End ___PeakEditList___
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
///		___PeakEditDlg___
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

class PeakEditDlg : public ResizeDialog
{
public:
	PeakEditDlg(LPCSTR lpcszFunctionCategory, DWORD dwOption = 0);
	
	int DoModalEx(HWND hWndParent = NULL);
	
protected:	

EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_BN_CLICKED(IDC_OPEN_PB_BUTTON, OnAdd)
	ON_BN_CLICKED(IDOK, OnOK)
	
	ON_GRID_BEFORE_EDIT(IDC_COL_LIST_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_COL_LIST_GRID, OnAfterEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_FUNC, OnComboChange)
	
EVENTS_END

	BOOL OnInitDialog();
	
	BOOL OnDlgResize(int nType, int cx, int cy);
	
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	
	BOOL OnAdd(Control ctrl);
	
	BOOL OnOK(Control ctrl);
	
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol);
	
	BOOL OnComboChange(Control ctrl);
	
public:
	
	bool SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight);
	
	bool GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight);
	
private:
	PeakEditList			m_peList;
	ComboBox				m_combo;		//------ Folger 11/27/07 ADD_NEW_CONTROL_FEATURE
	DWORD					m_dwOption;		//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
	string					m_strFunctionCategory;
};

PeakEditDlg::PeakEditDlg(LPCSTR lpcszFunctionCategory, DWORD dwOption) : ResizeDialog(IDD_COL_LIST_DLG, "ODlg8")
{
	m_dwOption = dwOption;
	m_strFunctionCategory = lpcszFunctionCategory;
}

int PeakEditDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

BOOL PeakEditDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog();
	
	///prepare controls to use
	Text = _L("Peak Info");
	GetItem(IDC_LAYER_LABEL).Visible = false;
	GetItem(IDC_SHEET_EDIT).Visible = false;
	Button btn = GetItem(IDC_OPEN_PB_BUTTON);
	if ( !(m_dwOption & PEAK_EDIT_OPTION_DISABLE) )		//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
		btn.Visible = true;
	//btn.Text = _L("Add");
	btn.Text = _LC("Add", STR_DLG_NAME);		//should add category to do correctly translation
	
	uint nButtonIDs[] = {IDCANCEL, IDC_OPEN_PB_BUTTON, 0};
	MakeSameSize(nButtonIDs, true);
	MakeSameSize(nButtonIDs, false);
	//------ Folger 11/27/07 ADD_NEW_CONTROL_FEATURE
	btn = GetItem(IDC_LAYER_LABEL);
	//btn.Visible = true;			//------ Folger 04/02/08 HIDE_FUNCTION_COLUMN_AND_COMBO_SELECTION_AS_SANDY_SAID
	btn.Text = _L("Function");
	
	m_combo = GetItem(IDC_COMBO_FUNC);
	//m_combo.Visible = true;		//------ Folger 04/02/08 HIDE_FUNCTION_COLUMN_AND_COMBO_SELECTION_AS_SANDY_SAID
	vector<string> vsFuncs, vsFiles;
	nslf_get_func_list(vsFuncs, vsFiles, m_strFunctionCategory);	
	for (int ii=0; ii<vsFuncs.GetSize(); ++ii)
	{
		m_combo.InsertString(ii, vsFuncs[ii]);
	}
	m_combo.SetCurSel(0);
	//------
	Control ctrl = GetItem(IDC_COL_LIST_GRID);
	RECT rr;
	GetClientRect(ctrl, rr);
	rr.top = GetControlGap();
	MoveControl(ctrl, rr);
	///end
	
	//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
	//m_peList.Init(IDC_COL_LIST_GRID, *this);
	m_peList.Init(IDC_COL_LIST_GRID, *this, m_strFunctionCategory, m_dwOption);
	//------
	
	return true;
}
	
BOOL PeakEditDlg::OnDlgResize(int nType, int cx, int cy)
{
	uint nButtonIDs[] = {IDCANCEL, IDOK, IDC_OPEN_PB_BUTTON, 0};
	ArrangeMainItemAndControls(nButtonIDs, IDC_COL_LIST_GRID, NULL, false);
	//------ Folger 11/27/07 ADD_NEW_CONTROL_FEATURE
	int nGap = GetControlGap();
	Control ctrlList;
	RECT 	rrList;
	GetControlClientRect(IDC_COL_LIST_GRID, rrList, &ctrlList);
	
	Control ctrlText;
	RECT 	rrText;
	GetControlClientRect(IDC_LAYER_LABEL, rrText, &ctrlText);
	
	Control ctrlCombo;
	RECT 	rrCombo;
	GetControlClientRect(IDC_COMBO_FUNC, rrCombo, &ctrlCombo);
	
	int nWidth = RECT_WIDTH(rrText);
	int nHeight = RECT_HEIGHT(rrText);
	rrText.top = rrList.bottom + 2 * nGap;
	rrText.bottom = rrText.top + nHeight;
	rrText.left = rrList.left;
	rrText.right = rrText.left + nWidth;
	MoveControl(ctrlText, rrText);
	
	nWidth = RECT_WIDTH(rrCombo);
	nHeight = RECT_HEIGHT(rrCombo);
	rrCombo.top = rrList.bottom + nGap;
	rrCombo.bottom = rrCombo.top + nHeight;
	rrCombo.left = rrText.right + nGap;
	rrCombo.right = rrCombo.left + nWidth;
	MoveControl(ctrlCombo, rrCombo);
	//------
	return true;
}
	
BOOL PeakEditDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
	
	pSz->top = -1;
	pSz->left = -1;
	pSz->width = 450;  //hard code, will change later
	pSz->height = 300;  //hard code, will change later
	return TRUE;
}
	
BOOL PeakEditDlg::OnAdd(Control ctrl)
{
	m_peList.AddRow();
	return true;
}
	
BOOL PeakEditDlg::OnOK(Control ctrl)
{
	m_peList.SetNewFlag();
	return true;
}
	
void PeakEditDlg::OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	m_peList.OnBeforeEdit(flxControl, nRow, nCol, pCancel);
}
	
void PeakEditDlg::OnAfterEdit(Control flxControl, int nRow, int nCol)
{
	m_peList.OnAfterEdit(flxControl, nRow, nCol);
}
	
BOOL PeakEditDlg::OnComboChange(Control ctrl)
{
	int nSel = m_combo.GetCurSel();
	string str;
	m_combo.GetLBText(nSel, str);
	vector<string> vsFuncs;
	int nRowOffset = m_peList.GetRowOffset();
	for (int ii=nRowOffset; ii<m_peList.GetRows(); ++ii)
	{
		m_peList.SetCell(ii, PEAK_EDIT_FUNCTION, str);
		OnAfterEdit(ctrl, ii, PEAK_EDIT_FUNCTION);
	}
	return true;
}

bool PeakEditDlg::SetGridContent(const vector<int> &vnPlotIndecies,
						const vector<int> &vnPeakIndecies,
						const vector<string> &vsFuncs,
						const vector &vCenter,
						const vector &vWidth,
						const vector &vHeight)
{
	return m_peList.SetGridContent(vnPlotIndecies, vnPeakIndecies, vsFuncs, vCenter, vWidth, vHeight);
}
	
bool PeakEditDlg::GetGridContent(bool bOK,
						vector<int> &vnPlotIndecies,
						vector<int> &vnPeakIndecies,
						vector<string> &vsFuncs,
						vector &vCenter,
						vector &vWidth,
						vector &vHeight)
{
	return m_peList.GetGridContent(bOK, vnPlotIndecies, vnPeakIndecies, vsFuncs, vCenter, vWidth, vHeight);
}

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
///		End ___PeakEditDlg___
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////


bool OpenPeakEditDlg(HWND hParent,
					LPCSTR		lpcszFunctionCategory,
					vector<int> &vnPlotIndecies,
					vector<int> &vnPeakIndecies,
					vector<string> &vsFuncs,
					vector &vCenter,
					vector &vWidth,
					vector &vHeight,
					DWORD	dwOption = 0)		//------ Folger 03/27/08 PEAK_EDIT_DIALOG_CONTROL_OPTION
{
	PeakEditDlg myDlg(lpcszFunctionCategory, dwOption);
	myDlg.SetGridContent(vnPlotIndecies, vnPeakIndecies, vsFuncs, vCenter, vWidth, vHeight);
	int nRet = myDlg.DoModalEx(hParent);
	bool bOK = nRet == IDOK;
	myDlg.GetGridContent(bOK, vnPlotIndecies, vnPeakIndecies, vsFuncs, vCenter, vWidth, vHeight);
	return bOK;
}