/*------------------------------------------------------------------------------*
 * File Name: ParameterTabs.h													*
 * Creation: Jasmine 10/22/08													*
 * Purpose: 																	*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG	*
 * Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION		*
 *	Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
 *	Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED		*
 *	Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT			*
 *	Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
 *	Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE
 *------------------------------------------------------------------------------*/

/////////////////////////////////////////////////////////////////
/////////////////////////	ParamTabs	/////////////////////////
/////////////////////////////////////////////////////////////////
#define STR_TAB_INI			"ParamTab.ini"
#define	MAX_TAB_COUNT		5

///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
#define STR_NEW_TAB_CONFIG_SECTION 		"NewTab"
#define IDC_BUILTIN_CONFIG_MENU_BEGIN 	(OC_MENURANGE_BEGIN + 1000)
#define IDC_USER_CONFIG_MENU_BEGIN 		(OC_MENURANGE_BEGIN + 1020)
///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG

class ParamTabs
{
public:
	ParamTabs()
	{
	}
	//in NLFit the first two tabs is splitter, so param tab should begin at the third tab, nBeginItem = 2
	void 	Init(LPCSTR lpcszDlg, TabControl* pTab, NLFParamsControl* pGridParas, int nBeginItem = 0);
	void 	OnDestroy();
	
	bool 	IsParamTab(int nTab);//for NLFit
	bool 	ShowTabCols();
	void	GotoTab(int nTab);

	int 	GetSelFromMousePos(int nx, int ny, Dialog* pDlg);
	void	OnShowMenu(int nx, int ny, Dialog* pDlg);
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//void 	LoadConfig(int nTab, LPCSTR lpcszConfig);
	void 	LoadConfig(int nTab, LPCSTR lpcszConfig, bool bIsBuiltIn = false);
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	void 	SaveConfig(int nTab, LPCSTR lpcszConfig);
	
	int 	NewTab();
	void 	DeleteTab(int nTab);
	
	bool 	RenameTab(int nTab);		///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
	
	int		ActiveParameterTab();		///-----Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT
private:
	bool 	inputConfigName(string& strConfig);
	int		loadBuiltinConfigs(vector<string>& vsBuiltinConfigs, BOOL bSort = FALSE);		 ///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
	bool 	isTabExist(LPCSTR lpczName);	///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME

protected:
	TabControl* 		m_pTab;
	int					m_nBegin;
	int					m_nParamTabs;
	vector<string>		m_vsTabNames;
	
	NLFParamsControl*	m_pGridParas;
	
	string				m_strDlg;
};

///////////////////////////////////////////////////////////////
///////////////////////	ParamTabMenu	///////////////////////
///////////////////////////////////////////////////////////////

enum{
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//PARAM_TAB_MENU_LOAD = 0,
	PARAM_TAB_MENU_LOAD_BUILT_IN = 0,
	PARAM_TAB_MENU_LOAD,
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	PARAM_TAB_MENU_SAVE,
	PARAM_TAB_MENU_SAVEAS,
		PARAM_TAB_MENU_SEPARATOR,
	PARAM_TAB_MENU_NEW,
	PARAM_TAB_MENU_DELETE,
	PARAM_TAB_MENU_RENAME,		///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		
	PARAM_TAB_MENU_TOTAL
};

class ParamTabMenu : public Menu
{
public:
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//ParamTabMenu(bool bEdit, int nTabs, bool bHasSubMenu, const Menu & subMenu)
	ParamTabMenu(bool bEdit, int nTabs, bool bHasBuiltInSubMenu, const Menu & subBuiltInMenu, bool bHasUserSubMenu, const Menu & subUserMenu)
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	{
		m_nChoice = -1;
		int nFlags = bEdit? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		//string strPopup = _L("Load Configuration");
		//if(bEdit && bHasSubMenu)
			//AddPopup(strPopup, subMenu);
		//else
			//Add(strPopup, OnMenuItem, bHasSubMenu? nFlags : MF_DISABLED | MF_GRAYED);
		string strLoadBuiltIn = _L("Load Built-in Configuration");
		if(bEdit && bHasBuiltInSubMenu)
			AddPopup(strLoadBuiltIn, subBuiltInMenu);
		else
			Add(strLoadBuiltIn, OnMenuItem, bHasBuiltInSubMenu? nFlags : MF_DISABLED | MF_GRAYED);

		string strLoadUser = _L("Load Configuration");
		if(bEdit && bHasUserSubMenu)
			AddPopup(strLoadUser, subUserMenu);
		else
			Add(strLoadUser, OnMenuItem, bHasUserSubMenu? nFlags : MF_DISABLED | MF_GRAYED);
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		
		
		Add(_L("Save Configuration"), OnMenuItem, nFlags);
		
		Add(_L("Save Configuration As..."), OnMenuItem, nFlags);
		
		Add(NULL, EmptySepFunc, MF_SEPARATOR);	
		
		bool bOverload = MAX_TAB_COUNT <= nTabs;
		///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		//Add(_L("New Parameter Tab"), OnMenuItem, bOverload? MF_DISABLED | MF_GRAYED : MF_ENABLED);
		Add(_L("New Tab"), OnMenuItem, bOverload? MF_DISABLED | MF_GRAYED : MF_ENABLED);
		///End CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		
		bool bLastTab = 1 >= nTabs;
		///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		//Add(_L("Delete Parameter Tab"), OnMenuItem, bLastTab? MF_DISABLED | MF_GRAYED : nFlags);
		Add(_L("Delete Tab"), OnMenuItem, bLastTab? MF_DISABLED | MF_GRAYED : nFlags);
		///End CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		
		Add(_L("Rename Tab"), OnMenuItem, nFlags);			///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		//if(m_nChoice >= PARAM_TAB_MENU_LOAD && m_nChoice <= PARAM_TAB_MENU_TOTAL)
		if(m_nChoice >= PARAM_TAB_MENU_LOAD_BUILT_IN && m_nChoice <= PARAM_TAB_MENU_TOTAL)
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};

///////////////////////////////////////////////////////////////
///////////////////////	TabConfigsMenu	///////////////////////
///////////////////////////////////////////////////////////////
///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
//#define IDC_CONFIG_MENU_BEGIN         (OC_MENURANGE_BEGIN + 1000)
///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG

class TabConfigsMenu : public Menu
{
public:
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//TabConfigsMenu(const vector<string>& vsConfigs)
	TabConfigsMenu(const vector<string>& vsConfigs, int nBeginID)
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	{
		m_nItems = vsConfigs.GetSize();
		
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		//int nCmd = IDC_CONFIG_MENU_BEGIN;
		m_nBeginID = nBeginID;
		int nCmd = m_nBeginID;
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		for(int ii = 0; ii < m_nItems; ii++)
		{
			Add( vsConfigs[ii], OnSubMenuItem, MF_STRING, nCmd++);
		}
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		//ASSERT(m_nItems == nCmd - IDC_CONFIG_MENU_BEGIN);
		ASSERT(m_nItems == nCmd - m_nBeginID);
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	}
	void OnSubMenuItem(UINT nPos)
	{
	}
	bool GetCommand(int& nChoice, int nSelCmd)
	{
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		//int nCmd = nSelCmd - IDC_CONFIG_MENU_BEGIN;
		int nCmd = nSelCmd - m_nBeginID;
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		if(nCmd >= 0 && nCmd < m_nItems)
		{
			nChoice = nCmd;
			return true;
		}
		return false;
	}
private:
	int m_nItems;
	int m_nBeginID;			///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
};
/////////////////////////////////////////////////////////////////
/////////////////////////	ParamTabs	/////////////////////////
/////////////////////////////////////////////////////////////////

///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
#define			STR_PARAM_TAB_REG_KEY		"ParamTabNameList"
#define			STR_PARAMETERS_E			_LE("Parameters")
#define			STR_BOUNDS_E				_LE("Bounds")
///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED

void ParamTabs::Init(LPCSTR lpcszDlg, TabControl* pTab, NLFParamsControl* pGridParas, int nBeginItem)// = 0
{
	if(!pTab || !pGridParas)
	{
		ASSERT(0);
		return;
	}
	
	m_pTab 		= pTab;
	m_pGridParas= pGridParas;	
	m_nBegin 	= nBeginItem;	
	m_strDlg 	= lpcszDlg;
	
	string strTabNames;
	///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
	//string strDefaultName = _L("Parameters") + "|" + _L("Bounds");
	string				strDefaultName;
	vector<string>		vsBuiltinConfigs;
	loadBuiltinConfigs(vsBuiltinConfigs, FALSE);
	strDefaultName.SetTokens(vsBuiltinConfigs, '|');
	dlg_load_registry(m_strDlg, STR_PARAM_TAB_REG_KEY, strTabNames, strDefaultName);	
	///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
	m_nParamTabs = strTabNames.GetTokens(m_vsTabNames, '|');
	
	vector<int> vnAllCol;
	///Jasmine 07/15/10 ORG-486-S1 ADD_PEAK_ATTRIB_TO_NLFIT
//	vnAllCol.Data(NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_UB, 1);
	vnAllCol.Data(NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_TOTAL-1, 1);
	///End ADD_PEAK_ATTRIB_TO_NLFIT
	for(int nItem = m_nBegin, ii = 0; ii < m_nParamTabs; ii++)
	{
		m_pTab->InsertItem(nItem++, m_vsTabNames[ii]);
		m_pGridParas->AddGroup(vnAllCol);
	}
	
	ASSERT(nItem - m_nBegin == m_nParamTabs);
	ASSERT(m_pGridParas->GetNumGroups() == m_nParamTabs);
}
	
void ParamTabs::OnDestroy()
{
	if(m_pTab)
	{
		string strTabNames;
		strTabNames.SetTokens(m_vsTabNames, '|');
		dlg_save_to_registry(m_strDlg, STR_PARAM_TAB_REG_KEY, strTabNames);
	}
}
	
bool ParamTabs::IsParamTab(int nTab)
{
	return 0 <= (nTab - m_nBegin) && (nTab - m_nBegin) < m_nParamTabs;
}
	

	
bool ParamTabs::ShowTabCols()
{
	int nSelTab = m_pTab->GetCurSel();
	if( !IsParamTab(nSelTab) )
		return false;
	
	m_pGridParas->SetShowCols(nSelTab - m_nBegin);
	
	return true;
}
	
void ParamTabs::GotoTab(int nTab)
{
	Window Wnd( m_pGridParas->GetDlgSafeHwnd() );
	if(Wnd)
		Wnd.SendMessage(WM_USER_SELECT_TOP_TAB, nTab, 0);
}

int ParamTabs::GetSelFromMousePos(int nx, int ny, Dialog* pDlg)
{
	int nSelTab = m_pTab->GetCurSel();
	///Jasmine 12/10/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
	//for(int ii = 0; ii < m_nBegin + m_nParamTabs; ii++)
	for(int ii = 0; ii < m_pTab->GetItemCount(); ii++)	
	///End MOVE_FIT_CONTROL_FROM_PA_FIT
	{
		RECT rr;
		///Jasmine 12/10/10 ORG-793 MOVE_FIT_CONTROL_FROM_PA_FIT
		BOOL bRet = m_pTab->GetItemRect(ii, &rr);
		if(!bRet)//exceed tab total number
			break;
		///End MOVE_FIT_CONTROL_FROM_PA_FIT
		pDlg->ClientToScreen(&rr);
			
		if(rr.left < nx && nx < rr.right)
		{
			nSelTab = ii;
			break;
		}
	}
	return nSelTab;
}

void ParamTabs::OnShowMenu(int nx, int ny, Dialog* pDlg)
{
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//vector<string> vsConfigs;
	//for(int nFlag = 0; nFlag < 2; nFlag++)
	//{
		//string strFile = GetAppPath(nFlag) + STR_TAB_INI;
		//if( !strFile.IsFile() )
			//continue;
		//
		//vector<string> vsSection;
		//okutil_get_file_sections(strFile, &vsSection);
		//vsConfigs.Append(vsSection);
	//}
	//remove_repeat_item(vsConfigs);
	//vsConfigs.Sort();
	vector<string> vsUserConfigs, vsBuiltInConfigs;

	///-----Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE
	//string strFile = GetAppPath(0) + STR_TAB_INI;		// user folder
	string strFile;
	_get_user_param_tabs_ini_file(strFile);
	///-----End READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE
	if(strFile.IsFile())
	{
		okutil_get_file_sections(strFile, &vsUserConfigs);
		remove_repeat_item(vsUserConfigs);
		vsUserConfigs.Sort();
	}
	///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
	//strFile = GetAppPath(1) + STR_TAB_INI;				// system folder
	//if(strFile.IsFile())
	//{
		//okutil_get_file_sections(strFile, &vsBuiltInConfigs);
		//int nIndex = vsBuiltInConfigs.Find( STR_NEW_TAB_CONFIG_SECTION );
		//if(nIndex>=0)
			//vsBuiltInConfigs.RemoveAt(nIndex);
		//remove_repeat_item(vsBuiltInConfigs);
		//vsBuiltInConfigs.Sort();
	//}
	loadBuiltinConfigs(vsBuiltInConfigs, TRUE);
	///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	
	int 			nSelTab = m_pTab->GetCurSel();	
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//TabConfigsMenu	myConfigsMenu(vsConfigs);	
	//ParamTabMenu 	myMenu(IsParamTab(nSelTab), m_nParamTabs, vsConfigs.GetSize() > 0, myConfigsMenu);
	TabConfigsMenu	builtConfigsMenu(vsBuiltInConfigs, IDC_BUILTIN_CONFIG_MENU_BEGIN);
	TabConfigsMenu	userConfigsMenu(vsUserConfigs, IDC_USER_CONFIG_MENU_BEGIN);
	ParamTabMenu 	myMenu(IsParamTab(nSelTab), m_nParamTabs, vsBuiltInConfigs.GetSize() > 0, builtConfigsMenu, vsUserConfigs.GetSize() > 0, userConfigsMenu);
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	
	int nSel;
	myMenu.TrackPopupMenu(0, nx, ny, pDlg->GetSafeHwnd(), &nSel);
	
	int nCmd;
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//if( myConfigsMenu.GetCommand(nCmd,nSel) )
	//{
		//string strConfig = vsConfigs[nCmd];
		//LoadConfig(nSelTab, strConfig);
		//return;
	//}
	bool bIsBuiltIn = false;
	string strConfig;
	if( builtConfigsMenu.GetCommand(nCmd,nSel) )
	{
		strConfig = vsBuiltInConfigs[nCmd];
		bIsBuiltIn = true;
	}
	if( userConfigsMenu.GetCommand(nCmd,nSel) )
		strConfig = vsUserConfigs[nCmd];
	if(!strConfig.IsEmpty())
	{
		LoadConfig(nSelTab, strConfig, bIsBuiltIn);
		return;
	}
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	if(myMenu.GetCommand(nCmd))
	{
		switch(nCmd)
		{	
		case PARAM_TAB_MENU_SAVE:
			string strConfig = m_vsTabNames[nSelTab - m_nBegin];
			SaveConfig(nSelTab, strConfig);
			break;
			
		case PARAM_TAB_MENU_SAVEAS:
			string strConfig;
			if( inputConfigName(strConfig) )
				SaveConfig(nSelTab, strConfig);
			break;
			
		case PARAM_TAB_MENU_NEW:
			NewTab();
			break;
			
		case PARAM_TAB_MENU_DELETE:
			DeleteTab(nSelTab);
			break;
		///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		case PARAM_TAB_MENU_RENAME:
			RenameTab(nSelTab);
			break;
		///End CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
		default:
			ASSERT(0);
			break;
		}
		
	}
	
}

///-----Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE
static void _get_user_param_tabs_ini_file(string &strFile)
{
	strFile = okutil_get_origin_path(ORIGIN_PATH_USER) + STR_TAB_INI;
	if ( !strFile.IsFile() )
		strFile = okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_TAB_INI;
}
///-----End READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE

///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
//void ParamTabs::LoadConfig(int nTab, LPCSTR lpcszConfig)
void ParamTabs::LoadConfig(int nTab, LPCSTR lpcszConfig, bool bIsBuiltIn)
///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
{
	if( !IsParamTab(nTab) )
		return;
	
	vector<string> 	vsCols, vsShow;
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//for(int nFlag = 0; nFlag < 2; nFlag++)
	//{
		//string strFile = GetAppPath(nFlag) + STR_TAB_INI;
		//if( !strFile.IsFile() )
			//continue;
		//
		//vector<string> vsSection;
		//okutil_get_file_sections(strFile, &vsSection);
		//if( 0 > vsSection.Find(lpcszConfig) )
			//continue;
	//
		//okutil_read_file_section_keys(strFile, lpcszConfig, &vsCols, &vsShow);
		//break;
	//}
	///-----Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE
	//string strFile = GetAppPath(bIsBuiltIn) + STR_TAB_INI;
	string strFile;
	if ( bIsBuiltIn )
	{
		strFile = okutil_get_origin_path(ORIGIN_PATH_SYSTEM) + STR_TAB_INI;
	}
	else
	{
		// uff ==> groupshare folder
		_get_user_param_tabs_ini_file(strFile);
	}
	///-----End READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_PARAMTAB_INI_FILE

	if(strFile.IsFile())
	{
		vector<string> vsSection;
		okutil_get_file_sections(strFile, &vsSection);
		///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
		if ( bIsBuiltIn )
		{
			for ( int ii=0; ii<vsSection.GetSize(); ++ii )
			{
				if ( compare_string_localization(lpcszConfig, vsSection[ii]) )
				{
					okutil_read_file_section_keys(strFile, vsSection[ii], &vsCols, &vsShow);
					break;
				}
			}
		}
		else
		///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
		if(vsSection.Find(lpcszConfig) >= 0)
			okutil_read_file_section_keys(strFile, lpcszConfig, &vsCols, &vsShow);
	}
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	
	if(vsCols.GetSize() > 0)
	{	
		vector<int> 	vnCols;
		///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
		//m_pGridParas->ConvertColNameToIndex(vsCols, vnCols);
		m_pGridParas->ConvertColNameToIndex(vsCols, vnCols, true);
		///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
		vector<uint> vnIndexes;
		int nInvalids = vnCols.Find(vnIndexes, -1);
		for(int ii = nInvalids - 1; ii >= 0; ii--)
		{
			int nIndex = vnIndexes[ii];
			vnCols.RemoveAt(nIndex);
			vsShow.RemoveAt(nIndex);
		}
		
		vector<byte> 	vbShows;
		convert_string_vector_to_byte_vector(vsShow, vbShows);
		
		if( m_pGridParas->SetGroupColShows(nTab - m_nBegin, vnCols, vbShows) )
		{
			///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
			//m_pTab->SetItemText(nTab, lpcszConfig);
			//m_vsTabNames[nTab - m_nBegin] = lpcszConfig;
			string		strConfig = bIsBuiltIn ? GetLocalized(lpcszConfig) : lpcszConfig;
			
			///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME
			if( strConfig.Compare( m_pTab->GetItemText(nTab) ) != 0 )
			{
				if( isTabExist(strConfig) )
				{
					string strPrefix;
					string_to_prefix_end_number(strPrefix.GetBuffer(MAXLINE), strConfig);
					strPrefix.ReleaseBuffer();
					strConfig = strPrefix;
					
					int nTabCount = m_pTab->GetItemCount();
					vector<string> vsTabNames(nTabCount);
					for(int ii = 0; ii < nTabCount; ii++)
						vsTabNames[ii] = m_pTab->GetItemText(ii);

					int nPostfix = get_list_enum_number(vsTabNames, strPrefix);
					if(nPostfix > 0)
						strConfig += (string)nPostfix;
				}
				
				m_pTab->SetItemText(nTab, strConfig);
				m_vsTabNames[nTab - m_nBegin] = strConfig;
				///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
			}
			///End NOT_ALLOW_DUPLICATE_NAME
			ShowTabCols();
			
			return;
		}
	}
	
	string strErr = _L("Fail to load configuration.");
	MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr);
	
}

void ParamTabs::SaveConfig(int nTab, LPCSTR lpcszConfig)
{
	if( !IsParamTab(nTab) )
		return;
	
	vector<int> 	vnCols;
	vector<byte> 	vbShows;
	m_pGridParas->GetGroupColShows(nTab - m_nBegin, vnCols, vbShows);
	
	vector<string> 	vsCols, vsShow;
	///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	//m_pGridParas->ConvertColIndexToName(vnCols, vsCols);
	m_pGridParas->ConvertColIndexToName(vnCols, vsCols, true);
	///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	
	vector<string> 	vsCheck;
	vsCheck = vsCols;
	if( vsCols.GetSize() != remove_empty_item(vsCheck) )
		ASSERT(0);
	
	convert_byte_vector_to_string_vector(vbShows, vsShow);
	
	
	string strFile = GetAppPath() + STR_TAB_INI;		
	if(okutil_write_file_section_keys(strFile, lpcszConfig, &vsCols, &vsShow) >= 0)
	{
		m_pTab->SetItemText(nTab, lpcszConfig);
		m_vsTabNames[nTab - m_nBegin] = lpcszConfig;
	}
	else	
		popup_errmsg_save_readonly_file(strFile, m_pGridParas->GetDlgSafeHwnd());
	
}
	
int ParamTabs::NewTab()
{
	if(MAX_TAB_COUNT <= m_nParamTabs)
		return -2;
		
	int nNewItem = m_nBegin + m_nParamTabs;
	///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	//string strName = _L("Tab") + (nNewItem+1);
	///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME
	//string strName = _L("NewParam") + (m_nParamTabs);
	int nTabCount = m_pTab->GetItemCount();
	vector<string> vsTabNames(nTabCount);
	for(int ii = 0; ii < nTabCount; ii++)
		vsTabNames[ii] = m_pTab->GetItemText(ii);
	
	string strName = _L("NewParam");
	int nPostfix = get_list_enum_number(vsTabNames, strName);
	if(nPostfix > 0)
		strName += (string)nPostfix;
	///End NOT_ALLOW_DUPLICATE_NAME
	///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
	if( m_pTab->InsertItem(nNewItem, strName) )
	{
		m_vsTabNames.Add(strName);
		m_nParamTabs++;
		
		vector<int> vnAllCol;
		vnAllCol.Data(NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_UB, 1);
		vector<uint> vnShows(NLPARAMGRIDCOLTYPE_TOTAL);
		vnShows = 0;
		vnShows[NLPARAMGRIDCOLTYPE_NAME] = 1;
		if( m_pGridParas->AddGroup(vnAllCol, vnShows) != nNewItem - m_nBegin)
			ASSERT(0);
		///Kyle 12/04/2008 ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		LoadConfig(nNewItem, STR_NEW_TAB_CONFIG_SECTION, true);
		m_pTab->SetItemText(nNewItem, strName);
		m_vsTabNames[nNewItem - m_nBegin] = strName;
		///End ADD_ITEM_LOAD_BUILT_IN_CONFIG_AND_SET_NEW_TAB_DEFAULT_CONFIG
		GotoTab(nNewItem);
		
		return nNewItem;
	}
	
	return -1;
}

void ParamTabs::DeleteTab(int nTab)
{	
	if( !IsParamTab(nTab) || 1 >= m_nParamTabs)
		return;
	
	int nSelTab = 0;
	
	if( m_pTab->DeleteItem(nTab) )
	{
		m_vsTabNames.RemoveAt(nTab - m_nBegin);
		m_nParamTabs--;
		
		m_pGridParas->DeleteGroup(nTab - m_nBegin); 
		
		int nSel = nTab;
		if( !IsParamTab(nSel) )
			nSel = m_nBegin + m_nParamTabs - 1;//sel last tab;
		
		GotoTab(nSel);
	}
}

///-----Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT
int	ParamTabs::ActiveParameterTab()
{
	for( int ii=0; ii<m_nParamTabs; ++ii )
	{
		string strItemText = m_pTab->GetItemText( ii+m_nBegin );

		if( compare_string_localization( strItemText, "Parameters" ) )
		{
			GotoTab( m_nBegin + ii );
			return m_nBegin+ii;
		}
	}

	return -1;
}
///-----End ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT

///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME
bool ParamTabs::isTabExist(LPCSTR lpczName)
{
	int nTabCount = m_pTab->GetItemCount();
	vector<string> vsTabNames(nTabCount);
	for(int ii = 0; ii < nTabCount; ii++)
		vsTabNames[ii] = m_pTab->GetItemText(ii);
	if(vsTabNames.Find(lpczName) != -1)
		return true;
	
	return false;
}
///End NOT_ALLOW_DUPLICATE_NAME

///Kyle 12/11/2008 CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION
bool ParamTabs::RenameTab(int nTab)
{
	string strOldTabName, strNewTabName;
	strOldTabName = m_vsTabNames[nTab - m_nBegin];
	Tree tr;
	TreeNode trNewName = tr.AddNode();
	GETN_USE(trNewName)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_STR(name, _L("New Tab Name"), strOldTabName)
	if(GetNBox(trNewName, "Rename Tab"))
	{
		strNewTabName = trNewName.name.GetNodeText();
		strNewTabName.TrimLeft();
		strNewTabName.TrimRight();
		///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME
		//if(!strNewTabName.IsEmpty() && strOldTabName.CompareNoCase(strNewTabName)&& m_pTab->SetItemText(nTab, strNewTabName))
		if(!strNewTabName.IsEmpty() && strOldTabName.CompareNoCase(strNewTabName))
		{
			if( isTabExist(strNewTabName) )
			{
				string strErr;
				ocu_load_msg_str(CER_NAME_ALREADY_EXIST, &strErr);
				MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr);
				return false;
			}
			
			m_pTab->SetItemText(nTab, strNewTabName);
		///End NOT_ALLOW_DUPLICATE_NAME
			m_vsTabNames[nTab - m_nBegin] = strNewTabName;
			return true;
		}
	}
	return false;
}
///End CHANGE_CONTEXT_MENU_LABELS_AND_ADD_RENAME_TAB_FUNCTION

bool ParamTabs::inputConfigName(string& strConfig)
{
	strConfig.Empty();
	
	
	string 	strFile = GetAppPath() + STR_TAB_INI;	
	vector<string> vsExistConfig;	
	okutil_get_file_sections(strFile, &vsExistConfig);
	
	
	vector<string> vsReservedNames(2);
	vsReservedNames[0] = RESERVED_SETTINGS_TAB;
	vsReservedNames[1] = RESERVED_CODE_TAB;
	remove_if_in_list(vsExistConfig, vsReservedNames);
	
	
	string strCombo;
	strCombo.SetTokens(vsExistConfig, '|');
	if(!strCombo.IsEmpty())
		strCombo = "|" + strCombo;
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_STRLIST(name, _L("Configuration Name"), "", strCombo)
	
	for(bool bValid = false; ; )
	{
		if( !GetNBox( tr, _L("Save As"), NULL, NULL, NULL, m_pGridParas->GetDlgSafeHwnd() ) )
			break;
			
		string strInput = tr.name.strVal;
		if( strInput.IsEmpty() )
		{
			string strErr;
			ocu_load_msg_str(CER_EMPTY_VARIABLE, &strErr, _L("Configuration Name"));
			MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr);
			continue;
		}		
		if(vsReservedNames.Find(strInput) >= 0)
		{
			string strErr = _L("%s is reserved name. Please input another name.");
			strErr.Format(strErr, strInput);
			MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr);
			continue;
		}
		///Jasmine 12/28/10 ORG-793 NOT_ALLOW_DUPLICATE_NAME
		if( isTabExist(strInput) )
		{
			string strErr;
			ocu_load_msg_str(CER_NAME_ALREADY_EXIST, &strErr);
			MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr);
			continue;			
		}
		///End NOT_ALLOW_DUPLICATE_NAME
		if(vsExistConfig.Find(strInput) >= 0)
		{
			string strErr;
			ocu_load_msg_str(XFWARN_TEMPLATE_ALREADY_EXISTS, &strErr, strInput);
			if( IDNO == MessageBox(m_pGridParas->GetDlgSafeHwnd(), strErr, NULL, MB_YESNO) )
				continue;			
		}
		
		strConfig = strInput;
		break;
	}
	
	return !strConfig.IsEmpty();
}

///------ Folger 07/17/09 QA80-13968 NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED
int		ParamTabs::loadBuiltinConfigs(vector<string>& vsBuiltinConfigs, BOOL bSort/* = FALSE*/)
{
	string		strFile = okutil_get_origin_path(ORIGIN_PATH_SYSTEM) + STR_TAB_INI;
	if ( strFile.IsFile() )
	{
		okutil_get_file_sections(strFile, &vsBuiltinConfigs);
		int		nIndex = vsBuiltinConfigs.Find(STR_NEW_TAB_CONFIG_SECTION);
		if ( nIndex >= 0 )
			vsBuiltinConfigs.RemoveAt(nIndex);
		remove_repeat_item(vsBuiltinConfigs);

		for ( int ii=0; ii<vsBuiltinConfigs.GetSize(); ++ii )
			vsBuiltinConfigs[ii] = GetLocalized(vsBuiltinConfigs[ii]);

		if ( bSort )
			vsBuiltinConfigs.Sort();
	}

	return vsBuiltinConfigs.GetSize();
}
///------ End NLFIT_PARAMETER_BUILTIN_TABS_NOT_LOCALIZAED