/*------------------------------------------------------------------------------*
 * File Name:PageListControl, Project Explorer Control							*
 * Creation: CPY Feb 29 2004													*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE					*
 *	Jasmine 03/28/07 QA70-6714 USE_LONG_NAME_FOR_LOOSEDATASET					*
 *	Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 *	Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO									*
 *	Jasmine 04/08/09 CHECK_STORAGE_TO_AVOID_OUTPUT_JUNK_ERROR_MSG				*
 *	Jasmine 04/13/09 EXCEL_IS_A_KIND_OF_WORKSHEET								*
 *	Jasmine 04/13/09 QA80-13444 GET_CORRECT_EXCEL_BOOK_COLUMNS					*
 *	Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE								*
 *	Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ		*
 *	Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
 *------------------------------------------------------------------------------*/
#ifndef _PAGE_CONTTROL_H
#define _PAGE_CONTTROL_H

//enum {PEPAGE_LONGNAME, PEPAGE_SHORTNAME, PAGEG_SHEET_NAME, PEPAGE_N_COLS, PEPAGE_N_ROWS, PEPAGE_FILEPATH, PEPAGE_FILENAME, PEPAGE_FILEDATE, PEPAGE_PATH, PEPAGE_CREATED, PEPAGE_MODIFIED, PEPAGE_TOTAL_COLS};
//#define PAGE_LIST_COL_HEADER		"Long Name|Book|Sheet|Cols|Rows|File Path|File Name|File Date|Folder|Created|Modified"
enum {PEPAGE_LONGNAME, PEPAGE_SHORTNAME, PAGEG_SHEET_NAME, PEPAGE_N_COLS, PEPAGE_N_ROWS, PEPAGE_FILEPATH, PEPAGE_FILENAME, PEPAGE_FILEDATE, PEPAGE_PATH, PEPAGE_CREATED, PEPAGE_MODIFIED, PEPAGE_TOTAL_COLS};
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
#ifndef _CAT
#define _CAT "PEObject"
#endif
#define PAGE_LIST_COL_HEADER _LC("Long Name|Book|Sheet|Cols|Rows|File Path|File Name|File Date|Folder|Created|Modified", _CAT)
//------ End COLUMN_HEADING_LOCALIZE
//enum {PEPAGE_LONGNAME, PEPAGE_SHORTNAME, PEPAGE_TYPE,PEPAGE_VIEW, PEPAGE_SIZE,PEPAGE_TOTAL_COLS};
//#define PAGE_LIST_COL_HEADER		"Long Name|Short Name|Type|View|Size"
///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
enum {
	PLIST_INCLUDE_SHORTCUT 		=	0x0001,
	PLIST_INCLUDE_SHORTCUT_ONLY =	0x0002,
	///------ Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
	PLIST_UPDATE_EXCEL_TO_ORIGIN=	0x0004,
	///------ End ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
};
///End OPTION_TO_GET_PAGE

class PageListControl : public GridListControl
{
/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
#define FORCE_RETRIEVE_PAGE_INFO					m_vbUseLastPageInfo = false;

#define CHECK_RETURN_LAST_PAGE_INFO(_nColType)	\
	if ( m_vbUseLastPageInfo[_nColType] )\
		return m_vsLastPageInfo[_nColType];

#define SAVE_AND_RETURN_LAST_PAGE_INFO(_nColType, _strPageInfo)		\
	m_vbUseLastPageInfo[_nColType] = true;\
	m_vsLastPageInfo[_nColType] = _strPageInfo;\
	return m_vsLastPageInfo[_nColType];

#define CHECK_RETURN_PAGE_INFO(_nColType, _strPageInfo)	\
	CHECK_RETURN_LAST_PAGE_INFO(_nColType)\
	SAVE_AND_RETURN_LAST_PAGE_INFO(_nColType, _strPageInfo);
/// End QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ

	PageListControl()
	{
		m_bShowWksLayers = false;
		// must match enum {PEPAGE_NAME, PEPAGE_LABEL,
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray("Long Name|Book|Sheet|Cols|Rows|File Path|File Name|File Date|Folder|Created|Modified", m_vsColHeadings, "PEPages");
		GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE

		/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
		m_vsLastPageInfo.SetSize(PEPAGE_TOTAL_COLS);
		m_vbUseLastPageInfo.SetSize(PEPAGE_TOTAL_COLS);
		FORCE_RETRIEVE_PAGE_INFO
		/// End QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
	}
	
public:
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, bool bShowWksLayers = true)
	{
		m_bShowWksLayers = bShowWksLayers;
		m_strDlgName = lpcszDlgName;
		vector<byte> vbDefaultShowCols = {0,1,0,0,0,1,0,0,1,0,0};		
		GridListControl::Init(nID, dlg);
		/*
		if(m_bShowWksLayers)
		{
			m_flx.OutlineCol = 0;
			m_flx.OutlineBar = flexOutlineBarSimpleLeaf;
		}
		*/
		m_flx.Cols = PEPAGE_TOTAL_COLS;
		m_flx.FormatString = makeColHeadings();
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;
		m_flx.ExplorerBar = flexExSortShow;
		m_flx.Ellipsis = flexEllipsisPath;// if str too long, show ... in the middle
		LoadHideCols(m_strDlgName, "PageListHideShowCols", &vbDefaultShowCols);
		/*
		if(m_bShowWksLayers)
			HideCol(PEPAGE_OUTLINE, false);
		else
			HideCol(PEPAGE_OUTLINE, true);
		*/
	}
	//virtual 
	string GetRuntimeClass()
	{
		return "PageListControl";
	}
	BOOL OnDestroy()
	{
		SaveHideCols();
		return TRUE;
	}
protected:
	void ResizeCols(int nMaxColSizeFactor = 0, int nExtraPixcels = 8)
	{
		GridListControl::ResizeCols(nMaxColSizeFactor, nExtraPixcels);
		//if(m_bShowWksLayers)
		//	m_flx.ColWidth(PEPAGE_OUTLINE) = PixelsToTwips(13);
		
	}
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	//void AddAllWksPages()
	void AddAllWksPages(DWORD dwOption = 0)//reseve
	///End OPTION_TO_GET_PAGE
	{
		foreach(WorksheetPage wkspg in Project.WorksheetPages)
		{
			///------ Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
			if ( O_QUERY_BOOL(dwOption, PLIST_UPDATE_EXCEL_TO_ORIGIN) && EXIST_EXTERN_WKS == wkspg.GetType() )
			{
				wkspg.UpdateOrigin(WKSPAGEUPDATEORIGIN_NO_COPY_DATA);
			}
			///------ End ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
			//m_flx.AddItem(makeRow(wkspg));
			addWksPage(wkspg);
		}	
	}
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	//void AddProjectMatrixPages()
	void AddProjectMatrixPages(DWORD dwOption = 0)
	///End OPTION_TO_GET_PAGE
	{
		foreach(MatrixPage mpg in Project.MatrixPages)
		{			
			//m_flx.AddItem(makeRow(mpg));
			AddPage(mpg, EXIST_MATRIX);
		}
		
		return;
	}
	///Jasmine 07/31/09 QA80-14022 OPTION_TO_GET_PAGE
	//void AddPages(Folder fldr, int nPageType = 0)
	void AddPages(Folder fldr, int nPageType = 0, DWORD dwOption = 0)
	{	 
		Collection<PageBase> cPages;
		if(dwOption & PLIST_INCLUDE_SHORTCUT)
			cPages = fldr.PagesAndShortcuts;
		else
			cPages = fldr.Pages;
		///End OPTION_TO_GET_PAGE
		
		foreach(PageBase page in cPages)
		{	
			if(dwOption & PLIST_INCLUDE_SHORTCUT_ONLY)
			{
				DWORD dw = page.GetStatus(fldr);
				if( !(dw & PBFS_SHORTCUT) )
					continue;
			}
		
			if(nPageType && page.GetType() != nPageType)
			{
				///Jasmine 04/13/09 EXCEL_IS_A_KIND_OF_WORKSHEET
				if( !isWksPageType( page.GetType() ) || !isWksPageType(nPageType) )
					continue;
				///End EXCEL_IS_A_KIND_OF_WORKSHEET
			}

			///------ Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
			if ( O_QUERY_BOOL(dwOption, PLIST_UPDATE_EXCEL_TO_ORIGIN) && EXIST_EXTERN_WKS == page.GetType() )
			{
				WorksheetPage		wksPage(page);
				wksPage.UpdateOrigin(WKSPAGEUPDATEORIGIN_NO_COPY_DATA);
			}
			///------ End ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
			
			//m_flx.AddItem(makeRow(page));
			AddPage(page, page.GetType());
		}
	}
	bool AddPage(PageBase pg, int nPageType)
	{
		if(isWksPageType(nPageType) || EXIST_MATRIX == nPageType)
			return addWksPage(pg);
		
		if(pg)
		{
			FORCE_RETRIEVE_PAGE_INFO;	/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
			m_flx.AddItem(makeRow(pg));
			SetCellIcon(m_flx.Rows - 1, 0, getDisplayIdFromPageID(pg.GetType()), MODULE_ORIGIN);//TD 3-30-04
			return true;
		}
		return false;
	}
	
	int CountPageByType(Collection<PageBase> pages, int nPageType)
	{
		if(!pages)
			return -1;

		int nCount = 0;
		foreach(PageBase page in pages)
		{
			if(nPageType && page.GetType() != nPageType)
			{
				if( !isWksPageType( page.GetType() ) || !isWksPageType(nPageType) )
					continue;
			}
			nCount++;
		}
		
		return nCount;
	}
	
	bool GetSpecifiedItems(vector<string>& vsWksNames, const vector<uint>& vnRows)
	{
		vsWksNames.SetSize(0);
		string strPage, strSheet;
		if(vnRows && vnRows.GetSize() > 0)
		{
			for(int ii = 0; ii < vnRows.GetSize(); ii++)
			{
				strPage = GetCell(flexcpText, vnRows[ii], PEPAGE_SHORTNAME);
				strSheet = GetCell(flexcpText, vnRows[ii], PAGEG_SHEET_NAME);
				///Jasmine 03/28/07 QA70-6714 USE_LONG_NAME_FOR_LOOSEDATASET, Loose dataset has no page or sheet name
				//vsWksNames.Add(make_book_sheet_name(strPage, strSheet));
				string strWksName = make_book_sheet_name(strPage, strSheet);
				if(strPage.IsEmpty() && strSheet.IsEmpty())
					strWksName = GetCell(flexcpText, vnRows[ii], PEPAGE_LONGNAME);
				vsWksNames.Add(strWksName);
				///End USE_LONG_NAME_FOR_LOOSEDATASET

				///Jasmine 04/13/09 QA80-13444 GET_CORRECT_EXCEL_BOOK_COLUMNS
				Worksheet wks(strWksName);
				if(wks && wks.GetPage().GetType() == EXIST_EXTERN_WKS)
					wks.UpdateOrigin();
				///End GET_CORRECT_EXCEL_BOOK_COLUMNS
			}
			return true;
		}
		return false;
	}
	
	bool GetSelItems(vector<string>& vsWksNames)
	{
		vector<uint> vnRows;
		if(GetSelRows(vnRows))
		{
			return GetSpecifiedItems(vsWksNames, vnRows);
		}
		return false;
	}
private:
	/// TD 3-30-04 QA70-6053 PICTURE_IN_OC
	int getDisplayIdFromPageID(int nPageId)
	{
	switch(nPageId)
		{
		case EXIST_GRAPH:
			return IDR_GRAPHTYPE_V8;
		case EXIST_WKS:
			return IDR_WORKSHEETTYPE_V8;
		case EXIST_NOTES:
			return IDR_NOTESTYPE;
		case EXIST_EXTERN_WKS:
			return IDR_EXCELTYPE;
		case EXIST_MATRIX:
			return IDR_MATRIXTYPE_V8;
		case EXIST_LAYOUT:
			return IDR_LAYOUTTYPE;
		};
		return IDI_FOLDER_CLOSED;

	}
	/// end PICTURE_IN_OC

	bool addWksPage(Page wpg)
	{
		if(!wpg)
			return false;
		int nPageType = wpg.GetType();
		int nLayers = numDataSheets(wpg);
		FORCE_RETRIEVE_PAGE_INFO		/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
		for(int ii = 0; ii < nLayers; ii++)
		{
			m_flx.AddItem(makeRow(wpg, ii));
			SetCellIcon(m_flx.Rows - 1, 0, getDisplayIdFromPageID(nPageType), MODULE_ORIGIN);//TD 3-30-04
		}
		return true;
	}
	string 	getPageSystemInfo(PageBase pg, int nType)
	{
		string str;
		PageSystemInfo	PgInfo;
		pg.GetPageSystemInfo(&PgInfo);
		switch(nType)
		{
		case PEPAGE_MODIFIED:
			str = get_date_str(PgInfo.dModified);
			break;
		case PEPAGE_CREATED:
			str = get_date_str(PgInfo.dCreated);
			break;			
		}
		return str;
	}
	// nLayer >= 0 if wks layer row
	///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
	//string makeCol(PageBase pgbase, int nColType, int nLayer = -1)
	string makeCol(PageBase pg, int nColType, int nLayer = -1)
	///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
	{
		///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
		//Page pg = pgbase;	///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
		Page page = pg;
		///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	

		string strTemp;
		switch(nColType)
		{
	//	case PEPAGE_OUTLINE:
	//		return strTemp;
		case PAGEG_SHEET_NAME:
			if(nLayer >= 0)
			{
				///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				//Datasheet wks = pg.Layers(nLayer);
				Datasheet wks = page.Layers(nLayer);
				///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				wks.GetName(strTemp);
				//---- CPY 7/29/06 PLOTSETUP_EMPTY_LAYER_NAME_NEED_USE_INDEX
				if(strTemp.IsEmpty())
					strTemp.Format("%d", 1 + nLayer);
				//----
			}
			break;
		/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
/*
		case PEPAGE_SHORTNAME:
			return pg.GetName();
		case PEPAGE_LONGNAME: // long name, if label empty, use tagName
			return page_get_display_name(pg);
		case PEPAGE_PATH:
			//if(nLayer < 0)	///Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO
			{
				Folder fld = pg.GetFolder();
				if(fld)
					strTemp = fld.GetPath();
				return strTemp;
			}
			break;
*/
		case PEPAGE_SHORTNAME:
			CHECK_RETURN_PAGE_INFO( nColType, pg.GetName() );
		case PEPAGE_LONGNAME: // long name, if label empty, use tagName
			CHECK_RETURN_PAGE_INFO( nColType, page_get_display_name(pg) );
		case PEPAGE_PATH:
			CHECK_RETURN_LAST_PAGE_INFO( nColType );
			{
				Folder fld = pg.GetFolder();
				if(fld)
					strTemp = fld.GetPath();
				SAVE_AND_RETURN_LAST_PAGE_INFO( nColType, strTemp );
			}
			break;
		/// End QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
		case PEPAGE_N_COLS:
			if(numDataSheets(pg))
			{
				///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				//Datasheet wks = pg.Layers(nLayer);
				Datasheet wks = page.Layers(nLayer);
				///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				if(wks)
					strTemp = wks.GetNumCols();
				return strTemp;
			}
			break;
		case PEPAGE_N_ROWS:
			if(numDataSheets(pg))
			{
				///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				//Datasheet wks = pg.Layers(nLayer);
				Datasheet wks = page.Layers(nLayer);
				///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
				if(wks)
					strTemp = wks.GetNumRows();
				return strTemp;
			}
			break;
		case PEPAGE_MODIFIED:
		case PEPAGE_CREATED:
			//if(nLayer < 0)	///Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO
			/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
				//return getPageSystemInfo(pg, nColType);
			CHECK_RETURN_PAGE_INFO( nColType, getPageSystemInfo(pg, nColType) );
			/// End QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
			break;
		///Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO
		case PEPAGE_FILEPATH:
		case PEPAGE_FILENAME:
		case PEPAGE_FILEDATE:
			CHECK_RETURN_LAST_PAGE_INFO( nColType );	/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
			if(pg)
			{
				if(nLayer < 0)
					strTemp = getPageImportInfo(pg, nColType);
				else
					strTemp = getSheetImportInfo(pg, nLayer, nColType);
				SAVE_AND_RETURN_LAST_PAGE_INFO( nColType, strTemp );	/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
			}
			break;
		///End 80_NEED_SHEET_LEVEL_INFO
		default:
			break;
		}
		///Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO
		//if(pg && nLayer < 0)
		//	return getPageImportInfo(pg, nColType);
		///End 80_NEED_SHEET_LEVEL_INFO
		
		return strTemp;// return empty
	}
	string makeRow(PageBase wkspg, int nLayer = -1)
	{
		string	str;// = wkspg.GetName() + "\t" + wkspg.Label;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += makeCol(wkspg, ii, nLayer);
			if(ii < nCols -1)
				str += "\t";
		}
		return str;
	}
	///-----Frank 5/27/05	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
	//string getPageImportInfo(Page wkspg, int nType)
	string getPageImportInfo(PageBase wkspg, int nType)
	///-----End	PAGE_LIST_SUPPORT_SUBFOLDER_AND_NOTE_PAGE	
	{
		string str;
		storage st;
		st = wkspg.GetStorage("System");
		if(st)
		{
			Tree trTemp;
			if(st.GetSection("Import", trTemp) && trTemp.FilePath.IsValid())
			{
				switch(nType)
				{
				case PEPAGE_FILEPATH:
					str = GetFilePath(trTemp.FilePath.strVal);
					break;
				case PEPAGE_FILENAME:
					str = trTemp.FileName.strVal;
					break;
				case PEPAGE_FILEDATE:
					if(trTemp.FileDate.IsValid()) // this was added later, so need to check, the other two added together
					{
						double dateVal = trTemp.FileDate.dVal;
						str = get_date_str(dateVal, LDF_SHORT);
					}
					break;
				}
			}
		}
		return str;
	}
	
	///Jasmine 01/23/09 80_NEED_SHEET_LEVEL_INFO
	string getSheetImportInfo(PageBase wkspg, int nLayer, int nType)
	{
		if(nLayer < 0)
			return "";
		
		Page pg = wkspg;
		if(!pg)
			return "";
		
		Datasheet ds = pg.Layers(nLayer); 
		if(!ds)
			return "";
		
		Tree 		trFile;
		int 		nErrCode = CER_NO_ERROR;
		DataRange 	dr;
		dr.Add(ds);
		
		///Jasmine 04/08/09 CHECK_STORAGE_TO_AVOID_OUTPUT_JUNK_ERROR_MSG
		//int nFile = get_file_info_by_range(trFile, dr, &nErrCode);
		if( !tree_get_binary_storage(trFile, pg, IFI_BINARY_STORAGE_NAME) )
			return "";
		get_file_info_by_range(trFile, dr, &nErrCode);
		///End CHECK_STORAGE_TO_AVOID_OUTPUT_JUNK_ERROR_MSG
		if(nErrCode != CER_NO_ERROR)
			return "";
		
		string str;
		switch(nType)
		{
		case PEPAGE_FILEPATH:
			str = GetFilePath(trFile.Info.FilePath.strVal);
			break;
		case PEPAGE_FILENAME:
			str = trFile.Info.FileName.strVal;
			break;
		case PEPAGE_FILEDATE:
			if(trFile.Info.FileDate.IsValid()) // this was added later, so need to check, the other two added together
			{
				double dateVal = trFile.Info.FileDate.dVal;
				str = get_date_str(dateVal, LDF_SHORT);
			}
			break;
		}
		
		return str;
	}
	///End 80_NEED_SHEET_LEVEL_INFO
	
	string makeColHeadings()
	{
		string str;
		int	nCols = m_vsColHeadings.GetSize();
		for(int ii = 0; ii < nCols; ii++)
		{
			str += m_vsColHeadings[ii];
			if(ii < nCols -1)
				str += "|";
		}
		return str;
	}
	bool isWksPageType(int nPageType)
	{
		if(EXIST_WKS == nPageType || EXIST_EXTERN_WKS == nPageType)
			return true;
		
		return false;
	}
	int numDataSheets(PageBase pgb)
	{
		if(!pgb)
			return 0;
		int nPageType = pgb.GetType();
		
		if(EXIST_MATRIX == nPageType)
		{
			MatrixPage mpg = pgb;
			int nLayers = mpg.Layers.Count();
			return nLayers;
		}
		if(isWksPageType(nPageType))
		{
			WorksheetPage wpg = pgb;
			int nLayers = wpg.Layers.Count();
			//if(nLayers > 0)
			//	printf("wks %s has %d sheets\n", wpg.GetName(), nLayers);
			return nLayers;
		}
		return 0;
	}
		
private:
	vector<string>	m_vsColHeadings;
	string			m_strDlgName;
	bool			m_bShowWksLayers;
	/// Kenny 11/06/2009 QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
	vector<string>	m_vsLastPageInfo;
	vector<bool>	m_vbUseLastPageInfo;
	/// End QA81-14608 PLOT_SETUP_TOO_SLOW_WHILE_LOADING_LARGE_PRJ
protected:
	int				m_nNameCol;
};

#endif //_PAGE_CONTTROL_H

