/*------------------------------------------------------------------------------*
 * File Name:PMSplitter, Presentation Manager Splitter Window					*
 * Creation: CPY Feb 23 2004													*
 * Purpose: A Splitter Control that represent the Presentation Manager			*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY							*
 *------------------------------------------------------------------------------*/
#ifndef _PM_SPLITTER_H
#define _PM_SPLITTER_H

class PresentationList : public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridListControl::Init(nID, dlg);
		m_nId = nID;
		m_flx.Cols = 2;
		m_flx.FixedCols = 0;//hide the Row heading
	}
private:
	int m_nId; // child ID of control

};

class PresentationContents :  public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridListControl::Init(nID, dlg);
		m_nId = nID;
		m_flx.Cols = 3;
		m_flx.FixedCols = 1;//need fixed col for drag and drop
		m_flx.ExplorerBar = flexExMoveRows;
	}
private:
	int m_nId; // child ID of control

};

// a splitter control to manage the list of Presentations
// in an OPJ
// on the left is the Presentation List (m_PMList)
// on the right is the Presentation itsetl (m_PMItem)
//
class PMSplitter : public SplitterControl
{
private:
	
public:
	PMSplitter()
	{
		m_bReady = false;
		SetGridSize(1,2);
		// control ID for panes
		// Must init these IDs before calls to InitMsgMap
		SetGridSize(1,2);
		m_PMListID = GetDlgCtrlID();
		m_PMContentsID = GetDlgCtrlID(0,1);
		InitMsgMap();
	}
	void Init(int nCntrlID, WndContainer& wndParent, LPCSTR lpcszDlgName)
	{
		SplitterControl::Init(nCntrlID, wndParent, 0, lpcszDlgName);
		Visible = true;
	}
	///Jasmine 10/28/05 v8.0324 SPLITTER_INIT_SIZE_ON_READY
	void OnReady()
	{
		SplitterControl::OnReady();
	}
	///End SPLITTER_INIT_SIZE_ON_READY
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)

	ON_GRID_ROW_COL_CHANGE(m_PMListID, OnRowColChange)

EVENTS_END
	BOOL OnInitDialog()
	{
		GUID clsid; // later, for now, only vsFlex
		CreateActiveXPane(clsid);
		m_PMList.Init(m_PMListID, *this);
		
		CreateActiveXPane(clsid, 0, 1);
		m_PMContents.Init(m_PMContentsID, *this);
		
		SetReady();
		m_bReady = true;
		return TRUE;
	}
	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		SplitterControl::OnResize(nType, cx, cy);
		return TRUE;
	}
	void OnRowColChange(Control cntrl)
	{
		if(!m_bReady)
			return;
		out_str("PM list sel change");
	}	
		
private:
	bool		m_bReady;
	PresentationList  		m_PMList;
	PresentationContents  	m_PMContents;
	int			m_PMListID;
	int			m_PMContentsID;
	
	Tree		m_trPM;
};

#endif //_PM_SPLITTER_H


