/*------------------------------------------------------------------------------*
 * File Name: 																	*
 * Creation: Sandy 05-29-2008													*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 09/02/08 STORE_PEAK_FIT_HELPER_POINTER_IN_PA_WIZ_CORE				*
 *  Sandy 2008-9-5 ADD_LOCAL_BASELINE											*
 *	Kyle 09/26/08 ADD_FUNCTION_TO_SET_AND_GET_THE_STATUS_OF_FINISH_BUTTON_CLICKED
 *	Folger 10/15/08 NEED_TO_KNOW_IF_THERE_IS_BASELINE_IN_PEAK_FITTING			*
 *	Folger 10/16/08 SAVE_PLOT_UIDS_IN_PA_CORE_TO_WORKAROUND_MISSING_PREVIEW_PLOT_IN_PA_FIT
 *	Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
 *  Sandy 2008-11-4 QA80-12518 v8.0965 BRING_BACK_SPECIAL_BASELINE				*
 *	Sophy 11/10/2008 CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE				*
 *	Sophy 11/12/2008 SUPPORT_USE_EXISTING_DATARANGE_AS_BASELINE_IN_NEW_PA		*
 *	Folger 11/12/08 QA80-12488 v8.0969 PA_FITTING_AUTO_UPDATE_SUPPORT			*
 *	Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5							*
 *	Kyle 11/17/2008 SUBTRACTED_DATA_IS_STORED_IN_TEMPORARY_WORKSHEET			*
 *	Jasmine 11/17/08 v8.0973 CENTRALIZE_FIT_CODE_TO_SHARE_WITH_NANOSIZER		*
 *  Iris 11/18/2008 PA_FIT_SUPPORT_NEW_BASELINE_MODE_XPS						*
 *  Iris 12/02/2008 v8.0981b QA80-12701 FIX_BACK_TO_BASECREATE_NOT_KEEP_BASELINE_FUNC_IF_CHANGE_FUNC_IN_FITPEAK*
 *	Folger 12/03/08 v8.0982 CHECK_CREATE_BASELINE_SHOULD_BE_MEMBER_OF_PAWIZCORE	*
 *	Folger 12/03/08 QA80-12701 v8.0982 THEME_SETTING_CONTROL_FOR_BASELINE_FUNCTION_APPLIED_IN_PA_FIT
 *	Sim 12-04-2008 IMPROVE_XF_WIZ_FRAMEWORK										*
 *	Folger 12/11/08 QA80-12765 v8.0985 CHANGE_PARAMETER_FAILS_TO_REMEMBER_SETTINGS_FROM_LAST_CLOSE_IN_PA_FITTING
 *	Folger 12/30/08 v8.0992 NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK				*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE				*
 *	Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL										*
 *	Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
 *	Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
 *	Jasmine 04/24/09 DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE				*
 *	Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT								*
 *	Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT							*
 *	Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
 *	Folger 09/05/09 FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA
 *	Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT						*
 *	Folger 03/05/2011 ORG-247-P1 PA_PAK_CENTER_DATA_SHOULD_COPY_SOURCE_DATA_FORMAT
 *	Folger 04/06/2011 ORG-2594-P1 PA_FIT_WEIGHT_DATA_SHOULD_HAVE_SAME_FLYOUT_AS_BASELINE_EXISTING_DATA
 *	Kyle 08/10/2011 ORG-3052 ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
 *	Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
 *------------------------------------------------------------------------------*/

#ifndef __PA_WIZ_CORE_H__
#define __PA_WIZ_CORE_H__

#include <..\OriginLab\XFWizManager.h> ///---Sim 12-09-2008 IMPROVE_XF_WIZ_FRAMEWORK
//---Jasmine 11/17/08 v8.0973 CENTRALIZE_FIT_CODE_TO_SHARE_WITH_NANOSIZER
//#include <..\OriginLab\XFCore.h>
#include <..\OriginLab\FitWizCoreBase.h>	
//---
#include <..\OriginLab\pa_utils.h>

#define STR_PA_XFNAME_GOAL 				"pa_goal"
#define STR_PA_XFNAME_BASEMODE 			"pa_basemode"
#define STR_PA_XFNAME_BASECREATE 		"pa_basecreate"
#define STR_PA_XFNAME_END_POINTS		"pa_epbase"		///Kyle 08/10/2011 ORG-3052 ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
#define STR_PA_XFNAME_BASESUBTR	        "pa_basesubtr"  ///sandy 2008-10-16 add subtract baseline goal
#define STR_PA_XFNAME_BASETREAT 		"pa_basetreat"
#define STR_PA_XFNAME_PEAKS 			"pa_peaks"
#define STR_PA_XFNAME_INT 				"pa_int"
#define STR_PA_XFNAME_FIT 				"pa_fit"


#ifdef PA_WITH_XPS_BASELINE
#define STR_PA_XFNAME_XPS 				"pa_xpsbase"///sandy 2008-11-4 QA80-12518 v8.0965 BRING_BACK_SPECIAL_BASELINE 
#endif

#define STR_LABEL_XFNAME_GOAL			_L("Goal")
#define STR_LABEL_XFNAME_BASEMODE		_L("Baseline Mode")
#define STR_LABEL_XFNAME_BASECREATE		_L("Create Baseline")
#define STR_LABEL_XFNAME_END_POINTS		_L("End Points Weighted Baseline")		///Kyle 08/10/2011 ORG-3052 ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
#define STR_LABEL_XFNAME_BASESUBTR		_L("Subtract Baseline")  ///sandy 2008-10-16 add subtract baseline goal
#define STR_LABEL_XFNAME_BASETREAT		_L("Baseline Treatment")
#define STR_LABEL_XFNAME_PEAK			_L("Find Peaks")
#define STR_LABEL_XFNAME_INT			_L("Integrate Peaks")
#define STR_LABEL_XFNAME_REG			_L("Peak Regions")   //Sandy 2008-9-5 ADD_LOCAL_BASELINE
#define STR_LABEL_XFNAME_FIT			_L("Fit Peaks")

#ifdef PA_WITH_XPS_BASELINE 
#define STR_LABEL_XFNAME_XPS			_L("XPS Baseline")///sandy 2008-11-4 QA80-12518 v8.0965 BRING_BACK_SPECIAL_BASELINE 
/// Iris 11/18/2008 PA_FIT_SUPPORT_NEW_BASELINE_MODE_XPS
#define STR_XPS_METHOD_SHIRLEY			_L("Shirley")
#define STR_XPS_METHOD_TOUGAARD			_L("Tougaard")
///end PA_FIT_SUPPORT_NEW_BASELINE_MODE_XPS
#endif //PA_WITH_XPS_BASELINE

///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
#define STR_LABEL_PA_THEME_SETTING_TITLE	_L("Peak Analyzer Theme Setting")
///---END NEW_PA_81_THEME_FILTER_SETTING


#define	PA_MODIFY_DELETE_CONTEXT_TAGNAME	"Context"
#define	PA_CORE_POINTER_TAGNAME				"PACore"	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG

///Sophy 11/10/2008 CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE moved to PFM_utils.h to share in FitPeak
//#define	STR_INTERP_FUNCTION_LIST	"Line|Spline|BSpline"	///Sophy 10/20/2008 CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE
//#define	STR_BASELINE_PARAM_TREE		"BaselineParamTree"		///Sophy 11/10/2008 CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE
///end CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE

#define STR_BASEFUNC_FROM_BASECREATE_XF_ATTRIB		"BaseFuncFromBaseCreateXF" /// Iris 12/02/2008 v8.0981b QA80-12701 FIX_BACK_TO_BASECREATE_NOT_KEEP_BASELINE_FUNC_IF_CHANGE_FUNC_IN_FITPEAK

#ifndef _PA_FUNC_CATE_INFO
#define _PA_FUNC_CATE_INFO
#define STR_PA_NLSF_CAT_BASELINE		"Baseline"
#define STR_PA_NLSF_CAT_PEAK			"PFW"
#define STR_GAUSSIAN_FUNC			"Gaussian"
#define STR_PA_DEFAULT_FUNC			STR_GAUSSIAN_FUNC
#define STR_PA_DEFAULT_FDF			STR_GAUSSIAN_FUNC
#define IS_DEFAULT_PA_FUNC(_STR)	(lstrcmpi(_STR, STR_PA_DEFAULT_FUNC)==0)
#endif //_PA_FUNC_CATE_INFO


#define STR_PA_MOFIGY_BASELN_TITLE		_L("click one of the red square to edit")
#define STR_PA_MOFIGY_PEAK_TITLE		_L("click one of the red circle to edit")
///Jasmine 02/19/09 PRESS_ENTER_TO_CLOSE_GRAPHDONEDLG

//#define STR_PA_MODIFY_BASE_ANCHORS 		_L("Use keys: Arrow, Del, Tab, Shift-Tab, Home, and End")//Sandy 2008-4-10 SUGGESTED_FROM_NOHO_TECH_GROUP
//#define STR_PA_MODIFY_PEAKS				_L("Drag/Arrow keys=move peak center, Del=delete, TAB Shift-TAB Home End=change peak")	
#define STR_PA_MODIFY_BASE_ANCHORS 		_L("Use keys: Space, Arrow, Del, Tab, Home, End and Enter.")
#define STR_PA_MODIFY_PEAKS				_L("Space=cross-hair size, Drag/Arrow keys=move peak center, Del=delete, TAB Shift-TAB Home End=change peak, Enter=Done")
///End PRESS_ENTER_TO_CLOSE_GRAPHDONEDLG

/// Iris 10/31/2008 V8.0963d MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
#define		_PREVIEW_RESIDUAL_LAYER					"PrevResid"	
#define		_PREVIEW_2ND_DERVIA_LAYER				"Prev2ndDerv"
///end MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE

#define PA_OP_FUNC_NAME			run_pa_wiz
#define STR_PA_OP_FUNC_NAME		"run_pa_wiz"
///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
#define PA_OP_CLASS_NAME		PeakAnalyzer
#define STR_PA_OP_CLASS_NAME	"PeakAnalyzer"
///---END FIX_WIZ_OPERATION_LABEL

//################################## PA theme data ID and TagName#####################
#define STR_GETN_VAR_SHARED_BASE_ANCHORS   			"trAnchorXY"
#define STR_GETN_VAR_SHARED_BASE_ANCHORS_XS 		"Anchor_Xs"
#define STR_GETN_VAR_SHARED_BASE_ANCHORS_YS 		"Anchor_Ys"
#define STR_GETN_VAR_SHARED_BASE_ANCHORS_SNAP 		"snap"
#define STR_GETN_VAR_SHARED_PEAKS_INFO   			"otr"
#define STR_GETN_VAR_SHARED_PEAKS_XC                "xc"
#define STR_GETN_VAR_SHARED_PEAKS_H                 "h"
#define STR_GETN_VAR_SHARED_DERIVATIVE				"derivative" /// Iris 10/31/2008 V8.0963d MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
///------ Folger 02/25/09 QA80-13181 SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING
#define STR_GETN_VAR_SHARED_FIXBASE					"fixbase"
///------ End SHARE_BASELINE_FIX_STATUS_BETWEEN_BASELINE_TREATMENT_AND_FITTING


///Jasmine 04/24/09 DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE, mapping for less modification
#define PA_BASE_ANCHOR_X_DATAID_IN_GETN_TREE       FITWIZ_BASE_ANCHOR_X_DATAID_IN_GETN_TREE
#define PA_BASE_ANCHOR_Y_DATAID_IN_GETN_TREE       FITWIZ_BASE_ANCHOR_Y_DATAID_IN_GETN_TREE

#define PA_PEAK_XC_DATAID_IN_GETN_TREE      	   FITWIZ_PEAK_XC_DATAID_IN_GETN_TREE
#define PA_PEAK_H_DATAID_IN_GETN_TREE              FITWIZ_PEAK_H_DATAID_IN_GETN_TREE

#define	PA_PEAK_FITTING_DATAID_START				FITWIZ_PEAK_FITTING_DATAID_START

#define	PA_PEAK_FITTING_DATAID_RANGE_UID			FITWIZ_PEAK_FITTING_DATAID_RANGE_UID
#define	PA_PEAK_FITTING_DATAID_GRAPH_UID			FITWIZ_PEAK_FITTING_DATAID_GRAPH_UID
///------ Folger 09/05/09 FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA
#define	PA_PEAK_FITTING_DATAID_RESULT_TABLE_UID		FITWIZ_PEAK_FITTING_DATAID_RESULT_TABLE_UID
///------ End FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA

#define	PA_PEAK_FITTING_DATAID_DISABLED_CENTER		FITWIZ_PEAK_FITTING_DATAID_DISABLED_CENTER
#define	PA_PEAK_FITTING_DATAID_DISABLED_HEIGHT		FITWIZ_PEAK_FITTING_DATAID_DISABLED_HEIGHT

#define	PA_PEAK_FITTING_DATAID_BASELINE_FUNCTION	FITWIZ_PEAK_FITTING_DATAID_BASELINE_FUNCTION

#define	PA_PEAK_FITTING_DATAID_FITWORKAREA_BEGIN	FITWIZ_PEAK_FITTING_DATAID_FITWORKAREA_BEGIN
#define	PA_PEAK_FITTING_DATAID_FITWORKAREA_END		FITWIZ_PEAK_FITTING_DATAID_FITWORKAREA_END

#define	PA_PEAK_FITTING_DATAID_END					FITWIZ_PEAK_FITTING_DATAID_END

#define	PA_BASE_CREATE_DATAID_FUNCTION_USING		FITWIZ_BASE_CREATE_DATAID_FUNCTION_USING
///End DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE


///Sandy 2009-1-24 MOVE_FROM_C_FILE_FOR_SHARE_WITH_XF
#ifndef _CAT_PA
#define _CAT_PA "Peak Analyzer"
#endif

#define PA_BASELINE_STR_BUTTON_SUBTRACT _LC("Subtract", _CAT_PA)
#define PA_BASELINE_STR_BUTTON_NO_SUBTRACT _LC("No Subtract", _CAT_PA)
///end MOVE_FROM_C_FILE_FOR_SHARE_WITH_XF

//################################## PAWizCore #####################################
enum
{
	PA_GOAL_INTEGRATE_PEAK = 0,
	PA_GOAL_CREATE_BASELINE,
	PA_GOAL_SUBTRACT_BASELINE,//Sandy add 2008-10-16
	PA_GOAL_FIND_PEAK,
	PA_GOAL_FIT_PEAK,
};
///Sophy 11/10/2008 CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE moved to PFM_utils.h to share in FitPeak
//enum{
	//PA_BM_CONSTANT,
	//PA_BM_USERDEF,
	//PA_BM_USE_EX,
	//PA_BM_LOCAL,
	//
//#if PA_WITH_XPS_BASELINE 
	//PA_BM_XPS,/// Sandy 2008-11-4 QA80-12518 v8.0965 BRING_BACK_SPECIAL_BASELINE	
//#endif
	//
	//PA_BM_None,
//};	
///end CLEAN_CODE_ADD_BASELINE_INFO_TO_REPORT_TABLE
enum{
	PA_UPDATE_LABEL_DATASET =	0x0001,
	PA_UPDATE_LABEL_PLOT =		0x0002,
	PA_UNSHOW_XF_ANCHOR =		0x0004,
};

enum{
	PA_TREE_BASELINE_FIT_INFO = 0,
	PA_TREE_PEAKS_CENTER_INFO,
};

class PeakFitHelper;


//#define STR_PA_CLASS_NAME "PeakAnalyzer"
///---Sim 12-09-2008 IMPROVE_XF_WIZ_FRAMEWORK
//#define STR_PA_CLASS_NAME "PA"   ///Sandy 2008-10-15 fix for no fly out theme
///---END IMPROVE_XF_WIZ_FRAMEWORK
class PAWizCore : public FitWizCoreBase//XFCore	///Jasmine 11/17/08 v8.0973 CENTRALIZE_FIT_CODE_TO_SHARE_WITH_NANOSIZER
{
public:
	PAWizCore();
	~PAWizCore();
	
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	// move to FitWizCoreBase.c
	/*
	//------ Folger 11/12/08 QA80-12488 v8.0969 PA_FITTING_AUTO_UPDATE_SUPPORT
	/// virtual
	bool				Apply();
	//------
	*/
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	
	virtual bool	Done(bool bFinish = true); ///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	///---Sim 12-04-2008 IMPROVE_XF_WIZ_FRAMEWORK
	/*
	virtual bool		GetDefaultSteps(StringArray &saXFNames);
	virtual string		GetClassName();
	virtual bool		GetOPEntry(string &strFile, string &strFunc);
	
	virtual double		GetVersion(); ///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	*/
	///---END IMPROVE_XF_WIZ_FRAMEWORK
	virtual void 		Destroy();

	//------ Folger 12/30/08 v8.0992 NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK
	//bool				GetTargetPage(Page& pg);
	//------ End NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK
	//bool				GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables);
public:
	int 				GetCurrGoal(){return m_nGoal}
	void 				SetGoal(int nGoal){m_nGoal = nGoal}
	void 				ChangeGoal(int nGoal);
	bool				GetSteps(vector<string> &vsXFNames, vector<string> &vsXFLabels);

	//virtual	
	int					GetBaseMode(){return m_nBaseMode}
	void				ChangeBaseMode(int nBaseMode);
	int 				GetBaseModeList(vector<int>& vnBaseModeList, string& strComboList = NULL);
	
	void				SetSubtractedMode(bool bHasSubtracted){m_bHasSubtracted = bHasSubtracted;}
	bool				GetSubtractedMode(){return m_bHasSubtracted;}
	
	void				SetBaselineFitMode(bool bBaselineFitWithPeaks){m_bBaselineFitWithPeaks = bBaselineFitWithPeaks;}
	//virtual
	bool				GetBaselineFitMode(){return m_bBaselineFitWithPeaks;} 
	
	void				SetBaseParamFixMode(bool bFixBaseParam){m_bFixBaseParam = bFixBaseParam;}
	/// virtual			///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	bool				GetBaseParamFixMode(){return m_bFixBaseParam;}
	
	///Sandy  2008-11-22 save existing baseline offset for report usage
	void				SetBaseOffset(double dOffset){m_dOffsetBaseline = dOffset;}
	double				GetBaseOffset(){return m_dOffsetBaseline;}
	///---
	
	///Sandy 2008-9-27 remove since pa_make_baseline_param_tree will add function name as label of root-treenode
	//void				SetBaselineFitFunc(int iBaselineFitFunc){m_iBaselineFitFunc = iBaselineFitFunc;}
	//int					GetBaselineFitFunc(){return m_iBaselineFitFunc;}
	int					GetBaselineFitFunc(string& strFuncName = NULL);//rewrited by sandy for get fitting function from baseline info tree
	
	void				SetInstanceID(int nID){m_nInstanceID = nID}					
	
	bool				GetPreviewLayer(GraphLayer& gl,  bool bSetActive = true);
	/// Iris 11/06/2008 v8.0966b IMPROVE_GET_SOURCE_GRAPH_CODES
	//GraphLayer			GetOriginalGraph(){return  m_glOriginal;} 
	bool				GetSourceGraph(GraphLayer& glSource);
	///end IMPROVE_GET_SOURCE_GRAPH_CODES
	bool    			GetSourceDataPlot(DataPlot& dp); /// Iris 11/01/2008 v8.0964 NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
	
	virtual bool		GetSourceRange(DataRange& drSource);	///Jasmine 11/17/08 v8.0973 CENTRALIZE_FIT_CODE_TO_SHARE_WITH_NANOSIZER

	///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	virtual	BOOL		IsNoInputData();
	///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	
	bool 				OnChangeInputRange(const XYRange& xyOrigin);		///Jasmine 12/30/10 ORG-790 ALLOW_CHANGE_INPUT_DATA_ROW_RANGE
	bool				GetOriginalRange(XYRange& xyOrigin);
	bool				GetBaseAnchorsRange(XYRange& xyAnchors);			
	bool				GetBaselineRange(XYRange& xyBaseline);
	bool 				GetLocalBaselineRange(XYRange& xyLocalBaseline, int nIndex, int& nCurrNum = NULL);//Sandy 2008-9-11 add
	///Sophy 11/12/2008 SUPPORT_USE_EXISTING_DATARANGE_AS_BASELINE_IN_NEW_PA
	bool				GetExistingBaselineRange(XYRange& xyExistBaseline );
	bool				SetExistingBaselineRange(XYRange& xyExistBaseline );
	///end SUPPORT_USE_EXISTING_DATARANGE_AS_BASELINE_IN_NEW_PA
	
	bool				GetSubtractedRange(XYRange& xySubtracted);
	bool				GetPeaksRange(XYRange& xyPeaks);
	/// virtual			///------ Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
	bool				GetPeaksCenterRange(XYRange& xyPeaksCenter);
	bool				GetPeaksMarkerRange(XYRange& xyPeaksMarker);//doing	
	
	///Kyle 11/17/2008 SUBTRACTED_DATA_IS_STORED_IN_TEMPORARY_WORKSHEET
	//bool  				UpdateSubtractedDataToSourcePage(bool bDestroy = false);///Sandy add 2008-10-24	
	///End SUBTRACTED_DATA_IS_STORED_IN_TEMPORARY_WORKSHEET

	/// Iris 11/04/2008 v8.0965b PA_FIT_ADD_INPUT_REPORT_TABLE
	// get iy in pa xfunction and convert to report table, saved in PAWizCore and used in pa_fit xfunction.
	void				SetInputDataTable(const TreeNode& trInputTable);
	bool				GetInputDataTable(TreeNode& trInputTable);
	///end PA_FIT_ADD_INPUT_REPORT_TABLE
	
	enum{
		PA_DR_BASEANCHORS,
		PA_DR_BASELINE,
		PA_DR_SUBTRACTED,
		PA_DR_PEAKSRANGE,
		PA_DR_PEAK_CENTERS,
		PA_DR_PEAK_MARKERS,
		PA_DRS_LOCAL_BASELINE,
	};
	bool				CleanUpContextRange(int nContextRange);
	
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	// move to FitWizBaseCore.c
	//Worksheet	 		CheckGetInterimResult(const string strInterimSheet);
	virtual string		GetTempBookPrefix();
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	
	bool				UpdateInfoTree(TreeNode& tr, int nTreeID, bool bSet);
	
	//------ Folger 09/02/08 STORE_PEAK_FIT_HELPER_POINTER_IN_PA_WIZ_CORE
	//void				SetPeakFitHelper(PeakFitHelper *pPeakFitHelper);
	PeakFitHelper*		CheckGetPeakFitHelper();
	//------ End STORE_PEAK_FIT_HELPER_POINTER_IN_PA_WIZ_CORE
	
	//---Jasmine 11/17/08 v8.0973 CENTRALIZE_FIT_CODE_TO_SHARE_WITH_NANOSIZER
	virtual bool		HasBaseline();		//------ Folger 10/15/08 NEED_TO_KNOW_IF_THERE_IS_BASELINE_IN_PEAK_FITTING
	//---
	void 				SetBaseIntepType(int nType){m_nBaseIntepType = nType}
	int                 GetBaseIntepType(){return m_nBaseIntepType}
	
	///---Sandy 2008-11-18 add for keep this info for report of fitting
	enum{
		PA_XPS_BASELINE_SHIRLEY,
		PA_XPS_BASELINE_TOUGAARD,
	};
	void 				SetXPSMethod(int nMethod){m_nXPSMethod = nMethod}
	int                 GetXPSMethod(){return m_nXPSMethod}
	//---end 
	
	///Kyle 08/10/2011 ORG-3052 ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
	void				SetEndSize(double dEndSize)		{ m_dEndSize = dEndSize; }
	double				GetEndSize()					{ return m_dEndSize; }
	///End ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
	
	void  				SetOriginalRangeToGetN(TreeNode& trInput);
	
	/// Iris 10/31/2008 V8.0963d MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	// 2nd Derivative Preivew relative
	bool 				SetAdditionalLayersName(LPCSTR lpcszLayersName);
	bool 				SetAdditionalLayersShow(LPCSTR lpcszLayersShow);
	bool 				GetAdditionalLayersShow(LPCSTR lpcszLayerName);
	bool 				GetAdditionalLayer(GraphLayer& glAdditional, LPCSTR lpcszLayerName);
	bool 				Update2ndDervitivePreivew();
	///end MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	
	///------ Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
	////------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	//bool				AccessPeakLabelSettings(int& nLabelXYType, bool bGet = true);
	////------
	///------ End NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
	
	void				SetSmoothed2ndDerivative(vector& v2nd){m_v2ndDerivative = v2nd}
	vector&				GetSmoothed2ndDerivative(){return m_v2ndDerivative}
	//------ Folger 12/03/08 v8.0982 CHECK_CREATE_BASELINE_SHOULD_BE_MEMBER_OF_PAWIZCORE
	bool				CheckCreateBaselinePlot(bool bCleanData = true, DataPlot* pBasePlot = NULL);
	//------
	
	///Sandy 2008-12-12 include to pawizcore memeber function
	bool 				UpdatePeaksCenterLabels(bool bShowCenter,  bool bShowLabel, int nLabelXYType, bool bRotateLabel);

	///------ Folger 03/05/2011 ORG-247-P1 PA_PAK_CENTER_DATA_SHOULD_COPY_SOURCE_DATA_FORMAT
	BOOL				CopyReportColumnFormat(TreeNode& trX, TreeNode& trY);
	///------ End PA_PAK_CENTER_DATA_SHOULD_COPY_SOURCE_DATA_FORMAT

	///------ Folger 04/06/2011 ORG-2594-P1 PA_FIT_WEIGHT_DATA_SHOULD_HAVE_SAME_FLYOUT_AS_BASELINE_EXISTING_DATA
	BOOL				UpdateSourceDataRangeInRangeNode(TreeNode& trRange);
	///------ End PA_FIT_WEIGHT_DATA_SHOULD_HAVE_SAME_FLYOUT_AS_BASELINE_EXISTING_DATA

protected:	
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	virtual bool		IsFitStep();
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT

	///------ Folger 03/05/2011 ORG-247-P1 PA_PAK_CENTER_DATA_SHOULD_COPY_SOURCE_DATA_FORMAT
	BOOL				CopySourceFomrat(XYRange& xyDest);
	///------ End PA_PAK_CENTER_DATA_SHOULD_COPY_SOURCE_DATA_FORMAT

private:
	/// Iris 10/31/2008 V8.0963d MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	// 2nd Derivative Preivew relative
	bool 				prepareAdditionalLayerForPreview();
	int 				getNumberAdditionalLayers();
	bool 				getPreviewPageOriginalFormat(GraphPage &gp, GraphLayer &glFitCurve, stLayersGridFormat& stOldFormat);
	int					plotDerivative();
	//bool 				update2ndDervitiveData();//Sandy 2008-11-19 rename only 
	bool 				init2ndDervitiveWks();
	bool 				update2ndDervitiveData(); ///Sandy 2008-11-19 add for allow update derviative after smoothing
	///end MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	

private:
	void 				getDefaultPathsByGoal(StringArray& saXFNames);
	///Sandy 2008-10-16 add insert steps, the insert Steps must leaded by an existing step.
	//void 				removeSteps(const 	vector<string>& vstrRemoveSteps);
	void  				updateSteps(const 	vector<string>& vstrRemoveSteps, const vector<string>& vstrInsertSteps);
	
	void 				putResultToOriginalGraph();
	
	
	
	
private:
	TreeNode			m_trBaselineFitInfo;
	
	TreeNode            m_trPeaksCenterInfo;
	

private:
    int            		m_nGoal;
    int            		m_nBaseMode;
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	// move to FitWizBaseCore.c
 	//int 				m_nInstanceID;
 	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
 	int                 m_nBaseIntepType;        ///Sandy 2008-10-20 add for keep this info to report
 	int					m_nXPSMethod;			 ///Sandy 2008-11-18 add for keep this info for report of fitting
 	//int					m_iBaselineFitFunc;
 	double				m_dEndSize;			///Kyle 08/10/2011 ORG-3052 ADD_MIN_MAX_AND_END_POINTS_WEIGHTED_BASELINE_MODE_TO_PA
 	bool				m_bHasSubtracted;
 	bool				m_bBaselineFitWithPeaks;
 	bool				m_bFixBaseParam;
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	// move to FitWizBaseCore.c
 	//WorksheetPage       m_wpInterim;
 	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	/// Iris 11/06/2008 v8.0966b IMPROVE_GET_SOURCE_GRAPH_CODES, give a better name
 	//GraphLayer			m_glOriginal;
 	GraphLayer			m_glSource;
 	///end IMPROVE_GET_SOURCE_GRAPH_CODES 

	///Sandy  2008-11-22 save existing baseline offset for report usage
	double 				m_dOffsetBaseline;
	
	///Sandy 2008-12-12 add member variables to save label type
	bool 				m_bShowCenter;
	bool 				m_bShowLabel;
	int  				m_nLabelXYType;
	bool 				m_bRotateLabel;
	///end
 	
private:
	XYRange 			m_xySource; ///Sandy 2008-11-4 Iris need a really born input range without any change(after plot)
	XYRange 			m_xyOriginal;
	XYRange 			m_xyBaseAnchors;
	XYRange 			m_xyBaseline;
	XYRange				m_xyExistBaseline;///Sophy 11/12/2008 SUPPORT_USE_EXISTING_DATARANGE_AS_BASELINE_IN_NEW_PA
	XYRange 			m_xySubtracted;
	XYRange 			m_xyPeaks;
	XYRange 			m_xyPeaksCenter;
	XYRange 			m_xyPeaksMarker;
	
	//Worksheet			m_wksOutSubtracted;	///Sandy 2008-11-18 This usage has been removed by kyle
	XYRange				m_xyOutSubtracted;
	
	//preview relative
	/// Iris 10/31/2008 V8.0963d MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	string				m_strLayersName; 
	string				m_strLayersShow;  //string like 0|1|1
	Worksheet			m_wksDerivative;
	///end MOVE_2ND_DERVITIVE_PLOT_CODES_TO_PAWIZCORE
	
	//report relative
	Tree				m_trInputTable; /// Iris 11/04/2008 v8.0965b PA_FIT_ADD_INPUT_REPORT_TABLE
	
	
	//smoothed 2nd derivative data
	vector				m_v2ndDerivative;///Sandy 2008-11-20

private:	
	PeakFitHelper*		m_pPeakFitHelper;
	
};

///------ Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
class PAWizTheme : public XFWizTheme
{
public:
	PAWizTheme();
	///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//virtual int		Update(const TreeNode& trGetN, LPCSTR lpcszXFName, bool bToGetN);
	///---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	
	///---Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	virtual bool		SetTree(const TreeNode& trThemes);
	virtual bool		Load(LPCSTR lpcszThemeName);
	///---END FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	virtual	bool		IsThemeSettingSupported() {return true;}
	virtual string		GetThemeFilterDlgTitle() {return STR_LABEL_PA_THEME_SETTING_TITLE;}
	///---END NEW_PA_81_THEME_FILTER_SETTING

	int				GetGoal(LPCSTR lpcszThemeName = NULL, TreeNode& trThemes = NULL);
	int				GetFittingReportGraphUID(LPCSTR lpcszThemeName = NULL, TreeNode& trThemes = NULL);

protected:
	///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//bool			UpdateSharedValues(TreeNode& trGetN, bool bToGetN);
	///---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	virtual	bool		ConstructThemeFilter(TreeNode& trThemeFilter);
	virtual bool		GetThemeFilterMapIDs(vector<int>& vnGUIID, vector<int>& vnThemeFilterID, TreeNode& trGetN, LPCSTR lpcszXFName);
	///---END NEW_PA_81_THEME_FILTER_SETTING
	///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	virtual bool		ConvertVersion(TreeNode& trThemes);
	///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
	///---Sim 11-17-2008 FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
	void			TrimSharedValueByThemeFilter();
	///---END FIX_SAVE_SHARED_VALUE_ON_PA_WIZ_THEME_TREE
protected:
	///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//StringArray		saSharedList;
	///---END QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	//vector<int>  	vnShareDataID;
};
///------ End SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER

///---Sim 12-09-2008 IMPROVE_XF_WIZ_FRAMEWORK
class PAWizManager : public PeakWizManager
{
public:
	///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
	//PAWizManager(const TreeNode& trThemes = NULL, const TreeNode& trInputsOutputs = NULL, DWORD dwUIDOp = 0);
	PAWizManager(LPCSTR lpcszThemeName = NULL, const XFWizTheme *pXFWizTheme = NULL, const XFWizInputOutputRange *pXFWizIO = NULL, DWORD dwUIDOp = 0);
	///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
public:
	virtual void	Destroy();
	virtual bool	CreatePreview(Page& pg);
protected:
	//virtual double	GetVersion() {return PA_VERSION_NUMBER;}
	virtual double	GetVersion();
	
	//virtual XFCore*						CreateXFCore() 					{ return new PAWizCore; }
	//virtual XFWizTheme*					CreateXFWizTheme() 				{ return new PAWizTheme; }
	//virtual XFWizInputOutputRange*		CreateXFWizInputOutputRange() 	{ return new XFWizInputOutputRange; }
	virtual XFCore*						CreateXFCore();
	virtual XFWizTheme*					CreateXFWizTheme();
	virtual XFWizInputOutputRange*		CreateXFWizInputOutputRange();
 
	//virtual string	GetClassName() { return STR_PA_CLASS_NAME; }
	virtual string	GetClassName();
	///---Sim 12-04-2008 IMPROVE_XF_WIZ_FRAMEWORK
	//virtual bool	GetOPEntry(string &strFile, string &strFunc) { strFile = GetFileName(__FILE__); strFunc = "run_pa_wiz"; return true; }
	///---Sim 02-11-2009 FIX_WIZ_OPERATION_LABEL
	//virtual bool	GetOPEntry(string &strFile, string &strFunc) { strFile = GetFileName("PAWiz.c"); strFunc = "run_pa_wiz"; return true; }
	virtual bool	GetOPEntry(string &strFile, string &strFunc, string &strOPClass) { strFile = GetFileName("PAWiz.c"); strFunc = STR_PA_OP_FUNC_NAME; strOPClass = STR_PA_OP_CLASS_NAME; return true; }
	///---END FIX_WIZ_OPERATION_LABEL
	///---END IMPROVE_XF_WIZ_FRAMEWORK
	
protected:
	GraphPage m_gpPreview;
};
///---END IMPROVE_XF_WIZ_FRAMEWORK


//################################## Until-functions #####################################

///Sandy 2008-12-30  centralize code for share code in create baseline mode(xps and create baseline, greg's suggestion)
void    output_baseline_if_create_baseline(XYRange& iy, XYRange oyb, PAWizCore* paCore,  vector& vbx, vector& vby);
void    process_create_baseline_before_execute(TreeNode trGetN, DWORD dwCntrl, PAWizCore* paCore);
bool	process_create_baseline_handler(TreeNode trGetN, int nEventID,LPCSTR lpcszNodeName, PAWizCore * paCore);
//end


///---Sim 12-04-2008 IMPROVE_XF_WIZ_FRAMEWORK
//int 		run_pa_nodlg(TreeNode &tnWizTheme = NULL, TreeNode &tnWizIOs = NULL, DWORD dwOPUID = 0);
//int			run_pa_dlg(TreeNode &tnWizTheme = NULL, TreeNode &tnWizIOs = NULL, DWORD dwOPUID = 0);
///---END IMPROVE_XF_WIZ_FRAMEWORK

//int 		get_all_steps_from_wizard_navigation(StringArray &saXFNames, XFWizNavigation *pXFWizNavg);

///Sandy 2008-9-12 get plot need verify plot type if there are multiple plots of xyrange, default  -1 is means get the first plot found.
//bool		get_plot_from_xyr_in_gl(GraphLayer gl, XYRange& xy, DataPlot& dp);///should move to graph_utils.h later
///------ Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
//bool		get_plot_from_xyr_in_gl(GraphLayer gl, XYRange& xy,  DataPlot& dp, int nPlotType = -1);
///------ End NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT

///Sandy 2008-11-18 should move outside later
void	remap_combo_indexes(TreeNode& trCombo, vector<int>& vnIndexes);


typedef enum tagMODIFYDELETECONTEXT
{
	MDC_BASELINE = 1,
	MDC_PEAKS,
	MDC_FITPEAKS,
}	MODIFYDELETECONTEXT;

bool		anchors_to_tree(vector& vebx, vector& veby, TreeNode& tr, bool bSetToTree = true);

///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
//bool 	   	attach_anchors_on_dataplot(DataPlot dp, int nContext = MDC_BASELINE);
bool 	   	attach_anchors_on_dataplot(PAWizCore * paCore, DataPlot dp, int nContext = MDC_BASELINE);
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG

bool	   	unattach_anchors_on_dataplot(DataPlot dp);

bool 	   	resume_anchor_plot_after_modify_done(PAWizCore * paCore,   bool bForceDialogShow = true);

///Sandy 2008-10-14 move to member function
/////Sandy 2008-10-14 clean baseline and anchor data together.
////void       	clean_up_baseline_anchors_data(PAWizCore * paCore);
//void   		clean_up_baseline_data(PAWizCore * paCore);
//
/////Sandy 2008-10-14 need clean peaks range and peak centers range together.
//void   		clean_up_peaks_data(PAWizCore * paCore);

//------ Folger 12/03/08 v8.0982 CHECK_CREATE_BASELINE_SHOULD_BE_MEMBER_OF_PAWIZCORE
//bool	   	create_baseline_plot(PAWizCore *paCore, bool bCleanData = true);
//------

bool	   	create_anchor_plot(PAWizCore *paCore, TreeNode& trBranch, bool bFromTree = true);

//bool		create_subtracted_plot(PAWizCore *paCore, bool bUndo);///Sandy 2009-3-6  RYAN_SUGGEST_RESCALE_SAVE_TO_THEME
bool		create_subtracted_plot(PAWizCore *paCore, bool bUndo, bool bRescale = false);

bool		peaks_center_to_tree(const TreeNode& tr, vector& vxc, vector& vh, bool bSetToTree = true);

//bool 		create_peaks_labels_plot(PAWizCore* paCore, int nLabelXYType, bool bShowLabel,  bool bRotateLabel, bool bShowCenter);

bool        clear_peaks_labels_plot(PAWizCore* paCore);

///-------Sandy 2008-12-12 include to pawizcore memeber function
//bool 		update_peaks_center_label(PAWizCore* paCore, bool bShowCenter, bool bShowLabel, int nLabelXYType, bool bRotateLabel );

bool 		pa_keep_dataplot_style_during_wiz(DataPlot& dp, TreeNode& trPlot);
bool 		pa_create_dataplot_with_style_during_wiz(XYRange& xy, GraphLayer& gl, DataPlot& dp, TreeNode& trFormat, bool bRemoveAllExisted = true);

bool 		xf_get_data_vectors_from_xyrange_treenode(TreeNode& trInput, vector& vx, vector& vy, string& strErrMsg = NULL);

bool       	pa_vParams2tr(vector& vParams, TreeNode& trParams, vector<string>& vsParamsName = NULL);

bool	   	pa_tr2vParams(TreeNode& trParams, vector& vParams, vector<string>& vsParamsName = NULL);

bool 	   	pa_make_baseline_param_tree(TreeNode& treeParams, string strFuncName, vector& vParams);

int 		get_find_peaks_xf_error_code(int nOCMathErr);

bool 		store_peak_info(LPCSTR lpcszFile, bool bSave, vector& vxc, vector& vh);

bool 		get_peaks_ascending_data_from_pacore(PAWizCore* paCore, vector& vx, vector& vy, XYRange& xy = NULL);

bool 		resume_peaks_centers_plot_after_modify_done(PAWizCore * paCore, TreeNode& trPeaksVector, bool bUpdate = true, bool bForceDialogShow = true);
enum
{
	STR_BTN_ADD,
	STR_BTN_MODIFY,
	STR_BTN_CLEARALL,

};
bool 	   	modify_baseline_points_buttons(PAWizCore* paCore, int nButtonID);

bool        modify_peaks_centers_buttons(PAWizCore* paCore, TreeNode& trPeakVectors, TreeNode& trDisablePeakVectors, int nButtonID, bool bAttachAnchorsOnPlotOnly = false);

bool		create_baseline_table(PAWizCore* paCore, ReportData& rd_baseline);

bool    	create_peak_center_table(PAWizCore* paCore, ReportData& rd_peakcenter);

bool    	create_peak_marker_table(PAWizCore* paCore, ReportData& rd_peakmarker);

///Sandy  2008-9-4 ADD_UTIL_FUNC_construct_tree_from_xyrange_FOR_FITTING
bool 		construct_GUI_from_operation(TreeNode& trOp, TreeNode& tr, LPCSTR lpcszVarName);



#endif		//__PA_WIZ_CORE_H__
