/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Header file													*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 07-16-2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6								*
 *	Sophy 7/17/2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6							*
 *------------------------------------------------------------------------------*/
 
#ifndef PA_THEME_CONVERT_H
#define PA_THEME_CONVERT_H

///////////////////////////////////////////////////////////////////////////////////////////////////////////
class ThemeElementConverter
{
protected:
	int				GetIDFromTagName(LPCSTR lpcszTagName);
	string			GetTagNameFromID(int ID);	
};

class ThemeIDConverter : public ThemeElementConverter
{
public:
	ThemeIDConverter(){ m_bKeepIfNotInTable = false; }
	int				Convert(TreeNode& trThemeTree); // trThemeTree is specified single xf theme tree

protected:
	int				GetDestID(int nID);
	
	int				AddIDs(TreeNode& trThemeTree); // return 0 for success

protected:
	vector<uint>	m_vnSourceID; //old node ID before SR5
	vector<uint>	m_vnDestID; //new node ID in SR5
	vector<byte>	m_vbRepeatIDGrouped; //use wild token to match, such as 0x001C????
	///Sophy 7/17/2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
	//indicate whether should keep this node when node's DataID is not in m_vnSourceID, in most case, will not keep the node if not in convert table.
	bool			m_bKeepIfNotInTable; 
	///end CONVERT_PA_THEME_FROM_SR5_TO_SR6
	
	vector<uint>	m_vnAddedID; //IDs exist in SR5 but not earlier version.
};

class ThemeValueConverter : public ThemeElementConverter
{
public:
	ThemeValueConverter(){}
	int	Convert(TreeNode& trThemeTree); // trThemeTree is specified single xf theme tree

protected:
	int			GetIndexInConvertTable(int nID);
	bool		GetNodeNewValue(int nIndex, int nOldValue, int& nNewValue); //nIndex returned by GetNodeIndexInConverTable, the index of the node need to be converted

protected:
	vector<uint>	m_vnIDs; //new node ID in SR5
	vector<string>	m_vsSrcValuesMap; //old value in sr4 theme file
	vector<string>	m_vsDestValuesMap; //new value to replace old value
};

struct GroupValueConvertTable
{
	vector<string>	vsSourceIDs;
	vector<string>	vsDestIDs;
	vector<string>	vsOps;
};

#define	CHAR_OP_VALUE_SEP				','
#define	CHAR_VALUES_SEP					'|'
#define	STR_OP_PARAM_REMOVE_ATTRIB		"RemoveAttrib"
enum
{
	OP_INVALID_OP,
	OP_COPY_VALUE,
	OP_SET_VALUE,
	OP_SET_VALUES,
};
enum
{
	GET_FAIL = -1,
	GET_SUCCESS = 0,
	GET_IGNORE,
};

class ThemeGroupValueConverter : public ThemeElementConverter
{
public:
	ThemeGroupValueConverter(){}
	virtual int		Convert(TreeNode& trTheme) {ASSERT(false); return -1;}
	
protected:
	int				GroupConvert(TreeNode& trTheme, const GroupValueConvertTable& vct);
	
	//return GET_SUCCESS if successful, GET_FAIL if fail, GET_IGNORE is lpcszXFName not in trTheme.Path
	int				GetXFThemeOneNode(TreeNode& trNode, const TreeNode& trTheme, LPCSTR lpcszXFName, LPCSTR lpcszNodeName);
	int				GetXFThemeOneNode(TreeNode& trNode, const TreeNode& trTheme, LPCSTR lpcszNameAndID);

private:
	bool			checkSizeConsistency(const GroupValueConvertTable& vct);
	bool			getXFNameAndNodeName(LPCSTR lpcszNameAndID, string& strXFName, string& strNodeName);
	int				getOpTypeAndValue(LPCSTR lpcszOps, string& strVal);
};
///////////////////////////////////////////////////////////////////////////////////////////////////////////

///---Sim 07-16-2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
/*
class PAThemeConvert
{
public:
	int Convert(TreeNode& trTheme);
protected:
	int ConvertXFName(TreeNode& trTheme);

	
	int ConvertIDs(TreeNode& trTheme);
	
	int ConvertIDsOnStart(TreeNode& trTheme);
	int ConvertIDsOnBaselineMode(TreeNode& trTheme);
	int ConvertIDsOnCreateBaseline(TreeNode& trTheme);
	int ConvertIDsOnBaselineTreatment(TreeNode& trTheme);
	int ConvertIDsOnFindPeaks(TreeNode& trTheme);
	int ConvertIDsOnIntegratePeaks(TreeNode& trTheme);
	int ConvertIDsOnFitPeaks(TreeNode& trTheme);
	
	
	int ConvertValue(TreeNode& trTheme);

	int ConvertValueOnStart(TreeNode& trTheme);
	int ConvertValueOnBaselineMode(TreeNode& trTheme);
	int ConvertValueOnCreateBaseline(TreeNode& trTheme);
	int ConvertValueOnBaselineTreatment(TreeNode& trTheme);
	int ConvertValueOnFindPeaks(TreeNode& trTheme);
	int ConvertValueOnIntegratePeaks(TreeNode& trTheme);
	int ConvertValueOnFitPeaks(TreeNode& trTheme);
	
private:
	int convertIDs(TreeNode& trTheme, ThemeIDConverter* pidcvt, LPCSTR lpcszXFName);
	
	int convertSingleValue(TreeNode& trTheme, ThemeValueConverter* pvcvt, LPCSTR lpcszXFName);
	int convertGroupValues(TreeNode& trTheme, ThemeGroupValueConverter* pgvcvt);
};
*/
class ThemeConvertBase
{
public:
	int Convert(TreeNode& trTheme);
protected:
	int ConvertIDs(TreeNode& trTheme, ThemeIDConverter* pidcvt, LPCSTR lpcszXFName);
	int ConvertSingleValue(TreeNode& trTheme, ThemeValueConverter* pvcvt, LPCSTR lpcszXFName);
	int ConvertGroupValues(TreeNode& trTheme, ThemeGroupValueConverter* pgvcvt);
	
	virtual int ConvertXFName(TreeNode& trTheme) {return 0;}
	virtual int ConvertIDs(TreeNode& trTheme) {return 0;}
	virtual int ConvertValue(TreeNode& trTheme) {return 0;}
};

class PAThemeConvert : public ThemeConvertBase
{
protected:
	virtual int ConvertXFName(TreeNode& trTheme);
	virtual int ConvertIDs(TreeNode& trTheme);
	virtual int ConvertValue(TreeNode& trTheme);
	
	int ConvertIDsOnStart(TreeNode& trTheme);
	int ConvertIDsOnBaselineMode(TreeNode& trTheme);
	int ConvertIDsOnCreateBaseline(TreeNode& trTheme);
	int ConvertIDsOnBaselineTreatment(TreeNode& trTheme);
	int ConvertIDsOnFindPeaks(TreeNode& trTheme);
	int ConvertIDsOnIntegratePeaks(TreeNode& trTheme);
	int ConvertIDsOnFitPeaks(TreeNode& trTheme);

	int ConvertValueOnStart(TreeNode& trTheme);
	int ConvertValueOnBaselineMode(TreeNode& trTheme);
	int ConvertValueOnCreateBaseline(TreeNode& trTheme);
	int ConvertValueOnBaselineTreatment(TreeNode& trTheme);
	int ConvertValueOnFindPeaks(TreeNode& trTheme);
	int ConvertValueOnIntegratePeaks(TreeNode& trTheme);
	int ConvertValueOnFitPeaks(TreeNode& trTheme);
};

class PAThemeConvertSR6 : public ThemeConvertBase
{
protected:
	virtual int ConvertIDs(TreeNode& trTheme);	///Sophy 7/17/2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
	virtual int ConvertValue(TreeNode& trTheme);

	int ConvertIDsOnFitPeaks(TreeNode& trTheme);///Sophy 7/17/2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
	
	int ConvertValueOnFitPeaks(TreeNode& trTheme);
};
///---END CONVERT_PA_THEME_FROM_SR5_TO_SR6

// reuturn -1 is error, 0 is successful
//int convert_pa_theme(TreeNode& trTheme);
//int convert_pa_theme_sr5_to_sr6(TreeNode& trTheme)

///////////////////////////////////////////////////////////////////////////////////////////////////////////
class PAGoalThemeIDConverter : public ThemeIDConverter
{
public:
	PAGoalThemeIDConverter();
};

class PABaselineModeThemeIDConverter : public ThemeIDConverter
{
public:
	PABaselineModeThemeIDConverter();
};

class PACreateBaselineThemeIDConverter : public ThemeIDConverter
{
public:
	PACreateBaselineThemeIDConverter();
};

class PABaselineTreatmentThemeIDConverter : public ThemeIDConverter
{
public:
	PABaselineTreatmentThemeIDConverter();
};

class PAFindPeaksThemeIDConverter : public ThemeIDConverter
{
public:
	PAFindPeaksThemeIDConverter();
};

class PAIntegratePeaksThemeIDConverter : public ThemeIDConverter
{
public:
	PAIntegratePeaksThemeIDConverter();
};

class PAFitPeaksThemeIDConverter : public ThemeIDConverter
{
public:
	PAFitPeaksThemeIDConverter();

};
//////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////Theme IDs from SR5 to SR6///////////////////////////////////////////////////
///Sophy 7/17/2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
class PAFitPeaksThemeIDConverterSR6 : public ThemeIDConverter
{
public:
	PAFitPeaksThemeIDConverterSR6();
};
///end CONVERT_PA_THEME_FROM_SR5_TO_SR6

///////////////////////////////////////////////////////////////////////////////////////////////////////////
class PAGoalThemeValueConverter : public ThemeValueConverter
{
public:
	PAGoalThemeValueConverter();
};

class PAThemeGroupValueBaselineModeConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueBaselineModeConverter(){}

	virtual int		Convert(TreeNode& trTheme);
};

class PAThemeGroupValueCreateBaselineConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueCreateBaselineConverter(){}
	
	virtual int		Convert(TreeNode& trTheme);
};

class PAThemeGroupValueBaselineTreatmentConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueBaselineTreatmentConverter(){}
	virtual	int		Convert(TreeNode& trTheme);
};

class PAThemeGroupValueFindPeaksConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueFindPeaksConverter(){}
	
	virtual int		Convert(TreeNode& trTheme);
};

class PAThemeGroupValueIntegratePeaksConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueIntegratePeaksConverter(){}
	
	virtual int		Convert(TreeNode& trTheme);
};

class PAThemeGroupValueFitPeaksConverter : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueFitPeaksConverter(){}
	
	virtual int		Convert(TreeNode& trTheme);
};

///end THEME_CONVERTION_FOR_PA_AS_TO_MAKE_THEME_BACKWARD_COMPATIBLE

///---Sim 07-16-2009 CONVERT_PA_THEME_FROM_SR5_TO_SR6
class PAThemeGroupValueFitPeaksConverterSR6 : public ThemeGroupValueConverter
{
public:
	PAThemeGroupValueFitPeaksConverterSR6(){}
	
	virtual int		Convert(TreeNode& trTheme);
};
///---END CONVERT_PA_THEME_FROM_SR5_TO_SR6

#endif // PA_THEME_CONVERT_H
