
/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/14/2011 IMAGE_THUMBNAIL_CHKBOX_CRASH									*
 *  Sen 08/02/2011 ORG-2629-P4 NO_NEED_TO_COMBINE_FILE_TYPE_FOR_MATRIX			*
 * Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD					*
 *	Bill 08/12/2011 ORG-3463-P2 SUPPORT_READONLY_FOR_OPEN_FILE_DLG				*
 *	Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE		*
 *	Folger 11/08/2011 DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include <Array.h>
#include "OpenTemplateDlg.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define STR_DLG_NAME						"Open Template"

#define REG_KEY_TEMPLATE_WND_TYPE			"TemplateWndType"
#define REG_KEY_TEMPLATE_PATH_TYPE			"TemplatePathType"
#define REG_KEY_TEMPLATE_PATH				"TemplatePath"
#define REG_KEY_TEMPLATE_WITHOUT_DATA		"TemplateWithoutData"
#define REG_KEY_ANALYSIS_TEMPLATE			"AnalysisTemplate"

#define STR_WB_ANALYSIS_TEMPLATE_EXTENTION	"OGW"
#define STR_MB_ANALYSIS_TEMPLATE_EXTENTION	"OGM"


#define LAST_BOTTOM_CONTROL_IN_TAB		IDOK

enum 
{
	WTYPE_WORKSHEET = 0,
	WTYPE_MATRIXSHEET,
	WTYPE_GRAPH
};

enum 
{
	TTYPE_WITHOUT_DATA = 0,
	TTYPE_ANALYSIS
};

enum
{
	COLUMNS_MODE_SINGLE,
	COLUMNS_MODE_GROUPED
};

enum
{
	TEMPLATE_SYSTEM_FOLDER,
	TEMPLATE_USER_FILE_FOLDER,
	TEMPLATE_CUSTOM_FOLDER
};



////////////////////////////////////////////////////////////////////////////////////
// Start OpenTemplateDlg class functions here.

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
////////////////// Dialog related ///////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

BOOL OpenTemplateDlg::OnInitDialog()
{	
	ResizeDialog::OnInitDialog(IDC_LIST_TEMPLATES, STR_DLG_NAME);

	initControls();	
	updateControlsOnWndTypeChange();
	
	return true;
}


BOOL OpenTemplateDlg::OnReady()
{
	SetInitReady(true);
	return true;
}

BOOL OpenTemplateDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return true;
	
	MoveControlsHelper	_temp(this);
	int nGap = GetControlGap();
	
	// to move Set Default, OK, Cancel buttons
	RECT rrOK, rrCancel, rrDefault;
	GetControlClientRect(IDOK, rrOK);
	GetControlClientRect(IDCANCEL, rrCancel);
	GetControlClientRect(IDC_BUTTON_SET_DEFAULT, rrDefault);
	
	int nButtonWidth = RECT_WIDTH(rrOK);
	int nButtonHeight = RECT_HEIGHT(rrOK);
	MoveControl(IDCANCEL, cx - nGap, cy - nGap, false);
	MoveControl(IDOK, cx - 2 * nGap - nButtonWidth, cy - nGap, false);	
	MoveControl(IDC_BUTTON_SET_DEFAULT, nGap + RECT_WIDTH(rrDefault), cy - nGap, false);
	
	// to resize grid	
	RECT rrList;
	GetControlClientRect(IDC_LIST_TEMPLATES, rrList);
	rrList.right = cx - nGap;
	rrList.bottom = cy - 2 * nGap - nButtonHeight;
	MoveControl(GetItem(IDC_LIST_TEMPLATES), rrList);
	
	return true;
}
/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
void OpenTemplateDlg::setListTemplateItemBold(int nNewDefaultIndex, int nOldDefaultIndex)
{
//	for(int ii = 1; ii <= m_listTemplates.GetRows(); ii++)
//		m_listTemplates.SetBold(ii, -1, false);
	m_listTemplates.SetBold(nOldDefaultIndex, -1, false);
	m_listTemplates.SetBold(nNewDefaultIndex, -1, true);
}
/// End DEFAULT_TEMPLATE_SHOULD_BE_BOLD

BOOL OpenTemplateDlg::OnSetDefaultButtonClick(Control cntrl)
{
	/// Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
	// The old File->New dialog use the same way as System.wks.DefTemplate to
	// set the default template. DefaultTemplate do it in another way and seem not work.
	//string strTemplate = getSelectedTemplate();
	//DefaultTemplate(strTemplate.GetBuffer(50), getPageType(), false, true);
	string strFullPath = getPath() + getSelectedTemplate();
	string strCommand;
	strCommand.Format("%s$=\"%s\"", getLTDefaultTemplateVar(), strFullPath);
	LT_execute(strCommand);
	/// End USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE

	/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	setListTemplateItemBold(m_listTemplates.GetSelectedRow(), m_nDefaultTemplates);
	m_nDefaultTemplates = m_listTemplates.GetSelectedRow();
	/// End DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	return true;
}


BOOL OpenTemplateDlg::OnOK(Control cntrl)
{
	return doLoadTemplate();		
}

///------ Folger 11/08/2011 DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE
BOOL OpenTemplateDlg::OnDblClickToClose(Control ctrl)
{
	PostMessage(WM_CLOSE);
	return doLoadTemplate();
}
///------ End DOUBLE._CLICK_TO_OPEN_SELECTED_TEMPLATE

bool OpenTemplateDlg::OnDestroy()
{
	int nWndType = getTemplateWndType();
	SaveSetting(REG_KEY_TEMPLATE_WND_TYPE, nWndType, STR_DLG_NAME);
	
	int nPathType = GetCheckedRadioButton(IDC_RADIO_TEMPLATE_SYS_FOLDER, IDC_RADIO_TEMPLATE_CUSTOM_FOLDER) - IDC_RADIO_TEMPLATE_SYS_FOLDER;
	SaveSetting(REG_KEY_TEMPLATE_PATH_TYPE, nPathType, STR_DLG_NAME);
	SaveSetting(REG_KEY_TEMPLATE_PATH, GetItem(IDC_STATIC_TEMPLATE_PATH).Text, STR_DLG_NAME);
	
	Button btn = GetItem(IDC_CHECK_TEMPLATE_WITHOUT_DATA);
	SaveSetting(REG_KEY_TEMPLATE_WITHOUT_DATA, btn.Value, STR_DLG_NAME);
	
	btn = GetItem(IDC_CHECK_ANALYSIS_TEMPLATE);
	SaveSetting(REG_KEY_ANALYSIS_TEMPLATE, btn.Value, STR_DLG_NAME);
	
	return true;
}

void OpenTemplateDlg::initControls()
{
	m_listTemplates.Init(IDC_LIST_TEMPLATES, *this);
	
	// load last used settings to template type radios
	DWORD dw;
	dw = LoadSetting(REG_KEY_TEMPLATE_WITHOUT_DATA, 1, STR_DLG_NAME);	
	m_checkTemplateWithoutData = GetItem(IDC_CHECK_TEMPLATE_WITHOUT_DATA);
	m_checkTemplateWithoutData.Value = dw;

	dw = LoadSetting(REG_KEY_ANALYSIS_TEMPLATE, 1, STR_DLG_NAME);	
	m_checkAnalysisTemplate = GetItem(IDC_CHECK_ANALYSIS_TEMPLATE);
	m_checkAnalysisTemplate.Value = dw;
	
	// init window type from regedit
	dw = LoadSetting(REG_KEY_TEMPLATE_WND_TYPE, WTYPE_WORKSHEET, STR_DLG_NAME);
	CheckRadioButton(IDC_RADIO_WND_TYPE_WB, IDC_RADIO_WND_TYPE_GRAPH, IDC_RADIO_WND_TYPE_WB + dw);
	
	// init template path and template list
	updateTemplatePath(-1); // -1 means init time
	/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	m_nDefaultTemplates = 0;
	/// End DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	updateTemplateList();
}

int OpenTemplateDlg::getTemplateWndType()
{
	return GetCheckedRadioButton(IDC_RADIO_WND_TYPE_WB, IDC_RADIO_WND_TYPE_GRAPH) - IDC_RADIO_WND_TYPE_WB;
}

int		OpenTemplateDlg::getPathType()
{
	return GetCheckedRadioButton(IDC_RADIO_TEMPLATE_SYS_FOLDER, IDC_RADIO_TEMPLATE_CUSTOM_FOLDER) - IDC_RADIO_TEMPLATE_SYS_FOLDER;
}

string	OpenTemplateDlg::getPath()
{	
	switch(getPathType())
	{
	case TEMPLATE_SYSTEM_FOLDER:
		return GetOriginPath(ORIGIN_PATH_SYSTEM);		
		
	case TEMPLATE_USER_FILE_FOLDER:
		return GetOriginPath(ORIGIN_PATH_USER);
		
	case TEMPLATE_CUSTOM_FOLDER:
		Control ctrlPath = GetItem(IDC_STATIC_TEMPLATE_PATH);
		if( ctrlPath )
			return ctrlPath.Text;
	}
	return "";
}

/// Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
string OpenTemplateDlg::getLTDefaultTemplateVar()
{
	string strVar = "System.Wks.DefTemplate";
	switch(getTemplateWndType())
	{
	case WTYPE_WORKSHEET:
		strVar = "System.Wks.DefTemplate";
		break;
	case WTYPE_MATRIXSHEET:
		strVar = "System.matrix.DefTemplate";
		break;
	case WTYPE_GRAPH:
		strVar = "System.graph.DefTemplate";
		break;
	}
	return strVar;
}
/// End USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE

void OpenTemplateDlg::updateTemplatePath(int nFolderType)
{
	// init time load last used setting from regedit
	Control ctrlPath = GetItem(IDC_STATIC_TEMPLATE_PATH);
	bool bIsInitTime = (-1 == nFolderType);
	if( bIsInitTime )
	{
		nFolderType = LoadSetting(REG_KEY_TEMPLATE_PATH_TYPE, TEMPLATE_SYSTEM_FOLDER, STR_DLG_NAME);
		if( TEMPLATE_CUSTOM_FOLDER == nFolderType )
		{			
			string strPath;		
			if( LoadSetting(REG_KEY_TEMPLATE_PATH, strPath, STR_DLG_NAME) )
			{
				if( strPath.IsPath() )
					ctrlPath.Text = strPath;
				else
					ctrlPath.Text = GetOriginPath(ORIGIN_PATH_SYSTEM);;
			}
		}
		CheckRadioButton(IDC_RADIO_TEMPLATE_SYS_FOLDER, IDC_RADIO_TEMPLATE_CUSTOM_FOLDER, IDC_RADIO_TEMPLATE_SYS_FOLDER + nFolderType);
	}
	
	Control ctrlBrowser = GetItem(IDC_TEMPLATE_PATH_BROWSER);
	ctrlBrowser.Enable = (TEMPLATE_CUSTOM_FOLDER == nFolderType);
	
	string strPath = ctrlPath.Text;
	switch(nFolderType)
	{
	case TEMPLATE_SYSTEM_FOLDER:
		strPath = GetOriginPath(ORIGIN_PATH_SYSTEM);
		break;
		
	case TEMPLATE_USER_FILE_FOLDER:
		strPath = GetOriginPath(ORIGIN_PATH_USER);
		break;
		
	case TEMPLATE_CUSTOM_FOLDER:
	default:
		break; // do nothing
	}
	
	if( 0 != strPath.CompareNoCase(ctrlPath.Text) )
	{
		ctrlPath.Text = strPath;
		updateTemplateList();
	}
}

string OpenTemplateDlg::getTemplateExtension(int nWndType, int nTemplateType)
{
	if( WTYPE_WORKSHEET == nWndType )
	{
		if( TTYPE_ANALYSIS == nTemplateType )
		{
			return "OGW";
		}
		else
		{
			return "OTW";
		}
	}
	else if( WTYPE_MATRIXSHEET == nWndType )
	{
		// matrix window
		if( TTYPE_ANALYSIS == nTemplateType )
		{
			return "OGM";
		}
		else
		{
			return "OTM";
		}		
	}
	else if( WTYPE_GRAPH == nWndType )
	{
		return "OTP";		
	}	
	ASSERT(false);
	return "";
}

int OpenTemplateDlg::getOneTemplateType(int nWndType, int nTemplateType, Array<TemplateInfo&> &arrInfos, LPCSTR lpcszPath, int *pnDefaultTemplate)
{
	vector<string> vsFiles;
	FindFiles(vsFiles, lpcszPath, getTemplateExtension(nWndType, nTemplateType));
	
	string strDefault = getDefaultTemplate();
	/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	getDefTemplateFullPath(strDefault);
	if(pnDefaultTemplate != NULL)
		*pnDefaultTemplate = -1;
	/// End DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	for(int ii = 0; ii < vsFiles.GetSize(); ii++)
	{
		string strDesc;
		getTemplateDescription(vsFiles[ii], strDesc);
		
		string strOriginExePath = GetOriginPath();		
		if(0 == strOriginExePath.CompareNoCase(lpcszPath) && nWndType != WTYPE_GRAPH && strDesc.IsEmpty() && TTYPE_WITHOUT_DATA == nTemplateType )
		{
			// not add to list
		}
		else
		{
			TemplateInfo *pst = new TemplateInfo;
			pst->strName = vsFiles[ii]; // file name							
			
			string strFullPath = (string)lpcszPath + pst->strName;
			WIN32_FILE_ATTRIBUTE_DATA stFileInfo;
			GetFileAttributesEx(strFullPath, 0, &stFileInfo);
			pst->nFileSize = nint(stFileInfo.nFileSizeLow / 1024.0) ; // file size
			
			// file date modified
			FILETIME localFiletime;
			SYSTEMTIME st;
			double dJulianDate;
			if( FileTimeToLocalFileTime(&(stFileInfo.ftLastWriteTime), &localFiletime) && FileTimeToSystemTime(&localFiletime, &st) )
			{
				SystemTimeToJulianDate(&dJulianDate, &st);
				pst->strDateModified = get_date_str(dJulianDate);
			}
			
			// template description
			string strOneLineDesc = strDesc;
			vector<string> vs;
			str_separate(strDesc, "\r\n", vs);
			if( vs.GetSize() > 0 )
				strOneLineDesc = vs[0];
			pst->strDescription = strOneLineDesc;
			
			arrInfos.Add(*pst);
			
			/// Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
			//if( pnDefaultTemplate != NULL && 0 == strDefault.CompareNoCase(pst->strName) )
			//	*pnDefaultTemplate = arrInfos.GetSize()-1;			
			if( pnDefaultTemplate != NULL && 0 == strDefault.CompareNoCase(strFullPath))
				*pnDefaultTemplate = arrInfos.GetSize()-1;			
			/// End USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
		}
	}
	
	return arrInfos.GetSize();
}

/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
bool OpenTemplateDlg::getDefTemplateFullPath(string& strDefault)
{
	string strTmpDefault = strDefault;
	if(strTmpDefault.IsFile())
	{
		return TRUE;
	}
	else
	{		
		if(GetFilePath(strTmpDefault).IsEmpty())
		{
			strTmpDefault.Format("%s%s" ,getPath(), strDefault);
		}
		
		if(strTmpDefault.Find('.') == -1)
		{
			switch(getTemplateWndType())
			{
				case WTYPE_WORKSHEET:
					strTmpDefault += ".otw";
					break;
				case WTYPE_MATRIXSHEET:
					strTmpDefault += ".otm";
					break;
				case WTYPE_GRAPH:
					strTmpDefault += ".otp";
					break;
			}
		}
					
		strDefault = strTmpDefault;
	}
	
	return TRUE;
}
/// End DEFAULT_TEMPLATE_SHOULD_BE_BOLD

void OpenTemplateDlg::getTemplateDescription(LPCSTR lpcszTemplateName, string& strDesc)
{
	string strFileName = GetOriginPath(ORIGIN_PATH_SYSTEM) + (string)lpcszTemplateName;
	string strDescription;
	if( !strFileName.IsFile() )
	{
		strFileName = GetOriginPath(ORIGIN_PATH_USER) + (string)lpcszTemplateName;
	}	
	
	if( strFileName.IsFile() )
		okutil_get_Origin_file_comment(strFileName, &strDesc); 
}


int OpenTemplateDlg::getTemplateInfo(Array<TemplateInfo&> &arrInfos, int &nDefaultIndex)
{
	int nWndType = getTemplateWndType();
	string strPath = GetItem(IDC_STATIC_TEMPLATE_PATH).Text;
	ASSERT(strPath.IsPath());
	if( !strPath.IsPath() )
		strPath = GetOriginPath();
	
	if( m_checkTemplateWithoutData.Value )
	{
		getOneTemplateType(nWndType, TTYPE_WITHOUT_DATA, arrInfos, strPath, &nDefaultIndex);
	}
	
	if( m_checkAnalysisTemplate.Value && WTYPE_GRAPH != nWndType )
	{
		getOneTemplateType(nWndType, TTYPE_ANALYSIS, arrInfos, strPath);
	}		
	return arrInfos.GetSize();
}

int OpenTemplateDlg::getPageType()
{
	int 	nPageType = WTYPE_WORKSHEET;
	switch(getTemplateWndType())
	{
	case WTYPE_WORKSHEET:
		nPageType = EXIST_WKS;
		break;
	case WTYPE_MATRIXSHEET:
		nPageType = EXIST_MATRIX;
		break;
	case WTYPE_GRAPH:
		nPageType = EXIST_PLOT;
		break;
	}
	return nPageType;
}

string OpenTemplateDlg::getDefaultTemplate()
{	
	char 	szName[MAXFULLPATH];
	/// Bill 08/24/2011 ORG-3463-P3 USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
	//DefaultTemplate(szName, getPageType(), true, true);
	LT_get_str(getLTDefaultTemplateVar(), szName, MAXFULLPATH);
	/// End USE_SYSTEM_VARIABLE_TO_SET_DEFAULT_TEMPLATE
	return (string)szName;
}

void OpenTemplateDlg::updateTemplateList()
{
	Array<TemplateInfo&> arrInfos(true);
	int nDefaultTemplate;
	getTemplateInfo(arrInfos, nDefaultTemplate);	
	
	m_listTemplates.UpdateInfo(arrInfos, nDefaultTemplate);
	/// Sen 08/11/2011 ORG-2629-S8 DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	setListTemplateItemBold(nDefaultTemplate + m_listTemplates.GetRowOffset(), m_nDefaultTemplates);
	m_nDefaultTemplates = nDefaultTemplate + m_listTemplates.GetRowOffset();
	/// End	DEFAULT_TEMPLATE_SHOULD_BE_BOLD
	
}

BOOL OpenTemplateDlg::OnWndTypeChange(Control ctrl)
{
	updateTemplateList();
	updateControlsOnWndTypeChange();
	return TRUE;
}

BOOL OpenTemplateDlg::OnTemplatePathRadioClick(Control ctrl)
{
	int nPathType = getPathType();
	updateTemplatePath(nPathType);
	return TRUE;
}

BOOL OpenTemplateDlg::OnTemplatePathBrowserClick(Control ctrl)
{
    Control ctrlPath = GetItem(IDC_STATIC_TEMPLATE_PATH);
    
    string strOldPath = GetFilePath(ctrlPath.Text);
    if( strOldPath.IsEmpty() )
    	strOldPath = GetOriginPath();
    
    StringArray saFiletypes;
    int nWndType = getTemplateWndType();
    if( WTYPE_WORKSHEET == nWndType )
    {
		saFiletypes.Add("[Workbook Template (*.otw; *ogw)] *.otw; * ogw");		
    }
    else if( WTYPE_MATRIXSHEET == nWndType )
    {	
    	/// Sen 08/02/2011 ORG-2629-P4 NO_NEED_TO_COMBINE_FILE_TYPE_FOR_MATRIX
		//saFiletypes.Add("[Matrixbook Template (*.otm; *.ogm)] *.otm; *.ogm");
		saFiletypes.Add("[Matrixbook Template (*.otm)] *.otm");
		/// End NO_NEED_TO_COMBINE_FILE_TYPE_FOR_MATRIX
    }
    else
    {
    	saFiletypes.Add("[Graph Template (*.otp)] * otp");
    }
    
    //string strNewPath = GetOpenBox( saFiletypes, strOldPath );
    string strName;
    int nOptions = FDLG_SUPPRESS_WARNING_SAVE_TO_EXISTING|FDLG_FILENAME_BOX_READ_ONLY;
	/// Bill 08/12/2011 ORG-3463-P2 SUPPORT_READONLY_FOR_OPEN_FILE_DLG
    //if( okutil_FileDialog(&strName, true, &saFiletypes, strOldPath, nOptions, GetSafeHwnd(), "Browser") )
    if( okutil_FileDialog(&strName, false, &saFiletypes, strOldPath, nOptions, GetSafeHwnd(), "Browser") )
	/// End SUPPORT_READONLY_FOR_OPEN_FILE_DLG
    {
	    string strNewPath = GetFilePath(strName);
	    
	    if( 0 != strNewPath.Compare(strOldPath) && !strNewPath.IsEmpty() )
	    {
	    	ctrlPath.Text = strNewPath;
	    	updateTemplateList();
	    }
    }
	return TRUE;
}

BOOL OpenTemplateDlg::OnTemplateTypeCheckBoxChecked(Control ctrl)
{
	updateTemplateList();
	return TRUE;
}

void OpenTemplateDlg::OnTemplateListSelChange(Control cntrl)
{
	bool bEnableDefault = true;
	
	int nWndType = getTemplateWndType();
	if( nWndType == WTYPE_WORKSHEET || nWndType == WTYPE_MATRIXSHEET )
	{
		string strTemplate = getSelectedTemplate();
		if( isAnalysisTemplate(strTemplate) )
			bEnableDefault = false;		
	}
	GetItem(IDC_BUTTON_SET_DEFAULT).Enable = bEnableDefault;
	
}

void OpenTemplateDlg::OnTemplateListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
{
	m_listTemplates.OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
}

string OpenTemplateDlg::getSelectedTemplate()
{
	string strTemplate;	
	strTemplate = m_listTemplates.GetSelectedTemplate();
	if( strTemplate.IsEmpty() )
		strTemplate = "ORIGIN";
		
	return strTemplate;
}

bool OpenTemplateDlg::isAnalysisTemplate(LPCSTR lpcszTemplate)
{	
	string strName = GetFileName(lpcszTemplate, true);
	string strNameWithExtension = GetFileName(lpcszTemplate, false);
	string strExtension = GetFileName(lpcszTemplate, false); // get name with extension
	strExtension.Delete(0, strName.GetLength() + 1); // remove name, just keep extension; +1 to remove "."
	return (0 == strExtension.CompareNoCase( getTemplateExtension(getTemplateWndType(), TTYPE_ANALYSIS) ) );
}


void OpenTemplateDlg::updateControlsOnWndTypeChange()
{
	/*
	vector<uint> vnTypeIDs = {
		IDC_STATIC_TEMPLATE_TYPE_LABEL,
		IDC_STATIC_TEMPLATE_TYPE_SEP,
		IDC_CHECK_TEMPLATE_WITHOUT_DATA,
		IDC_CHECK_ANALYSIS_TEMPLATE,
		0
	};
	
	vector<uint> vnGirdButtonIDs = {
		IDC_LIST_TEMPLATES,
		IDC_BUTTON_SET_DEFAULT,
		IDOK,
		IDCANCEL,
		0
	};
	
	RECT rrFirstTypeControl, rrGrid;
	GetControlClientRect(vnTypeIDs[0], rrFirstTypeControl);
	GetControlClientRect(vnGirdButtonIDs[0], rrGrid);
	
	int nWndType = getTemplateWndType();
	bool bIsTypeCtrlShow = (nWndType != WTYPE_GRAPH);
	if( GetItem(vnTypeIDs[0]).Visible == bIsTypeCtrlShow )
		return;
	
	MoveControlsHelper	_temp(this);
	ShowControls(vnTypeIDs, bIsTypeCtrlShow);	
	if( nWndType == WTYPE_GRAPH ) // to hide Template Type control group
	{		
		int nY = rrFirstTypeControl.top - rrGrid.top;
		MoveControls(vnGirdButtonIDs, 0, nY);
	}
	else
	{
		RECT rrLastTypeControl;
		GetControlClientRect(IDC_CHECK_ANALYSIS_TEMPLATE, rrLastTypeControl);
		
		int nY = rrLastTypeControl.bottom + GetControlGap() - rrFirstTypeControl.top;
		MoveControls(vnGirdButtonIDs, 0, nY);		
	}
	
	RECT rrOK, rrDlg;
	GetControlClientRect(IDOK, rrOK);	
	m_wndDlg.GetWindowRect(&rrDlg);
	m_wndDlg.ScreenToClient(&rrDlg);
	rrDlg.bottom = rrOK.bottom + GetControlGap();
	m_wndDlg.ClientToScreen(&rrDlg);
	
	//SetInitReady(false); // set as false in order to not enter OnDlgResize when resize dialog
	m_wndDlg.MoveWindow(&rrDlg, true); 
	//SetInitReady(true);
	*/
	/// Iris 8/01/2011 ORG-2629-P4 MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
	//bool bEnableAnalysisTemplateCtrl = (WTYPE_GRAPH != getTemplateWndType());
	bool bEnableAnalysisTemplateCtrl = (WTYPE_WORKSHEET == getTemplateWndType());
	///End MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
	
	Button ctrlTemplateCheck = GetItem(IDC_CHECK_TEMPLATE_WITHOUT_DATA);
	Button ctrlAnalysisTemplateCheck = GetItem(IDC_CHECK_ANALYSIS_TEMPLATE);
	if( !bEnableAnalysisTemplateCtrl )
	{
		ctrlTemplateCheck.Check = 1;
		/// Iris 8/01/2011 ORG-2629-P4 MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
		ctrlAnalysisTemplateCheck.Check = 0;
		///End MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
	}
	
	ctrlTemplateCheck.Enable = 
	ctrlAnalysisTemplateCheck.Enable = bEnableAnalysisTemplateCtrl;
}


bool OpenTemplateDlg::doLoadTemplate()
{	
	bool bRet;	
	string strTemplate = getSelectedTemplate();
	string strFullPath = getPath() + strTemplate;
	int nWndType = getTemplateWndType();
	if( WTYPE_WORKSHEET == nWndType )
	{
		/// Iris 8/01/2011 ORG-2629-P4-2 FIX_OPEN_WKS_ANALYSIS_TEMPLATE_ISSUE
		/*
		if( isAnalysisTemplate(strTemplate) )
		{
			Worksheet wks;
			bRet = wks.Open(strFullPath);
		}
		else
		{
			WorksheetPage wksPage;
			bRet = wksPage.Create(strTemplate);
		}
		*/
		WorksheetPage wksPage;		
		bRet = wksPage.Create(strFullPath);
		///End FIX_OPEN_WKS_ANALYSIS_TEMPLATE_ISSUE
	}
	else if( WTYPE_MATRIXSHEET == nWndType )
	{
		/// Iris 8/01/2011 ORG-2629-P4 MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
		/*
		if( isAnalysisTemplate(strTemplate) )
		{
			MatrixLayer ml;
			bRet = ml.Open(strFullPath);
		}
		else
		{
			MatrixPage matPage;
			bRet = matPage.Create(strTemplate);
		}
		*/
		MatrixPage matPage;
		bRet = matPage.Create(strFullPath);
		///End MATRIX_TYPE_ALSO_NEED_DISABLE_ALAYSIS_TEMPLATE
	}
	else
	{
		GraphPage gp;
		bRet = gp.Create(strFullPath);
	}
	return bRet;	
}


void TemplateGirdList::Init(int nID, WndContainer& dlg)
{
	GridListControl::Init(nID, dlg);
	m_flx.Editable = flexEDNone;
	m_flx.ExplorerBar = flexExSortShow;	
	m_flx.MergeCells = flexMergeSpill;
	SetAlternateRowColors();
	
	// set column headers		
	string strHeaders = STR_LIST_HEADER;
	vector<string> vsHeaders;
	strHeaders.GetTokens(vsHeaders, '|');
	int nCols = vsHeaders.GetSize();
	SetCols( nCols );
	
	for( int iCol = 0; iCol < nCols; ++iCol )
	{
		SetColHeading( iCol, vsHeaders[iCol] );	
	}
	InitColsShowHiddenFromReg();

	EnableNavigation(true); /// Bill 09/23/2011 ORG-3602-S1 SUPPORT_KEYBOARD_NAVIGATION_FOR_WXGRID
}
	
void TemplateGirdList::UpdateInfo(const Array<TemplateInfo&> &arrInfos, int nDefaultTemplate)
{
	int nSize = arrInfos.GetSize();
	SetRows(nSize);
		
	vector<string> vsTableValues;
	for(int index = 0; index < nSize; ++index)
	{
		TemplateInfo st;
		st = arrInfos.GetAt(index);
		
		vsTableValues.Add(st.strName);
		vsTableValues.Add((string)st.nFileSize);
		vsTableValues.Add(st.strDateModified);
		vsTableValues.Add(st.strDescription);
		
	}
	bool bRet = SetTableValue(vsTableValues, true);
	
	if( nDefaultTemplate >= 0 && nDefaultTemplate < nSize )
	{
		m_flx.Row = nDefaultTemplate + GetRowOffset();
	}
	ResizeCols(0, 12, 50, 0, flexAutoSizeColWidth | flexAutoSizeNoFixed);
}

string TemplateGirdList::GetSelectedTemplate()
{
	int nRow = GetSelectedRow();
	if( nRow >= 0 )
		return GetCell(nRow, 0);
	return "";
}

void TemplateGirdList::OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
{
	int nRow, nCol;
	GetMouseCell(nRow, nCol);
	
	int nx = XTwipsToPixels(X);
	int ny = YTwipsToPixels(Y);
	ClientToScreen(nx, ny);		

	if( MK_RBUTTON == nButton && GetSelectedRow() >= 0 && nRow < GetRowOffset() ) // right click on column header
	{
		TemplateGridHeaderMenu myMenu(this);	
		int nSelCol = myMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if( nSelCol >= 0 && nSelCol < GetNumCols() )
		{
			bool bHide = GetIsColHidden(nSelCol);
			SetIsColHidden(nSelCol, !bHide);
		}
	}	
}

TemplateGirdList::~TemplateGirdList()
{
	SaveColsShowHiddenToReg();
}

void openLoadTemplateDlg()
{
	OpenTemplateDlg myDlg;
	myDlg.DoModalEx();
}

