/*------------------------------------------------------------------------------*
 * File Name: OSelFilter.c														*
 * Purpose: Handle the selection of a import filter								*
 * Copyright (c) Originlab Corp. 2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 12/29/2004 v8.0181 OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils		*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *------------------------------------------------------------------------------*/

#include <origin.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
///	#include "ODlg.h"
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include "fu_utils.h"
/// SY 12/29/2004 v8.0181 OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils
///#include "App_Utils.h"
/// end OC_CLEANUP_REMOVING_wks_utils_dlg_utils_app_utils
///DSC 1/11/07 REMOVE_LOCAL_H #include "$Local.h"


#define IDD_SELFILTER 245


enum {
	SF_FOLDER_DATAFILE = 0,
	SF_FOLDER_ORIGIN,
	SF_FOLDER_USERFILES,
	SF_FOLDER_ALL,
	SF_FOLDER_UNKNOWN
};


static Dialog OSelFilterDlg(IDD_SELFILTER, "ODlg");
static LPCSTR s_lpcszDataFile;
static StringArray s_saDataFolderFilters;
static StringArray s_saOriginFilters;
static StringArray s_saUserFilesFilters;
static string s_strFilterFile;


BEGIN_EVENT_MAP
	ON_INIT(OnInitDialog)
	ON_OK(OnClickOK)
	///ON_CANCEL(OnClickCancel)
	ON_CBN_SELCHANGE(IDC_SELFILTER_FOLDER, OnSelChangeFolder)
	ON_LBN_SELCHANGE(IDC_SELFILTER_LIST, OnSelChangeFilter)
END_EVENT_MAP


bool SelectFilter(string &strFilterFile, LPCSTR lpcszDataFile)
{
	SelectFilterInit();
	s_lpcszDataFile = lpcszDataFile;
	bool bRet = false;
	if( IDOK == OSelFilterDlg.DoModal() )
	{
		strFilterFile = s_strFilterFile;
		bRet = true;
	}
	SelectFilterInit(); // cleanup
	return bRet;
}

static void SelectFilterInit()
{
	s_saDataFolderFilters.SetSize(0);
	s_saOriginFilters.SetSize(0);
	s_saUserFilesFilters.SetSize(0);
	s_strFilterFile.Empty();
}

static BOOL OnInitDialog()
{
	Edit ebDataFile = OSelFilterDlg.GetItem(IDC_SELFILTER_DATAFILE);
	ebDataFile.Text = s_lpcszDataFile;

	string strDataFile = GetFileName(s_lpcszDataFile);

	/// EJP 07-22-2003 v7.0631 CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
	/*
	string strPath = GetFilePath(s_lpcszDataFile);
	if( !strPath.IsEmpty() )
		fuGetFilterFiles(s_saDataFolderFilters, strPath, strDataFile);

	strPath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
	if( !strPath.IsEmpty() )
		fuGetFilterFiles(s_saOriginFilters, strPath, strDataFile);

	strPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	if( !strPath.IsEmpty() )
		fuGetFilterFiles(s_saUserFilesFilters, strPath, strDataFile);	
	*/
	string strDataPath = GetFilePath(s_lpcszDataFile);
	if( !strDataPath.IsEmpty() )
		fuGetFilterFiles(s_saDataFolderFilters, strDataPath, strDataFile);
	
	string strUserPath;
	strUserPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	if( strUserPath != strDataPath )
		fuGetFilterFiles(s_saUserFilesFilters, strUserPath, strDataFile);

	string strExePath;
	strExePath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
	if( strExePath != strDataPath && strExePath != strUserPath )
		fuGetFilterFiles(s_saOriginFilters, strExePath, strDataFile);
	/// end CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
	
	ComboBox cbFolder = OSelFilterDlg.GetItem(IDC_SELFILTER_FOLDER);
	cbFolder.SetCurSel(SF_FOLDER_ALL);
	UpdateFilterList(SF_FOLDER_ALL);
	return TRUE;
}

static BOOL OnClickOK()
{
	ListBox lbFilters = OSelFilterDlg.GetItem(IDC_SELFILTER_LIST);
	int n = lbFilters.GetCurSel();
	if( -1 == n )
		return FALSE; // no filter selected; should never come here

	string strName;
	lbFilters.GetText(n, strName);

	/// EJP 07-22-2003 v7.0631 CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
	/*
	ComboBox cbFolder = OSelFilterDlg.GetItem(IDC_SELFILTER_FOLDER);
	n = cbFolder.GetCurSel();
	
	if( SF_FOLDER_ALL == n )
	{
		// When display filters in all folders we need to determine
		// what folder the slected filter is from.  We do this by
		// extracting the prefix.
		
		n = strName.ReverseFind(':');
		if( -1 != n )
		{
			string strPrefix = strName.Left(n);
			strName.Delete(0, n + 2); // +2=colon and space
			string strLocPrefix(FILTER_LOCATION_PREFIX);
			n = strLocPrefix.FindToken(strPrefix, '|');
		}
	}
	
	string strFolder;
	switch( n )
	{
	case SF_FOLDER_DATAFILE:
		strFolder = GetFilePath(s_lpcszDataFile);
		break;
	case SF_FOLDER_ORIGIN:
		strFolder.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);;
		break;
	case SF_FOLDER_USERFILES:
		strFolder.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);;
		break;
	}

	s_strFilterFile.Format("%s%s.oif", strFolder, strName);

	return TRUE;
	*/
	return fuGetFilterFileNameFromListItem(strName, s_strFilterFile, GetFilePath(s_lpcszDataFile));
	/// end CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
}

static BOOL OnSelChangeFolder(Control ctrl)
{
	ComboBox cbFolder(ctrl);
	UpdateFilterList(cbFolder.GetCurSel());
	return TRUE;
}

static BOOL OnSelChangeFilter(Control ctrl)
{
	UpdateButtons();
	return TRUE;
}

static void UpdateFilterList(int nFolder)
{
	ListBox lbFilters = OSelFilterDlg.GetItem(IDC_SELFILTER_LIST);
	lbFilters.ResetContent();

	switch( nFolder )
	{
	case SF_FOLDER_DATAFILE:
		AddFiltersToListBox(s_saDataFolderFilters);
		break;
	case SF_FOLDER_ORIGIN:
		AddFiltersToListBox(s_saOriginFilters);
		break;
	case SF_FOLDER_USERFILES:
		AddFiltersToListBox(s_saUserFilesFilters);
		break;
	case SF_FOLDER_ALL:
		/// EJP 07-22-2003 v7.0631 CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
		///AddFiltersToListBox(s_saDataFolderFilters, SF_FOLDER_DATAFILE);
		///AddFiltersToListBox(s_saUserFilesFilters, SF_FOLDER_USERFILES);
		///AddFiltersToListBox(s_saOriginFilters, SF_FOLDER_ORIGIN);
		AddFiltersToListBox(s_saDataFolderFilters);
		AddFiltersToListBox(s_saUserFilesFilters);
		AddFiltersToListBox(s_saOriginFilters);
		/// end CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
		break;
	}
	UpdateButtons();
}

static void UpdateButtons()
{
	ListBox lbFilters = OSelFilterDlg.GetItem(IDC_SELFILTER_LIST);
	Button btnOK = OSelFilterDlg.GetItem(IDOK);
	btnOK.Enable = (lbFilters.GetCurSel() != -1);
}

/// EJP 07-22-2003 v7.0631 CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
/*
static void AddFiltersToListBox(StringArray &saFilters, int nType=SF_FOLDER_UNKNOWN)
{
	ListBox lbFilters = OSelFilterDlg.GetItem(IDC_SELFILTER_LIST);

	string strList, strName;
	string strLocPrefix(FILTER_LOCATION_PREFIX);
	
	for( int n = 0; n < saFilters.GetSize(); n++ )
	{
		strName = GetFileName(saFilters[n], TRUE); // true=remove file extension
		if( SF_FOLDER_DATAFILE <= nType && nType <= SF_FOLDER_USERFILES )
			strList.Format("%s: %s", strLocPrefix.GetToken(nType, '|'), strName);
		else
			strList = strName;
		lbFilters.AddString(strList);
	}
}
*/
static void AddFiltersToListBox(StringArray &saFilters)
{
	ListBox lbFilters = OSelFilterDlg.GetItem(IDC_SELFILTER_LIST);
	StringArray saFilterList;
	fuGetFilterList(saFilterList, saFilters);
	for( int i = 0; i < saFilterList.GetSize(); i++ )
		lbFilters.AddString(saFilterList[i]);
}
/// end CLEAN_SELFILTER_DLG_TO_USE_NEW_FILTER_UTILS_FUNCS
