/*------------------------------------------------------------------------------*
 * File Name: OGLSettings.h														*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS			*
 * Tony 09/03/2012 ORG-6501-P2 ADD_OGS_SAVE_AND_LOAD							*
 * Tony 09/03/2012 ORG-6501-S4 NO_TABS_IN_DIALOG								*
 * Tony 09/03/2012 ORG-6501-P1 CHANGE_TRANSPARENCY_CHECKBOX_TO_DROPDOWNLIST	*
 * Tony 09/17/2012 ORG-6501-S1 HIDE_DRIVE_VERSION								*
 * Tony 09/20/2012 ORG-6858-S7 SUPPORT_AA_WHEN_OGLFA_CHANGE					*
 * Tony 09/21/2012 ORG-6501-S7 MAKE_GUI_MORE_USER_FRIENDLY						*
 * Tony 09/24/2012 ORG-6501-S8 UPDATE_GRAPH_WHEN_OGL_SETTING_CHANGED			*
 * Kyle 09/28/2012 ORG-1433-S1 SHARE_O3D_ENUM_TO_OC_AND_SDK						*
 * Tony 10/10/2012 ORG-6501-S9 USE_MORE_SUITABLE_HINT_FOR_OPENGL_TOGGLE			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include "GridControl.h"
#include "OGLSettings.h"
#include <O3DGLConst.h>		///Kyle 09/28/2012 ORG-1433-S1 SHARE_O3D_ENUM_TO_OC_AND_SDK


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void OGLVarList::Init(int nID, WndContainer& dlg, WndContainer* pParentDlg/* = NULL*/)
{
	GridListControl::Init(nID, dlg, pParentDlg);
	
	SetColHeader(STR_OGL_VAR_LIST_HEADER);
	
	addVariables();
}

void OGLVarList::addVariables()
{	
	vector<string> vsTable;		
		
	int nRows = 0;
	nRows += getOneVariableInfo(vsTable, "@OGL", _L("Enable OpenGL"));			
	nRows += getOneVariableInfo(vsTable, "@OGLT", _L("Transparency"));		
	nRows += getOneVariableInfo(vsTable, "@OGLFA", _L("Full Screen Anti-aliasing"));		
	nRows += getOneVariableInfo(vsTable, "@OGLFAE", _L("Full Screen Anti-aliasing for Exporting and Printing"));	
	nRows += getOneVariableInfo(vsTable, "@OGLSC", _L("Slice Drawing for Copy Page"));			
	nRows += getOneVariableInfo(vsTable, "@OGLSE", _L("Slice Drawing for emf Export"));		
	nRows += getOneVariableInfo(vsTable, "@OGLSP", _L("Slice Drawing for Print"));		
	nRows += getOneVariableInfo(vsTable, "@OGLSS", _L("Copy Page Using Smart Slice Size"));
	
	SetRows(nRows);
	SetTableValue(vsTable, true);
}

string OGLVarList::getVaraibleValue(LPCSTR lpcszVarName)
{
	double dVal = NANUM;
	bool bRet = LT_get_var(lpcszVarName, &dVal);
	ASSERT( bRet );
	
	if( bRet )
		return ftoa(dVal);	
	else
		return "";
}

int OGLVarList::getOneVariableInfo(vector<string>& vsTable, LPCSTR lpcszVarName, LPCSTR lpcszVarComments)
{
	vsTable.Add( lpcszVarName );
	vsTable.Add( getVaraibleValue(lpcszVarName) );
	vsTable.Add( lpcszVarComments );
	return 1;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
BOOL OGLVarSubDlg::Create( HWND hWndParent/* = NULL */)
{
	InitMsgMap();
	bool bRet = Dialog::Create(hWndParent);
	if( bRet )
	{
		m_VarList.Init(IDC_GRID_FRAME, *this);
	}
	return bRet;	
}

bool OGLVarSubDlg::OnDlgResize(int nType, int cx, int cy)
{
	const int nGap = 4;	
	
	RECT rrList;		
	rrList.left = nGap;
	rrList.right = cx - nGap;
	rrList.top = nGap;
	rrList.bottom = cy - nGap;
	
	Control ctrlList = GetItem(IDC_GRID_FRAME);	
	ctrlList.MoveWindow(&rrList);
	
	return true;
}
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
int	OGLSettingsDlg::DoModalEx(HWND hWndParent/* = NULL*/)
{
	InitMsgMap();
	return ResizeDialog::DoModal(hWndParent);		
}

bool OGLSettingsDlg::OnInitDialog()
{
	m_tab = GetItem(IDC_TAB);			
	
	m_InfoDlg.Create(m_tab.GetSafeHwnd());	
	m_tab.AddTab(m_InfoDlg.GetSafeHwnd(), _L("OpenGL Info"));	
	
	m_VarDlg.Create(m_tab.GetSafeHwnd());	
	m_tab.AddTab(m_VarDlg.GetSafeHwnd(), _L("Settings"));
	
	return true;
}


void OpenOGLSettingsDlg()
{	
	OGLSettingsDlg mydlg;
	mydlg.DoModalEx(GetWindow());
}



/////////////////////////////////////////////////////////////////////////////
//////////////////////////GETN Dialog////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
///------ Tony 09/03/2012 ORG-6501-P2 ADD_OGS_SAVE_AND_LOAD
#define STR_MAIN_SECTION				"Main"
#define STR_SYS_VAR_OGS		"SystemVariables.ogs"
///------ End ADD_OGS_SAVE_AND_LOAD

///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
enum
{
	NO_ANTI_ALIASING = 0,
	MULTI_SAMPLES_ANTI_ALISING = 1,
	FAST_APPROXIMATE_ANTI_ALIASING = 2,
};
///------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS

static string _get_OGL_var_label_and_value(LPCSTR lpcszVarName, double& dVal)
{
	string strVarLabel;
	if( LT_get_var(lpcszVarName, &dVal) )
	{
		if( 0 == strcmp(lpcszVarName, "@OGLT") )
		{
			strVarLabel = _L("Enable Transparency");
		}
		else if( 0 == strcmp(lpcszVarName, "@OGLDL") )
		{
			strVarLabel = _L("Enable Display List");
		}
		else if( 0 == strcmp(lpcszVarName, "@OGLFA") )
		{
			strVarLabel = _L("Enable Anti-aliasing");
		}
		else if( 0 == strcmp(lpcszVarName, "@OGLFAE") )
		{
			strVarLabel = _L("Enable Anti-aliasing for Export/Print");
		}
	}
	
	//strVarLabel += " (" + (string)lpcszVarName + ")";	///------ Tony 09/21/2012 ORG-6501-S7 MAKE_GUI_MORE_USER_FRIENDLY
	return strVarLabel;
}

static bool _checkbox_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
	///------ Tony 09/20/2012 ORG-6858-S7 SUPPORT_AA_WHEN_OGLFA_CHANGE
	//myTree.Settings.OGLFAHit.Show = (myTree.Settings.OGLFA.nVal == MULTI_SAMPLES_ANTI_ALISING);
	///------ End SUPPORT_AA_WHEN_OGLFA_CHANGE
	myTree.Settings.OGLFAFastHit.Show = (myTree.Settings.OGLFA.nVal == FAST_APPROXIMATE_ANTI_ALIASING);
	myTree.Settings.OGLFAEFastHit.Show = (myTree.Settings.OGLFAE.nVal == FAST_APPROXIMATE_ANTI_ALIASING);
	///------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
	if( trNode && !(dwCntrl & GETNEVENT_ON_INIT) )
	{	
		return trNode.SetAttribute(STR_CHANGED_ATTRIB, 1);
	}
	return false;
}

static void _add_var_settings(TreeNode& trSettings, LPCSTR lpcszVarName, LPCSTR lpcszCombo = NULL, LPCSTR lpcszIntMap = NULL)
{
	double dVal;
	string strLabel = _get_OGL_var_label_and_value(lpcszVarName, dVal);
	///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
	//int nType = NULL != lpcszCombo ? TRGP_NUMERIC_LIST : TRGP_CHECK;
	int nType = NULL != lpcszCombo ? TRGP_ENUM_LIST : TRGP_CHECK;
	///------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
	
	string strtagName(lpcszVarName);
	strtagName.TrimLeft('@');
	TreeNode trN = trSettings.AddNumericNode((int)dVal, strtagName, nType);
	trN.SetAttribute(STR_LABEL_ATTRIB, strLabel);	
	trN.SetAttribute(STR_ATTRIB_HANDLER_RC, (ODWP)(PEVENT_NODE_FUNC)_checkbox_event);
	///------ Tony 09/03/2012 ORG-6501-P1 CHANGE_TRANSPARENCY_CHECKBOX_TO_DROPDOWNLIST
	if ( NULL != lpcszIntMap )
		trN.SetAttribute(STR_INTMAP_ATTRIB, lpcszIntMap);
	///------ End CHANGE_TRANSPARENCY_CHECKBOX_TO_DROPDOWNLIST
	if( NULL != lpcszCombo )
		trN.SetAttribute(STR_COMBO_ATTRIB, lpcszCombo);
}

static string _get_OGL_str_var(LPCSTR lpcszLTVarName)
{
	char szBuffer[255];
	if( LT_get_str(lpcszLTVarName, szBuffer, 255) )
	{
		return (string)szBuffer;
	}
	ASSERT(false);
	return ""; // not ready
}

//hide ram
//static string _get_OGL_byte_var(LPCSTR lpcszLTVarName)
//{
	//double dVal;
	//if( LT_get_var(lpcszLTVarName, &dVal) )
	//{
		//return (string) nint(dVal/pow(2,20)) + "MB";
	//}
	//ASSERT(false);
	//return ""; // not ready
//}

///------ Tony 09/21/2012 ORG-6501-S7 MAKE_GUI_MORE_USER_FRIENDLY
static string _get_OGL_toggle_hint()
{
	double dVal;
	LT_get_var("@OGL", &dVal);
	
	string strToggleHint;
	///------ Tony 10/10/2012 ORG-6501-S9 USE_MORE_SUITABLE_HINT_FOR_OPENGL_TOGGLE
	//string strOGLStatus;
	//int nVal;
	//if(dVal == 0)
	//{
		//strOGLStatus = _L("disabled");
		//nVal = 1;
	//}
	//else
	//{
		//strOGLStatus = _L("enabled");
		//nVal = 0;
	//}
	//strToggleHint.Format(_L("OpenGL is currently") + " %s " + _L("on creating 3D graphs. Toggle it by setting @ogl to") + " %d", strOGLStatus, nVal);
	if(dVal == 0)
	{
		strToggleHint = _L("OpenGL is currently disabled for creating 3D graphs. To enable OpenGL, set @ogl to 1");
	}
	else
	{
		strToggleHint = _L("OpenGL is currently enabled for creating 3D graphs. To disable OpenGL, set @ogl to 0");
	}
	///------ End USE_MORE_SUITABLE_HINT_FOR_OPENGL_TOGGLE
	return strToggleHint;
}
///------ End MAKE_GUI_MORE_USER_FRIENDLY

///------ Tony 09/20/2012 ORG-6858-S7 SUPPORT_AA_WHEN_OGLFA_CHANGE
static void _support_graph(Tree &tr, Tree &trTmp)
{
	if(tr.Settings.OGLFA.nVal != trTmp.Settings.OGLFA.nVal)
		LT_execute("doc -ugla");
	///------ Tony 09/24/2012 ORG-6501-S8 UPDATE_GRAPH_WHEN_OGL_SETTING_CHANGED
	else
		if(tr.Settings.OGLT.nVal != trTmp.Settings.OGLT.nVal || tr.Settings.OGLDL.nVal != trTmp.Settings.OGLDL.nVal)
			LT_execute("doc -u");
	///------ End UPDATE_GRAPH_WHEN_OGL_SETTING_CHANGED
}
///------ End SUPPORT_AA_WHEN_OGLFA_CHANGE

///------ Tony 09/03/2012 ORG-6501-P2 ADD_OGS_SAVE_AND_LOAD
static int _save_OGL_settings_to_ogs(Tree &tr, bool bExecute = false)
{
	vector<string>	vsVarNames;
	vector<string>	vsVarVals;
	vector<string>	vsComment;
	
	foreach(TreeNode trVar in tr.Settings.Children)
	{
		if( trVar.ID == TRGP_ENUM_LIST || trVar.ID == TRGP_CHECK )
		{		
			vsVarNames.Add("@" + trVar.tagName);
			vsVarVals.Add(trVar.nVal);
			vsComment.Add(";//");
		}
	}
	
	int nRet = okutil_write_file_section_keys(GetAppPath() + STR_SYS_VAR_OGS, STR_MAIN_SECTION, &vsVarNames, &vsVarVals, &vsComment);
	
	if(bExecute && nRet >= 0)
	{
		string strLT;
		strLT.Format("run.section(%s, main);", STR_SYS_VAR_OGS);
		LT_execute(strLT);
	}
	
	return nRet;
}

static void  _set_ogs_start_up()
{
	string	strKey("sysvar");
	INIFile	iniFile("Origin.ini");
	string 	strValue = iniFile.ReadString(STR_ORIGIN_STARTUP_SECTION, strKey);
	if(strValue.CompareNoCase(STR_SYS_VAR_OGS) != 0)
	{
		iniFile.WriteString(STR_ORIGIN_STARTUP_SECTION, strKey, STR_SYS_VAR_OGS);
	}
}
//int LoadOGLSettingsFromOgs(Tree &tr)
//{
	//vector<string>	vsVarNames;
	//vector<string>	vsVarVals;
	//int nRet = okutil_read_file_section_keys(GetAppPath() + STR_OGLSETTINGS_OGS, STR_MAIN_SECTION, &vsVarNames, &vsVarVals);	
	//
	//for(int ii = 0; ii < vsVarNames.GetSize(); ii++)
	//{
		//tr.Settings.SetValue(vsVarVals[ii], vsVarNames[ii]);
	//}
	//return nRet;
//}
///------ End ADD_OGS_SAVE_AND_LOAD

void OpenOGLSettingsGetNDlg()
{
	GETN_TREE(tr)
	//GETN_FIRST_SUBNODES_AS_TABS(tr) // display with tab control		///------ Tony 09/03/2012 ORG-6501-S4 NO_TABS_IN_DIALOG
	tr.SetAttribute(STR_HELPID_ATTRIB, IDD_OGL_SETTINGS_DLG);
	
	GETN_BEGIN_BRANCH(Info, _L("OpenGL Info")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		GETN_STR(Vendor, _L("Vendor:"), _get_OGL_str_var("System.OpenGL.Vendor$")) GETN_READ_ONLY_COLOR
		GETN_STR(Device, _L("Device:"), _get_OGL_str_var("System.OpenGL.Device$")) GETN_READ_ONLY_COLOR
		GETN_STR(Version, _L("Version:"), _get_OGL_str_var("System.OpenGL.Version$")) GETN_READ_ONLY_COLOR
		//GETN_STR(DriverVersion, _L("Driver Version:"), _get_OGL_str_var("System.OpenGL.DriverVersion$")) GETN_READ_ONLY_COLOR	//version has show it		///------ Tony 09/17/2012 ORG-6501-S1 HIDE_DRIVE_VERSION
		//GETN_STR(Adapter, _L("Adapter RAM:"), _get_OGL_byte_var("System.OpenGL.AdapterRAM")) GETN_READ_ONLY_COLOR		//hide ram
	GETN_END_BRANCH(Info)
	
	#define COMBO_ANTI_ALIASING _L("No Anti-Aliasing|Multi-Samples Anti-Aliasing|Fast Approximate Anti-Aliasing")
	GETN_BEGIN_BRANCH(Settings, _L("Settings")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		///------ Tony 09/03/2012 ORG-6501-P1 CHANGE_TRANSPARENCY_CHECKBOX_TO_DROPDOWNLIST
		//_add_var_settings(tr.Settings, "@OGLT");	
		///Kyle 09/28/2012 ORG-1433-S1 SHARE_O3D_ENUM_TO_OC_AND_SDK
		//_add_var_settings(tr.Settings, "@OGLT", "disable|enable", "-1|0");	
		string strMapOGLT = (string)OITA_OFF + "|" + (string)OITA_DUAL_DEPTH_PEELING;
		_add_var_settings(tr.Settings, "@OGLT", _L("Disable|Enable"), strMapOGLT);
		///End SHARE_O3D_ENUM_TO_OC_AND_SDK
		///------ End CHANGE_TRANSPARENCY_CHECKBOX_TO_DROPDOWNLIST
		///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
		//_add_var_settings(tr.Settings, "@OGLFA", "0|1|2");
		//_add_var_settings(tr.Settings, "@OGLFAE", "0|1|2");	
		_add_var_settings(tr.Settings, "@OGLFA", COMBO_ANTI_ALIASING);
		///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
		///------ Tony 09/20/2012 ORG-6858-S7 SUPPORT_AA_WHEN_OGLFA_CHANGE
		//GETN_STR(OGLFAHit, _L("It only applies to newly created window"), "") GETN_HINT
		///------ End SUPPORT_AA_WHEN_OGLFA_CHANGE
		GETN_STR(OGLFAFastHit, _L("Try using it if opengl version is higher than 4"), "") GETN_HINT
		///------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
		_add_var_settings(tr.Settings, "@OGLFAE", COMBO_ANTI_ALIASING);
		///------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
		GETN_STR(OGLFAEFastHit, _L("Try using it if opengl version is higher than 4"), "") GETN_HINT		///------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
		_add_var_settings(tr.Settings, "@OGLDL");	
		GETN_STR(OGLDLHit, _L("Some video cards do not support display list drawing. Try disabling if plot disappears after transparency is on"), "") GETN_HINT
	GETN_END_BRANCH(Settings)

	GETN_STR(OGLToggle, _get_OGL_toggle_hint(), "") GETN_HINT		///------ Tony 09/21/2012 ORG-6501-S7 MAKE_GUI_MORE_USER_FRIENDLY
	
	//LoadOGLSettingsFromOgs(tr);		///------ Tony 09/03/2012 ORG-6501-P2 ADD_OGS_SAVE_AND_LOAD
	
	if( GetNBox(tr, _L("3D OpenGL Settings")) )
	{		
		//octree_delete_nodes_by_missing_attribute(&tr, STR_CHANGED_ATTRIB, true, true, false); // to delete nodes that not changed
		
		//if( tr.Settings && tr.Settings.GetNodeCount() > 0 ) // to apply
		{
			///------ Tony 09/03/2012 ORG-6501-P2 ADD_OGS_SAVE_AND_LOAD
			//foreach(TreeNode trVar in tr.Settings.Children)
			//{
				/////------ Tony 08/31/2012 ORG-6501-S2 ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
				////if( trVar.ID == TRGP_NUMERIC_LIST || trVar.ID == TRGP_CHECK )
				//if( trVar.ID == TRGP_ENUM_LIST || trVar.ID == TRGP_CHECK )
				/////------ End ADD_BETTER_HINT_FOR_OPENGL_SETTINGS
				//{
					//string strVarName = "@" + trVar.tagName;				
					//double dVal = trVar.nVal;
					//LT_set_var(strVarName, dVal);
				//}
			//}
			_support_graph(tr, _tmpNode);		///------ Tony 09/20/2012 ORG-6858-S7 SUPPORT_AA_WHEN_OGLFA_CHANGE
			_save_OGL_settings_to_ogs(tr, true);
			_set_ogs_start_up();
			///------ End ADD_OGS_SAVE_AND_LOAD
		}			
	}
}

int OGLSettings(int nMsg, ODWP dwCntrl = 0, LPVOID lpData = NULL)
{
	/// just simple open dialog for now, later may have other messages
	OpenOGLSettingsGetNDlg();
	return 0;
}
