/*------------------------------------------------------------------------------*
 * File Name: OCHelpID.h														*
 * Creation: AW 09/15/2006														*
 * Purpose: Origin C generate HELP ID header file for making CHM file			*
 * Copyright (c) OriginLab Corp.	2006, 2007, 2008							*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * 																				*
 ********************************************************************************/
 
 
#ifndef _OC_HELP_ID_
#define _OC_HELP_ID_


#define HELP_ID_HEADER 	"/// This is HELP ID header file used to make %s CHM, don't modify this file!!!!\n"
#define HELP_ID_LINE	"#define %s %d"

class HelpIDFile : public stdioFile
{
public:
	HelpIDFile(LPCSTR lpcszFileName, int nHelpIDStart)
	{
		string strTemp(GetOriginPath() + lpcszFileName);
		strTemp += ".h";
		BOOL bOK = Open(strTemp, file::typeText | file::modeWrite | file::modeCreate );		
		if ( bOK)
		{
			strTemp.Format(HELP_ID_HEADER, lpcszFileName);
			WriteString(strTemp);
			m_nHelpIDStart = nHelpIDStart;
		}
		else
		{
			out_str("Fail to open" + strTemp );
			m_nHelpIDStart = -9999;    /// used to check error
		}
	}
	~HelpIDFile()
	{
		if (IsOpen())
			Close();
	}
public:
	int AddHelpID(LPCSTR lpcszHelpID, int nHelpID)
	{
		if ( IsOpen() )
		{
			string strLine;
			strLine.Format(HELP_ID_LINE, lpcszHelpID, m_nHelpIDStart + nHelpID);
			return WriteString(strLine);
		}
		return -1;
	}
protected:
	int m_nHelpIDStart;
};

#endif // _OC_HELP_ID_
 
 
 
 
 
 
 
